#!/usr/bin/perl

package eBay::API::XML::DataType::CartItemType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CartItemType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CartItemType

=head1 DESCRIPTION

Details about an item in a cart.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CartItemType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemType;
use eBay::API::XML::DataType::Enum::ModifyActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:ModifyActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ModifyActionCodeType', '' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
	, [ 'ReferenceID', 'xs:long', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

What is to be done with the item. If the action is Delete or Update,
ReferenceID must be provided. (It was returned with the item
when the item was initially added to the cart.)
This is only required if the parent container is submitted.

#    Argument: 'ns:ModifyActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:ModifyActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setItem()

When used as input, this is the item to be added, removed or updated in the cart.
Only ItemID and Quantity apply.
This is only required as input if the parent container is submitted.
When returned, this is one of the items remaining in the cart.

#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}


=head2 setReferenceID()

An ID created by eBay and returned along with an item, if items are returned.
This ID must be provided on input to SetCart along with the corresponding item
when doing a Delete or Update related to that item.

#    Argument: 'xs:long'

=cut

sub setReferenceID {
  my $self = shift;
  $self->{'ReferenceID'} = shift
}

=head2 getReferenceID()

#    Returns: 'xs:long'

=cut

sub getReferenceID {
  my $self = shift;
  return $self->{'ReferenceID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
