#!/usr/bin/perl -w
use strict;
use Test::More;
if ($ENV{DEVELOPER}) { 
  Test::More->import(tests => 6457); 
  # qw(no_plan); 
}
else { 
  plan skip_all => 'Developer test'; 
}

use_ok qw(Parse::Eyapp) or exit;
use Data::Dumper;

  my ($grammar, $parser);
  $grammar=join('',<DATA>);

  diag("The next tests take long ... Be patient");
  $parser=Parse::Eyapp->new(input => $grammar, inputfile => 'DATA', firstline => 34);

  ok(!$@, "Grammar module created");

  is(keys(%{$parser->{GRAMMAR}{NULLABLE}}), 43, "C++ parser 43 nullable productions");

  is(keys(%{$parser->{GRAMMAR}{NTERM}}), 233, "C++ parser 233 syntactic variables");

  is(scalar(@{$parser->{GRAMMAR}{UUTERM}}), 3, "C++ parser 3 UUTERM");

  is(scalar(keys(%{$parser->{GRAMMAR}{TERM}})), 108, "C++ parser 108 terminals");

  is(scalar(@{$parser->{GRAMMAR}{RULES}}), 825, "C++ parser 825 rules");

  is(scalar(@{$parser->{STATES}}), 1611, "C++ parser 1611 states");

  is(scalar(keys(%{$parser->{CONFLICTS}{SOLVED}})), 115, "C++ parser 115 solved conflicts");

  is( $parser->{CONFLICTS}{FORCED}{TOTAL}[0], 30, "C++ parser 30 forced conflicts");

  is($parser->{CONFLICTS}{FORCED}{TOTAL}[1], 42, "C++ parser 42 other forced conflicts");

  my $expected_parser = bless( { 
                 'STATES' => [
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'program' => '4',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'using_directive' => '11',
                                              'fndef' => '12',
                                              'extdefs' => '43',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '14',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'nested_name_specifier' => '57',
                                              'fn_dot_def1' => '56',
                                              'asm_keyword' => '55',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '20',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'namespace_alias' => '63',
                                              'explicit_instantiation' => '62',
                                              'notype_unqualified_id' => '64',
                                              'using_decl' => '25',
                                              'global_scope' => '26',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '67',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'extdef' => '30',
                                              'extension' => '70',
                                              'template_id' => '32',
                                              'datadef' => '71',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'lang_extdef' => '77',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'ACTIONS' => {
                                                ' ' => -1,
                                                'TEMPLATE' => '23',
                                                'ENUM' => '60',
                                                'NAMESPACE' => '2',
                                                '\';\'' => '61',
                                                '\'~\'' => '39',
                                                'USING' => '40',
                                                'SELFNAME' => '41',
                                                'ASM_KEYWORD' => '65',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '28',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '76',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               0,
                                               0
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -377
                                              },
                                 'CORE' => [
                                             [
                                               377,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'identifier' => '88'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '85',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '90',
                                                '\'{\'' => '86',
                                                'PTYPENAME' => '84',
                                                'SELFNAME' => '87'
                                              },
                                 'CORE' => [
                                             [
                                               19,
                                               1
                                             ],
                                             [
                                               20,
                                               1
                                             ],
                                             [
                                               25,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '93',
                                              'self_template_type' => '78',
                                              'global_scope' => '99',
                                              'identifier_defn' => '100',
                                              'attribute' => '7',
                                              'apparent_template_type' => '104',
                                              'identifier' => '106',
                                              'nested_name_specifier' => '107',
                                              'attributes' => '98'
                                            },
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '101',
                                                'IDENTIFIER' => '89',
                                                'TYPENAME_DEFN' => '91',
                                                'NSNAME' => '108',
                                                '\'{\'' => '102',
                                                'SCSPEC' => '109',
                                                'SELFNAME' => '105',
                                                'AGGR' => '103',
                                                'TYPESPEC' => '94',
                                                'IDENTIFIER_DEFN' => '95',
                                                'CV_QUALIFIER' => '92',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '96',
                                                'PTYPENAME_DEFN' => '97',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               458,
                                               1
                                             ],
                                             [
                                               459,
                                               1
                                             ],
                                             [
                                               460,
                                               1
                                             ],
                                             [
                                               461,
                                               1
                                             ],
                                             [
                                               462,
                                               1
                                             ],
                                             [
                                               463,
                                               1
                                             ],
                                             [
                                               464,
                                               1
                                             ],
                                             [
                                               467,
                                               1
                                             ],
                                             [
                                               468,
                                               1
                                             ],
                                             [
                                               469,
                                               1
                                             ],
                                             [
                                               470,
                                               1
                                             ],
                                             [
                                               471,
                                               1
                                             ],
                                             [
                                               475,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0
                                           ],
                                 'ACTIONS' => {
                                                ' ' => '110'
                                              },
                                 'CORE' => [
                                             [
                                               0,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -477
                                              },
                                 'CORE' => [
                                             [
                                               477,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'typename_sub2' => '115',
                                              'typename_sub1' => '121',
                                              'template_type' => '112',
                                              'typename_sub' => '111',
                                              'self_template_type' => '78',
                                              'typename_sub0' => '117',
                                              'global_scope' => '114'
                                            },
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '116',
                                                'IDENTIFIER' => '119',
                                                'NSNAME' => '120',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '113',
                                                'SELFNAME' => '118'
                                              },
                                 'CORE' => [
                                             [
                                               450,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             3,
                                             9,
                                             43,
                                             45,
                                             52,
                                             53,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             141,
                                             143,
                                             145,
                                             147,
                                             148,
                                             197,
                                             216,
                                             218,
                                             223,
                                             228,
                                             233,
                                             237,
                                             240,
                                             259,
                                             267,
                                             272,
                                             278,
                                             282,
                                             286,
                                             295,
                                             301,
                                             302,
                                             364,
                                             394,
                                             395,
                                             401,
                                             403,
                                             414,
                                             424,
                                             429,
                                             430,
                                             434,
                                             451,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             504,
                                             526,
                                             528,
                                             541,
                                             545,
                                             546,
                                             549,
                                             552,
                                             554,
                                             556,
                                             565,
                                             569,
                                             570,
                                             571,
                                             582,
                                             590,
                                             594,
                                             602,
                                             618,
                                             622,
                                             631,
                                             636,
                                             640,
                                             641,
                                             694,
                                             696,
                                             700,
                                             708,
                                             722,
                                             723,
                                             726,
                                             744,
                                             747,
                                             748,
                                             751,
                                             752,
                                             764,
                                             766,
                                             780,
                                             788,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             871,
                                             873,
                                             879,
                                             887,
                                             893,
                                             898,
                                             906,
                                             908,
                                             952,
                                             957,
                                             962,
                                             965,
                                             1009,
                                             1014,
                                             1019,
                                             1020,
                                             1021,
                                             1027,
                                             1035,
                                             1037,
                                             1038,
                                             1042,
                                             1044,
                                             1045,
                                             1073,
                                             1120,
                                             1121,
                                             1122,
                                             1181,
                                             1199,
                                             1201,
                                             1208,
                                             1212,
                                             1213,
                                             1216,
                                             1217,
                                             1218,
                                             1241,
                                             1250,
                                             1260,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1279,
                                             1280,
                                             1283,
                                             1318,
                                             1320,
                                             1321,
                                             1363,
                                             1367,
                                             1375,
                                             1379,
                                             1388,
                                             1390,
                                             1412,
                                             1415,
                                             1416,
                                             1423,
                                             1424,
                                             1426,
                                             1446,
                                             1468,
                                             1487,
                                             1488,
                                             1489,
                                             1510,
                                             1511,
                                             1515,
                                             1517,
                                             1518,
                                             1549,
                                             1569,
                                             1571,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => -405
                                              },
                                 'CORE' => [
                                             [
                                               405,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '124',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'type_name' => '13',
                                              'named_class_head_sans_basetype' => '49',
                                              'nonnested_type' => '34',
                                              'template_type' => '16',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'class_head' => '18',
                                              'complete_type_name' => '38',
                                              'typespec' => '125',
                                              'nested_name_specifier' => '126',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'nested_type' => '22'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             141,
                                             143,
                                             145,
                                             148,
                                             216,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             476,
                                             565,
                                             696,
                                             952,
                                             1009,
                                             1181,
                                             1201,
                                             1208,
                                             1212,
                                             1363,
                                             1367,
                                             1375,
                                             1388,
                                             1390,
                                             1468,
                                             1549,
                                             1569,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => '-365',
                                                'ENUM' => '60',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '122',
                                                'SCOPE' => '42',
                                                'TYPENAME' => '31',
                                                'TYPEOF' => '15',
                                                'NSNAME' => '127',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PTYPENAME' => '123'
                                              },
                                 'CORE' => [
                                             [
                                               365,
                                               1
                                             ],
                                             [
                                               372,
                                               1
                                             ],
                                             [
                                               374,
                                               1
                                             ],
                                             [
                                               550,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '135',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '128',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '130',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             216,
                                             218,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             403,
                                             429,
                                             476,
                                             484,
                                             494,
                                             498,
                                             565,
                                             696,
                                             780,
                                             1009,
                                             1026,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '73',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               579,
                                               1
                                             ],
                                             [
                                               581,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             27,
                                             43,
                                             45,
                                             70,
                                             73,
                                             86,
                                             141,
                                             143,
                                             145,
                                             147,
                                             148,
                                             216,
                                             223,
                                             233,
                                             267,
                                             278,
                                             301,
                                             302,
                                             359,
                                             394,
                                             395,
                                             401,
                                             476,
                                             526,
                                             528,
                                             549,
                                             554,
                                             565,
                                             582,
                                             590,
                                             594,
                                             613,
                                             615,
                                             620,
                                             624,
                                             645,
                                             696,
                                             700,
                                             726,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             764,
                                             766,
                                             780,
                                             859,
                                             863,
                                             894,
                                             898,
                                             1009,
                                             1038,
                                             1042,
                                             1044,
                                             1078,
                                             1163,
                                             1216,
                                             1217,
                                             1218,
                                             1262,
                                             1264,
                                             1265,
                                             1318,
                                             1321,
                                             1435,
                                             1446,
                                             1515,
                                             1517,
                                             1518
                                           ],
                                 'ACTIONS' => {
                                                '' => -549
                                              },
                                 'CORE' => [
                                             [
                                               549,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -23
                                              },
                                 'CORE' => [
                                             [
                                               23,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'eat_saved_input' => '138'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => '-82',
                                                'END_OF_SAVED_INPUT' => '137'
                                              },
                                 'CORE' => [
                                             [
                                               12,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             506,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             756,
                                             764,
                                             766,
                                             780,
                                             827,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1056,
                                             1076,
                                             1078,
                                             1085,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1277,
                                             1297,
                                             1298,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -571
                                              },
                                 'CORE' => [
                                             [
                                               571,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -14
                                              },
                                 'CORE' => [
                                             [
                                               14,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '139'
                                              },
                                 'CORE' => [
                                             [
                                               380,
                                               1
                                             ],
                                             [
                                               381,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             26,
                                             27,
                                             43,
                                             45,
                                             57,
                                             67,
                                             70,
                                             83,
                                             86,
                                             124,
                                             126,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             152,
                                             157,
                                             192,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             262,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             368,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             415,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             584,
                                             590,
                                             591,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             706,
                                             709,
                                             717,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             862,
                                             863,
                                             864,
                                             866,
                                             875,
                                             892,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1120,
                                             1121,
                                             1122,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1423,
                                             1424,
                                             1425,
                                             1426,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1549,
                                             1554,
                                             1564,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-608',
                                                'SCOPE' => '140'
                                              },
                                 'CORE' => [
                                             [
                                               608,
                                               1
                                             ],
                                             [
                                               615,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -378
                                              },
                                 'CORE' => [
                                             [
                                               378,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-452',
                                                '\'{\'' => '141'
                                              },
                                 'CORE' => [
                                             [
                                               451,
                                               1
                                             ],
                                             [
                                               452,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             139,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             199,
                                             200,
                                             201,
                                             214,
                                             216,
                                             218,
                                             222,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             303,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             364,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             494,
                                             498,
                                             517,
                                             519,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             567,
                                             595,
                                             602,
                                             603,
                                             614,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             706,
                                             709,
                                             717,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             780,
                                             788,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             957,
                                             958,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1182,
                                             1199,
                                             1206,
                                             1208,
                                             1211,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1374,
                                             1379,
                                             1380,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1554,
                                             1570,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-261',
                                                '\'<\'' => '142'
                                              },
                                 'CORE' => [
                                             [
                                               150,
                                               1
                                             ],
                                             [
                                               261,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'dot_hush_warning' => '145'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => '-7',
                                                '\'{\'' => '143',
                                                'EXTERN_LANG_STRING' => '144'
                                              },
                                 'CORE' => [
                                             [
                                               16,
                                               1
                                             ],
                                             [
                                               17,
                                               1
                                             ],
                                             [
                                               18,
                                               1
                                             ],
                                             [
                                               40,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'attribute' => '146'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             141,
                                             143,
                                             145,
                                             147,
                                             148,
                                             216,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             451,
                                             476,
                                             526,
                                             528,
                                             565,
                                             696,
                                             700,
                                             726,
                                             744,
                                             764,
                                             766,
                                             780,
                                             898,
                                             952,
                                             1009,
                                             1181,
                                             1201,
                                             1208,
                                             1212,
                                             1363,
                                             1367,
                                             1375,
                                             1388,
                                             1390,
                                             1446,
                                             1468,
                                             1549,
                                             1569,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => '-370',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               370,
                                               1
                                             ],
                                             [
                                               406,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -574
                                              },
                                 'CORE' => [
                                             [
                                               574,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'begin_explicit_instantiation' => '148'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => '-148',
                                                '\'<\'' => '147'
                                              },
                                 'CORE' => [
                                             [
                                               41,
                                               1
                                             ],
                                             [
                                               42,
                                               1
                                             ],
                                             [
                                               140,
                                               1
                                             ],
                                             [
                                               141,
                                               1
                                             ],
                                             [
                                               142,
                                               1
                                             ],
                                             [
                                               143,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             3,
                                             8,
                                             9,
                                             26,
                                             27,
                                             40,
                                             43,
                                             45,
                                             52,
                                             60,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             99,
                                             124,
                                             128,
                                             130,
                                             131,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             172,
                                             192,
                                             197,
                                             199,
                                             200,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             228,
                                             233,
                                             262,
                                             267,
                                             272,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             359,
                                             363,
                                             364,
                                             365,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             391,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             414,
                                             415,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             434,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             494,
                                             498,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             582,
                                             584,
                                             590,
                                             594,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             626,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             648,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             706,
                                             709,
                                             712,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             756,
                                             764,
                                             766,
                                             768,
                                             769,
                                             770,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             887,
                                             888,
                                             893,
                                             894,
                                             898,
                                             902,
                                             906,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             959,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1120,
                                             1121,
                                             1122,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1165,
                                             1167,
                                             1169,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1423,
                                             1424,
                                             1426,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1549,
                                             1554,
                                             1564,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -609
                                              },
                                 'CORE' => [
                                             [
                                               609,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '\';\'' => '149'
                                              },
                                 'CORE' => [
                                             [
                                               22,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'type_name' => '150',
                                              'nested_name_specifier' => '152',
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'nested_type' => '151'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             141,
                                             143,
                                             145,
                                             148,
                                             216,
                                             218,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             403,
                                             476,
                                             565,
                                             696,
                                             1009
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'NSNAME' => '127',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '41'
                                              },
                                 'CORE' => [
                                             [
                                               89,
                                               1
                                             ],
                                             [
                                               90,
                                               1
                                             ],
                                             [
                                               93,
                                               1
                                             ],
                                             [
                                               94,
                                               1
                                             ],
                                             [
                                               572,
                                               1
                                             ],
                                             [
                                               575,
                                               1
                                             ],
                                             [
                                               637,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '124',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '157',
                                              'type_name' => '13',
                                              'type_specifier_seq' => '172',
                                              'typed_typespecs' => '173',
                                              'named_class_head_sans_basetype' => '49',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'class_head' => '18',
                                              'complete_type_name' => '38',
                                              'typespec' => '176',
                                              'nested_name_specifier' => '126',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'nested_type' => '22'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             192,
                                             197,
                                             199,
                                             200,
                                             201,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             224,
                                             228,
                                             233,
                                             251,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             364,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             517,
                                             519,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             595,
                                             602,
                                             603,
                                             614,
                                             617,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             647,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             706,
                                             709,
                                             717,
                                             735,
                                             743,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '\'-\'' => '153',
                                                '\'<\'' => '155',
                                                'LSHIFT' => '154',
                                                '\'~\'' => '171',
                                                '\'%\'' => '156',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '158',
                                                '\'*\'' => '160',
                                                'CV_QUALIFIER' => '10',
                                                'POINTSAT' => '159',
                                                'SCOPE' => '42',
                                                '\'[\'' => '161',
                                                'TYPEOF' => '15',
                                                'LEFT_RIGHT' => '174',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'RSHIFT' => '175',
                                                'MINUSMINUS' => '162',
                                                '\'|\'' => '163',
                                                'ASSIGN' => '177',
                                                'PLUSPLUS' => '178',
                                                'MIN_MAX' => '164',
                                                'PTYPENAME' => '123',
                                                'ANDAND' => '179',
                                                '\'>\'' => '180',
                                                'POINTSAT_STAR' => '182',
                                                'NEW' => '181',
                                                'ENUM' => '60',
                                                '\'+\'' => '165',
                                                'ARITHCOMPARE' => '183',
                                                '\',\'' => '166',
                                                '\'^\'' => '184',
                                                'error' => '167',
                                                'EQCOMPARE' => '185',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '127',
                                                '\'?\'' => '168',
                                                'DELETE' => '169',
                                                '\'&\'' => '186',
                                                '\'/\'' => '187',
                                                '\'=\'' => '188',
                                                'AGGR' => '35',
                                                'OROR' => '170'
                                              },
                                 'CORE' => [
                                             [
                                               790,
                                               1
                                             ],
                                             [
                                               791,
                                               1
                                             ],
                                             [
                                               792,
                                               1
                                             ],
                                             [
                                               793,
                                               1
                                             ],
                                             [
                                               794,
                                               1
                                             ],
                                             [
                                               795,
                                               1
                                             ],
                                             [
                                               796,
                                               1
                                             ],
                                             [
                                               797,
                                               1
                                             ],
                                             [
                                               798,
                                               1
                                             ],
                                             [
                                               799,
                                               1
                                             ],
                                             [
                                               800,
                                               1
                                             ],
                                             [
                                               801,
                                               1
                                             ],
                                             [
                                               802,
                                               1
                                             ],
                                             [
                                               803,
                                               1
                                             ],
                                             [
                                               804,
                                               1
                                             ],
                                             [
                                               805,
                                               1
                                             ],
                                             [
                                               806,
                                               1
                                             ],
                                             [
                                               807,
                                               1
                                             ],
                                             [
                                               808,
                                               1
                                             ],
                                             [
                                               809,
                                               1
                                             ],
                                             [
                                               810,
                                               1
                                             ],
                                             [
                                               811,
                                               1
                                             ],
                                             [
                                               812,
                                               1
                                             ],
                                             [
                                               813,
                                               1
                                             ],
                                             [
                                               814,
                                               1
                                             ],
                                             [
                                               815,
                                               1
                                             ],
                                             [
                                               816,
                                               1
                                             ],
                                             [
                                               817,
                                               1
                                             ],
                                             [
                                               818,
                                               1
                                             ],
                                             [
                                               819,
                                               1
                                             ],
                                             [
                                               820,
                                               1
                                             ],
                                             [
                                               821,
                                               1
                                             ],
                                             [
                                               822,
                                               1
                                             ],
                                             [
                                               823,
                                               1
                                             ],
                                             [
                                               824,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '\'}\'' => '189',
                                                '\';\'' => '190'
                                              },
                                 'CORE' => [
                                             [
                                               74,
                                               1
                                             ],
                                             [
                                               75,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             3,
                                             9,
                                             21,
                                             43,
                                             45,
                                             52,
                                             53,
                                             70,
                                             73,
                                             83,
                                             86,
                                             98,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             147,
                                             148,
                                             197,
                                             216,
                                             218,
                                             223,
                                             224,
                                             228,
                                             233,
                                             237,
                                             238,
                                             240,
                                             259,
                                             267,
                                             272,
                                             278,
                                             282,
                                             286,
                                             293,
                                             295,
                                             301,
                                             302,
                                             364,
                                             394,
                                             395,
                                             401,
                                             403,
                                             414,
                                             424,
                                             429,
                                             430,
                                             434,
                                             451,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             501,
                                             504,
                                             526,
                                             528,
                                             531,
                                             541,
                                             542,
                                             545,
                                             546,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             569,
                                             570,
                                             571,
                                             582,
                                             590,
                                             594,
                                             602,
                                             618,
                                             622,
                                             631,
                                             636,
                                             640,
                                             641,
                                             694,
                                             696,
                                             700,
                                             708,
                                             722,
                                             723,
                                             726,
                                             744,
                                             747,
                                             748,
                                             751,
                                             752,
                                             764,
                                             766,
                                             780,
                                             788,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             871,
                                             873,
                                             879,
                                             887,
                                             888,
                                             893,
                                             898,
                                             902,
                                             906,
                                             908,
                                             952,
                                             957,
                                             958,
                                             962,
                                             965,
                                             1009,
                                             1014,
                                             1019,
                                             1020,
                                             1021,
                                             1027,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1044,
                                             1045,
                                             1073,
                                             1120,
                                             1121,
                                             1122,
                                             1181,
                                             1199,
                                             1201,
                                             1208,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1241,
                                             1250,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1279,
                                             1280,
                                             1283,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1363,
                                             1367,
                                             1375,
                                             1379,
                                             1388,
                                             1390,
                                             1412,
                                             1415,
                                             1416,
                                             1423,
                                             1424,
                                             1426,
                                             1446,
                                             1468,
                                             1487,
                                             1488,
                                             1489,
                                             1510,
                                             1511,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1549,
                                             1564,
                                             1569,
                                             1571,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '191'
                                              },
                                 'CORE' => [
                                             [
                                               407,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -11
                                              },
                                 'CORE' => [
                                             [
                                               11,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             26,
                                             27,
                                             43,
                                             45,
                                             57,
                                             67,
                                             70,
                                             83,
                                             86,
                                             124,
                                             126,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             152,
                                             157,
                                             192,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             262,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             368,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             584,
                                             590,
                                             591,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             717,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             764,
                                             766,
                                             780,
                                             788,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             862,
                                             863,
                                             864,
                                             866,
                                             875,
                                             892,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             957,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1120,
                                             1121,
                                             1122,
                                             1149,
                                             1153,
                                             1163,
                                             1182,
                                             1199,
                                             1206,
                                             1208,
                                             1211,
                                             1213,
                                             1217,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1374,
                                             1379,
                                             1380,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1423,
                                             1424,
                                             1425,
                                             1426,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1554,
                                             1564,
                                             1570,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-606',
                                                '\'<\'' => '192',
                                                'SCOPE' => '193'
                                              },
                                 'CORE' => [
                                             [
                                               151,
                                               1
                                             ],
                                             [
                                               606,
                                               1
                                             ],
                                             [
                                               612,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             192,
                                             197,
                                             199,
                                             200,
                                             201,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             224,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             364,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             517,
                                             519,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             595,
                                             602,
                                             603,
                                             614,
                                             617,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             706,
                                             709,
                                             717,
                                             735,
                                             743,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -258
                                              },
                                 'CORE' => [
                                             [
                                               258,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'suspend_mom' => '194',
                                              'maybe_parmlist' => '196'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             267,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             565,
                                             567,
                                             696,
                                             706,
                                             748,
                                             752,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1045,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => '-584',
                                                '\'[\'' => '195',
                                                'LEFT_RIGHT' => -551,
                                                '\'(\'' => -551
                                              },
                                 'CORE' => [
                                             [
                                               584,
                                               1
                                             ],
                                             [
                                               591,
                                               1
                                             ],
                                             [
                                               593,
                                               1
                                             ],
                                             [
                                               594,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -573
                                              },
                                 'CORE' => [
                                             [
                                               573,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             422,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -457
                                              },
                                 'CORE' => [
                                             [
                                               457,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'cv_qualifiers' => '197'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             216,
                                             218,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             403,
                                             429,
                                             476,
                                             484,
                                             494,
                                             498,
                                             565,
                                             696,
                                             780,
                                             1009,
                                             1026,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                '' => -547
                                              },
                                 'CORE' => [
                                             [
                                               583,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             192,
                                             203,
                                             216,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             451,
                                             452,
                                             517,
                                             519,
                                             529,
                                             566,
                                             580,
                                             595,
                                             602,
                                             603,
                                             614,
                                             617,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             709,
                                             735,
                                             743,
                                             756,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1224,
                                             1234,
                                             1242,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -9
                                              },
                                 'CORE' => [
                                             [
                                               9,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -379
                                              },
                                 'CORE' => [
                                             [
                                               379,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'see_typename' => '198'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             199,
                                             200,
                                             201,
                                             214,
                                             216,
                                             218,
                                             223,
                                             224,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             303,
                                             368,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             463,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             567,
                                             654,
                                             696,
                                             706,
                                             717,
                                             748,
                                             751,
                                             752,
                                             757,
                                             780,
                                             788,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             958,
                                             963,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1199,
                                             1206,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -776
                                              },
                                 'CORE' => [
                                             [
                                               256,
                                               1
                                             ],
                                             [
                                               257,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'nested_name_specifier' => '201',
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'global_scope' => '200',
                                              'qualified_id' => '202'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'NSNAME' => '127',
                                                'NAMESPACE' => '199',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '133'
                                              },
                                 'CORE' => [
                                             [
                                               26,
                                               1
                                             ],
                                             [
                                               27,
                                               1
                                             ],
                                             [
                                               28,
                                               1
                                             ],
                                             [
                                               32,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             26,
                                             27,
                                             43,
                                             45,
                                             67,
                                             70,
                                             83,
                                             86,
                                             124,
                                             126,
                                             139,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             262,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             368,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             398,
                                             415,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             584,
                                             590,
                                             591,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             700,
                                             706,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             764,
                                             766,
                                             780,
                                             788,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             862,
                                             863,
                                             864,
                                             866,
                                             875,
                                             892,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             957,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1016,
                                             1017,
                                             1018,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1120,
                                             1121,
                                             1122,
                                             1149,
                                             1153,
                                             1163,
                                             1182,
                                             1199,
                                             1206,
                                             1208,
                                             1211,
                                             1213,
                                             1217,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1374,
                                             1379,
                                             1380,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1423,
                                             1424,
                                             1425,
                                             1426,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1554,
                                             1564,
                                             1570,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-607',
                                                '\'<\'' => '203',
                                                'SCOPE' => '204'
                                              },
                                 'CORE' => [
                                             [
                                               155,
                                               1
                                             ],
                                             [
                                               607,
                                               1
                                             ],
                                             [
                                               613,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             3,
                                             6,
                                             8,
                                             9,
                                             27,
                                             40,
                                             43,
                                             45,
                                             52,
                                             60,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             172,
                                             192,
                                             197,
                                             199,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             359,
                                             363,
                                             364,
                                             365,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             391,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             414,
                                             415,
                                             416,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             434,
                                             451,
                                             452,
                                             476,
                                             484,
                                             494,
                                             498,
                                             506,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             582,
                                             590,
                                             594,
                                             595,
                                             602,
                                             603,
                                             607,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             626,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             706,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             756,
                                             764,
                                             766,
                                             768,
                                             769,
                                             770,
                                             780,
                                             788,
                                             827,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             887,
                                             888,
                                             893,
                                             894,
                                             898,
                                             902,
                                             906,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             959,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1085,
                                             1087,
                                             1099,
                                             1120,
                                             1121,
                                             1122,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1165,
                                             1167,
                                             1169,
                                             1181,
                                             1182,
                                             1193,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1297,
                                             1298,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1423,
                                             1424,
                                             1426,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1549,
                                             1554,
                                             1564,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -638
                                              },
                                 'CORE' => [
                                             [
                                               638,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'using_directive' => '11',
                                              'fndef' => '12',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '14',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'asm_keyword' => '55',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '20',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'namespace_alias' => '63',
                                              'explicit_instantiation' => '62',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'using_decl' => '25',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '67',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'extdef' => '30',
                                              'extension' => '70',
                                              'template_id' => '32',
                                              'datadef' => '71',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'lang_extdef' => '205',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             0
                                           ],
                                 'ACTIONS' => {
                                                ' ' => -2,
                                                'TEMPLATE' => '23',
                                                'ENUM' => '60',
                                                'NAMESPACE' => '2',
                                                '\';\'' => '61',
                                                '\'~\'' => '39',
                                                'USING' => '40',
                                                'SELFNAME' => '41',
                                                'ASM_KEYWORD' => '65',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '28',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '76',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               2,
                                               1
                                             ],
                                             [
                                               4,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             552,
                                             554,
                                             556,
                                             565,
                                             567,
                                             696,
                                             706,
                                             748,
                                             751,
                                             752,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1042,
                                             1044,
                                             1045,
                                             1073,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1279,
                                             1280,
                                             1283,
                                             1379,
                                             1481,
                                             1487,
                                             1488,
                                             1489
                                           ],
                                 'ACTIONS' => {
                                                '' => -282
                                              },
                                 'CORE' => [
                                             [
                                               282,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '206',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'fndef' => '207',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '208',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'template_datadef' => '213',
                                              'typespec' => '53',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '209',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '214',
                                              'nomods_initdecls' => '215',
                                              'constructor_declarator' => '69',
                                              'extension' => '216',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'template_extdef' => '212',
                                              'declmods' => '218',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             143,
                                             216,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                'TEMPLATE' => '210',
                                                'ENUM' => '60',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '211',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '217',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               56,
                                               1
                                             ],
                                             [
                                               57,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             552,
                                             554,
                                             556,
                                             565,
                                             567,
                                             696,
                                             717,
                                             748,
                                             751,
                                             752,
                                             757,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1073,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1279,
                                             1280,
                                             1283,
                                             1379,
                                             1481,
                                             1487,
                                             1488,
                                             1489
                                           ],
                                 'ACTIONS' => {
                                                '' => '-260',
                                                '\'<\'' => '219'
                                              },
                                 'CORE' => [
                                             [
                                               260,
                                               1
                                             ],
                                             [
                                               278,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             141,
                                             143,
                                             145,
                                             148,
                                             216,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             476,
                                             565,
                                             696,
                                             952,
                                             1009,
                                             1181,
                                             1201,
                                             1208,
                                             1212,
                                             1363,
                                             1367,
                                             1375,
                                             1388,
                                             1390,
                                             1468,
                                             1549,
                                             1569,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => -352
                                              },
                                 'CORE' => [
                                             [
                                               352,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             192,
                                             197,
                                             199,
                                             200,
                                             201,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             224,
                                             228,
                                             233,
                                             251,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             364,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             517,
                                             519,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             595,
                                             602,
                                             603,
                                             614,
                                             617,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             647,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             706,
                                             709,
                                             717,
                                             735,
                                             743,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -789
                                              },
                                 'CORE' => [
                                             [
                                               789,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-472',
                                                '\':\'' => '220',
                                                '\'{\'' => '221'
                                              },
                                 'CORE' => [
                                             [
                                               465,
                                               1
                                             ],
                                             [
                                               466,
                                               1
                                             ],
                                             [
                                               472,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             284,
                                             301,
                                             302,
                                             306,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             429,
                                             434,
                                             451,
                                             452,
                                             476,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             894,
                                             898,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '222'
                                              },
                                 'CORE' => [
                                             [
                                               382,
                                               1
                                             ],
                                             [
                                               383,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             143,
                                             216,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -39
                                              },
                                 'CORE' => [
                                             [
                                               39,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'expr_or_declarator' => '230',
                                              'complex_notype_declarator' => '227',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '231',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '232',
                                              'attribute' => '7',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '225',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '226',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '224',
                                              'expr_or_declarator_intern' => '229',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             216,
                                             218,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             403,
                                             429,
                                             476,
                                             484,
                                             494,
                                             498,
                                             565,
                                             696,
                                             780,
                                             1009,
                                             1026,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '233',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '228',
                                                '\'*\'' => '223',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               283,
                                               1
                                             ],
                                             [
                                               592,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '234',
                                              'named_class_head_sans_basetype' => '49',
                                              'reserved_typespecquals' => '240',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'reserved_declspecs' => '237',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'class_head' => '18',
                                              'typespecqual_reserved' => '239',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'attributes' => '238'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             141,
                                             143,
                                             145,
                                             216,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             476,
                                             696,
                                             1009
                                           ],
                                 'ACTIONS' => {
                                                '' => '-371',
                                                'ENUM' => '60',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '235',
                                                'ATTRIBUTE' => '29',
                                                'SCSPEC' => '241',
                                                'TYPESPEC' => '236',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               355,
                                               1
                                             ],
                                             [
                                               356,
                                               1
                                             ],
                                             [
                                               371,
                                               1
                                             ],
                                             [
                                               373,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'maybe_base_class_list' => '243'
                                            },
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-478',
                                                '\':\'' => '242'
                                              },
                                 'CORE' => [
                                             [
                                               474,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '244'
                                              },
                                 'CORE' => [
                                             [
                                               15,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'maybe_return_init' => '246',
                                              'return_init' => '245',
                                              'return_id' => '247'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             143,
                                             145,
                                             216,
                                             301,
                                             302,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                '' => '-79',
                                                'RETURN_KEYWORD' => '248'
                                              },
                                 'CORE' => [
                                             [
                                               84,
                                               1
                                             ],
                                             [
                                               85,
                                               1
                                             ],
                                             [
                                               86,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_template_declarator' => '255',
                                              'type_name' => '250',
                                              'template_id' => '32',
                                              'object_template_id' => '253',
                                              'nested_name_specifier_1' => '252',
                                              'template_type' => '16',
                                              'self_template_type' => '257',
                                              'notype_unqualified_id' => '256',
                                              'operator' => '27',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             83,
                                             86,
                                             141,
                                             143,
                                             145,
                                             148,
                                             216,
                                             218,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             403,
                                             476,
                                             565,
                                             696,
                                             1009
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'TEMPLATE' => '251',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '254',
                                                'PFUNCNAME' => '79',
                                                '\'*\'' => '249',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               87,
                                               1
                                             ],
                                             [
                                               88,
                                               1
                                             ],
                                             [
                                               91,
                                               1
                                             ],
                                             [
                                               92,
                                               1
                                             ],
                                             [
                                               576,
                                               1
                                             ],
                                             [
                                               596,
                                               1
                                             ],
                                             [
                                               599,
                                               1
                                             ],
                                             [
                                               600,
                                               1
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ],
                                             [
                                               636,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             192,
                                             197,
                                             199,
                                             200,
                                             201,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             224,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             364,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             517,
                                             519,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             595,
                                             602,
                                             603,
                                             614,
                                             617,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             706,
                                             709,
                                             717,
                                             735,
                                             743,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-259',
                                                '\'<\'' => '258'
                                              },
                                 'CORE' => [
                                             [
                                               259,
                                               1
                                             ],
                                             [
                                               265,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'asm_keyword' => '260',
                                              'maybeasm' => '259'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             143,
                                             145,
                                             216,
                                             301,
                                             302,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                '' => '-97',
                                                '\';\'' => -393,
                                                '\',\'' => -393,
                                                '\'=\'' => -393,
                                                'ASM_KEYWORD' => '65',
                                                'ATTRIBUTE' => -393
                                              },
                                 'CORE' => [
                                             [
                                               97,
                                               1
                                             ],
                                             [
                                               401,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'global_scope' => '262',
                                              'identifier' => '264',
                                              'complex_type_name' => '265',
                                              'nested_name_specifier' => '126',
                                              'nested_type' => '261'
                                            },
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '101',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '108',
                                                'SCOPE' => '42',
                                                '\'{\'' => '263',
                                                'PTYPENAME' => '96',
                                                'SELFNAME' => '105'
                                              },
                                 'CORE' => [
                                             [
                                               444,
                                               1
                                             ],
                                             [
                                               445,
                                               1
                                             ],
                                             [
                                               446,
                                               1
                                             ],
                                             [
                                               447,
                                               1
                                             ],
                                             [
                                               448,
                                               1
                                             ],
                                             [
                                               449,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -76
                                              },
                                 'CORE' => [
                                             [
                                               76,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '\';\'' => '266'
                                              },
                                 'CORE' => [
                                             [
                                               72,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -21
                                              },
                                 'CORE' => [
                                             [
                                               21,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             267,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             565,
                                             567,
                                             696,
                                             706,
                                             748,
                                             752,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1045,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -281
                                              },
                                 'CORE' => [
                                             [
                                               281,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             59,
                                             69,
                                             70,
                                             86,
                                             143,
                                             269,
                                             296,
                                             301,
                                             302,
                                             396,
                                             399,
                                             400,
                                             560,
                                             718,
                                             719,
                                             720,
                                             729,
                                             730,
                                             731,
                                             952,
                                             1181,
                                             1201,
                                             1212,
                                             1247,
                                             1249,
                                             1367,
                                             1375,
                                             1377,
                                             1388,
                                             1390,
                                             1397,
                                             1468,
                                             1547,
                                             1549,
                                             1569,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => -10
                                              },
                                 'CORE' => [
                                             [
                                               10,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             267,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             565,
                                             567,
                                             696,
                                             706,
                                             748,
                                             752,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1045,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -280
                                              },
                                 'CORE' => [
                                             [
                                               280,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator' => '274',
                                              'declarator' => '269',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'initdcl0' => '276',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'after_type_declarator' => '277',
                                              'type_name' => '268',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '270',
                                              'direct_after_type_declarator' => '279',
                                              'initdecls' => '271',
                                              'nested_name_specifier' => '273',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                '\';\'' => '275',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '278',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '272',
                                                '\'*\'' => '267',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               70,
                                               1
                                             ],
                                             [
                                               73,
                                               1
                                             ],
                                             [
                                               95,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '\';\'' => '281',
                                                '\',\'' => '280'
                                              },
                                 'CORE' => [
                                             [
                                               68,
                                               1
                                             ],
                                             [
                                               392,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'asm_keyword' => '260',
                                              'maybeasm' => '282'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             143,
                                             145,
                                             216,
                                             301,
                                             302,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                '' => '-99',
                                                '\';\'' => -393,
                                                '\',\'' => -393,
                                                'ASM_KEYWORD' => '65',
                                                'ATTRIBUTE' => -393
                                              },
                                 'CORE' => [
                                             [
                                               99,
                                               1
                                             ],
                                             [
                                               402,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'using_directive' => '11',
                                              'fndef' => '12',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '14',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'asm_keyword' => '55',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '20',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'namespace_alias' => '63',
                                              'explicit_instantiation' => '62',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'using_decl' => '25',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '67',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'extdef' => '283',
                                              'extension' => '70',
                                              'template_id' => '32',
                                              'datadef' => '71',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                'TEMPLATE' => '23',
                                                'ENUM' => '60',
                                                'NAMESPACE' => '2',
                                                '\';\'' => '61',
                                                '\'~\'' => '39',
                                                'USING' => '40',
                                                'SELFNAME' => '41',
                                                'ASM_KEYWORD' => '65',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '28',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '76',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               24,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -13
                                              },
                                 'CORE' => [
                                             [
                                               13,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             552,
                                             554,
                                             556,
                                             565,
                                             567,
                                             696,
                                             706,
                                             717,
                                             748,
                                             751,
                                             752,
                                             757,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1073,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1279,
                                             1280,
                                             1283,
                                             1379,
                                             1481,
                                             1487,
                                             1488,
                                             1489
                                           ],
                                 'ACTIONS' => {
                                                '' => '-262',
                                                '\'<\'' => '284',
                                                'SCOPE' => '285'
                                              },
                                 'CORE' => [
                                             [
                                               262,
                                               1
                                             ],
                                             [
                                               279,
                                               1
                                             ],
                                             [
                                               614,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '287',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '286',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '130',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             216,
                                             218,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             403,
                                             429,
                                             476,
                                             484,
                                             494,
                                             498,
                                             565,
                                             696,
                                             780,
                                             1009,
                                             1026,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '73',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               580,
                                               1
                                             ],
                                             [
                                               582,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'maybe_base_class_list' => '288'
                                            },
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => '-478',
                                                '\':\'' => '242'
                                              },
                                 'CORE' => [
                                             [
                                               473,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             141,
                                             143,
                                             145,
                                             148,
                                             216,
                                             301,
                                             302,
                                             394,
                                             395,
                                             401,
                                             476,
                                             565,
                                             696,
                                             952,
                                             1009,
                                             1181,
                                             1201,
                                             1208,
                                             1212,
                                             1363,
                                             1367,
                                             1375,
                                             1388,
                                             1390,
                                             1468,
                                             1549,
                                             1569,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => -353
                                              },
                                 'CORE' => [
                                             [
                                               353,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => '-366',
                                                'TEMPLATE' => '289'
                                              },
                                 'CORE' => [
                                             [
                                               144,
                                               1
                                             ],
                                             [
                                               145,
                                               1
                                             ],
                                             [
                                               146,
                                               1
                                             ],
                                             [
                                               147,
                                               1
                                             ],
                                             [
                                               366,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             86,
                                             143,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                '' => -3
                                              },
                                 'CORE' => [
                                             [
                                               3,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             3,
                                             6,
                                             8,
                                             9,
                                             26,
                                             27,
                                             40,
                                             43,
                                             45,
                                             52,
                                             60,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             99,
                                             107,
                                             114,
                                             121,
                                             124,
                                             126,
                                             128,
                                             130,
                                             131,
                                             134,
                                             139,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             172,
                                             192,
                                             197,
                                             198,
                                             199,
                                             200,
                                             201,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             228,
                                             233,
                                             262,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             305,
                                             306,
                                             330,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             359,
                                             363,
                                             364,
                                             365,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             391,
                                             398,
                                             414,
                                             415,
                                             416,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             434,
                                             444,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             494,
                                             498,
                                             506,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             582,
                                             584,
                                             590,
                                             591,
                                             594,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             626,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             648,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             700,
                                             706,
                                             709,
                                             712,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             764,
                                             766,
                                             768,
                                             769,
                                             770,
                                             780,
                                             788,
                                             816,
                                             827,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             862,
                                             863,
                                             864,
                                             866,
                                             875,
                                             887,
                                             888,
                                             892,
                                             893,
                                             894,
                                             898,
                                             902,
                                             906,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1085,
                                             1087,
                                             1099,
                                             1120,
                                             1121,
                                             1122,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1165,
                                             1167,
                                             1169,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1297,
                                             1298,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1423,
                                             1424,
                                             1425,
                                             1426,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1549,
                                             1554,
                                             1564,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -152
                                              },
                                 'CORE' => [
                                             [
                                               152,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             57,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             134,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             148,
                                             192,
                                             197,
                                             199,
                                             200,
                                             201,
                                             203,
                                             214,
                                             216,
                                             218,
                                             219,
                                             222,
                                             223,
                                             224,
                                             228,
                                             233,
                                             267,
                                             272,
                                             273,
                                             278,
                                             280,
                                             284,
                                             286,
                                             301,
                                             302,
                                             303,
                                             306,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             348,
                                             355,
                                             356,
                                             358,
                                             364,
                                             368,
                                             372,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             451,
                                             452,
                                             463,
                                             476,
                                             484,
                                             487,
                                             489,
                                             493,
                                             494,
                                             498,
                                             517,
                                             519,
                                             529,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             565,
                                             566,
                                             567,
                                             580,
                                             595,
                                             602,
                                             603,
                                             614,
                                             617,
                                             618,
                                             622,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             654,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             706,
                                             709,
                                             717,
                                             735,
                                             743,
                                             748,
                                             751,
                                             752,
                                             756,
                                             757,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             908,
                                             911,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             958,
                                             959,
                                             961,
                                             962,
                                             963,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1017,
                                             1018,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1043,
                                             1044,
                                             1045,
                                             1056,
                                             1073,
                                             1076,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1206,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1215,
                                             1216,
                                             1217,
                                             1218,
                                             1219,
                                             1224,
                                             1234,
                                             1242,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '290'
                                              },
                                 'CORE' => [
                                             [
                                               264,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             43,
                                             45,
                                             70,
                                             86,
                                             143,
                                             145,
                                             216,
                                             301,
                                             302,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                '' => -391
                                              },
                                 'CORE' => [
                                             [
                                               391,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             8,
                                             27,
                                             43,
                                             45,
                                             53,
                                             70,
                                             83,
                                             86,
                                             125,
                                             139,
                                             141,
                                             142,
                                             143,
                                             145,
                                             147,
                                             148,
                                             157,
                                             176,
                                             192,
                                             203,
                                             216,
                                             218,
                                             219,
                                             222,
                                             237,
                                             240,
                                             284,
                                             295,
                                             301,
                                             302,
                                             306,
                                             327,
                                             334,
                                             337,
                                             339,
                                             340,
                                             345,
                                             346,
                                             355,
                                             356,
                                             358,
                                             359,
                                             364,
                                             365,
                                             373,
                                             374,
                                             378,
                                             381,
                                             385,
                                             394,
                                             395,
                                             401,
                                             403,
                                             415,
                                             424,
                                             429,
                                             430,
                                             434,
                                             446,
                                             451,
                                             452,
                                             476,
                                             504,
                                             517,
                                             519,
                                             526,
                                             528,
                                             529,
                                             565,
                                             566,
                                             569,
                                             570,
                                             580,
                                             590,
                                             595,
                                             602,
                                             603,
                                             613,
                                             614,
                                             615,
                                             617,
                                             618,
                                             620,
                                             622,
                                             624,
                                             629,
                                             631,
                                             636,
                                             640,
                                             641,
                                             645,
                                             658,
                                             661,
                                             665,
                                             668,
                                             670,
                                             671,
                                             672,
                                             673,
                                             674,
                                             675,
                                             676,
                                             677,
                                             678,
                                             679,
                                             680,
                                             681,
                                             682,
                                             683,
                                             684,
                                             685,
                                             686,
                                             687,
                                             688,
                                             689,
                                             690,
                                             691,
                                             692,
                                             696,
                                             700,
                                             709,
                                             726,
                                             735,
                                             743,
                                             744,
                                             746,
                                             751,
                                             756,
                                             764,
                                             766,
                                             780,
                                             788,
                                             835,
                                             838,
                                             839,
                                             840,
                                             846,
                                             850,
                                             873,
                                             879,
                                             894,
                                             898,
                                             908,
                                             911,
                                             914,
                                             919,
                                             931,
                                             932,
                                             936,
                                             938,
                                             943,
                                             952,
                                             957,
                                             961,
                                             962,
                                             965,
                                             970,
                                             973,
                                             975,
                                             1009,
                                             1016,
                                             1018,
                                             1042,
                                             1056,
                                             1073,
                                             1076,
                                             1078,
                                             1087,
                                             1099,
                                             1149,
                                             1153,
                                             1154,
                                             1163,
                                             1181,
                                             1182,
                                             1199,
                                             1201,
                                             1208,
                                             1211,
                                             1212,
                                             1213,
                                             1217,
                                             1224,
                                             1234,
                                             1242,
                                             1264,
                                             1277,
                                             1279,
                                             1280,
                                             1283,
                                             1301,
                                             1303,
                                             1305,
                                             1311,
                                             1322,
                                             1330,
                                             1331,
                                             1332,
                                             1337,
                                             1353,
                                             1363,
                                             1367,
                                             1374,
                                             1375,
                                             1379,
                                             1380,
                                             1388,
                                             1390,
                                             1399,
                                             1406,
                                             1413,
                                             1414,
                                             1430,
                                             1435,
                                             1446,
                                             1457,
                                             1461,
                                             1468,
                                             1469,
                                             1470,
                                             1482,
                                             1487,
                                             1488,
                                             1489,
                                             1517,
                                             1549,
                                             1554,
                                             1569,
                                             1570,
                                             1590,
                                             1593
                                           ],
                                 'ACTIONS' => {
                                                '' => -476
                                              },
                                 'CORE' => [
                                             [
                                               476,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             0,
                                             9,
                                             43,
                                             45,
                                             52,
                                             67,
                                             70,
                                             73,
                                             83,
                                             86,
                                             128,
                                             130,
                                             141,
                                             143,
                                             145,
                                             148,
                                             197,
                                             214,
                                             216,
                                             218,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             278,
                                             280,
                                             286,
                                             301,
                                             302,
                                             394,
                                             395,
                                             398,
                                             401,
                                             403,
                                             423,
                                             424,
                                             427,
                                             429,
                                             432,
                                             476,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             552,
                                             554,
                                             556,
                                             565,
                                             567,
                                             696,
                                             706,
                                             748,
                                             751,
                                             752,
                                             780,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1009,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1042,
                                             1044,
                                             1045,
                                             1199,
                                             1206,
                                             1213,
                                             1260,
                                             1266,
                                             1268,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -595
                                              },
                                 'CORE' => [
                                             [
                                               595,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'notype_initdecls' => '291',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '295',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'attributes' => '293',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '296',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '26',
                                              'notype_unqualified_id' => '64',
                                              'operator' => '27',
                                              'complex_direct_notype_declarator' => '66',
                                              'constructor_declarator' => '298',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'notype_initdcl0' => '294',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             0,
                                             43,
                                             70,
                                             86,
                                             143,
                                             145,
                                             301,
                                             302
                                           ],
                                 'ACTIONS' => {
                                                'ENUM' => '60',
                                                '\';\'' => '297',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '292',
                                                'SCOPE' => '42',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '299',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               69,
                                               1
                                             ],
                                             [
                                               71,
                                               1
                                             ],
                                             [
                                               96,
                                               1
                                             ],
                                             [
                                               98,
                                               1
                                             ],
                                             [
                                               354,
                                               1
                                             ],
                                             [
                                               357,
                                               1
                                             ],
                                             [
                                               358,
                                               1
                                             ],
                                             [
                                               359,
                                               1
                                             ],
                                             [
                                               367,
                                               1
                                             ],
                                             [
                                               368,
                                               1
                                             ],
                                             [
                                               369,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             2,
                                             251,
                                             263,
                                             307,
                                             319,
                                             369,
                                             448,
                                             540,
                                             647,
                                             747,
                                             849,
                                             951,
                                             1057,
                                             1176,
                                             1177,
                                             1350,
                                             1369,
                                             1370,
                                             1475
                                           ],
                                 'ACTIONS' => {
                                                '' => -132
                                              },
                                 'CORE' => [
                                             [
                                               132,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             2,
                                             251,
                                             263,
                                             307,
                                             319,
                                             369,
                                             448,
                                             540,
                                             647,
                                             747,
                                             849,
                                             951,
                                             1057,
                                             1176,
                                             1177,
                                             1350,
                                             1369,
                                             1370,
                                             1475
                                           ],
                                 'ACTIONS' => {
                                                '' => -130
                                              },
                                 'CORE' => [
                                             [
                                               130,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'using_directive' => '11',
                                              'fndef' => '12',
                                              'extdefs' => '301',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '14',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'asm_keyword' => '55',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '20',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'namespace_alias' => '63',
                                              'explicit_instantiation' => '62',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'using_decl' => '25',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '67',
                                              'extdefs_opt' => '300',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'extdef' => '30',
                                              'extension' => '70',
                                              'template_id' => '32',
                                              'datadef' => '71',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'lang_extdef' => '77',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             2
                                           ],
                                 'ACTIONS' => {
                                                '\'}\'' => -6,
                                                'TEMPLATE' => '23',
                                                'ENUM' => '60',
                                                'NAMESPACE' => '2',
                                                '\';\'' => '61',
                                                '\'~\'' => '39',
                                                'USING' => '40',
                                                'SELFNAME' => '41',
                                                'ASM_KEYWORD' => '65',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '28',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '76',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               20,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             2,
                                             251,
                                             263,
                                             307,
                                             319,
                                             369,
                                             448,
                                             540,
                                             647,
                                             747,
                                             849,
                                             951,
                                             1057,
                                             1176,
                                             1177,
                                             1350,
                                             1369,
                                             1370,
                                             1475
                                           ],
                                 'ACTIONS' => {
                                                '' => -131
                                              },
                                 'CORE' => [
                                             [
                                               131,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             2
                                           ],
                                 'ACTIONS' => {
                                                '\'{\'' => '302',
                                                '\'=\'' => '303'
                                              },
                                 'CORE' => [
                                             [
                                               19,
                                               2
                                             ],
                                             [
                                               25,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             2,
                                             3,
                                             60,
                                             99,
                                             107,
                                             198,
                                             251,
                                             263,
                                             305,
                                             307,
                                             319,
                                             369,
                                             414,
                                             448,
                                             540,
                                             647,
                                             747,
                                             849,
                                             951,
                                             1057,
                                             1176,
                                             1177,
                                             1350,
                                             1369,
                                             1370,
                                             1475
                                           ],
                                 'ACTIONS' => {
                                                '' => -129
                                              },
                                 'CORE' => [
                                             [
                                               129,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             2,
                                             198,
                                             251,
                                             263,
                                             307,
                                             319,
                                             369,
                                             448,
                                             540,
                                             647,
                                             747,
                                             849,
                                             951,
                                             1057,
                                             1176,
                                             1177,
                                             1350
                                           ],
                                 'ACTIONS' => {
                                                '' => -133
                                              },
                                 'CORE' => [
                                             [
                                               133,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => -138
                                              },
                                 'CORE' => [
                                             [
                                               138,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414,
                                             747
                                           ],
                                 'ACTIONS' => {
                                                '' => -460
                                              },
                                 'CORE' => [
                                             [
                                               460,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             107,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => '-153',
                                                'SCOPE' => '140'
                                              },
                                 'CORE' => [
                                             [
                                               153,
                                               1
                                             ],
                                             [
                                               615,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414,
                                             747
                                           ],
                                 'ACTIONS' => {
                                                '' => -459
                                              },
                                 'CORE' => [
                                             [
                                               459,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => -137
                                              },
                                 'CORE' => [
                                             [
                                               137,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             60,
                                             99,
                                             107,
                                             198,
                                             305,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => '-132',
                                                '\'<\'' => '142'
                                              },
                                 'CORE' => [
                                             [
                                               132,
                                               1
                                             ],
                                             [
                                               150,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => -139
                                              },
                                 'CORE' => [
                                             [
                                               139,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'attribute' => '146'
                                            },
                                 'FROM' => [
                                             3,
                                             414,
                                             747
                                           ],
                                 'ACTIONS' => {
                                                '' => '-462',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               462,
                                               2
                                             ],
                                             [
                                               406,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'identifier' => '304',
                                              'nested_name_specifier' => '305',
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '129',
                                              'self_template_type' => '78'
                                            },
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '101',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '108',
                                                'PTYPENAME' => '96',
                                                'SELFNAME' => '105'
                                              },
                                 'CORE' => [
                                             [
                                               468,
                                               2
                                             ],
                                             [
                                               469,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => -464
                                              },
                                 'CORE' => [
                                             [
                                               464,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             60,
                                             99,
                                             107,
                                             305,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => '-130',
                                                '\'<\'' => '192',
                                                'SCOPE' => '193'
                                              },
                                 'CORE' => [
                                             [
                                               130,
                                               1
                                             ],
                                             [
                                               151,
                                               1
                                             ],
                                             [
                                               612,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => -475
                                              },
                                 'CORE' => [
                                             [
                                               475,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414,
                                             747
                                           ],
                                 'ACTIONS' => {
                                                '' => -461
                                              },
                                 'CORE' => [
                                             [
                                               461,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => -470
                                              },
                                 'CORE' => [
                                             [
                                               470,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             60,
                                             99,
                                             107,
                                             305,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => '-131',
                                                '\'<\'' => '203',
                                                'SCOPE' => '204'
                                              },
                                 'CORE' => [
                                             [
                                               131,
                                               1
                                             ],
                                             [
                                               155,
                                               1
                                             ],
                                             [
                                               613,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3
                                           ],
                                 'ACTIONS' => {
                                                '' => '-463',
                                                '\'<\'' => '306'
                                              },
                                 'CORE' => [
                                             [
                                               463,
                                               2
                                             ],
                                             [
                                               154,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'identifier' => '309',
                                              'apparent_template_type' => '308',
                                              'nested_name_specifier_1' => '252',
                                              'template_type' => '93',
                                              'self_template_type' => '78'
                                            },
                                 'FROM' => [
                                             3,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '101',
                                                'TEMPLATE' => '307',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '108',
                                                'PTYPENAME' => '96',
                                                'SELFNAME' => '105'
                                              },
                                 'CORE' => [
                                             [
                                               467,
                                               2
                                             ],
                                             [
                                               471,
                                               2
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             60,
                                             99,
                                             107,
                                             305,
                                             414
                                           ],
                                 'ACTIONS' => {
                                                '' => '-133',
                                                'SCOPE' => '285'
                                              },
                                 'CORE' => [
                                             [
                                               133,
                                               1
                                             ],
                                             [
                                               614,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             3,
                                             414,
                                             747
                                           ],
                                 'ACTIONS' => {
                                                '' => -458
                                              },
                                 'CORE' => [
                                             [
                                               458,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             4
                                           ],
                                 'ACTIONS' => {
                                                '' => 0
                                              },
                                 'CORE' => [
                                             [
                                               0,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             416
                                           ],
                                 'ACTIONS' => {
                                                '' => -450
                                              },
                                 'CORE' => [
                                             [
                                               450,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114,
                                             416
                                           ],
                                 'ACTIONS' => {
                                                'SCOPE' => '310'
                                              },
                                 'CORE' => [
                                             [
                                               628,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114,
                                             506,
                                             816,
                                             1085,
                                             1297
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '142',
                                                'SCOPE' => '311'
                                              },
                                 'CORE' => [
                                             [
                                               150,
                                               1
                                             ],
                                             [
                                               629,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'typename_sub2' => '115',
                                              'typename_sub1' => '121',
                                              'template_type' => '112',
                                              'self_template_type' => '78',
                                              'typename_sub0' => '312'
                                            },
                                 'FROM' => [
                                             6,
                                             416
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '116',
                                                'IDENTIFIER' => '119',
                                                'NSNAME' => '120',
                                                'PTYPENAME' => '113',
                                                'SELFNAME' => '118'
                                              },
                                 'CORE' => [
                                             [
                                               617,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114,
                                             416,
                                             506,
                                             816,
                                             827,
                                             1085,
                                             1297,
                                             1298
                                           ],
                                 'ACTIONS' => {
                                                '' => -622
                                              },
                                 'CORE' => [
                                             [
                                               622,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '192',
                                                'SCOPE' => '313'
                                              },
                                 'CORE' => [
                                             [
                                               151,
                                               1
                                             ],
                                             [
                                               626,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             416,
                                             506,
                                             827,
                                             1085,
                                             1297,
                                             1298
                                           ],
                                 'ACTIONS' => {
                                                '' => -616
                                              },
                                 'CORE' => [
                                             [
                                               616,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '203',
                                                'SCOPE' => '314'
                                              },
                                 'CORE' => [
                                             [
                                               155,
                                               1
                                             ],
                                             [
                                               627,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114,
                                             506,
                                             816,
                                             1085,
                                             1297
                                           ],
                                 'ACTIONS' => {
                                                'SCOPE' => '315'
                                              },
                                 'CORE' => [
                                             [
                                               630,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             6,
                                             114,
                                             506,
                                             816,
                                             1085,
                                             1297
                                           ],
                                 'ACTIONS' => {
                                                'SCOPE' => '316'
                                              },
                                 'CORE' => [
                                             [
                                               631,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'identifier' => '324',
                                              'typename_sub2' => '320',
                                              'explicit_template_type' => '321',
                                              'template_type' => '317',
                                              'self_template_type' => '78'
                                            },
                                 'FROM' => [
                                             6,
                                             114,
                                             416,
                                             506,
                                             816,
                                             827,
                                             1085,
                                             1297,
                                             1298
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '322',
                                                'TEMPLATE' => '319',
                                                'IDENTIFIER' => '325',
                                                'NSNAME' => '326',
                                                'PTYPENAME' => '318',
                                                'SELFNAME' => '323'
                                              },
                                 'CORE' => [
                                             [
                                               618,
                                               1
                                             ],
                                             [
                                               619,
                                               1
                                             ],
                                             [
                                               620,
                                               1
                                             ],
                                             [
                                               621,
                                               1
                                             ],
                                             [
                                               623,
                                               1
                                             ],
                                             [
                                               624,
                                               1
                                             ],
                                             [
                                               625,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             8,
                                             128,
                                             157,
                                             286,
                                             334,
                                             415,
                                             484,
                                             498,
                                             541,
                                             556,
                                             858,
                                             866,
                                             887,
                                             906,
                                             1035,
                                             1045,
                                             1120,
                                             1122,
                                             1260,
                                             1268,
                                             1423,
                                             1426
                                           ],
                                 'ACTIONS' => {
                                                '' => -550
                                              },
                                 'CORE' => [
                                             [
                                               550,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             8,
                                             26,
                                             27,
                                             40,
                                             124,
                                             126,
                                             131,
                                             147,
                                             152,
                                             157,
                                             172,
                                             262,
                                             330,
                                             334,
                                             348,
                                             359,
                                             363,
                                             365,
                                             391,
                                             415,
                                             434,
                                             444,
                                             526,
                                             528,
                                             582,
                                             584,
                                             590,
                                             591,
                                             594,
                                             613,
                                             615,
                                             620,
                                             624,
                                             626,
                                             645,
                                             648,
                                             700,
                                             712,
                                             726,
                                             744,
                                             746,
                                             764,
                                             766,
                                             768,
                                             769,
                                             770,
                                             862,
                                             887,
                                             888,
                                             892,
                                             893,
                                             894,
                                             898,
                                             902,
                                             906,
                                             914,
                                             959,
                                             1015,
                                             1078,
                                             1120,
                                             1121,
                                             1122,
                                             1163,
                                             1165,
                                             1167,
                                             1169,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1423,
                                             1424,
                                             1425,
                                             1426,
                                             1435,
                                             1446,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1564
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '142'
                                              },
                                 'CORE' => [
                                             [
                                               150,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'type_name' => '150',
                                              'nested_name_specifier' => '126',
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'nested_type' => '151'
                                            },
                                 'FROM' => [
                                             8,
                                             27,
                                             147,
                                             157,
                                             359,
                                             434,
                                             526,
                                             528,
                                             613,
                                             615,
                                             620,
                                             624,
                                             645,
                                             700,
                                             726,
                                             744,
                                             746,
                                             764,
                                             766,
                                             894,
                                             898,
                                             1078,
                                             1163,
                                             1435,
                                             1446
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'NSNAME' => '127',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '41'
                                              },
                                 'CORE' => [
                                             [
                                               572,
                                               1
                                             ],
                                             [
                                               575,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '234',
                                              'named_class_head_sans_basetype' => '49',
                                              'reserved_typespecquals' => '327',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'class_head' => '18',
                                              'typespecqual_reserved' => '239',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81'
                                            },
                                 'FROM' => [
                                             8,
                                             157,
                                             334,
                                             415
                                           ],
                                 'ACTIONS' => {
                                                '' => '-372',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '235',
                                                'TYPESPEC' => '236',
                                                'ENUM' => '60',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               372,
                                               2
                                             ],
                                             [
                                               374,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'type_name' => '250',
                                              'nested_name_specifier_1' => '252',
                                              'template_type' => '16',
                                              'self_template_type' => '78'
                                            },
                                 'FROM' => [
                                             8,
                                             27,
                                             60,
                                             124,
                                             147,
                                             157,
                                             262,
                                             359,
                                             434,
                                             526,
                                             528,
                                             613,
                                             615,
                                             620,
                                             624,
                                             645,
                                             700,
                                             726,
                                             744,
                                             746,
                                             764,
                                             766,
                                             894,
                                             898,
                                             1078,
                                             1163,
                                             1435,
                                             1446
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'TEMPLATE' => '307',
                                                'NSNAME' => '127',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '41'
                                              },
                                 'CORE' => [
                                             [
                                               576,
                                               1
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             8,
                                             26,
                                             27,
                                             40,
                                             124,
                                             126,
                                             131,
                                             147,
                                             152,
                                             157,
                                             172,
                                             262,
                                             330,
                                             334,
                                             348,
                                             359,
                                             363,
                                             365,
                                             391,
                                             415,
                                             434,
                                             444,
                                             526,
                                             528,
                                             582,
                                             584,
                                             590,
                                             591,
                                             594,
                                             613,
                                             615,
                                             620,
                                             624,
                                             626,
                                             645,
                                             648,
                                             700,
                                             712,
                                             726,
                                             744,
                                             746,
                                             764,
                                             766,
                                             768,
                                             769,
                                             770,
                                             862,
                                             887,
                                             888,
                                             892,
                                             893,
                                             894,
                                             898,
                                             902,
                                             906,
                                             914,
                                             959,
                                             1015,
                                             1078,
                                             1120,
                                             1121,
                                             1122,
                                             1163,
                                             1165,
                                             1167,
                                             1169,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1423,
                                             1424,
                                             1425,
                                             1426,
                                             1435,
                                             1446,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1564
                                           ],
                                 'ACTIONS' => {
                                                'SCOPE' => '285'
                                              },
                                 'CORE' => [
                                             [
                                               614,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '328',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '130',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             9
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '73',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '122',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               579,
                                               2
                                             ],
                                             [
                                               550,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             9,
                                             40,
                                             52,
                                             60,
                                             73,
                                             99,
                                             128,
                                             130,
                                             131,
                                             134,
                                             172,
                                             197,
                                             199,
                                             200,
                                             201,
                                             223,
                                             228,
                                             233,
                                             286,
                                             303,
                                             305,
                                             330,
                                             363,
                                             365,
                                             372,
                                             391,
                                             444,
                                             463,
                                             484,
                                             494,
                                             498,
                                             582,
                                             594,
                                             626,
                                             648,
                                             654,
                                             712,
                                             768,
                                             769,
                                             770,
                                             887,
                                             888,
                                             893,
                                             902,
                                             906,
                                             914,
                                             958,
                                             1015,
                                             1026,
                                             1165,
                                             1167,
                                             1169,
                                             1215,
                                             1216,
                                             1218
                                           ],
                                 'ACTIONS' => {
                                                'SCOPE' => '140'
                                              },
                                 'CORE' => [
                                             [
                                               615,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator' => '329',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '146',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nested_name_specifier' => '134',
                                              'operator_name' => '58',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             9,
                                             73,
                                             128,
                                             197,
                                             286,
                                             484,
                                             494,
                                             498
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '73',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                '\'*\'' => '9',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               406,
                                               1
                                             ],
                                             [
                                               578,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'nested_name_specifier' => '330',
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '129',
                                              'self_template_type' => '78'
                                            },
                                 'FROM' => [
                                             9,
                                             52,
                                             67,
                                             73,
                                             128,
                                             130,
                                             172,
                                             197,
                                             214,
                                             223,
                                             228,
                                             233,
                                             267,
                                             272,
                                             278,
                                             280,
                                             286,
                                             363,
                                             365,
                                             423,
                                             424,
                                             427,
                                             432,
                                             484,
                                             494,
                                             498,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             567,
                                             582,
                                             594,
                                             626,
                                             748,
                                             752,
                                             768,
                                             769,
                                             770,
                                             788,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             887,
                                             888,
                                             893,
                                             902,
                                             906,
                                             914,
                                             958,
                                             1017,
                                             1026,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1044,
                                             1045,
                                             1120,
                                             1121,
                                             1122,
                                             1165,
                                             1167,
                                             1169,
                                             1199,
                                             1206,
                                             1215,
                                             1216,
                                             1218,
                                             1260,
                                             1261,
                                             1262,
                                             1265,
                                             1266,
                                             1268,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1423,
                                             1424,
                                             1426,
                                             1481,
                                             1515,
                                             1516,
                                             1518,
                                             1564
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'NSNAME' => '127',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '133'
                                              },
                                 'CORE' => [
                                             [
                                               637,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             9,
                                             40,
                                             52,
                                             73,
                                             128,
                                             130,
                                             131,
                                             134,
                                             172,
                                             197,
                                             223,
                                             228,
                                             233,
                                             286,
                                             330,
                                             363,
                                             365,
                                             391,
                                             444,
                                             484,
                                             494,
                                             498,
                                             582,
                                             594,
                                             626,
                                             648,
                                             654,
                                             712,
                                             768,
                                             769,
                                             770,
                                             887,
                                             888,
                                             893,
                                             902,
                                             906,
                                             914,
                                             958,
                                             1015,
                                             1026,
                                             1165,
                                             1167,
                                             1169,
                                             1215,
                                             1216,
                                             1218
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '192',
                                                'SCOPE' => '193'
                                              },
                                 'CORE' => [
                                             [
                                               151,
                                               1
                                             ],
                                             [
                                               612,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             9,
                                             40,
                                             52,
                                             73,
                                             128,
                                             130,
                                             131,
                                             134,
                                             172,
                                             197,
                                             223,
                                             228,
                                             233,
                                             286,
                                             330,
                                             363,
                                             365,
                                             391,
                                             444,
                                             484,
                                             494,
                                             498,
                                             582,
                                             594,
                                             626,
                                             648,
                                             654,
                                             712,
                                             768,
                                             769,
                                             770,
                                             887,
                                             888,
                                             893,
                                             902,
                                             906,
                                             914,
                                             958,
                                             1026,
                                             1165,
                                             1167,
                                             1169,
                                             1215,
                                             1216,
                                             1218
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '203',
                                                'SCOPE' => '204'
                                              },
                                 'CORE' => [
                                             [
                                               155,
                                               1
                                             ],
                                             [
                                               613,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_template_declarator' => '255',
                                              'template_id' => '32',
                                              'object_template_id' => '253',
                                              'nested_name_specifier_1' => '252',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'notype_unqualified_id' => '256',
                                              'operator' => '27',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             9,
                                             52,
                                             73,
                                             128,
                                             130,
                                             197,
                                             223,
                                             228,
                                             233,
                                             286,
                                             484,
                                             494,
                                             498,
                                             1026
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'TEMPLATE' => '251',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'*\'' => '249',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               596,
                                               1
                                             ],
                                             [
                                               599,
                                               1
                                             ],
                                             [
                                               600,
                                               1
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ],
                                             [
                                               636,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             9,
                                             267,
                                             748
                                           ],
                                 'ACTIONS' => {
                                                '' => -581
                                              },
                                 'CORE' => [
                                             [
                                               581,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             9,
                                             73,
                                             128,
                                             197,
                                             267,
                                             278,
                                             286,
                                             484,
                                             494,
                                             498,
                                             541,
                                             546,
                                             556,
                                             748,
                                             752,
                                             858,
                                             864,
                                             866,
                                             1035,
                                             1037,
                                             1045,
                                             1260,
                                             1266,
                                             1268
                                           ],
                                 'ACTIONS' => {
                                                '' => -577
                                              },
                                 'CORE' => [
                                             [
                                               577,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             12,
                                             207,
                                             737,
                                             1080,
                                             1505
                                           ],
                                 'ACTIONS' => {
                                                '' => -83
                                              },
                                 'CORE' => [
                                             [
                                               83,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             12
                                           ],
                                 'ACTIONS' => {
                                                '' => -12
                                              },
                                 'CORE' => [
                                             [
                                               12,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'type_id' => '338',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'expr' => '377',
                                              'nontrivial_exprlist' => '351',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '384',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             15
                                           ],
                                 'ACTIONS' => {
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '19',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               380,
                                               2
                                             ],
                                             [
                                               381,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             16,
                                             93,
                                             129
                                           ],
                                 'ACTIONS' => {
                                                '' => -615
                                              },
                                 'CORE' => [
                                             [
                                               615,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'opt_dot_component_decl_list' => '386',
                                              'structsp' => '1',
                                              'fn_dot_def2' => '393',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_header' => '394',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'component_decl' => '387',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '396',
                                              'component_decl_list' => '395',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'using_decl' => '388',
                                              'global_scope' => '26',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'component_decl_1' => '389',
                                              'typed_declspecs' => '398',
                                              'component_constructor_declarator' => '399',
                                              'constructor_declarator' => '400',
                                              'extension' => '401',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '402',
                                              'ptr_to_mem' => '36',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '403',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             18
                                           ],
                                 'ACTIONS' => {
                                                '\'}\'' => -493,
                                                'TEMPLATE' => '210',
                                                '\':\'' => '385',
                                                'ENUM' => '60',
                                                '\';\'' => '397',
                                                '\'~\'' => '39',
                                                'USING' => '391',
                                                'SELFNAME' => '392',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '390',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '217',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19',
                                                'VISSPEC' => -493
                                              },
                                 'CORE' => [
                                             [
                                               451,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'template_arg_list_opt' => '406',
                                              'type_id' => '404',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'template_arg' => '407',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'template_arg_list' => '408',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '409',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             19,
                                             96,
                                             113,
                                             123,
                                             318,
                                             405,
                                             920,
                                             1093,
                                             1186
                                           ],
                                 'ACTIONS' => {
                                                '' => '-159',
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '405',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               150,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'using_directive' => '11',
                                              'fndef' => '12',
                                              'extdefs' => '301',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '14',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'asm_keyword' => '55',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '20',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'namespace_alias' => '63',
                                              'explicit_instantiation' => '62',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'using_decl' => '25',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '67',
                                              'extdefs_opt' => '410',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'extdef' => '30',
                                              'extension' => '70',
                                              'template_id' => '32',
                                              'datadef' => '71',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'lang_extdef' => '77',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             20
                                           ],
                                 'ACTIONS' => {
                                                '\'}\'' => -6,
                                                'TEMPLATE' => '23',
                                                'ENUM' => '60',
                                                'NAMESPACE' => '2',
                                                '\';\'' => '61',
                                                '\'~\'' => '39',
                                                'USING' => '40',
                                                'SELFNAME' => '41',
                                                'ASM_KEYWORD' => '65',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '28',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '76',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               16,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             20,
                                             209
                                           ],
                                 'ACTIONS' => {
                                                '' => -40
                                              },
                                 'CORE' => [
                                             [
                                               40,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'fndef' => '411',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'explicit_instantiation' => '62',
                                              'global_scope' => '26',
                                              'notype_unqualified_id' => '64',
                                              'operator' => '27',
                                              'complex_direct_notype_declarator' => '66',
                                              'typed_declspecs' => '67',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'template_id' => '32',
                                              'datadef' => '413',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             20
                                           ],
                                 'ACTIONS' => {
                                                'TEMPLATE' => '412',
                                                'ENUM' => '60',
                                                '\';\'' => '61',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'error' => '28',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '76',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               17,
                                               2
                                             ],
                                             [
                                               18,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             21,
                                             98,
                                             130,
                                             224,
                                             238,
                                             293,
                                             501,
                                             531,
                                             542,
                                             550,
                                             888,
                                             902,
                                             958,
                                             1036,
                                             1040,
                                             1215,
                                             1261,
                                             1319,
                                             1516,
                                             1564
                                           ],
                                 'ACTIONS' => {
                                                '' => -406
                                              },
                                 'CORE' => [
                                             [
                                               406,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '414',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '415',
                                              'type_id' => '417',
                                              'type_name' => '13',
                                              'template_header' => '422',
                                              'typed_typespecs' => '423',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'template_template_parm' => '418',
                                              'typespec' => '424',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '126',
                                              'attributes' => '21',
                                              'nested_type' => '22',
                                              'template_parm_list' => '419',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '124',
                                              'named_parm' => '420',
                                              'template_type_parm' => '421',
                                              'template_parm' => '426',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '427',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'parm' => '428',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '429'
                                            },
                                 'FROM' => [
                                             23,
                                             210
                                           ],
                                 'ACTIONS' => {
                                                'TEMPLATE' => '210',
                                                'ENUM' => '60',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '416',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'TYPEOF' => '15',
                                                'NSNAME' => '127',
                                                'SIGOF' => '50',
                                                'SCSPEC' => '217',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PTYPENAME' => '123',
                                                '\'>\'' => '425'
                                              },
                                 'CORE' => [
                                             [
                                               41,
                                               2
                                             ],
                                             [
                                               42,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '430',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '431',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '26',
                                              'notype_unqualified_id' => '64',
                                              'operator' => '27',
                                              'complex_direct_notype_declarator' => '66',
                                              'typed_declspecs' => '432',
                                              'constructor_declarator' => '433',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'typed_declspecs1' => '75',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '434',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             23,
                                             412
                                           ],
                                 'ACTIONS' => {
                                                'ENUM' => '60',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '217',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               140,
                                               2
                                             ],
                                             [
                                               141,
                                               2
                                             ],
                                             [
                                               142,
                                               2
                                             ],
                                             [
                                               143,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             25
                                           ],
                                 'ACTIONS' => {
                                                '' => -22
                                              },
                                 'CORE' => [
                                             [
                                               22,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             26,
                                             124,
                                             348,
                                             584,
                                             816,
                                             959
                                           ],
                                 'ACTIONS' => {
                                                '' => -572
                                              },
                                 'CORE' => [
                                             [
                                               572,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             26,
                                             124,
                                             348,
                                             584,
                                             959
                                           ],
                                 'ACTIONS' => {
                                                '' => -575
                                              },
                                 'CORE' => [
                                             [
                                               575,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'type_name' => '250',
                                              'nested_name_specifier_1' => '252',
                                              'template_type' => '16',
                                              'self_template_type' => '437'
                                            },
                                 'FROM' => [
                                             26
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'TEMPLATE' => '307',
                                                'NSNAME' => '127',
                                                '\'*\'' => '435',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '436'
                                              },
                                 'CORE' => [
                                             [
                                               89,
                                               2
                                             ],
                                             [
                                               90,
                                               2
                                             ],
                                             [
                                               93,
                                               2
                                             ],
                                             [
                                               94,
                                               2
                                             ],
                                             [
                                               637,
                                               2
                                             ],
                                             [
                                               576,
                                               1
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -794
                                              },
                                 'CORE' => [
                                             [
                                               794,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -806
                                              },
                                 'CORE' => [
                                             [
                                               806,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -801
                                              },
                                 'CORE' => [
                                             [
                                               801,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -792
                                              },
                                 'CORE' => [
                                             [
                                               792,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '124',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'type_name' => '13',
                                              'named_class_head_sans_basetype' => '49',
                                              'nonnested_type' => '34',
                                              'template_type' => '16',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'class_head' => '18',
                                              'complete_type_name' => '38',
                                              'typespec' => '125',
                                              'nested_name_specifier' => '126',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'nested_type' => '22'
                                            },
                                 'FROM' => [
                                             27,
                                             359,
                                             624,
                                             1374,
                                             1380,
                                             1470
                                           ],
                                 'ACTIONS' => {
                                                '' => '-724',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '122',
                                                'SCOPE' => '42',
                                                'TYPEOF' => '15',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'PTYPENAME' => '123',
                                                'ENUM' => '60',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '127',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               372,
                                               1
                                             ],
                                             [
                                               374,
                                               1
                                             ],
                                             [
                                               550,
                                               1
                                             ],
                                             [
                                               724,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -812
                                              },
                                 'CORE' => [
                                             [
                                               812,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -815
                                              },
                                 'CORE' => [
                                             [
                                               815,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -790
                                              },
                                 'CORE' => [
                                             [
                                               790,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '\']\'' => '438'
                                              },
                                 'CORE' => [
                                             [
                                               818,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -809
                                              },
                                 'CORE' => [
                                             [
                                               809,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -796
                                              },
                                 'CORE' => [
                                             [
                                               796,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -814
                                              },
                                 'CORE' => [
                                             [
                                               814,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -793
                                              },
                                 'CORE' => [
                                             [
                                               793,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -799
                                              },
                                 'CORE' => [
                                             [
                                               799,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -824
                                              },
                                 'CORE' => [
                                             [
                                               824,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '\':\'' => '439'
                                              },
                                 'CORE' => [
                                             [
                                               813,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => '-820',
                                                '\'[\'' => '440'
                                              },
                                 'CORE' => [
                                             [
                                               820,
                                               2
                                             ],
                                             [
                                               822,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -811
                                              },
                                 'CORE' => [
                                             [
                                               811,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -798
                                              },
                                 'CORE' => [
                                             [
                                               798,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'ptr_to_mem' => '443',
                                              'nested_name_specifier' => '444',
                                              'nested_name_specifier_1' => '24',
                                              'conversion_declarator' => '441',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'global_scope' => '131'
                                            },
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => '-785',
                                                'SELFNAME' => '133',
                                                '\'*\'' => '442',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '123',
                                                'TYPENAME' => '132',
                                                'NSNAME' => '127',
                                                '\'&\'' => '445'
                                              },
                                 'CORE' => [
                                             [
                                               823,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27,
                                             359,
                                             624,
                                             1374,
                                             1380,
                                             1470
                                           ],
                                 'ACTIONS' => {
                                                '' => -723
                                              },
                                 'CORE' => [
                                             [
                                               723,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -817
                                              },
                                 'CORE' => [
                                             [
                                               817,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -807
                                              },
                                 'CORE' => [
                                             [
                                               807,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '234',
                                              'named_class_head_sans_basetype' => '49',
                                              'reserved_typespecquals' => '446',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'class_head' => '18',
                                              'typespecqual_reserved' => '239',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81'
                                            },
                                 'FROM' => [
                                             27,
                                             359,
                                             624
                                           ],
                                 'ACTIONS' => {
                                                '' => '-371',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '235',
                                                'TYPESPEC' => '236',
                                                'ENUM' => '60',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               371,
                                               1
                                             ],
                                             [
                                               373,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -804
                                              },
                                 'CORE' => [
                                             [
                                               804,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -808
                                              },
                                 'CORE' => [
                                             [
                                               808,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -810
                                              },
                                 'CORE' => [
                                             [
                                               810,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -802
                                              },
                                 'CORE' => [
                                             [
                                               802,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => '-819',
                                                '\'[\'' => '447'
                                              },
                                 'CORE' => [
                                             [
                                               819,
                                               2
                                             ],
                                             [
                                               821,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -816
                                              },
                                 'CORE' => [
                                             [
                                               816,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -800
                                              },
                                 'CORE' => [
                                             [
                                               800,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -797
                                              },
                                 'CORE' => [
                                             [
                                               797,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -803
                                              },
                                 'CORE' => [
                                             [
                                               803,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -795
                                              },
                                 'CORE' => [
                                             [
                                               795,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -791
                                              },
                                 'CORE' => [
                                             [
                                               791,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             27
                                           ],
                                 'ACTIONS' => {
                                                '' => -805
                                              },
                                 'CORE' => [
                                             [
                                               805,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             28
                                           ],
                                 'ACTIONS' => {
                                                '' => -75
                                              },
                                 'CORE' => [
                                             [
                                               75,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             28
                                           ],
                                 'ACTIONS' => {
                                                '' => -74
                                              },
                                 'CORE' => [
                                             [
                                               74,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             29
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '448'
                                              },
                                 'CORE' => [
                                             [
                                               407,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'template_arg_list_opt' => '449',
                                              'type_id' => '404',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'template_arg' => '407',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'template_arg_list' => '408',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '409',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             31,
                                             101,
                                             116,
                                             132,
                                             322,
                                             459,
                                             464,
                                             713,
                                             818,
                                             921,
                                             1189,
                                             1244
                                           ],
                                 'ACTIONS' => {
                                                '' => '-159',
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '405',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               151,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             31,
                                             101,
                                             132,
                                             464,
                                             713,
                                             921,
                                             1189,
                                             1244
                                           ],
                                 'ACTIONS' => {
                                                '' => -612
                                              },
                                 'CORE' => [
                                             [
                                               612,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             33,
                                             225,
                                             279
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '451',
                                                'LEFT_RIGHT' => '450'
                                              },
                                 'CORE' => [
                                             [
                                               553,
                                               1
                                             ],
                                             [
                                               554,
                                               1
                                             ],
                                             [
                                               555,
                                               1
                                             ],
                                             [
                                               556,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'nonmomentary_expr' => '454',
                                              'suspend_mom' => '452'
                                            },
                                 'FROM' => [
                                             33,
                                             225
                                           ],
                                 'ACTIONS' => {
                                                '' => '-551',
                                                '\']\'' => '453'
                                              },
                                 'CORE' => [
                                             [
                                               593,
                                               2
                                             ],
                                             [
                                               594,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'cv_qualifiers' => '455'
                                            },
                                 'FROM' => [
                                             33,
                                             225
                                           ],
                                 'ACTIONS' => {
                                                '' => -547
                                              },
                                 'CORE' => [
                                             [
                                               591,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '457',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '130',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             36
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '73',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '456',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               583,
                                               2
                                             ],
                                             [
                                               548,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'identifier' => '461',
                                              'template_type' => '458',
                                              'self_template_type' => '78'
                                            },
                                 'FROM' => [
                                             39,
                                             356,
                                             651
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '459',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '90',
                                                'PTYPENAME' => '96',
                                                'SELFNAME' => '460'
                                              },
                                 'CORE' => [
                                             [
                                               256,
                                               2
                                             ],
                                             [
                                               257,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'template_id' => '32',
                                              'any_id' => '462',
                                              'nested_name_specifier_1' => '24',
                                              'unqualified_id' => '465',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'notype_unqualified_id' => '467',
                                              'global_scope' => '463',
                                              'qualified_id' => '468',
                                              'operator' => '27',
                                              'nested_name_specifier' => '201',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             40,
                                             1193
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '464',
                                                'IDENTIFIER' => '362',
                                                'NSNAME' => '380',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '466',
                                                'PFUNCNAME' => '79',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               32,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'template_id' => '32',
                                              'nested_name_specifier_1' => '24',
                                              'unqualified_id' => '469',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'notype_unqualified_id' => '467',
                                              'qualified_id' => '470',
                                              'operator' => '27',
                                              'nested_name_specifier' => '201',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             40,
                                             391
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '464',
                                                'IDENTIFIER' => '362',
                                                'NSNAME' => '380',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '466',
                                                'PFUNCNAME' => '79',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               27,
                                               2
                                             ],
                                             [
                                               28,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'template_id' => '32',
                                              'object_template_id' => '471',
                                              'nested_name_specifier_1' => '252',
                                              'unqualified_id' => '472',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'notype_unqualified_id' => '467',
                                              'operator' => '27',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             40,
                                             199,
                                             200,
                                             303,
                                             391,
                                             463
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '464',
                                                'TEMPLATE' => '251',
                                                'IDENTIFIER' => '362',
                                                'NSNAME' => '380',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '466',
                                                'PFUNCNAME' => '79',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               597,
                                               1
                                             ],
                                             [
                                               598,
                                               1
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             40,
                                             391
                                           ],
                                 'ACTIONS' => {
                                                '' => -26
                                              },
                                 'CORE' => [
                                             [
                                               26,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'template_arg_list_opt' => '473',
                                              'type_id' => '404',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'template_arg' => '407',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'template_arg_list' => '408',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '409',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             41,
                                             105,
                                             118,
                                             133,
                                             254,
                                             323,
                                             392,
                                             436,
                                             460,
                                             466,
                                             821,
                                             922,
                                             1194,
                                             1240
                                           ],
                                 'ACTIONS' => {
                                                '' => '-159',
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '405',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               155,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             41,
                                             105,
                                             133,
                                             254,
                                             392,
                                             436,
                                             466,
                                             922,
                                             1194,
                                             1240
                                           ],
                                 'ACTIONS' => {
                                                '' => -613
                                              },
                                 'CORE' => [
                                             [
                                               613,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             43,
                                             301
                                           ],
                                 'ACTIONS' => {
                                                '' => -4
                                              },
                                 'CORE' => [
                                             [
                                               4,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45,
                                             216,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                '' => '-377',
                                                '\';\'' => '474'
                                              },
                                 'CORE' => [
                                             [
                                               67,
                                               1
                                             ],
                                             [
                                               377,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'eat_saved_input' => '475'
                                            },
                                 'FROM' => [
                                             45,
                                             216
                                           ],
                                 'ACTIONS' => {
                                                '' => '-82',
                                                'END_OF_SAVED_INPUT' => '137'
                                              },
                                 'CORE' => [
                                             [
                                               58,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45,
                                             216
                                           ],
                                 'ACTIONS' => {
                                                '' => -60
                                              },
                                 'CORE' => [
                                             [
                                               60,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'dot_hush_warning' => '476'
                                            },
                                 'FROM' => [
                                             45,
                                             216
                                           ],
                                 'ACTIONS' => {
                                                '' => '-7',
                                                'EXTERN_LANG_STRING' => '144'
                                              },
                                 'CORE' => [
                                             [
                                               40,
                                               1
                                             ],
                                             [
                                               61,
                                               1
                                             ],
                                             [
                                               62,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45,
                                             141,
                                             147,
                                             216,
                                             394,
                                             395,
                                             401,
                                             696,
                                             744,
                                             1009
                                           ],
                                 'ACTIONS' => {
                                                '\'<\'' => '147'
                                              },
                                 'CORE' => [
                                             [
                                               41,
                                               1
                                             ],
                                             [
                                               42,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45
                                           ],
                                 'ACTIONS' => {
                                                '' => -57
                                              },
                                 'CORE' => [
                                             [
                                               57,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45
                                           ],
                                 'ACTIONS' => {
                                                '' => -56
                                              },
                                 'CORE' => [
                                             [
                                               56,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45,
                                             216
                                           ],
                                 'ACTIONS' => {
                                                '' => -59
                                              },
                                 'CORE' => [
                                             [
                                               59,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator' => '274',
                                              'declarator' => '269',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'initdcl0' => '276',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'after_type_declarator' => '277',
                                              'type_name' => '268',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '270',
                                              'direct_after_type_declarator' => '279',
                                              'initdecls' => '477',
                                              'nested_name_specifier' => '273',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             45,
                                             216,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '278',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '272',
                                                '\'*\'' => '267',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               66,
                                               1
                                             ],
                                             [
                                               95,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45,
                                             216,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                '\';\'' => '478',
                                                '\',\'' => '280'
                                              },
                                 'CORE' => [
                                             [
                                               64,
                                               1
                                             ],
                                             [
                                               392,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '206',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'fndef' => '207',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '208',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'template_datadef' => '213',
                                              'typespec' => '53',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '209',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '214',
                                              'nomods_initdecls' => '215',
                                              'constructor_declarator' => '69',
                                              'extension' => '216',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'template_extdef' => '479',
                                              'declmods' => '218',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             45,
                                             216
                                           ],
                                 'ACTIONS' => {
                                                'TEMPLATE' => '210',
                                                'ENUM' => '60',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '217',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTERN_LANG_STRING' => '51',
                                                'EXTENSION' => '37',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               63,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             45,
                                             141,
                                             147,
                                             148,
                                             216,
                                             394,
                                             395,
                                             401,
                                             451,
                                             476,
                                             526,
                                             528,
                                             565,
                                             590,
                                             641,
                                             696,
                                             700,
                                             726,
                                             744,
                                             751,
                                             764,
                                             766,
                                             780,
                                             898,
                                             952,
                                             962,
                                             1009,
                                             1042,
                                             1073,
                                             1181,
                                             1201,
                                             1208,
                                             1212,
                                             1217,
                                             1264,
                                             1280,
                                             1363,
                                             1367,
                                             1375,
                                             1388,
                                             1390,
                                             1446,
                                             1468,
                                             1517,
                                             1549,
                                             1569,
                                             1590
                                           ],
                                 'ACTIONS' => {
                                                '' => -366
                                              },
                                 'CORE' => [
                                             [
                                               366,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'notype_initdecls' => '480',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '295',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'attributes' => '293',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '296',
                                              'nested_name_specifier_1' => '24',
                                              'global_scope' => '26',
                                              'notype_unqualified_id' => '64',
                                              'operator' => '27',
                                              'complex_direct_notype_declarator' => '66',
                                              'constructor_declarator' => '298',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'notype_initdcl0' => '294',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             45,
                                             216,
                                             476
                                           ],
                                 'ACTIONS' => {
                                                'ENUM' => '60',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '292',
                                                'SCOPE' => '42',
                                                'ATTRIBUTE' => '29',
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                '\'&\'' => '73',
                                                'SCSPEC' => '299',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               65,
                                               1
                                             ],
                                             [
                                               96,
                                               1
                                             ],
                                             [
                                               98,
                                               1
                                             ],
                                             [
                                               354,
                                               1
                                             ],
                                             [
                                               357,
                                               1
                                             ],
                                             [
                                               358,
                                               1
                                             ],
                                             [
                                               359,
                                               1
                                             ],
                                             [
                                               367,
                                               1
                                             ],
                                             [
                                               368,
                                               1
                                             ],
                                             [
                                               369,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'template_arg_list_opt' => '481',
                                              'type_id' => '404',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'template_arg' => '407',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'template_arg_list' => '408',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '409',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             46,
                                             716,
                                             1246
                                           ],
                                 'ACTIONS' => {
                                                '' => '-159',
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '405',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               278,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             49
                                           ],
                                 'ACTIONS' => {
                                                '' => -466
                                              },
                                 'CORE' => [
                                             [
                                               466,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             49
                                           ],
                                 'ACTIONS' => {
                                                '' => -465
                                              },
                                 'CORE' => [
                                             [
                                               465,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'type_id' => '482',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'expr' => '483',
                                              'nontrivial_exprlist' => '351',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '384',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             50
                                           ],
                                 'ACTIONS' => {
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '19',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               382,
                                               2
                                             ],
                                             [
                                               383,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'expr_or_declarator' => '230',
                                              'complex_notype_declarator' => '485',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '231',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '232',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '484',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '225',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '226',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '224',
                                              'expr_or_declarator_intern' => '486',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '233',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '228',
                                                'CV_QUALIFIER' => '10',
                                                '\'*\'' => '223',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               275,
                                               1
                                             ],
                                             [
                                               585,
                                               1
                                             ],
                                             [
                                               587,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'expr_or_declarator' => '490',
                                              'operator' => '27',
                                              'attribute' => '146',
                                              'template_id' => '32',
                                              'notype_unqualified_id' => '491',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233,
                                             364,
                                             487,
                                             489,
                                             493,
                                             602,
                                             618,
                                             622,
                                             631,
                                             636,
                                             640,
                                             908
                                           ],
                                 'ACTIONS' => {
                                                'IDENTIFIER' => '362',
                                                'NSNAME' => '492',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '493',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '489',
                                                '\'*\'' => '487',
                                                'PTYPENAME' => '488',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               273,
                                               1
                                             ],
                                             [
                                               406,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'suspend_mom' => '194',
                                              'maybe_parmlist' => '196'
                                            },
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233,
                                             272,
                                             549,
                                             552,
                                             554,
                                             751,
                                             1038,
                                             1042,
                                             1044,
                                             1073,
                                             1279,
                                             1280,
                                             1283,
                                             1379,
                                             1487,
                                             1488,
                                             1489
                                           ],
                                 'ACTIONS' => {
                                                '' => '-551',
                                                '\'[\'' => '195'
                                              },
                                 'CORE' => [
                                             [
                                               591,
                                               1
                                             ],
                                             [
                                               593,
                                               1
                                             ],
                                             [
                                               594,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'cv_qualifiers' => '494'
                                            },
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233
                                           ],
                                 'ACTIONS' => {
                                                '' => -547
                                              },
                                 'CORE' => [
                                             [
                                               589,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             52,
                                             228,
                                             272,
                                             552,
                                             751,
                                             1042,
                                             1073,
                                             1280,
                                             1379,
                                             1488
                                           ],
                                 'ACTIONS' => {
                                                '\')\'' => '495'
                                              },
                                 'CORE' => [
                                             [
                                               592,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'expr_or_declarator' => '230',
                                              'complex_notype_declarator' => '227',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '231',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '232',
                                              'attribute' => '7',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '225',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '226',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '224',
                                              'expr_or_declarator_intern' => '496',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '233',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '228',
                                                '\'*\'' => '223',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               277,
                                               1
                                             ],
                                             [
                                               283,
                                               1
                                             ],
                                             [
                                               592,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             52,
                                             272,
                                             751
                                           ],
                                 'ACTIONS' => {
                                                '\')\'' => '497'
                                              },
                                 'CORE' => [
                                             [
                                               283,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233,
                                             272,
                                             364,
                                             487,
                                             489,
                                             493,
                                             549,
                                             552,
                                             554,
                                             602,
                                             618,
                                             622,
                                             631,
                                             636,
                                             640,
                                             641,
                                             751,
                                             859,
                                             861,
                                             863,
                                             908,
                                             957,
                                             962,
                                             965,
                                             1038,
                                             1042,
                                             1044,
                                             1073,
                                             1216,
                                             1217,
                                             1218,
                                             1262,
                                             1264,
                                             1265,
                                             1279,
                                             1280,
                                             1283,
                                             1379,
                                             1487,
                                             1488,
                                             1489
                                           ],
                                 'ACTIONS' => {
                                                '' => -272
                                              },
                                 'CORE' => [
                                             [
                                               272,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233,
                                             272,
                                             549,
                                             552,
                                             554,
                                             751,
                                             1038,
                                             1042,
                                             1044
                                           ],
                                 'ACTIONS' => {
                                                '' => '-281',
                                                '\')\'' => -274
                                              },
                                 'CORE' => [
                                             [
                                               274,
                                               1
                                             ],
                                             [
                                               281,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233,
                                             272,
                                             549,
                                             552,
                                             554,
                                             751,
                                             1038,
                                             1042,
                                             1044,
                                             1073,
                                             1279,
                                             1280,
                                             1283,
                                             1379,
                                             1487,
                                             1488,
                                             1489
                                           ],
                                 'ACTIONS' => {
                                                '' => '-280',
                                                '\')\'' => -590
                                              },
                                 'CORE' => [
                                             [
                                               280,
                                               1
                                             ],
                                             [
                                               590,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'expr_or_declarator' => '230',
                                              'complex_notype_declarator' => '499',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '231',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '232',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '498',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '225',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '226',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '224',
                                              'expr_or_declarator_intern' => '500',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             52,
                                             223,
                                             228,
                                             233
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '233',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '228',
                                                'CV_QUALIFIER' => '10',
                                                '\'*\'' => '223',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               276,
                                               1
                                             ],
                                             [
                                               586,
                                               1
                                             ],
                                             [
                                               588,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             53,
                                             125,
                                             176,
                                             237,
                                             240,
                                             295,
                                             327,
                                             365,
                                             424,
                                             430,
                                             446,
                                             504,
                                             569,
                                             570,
                                             788,
                                             873,
                                             879,
                                             914,
                                             1199,
                                             1482
                                           ],
                                 'ACTIONS' => {
                                                '' => -386
                                              },
                                 'CORE' => [
                                             [
                                               386,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             53,
                                             125,
                                             176,
                                             237,
                                             240,
                                             295,
                                             327,
                                             365,
                                             424,
                                             430,
                                             446,
                                             504,
                                             569,
                                             570,
                                             788,
                                             873,
                                             879,
                                             914,
                                             1199,
                                             1482
                                           ],
                                 'ACTIONS' => {
                                                '' => -385
                                              },
                                 'CORE' => [
                                             [
                                               385,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             53,
                                             125,
                                             176,
                                             237,
                                             240,
                                             295,
                                             327,
                                             365,
                                             424,
                                             430,
                                             446,
                                             504,
                                             569,
                                             570,
                                             788,
                                             873,
                                             879,
                                             914,
                                             1199,
                                             1482
                                           ],
                                 'ACTIONS' => {
                                                '' => -384
                                              },
                                 'CORE' => [
                                             [
                                               384,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '234',
                                              'named_class_head_sans_basetype' => '49',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'class_head' => '18',
                                              'typespecqual_reserved' => '502',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'attributes' => '501'
                                            },
                                 'FROM' => [
                                             53,
                                             424,
                                             430,
                                             788,
                                             873,
                                             1199
                                           ],
                                 'ACTIONS' => {
                                                '' => '-355',
                                                'ENUM' => '60',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '235',
                                                'ATTRIBUTE' => '29',
                                                'SCSPEC' => '503',
                                                'TYPESPEC' => '236',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               355,
                                               2
                                             ],
                                             [
                                               361,
                                               1
                                             ],
                                             [
                                               362,
                                               1
                                             ],
                                             [
                                               363,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'attribute' => '146'
                                            },
                                 'FROM' => [
                                             53,
                                             240,
                                             295,
                                             424,
                                             430,
                                             570,
                                             788,
                                             873,
                                             1199
                                           ],
                                 'ACTIONS' => {
                                                '' => '-364',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               364,
                                               1
                                             ],
                                             [
                                               406,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             53,
                                             125,
                                             176,
                                             295,
                                             365,
                                             424,
                                             430,
                                             788,
                                             873,
                                             914,
                                             1199,
                                             1482
                                           ],
                                 'ACTIONS' => {
                                                '' => -375
                                              },
                                 'CORE' => [
                                             [
                                               375,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '234',
                                              'named_class_head_sans_basetype' => '49',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'reserved_declspecs' => '504',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'class_head' => '18',
                                              'typespecqual_reserved' => '505',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'attributes' => '238'
                                            },
                                 'FROM' => [
                                             53,
                                             424,
                                             430,
                                             788,
                                             873,
                                             1199
                                           ],
                                 'ACTIONS' => {
                                                '' => '-373',
                                                'ENUM' => '60',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '235',
                                                'ATTRIBUTE' => '29',
                                                'SCSPEC' => '241',
                                                'TYPESPEC' => '236',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               356,
                                               2
                                             ],
                                             [
                                               373,
                                               2
                                             ],
                                             [
                                               376,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             53,
                                             240,
                                             295,
                                             424,
                                             430,
                                             570,
                                             788,
                                             873,
                                             1199
                                           ],
                                 'ACTIONS' => {
                                                '' => -360
                                              },
                                 'CORE' => [
                                             [
                                               360,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'see_typename' => '506'
                                            },
                                 'FROM' => [
                                             54,
                                             74
                                           ],
                                 'ACTIONS' => {
                                                '' => -776
                                              },
                                 'CORE' => [
                                             [
                                               479,
                                               1
                                             ],
                                             [
                                               480,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             54
                                           ],
                                 'ACTIONS' => {
                                                '' => -474
                                              },
                                 'CORE' => [
                                             [
                                               474,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'string' => '507'
                                            },
                                 'FROM' => [
                                             55
                                           ],
                                 'ACTIONS' => {
                                                'STRING' => '349'
                                              },
                                 'CORE' => [
                                             [
                                               15,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             56,
                                             1506
                                           ],
                                 'ACTIONS' => {
                                                '' => '-80',
                                                '\';\'' => '508'
                                              },
                                 'CORE' => [
                                             [
                                               80,
                                               1
                                             ],
                                             [
                                               81,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'base_init' => '515',
                                              'nodecls' => '511',
                                              'function_try_block' => '513',
                                              'ctor_initializer_opt' => '514'
                                            },
                                 'FROM' => [
                                             56
                                           ],
                                 'ACTIONS' => {
                                                '\':\'' => '509',
                                                '\'{\'' => -334,
                                                'error' => '512',
                                                'TRY' => '510'
                                              },
                                 'CORE' => [
                                             [
                                               84,
                                               2
                                             ],
                                             [
                                               85,
                                               2
                                             ],
                                             [
                                               86,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'maybe_init' => '518'
                                            },
                                 'FROM' => [
                                             56,
                                             1506
                                           ],
                                 'ACTIONS' => {
                                                '' => '-421',
                                                'LEFT_RIGHT' => '516',
                                                '\'=\'' => '519',
                                                '\'(\'' => '517'
                                              },
                                 'CORE' => [
                                             [
                                               112,
                                               1
                                             ],
                                             [
                                               113,
                                               1
                                             ],
                                             [
                                               114,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             56,
                                             1506
                                           ],
                                 'ACTIONS' => {
                                                'IDENTIFIER' => '520'
                                              },
                                 'CORE' => [
                                             [
                                               111,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             134,
                                             273,
                                             444,
                                             591,
                                             717,
                                             757,
                                             862,
                                             963,
                                             1043,
                                             1425
                                           ],
                                 'ACTIONS' => {
                                                '' => -636
                                              },
                                 'CORE' => [
                                             [
                                               636,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             126,
                                             152,
                                             368,
                                             591,
                                             757,
                                             892,
                                             963,
                                             1219
                                           ],
                                 'ACTIONS' => {
                                                '' => -576
                                              },
                                 'CORE' => [
                                             [
                                               576,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'operator' => '27',
                                              'identifier' => '522',
                                              'explicit_template_type' => '521',
                                              'operator_name' => '523'
                                            },
                                 'FROM' => [
                                             57,
                                             134,
                                             201,
                                             273,
                                             368,
                                             654,
                                             717,
                                             757,
                                             963,
                                             1043,
                                             1219
                                           ],
                                 'ACTIONS' => {
                                                'PFUNCNAME' => '524',
                                                'TYPENAME' => '85',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '90',
                                                'OPERATOR' => '48',
                                                'PTYPENAME' => '84',
                                                'SELFNAME' => '87'
                                              },
                                 'CORE' => [
                                             [
                                               611,
                                               2
                                             ],
                                             [
                                               266,
                                               1
                                             ],
                                             [
                                               267,
                                               1
                                             ],
                                             [
                                               268,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             107,
                                             126,
                                             134,
                                             152,
                                             201,
                                             273,
                                             305,
                                             330,
                                             368,
                                             444,
                                             591,
                                             654,
                                             717,
                                             757,
                                             862,
                                             892,
                                             963,
                                             1015,
                                             1043,
                                             1219,
                                             1425
                                           ],
                                 'ACTIONS' => {
                                                '' => -610
                                              },
                                 'CORE' => [
                                             [
                                               610,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             134,
                                             273,
                                             368,
                                             654,
                                             717,
                                             757,
                                             963,
                                             1043,
                                             1219
                                           ],
                                 'ACTIONS' => {
                                                '' => -600
                                              },
                                 'CORE' => [
                                             [
                                               600,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             717
                                           ],
                                 'ACTIONS' => {
                                                '' => '-607',
                                                '\'<\'' => '203',
                                                'SCOPE' => '204',
                                                'LEFT_RIGHT' => '525',
                                                '\'(\'' => '526'
                                              },
                                 'CORE' => [
                                             [
                                               87,
                                               2
                                             ],
                                             [
                                               88,
                                               2
                                             ],
                                             [
                                               155,
                                               1
                                             ],
                                             [
                                               607,
                                               1
                                             ],
                                             [
                                               613,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             134,
                                             273,
                                             717,
                                             757,
                                             1043
                                           ],
                                 'ACTIONS' => {
                                                '' => -596
                                              },
                                 'CORE' => [
                                             [
                                               596,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             134,
                                             273,
                                             368,
                                             654,
                                             717,
                                             757,
                                             963,
                                             1043,
                                             1219
                                           ],
                                 'ACTIONS' => {
                                                '' => -599
                                              },
                                 'CORE' => [
                                             [
                                               599,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             57,
                                             717
                                           ],
                                 'ACTIONS' => {
                                                '' => '-152',
                                                'LEFT_RIGHT' => '527',
                                                '\'(\'' => '528'
                                              },
                                 'CORE' => [
                                             [
                                               91,
                                               2
                                             ],
                                             [
                                               92,
                                               2
                                             ],
                                             [
                                               152,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'do_id' => '529'
                                            },
                                 'FROM' => [
                                             58,
                                             610
                                           ],
                                 'ACTIONS' => {
                                                '' => -263
                                              },
                                 'CORE' => [
                                             [
                                               265,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'attribute' => '7',
                                              'initdcl0_innards' => '532',
                                              'attributes' => '531',
                                              'maybe_attribute' => '530'
                                            },
                                 'FROM' => [
                                             59
                                           ],
                                 'ACTIONS' => {
                                                '' => '-403',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               401,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             59,
                                             69,
                                             269,
                                             296,
                                             396,
                                             399,
                                             400,
                                             560,
                                             718,
                                             719,
                                             720,
                                             729,
                                             730,
                                             731,
                                             1247,
                                             1249,
                                             1377,
                                             1397,
                                             1547
                                           ],
                                 'ACTIONS' => {
                                                '\'(\'' => '533'
                                              },
                                 'CORE' => [
                                             [
                                               394,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             60
                                           ],
                                 'ACTIONS' => {
                                                '' => -634
                                              },
                                 'CORE' => [
                                             [
                                               634,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'type_name' => '534',
                                              'nested_name_specifier' => '126',
                                              'nested_name_specifier_1' => '24',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'nested_type' => '535'
                                            },
                                 'FROM' => [
                                             60
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'NSNAME' => '127',
                                                'PTYPENAME' => '123',
                                                'SELFNAME' => '41'
                                              },
                                 'CORE' => [
                                             [
                                               633,
                                               1
                                             ],
                                             [
                                               635,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'enumlist' => '538',
                                              'identifier' => '539',
                                              'enumerator' => '537'
                                            },
                                 'FROM' => [
                                             60
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '85',
                                                '\'}\'' => '536',
                                                'IDENTIFIER' => '89',
                                                'NSNAME' => '90',
                                                'PTYPENAME' => '84',
                                                'SELFNAME' => '87'
                                              },
                                 'CORE' => [
                                             [
                                               446,
                                               2
                                             ],
                                             [
                                               447,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             60
                                           ],
                                 'ACTIONS' => {
                                                '' => '-448',
                                                '\'{\'' => '540'
                                              },
                                 'CORE' => [
                                             [
                                               444,
                                               2
                                             ],
                                             [
                                               445,
                                               2
                                             ],
                                             [
                                               448,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             60
                                           ],
                                 'ACTIONS' => {
                                                '' => -449
                                              },
                                 'CORE' => [
                                             [
                                               449,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             62
                                           ],
                                 'ACTIONS' => {
                                                '' => -72
                                              },
                                 'CORE' => [
                                             [
                                               72,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '135',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '541',
                                              'operator' => '27',
                                              'after_type_declarator' => '544',
                                              'type_name' => '268',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '270',
                                              'direct_after_type_declarator' => '279',
                                              'nested_name_specifier' => '273',
                                              'attributes' => '542',
                                              'after_type_declarator_intern' => '543',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             278,
                                             280,
                                             398,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             567,
                                             706,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1199,
                                             1206,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '278',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '272',
                                                '\'*\'' => '267',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               559,
                                               1
                                             ],
                                             [
                                               561,
                                               1
                                             ],
                                             [
                                               579,
                                               1
                                             ],
                                             [
                                               581,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             272,
                                             278,
                                             280,
                                             398,
                                             423,
                                             424,
                                             427,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             567,
                                             706,
                                             748,
                                             752,
                                             788,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1044,
                                             1045,
                                             1120,
                                             1121,
                                             1122,
                                             1199,
                                             1206,
                                             1260,
                                             1261,
                                             1262,
                                             1265,
                                             1266,
                                             1268,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1423,
                                             1424,
                                             1426,
                                             1481,
                                             1515,
                                             1516,
                                             1518,
                                             1564
                                           ],
                                 'ACTIONS' => {
                                                '' => -570
                                              },
                                 'CORE' => [
                                             [
                                               570,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'asm_keyword' => '260',
                                              'maybeasm' => '545'
                                            },
                                 'FROM' => [
                                             67,
                                             214
                                           ],
                                 'ACTIONS' => {
                                                '' => '-95',
                                                '\';\'' => -393,
                                                '\',\'' => -393,
                                                '\'=\'' => -393,
                                                'ASM_KEYWORD' => '65',
                                                'ATTRIBUTE' => -393
                                              },
                                 'CORE' => [
                                             [
                                               95,
                                               2
                                             ],
                                             [
                                               399,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'cv_qualifiers' => '546'
                                            },
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             278,
                                             280,
                                             398,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             567,
                                             706,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1199,
                                             1206,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -547
                                              },
                                 'CORE' => [
                                             [
                                               563,
                                               1
                                             ],
                                             [
                                               583,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             67
                                           ],
                                 'ACTIONS' => {
                                                '\';\'' => '548',
                                                '\',\'' => '547'
                                              },
                                 'CORE' => [
                                             [
                                               70,
                                               2
                                             ],
                                             [
                                               388,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'expr_or_declarator' => '230',
                                              'complex_notype_declarator' => '227',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '231',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '232',
                                              'attribute' => '7',
                                              'operator' => '27',
                                              'after_type_declarator' => '544',
                                              'type_name' => '268',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '225',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '551',
                                              'direct_after_type_declarator' => '279',
                                              'nested_name_specifier' => '273',
                                              'attributes' => '550',
                                              'after_type_declarator_intern' => '553',
                                              'expr_or_declarator_intern' => '229',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             278,
                                             280,
                                             398,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             567,
                                             706,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1206,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '554',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '552',
                                                '\'*\'' => '549',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               283,
                                               1
                                             ],
                                             [
                                               568,
                                               1
                                             ],
                                             [
                                               592,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_template_declarator' => '255',
                                              'type_name' => '555',
                                              'template_id' => '32',
                                              'object_template_id' => '253',
                                              'nested_name_specifier_1' => '252',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'notype_unqualified_id' => '256',
                                              'operator' => '27',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             272,
                                             278,
                                             280,
                                             423,
                                             424,
                                             427,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             552,
                                             554,
                                             556,
                                             567,
                                             748,
                                             752,
                                             788,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1044,
                                             1045,
                                             1199,
                                             1206,
                                             1260,
                                             1266,
                                             1268,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'TEMPLATE' => '251',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'*\'' => '249',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               569,
                                               1
                                             ],
                                             [
                                               596,
                                               1
                                             ],
                                             [
                                               599,
                                               1
                                             ],
                                             [
                                               600,
                                               1
                                             ],
                                             [
                                               610,
                                               1
                                             ],
                                             [
                                               611,
                                               1
                                             ],
                                             [
                                               636,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             67,
                                             214,
                                             280,
                                             423,
                                             424,
                                             427,
                                             432,
                                             547,
                                             567,
                                             788,
                                             875,
                                             1199,
                                             1206,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -344
                                              },
                                 'CORE' => [
                                             [
                                               344,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             67
                                           ],
                                 'ACTIONS' => {
                                                '' => -73
                                              },
                                 'CORE' => [
                                             [
                                               73,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             67,
                                             214,
                                             1199,
                                             1206
                                           ],
                                 'ACTIONS' => {
                                                '' => -387
                                              },
                                 'CORE' => [
                                             [
                                               387,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             67,
                                             214,
                                             280,
                                             423,
                                             424,
                                             427,
                                             432,
                                             547,
                                             567,
                                             788,
                                             875,
                                             1199,
                                             1206,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                '' => -343
                                              },
                                 'CORE' => [
                                             [
                                               343,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '287',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '556',
                                              'operator' => '27',
                                              'after_type_declarator' => '544',
                                              'type_name' => '268',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '270',
                                              'direct_after_type_declarator' => '279',
                                              'nested_name_specifier' => '273',
                                              'attributes' => '542',
                                              'after_type_declarator_intern' => '557',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             278,
                                             280,
                                             398,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             556,
                                             567,
                                             706,
                                             858,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1199,
                                             1206,
                                             1481
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '278',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '272',
                                                '\'*\'' => '267',
                                                'CV_QUALIFIER' => '10',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               560,
                                               1
                                             ],
                                             [
                                               562,
                                               1
                                             ],
                                             [
                                               580,
                                               1
                                             ],
                                             [
                                               582,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'suspend_mom' => '194',
                                              'maybe_parmlist' => '559'
                                            },
                                 'FROM' => [
                                             67,
                                             214,
                                             267,
                                             272,
                                             278,
                                             280,
                                             398,
                                             423,
                                             424,
                                             427,
                                             432,
                                             541,
                                             542,
                                             546,
                                             547,
                                             549,
                                             550,
                                             552,
                                             554,
                                             556,
                                             567,
                                             706,
                                             748,
                                             751,
                                             752,
                                             788,
                                             858,
                                             859,
                                             861,
                                             863,
                                             864,
                                             866,
                                             875,
                                             1017,
                                             1035,
                                             1036,
                                             1037,
                                             1038,
                                             1040,
                                             1042,
                                             1044,
                                             1045,
                                             1073,
                                             1120,
                                             1121,
                                             1122,
                                             1199,
                                             1206,
                                             1260,
                                             1261,
                                             1262,
                                             1264,
                                             1265,
                                             1266,
                                             1268,
                                             1279,
                                             1280,
                                             1283,
                                             1318,
                                             1319,
                                             1320,
                                             1321,
                                             1379,
                                             1423,
                                             1424,
                                             1426,
                                             1481,
                                             1487,
                                             1488,
                                             1489,
                                             1515,
                                             1516,
                                             1517,
                                             1518,
                                             1564
                                           ],
                                 'ACTIONS' => {
                                                '' => '-564',
                                                '\'[\'' => '558',
                                                'LEFT_RIGHT' => -551,
                                                '\'(\'' => -551
                                              },
                                 'CORE' => [
                                             [
                                               564,
                                               1
                                             ],
                                             [
                                               565,
                                               1
                                             ],
                                             [
                                               566,
                                               1
                                             ],
                                             [
                                               567,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator' => '274',
                                              'declarator' => '560',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'initdcl' => '561',
                                              'after_type_declarator' => '277',
                                              'type_name' => '268',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '16',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '270',
                                              'direct_after_type_declarator' => '279',
                                              'nested_name_specifier' => '273',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             68,
                                             215
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '31',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '278',
                                                'SELFNAME' => '41',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '272',
                                                '\'*\'' => '267',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19'
                                              },
                                 'CORE' => [
                                             [
                                               392,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             68
                                           ],
                                 'ACTIONS' => {
                                                '' => -68
                                              },
                                 'CORE' => [
                                             [
                                               68,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'attribute' => '7',
                                              'attributes' => '531',
                                              'maybe_attribute' => '562'
                                            },
                                 'FROM' => [
                                             69
                                           ],
                                 'ACTIONS' => {
                                                '' => '-403',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               402,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             70
                                           ],
                                 'ACTIONS' => {
                                                '' => -24
                                              },
                                 'CORE' => [
                                             [
                                               24,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'regcast_or_absdcl' => '355',
                                              'structsp' => '1',
                                              'string' => '332',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'nonempty_cv_qualifiers' => '334',
                                              'type_id' => '404',
                                              'new' => '359',
                                              'functional_cast' => '360',
                                              'type_name' => '13',
                                              'overqualified_id' => '361',
                                              'typed_typespecs' => '363',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'template_arg' => '407',
                                              'class_head' => '18',
                                              'typespec' => '365',
                                              'cast_expr' => '366',
                                              'boolean_dot_literal' => '343',
                                              'unary_expr' => '344',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'nested_name_specifier' => '368',
                                              'delete' => '345',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'object' => '372',
                                              'unop' => '374',
                                              'primary' => '375',
                                              'nested_name_specifier_1' => '24',
                                              'template_arg_list' => '563',
                                              'notype_unqualified_id' => '376',
                                              'global_scope' => '348',
                                              'operator' => '27',
                                              'extension' => '378',
                                              'template_id' => '32',
                                              'nonnested_type' => '34',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'self_template_type' => '78',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'expr_no_commas' => '409',
                                              'notype_qualified_id' => '383'
                                            },
                                 'FROM' => [
                                             72
                                           ],
                                 'ACTIONS' => {
                                                'CONST_CAST' => '354',
                                                '\'-\'' => '331',
                                                '\'~\'' => '356',
                                                'DYNAMIC_CAST' => '357',
                                                'SELFNAME' => '41',
                                                'CONSTANT' => '333',
                                                'SIZEOF' => '358',
                                                'TYPENAME_KEYWORD' => '6',
                                                '\'!\'' => '335',
                                                'CV_QUALIFIER' => '336',
                                                '\'*\'' => '337',
                                                'SCOPE' => '42',
                                                'THROW' => '339',
                                                'ALIGNOF' => '340',
                                                'IDENTIFIER' => '362',
                                                'TYPEOF' => '15',
                                                'OPERATOR' => '48',
                                                'SIGOF' => '50',
                                                'TYPESPEC' => '17',
                                                '\'(\'' => '364',
                                                'CXX_FALSE' => '341',
                                                'MINUSMINUS' => '342',
                                                'PLUSPLUS' => '367',
                                                'PTYPENAME' => '405',
                                                'ANDAND' => '369',
                                                'IMAGPART' => '346',
                                                'REINTERPRET_CAST' => '370',
                                                'REALPART' => '373',
                                                'NEW' => '371',
                                                'ENUM' => '60',
                                                '\'+\'' => '347',
                                                'STRING' => '349',
                                                'STATIC_CAST' => '350',
                                                'TYPENAME' => '31',
                                                'NSNAME' => '380',
                                                'TYPEID' => '379',
                                                'DELETE' => '352',
                                                '\'&\'' => '381',
                                                'AGGR' => '35',
                                                'PFUNCNAME' => '79',
                                                'EXTENSION' => '37',
                                                'THIS' => '353',
                                                'CXX_TRUE' => '382'
                                              },
                                 'CORE' => [
                                             [
                                               279,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             72,
                                             108,
                                             127,
                                             380,
                                             925
                                           ],
                                 'ACTIONS' => {
                                                '' => -614
                                              },
                                 'CORE' => [
                                             [
                                               614,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'notype_declarator_intern' => '564',
                                              'notype_declarator' => '136',
                                              'nested_name_specifier_1' => '24',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '131',
                                              'complex_direct_notype_declarator' => '66',
                                              'attribute' => '7',
                                              'operator' => '27',
                                              'notype_template_declarator' => '44',
                                              'template_id' => '32',
                                              'direct_notype_declarator' => '33',
                                              'template_type' => '129',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nested_name_specifier' => '134',
                                              'attributes' => '130',
                                              'notype_qualified_id' => '82',
                                              'operator_name' => '58'
                                            },
                                 'FROM' => [
                                             73
                                           ],
                                 'ACTIONS' => {
                                                'TYPENAME' => '132',
                                                'IDENTIFIER' => '46',
                                                'NSNAME' => '72',
                                                'OPERATOR' => '48',
                                                '\'~\'' => '39',
                                                '\'&\'' => '73',
                                                'SELFNAME' => '133',
                                                'PFUNCNAME' => '79',
                                                '\'(\'' => '52',
                                                '\'*\'' => '9',
                                                'CV_QUALIFIER' => '122',
                                                'SCOPE' => '42',
                                                'PTYPENAME' => '19',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               580,
                                               2
                                             ],
                                             [
                                               550,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             73,
                                             278,
                                             752
                                           ],
                                 'ACTIONS' => {
                                                '' => -582
                                              },
                                 'CORE' => [
                                             [
                                               582,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             74
                                           ],
                                 'ACTIONS' => {
                                                '' => -473
                                              },
                                 'CORE' => [
                                             [
                                               473,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'begin_explicit_instantiation' => '565'
                                            },
                                 'FROM' => [
                                             76
                                           ],
                                 'ACTIONS' => {
                                                '' => -148
                                              },
                                 'CORE' => [
                                             [
                                               144,
                                               2
                                             ],
                                             [
                                               145,
                                               2
                                             ],
                                             [
                                               146,
                                               2
                                             ],
                                             [
                                               147,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'do_id' => '566'
                                            },
                                 'FROM' => [
                                             79
                                           ],
                                 'ACTIONS' => {
                                                '' => -263
                                              },
                                 'CORE' => [
                                             [
                                               264,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             83
                                           ],
                                 'ACTIONS' => {
                                                '\';\'' => '568',
                                                '\',\'' => '567'
                                              },
                                 'CORE' => [
                                             [
                                               69,
                                               2
                                             ],
                                             [
                                               390,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             83,
                                             218,
                                             403,
                                             429,
                                             434,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                '' => -367
                                              },
                                 'CORE' => [
                                             [
                                               367,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'attribute' => '146'
                                            },
                                 'FROM' => [
                                             83,
                                             218,
                                             403,
                                             429,
                                             434,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                '' => '-369',
                                                'ATTRIBUTE' => '29'
                                              },
                                 'CORE' => [
                                             [
                                               369,
                                               2
                                             ],
                                             [
                                               406,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             83,
                                             218,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                '' => -389
                                              },
                                 'CORE' => [
                                             [
                                               389,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '234',
                                              'named_class_head_sans_basetype' => '49',
                                              'reserved_typespecquals' => '570',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'reserved_declspecs' => '569',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'class_head' => '18',
                                              'typespecqual_reserved' => '239',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'unnamed_class_head' => '81',
                                              'attributes' => '238'
                                            },
                                 'FROM' => [
                                             83,
                                             218,
                                             403,
                                             429,
                                             434,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                '' => '-354',
                                                'ENUM' => '60',
                                                'TYPENAME_KEYWORD' => '6',
                                                'CV_QUALIFIER' => '235',
                                                'ATTRIBUTE' => '29',
                                                'SCSPEC' => '241',
                                                'TYPESPEC' => '236',
                                                'AGGR' => '35'
                                              },
                                 'CORE' => [
                                             [
                                               354,
                                               2
                                             ],
                                             [
                                               357,
                                               2
                                             ],
                                             [
                                               358,
                                               2
                                             ],
                                             [
                                               359,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'asm_keyword' => '260',
                                              'maybeasm' => '571'
                                            },
                                 'FROM' => [
                                             83,
                                             218
                                           ],
                                 'ACTIONS' => {
                                                '' => '-96',
                                                '\';\'' => -393,
                                                '\',\'' => -393,
                                                '\'=\'' => -393,
                                                'ASM_KEYWORD' => '65',
                                                'ATTRIBUTE' => -393
                                              },
                                 'CORE' => [
                                             [
                                               96,
                                               2
                                             ],
                                             [
                                               400,
                                               1
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             83
                                           ],
                                 'ACTIONS' => {
                                                '' => -71
                                              },
                                 'CORE' => [
                                             [
                                               71,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             83,
                                             218
                                           ],
                                 'ACTIONS' => {
                                                '' => -98
                                              },
                                 'CORE' => [
                                             [
                                               98,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             83,
                                             218,
                                             403,
                                             429,
                                             434,
                                             1213
                                           ],
                                 'ACTIONS' => {
                                                '' => -368
                                              },
                                 'CORE' => [
                                             [
                                               368,
                                               2
                                             ]
                                           ]
                               },
                               {
                                 'FROM' => [
                                             86
                                           ],
                                 'ACTIONS' => {
                                                '\'}\'' => '572'
                                              },
                                 'CORE' => [
                                             [
                                               20,
                                               3
                                             ]
                                           ]
                               },
                               {
                                 'GOTOS' => {
                                              'structsp' => '1',
                                              'aggr' => '3',
                                              'named_class_head' => '5',
                                              'attribute' => '7',
                                              'nonempty_cv_qualifiers' => '8',
                                              'using_directive' => '11',
                                              'fndef' => '12',
                                              'notype_template_declarator' => '44',
                                              'type_name' => '13',
                                              'template_def' => '14',
                                              'template_header' => '45',
                                              'typed_typespecs' => '47',
                                              'named_class_head_sans_basetype' => '49',
                                              'template_type' => '16',
                                              'class_head' => '18',
                                              'typespec' => '53',
                                              'asm_keyword' => '55',
                                              'fn_dot_def1' => '56',
                                              'nested_name_specifier' => '57',
                                              'named_complex_class_head_sans_basetype' => '54',
                                              'extern_lang_string' => '20',
                                              'attributes' => '21',
                                              'operator_name' => '58',
                                              'nested_type' => '22',
                                              'notype_declarator' => '59',
                                              'nested_name_specifier_1' => '24',
                                              'namespace_alias' => '63',
                                              'explicit_instantiation' => '62',
                                              'notype_unqualified_id' => '64',
                                              'global_scope' => '26',
                                              'using_decl' => '25',
                                              'complex_direct_notype_declarator' => '66',
                                              'operator' => '27',
                                              'typed_declspecs' => '67',
                                              'nomods_initdecls' => '68',
                                              'constructor_declarator' => '69',
                                              'extdef' => '30',
                                              'extension' => '70',
                                              'template_id' => '32',
                                              'datadef' => '71',
                                              'direct_notype_declarator' => '33',
                                              'nonnested_type' => '34',
                                              'typed_declspecs1' => '75',
                                              'named_class_head_sans_basetype_defn' => '74',
                                              'lang_extdef' => '205',
                                              'self_template_type' => '78',
                                              'ptr_to_mem' => '36',
                                              'nomods_initdcl0' => '80',
                                              'complete_type_name' => '38',
                                              'unnamed_class_head' => '81',
                                              'declmods' => '83',
                                              'notype_qualified_id' => '82'
                                            },
                                 'FROM' => [
                                             86,
                                             143,
                                             302
                                           ],
                                 'ACTIO