/*
   SPDX-FileCopyrightText: 2026 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "librocketchatrestapi-qt_export.h"
#include "restapiabstractjob.h"
namespace RocketChatRestApi
{
class LIBROCKETCHATRESTAPI_QT_EXPORT RoomsMediaConfirmJob : public RestApiAbstractJob
{
    Q_OBJECT
public:
    explicit RoomsMediaConfirmJob(QObject *parent = nullptr);
    ~RoomsMediaConfirmJob() override;

    [[nodiscard]] bool start() override;
    [[nodiscard]] bool requireHttpAuthentication() const override;
    [[nodiscard]] bool canStart() const override;

    [[nodiscard]] QNetworkRequest request() const override;

    [[nodiscard]] QJsonDocument json() const;

    [[nodiscard]] QByteArray roomId() const;
    void setRoomId(const QByteArray &newRoomId);

    [[nodiscard]] QByteArray fileId() const;
    void setFileId(const QByteArray &newFileId);

    [[nodiscard]] QString description() const;
    void setDescription(const QString &newDescription);

Q_SIGNALS:
    void roomsMediaConfirmDone();

private:
    LIBROCKETCHATRESTAPI_QT_NO_EXPORT void onPostRequestResponse(const QString &replyErrorString, const QJsonDocument &replyJson) override;
    QByteArray mRoomId;
    QByteArray mFileId;
    QString mDescription;
};
}
