/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern1 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case AND:
      return pattern0 (x1, pnum_clobbers); /* [-1, 0] */

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 1;

    default:
      return -1;
    }
}

int
pattern16 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern25 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern27 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode)
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x1) != E_V4DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern36 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 8
      || GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 9
      || GET_MODE (x5) != E_XFmode)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 10
      || GET_MODE (x7) != E_XFmode)
    return -1;
  x8 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x8) != CLOBBER)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != REG
      || REGNO (x9) != 11
      || GET_MODE (x9) != E_XFmode)
    return -1;
  x10 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x10) != CLOBBER)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != REG
      || REGNO (x11) != 12
      || GET_MODE (x11) != E_XFmode)
    return -1;
  x12 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x12) != CLOBBER)
    return -1;
  x13 = XEXP (x12, 0);
  if (GET_CODE (x13) != REG
      || REGNO (x13) != 13
      || GET_MODE (x13) != E_XFmode)
    return -1;
  x14 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x14) != CLOBBER)
    return -1;
  x15 = XEXP (x14, 0);
  if (GET_CODE (x15) != REG
      || REGNO (x15) != 14
      || GET_MODE (x15) != E_XFmode)
    return -1;
  x16 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x16) != CLOBBER)
    return -1;
  x17 = XEXP (x16, 0);
  if (GET_CODE (x17) != REG
      || REGNO (x17) != 15
      || GET_MODE (x17) != E_XFmode)
    return -1;
  return 0;
}

int
pattern47 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (x1))
    {
    case E_QImode:
      if (!nonimmediate_operand (operands[1], E_QImode)
          || !general_operand (operands[2], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !general_operand (operands[2], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !x86_64_general_operand (operands[2], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !x86_64_general_operand (operands[2], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern55 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_CCmode)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern59 (rtx x1, int *pnum_clobbers, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern63 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern69 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case ASHIFT:
      if (GET_MODE (x2) != E_TImode)
        return -1;
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != ZERO_EXTEND
          || GET_MODE (x3) != E_TImode)
        return -1;
      x4 = XEXP (x2, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 64]
          || !nonimmediate_operand (operands[0], E_TImode)
          || GET_MODE (x1) != E_TImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_TImode
          || !nonimmediate_operand (operands[1], E_TImode)
          || !const_scalar_int_operand (operands[3], E_TImode))
        return -1;
      x6 = XEXP (x3, 0);
      operands[2] = x6;
      if (!nonimmediate_operand (operands[2], E_DImode))
        return -1;
      return 0;

    case ZERO_EXTEND:
      x3 = XEXP (x2, 0);
      operands[2] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (!nonimmediate_operand (operands[0], E_TImode)
              || GET_MODE (x1) != E_TImode)
            return -1;
          x5 = XEXP (x1, 0);
          if (GET_MODE (x5) != E_TImode
              || !nonimmediate_operand (operands[1], E_TImode)
              || !const_scalar_int_operand (operands[3], E_TImode)
              || GET_MODE (x2) != E_TImode
              || !nonimmediate_operand (operands[2], E_DImode))
            return -1;
          return 1;

        case E_DImode:
          if (!nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x1) != E_DImode)
            return -1;
          x5 = XEXP (x1, 0);
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || !const_int_operand (operands[3], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !nonimmediate_operand (operands[2], E_SImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern100 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 2);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V2QImode:
      return pattern97 (x1, 
E_V2QImode); /* [-1, 0] */

    case E_V4QImode:
      res = pattern98 (x1, 
E_V4QImode);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_V8QImode:
      if (!memory_operand (operands[0], E_V8QImode)
          || GET_MODE (x1) != E_V8QImode
          || GET_MODE (x2) != E_V8QImode)
        return -1;
      res = pattern99 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    case E_V4HImode:
      res = pattern98 (x1, 
E_V4HImode);
      if (res >= 0)
        return res + 6; /* [6, 7] */
      return -1;

    case E_V2HImode:
      if (pattern97 (x1, 
E_V2HImode) != 0)
        return -1;
      return 8;

    case E_V2SImode:
      if (pattern97 (x1, 
E_V2SImode) != 0)
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern115 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern124 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern131 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern139 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern146 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern148 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern146 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern146 (x1, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern146 (x1, 
E_V4SImode, 
E_QImode) != 0)
        return -1;
      return 2;

    case E_V8DImode:
      if (pattern146 (x1, 
E_V8DImode, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_V4DImode:
      if (pattern146 (x1, 
E_V4DImode, 
E_QImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern146 (x1, 
E_V2DImode, 
E_QImode) != 0)
        return -1;
      return 5;

    case E_V64QImode:
      if (pattern146 (x1, 
E_V64QImode, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V16QImode:
      if (pattern146 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 7;

    case E_V32QImode:
      if (pattern146 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 8;

    case E_V32HImode:
      if (pattern146 (x1, 
E_V32HImode, 
E_SImode) != 0)
        return -1;
      return 9;

    case E_V16HImode:
      if (pattern147 (x1, 
E_V16HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (pattern146 (x1, 
E_V8HImode, 
E_QImode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern161 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern152 (x3, 
E_V16SImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern152 (x3, 
E_V8SImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern152 (x3, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern170 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4SImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  if (!register_operand (operands[1], E_V4SImode))
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  operands[2] = x3;
  if (!register_operand (operands[2], E_V4SImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  operands[3] = x4;
  if (!vector_operand (operands[3], E_V4SImode))
    return -1;
  return 0;
}

int
pattern178 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SImode:
      return pattern172 (x3, 
E_V8SImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern172 (x3, 
E_V4SImode) != 0)
        return -1;
      return 1;

    case E_V16SImode:
      if (pattern172 (x3, 
E_V16SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern185 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern191 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i3))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern195 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || !ternlog_operand (operands[1], E_V32HFmode))
        return -1;
      return 0;

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || !ternlog_operand (operands[1], E_V16HFmode))
        return -1;
      return 1;

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || !ternlog_operand (operands[1], E_V8HFmode))
        return -1;
      return 2;

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || !ternlog_operand (operands[1], E_V32BFmode))
        return -1;
      return 3;

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || !ternlog_operand (operands[1], E_V16BFmode))
        return -1;
      return 4;

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || !ternlog_operand (operands[1], E_V8BFmode))
        return -1;
      return 5;

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || !ternlog_operand (operands[1], E_V16SFmode))
        return -1;
      return 6;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !ternlog_operand (operands[1], E_V8SFmode))
        return -1;
      return 7;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !ternlog_operand (operands[1], E_V4SFmode))
        return -1;
      return 8;

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || !ternlog_operand (operands[1], E_V8DFmode))
        return -1;
      return 9;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !ternlog_operand (operands[1], E_V4DFmode))
        return -1;
      return 10;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !ternlog_operand (operands[1], E_V2DFmode))
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern204 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      return pattern202 (x4); /* [-1, 7] */

    case ASHIFT:
      x7 = XEXP (x4, 0);
      operands[0] = x7;
      x8 = XEXP (x6, 0);
      operands[1] = x8;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      x10 = XEXP (x5, 1);
      operands[3] = x10;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern203 (x5, 
E_DImode) != 0)
            return -1;
          return 8;

        case E_TImode:
          if (pattern203 (x5, 
E_TImode) != 0)
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern214 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  x7 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x7))
    {
    case CLOBBER:
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17
          || GET_MODE (x8) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          return pattern211 (x4, 
E_DImode); /* [-1, 0] */

        case E_TImode:
          if (pattern211 (x4, 
E_TImode) != 0)
            return -1;
          return 1;

        case E_QImode:
          if (pattern211 (x4, 
E_QImode) != 0)
            return -1;
          return 2;

        case E_HImode:
          if (pattern211 (x4, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_SImode:
          if (pattern211 (x4, 
E_SImode) != 0)
            return -1;
          return 4;

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern213 (x1) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern231 (rtx x1, machine_mode i1, unsigned int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern237 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!mask_reg_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !mask_reg_operand (operands[1], i1)
      || !mask_reg_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern243 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x2, 1);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x7;
      x8 = XEXP (x2, 2);
      operands[3] = x8;
      return 0;

    case ZERO_EXTEND:
      if (GET_MODE (x7) != E_DImode)
        return -1;
      x8 = XEXP (x2, 2);
      if (GET_CODE (x8) != ZERO_EXTEND
          || GET_MODE (x8) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern258 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x2;
      return 0;

    case STRICT_LOW_PART:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      x4 = XEXP (x1, 1);
      res = pattern39 (x4);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    default:
      return -1;
    }
}

int
pattern264 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return pattern263 (); /* [-1, 2] */
}

int
pattern269 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case SUBREG:
      if (pnum_clobbers == NULL
          || maybe_ne (SUBREG_BYTE (x2), 0)
          || GET_MODE (x2) != E_QImode)
        return -1;
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case AND:
          x4 = XEXP (x3, 0);
          operands[2] = x4;
          if (!int248_register_operand (operands[2], E_VOIDmode))
            return -1;
          return pattern268 (x1); /* [-1, 1] */

        case PLUS:
          x4 = XEXP (x3, 0);
          operands[2] = x4;
          if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern268 (x1);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        case MINUS:
          x4 = XEXP (x3, 0);
          operands[3] = x4;
          if (!const_int_operand (operands[3], E_VOIDmode))
            return -1;
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern2 (x1);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        default:
          return -1;
        }

    case CONST_INT:
      return 6;

    default:
      return -1;
    }
}

int
pattern291 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x2, 1);
  switch (GET_CODE (x5))
    {
    case LTU:
    case UNLT:
      operands[4] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x5, 0);
      operands[3] = x7;
      if (!flags_reg_operand (operands[3], E_VOIDmode))
        return -1;
      return 0;

    case EQ:
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x5, 0);
      operands[3] = x7;
      if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern303 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_DImode
      || !register_operand (operands[0], E_DImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  if (!register_operand (operands[1], E_DImode))
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  operands[2] = x3;
  if (!register_mmxmem_operand (operands[2], E_DImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  operands[3] = x4;
  if (!const_0_to_255_mul_8_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern310 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_SImode
      || !nonimmediate_operand (operands[1], E_HImode)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern318 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !float_vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern323 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          return 0;

        case E_V16SImode:
          return 1;

        case E_V8DImode:
          return 2;

        case E_V16HImode:
          return 3;

        case E_V8SImode:
          return 4;

        case E_V4DImode:
          return 5;

        case E_V8HImode:
          return 6;

        case E_V4SImode:
          return 7;

        case E_V2DImode:
          return 8;

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x2) != E_V2SFmode)
        return -1;
      x3 = XEXP (x2, 1);
      if (GET_CODE (x3) != PARALLEL
          || XVECLEN (x3, 0) != 2)
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode)
        return -1;
      x6 = XEXP (x2, 0);
      operands[1] = x6;
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern331 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern330 (x1, 
E_V8HImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern330 (x1, 
E_V4SImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern335 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_SELECT)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PARALLEL)
    return -1;
  x6 = XEXP (x2, 1);
  if (GET_CODE (x6) != i1)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != VEC_SELECT)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != PARALLEL)
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != PLUS)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != i1)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != VEC_SELECT)
    return -1;
  x12 = XEXP (x11, 1);
  if (GET_CODE (x12) != PARALLEL)
    return -1;
  x13 = XEXP (x9, 1);
  if (GET_CODE (x13) != i1)
    return -1;
  x14 = XEXP (x13, 0);
  if (GET_CODE (x14) != VEC_SELECT)
    return -1;
  x15 = XEXP (x14, 1);
  if (GET_CODE (x15) != PARALLEL)
    return -1;
  x16 = XEXP (x4, 0);
  operands[1] = x16;
  x17 = XEXP (x7, 0);
  if (!rtx_equal_p (x17, operands[1]))
    return -1;
  x18 = XEXP (x11, 0);
  if (!rtx_equal_p (x18, operands[1]))
    return -1;
  x19 = XEXP (x14, 0);
  if (!rtx_equal_p (x19, operands[1]))
    return -1;
  switch (XVECLEN (x5, 0))
    {
    case 4:
      x20 = XVECEXP (x5, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x21 = XVECEXP (x5, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x22 = XVECEXP (x5, 0, 2);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x23 = XVECEXP (x5, 0, 3);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 12]
          || XVECLEN (x8, 0) != 4)
        return -1;
      x24 = XVECEXP (x8, 0, 0);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x25 = XVECEXP (x8, 0, 1);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x26 = XVECEXP (x8, 0, 2);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x27 = XVECEXP (x8, 0, 3);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 13]
          || XVECLEN (x12, 0) != 4)
        return -1;
      x28 = XVECEXP (x12, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x29 = XVECEXP (x12, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x30 = XVECEXP (x12, 0, 2);
      if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
        return -1;
      x31 = XVECEXP (x12, 0, 3);
      if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x15, 0) != 4)
        return -1;
      x32 = XVECEXP (x15, 0, 0);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x15, 0, 1);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x34 = XVECEXP (x15, 0, 2);
      if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
        return -1;
      x35 = XVECEXP (x15, 0, 3);
      if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 15]
          || pattern334 (x1, 
E_V4QImode, 
E_V4SImode, 
E_V16QImode) != 0)
        return -1;
      return 0;

    case 2:
      x20 = XVECEXP (x5, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x21 = XVECEXP (x5, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 4]
          || XVECLEN (x8, 0) != 2)
        return -1;
      x24 = XVECEXP (x8, 0, 0);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x25 = XVECEXP (x8, 0, 1);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 5]
          || XVECLEN (x12, 0) != 2)
        return -1;
      x28 = XVECEXP (x12, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x29 = XVECEXP (x12, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x15, 0) != 2)
        return -1;
      x32 = XVECEXP (x15, 0, 0);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x15, 0, 1);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern334 (x1, 
E_V2HImode, 
E_V2DImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern374 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17
      || GET_MODE (x2) != E_CCmode)
    return -1;
  return 0;
}

int
pattern378 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern383 (rtx x1, int i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  return 0;
}

int
pattern388 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x1) != E_SFmode)
        return -1;
      return 0;

    case E_DFmode:
      if (!register_operand (operands[0], E_DFmode)
          || GET_MODE (x1) != E_DFmode)
        return -1;
      return 1;

    case E_XFmode:
      if (!register_operand (operands[0], E_XFmode)
          || GET_MODE (x1) != E_XFmode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern396 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (XINT (x1, 1) != i1
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 20
      || GET_MODE (x2) != E_V2DImode)
    return -1;
  return 0;
}

int
pattern404 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  switch (GET_CODE (x4))
    {
    case ASHIFT:
      x5 = XEXP (x4, 1);
      operands[3] = x5;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[2] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              return pattern400 (x1, 
E_DImode, 
E_SImode); /* [-1, 0] */

            case E_TImode:
              if (pattern400 (x1, 
E_TImode, 
E_DImode) != 0)
                return -1;
              return 1;

            default:
              return -1;
            }

        case SIGN_EXTEND:
          res = pattern402 (x1);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        case ZERO_EXTEND:
          res = pattern402 (x1);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern403 (x1, 
E_DImode, 
E_SImode) != 0)
            return -1;
          return 6;

        case E_TImode:
          if (pattern403 (x1, 
E_TImode, 
E_DImode) != 0)
            return -1;
          return 7;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern423 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != AND)
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  return pattern422 (x2, 
i1); /* [-1, 0] */
}

int
pattern431 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const248_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern430 (x1); /* [-1, 1] */
}

int
pattern438 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != ASHIFT
      || GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  return 0;
}

int
pattern443 (rtx x1, rtx_code i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != MINUS
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern451 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern460 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !vector_operand (operands[1], i2)
      || !vector_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2))
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[4], E_QImode))
    return -1;
  return 0;
}

int
pattern469 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V32BFmode:
      return pattern468 (x1, 
E_V32BFmode, 
E_SImode); /* [-1, 0] */

    case E_V16BFmode:
      if (pattern468 (x1, 
E_V16BFmode, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_V8BFmode:
      if (pattern468 (x1, 
E_V8BFmode, 
E_QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern477 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  if (!register_operand (x6, E_QImode))
    return -1;
  x7 = XEXP (x1, 1);
  switch (GET_CODE (x7))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x7;
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          return pattern475 (x1, 
E_V8DImode); /* [-1, 0] */

        case E_V4DImode:
          if (pattern475 (x1, 
E_V4DImode) != 0)
            return -1;
          return 1;

        case E_V2DImode:
          if (pattern475 (x1, 
E_V2DImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      if (!rtx_equal_p (x7, operands[1]))
        return -1;
      operands[4] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          if (pattern476 (x1, 
E_V8DImode) != 0)
            return -1;
          return 3;

        case E_V4DImode:
          if (pattern476 (x1, 
E_V4DImode) != 0)
            return -1;
          return 4;

        case E_V2DImode:
          if (pattern476 (x1, 
E_V2DImode) != 0)
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern494 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern497 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i3))
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1
      || !nonimm_or_0_operand (operands[2], i2)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern503 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V2SImode)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_CODE (x4) != CONST_VECTOR
      || XVECLEN (x4, 0) != 2
      || GET_MODE (x4) != E_V2SImode)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !register_operand (operands[0], E_V4SImode)
      || GET_MODE (x1) != E_V4SImode
      || GET_MODE (x2) != E_V2SImode)
    return -1;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  if (!nonimmediate_operand (operands[1], E_V2DFmode))
    return -1;
  return pattern502 (x2); /* [-1, 1] */
}

int
pattern508 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern516 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V16HFmode)
      || GET_MODE (x1) != E_V16HFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16HImode:
      if (!vector_operand (operands[1], E_V16HImode))
        return -1;
      return 0;

    case E_V16SImode:
      if (!vector_operand (operands[1], E_V16SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern520 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i3)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !const0_operand (operands[2], i2)
      || !const0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern528 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !regmem_or_bitnot_regmem_operand (operands[1], i1)
      || !regmem_or_bitnot_regmem_operand (operands[2], i1)
      || !regmem_or_bitnot_regmem_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern532 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x2, 1);
  operands[4] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      return pattern526 (x1, 
E_V32HFmode); /* [-1, 0] */

    case E_V16HFmode:
      if (pattern526 (x1, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V8HFmode:
      if (pattern526 (x1, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    case E_V32BFmode:
      if (pattern526 (x1, 
E_V32BFmode) != 0)
        return -1;
      return 3;

    case E_V16BFmode:
      if (pattern526 (x1, 
E_V16BFmode) != 0)
        return -1;
      return 4;

    case E_V8BFmode:
      if (pattern526 (x1, 
E_V8BFmode) != 0)
        return -1;
      return 5;

    case E_V16SFmode:
      if (pattern526 (x1, 
E_V16SFmode) != 0)
        return -1;
      return 6;

    case E_V8SFmode:
      if (pattern526 (x1, 
E_V8SFmode) != 0)
        return -1;
      return 7;

    case E_V4SFmode:
      if (pattern526 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 8;

    case E_V8DFmode:
      if (pattern526 (x1, 
E_V8DFmode) != 0)
        return -1;
      return 9;

    case E_V4DFmode:
      if (pattern526 (x1, 
E_V4DFmode) != 0)
        return -1;
      return 10;

    case E_V2DFmode:
      if (pattern526 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern539 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern542 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != i1
      || GET_MODE (x5) != E_XFmode)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_XFmode))
    return -1;
  x7 = XVECEXP (x3, 0, 0);
  operands[2] = x7;
  if (!register_operand (operands[2], E_XFmode))
    return -1;
  x8 = XEXP (x4, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  x9 = XVECEXP (x5, 0, 0);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  return 0;
}

int
pattern550 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCmode)
        return -1;
      return 0;

    case UNSPEC:
      if (pnum_clobbers == NULL
          || XVECLEN (x6, 0) != 1
          || XINT (x6, 1) != 38)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern559 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != i1)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != CLOBBER)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 17
      || GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XEXP (x3, 0);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x4, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      return pattern558 (x3, 
E_SImode, 
E_DImode); /* [-1, 0] */

    case E_TImode:
      if (pattern558 (x3, 
E_DImode, 
E_TImode) != 0)
        return -1;
      return 1;

    case E_HImode:
      if (pattern558 (x3, 
E_QImode, 
E_HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern572 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], E_SImode)
      || !register_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern580 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!int248_register_operand (operands[1], E_VOIDmode))
    return -1;
  x8 = XEXP (x4, 1);
  operands[2] = x8;
  if (!general_operand (operands[2], E_QImode))
    return -1;
  x9 = XVECEXP (x1, 0, 1);
  return pattern579 (x9); /* [-1, 2] */
}

int
pattern584 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  return pattern223 (x1); /* [-1, 1] */
}

int
pattern587 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != US_MINUS)
    return -1;
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XVECEXP (x1, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x1, 0, 2);
  operands[4] = x6;
  if (!const_0_to_7_operand (operands[4], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      return pattern419 (x1, 
E_V64QImode, 
E_DImode); /* [-1, 0] */

    case E_HImode:
      res = pattern418 (x1);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_SImode:
      res = pattern454 (x1);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    case E_QImode:
      if (pattern419 (x1, 
E_V8HImode, 
E_QImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern598 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != AND)
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_MODE (x4) != E_CCZmode
      || GET_MODE (x2) != E_CCZmode)
    return -1;
  x5 = XVECEXP (x2, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  operands[1] = x7;
  x8 = XEXP (x3, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (GET_MODE (x5))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || !vector_operand (operands[1], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode)
        return -1;
      return 0;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || !vector_operand (operands[1], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      return 1;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || !vector_operand (operands[1], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      return 2;

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || !vector_operand (operands[1], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode)
        return -1;
      return 3;

    case E_V1TImode:
      if (!register_operand (operands[0], E_V1TImode)
          || !vector_operand (operands[1], E_V1TImode)
          || GET_MODE (x3) != E_V1TImode)
        return -1;
      return 4;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !vector_operand (operands[1], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode)
        return -1;
      return 5;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !vector_operand (operands[1], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      return 6;

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || !vector_operand (operands[1], E_V32QImode)
          || GET_MODE (x3) != E_V32QImode)
        return -1;
      return 7;

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || !vector_operand (operands[1], E_V16HImode)
          || GET_MODE (x3) != E_V16HImode)
        return -1;
      return 8;

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || !vector_operand (operands[1], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode)
        return -1;
      return 9;

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || !vector_operand (operands[1], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode)
        return -1;
      return 10;

    case E_V2TImode:
      if (!register_operand (operands[0], E_V2TImode)
          || !vector_operand (operands[1], E_V2TImode)
          || GET_MODE (x3) != E_V2TImode)
        return -1;
      return 11;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !vector_operand (operands[1], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode)
        return -1;
      return 12;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !vector_operand (operands[1], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode)
        return -1;
      return 13;

    default:
      return -1;
    }
}

int
pattern641 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern649 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern653 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[2], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern658 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vector_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !vector_all_ones_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern664 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern667 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XVECEXP (x1, 0, 9);
  if (GET_CODE (x11) != CONST_INT)
    return -1;
  x12 = XVECEXP (x1, 0, 10);
  if (GET_CODE (x12) != CONST_INT)
    return -1;
  x13 = XVECEXP (x1, 0, 11);
  if (GET_CODE (x13) != CONST_INT)
    return -1;
  x14 = XVECEXP (x1, 0, 12);
  if (GET_CODE (x14) != CONST_INT)
    return -1;
  x15 = XVECEXP (x1, 0, 13);
  if (GET_CODE (x15) != CONST_INT)
    return -1;
  x16 = XVECEXP (x1, 0, 14);
  if (GET_CODE (x16) != CONST_INT)
    return -1;
  x17 = XVECEXP (x1, 0, 15);
  if (GET_CODE (x17) != CONST_INT)
    return -1;
  x18 = XVECEXP (x1, 0, 16);
  if (GET_CODE (x18) != CONST_INT)
    return -1;
  x19 = XVECEXP (x1, 0, 17);
  if (GET_CODE (x19) != CONST_INT)
    return -1;
  x20 = XVECEXP (x1, 0, 18);
  if (GET_CODE (x20) != CONST_INT)
    return -1;
  x21 = XVECEXP (x1, 0, 19);
  if (GET_CODE (x21) != CONST_INT)
    return -1;
  x22 = XVECEXP (x1, 0, 20);
  if (GET_CODE (x22) != CONST_INT)
    return -1;
  x23 = XVECEXP (x1, 0, 21);
  if (GET_CODE (x23) != CONST_INT)
    return -1;
  x24 = XVECEXP (x1, 0, 22);
  if (GET_CODE (x24) != CONST_INT)
    return -1;
  x25 = XVECEXP (x1, 0, 23);
  if (GET_CODE (x25) != CONST_INT)
    return -1;
  x26 = XVECEXP (x1, 0, 24);
  if (GET_CODE (x26) != CONST_INT)
    return -1;
  x27 = XVECEXP (x1, 0, 25);
  if (GET_CODE (x27) != CONST_INT)
    return -1;
  x28 = XVECEXP (x1, 0, 26);
  if (GET_CODE (x28) != CONST_INT)
    return -1;
  x29 = XVECEXP (x1, 0, 27);
  if (GET_CODE (x29) != CONST_INT)
    return -1;
  x30 = XVECEXP (x1, 0, 28);
  if (GET_CODE (x30) != CONST_INT)
    return -1;
  x31 = XVECEXP (x1, 0, 29);
  if (GET_CODE (x31) != CONST_INT)
    return -1;
  x32 = XVECEXP (x1, 0, 30);
  if (GET_CODE (x32) != CONST_INT)
    return -1;
  x33 = XVECEXP (x1, 0, 31);
  if (GET_CODE (x33) != CONST_INT)
    return -1;
  return 0;
}

int
pattern702 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != UNSPEC_VOLATILE
      || XVECLEN (x6, 0) != 1
      || XINT (x6, 1) != i1
      || GET_MODE (x6) != E_CCCmode)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x8 = XEXP (x5, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCCmode)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x3) != E_HImode)
        return -1;
      return 0;

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      return 1;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern715 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[2], i1)
      || pattern714 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern722 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2
      || peep2_current_count < 3
      || !general_reg_operand (operands[0], i1)
      || !general_reg_operand (operands[1], i1))
    return -1;
  x2 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x2) != SET)
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      return 0;

    case PARALLEL:
      return 1;

    default:
      return -1;
    }
}

int
pattern728 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern731 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x2, 1);
  operands[4] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      return pattern730 (x1, 
E_SFmode); /* [-1, 0] */

    case E_DFmode:
      if (pattern730 (x1, 
E_DFmode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern739 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern746 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern745 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern745 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern757 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != AND)
    return -1;
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!int248_register_operand (operands[1], E_VOIDmode))
    return -1;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  if (!const_int_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern286 (x1); /* [-1, 1] */
}

int
pattern766 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern773 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 2);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XEXP (x2, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x4, 1);
  operands[3] = x8;
  x9 = XEXP (x4, 2);
  operands[4] = x9;
  if (!register_operand (operands[4], E_QImode))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  operands[5] = x10;
  if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
    return -1;
  return pattern772 (x1); /* [-1, 2] */
}

int
pattern785 (rtx x1, int i1, int i2, int i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern802 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!movq_parallel (operands[3], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  x6 = XVECEXP (x5, 0, 0);
  operands[4] = x6;
  if (!const_int_operand (operands[4], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern798 (x1, 
E_V64QImode, 
E_V128QImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern798 (x1, 
E_V32QImode, 
E_V64QImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern798 (x1, 
E_V16QImode, 
E_V32QImode) != 0)
        return -1;
      return 2;

    case E_V32HImode:
      if (pattern798 (x1, 
E_V32HImode, 
E_V64HImode) != 0)
        return -1;
      return 3;

    case E_V16HImode:
      if (pattern798 (x1, 
E_V16HImode, 
E_V32HImode) != 0)
        return -1;
      return 4;

    case E_V8HImode:
      if (pattern798 (x1, 
E_V8HImode, 
E_V16HImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern817 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_HImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 0);
  operands[3] = x5;
  if (!memory_operand (operands[3], E_HImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x6 = XVECEXP (x1, 0, 0);
      x7 = XEXP (x6, 1);
      if (GET_MODE (x7) != E_DImode)
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[0], E_HImode))
        return -1;
      x6 = XVECEXP (x1, 0, 0);
      x7 = XEXP (x6, 1);
      if (GET_MODE (x7) != E_HImode)
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode))
        return -1;
      x6 = XVECEXP (x1, 0, 0);
      x7 = XEXP (x6, 1);
      if (GET_MODE (x7) != E_SImode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern831 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || pattern830 (x1, 
i1, 
i2, 
i3, 
i4) != 0)
    return -1;
  return 0;
}

int
pattern842 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern845 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern844 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern844 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern851 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !nonmemory_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern855 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern862 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V32QImode:
      if (!register_operand (operands[1], E_V32QImode)
          || !nonimmediate_operand (operands[2], E_V32QImode))
        return -1;
      return 0;

    case E_V32HImode:
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern871 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  switch (GET_MODE (x3))
    {
    case E_DFmode:
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern879 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i2))
    return -1;
  x4 = XEXP (x1, 1);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern890 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  return pattern889 (x3); /* [-1, 0] */
}

int
pattern894 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
      || !register_operand (operands[0], E_V2DImode)
      || GET_MODE (x1) != E_V2DImode
      || GET_MODE (x2) != E_V2DImode
      || GET_MODE (x3) != i2)
    return -1;
  x7 = XEXP (x3, 0);
  if (GET_MODE (x7) != i1
      || !nonimm_or_0_operand (operands[2], E_V2DImode))
    return -1;
  return 0;
}

int
pattern903 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern909 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V8QImode)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != VEC_SELECT
      || GET_MODE (x4) != E_V8QImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PARALLEL
      || XVECLEN (x5, 0) != 8)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x5, 0, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x8 = XVECEXP (x5, 0, 2);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x9 = XVECEXP (x5, 0, 3);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x10 = XVECEXP (x5, 0, 4);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x11 = XVECEXP (x5, 0, 5);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x12 = XVECEXP (x5, 0, 6);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x13 = XVECEXP (x5, 0, 7);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V16QImode)
      || GET_MODE (x1) != E_V16QImode
      || GET_MODE (x2) != E_V8QImode
      || !nonimmediate_operand (operands[1], E_V8HFmode))
    return -1;
  x14 = XEXP (x4, 0);
  operands[2] = x14;
  if (!nonimm_or_0_operand (operands[2], E_V16QImode))
    return -1;
  x15 = XEXP (x2, 2);
  operands[3] = x15;
  x16 = XEXP (x1, 1);
  operands[4] = x16;
  if (!const0_operand (operands[4], E_V8QImode))
    return -1;
  return 0;
}

int
pattern924 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V8QImode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!register_mmxmem_operand (operands[2], E_V8QImode))
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  operands[4] = x6;
  if (!reg_or_const_vector_operand (operands[4], E_V4SImode))
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 0);
  operands[3] = x8;
  if (!scratch_operand (operands[3], E_V4SImode))
    return -1;
  return 0;
}

int
pattern938 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (x1))
    {
    case E_QImode:
      if (!nonimmediate_operand (operands[1], E_QImode)
          || !general_operand (operands[2], E_QImode)
          || !scratch_operand (operands[0], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !general_operand (operands[2], E_HImode)
          || !scratch_operand (operands[0], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !x86_64_general_operand (operands[2], E_SImode)
          || !scratch_operand (operands[0], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !x86_64_general_operand (operands[2], E_DImode)
          || !scratch_operand (operands[0], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern954 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x1) != E_QImode)
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern956 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern960 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16SImode:
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_V16HFmode:
      if (!register_operand (operands[1], E_V16HFmode)
          || !nonimmediate_operand (operands[2], E_V16HFmode)
          || !const_0_to_31_operand (operands[3], E_SImode))
        return -1;
      return 1;

    case E_V16SFmode:
      if (!register_operand (operands[1], E_V16SFmode)
          || !nonimmediate_operand (operands[2], E_V16SFmode)
          || !const_0_to_31_operand (operands[3], E_SImode))
        return -1;
      return 2;

    case E_V16QImode:
      if (!register_operand (operands[1], E_V16QImode)
          || !nonimmediate_operand (operands[2], E_V16QImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 3;

    case E_V16HImode:
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 4;

    default:
      return -1;
    }
}

int
pattern969 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (x1))
    {
    case E_V8SFmode:
      if (!register_operand (operands[1], E_V8SImode)
          || !const0_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!register_operand (operands[1], E_V4SImode)
          || !const0_operand (operands[2], E_V4SImode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (!register_operand (operands[1], E_V4DImode)
          || !const0_operand (operands[2], E_V4DImode))
        return -1;
      return 2;

    case E_V2DFmode:
      if (!register_operand (operands[1], E_V2DImode)
          || !const0_operand (operands[2], E_V2DImode))
        return -1;
      return 3;

    case E_V32QImode:
      if (!register_operand (operands[1], E_V32QImode)
          || !const0_operand (operands[2], E_V32QImode))
        return -1;
      return 4;

    case E_V16QImode:
      if (!register_operand (operands[1], E_V16QImode)
          || !const0_operand (operands[2], E_V16QImode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern981 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V8DFmode:
      if (!vector_operand (operands[1], E_V8DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern991 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (!nonimmediate_operand (x5, i1))
    return -1;
  x6 = XEXP (x3, 1);
  if (!nonimmediate_operand (x6, i1))
    return -1;
  return 0;
}

int
pattern1004 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1)
      || !vector_all_ones_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1012 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const_4_or_8_to_11_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern1020 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1028 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      x13 = XEXP (x3, 1);
      operands[2] = x13;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      return pattern1027 (x1); /* [-1, 2] */

    default:
      return -1;
    }
}

int
pattern1041 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x4, 1);
  operands[3] = x8;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      return pattern1040 (x3, 
E_HImode); /* [-1, 0] */

    case E_SImode:
      if (pattern1040 (x3, 
E_SImode) != 0)
        return -1;
      return 1;

    case E_DImode:
      if (pattern1040 (x3, 
E_DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1046 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (!register_operand (x3, E_DImode))
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  if (!register_operand (x7, E_SImode))
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != E_SImode)
    return -1;
  switch (GET_CODE (x5))
    {
    case DIV:
      return 0;

    case UDIV:
      return 1;

    case MOD:
      return 2;

    case UMOD:
      return 3;

    default:
      return -1;
    }
}

int
pattern1056 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3
      || GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XEXP (x4, 0);
  if (!rtx_equal_p (x6, operands[2]))
    return -1;
  return 0;
}

int
pattern1064 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  return pattern736 (); /* [-1, 2] */
}

int
pattern1070 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_unset_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1079 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1085 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!const_int_operand (operands[2], E_QImode))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_V8SFmode:
      if (GET_MODE (x2) != E_V8SImode
          || !register_operand (operands[1], E_V8SImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (GET_MODE (x2) != E_V4SImode
          || !register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (GET_MODE (x2) != E_V4DImode
          || !register_operand (operands[1], E_V4DImode))
        return -1;
      return 2;

    case E_V2DFmode:
      if (GET_MODE (x2) != E_V2DImode
          || !register_operand (operands[1], E_V2DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1093 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1100 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  if (XWINT (x2, 0) != 1L
      || !const_0_to_255_operand (operands[3], E_SImode))
    return -1;
  return pattern1099 (x1); /* [-1, 2] */
}

int
pattern1102 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern1109 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i3)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i3)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i3
      || !vector_operand (operands[1], i2))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i3
      || !vector_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1121 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V32HFmode
      || !register_operand (operands[0], E_V32HFmode)
      || GET_MODE (x1) != E_V32HFmode
      || !register_operand (operands[1], E_V32HFmode)
      || !register_operand (operands[2], E_V32HFmode)
      || !const_4_or_8_to_11_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1128 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1135 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[5], i1)
      || !immediate_operand (operands[3], i1)
      || !register_operand (operands[4], i1)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1141 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_CODE (x5) != ZERO_EXTEND)
    return -1;
  return pattern356 (x1); /* [-1, 3] */
}

int
pattern1146 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1155 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      return pattern1154 (x1); /* [-1, 3] */

    case PLUS:
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern1154 (x1);
      if (res >= 0)
        return res + 4; /* [4, 7] */
      return -1;

    case MINUS:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern205 (x1);
      if (res >= 0)
        return res + 8; /* [8, 11] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1173 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !const0_operand (operands[2], i2)
      || !vector_all_ones_operand (operands[3], i2)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1177 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != MINUS)
    return -1;
  x7 = XEXP (x2, 0);
  if (GET_MODE (x7) != E_CCmode
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x8 = XEXP (x3, 1);
  operands[2] = x8;
  if (!memory_operand (operands[2], i1))
    return -1;
  x9 = XEXP (x6, 0);
  if (!rtx_equal_p (x9, operands[0]))
    return -1;
  x10 = XEXP (x6, 1);
  if (!rtx_equal_p (x10, operands[2]))
    return -1;
  return 0;
}

int
pattern1186 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_QImode)
      || GET_MODE (x1) != E_QImode
      || !ix86_comparison_operator (operands[1], E_VOIDmode)
      || !register_operand (operands[2], E_QImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  return 0;
}

int
pattern1190 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1196 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (XVECLEN (x1, 0) != 2
          || XINT (x1, 1) != 52
          || GET_MODE (x1) != E_V16QImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      operands[1] = x2;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x3 = XVECEXP (x1, 0, 1);
      operands[2] = x3;
      return 0;

    case VEC_SELECT:
      if (GET_MODE (x1) != E_V4SImode)
        return -1;
      x4 = XEXP (x1, 1);
      if (GET_CODE (x4) != PARALLEL
          || XVECLEN (x4, 0) != 4)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x7 = XVECEXP (x4, 0, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x8 = XVECEXP (x4, 0, 3);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x9 = XEXP (x1, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1215 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1218 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_CCGOCmode)
    return -1;
  return pattern364 (x1, 
E_CCGOCmode); /* [-1, 3] */
}

int
pattern1223 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (GET_MODE (x1) != E_DImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_63_operand (x6, E_QImode))
        return -1;
      return 0;

    case E_SImode:
      if (GET_MODE (x1) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_SImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_31_operand (x6, E_QImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1232 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode
      || !register_operand (operands[0], E_SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XVECEXP (x7, 0, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x9 = XVECEXP (x7, 0, 1);
  operands[2] = x9;
  return 0;
}

int
pattern1244 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !fcmov_comparison_operator (operands[1], E_VOIDmode)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1248 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1256 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1263 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i3)
      || pattern481 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1272 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i3))
    return -1;
  return 0;
}

int
pattern1281 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[2], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1290 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V16SImode)
      || GET_MODE (x1) != E_V16SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V16SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V16SImode
      || !nonimm_or_0_operand (operands[2], E_V16SImode)
      || !register_operand (operands[3], E_HImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16HFmode:
      if (!register_operand (operands[1], E_V16HFmode))
        return -1;
      return 0;

    case E_V16SFmode:
      if (!register_operand (operands[1], E_V16SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1301 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XVECEXP (x4, 0, 4);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x10 = XVECEXP (x4, 0, 5);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x11 = XVECEXP (x4, 0, 6);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x12 = XVECEXP (x4, 0, 7);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x13 = XEXP (x1, 1);
  x14 = XEXP (x13, 0);
  x15 = XEXP (x14, 1);
  return pattern1300 (x15, 
8); /* [-1, 0] */
}

int
pattern1314 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern1322 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[2], i1)
      || !const0_operand (operands[3], i1)
      || !register_operand (operands[1], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1331 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  if (!rtx_equal_p (x6, operands[0]))
    return -1;
  x7 = XEXP (x4, 0);
  if (!rtx_equal_p (x7, operands[0]))
    return -1;
  return 0;
}

int
pattern1339 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1349 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], E_SImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_DImode)
    return -1;
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x6 = XEXP (x3, 1);
  operands[3] = x6;
  if (!const_0_to_63_operand (operands[3], E_QImode))
    return -1;
  x7 = XEXP (x1, 0);
  x8 = XEXP (x7, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  return 0;
}

int
pattern1358 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1370 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 2);
  return pattern1369 (x3, 
i1); /* [-1, 0] */
}

int
pattern1379 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x2, 2);
  return pattern1369 (x4, 
i1); /* [-1, 0] */
}

int
pattern1388 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1394 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  operands[4] = x2;
  if (!const48_operand (operands[4], E_SImode))
    return -1;
  return pattern1393 (x1); /* [-1, 2] */
}

int
pattern1399 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1407 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  if (!register_operand (operands[2], E_XFmode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[3] = x5;
  if (!register_operand (operands[3], E_XFmode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  x8 = XEXP (x6, 1);
  x9 = XVECEXP (x8, 0, 0);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  x10 = XVECEXP (x8, 0, 1);
  if (!rtx_equal_p (x10, operands[3]))
    return -1;
  return 0;
}

int
pattern1421 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern198 (x1); /* [-1, 1] */
}

int
pattern1429 (rtx x1, int i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case PLUS:
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != ASHIFT)
        return -1;
      x5 = XEXP (x4, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x6) != SET)
        return -1;
      x7 = XEXP (x6, 1);
      if (GET_CODE (x7) != MEM
          || GET_MODE (x7) != E_BLKmode)
        return -1;
      x8 = XEXP (x6, 0);
      if (GET_CODE (x8) != MEM
          || GET_MODE (x8) != E_BLKmode)
        return -1;
      x9 = XVECEXP (x1, 0, 0);
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      x11 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x11, 1);
      x13 = XEXP (x12, 0);
      x14 = XEXP (x13, 0);
      operands[5] = x14;
      x15 = XEXP (x2, 0);
      operands[1] = x15;
      x16 = XEXP (x3, 1);
      operands[4] = x16;
      x17 = XEXP (x4, 0);
      if (!rtx_equal_p (x17, operands[5]))
        return -1;
      x18 = XEXP (x7, 0);
      if (!rtx_equal_p (x18, operands[4]))
        return -1;
      x19 = XEXP (x8, 0);
      if (!rtx_equal_p (x19, operands[3]))
        return -1;
      x20 = XVECEXP (x1, 0, 4);
      x21 = XEXP (x20, 0);
      if (!rtx_equal_p (x21, operands[5]))
        return -1;
      switch (GET_MODE (operands[2]))
        {
        case E_SImode:
          return pattern1427 (x1, 
E_SImode); /* [-1, 0] */

        case E_DImode:
          if (pattern1427 (x1, 
E_DImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 0L)
        return -1;
      x15 = XEXP (x2, 0);
      if (GET_CODE (x15) != MEM
          || GET_MODE (x15) != E_BLKmode)
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x6) != USE)
        return -1;
      x9 = XVECEXP (x1, 0, 0);
      x10 = XEXP (x9, 0);
      operands[1] = x10;
      x11 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x11, 1);
      x13 = XEXP (x12, 0);
      x14 = XEXP (x13, 0);
      operands[4] = x14;
      x8 = XEXP (x6, 0);
      operands[2] = x8;
      if (!register_operand (operands[2], i2))
        return -1;
      x22 = XEXP (x15, 0);
      if (!rtx_equal_p (x22, operands[3]))
        return -1;
      x20 = XVECEXP (x1, 0, 4);
      x21 = XEXP (x20, 0);
      if (!rtx_equal_p (x21, operands[4]))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (pattern1428 (x12, 
E_SImode) != 0)
            return -1;
          return 2;

        case E_DImode:
          if (pattern1428 (x12, 
E_DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1475 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode)
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1487 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !x86_64_nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1491 (rtx x1, int i1, int i2, int i3, int i4, int i5)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 7);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i5])
    return -1;
  x3 = XVECEXP (x1, 0, 8);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x4 = XVECEXP (x1, 0, 9);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x5 = XVECEXP (x1, 0, 10);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x6 = XVECEXP (x1, 0, 11);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i1]
      || pattern1402 (x1) != 0)
    return -1;
  return 0;
}

int
pattern1506 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i2
      || !vector_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x5, 1);
  if (GET_MODE (x7) != i2
      || !vector_operand (operands[2], i1)
      || !const1_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1518 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1525 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1535 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  x6 = XEXP (x2, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1)
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x1, 1);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  if (GET_MODE (x11) != i1)
    return -1;
  x12 = XEXP (x10, 1);
  if (GET_MODE (x12) != i1)
    return -1;
  x13 = XEXP (x9, 1);
  x14 = XEXP (x13, 0);
  if (GET_MODE (x14) != i1)
    return -1;
  x15 = XEXP (x13, 1);
  if (GET_MODE (x15) != i1)
    return -1;
  return 0;
}

int
pattern1547 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1555 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x4, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 1);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  if (!rtx_equal_p (x11, operands[1]))
    return -1;
  x12 = XEXP (x9, 1);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1554 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1554 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1569 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XVECEXP (x3, 0, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1579 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !register_operand (operands[2], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1588 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1587 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1587 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1599 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V4SImode:
      if (!register_operand (operands[2], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[2], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1608 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !ix86_carry_flag_operator (operands[4], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1615 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1624 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i3)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i3)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i3)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i3)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i3
      || !vector_operand (operands[1], i2))
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != i3
      || !vector_operand (operands[2], i2)
      || !const1_operand (operands[3], i2)
      || !nonimm_or_0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1639 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[4], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[3], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1647 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !addsub_vs_operator (operands[7], i1)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1658 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1668 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x1, 0);
  x5 = XEXP (x4, 0);
  switch (GET_MODE (x5))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1678 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 2);
  if (GET_MODE (x6) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  x7 = XEXP (x2, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  x8 = XEXP (x1, 1);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  return 0;
}

int
pattern1685 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[3], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1692 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[2], E_VOIDmode)
      || !const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_0_to_3_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode)
      || !const_4_to_7_operand (operands[7], E_VOIDmode)
      || !const_4_to_7_operand (operands[8], E_VOIDmode)
      || !const_4_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1703 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1)
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1702 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1702 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1715 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 4);
  if (XWINT (x4, 0) != 6L)
    return -1;
  x5 = XVECEXP (x3, 0, 5);
  if (XWINT (x5, 0) != 14L)
    return -1;
  x6 = XVECEXP (x3, 0, 6);
  if (XWINT (x6, 0) != 7L)
    return -1;
  x7 = XVECEXP (x3, 0, 7);
  if (XWINT (x7, 0) != 15L)
    return -1;
  x8 = XEXP (x2, 0);
  x9 = XEXP (x8, 1);
  operands[2] = x9;
  x10 = XEXP (x1, 1);
  operands[3] = x10;
  x11 = XEXP (x1, 2);
  operands[4] = x11;
  return 0;
}

int
pattern1722 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_V8SFmode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1731 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1)
      || !scratch_operand (operands[2], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1730 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1730 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1745 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  if (!constm1_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (XVECLEN (x3, 0) != 2
      || XINT (x3, 1) != 110
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PLUS
      || GET_MODE (x5) != i1)
    return -1;
  x6 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  x8 = XVECEXP (x3, 0, 0);
  operands[1] = x8;
  if (!memory_operand (operands[1], i1))
    return -1;
  x9 = XVECEXP (x3, 0, 1);
  operands[4] = x9;
  if (!const_int_operand (operands[4], E_SImode))
    return -1;
  x10 = XEXP (x2, 0);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x5, 0);
  if (!rtx_equal_p (x11, operands[1]))
    return -1;
  x12 = XEXP (x5, 1);
  if (!rtx_equal_p (x12, operands[0]))
    return -1;
  x13 = XEXP (x4, 0);
  if (!rtx_equal_p (x13, operands[1]))
    return -1;
  x14 = PATTERN (peep2_next_insn (2));
  x15 = XEXP (x14, 1);
  x16 = XEXP (x15, 1);
  operands[3] = x16;
  if (!const_int_operand (operands[3], i1))
    return -1;
  x17 = XEXP (x15, 0);
  if (!rtx_equal_p (x17, operands[0]))
    return -1;
  return 0;
}

int
pattern1767 (rtx x1, machine_mode i1, machine_mode i2, rtx_code i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != MULT
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != i3
      || GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != SIGN_EXTEND
      || GET_MODE (x9) != i2)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != i1)
    return -1;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 4)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x14 = XVECEXP (x11, 0, 2);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x15 = XVECEXP (x11, 0, 3);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  return 0;
}

int
pattern1793 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[3], i1))
    return -1;
  x6 = XEXP (x2, 1);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  x7 = XEXP (x1, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  return 0;
}

int
pattern1802 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1810 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[2], i1)
      || !register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1)
      || !register_operand (operands[5], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1817 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8SImode:
      if (!register_operand (operands[3], E_V8SImode)
          || !register_operand (operands[4], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode)
          || !register_operand (operands[4], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1823 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[2], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return pattern1822 (x1, 
i1); /* [-1, 1] */
}

int
pattern1828 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_8_to_15_operand (operands[7], E_VOIDmode)
      || !const_8_to_15_operand (operands[8], E_VOIDmode)
      || !const_8_to_15_operand (operands[9], E_VOIDmode)
      || !const_8_to_15_operand (operands[10], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1834 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[2], i2)
      || !vsib_mem_operator (operands[7], i3)
      || !register_operand (operands[5], i2)
      || !scratch_operand (operands[1], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 1);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      if (!vsib_address_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!vsib_address_operand (operands[3], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1843 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!x86_64_general_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (XINT (x3, 1) != 112
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != COMPARE
      || GET_MODE (x5) != E_CCmode
      || !memory_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  x6 = XEXP (x4, 0);
  if (GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XEXP (x5, 0);
  if (!rtx_equal_p (x7, operands[2]))
    return -1;
  x8 = XEXP (x5, 1);
  if (!rtx_equal_p (x8, operands[0])
      || !register_operand (operands[5], i1)
      || !x86_64_general_operand (operands[6], i1))
    return -1;
  return 0;
}

int
pattern1850 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[4], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !nonmemory_operand (operands[2], E_SImode))
    return -1;
  x2 = PATTERN (peep2_next_insn (3));
  x3 = XEXP (x2, 1);
  operands[5] = x3;
  if (!register_operand (operands[5], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (4));
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[6] = x6;
  x7 = XEXP (x5, 1);
  operands[7] = x7;
  return 0;
}

int
pattern1858 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const_int_operand (operands[6], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i2)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != i1
      || !ix86_carry_flag_operator (operands[5], i1))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 1);
  return pattern1857 (x11, 
i1); /* [-1, 0] */
}

int
pattern1868 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 8);
  if (XWINT (x2, 0) != 12L)
    return -1;
  x3 = XVECEXP (x1, 0, 9);
  if (XWINT (x3, 0) != 44L)
    return -1;
  x4 = XVECEXP (x1, 0, 10);
  if (XWINT (x4, 0) != 13L)
    return -1;
  x5 = XVECEXP (x1, 0, 11);
  if (XWINT (x5, 0) != 45L)
    return -1;
  x6 = XVECEXP (x1, 0, 12);
  if (XWINT (x6, 0) != 14L)
    return -1;
  x7 = XVECEXP (x1, 0, 13);
  if (XWINT (x7, 0) != 46L)
    return -1;
  x8 = XVECEXP (x1, 0, 14);
  if (XWINT (x8, 0) != 15L)
    return -1;
  x9 = XVECEXP (x1, 0, 15);
  if (XWINT (x9, 0) != 47L)
    return -1;
  return 0;
}

 int
recog_4 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  res = recog_3 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (GET_CODE (x3) != SUBREG
      || pattern261 (x3) != 0)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (!int248_register_operand (operands[0], E_VOIDmode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[1] = x6;
  switch (pattern1341 ())
    {
    case 0:
      if (const0_operand (operands[1], E_QImode)
          && 
#line 1629 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
        return 24; /* *cmpqi_exthi_2 */
      if (general_operand (operands[1], E_QImode)
          && 
#line 1654 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
        return 27; /* *cmpqi_exthi_3 */
      break;

    case 1:
      if (const0_operand (operands[1], E_QImode)
          && 
#line 1629 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
        return 25; /* *cmpqi_extsi_2 */
      if (general_operand (operands[1], E_QImode)
          && 
#line 1654 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
        return 28; /* *cmpqi_extsi_3 */
      break;

    case 2:
      if (const0_operand (operands[1], E_QImode)
          && (
#line 1629 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 26; /* *cmpqi_extdi_2 */
      if (general_operand (operands[1], E_QImode)
          && (
#line 1654 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 29; /* *cmpqi_extdi_3 */
      break;

    default:
      break;
    }
  if (GET_CODE (x6) != SUBREG
      || maybe_ne (SUBREG_BYTE (x6), 0)
      || GET_MODE (x6) != E_QImode)
    return -1;
  x7 = XEXP (x6, 0);
  switch (GET_CODE (x7))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x7;
      x8 = XEXP (x7, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x9 = XEXP (x7, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x7, 0);
      operands[1] = x10;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[2]))
        {
        case E_HImode:
          if (!extract_operator (operands[2], E_HImode)
              || !extract_operator (operands[3], E_HImode)
              || !
#line 1673 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
            return -1;
          return 30; /* *cmpqi_exthi_4 */

        case E_SImode:
          if (!extract_operator (operands[2], E_SImode)
              || !extract_operator (operands[3], E_SImode)
              || !
#line 1673 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
            return -1;
          return 31; /* *cmpqi_extsi_4 */

        case E_DImode:
          if (!extract_operator (operands[2], E_DImode)
              || !extract_operator (operands[3], E_DImode)
              || !(
#line 1673 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 32; /* *cmpqi_extdi_4 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_12 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 105:
      if (GET_MODE (x2) != E_TImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!push_operand (operands[0], E_TImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!register_operand (operands[2], E_DImode)
          || !
#line 3901 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PUSH2POP2))
        return -1;
      return 159; /* push2_di */

    case 40:
      if (GET_MODE (x2) != E_CCCmode
          || pattern250 (x1) != 0)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case LTU:
          if (pattern712 (x4) != 0)
            return -1;
          x6 = XEXP (x4, 0);
          switch (GET_MODE (x6))
            {
            case E_CCmode:
              if (!
#line 9916 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
                return -1;
              return 532; /* *setcc_qi_negqi_ccc_2_cc */

            case E_CCCmode:
              if (!
#line 9916 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
                return -1;
              return 533; /* *setcc_qi_negqi_ccc_2_ccc */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          if (pnum_clobbers == NULL)
            return -1;
          operands[1] = x4;
          switch (GET_MODE (operands[1]))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode))
                return -1;
              *pnum_clobbers = 1;
              return 984; /* *negqi_ccc_2 */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode))
                return -1;
              *pnum_clobbers = 1;
              return 985; /* *neghi_ccc_2 */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              *pnum_clobbers = 1;
              return 986; /* *negsi_ccc_2 */

            case E_DImode:
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 987; /* *negdi_ccc_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 66:
      if (pnum_clobbers == NULL
          || GET_MODE (x2) != E_XFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_XFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[2] = x4;
      if (!register_operand (operands[2], E_XFmode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[1] = x5;
      if (!register_operand (operands[1], E_XFmode)
          || !
#line 24165 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      *pnum_clobbers = 1;
      return 1721; /* atan2xf3 */

    case 67:
      if (pnum_clobbers == NULL
          || pattern159 (x1, 
E_XFmode) != 0
          || !
#line 24468 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      *pnum_clobbers = 1;
      return 1722; /* fyl2xxf3_i387 */

    case 68:
      if (pnum_clobbers == NULL
          || pattern159 (x1, 
E_XFmode) != 0
          || !
#line 24565 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      *pnum_clobbers = 1;
      return 1723; /* fyl2xp1xf3_i387 */

    case 58:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (pattern61 (x2, 
E_SFmode) != 0
              || !
#line 24874 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512F))
            return -1;
          return 1727; /* avx512f_scalefsf2 */

        case E_DFmode:
          if (pattern61 (x2, 
E_DFmode) != 0
              || !
#line 24874 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512F))
            return -1;
          return 1728; /* avx512f_scalefdf2 */

        default:
          return -1;
        }

    case 94:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_15_operand (operands[2], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HFmode:
          if (!register_operand (operands[0], E_HFmode)
              || GET_MODE (x2) != E_HFmode
              || !nonimmediate_operand (operands[1], E_HFmode)
              || !(
#line 24992 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1) && 
#line 1355 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16)))
            return -1;
          return 1729; /* sse4_1_roundhf2 */

        case E_SFmode:
          if (!register_operand (operands[0], E_SFmode)
              || GET_MODE (x2) != E_SFmode
              || !nonimmediate_operand (operands[1], E_SFmode)
              || !
#line 24992 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1))
            return -1;
          return 1730; /* sse4_1_roundsf2 */

        case E_DFmode:
          if (!register_operand (operands[0], E_DFmode)
              || GET_MODE (x2) != E_DFmode
              || !nonimmediate_operand (operands[1], E_DFmode)
              || !
#line 24992 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1))
            return -1;
          return 1731; /* sse4_1_rounddf2 */

        default:
          return -1;
        }

    case 63:
      switch (pattern62 (x1))
        {
        case 0:
          if (!
#line 26793 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1821; /* *ieee_smaxhf3 */

        case 1:
          if (!
#line 26805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
            return -1;
          return 1823; /* *ieee_smaxsf3 */

        case 2:
          if (!
#line 26805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
            return -1;
          return 1825; /* *ieee_smaxdf3 */

        default:
          return -1;
        }

    case 62:
      switch (pattern62 (x1))
        {
        case 0:
          if (!
#line 26793 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1822; /* *ieee_sminhf3 */

        case 1:
          if (!
#line 26805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
            return -1;
          return 1824; /* *ieee_sminsf3 */

        case 2:
          if (!
#line 26805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
            return -1;
          return 1826; /* *ieee_smindf3 */

        default:
          return -1;
        }

    case 113:
      if (pattern63 (x1, 
E_V2SFmode) != 0
          || !
#line 911 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2060; /* mmx_rcpit1v2sf3 */

    case 114:
      if (pattern63 (x1, 
E_V2SFmode) != 0
          || !
#line 922 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2061; /* mmx_rcpit2v2sf3 */

    case 116:
      if (pattern63 (x1, 
E_V2SFmode) != 0
          || !
#line 959 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2063; /* mmx_rsqit1v2sf3 */

    case 57:
      switch (pattern65 (x1))
        {
        case 0:
          if (!
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2293; /* mmx_packuswb */

        case 1:
          if (!
#line 4831 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return -1;
          return 2295; /* mmx_packusdw */

        default:
          return -1;
        }

    case 52:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!vector_operand (operands[2], E_V16QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (!register_operand (operands[0], E_V8QImode)
              || GET_MODE (x2) != E_V8QImode
              || !register_operand (operands[1], E_V8QImode)
              || !
#line 5489 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSSE3 && TARGET_MMX_WITH_SSE))
            return -1;
          return 2330; /* mmx_pshufbv8qi3 */

        case E_V4QImode:
          if (!register_operand (operands[0], E_V4QImode)
              || GET_MODE (x2) != E_V4QImode
              || !register_operand (operands[1], E_V4QImode)
              || !
#line 5507 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSSE3))
            return -1;
          return 2331; /* mmx_pshufbv4qi3 */

        default:
          return -1;
        }

    case 56:
      if (GET_MODE (x2) != E_V1DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V1DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_mmxmem_operand (operands[1], E_V8QImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!register_mmxmem_operand (operands[2], E_V8QImode)
          || !
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (PLUS, V8QImode, operands)))
        return -1;
      return 2383; /* *mmx_psadbw */

    case 176:
      if (pattern66 (x1) != 0)
        return -1;
      switch (pattern953 ())
        {
        case 0:
          if (!(
#line 2338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return -1;
          return 2610; /* ktestqi */

        case 1:
          if (!(
#line 2338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return -1;
          return 2611; /* ktesthi */

        case 2:
          if (!(
#line 2338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2612; /* ktestsi */

        case 3:
          if (!(
#line 2338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2613; /* ktestdi */

        default:
          return -1;
        }

    case 178:
      return recog_8 (x1, insn, pnum_clobbers);

    case 61:
      return recog_9 (x1, insn, pnum_clobbers);

    case 158:
      switch (pattern68 (x1))
        {
        case 0:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8040; /* avx512vl_testmv16qi3 */

        case 1:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8044; /* avx512vl_testmv16hi3 */

        case 2:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8048; /* avx512f_testmv16si3 */

        case 3:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8046; /* avx512vl_testmv8hi3 */

        case 4:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8050; /* avx512vl_testmv8si3 */

        case 5:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8052; /* avx512vl_testmv4si3 */

        case 6:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8054; /* avx512f_testmv8di3 */

        case 7:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8056; /* avx512vl_testmv4di3 */

        case 8:
          if (!(
#line 19038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8058; /* avx512vl_testmv2di3 */

        default:
          return -1;
        }

    case 159:
      switch (pattern68 (x1))
        {
        case 0:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8064; /* avx512vl_testnmv16qi3 */

        case 1:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8068; /* avx512vl_testnmv16hi3 */

        case 2:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8072; /* avx512f_testnmv16si3 */

        case 3:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8070; /* avx512vl_testnmv8hi3 */

        case 4:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8074; /* avx512vl_testnmv8si3 */

        case 5:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8076; /* avx512vl_testnmv4si3 */

        case 6:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8078; /* avx512f_testnmv8di3 */

        case 7:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8080; /* avx512vl_testnmv4di3 */

        case 8:
          if (!(
#line 19049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8082; /* avx512vl_testnmv2di3 */

        default:
          return -1;
        }

    case 120:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (pattern728 (x2, 
E_V8QImode) != 0
              || !
#line 23204 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          return 8564; /* ssse3_psignv8qi3 */

        case E_V4HImode:
          if (pattern64 (x2, 
E_V4HImode) != 0
              || !
#line 23204 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          return 8565; /* ssse3_psignv4hi3 */

        case E_V2SImode:
          if (pattern728 (x2, 
E_V2SImode) != 0
              || !
#line 23204 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          return 8566; /* ssse3_psignv2si3 */

        default:
          return -1;
        }

    case 148:
      if (pattern66 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || !nonimmediate_operand (operands[1], E_V8SFmode)
              || !
#line 25304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 8861; /* avx_vtestps256 */

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || !nonimmediate_operand (operands[1], E_V4SFmode)
              || !
#line 25304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 8862; /* avx_vtestps */

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || !nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 25304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 8863; /* avx_vtestpd256 */

        case E_V2DFmode:
          if (!register_operand (operands[0], E_V2DFmode)
              || !nonimmediate_operand (operands[1], E_V2DFmode)
              || !(
#line 25304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 8864; /* avx_vtestpd */

        default:
          return -1;
        }

    case 130:
      return recog_10 (x1, insn, pnum_clobbers);

    case 150:
      if (GET_MODE (x2) != E_V4HImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_V4HImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_SImode)
          || !
#line 29159 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
        return -1;
      return 9585; /* *vcvtps2ph_store */

    case 193:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          switch (pattern637 (x2, 
E_HImode))
            {
            case 0:
              if (!(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V16HFmode)) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 9910; /* avx512dq_fpclassv16hf */

            case 1:
              if (!(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V16SFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9914; /* avx512dq_fpclassv16sf */

            default:
              return -1;
            }

        case E_QImode:
          if (!register_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!vector_operand (operands[1], E_V8HFmode)
                  || !(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V8HFmode)) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 9912; /* avx512dq_fpclassv8hf */

            case E_V8SFmode:
              if (!vector_operand (operands[1], E_V8SFmode)
                  || !(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V8SFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9916; /* avx512dq_fpclassv8sf */

            case E_V4SFmode:
              if (!vector_operand (operands[1], E_V4SFmode)
                  || !(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V4SFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9918; /* avx512dq_fpclassv4sf */

            case E_V8DFmode:
              if (!vector_operand (operands[1], E_V8DFmode)
                  || !(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V8DFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9920; /* avx512dq_fpclassv8df */

            case E_V4DFmode:
              if (!vector_operand (operands[1], E_V4DFmode)
                  || !(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V4DFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9922; /* avx512dq_fpclassv4df */

            case E_V2DFmode:
              if (!vector_operand (operands[1], E_V2DFmode)
                  || !(
#line 29857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V2DFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9924; /* avx512dq_fpclassv2df */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 214:
      if (GET_MODE (x2) != E_HImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_HImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!nonimmediate_operand (operands[2], E_V16QImode)
          || !(
#line 30940 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10252; /* avx512vl_vpshufbitqmbv16qi */

    case 215:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_P2QImode:
          if (!register_operand (operands[0], E_P2QImode)
              || GET_MODE (x2) != E_P2QImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DImode:
              if (!register_operand (operands[1], E_V8DImode)
                  || !vector_operand (operands[2], E_V8DImode)
                  || !(
#line 30980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 10258; /* avx512vp2intersect_2intersectv8di */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !vector_operand (operands[2], E_V4DImode)
                  || !(
#line 30980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10259; /* avx512vp2intersect_2intersectv4di */

            case E_V2DImode:
              if (!register_operand (operands[1], E_V2DImode)
                  || !vector_operand (operands[2], E_V2DImode)
                  || !(
#line 30980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10260; /* avx512vp2intersect_2intersectv2di */

            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode)
                  || !vector_operand (operands[2], E_V8SImode)
                  || !(
#line 30980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30948 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10261; /* avx512vp2intersect_2intersectv8si */

            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !vector_operand (operands[2], E_V4SImode)
                  || !(
#line 30980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30948 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10262; /* avx512vp2intersect_2intersectv4si */

            default:
              return -1;
            }

        case E_P2HImode:
          if (pattern729 (x2, 
E_V16SImode, 
E_P2HImode) != 0
              || !
#line 30989 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT && TARGET_EVEX512))
            return -1;
          return 10263; /* avx512vp2intersect_2intersectv16si */

        default:
          return -1;
        }

    case 262:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode
              || !nonimmediate_operand (operands[1], E_V16BFmode)
              || !
#line 32456 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10646; /* avx10_2_fpclassbf16_v16bf */

        case E_QImode:
          if (!register_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode
              || !nonimmediate_operand (operands[1], E_V8BFmode)
              || !
#line 32456 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10648; /* avx10_2_fpclassbf16_v8bf */

        default:
          return -1;
        }

    case 288:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_int_operand (operands[2], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!memory_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode
              || !nonmemory_operand (operands[1], E_QImode))
            return -1;
          return 10907; /* atomic_storeqi_1 */

        case E_HImode:
          if (!memory_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode
              || !nonmemory_operand (operands[1], E_HImode))
            return -1;
          return 10908; /* atomic_storehi_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_36 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      switch (pattern1062 (x2))
        {
        case 0:
          switch (GET_MODE (operands[1]))
            {
            case E_V16SImode:
              if (!register_operand (operands[1], E_V16SImode)
                  || !nonimmediate_operand (operands[2], E_V16SImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3253; /* avx512f_cmpv16si3_mask */

            case E_V16HFmode:
              if (!register_operand (operands[1], E_V16HFmode)
                  || !nonimmediate_operand (operands[2], E_V16HFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 3272; /* avx512vl_cmpv16hf3_mask */

            case E_V16SFmode:
              if (!register_operand (operands[1], E_V16SFmode)
                  || !nonimmediate_operand (operands[2], E_V16SFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3277; /* avx512f_cmpv16sf3_mask */

            case E_V16QImode:
              if (!register_operand (operands[1], E_V16QImode)
                  || !nonimmediate_operand (operands[2], E_V16QImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3399; /* avx512vl_cmpv16qi3_mask */

            case E_V16HImode:
              if (!register_operand (operands[1], E_V16HImode)
                  || !nonimmediate_operand (operands[2], E_V16HImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3405; /* avx512vl_cmpv16hi3_mask */

            case E_V16BFmode:
              if (!register_operand (operands[1], E_V16BFmode)
                  || !nonimmediate_operand (operands[2], E_V16BFmode)
                  || !const_0_to_31_operand (operands[3], E_VOIDmode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10653; /* avx10_2_cmpbf16_v16bf_mask */

            default:
              return -1;
            }

        case 1:
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode)
                  || !nonimmediate_operand (operands[2], E_V8SImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3256; /* avx512vl_cmpv8si3_mask */

            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !nonimmediate_operand (operands[2], E_V4SImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3258; /* avx512vl_cmpv4si3_mask */

            case E_V8DImode:
              if (!register_operand (operands[1], E_V8DImode)
                  || !nonimmediate_operand (operands[2], E_V8DImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3261; /* avx512f_cmpv8di3_mask */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !nonimmediate_operand (operands[2], E_V4DImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3264; /* avx512vl_cmpv4di3_mask */

            case E_V2DImode:
              if (!register_operand (operands[1], E_V2DImode)
                  || !nonimmediate_operand (operands[2], E_V2DImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3266; /* avx512vl_cmpv2di3_mask */

            case E_V8HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[2], E_V8HFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 3274; /* avx512fp16_cmpv8hf3_mask */

            case E_V8SFmode:
              if (!register_operand (operands[1], E_V8SFmode)
                  || !nonimmediate_operand (operands[2], E_V8SFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3280; /* avx512vl_cmpv8sf3_mask */

            case E_V4SFmode:
              if (!register_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[2], E_V4SFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3282; /* avx512vl_cmpv4sf3_mask */

            case E_V8DFmode:
              if (!register_operand (operands[1], E_V8DFmode)
                  || !nonimmediate_operand (operands[2], E_V8DFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3285; /* avx512f_cmpv8df3_mask */

            case E_V4DFmode:
              if (!register_operand (operands[1], E_V4DFmode)
                  || !nonimmediate_operand (operands[2], E_V4DFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3288; /* avx512vl_cmpv4df3_mask */

            case E_V2DFmode:
              if (!register_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[2], E_V2DFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3290; /* avx512vl_cmpv2df3_mask */

            case E_V8HImode:
              if (!register_operand (operands[1], E_V8HImode)
                  || !nonimmediate_operand (operands[2], E_V8HImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3407; /* avx512vl_cmpv8hi3_mask */

            case E_V8BFmode:
              if (!register_operand (operands[1], E_V8BFmode)
                  || !nonimmediate_operand (operands[2], E_V8BFmode)
                  || !const_0_to_31_operand (operands[3], E_VOIDmode)
                  || !(
#line 122 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10655; /* avx10_2_cmpbf16_v8bf_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 1L
          || pattern1189 (x2) != 0)
        return -1;
      switch (pattern1493 ())
        {
        case 0:
          if (!(
#line 4822 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 3618; /* avx512f_vmcmpv8hf3 */

        case 1:
          if (!
#line 4822 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 3620; /* avx512f_vmcmpv4sf3 */

        case 2:
          if (!(
#line 4822 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3622; /* avx512f_vmcmpv2df3 */

        default:
          return -1;
        }

    case AND:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || pattern1189 (x2) != 0)
        return -1;
      x5 = XEXP (x3, 0);
      operands[4] = x5;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      switch (pattern1493 ())
        {
        case 0:
          if (!(
#line 4840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 3624; /* avx512f_vmcmpv8hf3_mask */

        case 1:
          if (!
#line 4840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 3626; /* avx512f_vmcmpv4sf3_mask */

        case 2:
          if (!(
#line 4840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3628; /* avx512f_vmcmpv2df3_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_49 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case LTU:
      switch (pattern43 (x1))
        {
        case 0:
          if (
#line 9905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
            return 530; /* *setcc_qi_negqi_ccc_1_cc */
          break;

        case 1:
          if (
#line 9905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
            return 531; /* *setcc_qi_negqi_ccc_1_ccc */
          break;

        default:
          break;
        }
      break;

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      res = recog_47 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  operands[1] = x2;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) == REG
      && REGNO (x3) == 17)
    {
      res = recog_48 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  switch (GET_CODE (operands[1]))
    {
    case NE:
    case EQ:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      operands[2] = x3;
      x5 = XEXP (x2, 1);
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (pattern741 (
E_V8QImode) != 0
              || !
#line 4218 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2235; /* *xop_maskcmp_unsv8qi3 */

        case E_V4HImode:
          if (pattern741 (
E_V4HImode) != 0
              || !
#line 4218 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2236; /* *xop_maskcmp_unsv4hi3 */

        case E_V2SImode:
          if (pattern741 (
E_V2SImode) != 0
              || !
#line 4218 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2237; /* *xop_maskcmp_unsv2si3 */

        case E_V4QImode:
          if (pattern741 (
E_V4QImode) != 0
              || !
#line 4228 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2238; /* *xop_maskcmp_unsv4qi3 */

        case E_V2QImode:
          if (pattern741 (
E_V2QImode) != 0
              || !
#line 4228 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2239; /* *xop_maskcmp_unsv2qi3 */

        case E_V2HImode:
          if (pattern741 (
E_V2HImode) != 0
              || !
#line 4228 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2240; /* *xop_maskcmp_unsv2hi3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_56 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode
              || !nonimmediate_operand (operands[1], E_HImode)
              || !general_operand (operands[2], E_HImode))
            return -1;
          if ((
#line 10616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF) && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
            return 590; /* *mulhi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 10616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
            return -1;
          *pnum_clobbers = 1;
          return 591; /* *mulhi3_1 */

        case E_QImode:
          if (pattern5 (x3, 
E_QImode) != 0)
            return -1;
          if (
#line 10703 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF))
            return 602; /* *mulqi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 10703 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 603; /* *mulqi3_1 */

        case E_HFmode:
          if (pattern5 (x3, 
E_HFmode) != 0
              || !
#line 23483 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 1678; /* *mulhf */

        case E_V2SImode:
          if (pattern7 (x3, 
E_V2SImode) != 0
              || !
#line 3352 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return -1;
          return 2158; /* mulv2si3 */

        case E_V4HImode:
          if (pattern8 (x3, 
E_V4HImode) != 0
              || !
#line 3381 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
            return -1;
          return 2159; /* *mmx_mulv4hi3 */

        case E_V2HImode:
          if (pattern7 (x3, 
E_V2HImode) != 0
              || !
#line 3396 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2160; /* mulv2hi3 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != ZERO_EXTEND)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          x7 = XEXP (x5, 0);
          operands[2] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_TImode:
              if (pnum_clobbers == NULL
                  || pattern849 (x3, 
E_DImode, 
E_TImode) != 0
                  || !(
#line 11006 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 618; /* *umulditi3_1 */

            case E_HImode:
              if (pattern849 (x3, 
E_QImode, 
E_HImode) != 0)
                return -1;
              if (
#line 11072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF))
                return 625; /* *umulqihi3_1_nf */
              if (pnum_clobbers == NULL
                  || !
#line 11072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              *pnum_clobbers = 1;
              return 626; /* *umulqihi3_1 */

            default:
              return -1;
            }

        case VEC_SELECT:
          if (GET_MODE (x6) != E_V1SImode)
            return -1;
          x8 = XEXP (x6, 1);
          if (GET_CODE (x8) != PARALLEL
              || XVECLEN (x8, 0) != 1)
            return -1;
          x9 = XVECEXP (x8, 0, 0);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x7 = XEXP (x5, 0);
          if (GET_CODE (x7) != VEC_SELECT
              || GET_MODE (x7) != E_V1SImode)
            return -1;
          x10 = XEXP (x7, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 1)
            return -1;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_V1DImode)
              || GET_MODE (x3) != E_V1DImode
              || GET_MODE (x4) != E_V1DImode)
            return -1;
          x12 = XEXP (x6, 0);
          operands[1] = x12;
          if (!register_mmxmem_operand (operands[1], E_V2SImode)
              || GET_MODE (x5) != E_V1DImode)
            return -1;
          x13 = XEXP (x7, 0);
          operands[2] = x13;
          if (!register_mmxmem_operand (operands[2], E_V2SImode)
              || !
#line 3636 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_SSE2
   && ix86_binary_operator_ok (MULT, V2SImode, operands)))
            return -1;
          return 2167; /* *sse2_umulv1siv1di3 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SIGN_EXTEND)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x7 = XEXP (x5, 0);
      operands[2] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (pattern849 (x3, 
E_DImode, 
E_TImode) != 0)
            return -1;
          if ((
#line 11052 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 621; /* *mulditi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 1199 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && (
#line 11052 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          *pnum_clobbers = 1;
          return 622; /* *mulditi3_1 */

        case E_HImode:
          if (pattern849 (x3, 
E_QImode, 
E_HImode) != 0)
            return -1;
          if (
#line 11072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF))
            return 623; /* *mulqihi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 11072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 624; /* *mulqihi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_64 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern45 (x3))
        {
        case 0:
          if (!
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (SS_PLUS, V8QImode, operands)))
            return -1;
          return 2138; /* *mmx_ssaddv8qi3 */

        case 1:
          if (!
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (SS_PLUS, V4HImode, operands)))
            return -1;
          return 2142; /* *mmx_ssaddv4hi3 */

        case 2:
          if (!
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2146; /* ssaddv4qi3 */

        case 3:
          if (!
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2150; /* ssaddv2qi3 */

        case 4:
          if (!
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2154; /* ssaddv2hi3 */

        default:
          return -1;
        }

    case VEC_SELECT:
      if (pattern101 (x3) != 0
          || !
#line 22618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
        return -1;
      return 8523; /* ssse3_phaddswv4hi3 */

    case MULT:
      if (GET_MODE (x4) != E_V4HImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != ZERO_EXTEND
          || GET_MODE (x5) != E_V4HImode)
        return -1;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != VEC_SELECT
          || GET_MODE (x6) != E_V4QImode)
        return -1;
      x7 = XEXP (x6, 1);
      if (GET_CODE (x7) != PARALLEL
          || XVECLEN (x7, 0) != 4
          || pattern1068 (x7, 
6, 
4, 
2, 
0) != 0)
        return -1;
      x8 = XEXP (x4, 1);
      if (pattern1255 (x8, 
E_V4QImode, 
E_V4HImode) != 0)
        return -1;
      x9 = XEXP (x8, 0);
      x10 = XEXP (x9, 1);
      if (pattern1602 (x10, 
6, 
4, 
2, 
0) != 0)
        return -1;
      x11 = XEXP (x3, 1);
      if (pattern1767 (x11, 
E_V4QImode, 
E_V4HImode, 
ZERO_EXTEND) != 0
          || !register_operand (operands[0], E_V4HImode)
          || GET_MODE (x3) != E_V4HImode)
        return -1;
      x12 = XEXP (x6, 0);
      operands[1] = x12;
      if (!register_operand (operands[1], E_V8QImode))
        return -1;
      x13 = XEXP (x9, 0);
      operands[2] = x13;
      if (!register_mmxmem_operand (operands[2], E_V8QImode))
        return -1;
      x14 = XEXP (x11, 0);
      x15 = XEXP (x14, 0);
      x16 = XEXP (x15, 0);
      if (!rtx_equal_p (x16, operands[1]))
        return -1;
      x17 = XEXP (x11, 1);
      x18 = XEXP (x17, 0);
      x19 = XEXP (x18, 0);
      if (!rtx_equal_p (x19, operands[2])
          || !
#line 22902 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
        return -1;
      return 8542; /* ssse3_pmaddubsw */

    default:
      return -1;
    }
}

 int
recog_68 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_CODE (operands[2]))
    {
    case CONST_INT:
      if (pnum_clobbers == NULL
          || !const_int_operand (operands[2], E_QImode)
          || !
#line 17280 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && INTVAL (operands[2]) == 31
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
        return -1;
      *pnum_clobbers = 1;
      return 1170; /* *ashrsi3_cvt_zext */

    case REG:
    case SUBREG:
      if (!register_operand (operands[2], E_SImode)
          || !
#line 17459 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
        return -1;
      return 1185; /* *bmi2_ashrsi3_1_zext */

    default:
      return -1;
    }
}

 int
recog_69 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x2) != E_DImode
          || GET_MODE (x3) != E_SImode)
        return -1;
      switch (XINT (x3, 1))
        {
        case 19:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 23231 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_X32))
            return -1;
          return 1660; /* *load_tp_x32_zext */

        case 49:
          x4 = XVECEXP (x3, 0, 0);
          switch (GET_CODE (x4))
            {
            case REG:
            case SUBREG:
              operands[1] = x4;
              switch (GET_MODE (operands[1]))
                {
                case E_V8SFmode:
                  if (register_operand (operands[1], E_V8SFmode)
                      && (
#line 21947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8440; /* *avx_movmskps256_uext */
                  break;

                case E_V4SFmode:
                  if (register_operand (operands[1], E_V4SFmode)
                      && 
#line 21947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return 8442; /* *sse_movmskps_uext */
                  break;

                case E_V4DFmode:
                  if (register_operand (operands[1], E_V4DFmode)
                      && (
#line 21947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8444; /* *avx_movmskpd256_uext */
                  break;

                case E_V2DFmode:
                  if (register_operand (operands[1], E_V2DFmode)
                      && (
#line 21947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return 8446; /* *sse2_movmskpd_uext */
                  break;

                case E_V32QImode:
                  if (register_operand (operands[1], E_V32QImode)
                      && (
#line 22102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return 8485; /* *avx2_pmovmskb_zext */
                  break;

                case E_V16QImode:
                  if (register_operand (operands[1], E_V16QImode)
                      && 
#line 22102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2))
                    return 8486; /* *sse2_pmovmskb_zext */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x4) != SUBREG)
                return -1;
              switch (pattern1074 (x4))
                {
                case 0:
                  if (!(
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8464; /* *avx_movmskps256_uext_lt_avx512 */

                case 1:
                  if (!
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return -1;
                  return 8466; /* *sse_movmskps_uext_lt_avx512 */

                case 2:
                  if (!(
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8468; /* *avx_movmskpd256_uext_lt_avx512 */

                case 3:
                  if (!(
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8470; /* *sse2_movmskpd_uext_lt_avx512 */

                case 4:
                  if (!(
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8476; /* *avx_movmskps256_uext_shift */

                case 5:
                  if (!
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return -1;
                  return 8478; /* *sse_movmskps_uext_shift */

                case 6:
                  if (!(
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8480; /* *avx_movmskpd256_uext_shift */

                case 7:
                  if (!(
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8482; /* *sse2_movmskpd_uext_shift */

                default:
                  return -1;
                }

            case LT:
              switch (pattern969 (x4))
                {
                case 0:
                  if (!(
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8456; /* *avx_movmskps256_uext_lt */

                case 1:
                  if (!
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return -1;
                  return 8458; /* *sse_movmskps_uext_lt */

                case 2:
                  if (!(
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8460; /* *avx_movmskpd256_uext_lt */

                case 3:
                  if (!(
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8462; /* *sse2_movmskpd_uext_lt */

                case 4:
                  if (!(
#line 22264 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8493; /* *avx2_pmovmskb_zext_lt */

                case 5:
                  if (!
#line 22264 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2))
                    return -1;
                  return 8494; /* *sse2_pmovmskb_zext_lt */

                default:
                  return -1;
                }

            case VEC_MERGE:
              switch (pattern971 (x4))
                {
                case 0:
                  if (!(
#line 22293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8495; /* *avx2_pmovmskb_zext_lt_avx512 */

                case 1:
                  if (!
#line 22293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2))
                    return -1;
                  return 8496; /* *sse2_pmovmskb_zext_lt_avx512 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 2:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      switch (XINT (x3, 1))
        {
        case 95:
          if (GET_MODE (x3) != E_SImode
              || !register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !register_operand (operands[1], E_SImode)
              || !nonimmediate_operand (operands[2], E_DImode)
              || !
#line 29096 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_CRC32))
            return -1;
          return 1894; /* sse4_2_crc32di */

        case 158:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              switch (pattern863 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (DImode))) && 
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8084; /* *avx512bw_testmv64qi3_zext */

                case 1:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8087; /* *avx512vl_testmv32qi3_zext */

                case 2:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && 
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8093; /* *avx512bw_testmv32hi3_zext */

                case 3:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8090; /* *avx512vl_testmv16qi3_zext */

                case 4:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8096; /* *avx512vl_testmv16hi3_zext */

                case 5:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8102; /* *avx512f_testmv16si3_zext */

                case 6:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8099; /* *avx512vl_testmv8hi3_zext */

                case 7:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8105; /* *avx512vl_testmv8si3_zext */

                case 8:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8108; /* *avx512vl_testmv4si3_zext */

                case 9:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8111; /* *avx512f_testmv8di3_zext */

                case 10:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8114; /* *avx512vl_testmv4di3_zext */

                case 11:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8117; /* *avx512vl_testmv2di3_zext */

                default:
                  return -1;
                }

            case E_SImode:
              switch (pattern863 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (DImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8085; /* *avx512bw_testmv64qi3_zext */

                case 1:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8088; /* *avx512vl_testmv32qi3_zext */

                case 2:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8094; /* *avx512bw_testmv32hi3_zext */

                case 3:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8091; /* *avx512vl_testmv16qi3_zext */

                case 4:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8097; /* *avx512vl_testmv16hi3_zext */

                case 5:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8103; /* *avx512f_testmv16si3_zext */

                case 6:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8100; /* *avx512vl_testmv8hi3_zext */

                case 7:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8106; /* *avx512vl_testmv8si3_zext */

                case 8:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8109; /* *avx512vl_testmv4si3_zext */

                case 9:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8112; /* *avx512f_testmv8di3_zext */

                case 10:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8115; /* *avx512vl_testmv4di3_zext */

                case 11:
                  if (!(
#line 19061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8118; /* *avx512vl_testmv2di3_zext */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 159:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              switch (pattern863 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (DImode))) && 
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8156; /* *avx512bw_testnmv64qi3_zext */

                case 1:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8159; /* *avx512vl_testnmv32qi3_zext */

                case 2:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && 
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8165; /* *avx512bw_testnmv32hi3_zext */

                case 3:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8162; /* *avx512vl_testnmv16qi3_zext */

                case 4:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8168; /* *avx512vl_testnmv16hi3_zext */

                case 5:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8174; /* *avx512f_testnmv16si3_zext */

                case 6:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8171; /* *avx512vl_testnmv8hi3_zext */

                case 7:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8177; /* *avx512vl_testnmv8si3_zext */

                case 8:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8180; /* *avx512vl_testnmv4si3_zext */

                case 9:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8183; /* *avx512f_testnmv8di3_zext */

                case 10:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8186; /* *avx512vl_testnmv4di3_zext */

                case 11:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8189; /* *avx512vl_testnmv2di3_zext */

                default:
                  return -1;
                }

            case E_SImode:
              switch (pattern863 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (DImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8157; /* *avx512bw_testnmv64qi3_zext */

                case 1:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8160; /* *avx512vl_testnmv32qi3_zext */

                case 2:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8166; /* *avx512bw_testnmv32hi3_zext */

                case 3:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8163; /* *avx512vl_testnmv16qi3_zext */

                case 4:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8169; /* *avx512vl_testnmv16hi3_zext */

                case 5:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8175; /* *avx512f_testnmv16si3_zext */

                case 6:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8172; /* *avx512vl_testnmv8hi3_zext */

                case 7:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8178; /* *avx512vl_testnmv8si3_zext */

                case 8:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8181; /* *avx512vl_testnmv4si3_zext */

                case 9:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8184; /* *avx512f_testnmv8di3_zext */

                case 10:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8187; /* *avx512vl_testnmv4di3_zext */

                case 11:
                  if (!(
#line 19091 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8190; /* *avx512vl_testnmv2di3_zext */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 3:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      if (!const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      switch (XINT (x3, 1))
        {
        case 59:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern1076 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3292; /* *avx512f_cmpv16si3_zero_extendsi */

                case 1:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3313; /* *avx512vl_cmpv16hf3_zero_extendsi */

                case 2:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3319; /* *avx512f_cmpv16sf3_zero_extendsi */

                case 3:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16QImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3412; /* *avx512vl_cmpv16qi3_zero_extendsi */

                case 4:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16HImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3421; /* *avx512vl_cmpv16hi3_zero_extendsi */

                case 5:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3295; /* *avx512vl_cmpv8si3_zero_extendsi */

                case 6:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3298; /* *avx512vl_cmpv4si3_zero_extendsi */

                case 7:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3301; /* *avx512f_cmpv8di3_zero_extendsi */

                case 8:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3304; /* *avx512vl_cmpv4di3_zero_extendsi */

                case 9:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3307; /* *avx512vl_cmpv2di3_zero_extendsi */

                case 10:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3316; /* *avx512fp16_cmpv8hf3_zero_extendsi */

                case 11:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3322; /* *avx512vl_cmpv8sf3_zero_extendsi */

                case 12:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3325; /* *avx512vl_cmpv4sf3_zero_extendsi */

                case 13:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3328; /* *avx512f_cmpv8df3_zero_extendsi */

                case 14:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3331; /* *avx512vl_cmpv4df3_zero_extendsi */

                case 15:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3334; /* *avx512vl_cmpv2df3_zero_extendsi */

                case 16:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V8HImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3424; /* *avx512vl_cmpv8hi3_zero_extendsi */

                case 17:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                    return -1;
                  return 3310; /* *avx512bw_cmpv32hf3_zero_extendsi */

                case 18:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32QImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3415; /* *avx512vl_cmpv32qi3_zero_extendsi */

                case 19:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32HImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3418; /* *avx512bw_cmpv32hi3_zero_extendsi */

                case 20:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V64QImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3409; /* *avx512bw_cmpv64qi3_zero_extendsi */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern1076 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3293; /* *avx512f_cmpv16si3_zero_extenddi */

                case 1:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3314; /* *avx512vl_cmpv16hf3_zero_extenddi */

                case 2:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3320; /* *avx512f_cmpv16sf3_zero_extenddi */

                case 3:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16QImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3413; /* *avx512vl_cmpv16qi3_zero_extenddi */

                case 4:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16HImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3422; /* *avx512vl_cmpv16hi3_zero_extenddi */

                case 5:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3296; /* *avx512vl_cmpv8si3_zero_extenddi */

                case 6:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3299; /* *avx512vl_cmpv4si3_zero_extenddi */

                case 7:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3302; /* *avx512f_cmpv8di3_zero_extenddi */

                case 8:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3305; /* *avx512vl_cmpv4di3_zero_extenddi */

                case 9:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3308; /* *avx512vl_cmpv2di3_zero_extenddi */

                case 10:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3317; /* *avx512fp16_cmpv8hf3_zero_extenddi */

                case 11:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3323; /* *avx512vl_cmpv8sf3_zero_extenddi */

                case 12:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3326; /* *avx512vl_cmpv4sf3_zero_extenddi */

                case 13:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3329; /* *avx512f_cmpv8df3_zero_extenddi */

                case 14:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3332; /* *avx512vl_cmpv4df3_zero_extenddi */

                case 15:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3335; /* *avx512vl_cmpv2df3_zero_extenddi */

                case 16:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V8HImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3425; /* *avx512vl_cmpv8hi3_zero_extenddi */

                case 17:
                  if (!(
#line 4415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                    return -1;
                  return 3311; /* *avx512bw_cmpv32hf3_zero_extenddi */

                case 18:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32QImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3416; /* *avx512vl_cmpv32qi3_zero_extenddi */

                case 19:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32HImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3419; /* *avx512bw_cmpv32hi3_zero_extenddi */

                case 20:
                  if (!(
#line 4505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V64QImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3410; /* *avx512bw_cmpv64qi3_zero_extenddi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 157:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern1078 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3493; /* *avx512bw_ucmpv64qi3_zero_extendsi */

                case 1:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3496; /* *avx512vl_ucmpv16qi3_zero_extendsi */

                case 2:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3505; /* *avx512vl_ucmpv16hi3_zero_extendsi */

                case 3:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3570; /* *avx512f_ucmpv16si3_zero_extendsi */

                case 4:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3499; /* *avx512vl_ucmpv32qi3_zero_extendsi */

                case 5:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3502; /* *avx512bw_ucmpv32hi3_zero_extendsi */

                case 6:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3508; /* *avx512vl_ucmpv8hi3_zero_extendsi */

                case 7:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3571; /* *avx512vl_ucmpv8si3_zero_extendsi */

                case 8:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3572; /* *avx512vl_ucmpv4si3_zero_extendsi */

                case 9:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3573; /* *avx512f_ucmpv8di3_zero_extendsi */

                case 10:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3574; /* *avx512vl_ucmpv4di3_zero_extendsi */

                case 11:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3575; /* *avx512vl_ucmpv2di3_zero_extendsi */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern1078 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3494; /* *avx512bw_ucmpv64qi3_zero_extenddi */

                case 1:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3497; /* *avx512vl_ucmpv16qi3_zero_extenddi */

                case 2:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3506; /* *avx512vl_ucmpv16hi3_zero_extenddi */

                case 3:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3576; /* *avx512f_ucmpv16si3_zero_extenddi */

                case 4:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3500; /* *avx512vl_ucmpv32qi3_zero_extenddi */

                case 5:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3503; /* *avx512bw_ucmpv32hi3_zero_extenddi */

                case 6:
                  if (!(
#line 4615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3509; /* *avx512vl_ucmpv8hi3_zero_extenddi */

                case 7:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3577; /* *avx512vl_ucmpv8si3_zero_extenddi */

                case 8:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3578; /* *avx512vl_ucmpv4si3_zero_extenddi */

                case 9:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3579; /* *avx512f_ucmpv8di3_zero_extenddi */

                case 10:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3580; /* *avx512vl_ucmpv4di3_zero_extenddi */

                case 11:
                  if (!(
#line 4704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3581; /* *avx512vl_ucmpv2di3_zero_extenddi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_132 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[3] = x6;
      x7 = XEXP (x2, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1353 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4025; /* fma_fmaddsub_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1353 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4029; /* fma_fmaddsub_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1353 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4031; /* fma_fmaddsub_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1353 (x2, 
E_V16SFmode, 
E_HImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4033; /* fma_fmaddsub_v16sf_maskz_1 */

            case E_V8SFmode:
              if (pattern1353 (x2, 
E_V8SFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4037; /* fma_fmaddsub_v8sf_maskz_1 */

            case E_V4SFmode:
              if (pattern1353 (x2, 
E_V4SFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4039; /* fma_fmaddsub_v4sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1353 (x2, 
E_V8DFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4041; /* fma_fmaddsub_v8df_maskz_1 */

            case E_V4DFmode:
              if (pattern1353 (x2, 
E_V4DFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4045; /* fma_fmaddsub_v4df_maskz_1 */

            case E_V2DFmode:
              if (pattern1353 (x2, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4047; /* fma_fmaddsub_v2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          x8 = XEXP (x2, 2);
          operands[4] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1260 (x2, 
E_V32HFmode, 
E_SImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V32HFmode)
                  && vector_operand (operands[3], E_V32HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return 4048; /* avx512bw_fmaddsub_v32hf_mask */
              if (!nonimmediate_operand (operands[1], E_V32HFmode)
                  || !nonimmediate_operand (operands[3], E_V32HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4066; /* avx512bw_fmaddsub_v32hf_mask3 */

            case E_V16HFmode:
              if (pattern1260 (x2, 
E_V16HFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V16HFmode)
                  && vector_operand (operands[3], E_V16HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4050; /* avx512vl_fmaddsub_v16hf_mask */
              if (!nonimmediate_operand (operands[1], E_V16HFmode)
                  || !nonimmediate_operand (operands[3], E_V16HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4068; /* avx512vl_fmaddsub_v16hf_mask3 */

            case E_V8HFmode:
              if (pattern1260 (x2, 
E_V8HFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8HFmode)
                  && vector_operand (operands[3], E_V8HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4052; /* avx512fp16_fmaddsub_v8hf_mask */
              if (!nonimmediate_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[3], E_V8HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4070; /* avx512fp16_fmaddsub_v8hf_mask3 */

            case E_V16SFmode:
              if (pattern1260 (x2, 
E_V16SFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V16SFmode)
                  && vector_operand (operands[3], E_V16SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4054; /* avx512f_fmaddsub_v16sf_mask */
              if (!nonimmediate_operand (operands[1], E_V16SFmode)
                  || !nonimmediate_operand (operands[3], E_V16SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4072; /* avx512f_fmaddsub_v16sf_mask3 */

            case E_V8SFmode:
              if (pattern1260 (x2, 
E_V8SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8SFmode)
                  && vector_operand (operands[3], E_V8SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4056; /* avx512vl_fmaddsub_v8sf_mask */
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !nonimmediate_operand (operands[3], E_V8SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4074; /* avx512vl_fmaddsub_v8sf_mask3 */

            case E_V4SFmode:
              if (pattern1260 (x2, 
E_V4SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V4SFmode)
                  && vector_operand (operands[3], E_V4SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4058; /* avx512vl_fmaddsub_v4sf_mask */
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[3], E_V4SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4076; /* avx512vl_fmaddsub_v4sf_mask3 */

            case E_V8DFmode:
              if (pattern1260 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8DFmode)
                  && vector_operand (operands[3], E_V8DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4060; /* avx512f_fmaddsub_v8df_mask */
              if (!nonimmediate_operand (operands[1], E_V8DFmode)
                  || !nonimmediate_operand (operands[3], E_V8DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4078; /* avx512f_fmaddsub_v8df_mask3 */

            case E_V4DFmode:
              if (pattern1260 (x2, 
E_V4DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V4DFmode)
                  && vector_operand (operands[3], E_V4DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4062; /* avx512vl_fmaddsub_v4df_mask */
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !nonimmediate_operand (operands[3], E_V4DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4080; /* avx512vl_fmaddsub_v4df_mask3 */

            case E_V2DFmode:
              if (pattern1260 (x2, 
E_V2DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V2DFmode)
                  && vector_operand (operands[3], E_V2DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4064; /* avx512vl_fmaddsub_v2df_mask */
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[3], E_V2DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4082; /* avx512vl_fmaddsub_v2df_mask3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x9 = XEXP (x6, 0);
      operands[3] = x9;
      x7 = XEXP (x2, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1354 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4089; /* fma_fmsubadd_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1354 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4093; /* fma_fmsubadd_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1354 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4095; /* fma_fmsubadd_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1354 (x2, 
E_V16SFmode, 
E_HImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4097; /* fma_fmsubadd_v16sf_maskz_1 */

            case E_V8SFmode:
              if (pattern1354 (x2, 
E_V8SFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4101; /* fma_fmsubadd_v8sf_maskz_1 */

            case E_V4SFmode:
              if (pattern1354 (x2, 
E_V4SFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4103; /* fma_fmsubadd_v4sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1354 (x2, 
E_V8DFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4105; /* fma_fmsubadd_v8df_maskz_1 */

            case E_V4DFmode:
              if (pattern1354 (x2, 
E_V4DFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4109; /* fma_fmsubadd_v4df_maskz_1 */

            case E_V2DFmode:
              if (pattern1354 (x2, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4111; /* fma_fmsubadd_v2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          x8 = XEXP (x2, 2);
          operands[4] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1261 (x2, 
E_V32HFmode, 
E_SImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V32HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return 4112; /* avx512bw_fmsubadd_v32hf_mask */
              if (!nonimmediate_operand (operands[3], E_V32HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4130; /* avx512bw_fmsubadd_v32hf_mask3 */

            case E_V16HFmode:
              if (pattern1261 (x2, 
E_V16HFmode, 
E_HImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V16HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4114; /* avx512vl_fmsubadd_v16hf_mask */
              if (!nonimmediate_operand (operands[3], E_V16HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4132; /* avx512vl_fmsubadd_v16hf_mask3 */

            case E_V8HFmode:
              if (pattern1261 (x2, 
E_V8HFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V8HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4116; /* avx512fp16_fmsubadd_v8hf_mask */
              if (!nonimmediate_operand (operands[3], E_V8HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4134; /* avx512fp16_fmsubadd_v8hf_mask3 */

            case E_V16SFmode:
              if (pattern1261 (x2, 
E_V16SFmode, 
E_HImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V16SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4118; /* avx512f_fmsubadd_v16sf_mask */
              if (!nonimmediate_operand (operands[3], E_V16SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4136; /* avx512f_fmsubadd_v16sf_mask3 */

            case E_V8SFmode:
              if (pattern1261 (x2, 
E_V8SFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V8SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4120; /* avx512vl_fmsubadd_v8sf_mask */
              if (!nonimmediate_operand (operands[3], E_V8SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4138; /* avx512vl_fmsubadd_v8sf_mask3 */

            case E_V4SFmode:
              if (pattern1261 (x2, 
E_V4SFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V4SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4122; /* avx512vl_fmsubadd_v4sf_mask */
              if (!nonimmediate_operand (operands[3], E_V4SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4140; /* avx512vl_fmsubadd_v4sf_mask3 */

            case E_V8DFmode:
              if (pattern1261 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V8DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4124; /* avx512f_fmsubadd_v8df_mask */
              if (!nonimmediate_operand (operands[3], E_V8DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4142; /* avx512f_fmsubadd_v8df_mask3 */

            case E_V4DFmode:
              if (pattern1261 (x2, 
E_V4DFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V4DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4126; /* avx512vl_fmsubadd_v4df_mask */
              if (!nonimmediate_operand (operands[3], E_V4DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4144; /* avx512vl_fmsubadd_v4df_mask3 */

            case E_V2DFmode:
              if (pattern1261 (x2, 
E_V2DFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V2DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4128; /* avx512vl_fmsubadd_v2df_mask */
              if (!nonimmediate_operand (operands[3], E_V2DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4146; /* avx512vl_fmsubadd_v2df_mask3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_157 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern633 (x2))
    {
    case 0:
      if (pattern1366 (x2, 
E_V32HFmode, 
E_SImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5931 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3830; /* fma_fmsub_v32hf_maskz_1 */

    case 1:
      if (pattern1366 (x2, 
E_V16HFmode, 
E_HImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3834; /* fma_fmsub_v16hf_maskz_1 */

    case 2:
      if (pattern1366 (x2, 
E_V8HFmode, 
E_QImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5933 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3836; /* fma_fmsub_v8hf_maskz_1 */

    case 3:
      if (pattern1366 (x2, 
E_V16SFmode, 
E_HImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5935 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3840; /* fma_fmsub_v16sf_maskz_1 */

    case 4:
      if (pattern1366 (x2, 
E_V8SFmode, 
E_QImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3844; /* fma_fmsub_v8sf_maskz_1 */

    case 5:
      if (pattern1366 (x2, 
E_V4SFmode, 
E_QImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3846; /* fma_fmsub_v4sf_maskz_1 */

    case 6:
      if (pattern1366 (x2, 
E_V8DFmode, 
E_QImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5937 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3849; /* fma_fmsub_v8df_maskz_1 */

    case 7:
      if (pattern1366 (x2, 
E_V4DFmode, 
E_QImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3853; /* fma_fmsub_v4df_maskz_1 */

    case 8:
      if (pattern1366 (x2, 
E_V2DFmode, 
E_QImode) != 0
          || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3855; /* fma_fmsub_v2df_maskz_1 */

    case 9:
      if (pattern1368 (x2, 
E_SImode, 
E_V32BFmode) != 0
          || !
#line 32284 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10579; /* avx10_2_fmsubbf16_v32bf_maskz_1 */

    case 10:
      if (pattern1368 (x2, 
E_HImode, 
E_V16BFmode) != 0
          || !
#line 32284 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10581; /* avx10_2_fmsubbf16_v16bf_maskz_1 */

    case 11:
      if (pattern1368 (x2, 
E_QImode, 
E_V8BFmode) != 0
          || !
#line 32284 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10583; /* avx10_2_fmsubbf16_v8bf_maskz_1 */

    case 12:
      if (pattern1370 (x2, 
E_V4SFmode) != 0
          || !
#line 6975 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4))
        return -1;
      return 4246; /* *fma4i_vmfmsub_v4sf */

    case 13:
      if (pattern1370 (x2, 
E_V2DFmode) != 0
          || !(
#line 6975 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 4247; /* *fma4i_vmfmsub_v2df */

    case 14:
      if (pattern1278 (x2, 
E_V32HFmode, 
E_SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V32HFmode)
          && vector_operand (operands[3], E_V32HFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return 3856; /* avx512bw_fmsub_v32hf_mask */
        }
      if (!vector_operand (operands[1], E_V32HFmode)
          || !nonimmediate_operand (operands[3], E_V32HFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3874; /* avx512bw_fmsub_v32hf_mask3 */

    case 15:
      if (pattern1278 (x2, 
E_V16HFmode, 
E_HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16HFmode)
          && vector_operand (operands[3], E_V16HFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3858; /* avx512vl_fmsub_v16hf_mask */
        }
      if (!vector_operand (operands[1], E_V16HFmode)
          || !nonimmediate_operand (operands[3], E_V16HFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3876; /* avx512vl_fmsub_v16hf_mask3 */

    case 16:
      if (pattern1278 (x2, 
E_V8HFmode, 
E_QImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8HFmode)
          && vector_operand (operands[3], E_V8HFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3860; /* avx512fp16_fmsub_v8hf_mask */
        }
      if (!vector_operand (operands[1], E_V8HFmode)
          || !nonimmediate_operand (operands[3], E_V8HFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3877; /* avx512fp16_fmsub_v8hf_mask3 */

    case 17:
      if (pattern1278 (x2, 
E_V16SFmode, 
E_HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16SFmode)
          && vector_operand (operands[3], E_V16SFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3862; /* avx512f_fmsub_v16sf_mask */
        }
      if (!vector_operand (operands[1], E_V16SFmode)
          || !nonimmediate_operand (operands[3], E_V16SFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3878; /* avx512f_fmsub_v16sf_mask3 */

    case 18:
      if (pattern1278 (x2, 
E_V8SFmode, 
E_QImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SFmode)
          && vector_operand (operands[3], E_V8SFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3864; /* avx512vl_fmsub_v8sf_mask */
        }
      if (!vector_operand (operands[1], E_V8SFmode)
          || !nonimmediate_operand (operands[3], E_V8SFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3880; /* avx512vl_fmsub_v8sf_mask3 */

    case 19:
      if (pattern1278 (x2, 
E_V4SFmode, 
E_QImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SFmode)
          && vector_operand (operands[3], E_V4SFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3866; /* avx512vl_fmsub_v4sf_mask */
        }
      if (!vector_operand (operands[1], E_V4SFmode)
          || !nonimmediate_operand (operands[3], E_V4SFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3881; /* avx512vl_fmsub_v4sf_mask3 */

    case 20:
      if (pattern1278 (x2, 
E_V8DFmode, 
E_QImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8DFmode)
          && vector_operand (operands[3], E_V8DFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3868; /* avx512f_fmsub_v8df_mask */
        }
      if (!vector_operand (operands[1], E_V8DFmode)
          || !nonimmediate_operand (operands[3], E_V8DFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3882; /* avx512f_fmsub_v8df_mask3 */

    case 21:
      if (pattern1278 (x2, 
E_V4DFmode, 
E_QImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DFmode)
          && vector_operand (operands[3], E_V4DFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3870; /* avx512vl_fmsub_v4df_mask */
        }
      if (!vector_operand (operands[1], E_V4DFmode)
          || !nonimmediate_operand (operands[3], E_V4DFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3884; /* avx512vl_fmsub_v4df_mask3 */

    case 22:
      if (pattern1278 (x2, 
E_V2DFmode, 
E_QImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DFmode)
          && vector_operand (operands[3], E_V2DFmode))
        {
          x3 = XEXP (x2, 1);
          if (rtx_equal_p (x3, operands[1])
              && (
#line 6092 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3872; /* avx512vl_fmsub_v2df_mask */
        }
      if (!vector_operand (operands[1], E_V2DFmode)
          || !nonimmediate_operand (operands[3], E_V2DFmode))
        return -1;
      x3 = XEXP (x2, 1);
      if (!rtx_equal_p (x3, operands[3])
          || !(
#line 6110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3885; /* avx512vl_fmsub_v2df_mask3 */

    case 23:
      if (pattern1280 (x2, 
E_SImode, 
E_V32BFmode) != 0)
        return -1;
      x3 = XEXP (x2, 1);
      if (rtx_equal_p (x3, operands[1])
          && 
#line 32303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return 10584; /* avx10_2_fmsubbf16_v32bf_mask */
      if (!rtx_equal_p (x3, operands[3])
          || !
#line 32321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10587; /* avx10_2_fmsubbf16_v32bf_mask3 */

    case 24:
      if (pattern1280 (x2, 
E_HImode, 
E_V16BFmode) != 0)
        return -1;
      x3 = XEXP (x2, 1);
      if (rtx_equal_p (x3, operands[1])
          && 
#line 32303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return 10585; /* avx10_2_fmsubbf16_v16bf_mask */
      if (!rtx_equal_p (x3, operands[3])
          || !
#line 32321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10588; /* avx10_2_fmsubbf16_v16bf_mask3 */

    case 25:
      if (pattern1280 (x2, 
E_QImode, 
E_V8BFmode) != 0)
        return -1;
      x3 = XEXP (x2, 1);
      if (rtx_equal_p (x3, operands[1])
          && 
#line 32303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return 10586; /* avx10_2_fmsubbf16_v8bf_mask */
      if (!rtx_equal_p (x3, operands[3])
          || !
#line 32321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10589; /* avx10_2_fmsubbf16_v8bf_mask3 */

    case 26:
      if (pattern1371 (x2, 
E_V8HFmode) != 0
          || !(
#line 6618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
        return -1;
      return 4154; /* *fmai_fmsub_v8hf */

    case 27:
      if (pattern1371 (x2, 
E_V4SFmode) != 0
          || !
#line 6618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F))
        return -1;
      return 4156; /* *fmai_fmsub_v4sf */

    case 28:
      if (pattern1371 (x2, 
E_V2DFmode) != 0
          || !(
#line 6618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 4158; /* *fmai_fmsub_v2df */

    default:
      return -1;
    }
}

 int
recog_161 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (pattern917 (x4) != 0)
    return -1;
  x5 = XEXP (x2, 2);
  if (!register_operand (x5, E_QImode))
    return -1;
  x6 = XVECEXP (x4, 0, 0);
  switch (XWINT (x6, 0))
    {
    case 2L:
      x7 = XVECEXP (x4, 0, 1);
      if (XWINT (x7, 0) != 10L)
        return -1;
      x8 = XVECEXP (x4, 0, 2);
      if (XWINT (x8, 0) != 3L)
        return -1;
      x9 = XVECEXP (x4, 0, 3);
      if (XWINT (x9, 0) != 11L
          || pattern1715 (x2) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1563 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
            return -1;
          return 5153; /* avx_unpckhps256_mask */

        case E_V8SImode:
          if (pattern1563 (x2, 
E_V8SImode, 
E_V16SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19710 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return -1;
          return 8295; /* avx2_interleave_highv8si_mask */

        default:
          return -1;
        }

    case 0L:
      x7 = XVECEXP (x4, 0, 1);
      switch (XWINT (x7, 0))
        {
        case 8L:
          x8 = XVECEXP (x4, 0, 2);
          switch (XWINT (x8, 0))
            {
            case 1L:
              x9 = XVECEXP (x4, 0, 3);
              if (XWINT (x9, 0) != 9L)
                return -1;
              x10 = XEXP (x3, 0);
              x11 = XEXP (x10, 1);
              operands[2] = x11;
              x12 = XEXP (x2, 1);
              operands[3] = x12;
              operands[4] = x5;
              x13 = XVECEXP (x4, 0, 4);
              switch (XWINT (x13, 0))
                {
                case 4L:
                  x14 = XVECEXP (x4, 0, 5);
                  if (XWINT (x14, 0) != 12L)
                    return -1;
                  x15 = XVECEXP (x4, 0, 6);
                  if (XWINT (x15, 0) != 5L)
                    return -1;
                  x16 = XVECEXP (x4, 0, 7);
                  if (XWINT (x16, 0) != 13L)
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V8SFmode:
                      if (pattern1563 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11243 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                        return -1;
                      return 5159; /* avx_unpcklps256_mask */

                    case E_V8SImode:
                      if (pattern1563 (x2, 
E_V8SImode, 
E_V16SImode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
                        return -1;
                      return 8301; /* avx2_interleave_lowv8si_mask */

                    default:
                      return -1;
                    }

                case 2L:
                  x14 = XVECEXP (x4, 0, 5);
                  if (XWINT (x14, 0) != 10L)
                    return -1;
                  x15 = XVECEXP (x4, 0, 6);
                  if (XWINT (x15, 0) != 3L)
                    return -1;
                  x16 = XVECEXP (x4, 0, 7);
                  if (XWINT (x16, 0) != 11L)
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V8HImode:
                      if (pattern1564 (x2, 
E_V8HImode, 
E_V16HImode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19690 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                        return -1;
                      return 8289; /* vec_interleave_lowv8hi_mask */

                    case E_V8HFmode:
                      if (pattern1564 (x2, 
E_V8HFmode, 
E_V16HFmode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19690 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                        return -1;
                      return 8291; /* vec_interleave_lowv8hf_mask */

                    case E_V8BFmode:
                      if (pattern1564 (x2, 
E_V8BFmode, 
E_V16BFmode) != 0
                          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19690 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                        return -1;
                      return 8293; /* vec_interleave_lowv8bf_mask */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case 2L:
              x9 = XVECEXP (x4, 0, 3);
              if (XWINT (x9, 0) != 10L)
                return -1;
              x13 = XVECEXP (x4, 0, 4);
              if (XWINT (x13, 0) != 4L)
                return -1;
              x14 = XVECEXP (x4, 0, 5);
              if (XWINT (x14, 0) != 12L)
                return -1;
              x15 = XVECEXP (x4, 0, 6);
              if (XWINT (x15, 0) != 6L)
                return -1;
              x16 = XVECEXP (x4, 0, 7);
              if (XWINT (x16, 0) != 14L)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V8DFmode:
                  if (pattern1620 (x2, 
E_V8DFmode, 
E_V16DFmode) != 0)
                    return -1;
                  x12 = XEXP (x2, 1);
                  operands[2] = x12;
                  if (nonimmediate_operand (operands[1], E_V8DFmode))
                    {
                      operands[3] = x5;
                      x10 = XEXP (x3, 0);
                      x11 = XEXP (x10, 1);
                      if (rtx_equal_p (x11, operands[1])
                          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                        return 5311; /* avx512f_movddup512_mask */
                    }
                  operands[3] = x12;
                  if (!register_operand (operands[1], E_V8DFmode))
                    return -1;
                  x10 = XEXP (x3, 0);
                  x11 = XEXP (x10, 1);
                  operands[2] = x11;
                  if (!nonimmediate_operand (operands[2], E_V8DFmode))
                    return -1;
                  operands[4] = x5;
                  if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return -1;
                  return 5313; /* avx512f_unpcklpd512_mask */

                case E_V8DImode:
                  if (pattern1621 (x2, 
E_V8DImode, 
E_V16DImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return -1;
                  return 7132; /* avx512f_interleave_lowv8di_mask */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 0L:
          if (pattern1649 (x4) != 0
              || pattern1790 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11382 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
            return -1;
          return 5169; /* avx_movsldup256_mask */

        default:
          return -1;
        }

    case 1L:
      x8 = XVECEXP (x4, 0, 2);
      if (XWINT (x8, 0) != 3L)
        return -1;
      x13 = XVECEXP (x4, 0, 4);
      if (XWINT (x13, 0) != 5L)
        return -1;
      x15 = XVECEXP (x4, 0, 6);
      if (XWINT (x15, 0) != 7L)
        return -1;
      x7 = XVECEXP (x4, 0, 1);
      switch (XWINT (x7, 0))
        {
        case 1L:
          x9 = XVECEXP (x4, 0, 3);
          if (XWINT (x9, 0) != 3L)
            return -1;
          x14 = XVECEXP (x4, 0, 5);
          if (XWINT (x14, 0) != 5L)
            return -1;
          x16 = XVECEXP (x4, 0, 7);
          if (XWINT (x16, 0) != 7L
              || pattern1790 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11329 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
            return -1;
          return 5163; /* avx_movshdup256_mask */

        case 9L:
          x9 = XVECEXP (x4, 0, 3);
          if (XWINT (x9, 0) != 11L)
            return -1;
          x14 = XVECEXP (x4, 0, 5);
          if (XWINT (x14, 0) != 13L)
            return -1;
          x16 = XVECEXP (x4, 0, 7);
          if (XWINT (x16, 0) != 15L)
            return -1;
          x10 = XEXP (x3, 0);
          x11 = XEXP (x10, 1);
          operands[2] = x11;
          x12 = XEXP (x2, 1);
          operands[3] = x12;
          operands[4] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1563 (x2, 
E_V8DFmode, 
E_V16DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5305; /* avx512f_unpckhpd512_mask */

            case E_V8DImode:
              if (pattern1563 (x2, 
E_V8DImode, 
E_V16DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7126; /* avx512f_interleave_highv8di_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4L:
      x7 = XVECEXP (x4, 0, 1);
      if (XWINT (x7, 0) != 12L)
        return -1;
      x8 = XVECEXP (x4, 0, 2);
      if (XWINT (x8, 0) != 5L)
        return -1;
      x9 = XVECEXP (x4, 0, 3);
      if (XWINT (x9, 0) != 13L
          || pattern1715 (x2) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          if (pattern1564 (x2, 
E_V8HImode, 
E_V16HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19622 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8271; /* vec_interleave_highv8hi_mask */

        case E_V8HFmode:
          if (pattern1564 (x2, 
E_V8HFmode, 
E_V16HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19622 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8273; /* vec_interleave_highv8hf_mask */

        case E_V8BFmode:
          if (pattern1564 (x2, 
E_V8BFmode, 
E_V16BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19622 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8275; /* vec_interleave_highv8bf_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_180 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
      x5 = XEXP (x3, 1);
      switch (GET_CODE (x5))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case REG:
        case SUBREG:
        case MEM:
          operands[3] = x5;
          x6 = XEXP (x2, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          operands[2] = x4;
          x7 = XEXP (x3, 2);
          operands[4] = x7;
          if (!register_operand (operands[4], E_QImode))
            return -1;
          x8 = XEXP (x2, 1);
          operands[1] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1266 (x2, 
E_V8HFmode) != 0
                  || !(
#line 1695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 2497; /* avx512f_movhf_mask */

            case E_V4SFmode:
              if (pattern1266 (x2, 
E_V4SFmode) != 0
                  || !
#line 1695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2498; /* avx512f_movsf_mask */

            case E_V2DFmode:
              if (pattern1266 (x2, 
E_V2DFmode) != 0
                  || !(
#line 1695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2499; /* avx512f_movdf_mask */

            default:
              return -1;
            }

        case VEC_DUPLICATE:
          operands[1] = x4;
          x9 = XEXP (x5, 0);
          operands[2] = x9;
          x7 = XEXP (x3, 2);
          operands[3] = x7;
          if (!const_int_operand (operands[3], E_SImode))
            return -1;
          x8 = XEXP (x2, 1);
          operands[4] = x8;
          x6 = XEXP (x2, 2);
          operands[5] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1267 (x2, 
E_V8DFmode, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 12379 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_EVEX512))))
                return -1;
              return 8317; /* avx512dq_vinsertf64x2_1_mask */

            case E_V8DImode:
              if (pattern1267 (x2, 
E_V8DImode, 
E_V2DImode, 
E_QImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 12380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_EVEX512))))
                return -1;
              return 8319; /* avx512dq_vinserti64x2_1_mask */

            case E_V16SFmode:
              if (pattern1267 (x2, 
E_V16SFmode, 
E_V4SFmode, 
E_HImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 12381 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8321; /* avx512f_vinsertf32x4_1_mask */

            case E_V16SImode:
              if (pattern1267 (x2, 
E_V16SImode, 
E_V4SImode, 
E_HImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 12381 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8323; /* avx512f_vinserti32x4_1_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_DUPLICATE:
      x10 = XEXP (x4, 0);
      switch (GET_CODE (x10))
        {
        case SUBREG:
        case MEM:
          operands[1] = x10;
          x6 = XEXP (x2, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          x7 = XEXP (x3, 2);
          operands[3] = x7;
          if (!register_operand (operands[3], E_QImode))
            return -1;
          x8 = XEXP (x2, 1);
          operands[4] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1268 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                  || !(
#line 1724 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1355 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16)))
                return -1;
              return 2500; /* *avx512f_loadhf_mask */

            case E_V4SFmode:
              if (pattern1268 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                  || !
#line 1724 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2501; /* *avx512f_loadsf_mask */

            case E_V2DFmode:
              if (pattern1268 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                  || !
#line 1724 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2502; /* *avx512f_loaddf_mask */

            default:
              return -1;
            }

        case SQRT:
          x6 = XEXP (x2, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x11 = XEXP (x10, 0);
          operands[1] = x11;
          x5 = XEXP (x3, 1);
          operands[3] = x5;
          x7 = XEXP (x3, 2);
          operands[4] = x7;
          if (!register_operand (operands[4], E_QImode))
            return -1;
          x8 = XEXP (x2, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1269 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 2942; /* *avx512fp16_vmsqrtv8hf2_mask */

            case E_V4SFmode:
              if (pattern1269 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 2946; /* *sse_vmsqrtv4sf2_mask */

            case E_V2DFmode:
              if (pattern1269 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 2950; /* *sse2_vmsqrtv2df2_mask */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x10, 0) != 1
              || XINT (x10, 1) != 55
              || GET_MODE (x10) != E_HFmode)
            return -1;
          x6 = XEXP (x2, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || pattern990 (x2, 
E_V8HFmode) != 0)
            return -1;
          x12 = XVECEXP (x10, 0, 0);
          operands[1] = x12;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          x5 = XEXP (x3, 1);
          operands[3] = x5;
          if (!nonimm_or_0_operand (operands[3], E_V8HFmode))
            return -1;
          x7 = XEXP (x3, 2);
          operands[4] = x7;
          if (!register_operand (operands[4], E_QImode))
            return -1;
          x8 = XEXP (x2, 1);
          operands[2] = x8;
          if (!register_operand (operands[2], E_V8HFmode)
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3254 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2981; /* *avx512fp16_vmrsqrtv8hf2 */

        case FLOAT_EXTEND:
          x6 = XEXP (x2, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x5 = XEXP (x3, 1);
          operands[3] = x5;
          x7 = XEXP (x3, 2);
          operands[4] = x7;
          if (!register_operand (operands[4], E_QImode))
            return -1;
          x8 = XEXP (x2, 1);
          operands[2] = x8;
          x11 = XEXP (x10, 0);
          switch (GET_CODE (x11))
            {
            case VEC_SELECT:
              if (GET_MODE (x11) != E_HFmode)
                return -1;
              x13 = XEXP (x11, 1);
              if (GET_CODE (x13) != PARALLEL
                  || XVECLEN (x13, 0) != 1)
                return -1;
              x14 = XVECEXP (x13, 0, 0);
              if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x15 = XEXP (x11, 0);
              operands[1] = x15;
              if (!register_operand (operands[1], E_V8HFmode))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V2DFmode:
                  if (pattern1444 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                      || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4692; /* avx512fp16_vcvtsh2sd_mask */

                case E_V4SFmode:
                  if (pattern1444 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                      || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4696; /* avx512fp16_vcvtsh2ss_mask */

                default:
                  return -1;
                }

            case SUBREG:
            case MEM:
              operands[1] = x11;
              if (!memory_operand (operands[1], E_HFmode))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V2DFmode:
                  if (pattern1444 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                      || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4700; /* avx512fp16_vcvtsh2sd_mask_mem */

                case E_V4SFmode:
                  if (pattern1444 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                      || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4702; /* avx512fp16_vcvtsh2ss_mask_mem */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case FLOAT_TRUNCATE:
          x11 = XEXP (x10, 0);
          switch (GET_CODE (x11))
            {
            case VEC_SELECT:
              x13 = XEXP (x11, 1);
              if (GET_CODE (x13) != PARALLEL
                  || XVECLEN (x13, 0) != 1)
                return -1;
              x14 = XVECEXP (x13, 0, 0);
              if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x6 = XEXP (x2, 2);
              if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
                  || pattern876 (x2, 
E_HFmode, 
E_V8HFmode) != 0)
                return -1;
              x15 = XEXP (x11, 0);
              operands[1] = x15;
              x5 = XEXP (x3, 1);
              operands[3] = x5;
              if (!nonimm_or_0_operand (operands[3], E_V8HFmode))
                return -1;
              x7 = XEXP (x3, 2);
              operands[4] = x7;
              if (!register_operand (operands[4], E_QImode))
                return -1;
              x8 = XEXP (x2, 1);
              operands[2] = x8;
              if (!register_operand (operands[2], E_V8HFmode))
                return -1;
              switch (GET_MODE (x11))
                {
                case E_DFmode:
                  if (!register_operand (operands[1], E_V2DFmode)
                      || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4705; /* avx512fp16_vcvtsd2sh_mask */

                case E_SFmode:
                  if (!register_operand (operands[1], E_V4SFmode)
                      || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4709; /* avx512fp16_vcvtss2sh_mask */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
            case MEM:
              x7 = XEXP (x3, 2);
              switch (GET_CODE (x7))
                {
                case REG:
                case SUBREG:
                  operands[4] = x7;
                  if (!register_operand (operands[4], E_QImode))
                    return -1;
                  x6 = XEXP (x2, 2);
                  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
                      || pattern876 (x2, 
E_HFmode, 
E_V8HFmode) != 0)
                    return -1;
                  operands[1] = x11;
                  x5 = XEXP (x3, 1);
                  operands[3] = x5;
                  if (!nonimm_or_0_operand (operands[3], E_V8HFmode))
                    return -1;
                  x8 = XEXP (x2, 1);
                  operands[2] = x8;
                  if (!register_operand (operands[2], E_V8HFmode))
                    return -1;
                  switch (GET_MODE (operands[1]))
                    {
                    case E_SFmode:
                      if (!memory_operand (operands[1], E_SFmode)
                          || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                        return -1;
                      return 4712; /* avx512fp16_vcvtss2sh_mask_mem */

                    case E_DFmode:
                      if (!memory_operand (operands[1], E_DFmode)
                          || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                        return -1;
                      return 4714; /* avx512fp16_vcvtsd2sh_mask_mem */

                    default:
                      return -1;
                    }

                case CONST_INT:
                  if (XWINT (x7, 0) != 1L
                      || pattern876 (x2, 
E_V2SFmode, 
E_V4SFmode) != 0
                      || pattern1357 (x2, 
E_V4SFmode, 
E_V2DFmode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9990 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 5073; /* sse2_cvtsd2ss_mask */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      switch (pattern306 (x2))
        {
        case 0:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2763; /* avx512fp16_vmaddv8hf3_mask */

        case 1:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2771; /* sse_vmaddv4sf3_mask */

        case 2:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2779; /* sse2_vmaddv2df3_mask */

        default:
          return -1;
        }

    case MINUS:
      switch (pattern306 (x2))
        {
        case 0:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2767; /* avx512fp16_vmsubv8hf3_mask */

        case 1:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2775; /* sse_vmsubv4sf3_mask */

        case 2:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2783; /* sse2_vmsubv2df3_mask */

        default:
          return -1;
        }

    case MULT:
      switch (pattern306 (x2))
        {
        case 0:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2829; /* avx512fp16_vmmulv8hf3_mask */

        case 1:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2837; /* sse_vmmulv4sf3_mask */

        case 2:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2845; /* sse2_vmmulv2df3_mask */

        default:
          return -1;
        }

    case DIV:
      switch (pattern306 (x2))
        {
        case 0:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2833; /* avx512fp16_vmdivv8hf3_mask */

        case 1:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2841; /* sse_vmdivv4sf3_mask */

        case 2:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2849; /* sse2_vmdivv2df3_mask */

        default:
          return -1;
        }

    case UNSPEC:
      return recog_146 (x1, insn, pnum_clobbers);

    case SQRT:
      x6 = XEXP (x2, 2);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x10 = XEXP (x4, 0);
      operands[1] = x10;
      x5 = XEXP (x3, 1);
      operands[3] = x5;
      x7 = XEXP (x3, 2);
      operands[4] = x7;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      x8 = XEXP (x2, 1);
      operands[2] = x8;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern1199 (x2, 
E_V8HFmode) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2930; /* avx512fp16_vmsqrtv8hf2_mask */

        case E_V4SFmode:
          if (pattern1199 (x2, 
E_V4SFmode) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2934; /* sse_vmsqrtv4sf2_mask */

        case E_V2DFmode:
          if (pattern1199 (x2, 
E_V2DFmode) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2938; /* sse2_vmsqrtv2df2_mask */

        default:
          return -1;
        }

    case SMAX:
      switch (pattern306 (x2))
        {
        case 0:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 3098; /* *avx512fp16_vmsmaxv8hf3_mask */

        case 1:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 3106; /* *sse_vmsmaxv4sf3_mask */

        case 2:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3114; /* *sse2_vmsmaxv2df3_mask */

        default:
          return -1;
        }

    case SMIN:
      switch (pattern306 (x2))
        {
        case 0:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 3102; /* *avx512fp16_vmsminv8hf3_mask */

        case 1:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 3110; /* *sse_vmsminv4sf3_mask */

        case 2:
          if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3118; /* *sse2_vmsminv2df3_mask */

        default:
          return -1;
        }

    case FMA:
      return recog_145 (x1, insn, pnum_clobbers);

    case FLOAT_EXTEND:
      if (pattern307 (x4, 
1, 
E_V2SFmode, 
E_V2DFmode) != 0)
        return -1;
      x7 = XEXP (x3, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x2) != E_V2DFmode
          || GET_MODE (x3) != E_V2DFmode
          || pattern1357 (x2, 
E_V2DFmode, 
E_V4SFmode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10034 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 5078; /* sse2_cvtss2sd_mask */

    default:
      return -1;
    }
}

 int
recog_195 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern133 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
        return -1;
      return 2984; /* *smaxv32hf3_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2991; /* *smaxv16hf3_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2995; /* *smaxv8hf3_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 3000; /* *smaxv16sf3_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3007; /* *smaxv8sf3_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1)))
        return -1;
      return 3011; /* *smaxv4sf3_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 3016; /* *smaxv8df3_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3023; /* *smaxv4df3_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
        return -1;
      return 3027; /* *smaxv2df3_mask */

    case 9:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7698; /* *avx512f_smaxv16si3_mask */

    case 10:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7706; /* *avx512f_smaxv8si3_mask */

    case 11:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7714; /* *avx512f_smaxv4si3_mask */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 7798; /* *sse4_1_smaxv4si3_mask */

    case 12:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7722; /* *avx512f_smaxv8di3_mask */

    case 13:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7730; /* *avx512f_smaxv4di3_mask */

    case 14:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7738; /* *avx512f_smaxv2di3_mask */

    case 15:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7746; /* *avx512bw_smaxv64qi3_mask */

    case 16:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7754; /* *avx512bw_smaxv16qi3_mask */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 7794; /* *sse4_1_smaxv16qi3_mask */

    case 17:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7762; /* *avx512bw_smaxv32qi3_mask */

    case 18:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7770; /* *avx512bw_smaxv32hi3_mask */

    case 19:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7778; /* *avx512bw_smaxv16hi3_mask */

    case 20:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7786; /* *avx512bw_smaxv8hi3_mask */

    case 21:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10519; /* avx10_2_smaxbf16_v32bf_mask */

    case 22:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10523; /* avx10_2_smaxbf16_v16bf_mask */

    case 23:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10527; /* avx10_2_smaxbf16_v8bf_mask */

    case 24:
      if (!(
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
        return -1;
      return 3097; /* *avx512fp16_vmsmaxv8hf3 */

    case 25:
      if (!
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 3105; /* *sse_vmsmaxv4sf3 */

    case 26:
      if (!(
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3113; /* *sse2_vmsmaxv2df3 */

    default:
      return -1;
    }
}

 int
recog_207 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x2) != E_V32HFmode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 6946; /* avx512bw_getexpv32hf */

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x2) != E_V16HFmode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 6950; /* avx512vl_getexpv16hf */

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x2) != E_V8HFmode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 6954; /* avx512fp16_getexpv8hf */

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || !vector_operand (operands[1], E_V16SFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 6958; /* avx512f_getexpv16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x2) != E_V8SFmode
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 6962; /* avx512vl_getexpv8sf */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode
          || !vector_operand (operands[1], E_V4SFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 6966; /* avx512vl_getexpv4sf */

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x2) != E_V8DFmode
          || !vector_operand (operands[1], E_V8DFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 6970; /* avx512f_getexpv8df */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x2) != E_V4DFmode
          || !vector_operand (operands[1], E_V4DFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 6974; /* avx512vl_getexpv4df */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x2) != E_V2DFmode
          || !vector_operand (operands[1], E_V2DFmode)
          || !(
#line 14017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 6978; /* avx512vl_getexpv2df */

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || GET_MODE (x2) != E_V32BFmode
          || !nonimmediate_operand (operands[1], E_V32BFmode)
          || !
#line 32426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10620; /* avx10_2_getexpbf16_v32bf */

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || GET_MODE (x2) != E_V16BFmode
          || !nonimmediate_operand (operands[1], E_V16BFmode)
          || !
#line 32426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10622; /* avx10_2_getexpbf16_v16bf */

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || GET_MODE (x2) != E_V8BFmode
          || !nonimmediate_operand (operands[1], E_V8BFmode)
          || !
#line 32426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10624; /* avx10_2_getexpbf16_v8bf */

    default:
      return -1;
    }
}

 int
recog_216 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x5 = XEXP (x3, 0);
  x6 = XEXP (x5, 2);
  if (!register_operand (x6, E_QImode))
    return -1;
  x7 = XVECEXP (x2, 0, 1);
  if (!const_4_or_8_to_11_operand (x7, E_SImode))
    return -1;
  x8 = XEXP (x5, 0);
  x9 = XEXP (x8, 0);
  switch (GET_CODE (x9))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x9;
      x10 = XEXP (x8, 1);
      operands[2] = x10;
      x11 = XEXP (x8, 2);
      switch (GET_CODE (x11))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[3] = x11;
          switch (pattern1501 (x2))
            {
            case 0:
              if (pattern1651 (x2, 
E_V8HFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8HFmode)
                  && register_operand (operands[3], E_V8HFmode))
                {
                  x12 = XEXP (x5, 1);
                  if (rtx_equal_p (x12, operands[1]))
                    {
                      x13 = XEXP (x3, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                        return 4173; /* avx512f_vmfmadd_v8hf_mask_round */
                    }
                }
              if (!register_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[3], E_V8HFmode))
                return -1;
              x12 = XEXP (x5, 1);
              if (!rtx_equal_p (x12, operands[3]))
                return -1;
              x13 = XEXP (x3, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4179; /* avx512f_vmfmadd_v8hf_mask3_round */

            case 1:
              if (pattern1651 (x2, 
E_V4SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && register_operand (operands[3], E_V4SFmode))
                {
                  x12 = XEXP (x5, 1);
                  if (rtx_equal_p (x12, operands[1]))
                    {
                      x13 = XEXP (x3, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && 
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                        return 4175; /* avx512f_vmfmadd_v4sf_mask_round */
                    }
                }
              if (!register_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[3], E_V4SFmode))
                return -1;
              x12 = XEXP (x5, 1);
              if (!rtx_equal_p (x12, operands[3]))
                return -1;
              x13 = XEXP (x3, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4181; /* avx512f_vmfmadd_v4sf_mask3_round */

            case 2:
              if (pattern1651 (x2, 
E_V2DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && register_operand (operands[3], E_V2DFmode))
                {
                  x12 = XEXP (x5, 1);
                  if (rtx_equal_p (x12, operands[1]))
                    {
                      x13 = XEXP (x3, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                        return 4177; /* avx512f_vmfmadd_v2df_mask_round */
                    }
                }
              if (!register_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[3], E_V2DFmode))
                return -1;
              x12 = XEXP (x5, 1);
              if (!rtx_equal_p (x12, operands[3]))
                return -1;
              x13 = XEXP (x3, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4183; /* avx512f_vmfmadd_v2df_mask3_round */

            case 3:
              if (pattern1717 (x2, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4185; /* avx512f_vmfmadd_v8hf_maskz_1_round */

            case 4:
              if (pattern1717 (x2, 
E_V4SFmode) != 0
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4187; /* avx512f_vmfmadd_v4sf_maskz_1_round */

            case 5:
              if (pattern1717 (x2, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4189; /* avx512f_vmfmadd_v2df_maskz_1_round */

            default:
              return -1;
            }

        case NEG:
          x14 = XEXP (x11, 0);
          operands[3] = x14;
          switch (pattern1501 (x2))
            {
            case 0:
              if (pattern1652 (x2, 
E_V8HFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8HFmode)
                  && register_operand (operands[3], E_V8HFmode))
                {
                  x12 = XEXP (x5, 1);
                  if (rtx_equal_p (x12, operands[1]))
                    {
                      x13 = XEXP (x3, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6748 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                        return 4191; /* *avx512f_vmfmsub_v8hf_mask_round */
                    }
                }
              if (!register_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[3], E_V8HFmode))
                return -1;
              x12 = XEXP (x5, 1);
              if (!rtx_equal_p (x12, operands[3]))
                return -1;
              x13 = XEXP (x3, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6769 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4197; /* avx512f_vmfmsub_v8hf_mask3_round */

            case 1:
              if (pattern1652 (x2, 
E_V4SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && register_operand (operands[3], E_V4SFmode))
                {
                  x12 = XEXP (x5, 1);
                  if (rtx_equal_p (x12, operands[1]))
                    {
                      x13 = XEXP (x3, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && 
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                        return 4193; /* *avx512f_vmfmsub_v4sf_mask_round */
                    }
                }
              if (!register_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[3], E_V4SFmode))
                return -1;
              x12 = XEXP (x5, 1);
              if (!rtx_equal_p (x12, operands[3]))
                return -1;
              x13 = XEXP (x3, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4199; /* avx512f_vmfmsub_v4sf_mask3_round */

            case 2:
              if (pattern1652 (x2, 
E_V2DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && register_operand (operands[3], E_V2DFmode))
                {
                  x12 = XEXP (x5, 1);
                  if (rtx_equal_p (x12, operands[1]))
                    {
                      x13 = XEXP (x3, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6748 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                        return 4195; /* *avx512f_vmfmsub_v2df_mask_round */
                    }
                }
              if (!register_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[3], E_V2DFmode))
                return -1;
              x12 = XEXP (x5, 1);
              if (!rtx_equal_p (x12, operands[3]))
                return -1;
              x13 = XEXP (x3, 1);
              if (!rtx_equal_p (x13, operands[3])
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6769 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4201; /* avx512f_vmfmsub_v2df_mask3_round */

            case 3:
              if (pattern1718 (x2, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6788 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4203; /* *avx512f_vmfmsub_v8hf_maskz_1_round */

            case 4:
              if (pattern1718 (x2, 
E_V4SFmode) != 0
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4205; /* *avx512f_vmfmsub_v4sf_maskz_1_round */

            case 5:
              if (pattern1718 (x2, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6788 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4207; /* *avx512f_vmfmsub_v2df_maskz_1_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x11 = XEXP (x8, 2);
      switch (GET_CODE (x11))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[3] = x11;
          switch (pattern1387 (x2))
            {
            case 0:
              x10 = XEXP (x8, 1);
              operands[2] = x10;
              if (pattern1793 (x3, 
E_V8HFmode) == 0
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6809 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return 4209; /* avx512f_vmfnmadd_v8hf_mask_round */
              operands[1] = x10;
              if (pattern1794 (x3, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6830 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4215; /* avx512f_vmfnmadd_v8hf_mask3_round */

            case 1:
              x10 = XEXP (x8, 1);
              operands[2] = x10;
              if (pattern1793 (x3, 
E_V4SFmode) == 0
                  && 
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return 4211; /* avx512f_vmfnmadd_v4sf_mask_round */
              operands[1] = x10;
              if (pattern1794 (x3, 
E_V4SFmode) != 0
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4217; /* avx512f_vmfnmadd_v4sf_mask3_round */

            case 2:
              x10 = XEXP (x8, 1);
              operands[2] = x10;
              if (pattern1793 (x3, 
E_V2DFmode) == 0
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6809 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return 4213; /* avx512f_vmfnmadd_v2df_mask_round */
              operands[1] = x10;
              if (pattern1794 (x3, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6830 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4219; /* avx512f_vmfnmadd_v2df_mask3_round */

            case 3:
              if (pattern1719 (x2, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6863 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4221; /* avx512f_vmfnmadd_v8hf_maskz_1_round */

            case 4:
              if (pattern1719 (x2, 
E_V4SFmode) != 0
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4223; /* avx512f_vmfnmadd_v4sf_maskz_1_round */

            case 5:
              if (pattern1719 (x2, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6863 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4225; /* avx512f_vmfnmadd_v2df_maskz_1_round */

            default:
              return -1;
            }

        case NEG:
          x14 = XEXP (x11, 0);
          operands[3] = x14;
          switch (pattern1387 (x2))
            {
            case 0:
              x10 = XEXP (x8, 1);
              operands[2] = x10;
              if (pattern1795 (x3, 
E_V8HFmode) == 0
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return 4227; /* *avx512f_vmfnmsub_v8hf_mask_round */
              operands[1] = x10;
              if (pattern1796 (x3, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6907 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4233; /* *avx512f_vmfnmsub_v8hf_mask3_round */

            case 1:
              x10 = XEXP (x8, 1);
              operands[2] = x10;
              if (pattern1795 (x3, 
E_V4SFmode) == 0
                  && 
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return 4229; /* *avx512f_vmfnmsub_v4sf_mask_round */
              operands[1] = x10;
              if (pattern1796 (x3, 
E_V4SFmode) != 0
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4235; /* *avx512f_vmfnmsub_v4sf_mask3_round */

            case 2:
              x10 = XEXP (x8, 1);
              operands[2] = x10;
              if (pattern1795 (x3, 
E_V2DFmode) == 0
                  && (
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return 4231; /* *avx512f_vmfnmsub_v2df_mask_round */
              operands[1] = x10;
              if (pattern1796 (x3, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6907 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4237; /* *avx512f_vmfnmsub_v2df_mask3_round */

            case 3:
              if (pattern1720 (x2, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4239; /* *avx512f_vmfnmsub_v8hf_maskz_1_round */

            case 4:
              if (pattern1720 (x2, 
E_V4SFmode) != 0
                  || !
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 4241; /* *avx512f_vmfnmsub_v4sf_maskz_1_round */

            case 5:
              if (pattern1720 (x2, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 4243; /* *avx512f_vmfnmsub_v2df_maskz_1_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_227 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  switch (XVECLEN (x3, 0))
    {
    case 2:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 1);
      operands[3] = x6;
      switch (XINT (x3, 1))
        {
        case 63:
          switch (pattern1120 (x2))
            {
            case 0:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 3044; /* ieee_maxv32hf3_round */

            case 1:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 3060; /* ieee_maxv16sf3_round */

            case 2:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 3076; /* ieee_maxv8df3_round */

            default:
              return -1;
            }

        case 62:
          switch (pattern1120 (x2))
            {
            case 0:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 3048; /* ieee_minv32hf3_round */

            case 1:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 3064; /* ieee_minv16sf3_round */

            case 2:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && 1
   && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 3080; /* ieee_minv8df3_round */

            default:
              return -1;
            }

        case 192:
          if (!const_0_to_255_operand (operands[2], E_SImode)
              || !const48_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1208 (x2, 
E_V32HFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V32HFmode))) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 3160; /* *reducepv32hf_round */

            case E_V16HFmode:
              if (pattern1208 (x2, 
E_V16HFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16HFmode))) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 3164; /* *reducepv16hf_round */

            case E_V8HFmode:
              if (pattern1208 (x2, 
E_V8HFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 3168; /* *reducepv8hf_round */

            case E_V16SFmode:
              if (pattern1208 (x2, 
E_V16SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3172; /* *reducepv16sf_round */

            case E_V8SFmode:
              if (pattern1208 (x2, 
E_V8SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3176; /* *reducepv8sf_round */

            case E_V4SFmode:
              if (pattern1208 (x2, 
E_V4SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3180; /* *reducepv4sf_round */

            case E_V8DFmode:
              if (pattern1208 (x2, 
E_V8DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3184; /* *reducepv8df_round */

            case E_V4DFmode:
              if (pattern1208 (x2, 
E_V4DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3188; /* *reducepv4df_round */

            case E_V2DFmode:
              if (pattern1208 (x2, 
E_V2DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3192; /* *reducepv2df_round */

            default:
              return -1;
            }

        case 221:
          if (pattern1121 (x2) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4302; /* avx512bw_fmulc_v32hf_round */

        case 222:
          if (pattern1121 (x2) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4306; /* avx512bw_fcmulc_v32hf_round */

        case 58:
          if (!const_4_or_8_to_11_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1299 (x2, 
E_V32HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 5333; /* avx512bw_scalefv32hf_round */

            case E_V16HFmode:
              if (pattern1299 (x2, 
E_V16HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 5337; /* avx512vl_scalefv16hf_round */

            case E_V8HFmode:
              if (pattern1299 (x2, 
E_V8HFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 5341; /* avx512fp16_scalefv8hf_round */

            case E_V16SFmode:
              if (pattern1299 (x2, 
E_V16SFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 5345; /* avx512f_scalefv16sf_round */

            case E_V8SFmode:
              if (pattern1299 (x2, 
E_V8SFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 5349; /* avx512vl_scalefv8sf_round */

            case E_V4SFmode:
              if (pattern1299 (x2, 
E_V4SFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 5353; /* avx512vl_scalefv4sf_round */

            case E_V8DFmode:
              if (pattern1299 (x2, 
E_V8DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 5357; /* avx512f_scalefv8df_round */

            case E_V4DFmode:
              if (pattern1299 (x2, 
E_V4DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 5361; /* avx512vl_scalefv4df_round */

            case E_V2DFmode:
              if (pattern1299 (x2, 
E_V2DFmode) != 0
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 5365; /* avx512vl_scalefv2df_round */

            default:
              return -1;
            }

        case 94:
          if (!const_0_to_255_operand (operands[2], E_SImode))
            return -1;
          switch (pattern1206 (x2))
            {
            case 0:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 7063; /* avx512bw_rndscalev32hf_round */

            case 1:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 7067; /* avx512vl_rndscalev16hf_round */

            case 2:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 7071; /* avx512fp16_rndscalev8hf_round */

            case 3:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 7075; /* avx512f_rndscalev16sf_round */

            case 4:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7079; /* avx512vl_rndscalev8sf_round */

            case 5:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7083; /* avx512vl_rndscalev4sf_round */

            case 6:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 7087; /* avx512f_rndscalev8df_round */

            case 7:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7091; /* avx512vl_rndscalev4df_round */

            case 8:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7095; /* avx512vl_rndscalev2df_round */

            default:
              return -1;
            }

        case 150:
          if (GET_MODE (x3) != E_V16HImode
              || !register_operand (operands[0], E_V16HImode)
              || GET_MODE (x2) != E_V16HImode
              || !register_operand (operands[1], E_V16SFmode)
              || !const_0_to_255_operand (operands[2], E_SImode)
              || !const48_operand (operands[3], E_SImode)
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9591; /* *avx512f_vcvtps2ph512_round */

        case 166:
          if (!const_0_to_15_operand (operands[2], E_SImode))
            return -1;
          switch (pattern1206 (x2))
            {
            case 0:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                return -1;
              return 9933; /* avx512bw_getmantv32hf_round */

            case 1:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 9937; /* avx512vl_getmantv16hf_round */

            case 2:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 9941; /* avx512fp16_getmantv8hf_round */

            case 3:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9945; /* avx512f_getmantv16sf_round */

            case 4:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9949; /* avx512vl_getmantv8sf_round */

            case 5:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9953; /* avx512vl_getmantv4sf_round */

            case 6:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9957; /* avx512f_getmantv8df_round */

            case 7:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9961; /* avx512vl_getmantv4df_round */

            case 8:
              if (!(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 9965; /* avx512vl_getmantv2df_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 3:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 1);
      operands[4] = x6;
      switch (XINT (x3, 1))
        {
        case 133:
          if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
            return -1;
          x7 = XVECEXP (x3, 0, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[3] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_V32HFmode:
                  if (pattern1463 (x2, 
E_V32HFmode) != 0
                      || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                    return -1;
                  return 4026; /* *fma_fmaddsub_v32hf_round */

                case E_V16SFmode:
                  if (pattern1463 (x2, 
E_V16SFmode) != 0
                      || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 4034; /* *fma_fmaddsub_v16sf_round */

                case E_V8DFmode:
                  if (pattern1463 (x2, 
E_V8DFmode) != 0
                      || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6425 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 4042; /* *fma_fmaddsub_v8df_round */

                default:
                  return -1;
                }

            case NEG:
              x8 = XEXP (x7, 0);
              operands[3] = x8;
              switch (GET_MODE (operands[0]))
                {
                case E_V32HFmode:
                  if (pattern1464 (x2, 
E_V32HFmode) != 0
                      || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
                    return -1;
                  return 4090; /* *fma_fmsubadd_v32hf_round */

                case E_V16SFmode:
                  if (pattern1464 (x2, 
E_V16SFmode) != 0
                      || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 4098; /* *fma_fmsubadd_v16sf_round */

                case E_V8DFmode:
                  if (pattern1464 (x2, 
E_V8DFmode) != 0
                      || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 6495 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 4106; /* *fma_fmsubadd_v8df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 217:
          if (pattern1122 (x2) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4253; /* fma_fmaddc_v32hf_round */

        case 219:
          if (pattern1122 (x2) != 0
              || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4257; /* fma_fcmaddc_v32hf_round */

        case 194:
          x7 = XVECEXP (x3, 0, 2);
          operands[3] = x7;
          if (!const_0_to_15_operand (operands[3], E_SImode)
              || !const48_operand (operands[4], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1119 (x2, 
E_V16SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9885; /* avx512dq_rangepv16sf_round */

            case E_V8DFmode:
              if (pattern1119 (x2, 
E_V8DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 9893; /* avx512dq_rangepv8df_round */

            default:
              return -1;
            }

        case 278:
          x7 = XVECEXP (x3, 0, 2);
          operands[3] = x7;
          if (!const_0_to_255_operand (operands[3], E_SImode)
              || !const48_operand (operands[4], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1119 (x2, 
E_V32HFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10831; /* avx10_2_minmaxpv32hf_round */

            case E_V16HFmode:
              if (pattern1119 (x2, 
E_V16HFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10835; /* avx10_2_minmaxpv16hf_round */

            case E_V8HFmode:
              if (pattern1119 (x2, 
E_V8HFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10839; /* avx10_2_minmaxpv8hf_round */

            case E_V16SFmode:
              if (pattern1119 (x2, 
E_V16SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10843; /* avx10_2_minmaxpv16sf_round */

            case E_V8SFmode:
              if (pattern1119 (x2, 
E_V8SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10847; /* avx10_2_minmaxpv8sf_round */

            case E_V4SFmode:
              if (pattern1119 (x2, 
E_V4SFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10851; /* avx10_2_minmaxpv4sf_round */

            case E_V8DFmode:
              if (pattern1119 (x2, 
E_V8DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10855; /* avx10_2_minmaxpv8df_round */

            case E_V4DFmode:
              if (pattern1119 (x2, 
E_V4DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10859; /* avx10_2_minmaxpv4df_round */

            case E_V2DFmode:
              if (pattern1119 (x2, 
E_V2DFmode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10863; /* avx10_2_minmaxpv2df_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 1:
      return recog_225 (x1, insn, pnum_clobbers);

    case 4:
      if (XINT (x3, 1) != 163)
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x7 = XVECEXP (x3, 0, 2);
      operands[3] = x7;
      x9 = XVECEXP (x3, 0, 3);
      operands[4] = x9;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x6 = XVECEXP (x2, 0, 1);
      operands[5] = x6;
      if (!const48_operand (operands[5], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern1502 (x2, 
E_V16SImode, 
E_V16SFmode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7015; /* avx512f_fixupimmv16sf_round */

        case E_V8SFmode:
          if (pattern1502 (x2, 
E_V8SImode, 
E_V8SFmode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7019; /* avx512vl_fixupimmv8sf_round */

        case E_V4SFmode:
          if (pattern1502 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7023; /* avx512vl_fixupimmv4sf_round */

        case E_V8DFmode:
          if (pattern1502 (x2, 
E_V8DImode, 
E_V8DFmode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7027; /* avx512f_fixupimmv8df_round */

        case E_V4DFmode:
          if (pattern1502 (x2, 
E_V4DImode, 
E_V4DFmode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7031; /* avx512vl_fixupimmv4df_round */

        case E_V2DFmode:
          if (pattern1502 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
              || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7035; /* avx512vl_fixupimmv2df_round */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_249 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (pattern903 (x3, 
E_HImode, 
E_V16SImode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9812; /* avx512f_compressv16si_mask */

    case E_V16SFmode:
      if (pattern903 (x3, 
E_HImode, 
E_V16SFmode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9813; /* avx512f_compressv16sf_mask */

    case E_V8DImode:
      if (pattern903 (x3, 
E_QImode, 
E_V8DImode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9814; /* avx512f_compressv8di_mask */

    case E_V8DFmode:
      if (pattern903 (x3, 
E_QImode, 
E_V8DFmode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9815; /* avx512f_compressv8df_mask */

    case E_V8SImode:
      if (pattern903 (x3, 
E_QImode, 
E_V8SImode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9816; /* avx512vl_compressv8si_mask */

    case E_V8SFmode:
      if (pattern903 (x3, 
E_QImode, 
E_V8SFmode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9817; /* avx512vl_compressv8sf_mask */

    case E_V4DImode:
      if (pattern903 (x3, 
E_QImode, 
E_V4DImode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9818; /* avx512vl_compressv4di_mask */

    case E_V4DFmode:
      if (pattern903 (x3, 
E_QImode, 
E_V4DFmode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9819; /* avx512vl_compressv4df_mask */

    case E_V4SImode:
      if (pattern903 (x3, 
E_QImode, 
E_V4SImode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9820; /* avx512vl_compressv4si_mask */

    case E_V4SFmode:
      if (pattern903 (x3, 
E_QImode, 
E_V4SFmode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9821; /* avx512vl_compressv4sf_mask */

    case E_V2DImode:
      if (pattern903 (x3, 
E_QImode, 
E_V2DImode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9822; /* avx512vl_compressv2di_mask */

    case E_V2DFmode:
      if (pattern903 (x3, 
E_QImode, 
E_V2DFmode) != 0
          || !(
#line 29657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9823; /* avx512vl_compressv2df_mask */

    case E_V64QImode:
      if (pattern903 (x3, 
E_DImode, 
E_V64QImode) != 0
          || !(
#line 29670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9824; /* compressv64qi_mask */

    case E_V16QImode:
      if (pattern903 (x3, 
E_HImode, 
E_V16QImode) != 0
          || !(
#line 29670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9825; /* compressv16qi_mask */

    case E_V32QImode:
      if (pattern903 (x3, 
E_SImode, 
E_V32QImode) != 0
          || !(
#line 29670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9826; /* compressv32qi_mask */

    case E_V32HImode:
      if (pattern903 (x3, 
E_SImode, 
E_V32HImode) != 0
          || !(
#line 29670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9827; /* compressv32hi_mask */

    case E_V16HImode:
      if (pattern903 (x3, 
E_HImode, 
E_V16HImode) != 0
          || !(
#line 29670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9828; /* compressv16hi_mask */

    case E_V8HImode:
      if (pattern903 (x3, 
E_QImode, 
E_V8HImode) != 0
          || !(
#line 29670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9829; /* compressv8hi_mask */

    default:
      return -1;
    }
}

 int
recog_260 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (pattern661 (x3))
    {
    case 0:
      if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 4252; /* fma_fmaddc_v32hf */
      break;

    case 1:
      if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 4260; /* fma_fmaddc_v16hf */
      break;

    case 2:
      if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 4264; /* fma_fmaddc_v8hf */
      break;

    default:
      break;
    }
  if (GET_CODE (x5) != SUBREG
      || maybe_ne (SUBREG_BYTE (x5), 0))
    return -1;
  switch (pattern589 (x3))
    {
    case 0:
      if (!(
#line 7243 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4286; /* fma_v32hf_fmaddc_bcst */

    case 1:
      if (!(
#line 7243 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4287; /* fma_v16hf_fmaddc_bcst */

    case 2:
      if (!(
#line 7243 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4288; /* fma_v8hf_fmaddc_bcst */

    default:
      return -1;
    }
}

 int
recog_266 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 2);
  if (!register_operand (x4, E_QImode))
    return -1;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case FLOAT:
      switch (pattern501 (x2))
        {
        case 0:
          if (!
#line 7711 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4460; /* *avx512fp16_vcvtdq2ph_v4si_mask */

        case 1:
          if (!
#line 7711 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4462; /* *avx512fp16_vcvtqq2ph_v4di_mask */

        case 2:
          if (!
#line 7787 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4470; /* *avx512fp16_vcvtqq2ph_v2di_mask */

        case 3:
          if (!
#line 9300 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 4914; /* *floatv2div2sf2_mask */

        case 4:
          if (!
#line 7726 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4464; /* *avx512fp16_vcvtdq2ph_v4si_mask_1 */

        case 5:
          if (!
#line 7726 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4466; /* *avx512fp16_vcvtqq2ph_v4di_mask_1 */

        case 6:
          if (!
#line 7802 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4472; /* *avx512fp16_vcvtqq2ph_v2di_mask_1 */

        case 7:
          if (!
#line 9315 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 4916; /* *floatv2div2sf2_mask_1 */

        default:
          return -1;
        }

    case UNSIGNED_FLOAT:
      switch (pattern501 (x2))
        {
        case 0:
          if (!
#line 7711 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4461; /* *avx512fp16_vcvtudq2ph_v4si_mask */

        case 1:
          if (!
#line 7711 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4463; /* *avx512fp16_vcvtuqq2ph_v4di_mask */

        case 2:
          if (!
#line 7787 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4471; /* *avx512fp16_vcvtuqq2ph_v2di_mask */

        case 3:
          if (!
#line 9300 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 4915; /* *floatunsv2div2sf2_mask */

        case 4:
          if (!
#line 7726 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4465; /* *avx512fp16_vcvtudq2ph_v4si_mask_1 */

        case 5:
          if (!
#line 7726 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4467; /* *avx512fp16_vcvtuqq2ph_v4di_mask_1 */

        case 6:
          if (!
#line 7802 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4473; /* *avx512fp16_vcvtuqq2ph_v2di_mask_1 */

        case 7:
          if (!
#line 9315 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 4917; /* *floatunsv2div2sf2_mask_1 */

        default:
          return -1;
        }

    case FLOAT_TRUNCATE:
      x6 = XEXP (x5, 0);
      operands[1] = x6;
      x7 = XEXP (x2, 1);
      operands[4] = x7;
      x8 = XEXP (x3, 1);
      switch (GET_CODE (x8))
        {
        case VEC_SELECT:
          x9 = XEXP (x8, 1);
          if (GET_CODE (x9) != PARALLEL)
            return -1;
          x10 = XEXP (x8, 0);
          operands[2] = x10;
          operands[3] = x4;
          switch (XVECLEN (x9, 0))
            {
            case 4:
              if (pattern1203 (x9, 
3, 
2, 
1, 
0) != 0)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V8HFmode:
                  if (!register_operand (operands[0], E_V8HFmode)
                      || GET_MODE (x2) != E_V8HFmode
                      || GET_MODE (x3) != E_V4HFmode
                      || GET_MODE (x5) != E_V4HFmode
                      || GET_MODE (x8) != E_V4HFmode
                      || !nonimm_or_0_operand (operands[2], E_V8HFmode))
                    return -1;
                  switch (pattern1537 ())
                    {
                    case 0:
                      if (!
#line 8182 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4684; /* *avx512fp16_vcvtpd2ph_v4df_mask */

                    case 1:
                      if (!
#line 8182 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4685; /* *avx512fp16_vcvtps2ph_v4sf_mask */

                    default:
                      return -1;
                    }

                case E_V8BFmode:
                  if (pattern497 (x2, 
E_V4BFmode, 
E_V8BFmode, 
E_V4SFmode) != 0
                      || !
#line 31110 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16 && TARGET_AVX512VL))
                    return -1;
                  return 10271; /* avx512f_cvtneps2bf16_v4sf_mask_1 */

                default:
                  return -1;
                }

            case 2:
              switch (pattern498 (x2, 
E_V2DFmode))
                {
                case 0:
                  if (!
#line 8258 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                    return -1;
                  return 4689; /* *avx512fp16_vcvtpd2ph_v2df_mask */

                case 1:
                  if (!
#line 10164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 5089; /* *sse2_cvtpd2ps_mask */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[3] = x8;
          operands[2] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[0], E_V8HFmode)
                  || GET_MODE (x2) != E_V8HFmode)
                return -1;
              switch (GET_MODE (x3))
                {
                case E_V4HFmode:
                  if (GET_MODE (x5) != E_V4HFmode
                      || !const0_operand (operands[3], E_V4HFmode))
                    return -1;
                  switch (pattern1537 ())
                    {
                    case 0:
                      if (!
#line 8197 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4686; /* *avx512fp16_vcvtpd2ph_v4df_mask_1 */

                    case 1:
                      if (!
#line 8197 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4687; /* *avx512fp16_vcvtps2ph_v4sf_mask_1 */

                    default:
                      return -1;
                    }

                case E_V2HFmode:
                  if (pattern499 (x5, 
E_V2DFmode) != 0
                      || !
#line 8273 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                    return -1;
                  return 4690; /* *avx512fp16_vcvtpd2ph_v2df_mask_1 */

                default:
                  return -1;
                }

            case E_V4SFmode:
              if (pattern500 (x2, 
E_V2DFmode) != 0
                  || !
#line 10179 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 5090; /* *sse2_cvtpd2ps_mask_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      switch (XVECLEN (x5, 0))
        {
        case 1:
          x11 = XVECEXP (x5, 0, 0);
          operands[1] = x11;
          switch (XINT (x5, 1))
            {
            case 46:
              switch (pattern908 (x2))
                {
                case 0:
                  if (!
#line 9459 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 4936; /* sse2_cvtpd2dq_mask */

                case 1:
                  if (!
#line 9474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 4937; /* *sse2_cvtpd2dq_mask_1 */

                default:
                  return -1;
                }

            case 156:
              switch (pattern908 (x2))
                {
                case 0:
                  if (!
#line 9520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 4947; /* fixuns_notruncv2dfv2si2_mask */

                case 1:
                  if (!
#line 9536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 4948; /* *fixuns_notruncv2dfv2si2_mask_1 */

                default:
                  return -1;
                }

            case 173:
              if (GET_MODE (x5) != E_V2SImode)
                return -1;
              x8 = XEXP (x3, 1);
              if (pattern662 (x8, 
2, 
E_V2SImode) != 0)
                return -1;
              x9 = XEXP (x8, 1);
              x12 = XVECEXP (x9, 0, 0);
              if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x13 = XVECEXP (x9, 0, 1);
              if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return -1;
              x7 = XEXP (x2, 1);
              if (GET_CODE (x7) != CONST_VECTOR
                  || XVECLEN (x7, 0) != 2
                  || GET_MODE (x7) != E_V2SImode)
                return -1;
              x14 = XVECEXP (x7, 0, 0);
              if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x15 = XVECEXP (x7, 0, 1);
              if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
                  || !register_operand (operands[0], E_V4SImode)
                  || GET_MODE (x2) != E_V4SImode
                  || GET_MODE (x3) != E_V2SImode
                  || !nonimmediate_operand (operands[1], E_V2DFmode))
                return -1;
              x10 = XEXP (x8, 0);
              operands[2] = x10;
              if (!nonimm_or_0_operand (operands[2], E_V4SImode))
                return -1;
              operands[3] = x4;
              if (!
#line 9597 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 4967; /* unspec_fixuns_truncv2dfv2si2_mask */

            case 253:
              if (pattern909 (x2) != 0
                  || !
#line 31913 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10423; /* *vcvtph2bf8v8hf_mask */

            case 254:
              if (pattern909 (x2) != 0
                  || !
#line 31913 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10424; /* *vcvtph2bf8sv8hf_mask */

            case 255:
              if (pattern909 (x2) != 0
                  || !
#line 31913 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10425; /* *vcvtph2hf8v8hf_mask */

            case 256:
              if (pattern909 (x2) != 0
                  || !
#line 31913 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10426; /* *vcvtph2hf8sv8hf_mask */

            default:
              return -1;
            }

        case 2:
          x8 = XEXP (x3, 1);
          if (pattern662 (x8, 
8, 
E_V8QImode) != 0)
            return -1;
          x9 = XEXP (x8, 1);
          x12 = XVECEXP (x9, 0, 0);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x13 = XVECEXP (x9, 0, 1);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x16 = XVECEXP (x9, 0, 2);
          if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 2]
              || pattern1400 (x9, 
7, 
6, 
5, 
4, 
3) != 0
              || !register_operand (operands[0], E_V16QImode)
              || GET_MODE (x2) != E_V16QImode
              || GET_MODE (x3) != E_V8QImode
              || GET_MODE (x5) != E_V8QImode)
            return -1;
          x11 = XVECEXP (x5, 0, 0);
          operands[1] = x11;
          if (!register_operand (operands[1], E_V16QImode))
            return -1;
          x17 = XVECEXP (x5, 0, 1);
          operands[2] = x17;
          if (!nonimmediate_operand (operands[2], E_V8HFmode))
            return -1;
          x10 = XEXP (x8, 0);
          operands[3] = x10;
          if (!nonimm_or_0_operand (operands[3], E_V16QImode))
            return -1;
          operands[4] = x4;
          x7 = XEXP (x2, 1);
          operands[5] = x7;
          if (!const0_operand (operands[5], E_V8QImode))
            return -1;
          switch (XINT (x5, 1))
            {
            case 245:
              if (!
#line 31825 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10399; /* *vcvtbiasph2bf8v8hf_mask */

            case 246:
              if (!
#line 31825 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10400; /* *vcvtbiasph2bf8sv8hf_mask */

            case 247:
              if (!
#line 31825 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10401; /* *vcvtbiasph2hf8v8hf_mask */

            case 248:
              if (!
#line 31825 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10402; /* *vcvtbiasph2hf8sv8hf_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSIGNED_FIX:
      switch (pattern503 (x2))
        {
        case 0:
          if (!
#line 9613 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 4968; /* fixuns_truncv2dfv2si2_mask */

        case 1:
          if (!
#line 9627 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 4969; /* *fixuns_truncv2dfv2si2_mask_1 */

        default:
          return -1;
        }

    case FIX:
      switch (pattern503 (x2))
        {
        case 0:
          if (!
#line 9962 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 5069; /* sse2_cvttpd2dq_mask */

        case 1:
          if (!
#line 9976 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 5070; /* *sse2_cvttpd2dq_mask_1 */

        default:
          return -1;
        }

    case SS_TRUNCATE:
      switch (pattern509 (x2))
        {
        case 0:
          if (!
#line 15422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7228; /* avx512vl_ss_truncatev2div2qi2_mask */

        case 1:
          if (!
#line 15864 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7343; /* avx512vl_ss_truncatev2div2hi2_mask */

        case 2:
          if (!
#line 16012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7362; /* avx512vl_ss_truncatev2div2si2_mask */

        case 3:
          if (!
#line 15517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7249; /* avx512vl_ss_truncatev4siv4qi2_mask */

        case 4:
          if (!
#line 15517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7252; /* avx512vl_ss_truncatev4div4qi2_mask */

        case 5:
          if (!
#line 15773 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7319; /* avx512vl_ss_truncatev4siv4hi2_mask */

        case 6:
          if (!
#line 15773 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7322; /* avx512vl_ss_truncatev4div4hi2_mask */

        case 7:
          if (!(
#line 15615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7279; /* avx512vl_ss_truncatev8hiv8qi2_mask */

        case 8:
          if (!
#line 15615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7282; /* avx512vl_ss_truncatev8siv8qi2_mask */

        case 9:
          if (!
#line 16131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7380; /* avx512f_ss_truncatev8div16qi2_mask */

        case 10:
          if (!
#line 15443 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7231; /* *avx512vl_ss_truncatev2div2qi2_mask_1 */

        case 11:
          if (!
#line 15881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7346; /* *avx512vl_ss_truncatev2div2hi2_mask_1 */

        case 12:
          if (!
#line 16027 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7365; /* *avx512vl_ss_truncatev2div2si2_mask_1 */

        case 13:
          if (!
#line 15538 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7255; /* *avx512vl_ss_truncatev4siv4qi2_mask_1 */

        case 14:
          if (!
#line 15538 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7258; /* *avx512vl_ss_truncatev4div4qi2_mask_1 */

        case 15:
          if (!
#line 15790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7325; /* *avx512vl_ss_truncatev4siv4hi2_mask_1 */

        case 16:
          if (!
#line 15790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7328; /* *avx512vl_ss_truncatev4div4hi2_mask_1 */

        case 17:
          if (!(
#line 15636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7285; /* *avx512vl_ss_truncatev8hiv8qi2_mask_1 */

        case 18:
          if (!
#line 15636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7288; /* *avx512vl_ss_truncatev8siv8qi2_mask_1 */

        case 19:
          if (!
#line 16152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7383; /* *avx512f_ss_truncatev8div16qi2_mask_1 */

        default:
          return -1;
        }

    case TRUNCATE:
      switch (pattern509 (x2))
        {
        case 0:
          if (!
#line 15422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7229; /* avx512vl_truncatev2div2qi2_mask */

        case 1:
          if (!
#line 15864 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7344; /* avx512vl_truncatev2div2hi2_mask */

        case 2:
          if (!
#line 16012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7363; /* avx512vl_truncatev2div2si2_mask */

        case 3:
          if (!
#line 15517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7250; /* avx512vl_truncatev4siv4qi2_mask */

        case 4:
          if (!
#line 15517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7253; /* avx512vl_truncatev4div4qi2_mask */

        case 5:
          if (!
#line 15773 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7320; /* avx512vl_truncatev4siv4hi2_mask */

        case 6:
          if (!
#line 15773 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7323; /* avx512vl_truncatev4div4hi2_mask */

        case 7:
          if (!(
#line 15615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7280; /* avx512vl_truncatev8hiv8qi2_mask */

        case 8:
          if (!
#line 15615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7283; /* avx512vl_truncatev8siv8qi2_mask */

        case 9:
          if (!
#line 16131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7381; /* avx512f_truncatev8div16qi2_mask */

        case 10:
          if (!
#line 15443 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7232; /* *avx512vl_truncatev2div2qi2_mask_1 */

        case 11:
          if (!
#line 15881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7347; /* *avx512vl_truncatev2div2hi2_mask_1 */

        case 12:
          if (!
#line 16027 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7366; /* *avx512vl_truncatev2div2si2_mask_1 */

        case 13:
          if (!
#line 15538 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7256; /* *avx512vl_truncatev4siv4qi2_mask_1 */

        case 14:
          if (!
#line 15538 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7259; /* *avx512vl_truncatev4div4qi2_mask_1 */

        case 15:
          if (!
#line 15790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7326; /* *avx512vl_truncatev4siv4hi2_mask_1 */

        case 16:
          if (!
#line 15790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7329; /* *avx512vl_truncatev4div4hi2_mask_1 */

        case 17:
          if (!(
#line 15636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7286; /* *avx512vl_truncatev8hiv8qi2_mask_1 */

        case 18:
          if (!
#line 15636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7289; /* *avx512vl_truncatev8siv8qi2_mask_1 */

        case 19:
          if (!
#line 16152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7384; /* *avx512f_truncatev8div16qi2_mask_1 */

        default:
          return -1;
        }

    case US_TRUNCATE:
      switch (pattern509 (x2))
        {
        case 0:
          if (!
#line 15422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7230; /* avx512vl_us_truncatev2div2qi2_mask */

        case 1:
          if (!
#line 15864 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7345; /* avx512vl_us_truncatev2div2hi2_mask */

        case 2:
          if (!
#line 16012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7364; /* avx512vl_us_truncatev2div2si2_mask */

        case 3:
          if (!
#line 15517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7251; /* avx512vl_us_truncatev4siv4qi2_mask */

        case 4:
          if (!
#line 15517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7254; /* avx512vl_us_truncatev4div4qi2_mask */

        case 5:
          if (!
#line 15773 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7321; /* avx512vl_us_truncatev4siv4hi2_mask */

        case 6:
          if (!
#line 15773 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7324; /* avx512vl_us_truncatev4div4hi2_mask */

        case 7:
          if (!(
#line 15615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7281; /* avx512vl_us_truncatev8hiv8qi2_mask */

        case 8:
          if (!
#line 15615 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7284; /* avx512vl_us_truncatev8siv8qi2_mask */

        case 9:
          if (!
#line 16131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7382; /* avx512f_us_truncatev8div16qi2_mask */

        case 10:
          if (!
#line 15443 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7233; /* *avx512vl_us_truncatev2div2qi2_mask_1 */

        case 11:
          if (!
#line 15881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7348; /* *avx512vl_us_truncatev2div2hi2_mask_1 */

        case 12:
          if (!
#line 16027 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7367; /* *avx512vl_us_truncatev2div2si2_mask_1 */

        case 13:
          if (!
#line 15538 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7257; /* *avx512vl_us_truncatev4siv4qi2_mask_1 */

        case 14:
          if (!
#line 15538 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7260; /* *avx512vl_us_truncatev4div4qi2_mask_1 */

        case 15:
          if (!
#line 15790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7327; /* *avx512vl_us_truncatev4siv4hi2_mask_1 */

        case 16:
          if (!
#line 15790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7330; /* *avx512vl_us_truncatev4div4hi2_mask_1 */

        case 17:
          if (!(
#line 15636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7287; /* *avx512vl_us_truncatev8hiv8qi2_mask_1 */

        case 18:
          if (!
#line 15636 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7290; /* *avx512vl_us_truncatev8siv8qi2_mask_1 */

        case 19:
          if (!
#line 16152 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7385; /* *avx512f_us_truncatev8div16qi2_mask_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_283 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 1);
  operands[3] = x4;
  x5 = XVECEXP (x3, 0, 2);
  operands[4] = x5;
  x6 = XVECEXP (x3, 0, 3);
  operands[5] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SFmode:
      if (!nonimmediate_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode
          || pattern1470 (
E_V16SFmode) != 0
          || !(
#line 12507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && INTVAL (operands[2]) % 4 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[3]) == INTVAL (operands[4]) - 1
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 5246; /* *avx512f_vextractf32x4_1 */

    case E_V4SImode:
      if (GET_MODE (x2) != E_V4SImode)
        return -1;
      if (nonimmediate_operand (operands[0], E_V4SImode)
          && pattern1470 (
E_V16SImode) == 0
          && (
#line 12507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && INTVAL (operands[2]) % 4 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[3]) == INTVAL (operands[4]) - 1
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 5247; /* *avx512f_vextracti32x4_1 */
      if (!register_operand (operands[0], E_V4SImode)
          || !vector_operand (operands[1], E_V4SImode)
          || pattern1505 () != 0
          || !
#line 20678 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
        return -1;
      return 8368; /* sse2_pshufd_1 */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x2) != E_V4DImode
          || !nonimmediate_operand (operands[1], E_V4DImode)
          || pattern1505 () != 0
          || !
#line 27555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9096; /* avx2_permv4di_1 */

    default:
      return -1;
    }
}

 int
recog_286 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 1);
  operands[3] = x4;
  x5 = XVECEXP (x3, 0, 2);
  operands[4] = x5;
  x6 = XVECEXP (x3, 0, 3);
  operands[5] = x6;
  x7 = XVECEXP (x3, 0, 5);
  operands[7] = x7;
  x8 = XVECEXP (x3, 0, 6);
  operands[8] = x8;
  x9 = XVECEXP (x3, 0, 7);
  operands[9] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x2) != E_V8DFmode
          || !register_operand (operands[1], E_V8DFmode)
          || pattern1691 () != 0
          || !(
#line 20259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 1) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (INTVAL (operands[4]) & 1) == 0
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1
   && (INTVAL (operands[6]) & 1) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && (INTVAL (operands[8]) & 1) == 0
   && INTVAL (operands[8]) == INTVAL (operands[9]) - 1) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 8348; /* *avx512f_shuf_f64x2_1_1 */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x2) != E_V8DImode)
        return -1;
      if (register_operand (operands[1], E_V8DImode)
          && pattern1691 () == 0
          && (
#line 20259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 1) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (INTVAL (operands[4]) & 1) == 0
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1
   && (INTVAL (operands[6]) & 1) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && (INTVAL (operands[8]) & 1) == 0
   && INTVAL (operands[8]) == INTVAL (operands[9]) - 1) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 8350; /* *avx512f_shuf_i64x2_1_1 */
      if (!nonimmediate_operand (operands[1], E_V8DImode)
          || pattern1692 () != 0
          || !(
#line 27626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1
   && (INTVAL (operands[2]) == (INTVAL (operands[6]) - 4)
       && INTVAL (operands[3]) == (INTVAL (operands[7]) - 4)
       && INTVAL (operands[4]) == (INTVAL (operands[8]) - 4)
       && INTVAL (operands[5]) == (INTVAL (operands[9]) - 4))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9102; /* avx512f_permv8di_1 */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x2) != E_V8SImode
          || !nonimmediate_operand (operands[1], E_V8SImode)
          || pattern1692 () != 0
          || !
#line 20616 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   && 1
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9])))
        return -1;
      return 8366; /* avx2_pshufd_1 */

    default:
      return -1;
    }
}

 int
recog_294 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SFmode))
        {
          if (avx_vbroadcast_operand (operands[2], E_VOIDmode)
              && 
#line 27364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return 9081; /* *avx_vperm_broadcast_v4sf */
          if (
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1
   && avx_vpermilp_parallel (operands[2], V4SFmode)))
            return 9088; /* *avx_vpermilpv4sf */
        }
      if (!register_operand (operands[1], E_V4SFmode)
          || !palignr_operand (operands[2], E_VOIDmode)
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9386; /* *ssse3_palignrv4sf_perm */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x2) != E_V8SFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      if (avx_vbroadcast_operand (operands[2], E_VOIDmode)
          && 
#line 27392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && (V8SFmode != V4DFmode || !TARGET_AVX2 || operands[3] == const0_rtx)))
        return 9082; /* *avx_vperm_broadcast_v8sf */
      if (!(
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1
   && avx_vpermilp_parallel (operands[2], V8SFmode)) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 9086; /* *avx_vpermilpv8sf */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x2) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode))
        return -1;
      if (avx_vbroadcast_operand (operands[2], E_VOIDmode)
          && 
#line 27392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && (V4DFmode != V4DFmode || !TARGET_AVX2 || operands[3] == const0_rtx)))
        return 9083; /* *avx_vperm_broadcast_v4df */
      if (!(
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1
   && avx_vpermilp_parallel (operands[2], V4DFmode)) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 9092; /* *avx_vpermilpv4df */

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode)
          || !(
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1
   && avx_vpermilp_parallel (operands[2], V16SFmode)) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9084; /* *avx512f_vpermilpv16sf */

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x2) != E_V8DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode)
          || !(
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1
   && avx_vpermilp_parallel (operands[2], V8DFmode)) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9090; /* *avx512f_vpermilpv8df */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x2) != E_V2DFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DFmode)
          && (
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1
   && avx_vpermilp_parallel (operands[2], V2DFmode)) && 
#line 376 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return 9094; /* *avx_vpermilpv2df */
      if (!register_operand (operands[1], E_V2DFmode)
          || !palignr_operand (operands[2], E_VOIDmode)
          || !(
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 342 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 9387; /* *ssse3_palignrv2df_perm */

    case E_V16QImode:
      if (pattern1130 (x2, 
E_V16QImode) != 0
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9380; /* *ssse3_palignrv16qi_perm */

    case E_V8HImode:
      if (pattern1130 (x2, 
E_V8HImode) != 0
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9381; /* *ssse3_palignrv8hi_perm */

    case E_V8HFmode:
      if (pattern1130 (x2, 
E_V8HFmode) != 0
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9382; /* *ssse3_palignrv8hf_perm */

    case E_V8BFmode:
      if (pattern1130 (x2, 
E_V8BFmode) != 0
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9383; /* *ssse3_palignrv8bf_perm */

    case E_V4SImode:
      if (pattern1130 (x2, 
E_V4SImode) != 0
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9384; /* *ssse3_palignrv4si_perm */

    case E_V2DImode:
      if (pattern1130 (x2, 
E_V2DImode) != 0
          || !
#line 28353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 9385; /* *ssse3_palignrv2di_perm */

    default:
      return -1;
    }
}

 int
recog_304 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern529 (x2))
        {
        case 0:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5439; /* *avx512bw_vpternlogv64qi_1 */

        case 1:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5466; /* *avx512vl_vpternlogv32qi_1 */

        case 2:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5493; /* *avx512vl_vpternlogv16qi_1 */

        case 3:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5520; /* *avx512bw_vpternlogv32hi_1 */

        case 4:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5547; /* *avx512vl_vpternlogv16hi_1 */

        case 5:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5574; /* *avx512vl_vpternlogv8hi_1 */

        case 6:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5601; /* *avx512f_vpternlogv16si_1 */

        case 7:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5628; /* *avx512vl_vpternlogv8si_1 */

        case 8:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5655; /* *avx512vl_vpternlogv4si_1 */

        case 9:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5682; /* *avx512f_vpternlogv8di_1 */

        case 10:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5709; /* *avx512vl_vpternlogv4di_1 */

        case 11:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5736; /* *avx512vl_vpternlogv2di_1 */

        case 12:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5442; /* *avx512bw_vpternlogv64qi_1 */

        case 13:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5469; /* *avx512vl_vpternlogv32qi_1 */

        case 14:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5496; /* *avx512vl_vpternlogv16qi_1 */

        case 15:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5523; /* *avx512bw_vpternlogv32hi_1 */

        case 16:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5550; /* *avx512vl_vpternlogv16hi_1 */

        case 17:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5577; /* *avx512vl_vpternlogv8hi_1 */

        case 18:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5604; /* *avx512f_vpternlogv16si_1 */

        case 19:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5631; /* *avx512vl_vpternlogv8si_1 */

        case 20:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5658; /* *avx512vl_vpternlogv4si_1 */

        case 21:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5685; /* *avx512f_vpternlogv8di_1 */

        case 22:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5712; /* *avx512vl_vpternlogv4di_1 */

        case 23:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5739; /* *avx512vl_vpternlogv2di_1 */

        case 24:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5445; /* *avx512bw_vpternlogv64qi_1 */

        case 25:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5472; /* *avx512vl_vpternlogv32qi_1 */

        case 26:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5499; /* *avx512vl_vpternlogv16qi_1 */

        case 27:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5526; /* *avx512bw_vpternlogv32hi_1 */

        case 28:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5553; /* *avx512vl_vpternlogv16hi_1 */

        case 29:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5580; /* *avx512vl_vpternlogv8hi_1 */

        case 30:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5607; /* *avx512f_vpternlogv16si_1 */

        case 31:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5634; /* *avx512vl_vpternlogv8si_1 */

        case 32:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5661; /* *avx512vl_vpternlogv4si_1 */

        case 33:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5688; /* *avx512f_vpternlogv8di_1 */

        case 34:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5715; /* *avx512vl_vpternlogv4di_1 */

        case 35:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5742; /* *avx512vl_vpternlogv2di_1 */

        case 36:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6729; /* *avx512bw_vpternlogv64qi_3 */

        case 37:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6738; /* *avx512vl_vpternlogv32qi_3 */

        case 38:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6747; /* *avx512vl_vpternlogv16qi_3 */

        case 39:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6756; /* *avx512bw_vpternlogv32hi_3 */

        case 40:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6765; /* *avx512vl_vpternlogv16hi_3 */

        case 41:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6774; /* *avx512vl_vpternlogv8hi_3 */

        case 42:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6783; /* *avx512f_vpternlogv16si_3 */

        case 43:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6792; /* *avx512vl_vpternlogv8si_3 */

        case 44:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6801; /* *avx512vl_vpternlogv4si_3 */

        case 45:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6810; /* *avx512f_vpternlogv8di_3 */

        case 46:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6819; /* *avx512vl_vpternlogv4di_3 */

        case 47:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6828; /* *avx512vl_vpternlogv2di_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6087; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6114; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6141; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6168; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6195; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6222; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6249; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6276; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6303; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6330; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6357; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6384; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6090; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6117; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6144; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6171; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6198; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6225; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6252; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6279; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6306; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6333; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6360; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6387; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6093; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6120; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6147; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6174; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6201; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6228; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6255; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6282; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6309; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6336; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6363; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6390; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_313 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != CONST_VECTOR
      || XVECLEN (x5, 0) != 32
      || pattern1346 (x5, 
E_V32HImode) != 0)
    return -1;
  x6 = XVECEXP (x5, 0, 8);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x7 = XVECEXP (x5, 0, 9);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x8 = XVECEXP (x5, 0, 10);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x9 = XVECEXP (x5, 0, 11);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x10 = XVECEXP (x5, 0, 12);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x11 = XVECEXP (x5, 0, 13);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x12 = XVECEXP (x5, 0, 14);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x5, 0, 15);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x14 = XVECEXP (x5, 0, 16);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x15 = XVECEXP (x5, 0, 17);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x16 = XVECEXP (x5, 0, 18);
  if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x17 = XVECEXP (x5, 0, 19);
  if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x18 = XVECEXP (x5, 0, 20);
  if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x19 = XVECEXP (x5, 0, 21);
  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x20 = XVECEXP (x5, 0, 22);
  if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x21 = XVECEXP (x5, 0, 23);
  if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x22 = XVECEXP (x5, 0, 24);
  if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x23 = XVECEXP (x5, 0, 25);
  if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x24 = XVECEXP (x5, 0, 26);
  if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x25 = XVECEXP (x5, 0, 27);
  if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x26 = XVECEXP (x5, 0, 28);
  if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x27 = XVECEXP (x5, 0, 29);
  if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x28 = XVECEXP (x5, 0, 30);
  if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x29 = XVECEXP (x5, 0, 31);
  if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
      || !register_operand (operands[0], E_V32HImode)
      || GET_MODE (x2) != E_V32HImode
      || GET_MODE (x3) != E_V32SImode
      || pattern1495 (x4, 
E_V32SImode) != 0)
    return -1;
  x30 = XEXP (x4, 0);
  x31 = XEXP (x30, 0);
  x32 = XEXP (x31, 1);
  if (GET_MODE (x32) != E_V32SImode)
    return -1;
  x33 = XEXP (x32, 0);
  operands[2] = x33;
  if (!nonimmediate_operand (operands[2], E_V32HImode)
      || !
#line 22830 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
    return -1;
  return 8539; /* avx512bw_umulhrswv32hi3 */
}

 int
recog_314 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case VEC_SELECT:
      return recog_267 (x1, insn, pnum_clobbers);

    case VEC_CONCAT:
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case PLUS:
          switch (pattern328 (x3, 
PLUS))
            {
            case 0:
              if (!
#line 3670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 3149; /* avx_haddv4df3 */

            case 1:
              if (!
#line 3846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3))
                return -1;
              return 3157; /* sse3_haddv4sf3 */

            default:
              return -1;
            }

        case MINUS:
          switch (pattern328 (x3, 
MINUS))
            {
            case 0:
              if (!
#line 3670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 3150; /* avx_hsubv4df3 */

            case 1:
              if (!
#line 3846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3))
                return -1;
              return 3158; /* sse3_hsubv4sf3 */

            default:
              return -1;
            }

        case VEC_CONCAT:
          if (GET_MODE (x5) != E_V2SFmode)
            return -1;
          x6 = XEXP (x4, 1);
          if (GET_CODE (x6) != VEC_CONCAT
              || GET_MODE (x6) != E_V2SFmode)
            return -1;
          x7 = XEXP (x3, 1);
          if (GET_CODE (x7) != VEC_CONCAT
              || GET_MODE (x7) != E_V4SFmode
              || pattern1022 (x7, 
E_V2SFmode, 
VEC_CONCAT) != 0
              || !register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x3) != E_V8SFmode
              || GET_MODE (x4) != E_V4SFmode
              || pattern1535 (x3, 
E_SFmode) != 0)
            return -1;
          x8 = XEXP (x5, 0);
          switch (GET_CODE (x8))
            {
            case PLUS:
              if (pattern1799 (x3, 
PLUS) != 0
                  || !
#line 3818 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 3155; /* avx_haddv8sf3 */

            case MINUS:
              if (pattern1799 (x3, 
MINUS) != 0
                  || !
#line 3818 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 3156; /* avx_hsubv8sf3 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x5;
          if (pattern410 (x3) != 0)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (pattern1466 (x3, 
E_V8SImode, 
E_V4SImode, 
E_V16SImode) != 0
                  || !(
#line 30141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 10029; /* avx512f_si512_si */

            case E_V16SFmode:
              if (pattern1466 (x3, 
E_V8SFmode, 
E_V4SFmode, 
E_V16SFmode) != 0
                  || !(
#line 30141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 10030; /* avx512f_ps512_ps */

            case E_V8DFmode:
              if (pattern1466 (x3, 
E_V4DFmode, 
E_V2DFmode, 
E_V8DFmode) != 0
                  || !(
#line 30141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 10031; /* avx512f_pd512_pd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      if (pattern95 (x3, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      x7 = XEXP (x3, 1);
      x9 = XEXP (x7, 0);
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      if (!vector_operand (operands[2], E_V2DFmode)
          || pattern1832 (x3) != 0
          || !
#line 3709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && INTVAL (operands[3]) != INTVAL (operands[4])
   && INTVAL (operands[5]) != INTVAL (operands[6])))
        return -1;
      return 3151; /* *sse3_haddv2df3 */

    case MINUS:
      if (pattern96 (x4, 
E_DFmode) != 0)
        return -1;
      x7 = XEXP (x3, 1);
      if (GET_CODE (x7) != MINUS
          || GET_MODE (x7) != E_DFmode
          || pattern1536 (x7, 
E_DFmode) != 0
          || !register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      x5 = XEXP (x4, 0);
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      x9 = XEXP (x7, 0);
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      if (!vector_operand (operands[2], E_V2DFmode))
        return -1;
      x6 = XEXP (x4, 1);
      x11 = XEXP (x6, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      x12 = XEXP (x7, 1);
      x13 = XEXP (x12, 0);
      if (!rtx_equal_p (x13, operands[2])
          || !
#line 3734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3))
        return -1;
      return 3152; /* sse3_hsubv2df3 */

    case FLOAT:
      switch (pattern180 (x3))
        {
        case 0:
          if (!
#line 7682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4456; /* *avx512fp16_vcvtdq2ph_v4si */

        case 1:
          if (!
#line 7682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4458; /* *avx512fp16_vcvtqq2ph_v4di */

        case 2:
          if (!
#line 7758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4468; /* *avx512fp16_vcvtqq2ph_v2di */

        case 3:
          if (!
#line 9194 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 4912; /* *avx512dq_floatv2div2sf2 */

        default:
          return -1;
        }

    case UNSIGNED_FLOAT:
      switch (pattern180 (x3))
        {
        case 0:
          if (!
#line 7682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4457; /* *avx512fp16_vcvtudq2ph_v4si */

        case 1:
          if (!
#line 7682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4459; /* *avx512fp16_vcvtuqq2ph_v4di */

        case 2:
          if (!
#line 7758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4469; /* *avx512fp16_vcvtuqq2ph_v2di */

        case 3:
          if (!
#line 9194 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 4913; /* *avx512dq_floatunsv2div2sf2 */

        default:
          return -1;
        }

    case VEC_MERGE:
      return recog_266 (x1, insn, pnum_clobbers);

    case FLOAT_TRUNCATE:
      x7 = XEXP (x3, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[2] = x7;
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[0], E_V8HFmode)
                  || GET_MODE (x3) != E_V8HFmode)
                return -1;
              switch (GET_MODE (x4))
                {
                case E_V4HFmode:
                  if (!const0_operand (operands[2], E_V4HFmode))
                    return -1;
                  switch (GET_MODE (operands[1]))
                    {
                    case E_V4DFmode:
                      if (!vector_operand (operands[1], E_V4DFmode)
                          || !
#line 8149 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4682; /* *avx512fp16_vcvtpd2ph_v4df */

                    case E_V4SFmode:
                      if (!vector_operand (operands[1], E_V4SFmode)
                          || !
#line 8149 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4683; /* *avx512fp16_vcvtps2ph_v4sf */

                    default:
                      return -1;
                    }

                case E_V2HFmode:
                  if (!vector_operand (operands[1], E_V2DFmode)
                      || !const0_operand (operands[2], E_V6HFmode)
                      || !
#line 8228 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                    return -1;
                  return 4688; /* *avx512fp16_vcvtpd2ph_v2df */

                default:
                  return -1;
                }

            case E_V4SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x3) != E_V4SFmode
                  || GET_MODE (x4) != E_V2SFmode
                  || !vector_operand (operands[1], E_V2DFmode)
                  || !const0_operand (operands[2], E_V2SFmode)
                  || !
#line 10119 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return -1;
              return 5087; /* *sse2_cvtpd2ps */

            case E_V8BFmode:
              if (pattern179 (x3, 
E_V4BFmode, 
E_V4SFmode, 
E_V8BFmode) != 0
                  || !
#line 31067 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT || (TARGET_AVX512BF16 && TARGET_AVX512VL)))
                return -1;
              return 10270; /* *vcvtneps2bf16_v4sf */

            default:
              return -1;
            }

        case FLOAT_TRUNCATE:
          x5 = XEXP (x4, 0);
          operands[2] = x5;
          x9 = XEXP (x7, 0);
          operands[1] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V32BFmode:
              if (pattern786 (x3, 
E_V16SFmode, 
E_V16BFmode, 
E_V32BFmode) != 0
                  || !(
#line 31028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 30994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 10264; /* avx512f_cvtne2ps2bf16_v32bf */

            case E_V16BFmode:
              if (pattern786 (x3, 
E_V8SFmode, 
E_V8BFmode, 
E_V16BFmode) != 0
                  || !(
#line 31028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 30994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10266; /* avx512f_cvtne2ps2bf16_v16bf */

            case E_V8BFmode:
              if (pattern786 (x3, 
E_V4SFmode, 
E_V4BFmode, 
E_V8BFmode) != 0
                  || !(
#line 31028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 30994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10268; /* avx512f_cvtne2ps2bf16_v8bf */

            case E_V32HFmode:
              if (pattern787 (x3, 
E_V16SFmode, 
E_V16HFmode, 
E_V32HFmode) != 0
                  || !(
#line 31727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10363; /* avx10_2_cvt2ps2phx_v32hf */

            case E_V16HFmode:
              if (pattern787 (x3, 
E_V8SFmode, 
E_V8HFmode, 
E_V16HFmode) != 0
                  || !
#line 31727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10367; /* avx10_2_cvt2ps2phx_v16hf */

            case E_V8HFmode:
              if (pattern787 (x3, 
E_V4SFmode, 
E_V4HFmode, 
E_V8HFmode) != 0
                  || !
#line 31727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10369; /* avx10_2_cvt2ps2phx_v8hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      return recog_268 (x1, insn, pnum_clobbers);

    case UNSIGNED_FIX:
      if (GET_MODE (x4) != E_V2SImode)
        return -1;
      x7 = XEXP (x3, 1);
      if (GET_CODE (x7) != CONST_VECTOR
          || XVECLEN (x7, 0) != 2
          || GET_MODE (x7) != E_V2SImode
          || pattern277 (x3, 
E_V2DFmode, 
E_V4SImode, 
0) != 0
          || !
#line 9580 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return -1;
      return 4966; /* *fixuns_truncv2dfv2si2 */

    case FIX:
      if (GET_MODE (x4) != E_V2SImode)
        return -1;
      x7 = XEXP (x3, 1);
      if (GET_CODE (x7) != CONST_VECTOR
          || pattern510 (x7, 
E_V2SImode, 
2) != 0
          || !register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!vector_operand (operands[1], E_V2DFmode)
          || !
#line 9938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 5068; /* sse2_cvttpd2dq */

    case REG:
    case SUBREG:
    case MEM:
      x7 = XEXP (x3, 1);
      switch (GET_CODE (x7))
        {
        case VEC_SELECT:
          res = recog_264 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case REG:
        case SUBREG:
        case MEM:
          res = recog_265 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case UNSPEC:
          if (XVECLEN (x7, 0) == 1
              && XINT (x7, 1) == 147)
            {
              x14 = XVECEXP (x7, 0, 0);
              if (x14 == const_int_rtx[MAX_SAVED_CONST_INT + 0])
                {
                  operands[1] = x4;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V8SImode:
                      if (pattern1023 (x3, 
E_V4SImode, 
E_V8SImode) == 0
                          && 
#line 28815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
                        return 9476; /* avx_si256_si */
                      break;

                    case E_V8SFmode:
                      if (pattern1023 (x3, 
E_V4SFmode, 
E_V8SFmode) == 0
                          && 
#line 28815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
                        return 9477; /* avx_ps256_ps */
                      break;

                    case E_V4DFmode:
                      if (pattern1023 (x3, 
E_V2DFmode, 
E_V4DFmode) == 0
                          && 
#line 28815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
                        return 9478; /* avx_pd256_pd */
                      break;

                    case E_V16SImode:
                      if (pattern1023 (x3, 
E_V8SImode, 
E_V16SImode) == 0
                          && (
#line 30158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 10032; /* avx512f_si512_256si */
                      break;

                    case E_V16SFmode:
                      if (pattern1023 (x3, 
E_V8SFmode, 
E_V16SFmode) == 0
                          && (
#line 30158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 10033; /* avx512f_ps512_256ps */
                      break;

                    case E_V8DFmode:
                      if (pattern1023 (x3, 
E_V4DFmode, 
E_V8DFmode) == 0
                          && (
#line 30158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 10034; /* avx512f_pd512_256pd */
                      break;

                    default:
                      break;
                    }
                }
            }
          break;

        default:
          break;
        }
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode)
        return -1;
      if (GET_CODE (x4) == SUBREG
          && known_eq (SUBREG_BYTE (x4), 0)
          && GET_MODE (x4) == E_V2DImode)
        {
          x5 = XEXP (x4, 0);
          if (pattern83 (x5, 
E_V16QImode, 
119, 
1) == 0
              && GET_CODE (x7) == SUBREG
              && pattern1238 (x7) == 0)
            {
              x15 = XVECEXP (x5, 0, 0);
              operands[1] = x15;
              if (memory_operand (operands[1], E_V16QImode))
                {
                  x9 = XEXP (x7, 0);
                  x16 = XVECEXP (x9, 0, 0);
                  if (rtx_equal_p (x16, operands[1])
                      && 
#line 27912 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && ix86_pre_reload_split ()))
                    return 9223; /* avx2_lddqu_inserti_to_bcasti */
                }
            }
        }
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_V2DImode))
        return -1;
      if (rtx_equal_p (x7, operands[1])
          && 
#line 28004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
        return 9241; /* avx_vbroadcastf128_v4di */
      operands[2] = x7;
      if (!nonimm_or_0_operand (operands[2], E_V2DImode)
          || !
#line 28949 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && (operands[2] == CONST0_RTX (V2DImode)
       || !MEM_P (operands[1]))))
        return -1;
      return 9538; /* avx_vec_concatv4di */

    case ZERO_EXTEND:
      switch (pattern181 (x3))
        {
        case 0:
          if (!
#line 12083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()))
            return -1;
          return 5221; /* *vec_setv2di_0_zero_extendhi_1 */

        case 1:
          if (!
#line 12197 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return -1;
          return 5233; /* *vec_setv2di_0_zero_extendsi_1 */

        default:
          return -1;
        }

    case SS_TRUNCATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x7 = XEXP (x3, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[2] = x7;
          switch (pattern512 (x3))
            {
            case 0:
              if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7206; /* avx512vl_ss_truncatev4div4qi2 */
              break;

            case 1:
              if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7215; /* avx512vl_ss_truncatev4siv4qi2 */
              break;

            case 2:
              if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7209; /* avx512vl_ss_truncatev2div2qi2 */
              break;

            case 3:
              if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7212; /* avx512vl_ss_truncatev8siv8qi2 */
              break;

            case 4:
              if ((
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return 7218; /* avx512vl_ss_truncatev8hiv8qi2 */
              break;

            case 5:
              if ((
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return 7297; /* avx512vl_ss_truncatev4div4hi2 */
              break;

            case 6:
              if (
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7303; /* avx512vl_ss_truncatev4siv4hi2 */
              break;

            case 7:
              if (
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7300; /* avx512vl_ss_truncatev2div2hi2 */
              break;

            case 8:
              if (
#line 15949 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return 7352; /* avx512vl_ss_truncatev2div2si2 */
              break;

            default:
              break;
            }
          if (GET_CODE (x7) != CONST_VECTOR
              || pattern510 (x7, 
E_V8QImode, 
8) != 0)
            return -1;
          x17 = XVECEXP (x7, 0, 2);
          if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x18 = XVECEXP (x7, 0, 3);
          if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x19 = XVECEXP (x7, 0, 4);
          if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x20 = XVECEXP (x7, 0, 5);
          if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x21 = XVECEXP (x7, 0, 6);
          if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x22 = XVECEXP (x7, 0, 7);
          if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || pattern603 (x3, 
E_V8DImode, 
E_V8QImode, 
E_V16QImode) != 0
              || !
#line 16085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7371; /* avx512f_ss_truncatev8div16qi2 */

        case SS_TRUNCATE:
          x9 = XEXP (x7, 0);
          operands[2] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V16QImode:
              if (pattern792 (x3, 
E_V8HImode, 
E_V8QImode, 
E_V16QImode) != 0
                  || !
#line 19198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                return -1;
              return 8228; /* sse2_packsswb */

            case E_V8HImode:
              if (pattern792 (x3, 
E_V4SImode, 
E_V4HImode, 
E_V8HImode) != 0
                  || !
#line 19292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                return -1;
              return 8234; /* sse2_packssdw */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case TRUNCATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x7 = XEXP (x3, 1);
      operands[2] = x7;
      switch (pattern512 (x3))
        {
        case 0:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7207; /* avx512vl_truncatev4div4qi2 */
          break;

        case 1:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7216; /* avx512vl_truncatev4siv4qi2 */
          break;

        case 2:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7210; /* avx512vl_truncatev2div2qi2 */
          break;

        case 3:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7213; /* avx512vl_truncatev8siv8qi2 */
          break;

        case 4:
          if ((
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 7219; /* avx512vl_truncatev8hiv8qi2 */
          break;

        case 5:
          if ((
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return 7298; /* avx512vl_truncatev4div4hi2 */
          break;

        case 6:
          if (
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7304; /* avx512vl_truncatev4siv4hi2 */
          break;

        case 7:
          if (
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7301; /* avx512vl_truncatev2div2hi2 */
          break;

        case 8:
          if (
#line 15949 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7353; /* avx512vl_truncatev2div2si2 */
          break;

        default:
          break;
        }
      if (!register_operand (operands[1], E_V8DImode)
          || pattern513 (x3) != 0
          || !
#line 16085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 7372; /* avx512f_truncatev8div16qi2 */

    case US_TRUNCATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x7 = XEXP (x3, 1);
      operands[2] = x7;
      switch (pattern512 (x3))
        {
        case 0:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7208; /* avx512vl_us_truncatev4div4qi2 */
          break;

        case 1:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7217; /* avx512vl_us_truncatev4siv4qi2 */
          break;

        case 2:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7211; /* avx512vl_us_truncatev2div2qi2 */
          break;

        case 3:
          if (
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7214; /* avx512vl_us_truncatev8siv8qi2 */
          break;

        case 4:
          if ((
#line 15353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 7220; /* avx512vl_us_truncatev8hiv8qi2 */
          break;

        case 5:
          if ((
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15670 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return 7299; /* avx512vl_us_truncatev4div4hi2 */
          break;

        case 6:
          if (
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7305; /* avx512vl_us_truncatev4siv4hi2 */
          break;

        case 7:
          if (
#line 15708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7302; /* avx512vl_us_truncatev2div2hi2 */
          break;

        case 8:
          if (
#line 15949 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7354; /* avx512vl_us_truncatev2div2si2 */
          break;

        default:
          break;
        }
      if (!register_operand (operands[1], E_V8DImode)
          || pattern513 (x3) != 0
          || !
#line 16085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 7373; /* avx512f_us_truncatev8div16qi2 */

    default:
      return -1;
    }
}

 int
recog_319 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case VEC_SELECT:
      return recog_296 (x1, insn, pnum_clobbers);

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DFmode:
          if (!register_operand (operands[0], E_V2DFmode)
              || GET_MODE (x3) != E_V2DFmode
              || !nonimmediate_operand (operands[1], E_DFmode))
            return -1;
          if (
#line 14872 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return 7145; /* vec_dupv2df */
          if (!(
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9214; /* *avx512vl_vec_dup_gprv2df */

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x3) != E_V16SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 27746 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9160; /* *avx512f_broadcastv16sf */

            case E_SFmode:
              if (!nonimmediate_operand (operands[1], E_SFmode)
                  || !(
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9204; /* *avx512f_vec_dup_gprv16sf */

            case E_V8SFmode:
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !(
#line 28066 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9260; /* *avx512dq_broadcastv16sf_1 */

            default:
              return -1;
            }

        case E_V16SImode:
          if (!register_operand (operands[0], E_V16SImode)
              || GET_MODE (x3) != E_V16SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode)
                  || !(
#line 27746 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9162; /* *avx512f_broadcastv16si */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !(
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9192; /* *avx512f_vec_dup_gprv16si */

            case E_V8SImode:
              if (!nonimmediate_operand (operands[1], E_V8SImode)
                  || !(
#line 28066 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9262; /* *avx512dq_broadcastv16si_1 */

            default:
              return -1;
            }

        case E_V8DFmode:
          if (!register_operand (operands[0], E_V8DFmode)
              || GET_MODE (x3) != E_V8DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4DFmode:
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !(
#line 27758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9164; /* *avx512f_broadcastv8df */

            case E_DFmode:
              if (!nonimmediate_operand (operands[1], E_DFmode)
                  || !(
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9210; /* *avx512f_vec_dup_gprv8df */

            case E_V2DFmode:
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !(
#line 28084 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9266; /* *avx512dq_broadcastv8df_1 */

            default:
              return -1;
            }

        case E_V8DImode:
          if (!register_operand (operands[0], E_V8DImode)
              || GET_MODE (x3) != E_V8DImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !(
#line 27758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9166; /* *avx512f_broadcastv8di */

            case E_DImode:
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !(
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9198; /* *avx512f_vec_dup_gprv8di */

            case E_V2DImode:
              if (!nonimmediate_operand (operands[1], E_V2DImode)
                  || !(
#line 28084 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9264; /* *avx512dq_broadcastv8di_1 */

            default:
              return -1;
            }

        case E_V64QImode:
          if (!register_operand (operands[0], E_V64QImode)
              || GET_MODE (x3) != E_V64QImode
              || !nonimmediate_operand (operands[1], E_QImode)
              || !(
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9168; /* *avx512bw_vec_dup_gprv64qi */

        case E_V16QImode:
          if (!register_operand (operands[0], E_V16QImode)
              || GET_MODE (x3) != E_V16QImode
              || !nonimmediate_operand (operands[1], E_QImode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9170; /* *avx512vl_vec_dup_gprv16qi */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9225; /* *vec_dupv16qi */

        case E_V32QImode:
          if (!register_operand (operands[0], E_V32QImode)
              || GET_MODE (x3) != E_V32QImode
              || !nonimmediate_operand (operands[1], E_QImode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9172; /* *avx512vl_vec_dup_gprv32qi */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9224; /* *vec_dupv32qi */

        case E_V32HImode:
          if (!register_operand (operands[0], E_V32HImode)
              || GET_MODE (x3) != E_V32HImode
              || !nonimmediate_operand (operands[1], E_HImode)
              || !(
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9174; /* *avx512bw_vec_dup_gprv32hi */

        case E_V16HImode:
          if (!register_operand (operands[0], E_V16HImode)
              || GET_MODE (x3) != E_V16HImode
              || !nonimmediate_operand (operands[1], E_HImode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9176; /* *avx512vl_vec_dup_gprv16hi */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9226; /* *vec_dupv16hi */

        case E_V8HImode:
          if (!register_operand (operands[0], E_V8HImode)
              || GET_MODE (x3) != E_V8HImode
              || !nonimmediate_operand (operands[1], E_HImode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9178; /* *avx512vl_vec_dup_gprv8hi */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9227; /* *vec_dupv8hi */

        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x3) != E_V32HFmode
              || !nonimmediate_operand (operands[1], E_HFmode)
              || !(
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9180; /* *avx512bw_vec_dup_gprv32hf */

        case E_V16HFmode:
          if (!register_operand (operands[0], E_V16HFmode)
              || GET_MODE (x3) != E_V16HFmode
              || !nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9182; /* *avx512vl_vec_dup_gprv16hf */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9230; /* *vec_dupv16hf */

        case E_V8HFmode:
          if (!register_operand (operands[0], E_V8HFmode)
              || GET_MODE (x3) != E_V8HFmode
              || !nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9184; /* *avx512fp16_vec_dup_gprv8hf */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9231; /* *vec_dupv8hf */

        case E_V32BFmode:
          if (!register_operand (operands[0], E_V32BFmode)
              || GET_MODE (x3) != E_V32BFmode
              || !nonimmediate_operand (operands[1], E_BFmode)
              || !(
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9186; /* *avx512bw_vec_dup_gprv32bf */

        case E_V16BFmode:
          if (!register_operand (operands[0], E_V16BFmode)
              || GET_MODE (x3) != E_V16BFmode
              || !nonimmediate_operand (operands[1], E_BFmode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9188; /* *avx512vl_vec_dup_gprv16bf */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9232; /* *vec_dupv16bf */

        case E_V8BFmode:
          if (!register_operand (operands[0], E_V8BFmode)
              || GET_MODE (x3) != E_V8BFmode
              || !nonimmediate_operand (operands[1], E_BFmode))
            return -1;
          if ((
#line 27770 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9190; /* *avx512vl_vec_dup_gprv8bf */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9233; /* *vec_dupv8bf */

        case E_V8SImode:
          if (!register_operand (operands[0], E_V8SImode)
              || GET_MODE (x3) != E_V8SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 9194; /* *avx512vl_vec_dup_gprv8si */
              if (
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 9228; /* *vec_dupv8si */
              if (!
#line 27952 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 9234; /* vec_dupv8si */

            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode)
                  || !
#line 28053 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 9256; /* *avx512vl_broadcastv8si_1 */

            default:
              return -1;
            }

        case E_V4SImode:
          if (!register_operand (operands[0], E_V4SImode)
              || GET_MODE (x3) != E_V4SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9196; /* *avx512vl_vec_dup_gprv4si */
          if (
#line 27829 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return 9217; /* *vec_dupv4si */
          if (!
#line 27932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 9229; /* *vec_dupv4si */

        case E_V4DImode:
          if (!register_operand (operands[0], E_V4DImode)
              || GET_MODE (x3) != E_V4DImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_DImode:
              if (!nonimmediate_operand (operands[1], E_DImode))
                return -1;
              if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 9200; /* *avx512vl_vec_dup_gprv4di */
              if (!
#line 27952 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 9236; /* vec_dupv4di */

            case E_V2DImode:
              if (!nonimmediate_operand (operands[1], E_V2DImode)
                  || !(
#line 28084 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9268; /* *avx512dq_broadcastv4di_1 */

            default:
              return -1;
            }

        case E_V2DImode:
          if (!register_operand (operands[0], E_V2DImode)
              || GET_MODE (x3) != E_V2DImode
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9202; /* *avx512vl_vec_dup_gprv2di */
          if (!
#line 27857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 9218; /* *vec_dupv2di */

        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x3) != E_V8SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_SFmode:
              if (!nonimmediate_operand (operands[1], E_SFmode))
                return -1;
              if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 9206; /* *avx512vl_vec_dup_gprv8sf */
              if (!
#line 27952 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 9235; /* vec_dupv8sf */

            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !
#line 28053 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 9258; /* *avx512vl_broadcastv8sf_1 */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x3) != E_V4SFmode
              || !nonimmediate_operand (operands[1], E_SFmode))
            return -1;
          if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 9208; /* *avx512vl_vec_dup_gprv4sf */
          if (!
#line 27797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 9216; /* vec_dupv4sf */

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || GET_MODE (x3) != E_V4DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_DFmode:
              if (!nonimmediate_operand (operands[1], E_DFmode))
                return -1;
              if ((
#line 27782 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 9212; /* *avx512vl_vec_dup_gprv4df */
              if (!
#line 27952 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                return -1;
              return 9237; /* vec_dupv4df */

            case E_V2DFmode:
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !(
#line 28084 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9270; /* *avx512dq_broadcastv4df_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case FLOAT_EXTEND:
      if (GET_MODE (x4) != E_SFmode)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          switch (pattern670 (x3, 
E_V8SFmode))
            {
            case 0:
              if (!(
#line 31643 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT) && 
#line 440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 10351; /* vbcstnebf162ps_v8sf */

            case 1:
              if (!(
#line 31654 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT) && 
#line 440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 10353; /* vbcstnesh2ps_v8sf */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern670 (x3, 
E_V4SFmode))
            {
            case 0:
              if (!
#line 31643 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                return -1;
              return 10352; /* vbcstnebf162ps_v4sf */

            case 1:
              if (!
#line 31654 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                return -1;
              return 10354; /* vbcstnesh2ps_v4sf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_324 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x3) != E_V16HImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 7535; /* *ashrv16hi3 */
      if (!register_operand (operands[1], E_V16HImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17094 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 743 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7545; /* ashrv16hi3 */
      if (!nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 28916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9493; /* avx512vl_ashrvv16hi */

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 7537; /* *ashrv8hi3 */
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17094 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7546; /* ashrv8hi3 */
      if (!nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 28916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9491; /* avx512vl_ashrvv8hi */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7539; /* *ashrv8si3 */
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17094 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 744 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7547; /* ashrv8si3 */
      if (!nonimmediate_operand (operands[2], E_V8SImode)
          || !
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9481; /* avx2_ashrvv8si */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7541; /* *ashrv4si3 */
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17094 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7548; /* ashrv4si3 */
      if (!nonimmediate_operand (operands[2], E_V4SImode)
          || !
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9479; /* avx2_ashrvv4si */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7543; /* *ashrv2di3 */
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 26983 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !TARGET_AVX512VL && ix86_pre_reload_split ()))
        return 8979; /* *ashrv2di3 */
      if (!nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9485; /* avx2_ashrvv2di */

    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x3) != E_V32HImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 788 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return 7553; /* *ashrv32hi3 */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 28916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9495; /* avx512bw_ashrvv32hi */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7555; /* *ashrv4di3 */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9487; /* avx2_ashrvv4di */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x3) != E_V16SImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 7557; /* *ashrv16si3 */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 680 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9483; /* avx512f_ashrvv16si */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x3) != E_V8DImode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 7559; /* *ashrv8di3 */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 28905 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9489; /* avx512f_ashrvv8di */

    case E_V1TImode:
      if (pattern30 (x3) != 0
          || !
#line 17498 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()))
        return -1;
      return 7624; /* *ashrv1ti3_internal */

    default:
      return -1;
    }
}

 int
recog_326 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern29 (x1))
    {
    case 0:
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 7570; /* *ashlv16hi3 */
      if (!register_operand (operands[1], E_V16HImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 774 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7594; /* ashlv16hi3 */
      if (!nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9525; /* avx512vl_ashlvv16hi */

    case 1:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 7574; /* *ashlv8hi3 */
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7596; /* ashlv8hi3 */
      if (!nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9521; /* avx512vl_ashlvv8hi */

    case 2:
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7578; /* *ashlv8si3 */
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7598; /* ashlv8si3 */
      if (!nonimmediate_operand (operands[2], E_V8SImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9501; /* avx2_ashlvv8si */

    case 3:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7582; /* *ashlv4si3 */
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7600; /* ashlv4si3 */
      if (!nonimmediate_operand (operands[2], E_V4SImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9505; /* avx2_ashlvv4si */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7586; /* *ashlv4di3 */
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && (
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 776 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return 7602; /* ashlv4di3 */
      if (!nonimmediate_operand (operands[2], E_V4DImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9513; /* avx2_ashlvv4di */

    case 5:
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return 7590; /* *ashlv2di3 */
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      if (nonmemory_operand (operands[2], E_DImode)
          && 
#line 17290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return 7604; /* ashlv2di3 */
      if (!nonimmediate_operand (operands[2], E_V2DImode)
          || !
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 9517; /* avx2_ashlvv2di */

    case 6:
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return 7610; /* ashlv32hi3 */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 28938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9529; /* avx512bw_ashlvv32hi */

    case 7:
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 7614; /* ashlv16si3 */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9497; /* avx512f_ashlvv16si */

    case 8:
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 7618; /* ashlv8di3 */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 28927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 9509; /* avx512f_ashlvv8di */

    case 9:
      if (register_operand (operands[1], E_V1TImode)
          && const_0_to_255_not_mul_8_operand (operands[2], E_SImode)
          && 
#line 17439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()))
        return 7622; /* *ashlv1ti3_internal */
      if (!const_0_to_255_mul_8_operand (operands[2], E_SImode))
        return -1;
      if (nonimmediate_operand (operands[1], E_V1TImode)
          && (
#line 17583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7631; /* avx512bw_ashlv1ti3 */
      if (!register_operand (operands[1], E_V1TImode)
          || !
#line 17598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 7635; /* sse2_ashlv1ti3 */

    case 10:
      if (!(
#line 17583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7627; /* avx512bw_ashlv4ti3 */

    case 11:
      if (nonimmediate_operand (operands[1], E_V2TImode)
          && (
#line 17583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7629; /* avx512bw_ashlv2ti3 */
      if (!register_operand (operands[1], E_V2TImode)
          || !(
#line 17598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 7633; /* avx2_ashlv2ti3 */

    default:
      return -1;
    }
}

 int
recog_331 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x3) != E_V16SImode
          || !nonimmediate_operand (operands[1], E_V16SImode)
          || !(
#line 30289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10059; /* vpopcountv16si */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode
          || !nonimmediate_operand (operands[1], E_V8SImode)
          || !(
#line 30289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10061; /* vpopcountv8si */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !nonimmediate_operand (operands[1], E_V4SImode)
          || !(
#line 30289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10063; /* vpopcountv4si */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x3) != E_V8DImode
          || !nonimmediate_operand (operands[1], E_V8DImode)
          || !(
#line 30289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10065; /* vpopcountv8di */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode
          || !nonimmediate_operand (operands[1], E_V4DImode)
          || !(
#line 30289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10067; /* vpopcountv4di */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode
          || !nonimmediate_operand (operands[1], E_V2DImode)
          || !(
#line 30289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VPOPCNTDQ) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10069; /* vpopcountv2di */

    case E_V64QImode:
      if (!register_operand (operands[0], E_V64QImode)
          || GET_MODE (x3) != E_V64QImode
          || !nonimmediate_operand (operands[1], E_V64QImode)
          || !(
#line 30339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10079; /* vpopcountv64qi */

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !nonimmediate_operand (operands[1], E_V16QImode)
          || !(
#line 30339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10081; /* vpopcountv16qi */

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || GET_MODE (x3) != E_V32QImode
          || !nonimmediate_operand (operands[1], E_V32QImode)
          || !(
#line 30339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10083; /* vpopcountv32qi */

    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x3) != E_V32HImode
          || !nonimmediate_operand (operands[1], E_V32HImode)
          || !(
#line 30339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10085; /* vpopcountv32hi */

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x3) != E_V16HImode
          || !nonimmediate_operand (operands[1], E_V16HImode)
          || !(
#line 30339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10087; /* vpopcountv16hi */

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !nonimmediate_operand (operands[1], E_V8HImode)
          || !(
#line 30339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10089; /* vpopcountv8hi */

    default:
      return -1;
    }
}

 int
recog_337 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern26 (x1))
    {
    case 0:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 2986; /* *sminv32hf3 */

    case 1:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 2992; /* *sminv16hf3 */

    case 2:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 2996; /* *sminv8hf3 */

    case 3:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3002; /* *sminv16sf3 */

    case 4:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3008; /* *sminv8sf3 */

    case 5:
      if (!
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1))
        return -1;
      return 3012; /* *sminv4sf3 */

    case 6:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3018; /* *sminv8df3 */

    case 7:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3024; /* *sminv4df3 */

    case 8:
      if (!(
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3028; /* *sminv2df3 */

    case 9:
      if (
#line 17653 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7686; /* *avx2_sminv32qi3 */
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7763; /* *avx512bw_sminv32qi3 */

    case 10:
      if (
#line 17653 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7690; /* *avx2_sminv16hi3 */
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7779; /* *avx512bw_sminv16hi3 */

    case 11:
      if (
#line 17653 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7694; /* *avx2_sminv8si3 */
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7707; /* *avx512f_sminv8si3 */

    case 12:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7699; /* *avx512f_sminv16si3 */

    case 13:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7715; /* *avx512f_sminv4si3 */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7799; /* *sse4_1_sminv4si3 */

    case 14:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7723; /* *avx512f_sminv8di3 */

    case 15:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7731; /* *avx512f_sminv4di3 */

    case 16:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7739; /* *avx512f_sminv2di3 */

    case 17:
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7747; /* *avx512bw_sminv64qi3 */

    case 18:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7755; /* *avx512bw_sminv16qi3 */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7795; /* *sse4_1_sminv16qi3 */

    case 19:
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7771; /* *avx512bw_sminv32hi3 */

    case 20:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonimmediate_operand (operands[2], E_V8HImode)
          && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7787; /* *avx512bw_sminv8hi3 */
      if (!vector_operand (operands[1], E_V8HImode)
          || !vector_operand (operands[2], E_V8HImode)
          || !
#line 17816 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7802; /* *sminv8hi3 */

    case 21:
      if (!
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10520; /* avx10_2_sminbf16_v32bf */

    case 22:
      if (!
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10524; /* avx10_2_sminbf16_v16bf */

    case 23:
      if (!
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10528; /* avx10_2_sminbf16_v8bf */

    default:
      return -1;
    }
}

 int
recog_344 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern33 (x1))
    {
    case 0:
      if (
#line 17653 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7687; /* *avx2_umaxv32qi3 */
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7765; /* *avx512bw_umaxv32qi3 */

    case 1:
      if (
#line 17653 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7691; /* *avx2_umaxv16hi3 */
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7781; /* *avx512bw_umaxv16hi3 */

    case 2:
      if (
#line 17653 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7695; /* *avx2_umaxv8si3 */
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7709; /* *avx512f_umaxv8si3 */

    case 3:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7701; /* *avx512f_umaxv16si3 */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7717; /* *avx512f_umaxv4si3 */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !
#line 17881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7807; /* *sse4_1_umaxv4si3 */

    case 5:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7725; /* *avx512f_umaxv8di3 */

    case 6:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7733; /* *avx512f_umaxv4di3 */

    case 7:
      if (!(
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7741; /* *avx512f_umaxv2di3 */

    case 8:
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7749; /* *avx512bw_umaxv64qi3 */

    case 9:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7757; /* *avx512bw_umaxv16qi3 */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !
#line 17900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7811; /* *umaxv16qi3 */

    case 10:
      if (!(
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7773; /* *avx512bw_umaxv32hi3 */

    case 11:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonimmediate_operand (operands[2], E_V8HImode)
          && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7789; /* *avx512bw_umaxv8hi3 */
      if (!vector_operand (operands[1], E_V8HImode)
          || !vector_operand (operands[2], E_V8HImode)
          || !
#line 17881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7803; /* *sse4_1_umaxv8hi3 */

    default:
      return -1;
    }
}

 int
recog_353 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x4))
    {
    case CLOBBER:
      x5 = XEXP (x2, 1);
      operands[1] = x5;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case MEM:
          if (GET_MODE (x6) != E_BLKmode)
            return -1;
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != SCRATCH)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (push_operand (operands[0], E_SImode)
                  && general_no_elim_operand (operands[1], E_SImode)
                  && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
                return 74; /* *pushsi2_prologue */
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || !pop_operand (operands[1], E_SImode)
                  || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
                return -1;
              return 78; /* *popsi1_epilogue */

            case E_DImode:
              if (push_operand (operands[0], E_DImode)
                  && general_no_elim_operand (operands[1], E_DImode)
                  && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
                return 75; /* *pushdi2_prologue */
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !pop_operand (operands[1], E_DImode)
                  || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
                return -1;
              return 79; /* *popdi1_epilogue */

            default:
              return -1;
            }

        case REG:
          if (REGNO (x6) != 17
              || GET_MODE (x6) != E_CCmode)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (const0_operand (operands[1], E_SImode))
                {
                  if (register_operand (operands[0], E_SImode)
                      && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return 84; /* *movsi_xor */
                  if (memory_operand (operands[0], E_SImode)
                      && 
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return 87; /* *movsi_and */
                }
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || !constm1_operand (operands[1], E_SImode)
                  || !
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 90; /* *movsi_or */

            case E_DImode:
              if (const0_operand (operands[1], E_DImode))
                {
                  if (register_operand (operands[0], E_DImode)
                      && (
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 85; /* *movdi_xor */
                  if (memory_operand (operands[0], E_DImode)
                      && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 88; /* *movdi_and */
                }
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !constm1_operand (operands[1], E_DImode)
                  || !(
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 91; /* *movdi_or */

            case E_HImode:
              if (memory_operand (operands[0], E_HImode)
                  && const0_operand (operands[1], E_HImode)
                  && 
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return 86; /* *movhi_and */
              if (!nonimmediate_operand (operands[0], E_HImode)
                  || !constm1_operand (operands[1], E_HImode)
                  || !
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 89; /* *movhi_or */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SET:
      x8 = XEXP (x4, 1);
      switch (GET_CODE (x8))
        {
        case REG:
        case SUBREG:
          if (!rtx_equal_p (x8, operands[0]))
            return -1;
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          x6 = XEXP (x4, 0);
          if (!rtx_equal_p (x6, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !register_operand (operands[1], E_SImode))
                return -1;
              return 107; /* swapsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !register_operand (operands[1], E_DImode)
                  || !
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 108; /* swapdi */

            case E_QImode:
              if (!register_operand (operands[0], E_QImode)
                  || !register_operand (operands[1], E_QImode))
                return -1;
              return 109; /* *swapqi */

            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || !register_operand (operands[1], E_HImode))
                return -1;
              return 110; /* *swaphi */

            case E_XFmode:
              if (!register_operand (operands[0], E_XFmode)
                  || !register_operand (operands[1], E_XFmode)
                  || !
#line 4656 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 173; /* *swapxf */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x8, 0) != 1
              || XINT (x8, 1) != 72
              || GET_MODE (x8) != E_XFmode
              || !register_operand (operands[0], E_SFmode))
            return -1;
          x5 = XEXP (x2, 1);
          operands[3] = x5;
          if (!const1_operand (operands[3], E_SFmode))
            return -1;
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (!register_operand (operands[1], E_XFmode))
            return -1;
          x9 = XVECEXP (x8, 0, 0);
          operands[2] = x9;
          if (!register_operand (operands[2], E_XFmode)
              || !
#line 24123 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
            return -1;
          return 1720; /* fptanxf4_i387 */

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 108
          || GET_MODE (x4) != E_DImode)
        return -1;
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x5 = XEXP (x2, 1);
      operands[1] = x5;
      if (register_operand (operands[1], E_DImode)
          && push_operand (operands[0], E_DImode)
          && 
#line 3922 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return 161; /* pushp_di */
      if (!pop_operand (operands[1], E_DImode)
          || !register_operand (operands[0], E_DImode)
          || !
#line 3930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PPX))
        return -1;
      return 162; /* popp_di */

    default:
      return -1;
    }
}

 int
recog_365 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  if (pattern340 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode
              || GET_MODE (x4) != E_QImode
              || !nonimmediate_operand (operands[1], E_QImode)
              || !general_operand (operands[2], E_QImode)
              || !
#line 6689 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 287; /* *addqi_1_zexthi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !general_operand (operands[2], E_QImode)
                  || !
#line 6689 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 289; /* *addqi_1_zextsi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !general_operand (operands[2], E_HImode)
                  || !
#line 6727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 293; /* *addhi_1_zextsi */

            default:
              return -1;
            }

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !general_operand (operands[2], E_QImode)
                  || !
#line 6689 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 291; /* *addqi_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !general_operand (operands[2], E_HImode)
                  || !
#line 6727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 295; /* *addhi_1_zextdi */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || !
#line 6772 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 296; /* addsi_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      x7 = XEXP (x5, 0);
      switch (GET_CODE (x7))
        {
        case LTU:
        case UNLT:
          operands[3] = x7;
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != REG
              || REGNO (x8) != 17)
            return -1;
          x9 = XEXP (x7, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XEXP (x5, 1);
          operands[1] = x10;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          switch (pattern1138 (x3))
            {
            case 0:
              if (pattern1734 (x5, 
E_QImode) != 0
                  || !
#line 8907 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 465; /* *addqi3_carry_zexthi */

            case 1:
              if (pattern1734 (x5, 
E_QImode) != 0
                  || !
#line 8907 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 466; /* *addqi3_carry_zextsi */

            case 2:
              if (pattern1734 (x5, 
E_HImode) != 0
                  || !
#line 8926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 468; /* *addhi3_carry_zextsi */

            case 3:
              if (pattern1734 (x5, 
E_QImode) != 0
                  || !
#line 8907 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 467; /* *addqi3_carry_zextdi */

            case 4:
              if (pattern1734 (x5, 
E_HImode) != 0
                  || !
#line 8926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 469; /* *addhi3_carry_zextdi */

            case 5:
              if (pattern1734 (x5, 
E_SImode) != 0
                  || !
#line 8945 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 470; /* *addsi3_carry_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      switch (pattern1139 (x3))
        {
        case 0:
          if (!ix86_carry_flag_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 8964 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 471; /* *addqi3_carry_zexthi_0 */

        case 1:
          if (!ix86_carry_flag_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 8964 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 472; /* *addqi3_carry_zextsi_0 */

        case 2:
          if (!ix86_carry_flag_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 8978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 474; /* *addhi3_carry_zextsi_0 */

        case 3:
          if (!ix86_carry_flag_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 8964 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 473; /* *addqi3_carry_zextdi_0 */

        case 4:
          if (!ix86_carry_flag_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 8978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 475; /* *addhi3_carry_zextdi_0 */

        case 5:
          if (!ix86_carry_flag_operator (operands[2], E_SImode)
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 8992 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 476; /* *addsi3_carry_zext_0 */

        default:
          return -1;
        }

    case GE:
    case GEU:
      switch (pattern1139 (x3))
        {
        case 0:
          if (!ix86_carry_flag_unset_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 9009 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 477; /* *addqi3_carry_zexthi_0r */

        case 1:
          if (!ix86_carry_flag_unset_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 9009 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 478; /* *addqi3_carry_zextsi_0r */

        case 2:
          if (!ix86_carry_flag_unset_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 9023 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 480; /* *addhi3_carry_zextsi_0r */

        case 3:
          if (!ix86_carry_flag_unset_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 9009 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 479; /* *addqi3_carry_zextdi_0r */

        case 4:
          if (!ix86_carry_flag_unset_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 9023 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 481; /* *addhi3_carry_zextdi_0r */

        case 5:
          if (!ix86_carry_flag_unset_operator (operands[2], E_SImode)
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 9037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 482; /* *addsi3_carry_zext_0r */

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern1140 (x5) != 0
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || GET_MODE (x4) != E_SImode)
        return -1;
      x6 = XEXP (x4, 1);
      operands[1] = x6;
      if (!register_operand (operands[1], E_SImode)
          || !
#line 23269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_X32))
        return -1;
      return 1663; /* *add_tp_x32_zext */

    default:
      return -1;
    }
}

 int
recog_367 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      if (pattern340 (x1) != 0)
        return -1;
      switch (pattern1137 (x3))
        {
        case 0:
          if (!
#line 4851 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
            return -1;
          return 178; /* zero_extendqisi2_and */

        case 1:
          if (!
#line 4851 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
            return -1;
          return 179; /* zero_extendhisi2_and */

        case 2:
          if (!
#line 4905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
            return -1;
          return 182; /* zero_extendqihi2_and */

        default:
          return -1;
        }

    case PLUS:
      return recog_365 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_366 (x1, insn, pnum_clobbers);

    case MULT:
      if (pattern341 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || GET_MODE (x4) != E_HImode
              || !nonimmediate_operand (operands[1], E_HImode)
              || !immediate_operand (operands[2], E_HImode)
              || !
#line 10655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_ZU && true))
            return -1;
          return 597; /* *imulhisizu */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !immediate_operand (operands[2], E_HImode)
                  || !
#line 10655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_ZU && true))
                return -1;
              return 599; /* *imulhidizu */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || !
#line 10667 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              return 601; /* *mulsi3_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case DIV:
      if (pattern342 (x1, pnum_clobbers, 
MOD) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      x10 = XEXP (x9, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return -1;
      x11 = XEXP (x9, 1);
      if (!rtx_equal_p (x11, operands[3])
          || !
#line 11696 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 655; /* *divmodsi4_zext_1 */

    case UDIV:
      if (pattern342 (x1, pnum_clobbers, 
UMOD) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      switch (pattern1604 (x9))
        {
        case 0:
          if (!
#line 11731 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 656; /* *udivmodsi4_zext_1 */

        case 1:
          if (!
#line 11753 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
            return -1;
          *pnum_clobbers = 1;
          return 657; /* *udivmodsi4_pow2_zext_1 */

        default:
          return -1;
        }

    case MOD:
      if (pattern343 (x1, pnum_clobbers, 
DIV) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[0] = x8;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      x10 = XEXP (x9, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return -1;
      x11 = XEXP (x9, 1);
      if (!rtx_equal_p (x11, operands[3])
          || !
#line 11779 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 658; /* *divmodsi4_zext_2 */

    case UMOD:
      if (pattern343 (x1, pnum_clobbers, 
UDIV) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[0] = x8;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      switch (pattern1604 (x9))
        {
        case 0:
          if (!
#line 11815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 659; /* *udivmodsi4_zext_2 */

        case 1:
          if (!
#line 11837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
            return -1;
          *pnum_clobbers = 1;
          return 660; /* *udivmodsi4_pow2_zext_2 */

        default:
          return -1;
        }

    case AND:
      if (pattern340 (x1) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
        case MEM:
          switch (pattern345 (x3))
            {
            case 0:
              if (!
#line 12640 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 709; /* *andqi_1_zexthi */

            case 1:
              if (!
#line 12640 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 711; /* *andqi_1_zextsi */

            case 2:
              if (!
#line 12654 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 715; /* *andhi_1_zextsi */

            case 3:
              if (!
#line 12640 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 713; /* *andqi_1_zextdi */

            case 4:
              if (!
#line 12654 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 717; /* *andhi_1_zextdi */

            case 5:
              if (!
#line 12670 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (AND, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 718; /* *andsi_1_zext */

            default:
              return -1;
            }

        case PLUS:
          if (pattern688 (x5) != 0
              || !register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_SImode)
            return -1;
          x12 = XEXP (x5, 0);
          x13 = XEXP (x12, 1);
          operands[2] = x13;
          if (!register_operand (operands[2], E_QImode))
            return -1;
          x6 = XEXP (x4, 1);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 22132 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return -1;
          return 1598; /* *bmi2_bzhi_zero_extendsidi_4 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern346 (x1))
        {
        case 0:
          if (!
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 844; /* *iorqi_1_zexthi */

        case 1:
          if (!
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 848; /* *iorqi_1_zextsi */

        case 2:
          if (!
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 856; /* *iorhi_1_zextsi */

        case 3:
          if (!
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 852; /* *iorqi_1_zextdi */

        case 4:
          if (!
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 860; /* *iorhi_1_zextdi */

        case 5:
          if (!
#line 13759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 863; /* *iorsi_1_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern346 (x1))
        {
        case 0:
          if (!
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 846; /* *xorqi_1_zexthi */

        case 1:
          if (!
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 850; /* *xorqi_1_zextsi */

        case 2:
          if (!
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 858; /* *xorhi_1_zextsi */

        case 3:
          if (!
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 854; /* *xorqi_1_zextdi */

        case 4:
          if (!
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 862; /* *xorhi_1_zextdi */

        case 5:
          if (!
#line 13759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 864; /* *xorsi_1_zext */

        default:
          return -1;
        }

    case NEG:
      if (pattern347 (x1) != 0)
        return -1;
      switch (pattern349 (x3))
        {
        case 0:
          if (!
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 963; /* *negqi_1_zexthi */

        case 1:
          if (!
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 965; /* *negqi_1_zextsi */

        case 2:
          if (!
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 969; /* *neghi_1_zextsi */

        case 3:
          if (!
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 967; /* *negqi_1_zextdi */

        case 4:
          if (!
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 971; /* *neghi_1_zextdi */

        case 5:
          if (!
#line 14395 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NEG, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 972; /* *negsi_1_zext */

        default:
          return -1;
        }

    case ASHIFT:
      switch (pattern351 (x1))
        {
        case 0:
          if (!
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1094; /* *ashlqi3_1_zexthi */

        case 1:
          if (!
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1096; /* *ashlqi3_1_zextsi */

        case 2:
          if (!
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1100; /* *ashlhi3_1_zextsi */

        case 3:
          if (!
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1098; /* *ashlqi3_1_zextdi */

        case 4:
          if (!
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1102; /* *ashlhi3_1_zextdi */

        case 5:
          if (!
#line 16045 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 1103; /* *ashlsi3_1_zext */

        default:
          return -1;
        }

    case ASHIFTRT:
      if (pattern341 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              if (const_int_operand (operands[2], E_QImode)
                  && 
#line 17280 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && INTVAL (operands[2]) == 31
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
                return 1170; /* *ashrsi3_cvt_zext */
              if (!nonmemory_operand (operands[2], E_QImode)
                  || !
#line 17492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1207; /* *ashrsi3_1_zext */

            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !nonmemory_operand (operands[2], E_QImode)
                  || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1197; /* *ashrqi3_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !nonmemory_operand (operands[2], E_QImode)
                  || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1205; /* *ashrhi3_1_zextdi */

            default:
              return -1;
            }

        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode
              || GET_MODE (x4) != E_QImode
              || !nonimmediate_operand (operands[1], E_QImode)
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1189; /* *ashrqi3_1_zexthi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1193; /* *ashrqi3_1_zextsi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1201; /* *ashrhi3_1_zextsi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case LSHIFTRT:
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x7))
        {
        case CLOBBER:
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != REG
              || REGNO (x8) != 17
              || GET_MODE (x8) != E_CCmode)
            return -1;
          switch (pattern350 (x3))
            {
            case 0:
              if (!
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1187; /* *lshrqi3_1_zexthi */

            case 1:
              if (!
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1191; /* *lshrqi3_1_zextsi */

            case 2:
              if (!
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1199; /* *lshrhi3_1_zextsi */

            case 3:
              if (!
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1195; /* *lshrqi3_1_zextdi */

            case 4:
              if (!
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1203; /* *lshrhi3_1_zextdi */

            case 5:
              if (!
#line 17492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (LSHIFTRT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1206; /* *lshrsi3_1_zext */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x7, 0) != 1
              || XINT (x7, 1) != 174)
            return -1;
          x15 = XVECEXP (x7, 0, 0);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || pattern1215 (x3, 
E_SImode, 
E_DImode) != 0
              || !const_0_to_31_operand (operands[2], E_VOIDmode)
              || !
#line 2310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
            return -1;
          return 2609; /* *klshrsi3_1_zext */

        default:
          return -1;
        }

    case ROTATE:
      switch (pattern351 (x1))
        {
        case 0:
          if (!
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1352; /* *rotlqi3_1_zexthi */

        case 1:
          if (!
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1356; /* *rotlqi3_1_zextsi */

        case 2:
          if (!
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1364; /* *rotlhi3_1_zextsi */

        case 3:
          if (!
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1360; /* *rotlqi3_1_zextdi */

        case 4:
          if (!
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1368; /* *rotlhi3_1_zextdi */

        case 5:
          if (!
#line 18625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)))
            return -1;
          return 1371; /* *rotlsi3_1_zext */

        default:
          return -1;
        }

    case ROTATERT:
      switch (pattern351 (x1))
        {
        case 0:
          if (!
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1354; /* *rotrqi3_1_zexthi */

        case 1:
          if (!
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1358; /* *rotrqi3_1_zextsi */

        case 2:
          if (!
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1366; /* *rotrhi3_1_zextsi */

        case 3:
          if (!
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1362; /* *rotrqi3_1_zextdi */

        case 4:
          if (!
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1370; /* *rotrhi3_1_zextdi */

        case 5:
          if (!
#line 18625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)))
            return -1;
          return 1372; /* *rotrsi3_1_zext */

        default:
          return -1;
        }

    case CTZ:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      switch (pattern925 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 21193 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1521; /* *ctzsidi2_uext */

        case 1:
          if (!
#line 21233 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1523; /* *ctzsidi2_uext_falsedep */

        default:
          return -1;
        }

    case CLZ:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      switch (pattern550 (x1, pnum_clobbers))
        {
        case 0:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 21628 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT))
            return -1;
          return 1543; /* *clzsi2_lzcnt_zext_2 */

        case 1:
          x7 = XVECEXP (x1, 0, 1);
          x15 = XVECEXP (x7, 0, 0);
          switch (pattern1409 (x15))
            {
            case 0:
              if (!
#line 21653 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
                return -1;
              *pnum_clobbers = 1;
              return 1544; /* *clzsi2_lzcnt_zext_2_falsedep */

            case 1:
              if (!(
#line 21653 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1545; /* *clzsi2_lzcnt_zext_2_falsedep */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case POPCOUNT:
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      switch (pattern550 (x1, pnum_clobbers))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern348 (x3, 
E_SImode, 
E_DImode) != 0
                  || !
#line 22465 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
                return -1;
              return 1634; /* *popcountsi2_zext_2 */

            case E_SImode:
              if (pattern348 (x3, 
E_HImode, 
E_SImode) != 0
                  || !
#line 22531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
                return -1;
              return 1637; /* *popcounthi2_2 */

            default:
              return -1;
            }

        case 1:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x7 = XVECEXP (x1, 0, 1);
          x15 = XVECEXP (x7, 0, 0);
          operands[2] = x15;
          if (!register_operand (operands[2], E_DImode)
              || !
#line 22496 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1635; /* *popcountsi2_zext_2_falsedep */

        default:
          return -1;
        }

    case NOT:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (pattern383 (x7, 
174, 
0) != 0)
        return -1;
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_SImode)
          || !
#line 2233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
        return -1;
      return 2596; /* *knotsi_1_zext */

    case UNSPEC:
      return recog_364 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_391 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != REG
              || REGNO (x7) != 17
              || GET_MODE (x7) != E_CCmode)
            return -1;
          operands[1] = x5;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || GET_MODE (x4) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !general_operand (operands[2], E_HImode)
                  || !(
#line 10616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
                return -1;
              return 591; /* *mulhi3_1 */

            case E_SImode:
              if (pattern1313 (x4, 
E_SImode) != 0
                  || !
#line 10616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              return 593; /* *mulsi3_1 */

            case E_DImode:
              if (pattern1313 (x4, 
E_DImode) != 0
                  || !(
#line 10616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 595; /* *muldi3_1 */

            case E_QImode:
              if (pattern212 (x4, 
E_QImode) != 0
                  || !
#line 10703 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              return 603; /* *mulqi3_1 */

            default:
              return -1;
            }

        case SET:
          x9 = XEXP (x6, 1);
          if (GET_CODE (x9) != UMUL_HIGHPART)
            return -1;
          switch (pattern585 (x1))
            {
            case 0:
              if (!(
#line 10967 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 615; /* *bmi2_umulsidi3_1 */

            case 1:
              if (!(
#line 10967 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 616; /* *bmi2_umulditi3_1 */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x6, 0) != 1
              || XINT (x6, 1) != 110)
            return -1;
          x10 = XVECEXP (x6, 0, 0);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_V2SFmode)
              || GET_MODE (x4) != E_V2SFmode)
            return -1;
          operands[1] = x5;
          if (!nonimmediate_operand (operands[1], E_V2SFmode))
            return -1;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          if (!nonimmediate_operand (operands[2], E_V2SFmode)
              || !
#line 795 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (MULT, V2SFmode, operands)))
            return -1;
          return 2054; /* *mmx_mulv2sf3 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern559 (x1, 
ZERO_EXTEND))
        {
        case 0:
          if (!(
#line 11006 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 617; /* *umulsidi3_1 */

        case 1:
          if (!(
#line 11006 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 618; /* *umulditi3_1 */

        case 2:
          if (!
#line 11072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          return 626; /* *umulqihi3_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern559 (x1, 
SIGN_EXTEND))
        {
        case 0:
          if (!(
#line 11052 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 620; /* *mulsidi3_1 */

        case 1:
          if (!(
#line 1199 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && (
#line 11052 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          return 622; /* *mulditi3_1 */

        case 2:
          if (!
#line 11072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          return 624; /* *mulqihi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_397 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern566 (x1))
        {
        case 0:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 727; /* *xorqi_1_slp */
          break;

        case 1:
          if (
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 730; /* *xorhi_1_slp */
          break;

        case 2:
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 820; /* *xordi3_doubleword */
          if (x86_64_general_operand (operands[2], E_DImode)
              && (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 834; /* *xordi_1 */
          if (const_int_operand (operands[2], E_DImode)
              && 
#line 13669 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (XOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)))
            return 839; /* *xordi_1_btc */
          break;

        case 3:
          if ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 822; /* *xorti3_doubleword */
          break;

        case 4:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)
   && true))
            return 826; /* *xorhi_1 */
          break;

        case 5:
          if (
#line 13599 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)
   && true))
            return 830; /* *xorsi_1 */
          break;

        case 6:
          if (
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V4QImode, operands)))
            return 2285; /* *xorv4qi3 */
          break;

        case 7:
          if (
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V2QImode, operands)))
            return 2288; /* *xorv2qi3 */
          break;

        case 8:
          if (
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V2HImode, operands)))
            return 2291; /* *xorv2hi3 */
          break;

        case 9:
          if (
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2574; /* kxorqi */
          break;

        case 10:
          if (
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2577; /* kxorhi */
          break;

        case 11:
          if ((
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2580; /* kxorsi */
          break;

        case 12:
          if ((
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2583; /* kxordi */
          break;

        default:
          break;
        }
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != CLOBBER
          || pattern567 (x1) != 0)
        return -1;
      if (GET_CODE (x4) == SUBREG
          && pattern555 (x4) == 0)
        {
          x6 = XEXP (x4, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (pattern1606 (x2))
            {
            case 0:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 733; /* *xorqi_exthi_1_slp */
              break;

            case 1:
              if (
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 736; /* *xorqi_extsi_1_slp */
              break;

            case 2:
              if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 739; /* *xorqi_extdi_1_slp */
              break;

            case 3:
              return 757; /* *xorqi_exthi_0 */

            case 4:
              return 760; /* *xorqi_extsi_0 */

            case 5:
              if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return 763; /* *xorqi_extdi_0 */
              break;

            default:
              break;
            }
          x8 = XEXP (x3, 1);
          if (GET_CODE (x8) == SUBREG)
            {
              switch (pattern1607 (x2))
                {
                case 0:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 742; /* *xorqi_exthi_2_slp */
                  break;

                case 1:
                  if (
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 745; /* *xorqi_extsi_2_slp */
                  break;

                case 2:
                  if ((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 748; /* *xorqi_extdi_2_slp */
                  break;

                case 3:
                  return 766; /* *xorqi_ext2hi_0 */

                case 4:
                  return 769; /* *xorqi_ext2si_0 */

                case 5:
                  if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 772; /* *xorqi_ext2di_0 */
                  break;

                default:
                  break;
                }
            }
        }
      x9 = XEXP (x2, 0);
      operands[0] = x9;
      if (!nonimmediate_operand (operands[0], E_QImode))
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_QImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      if (!general_operand (operands[2], E_QImode)
          || !
#line 13789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      return 870; /* *xorqi_1 */

    case AND:
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != XOR)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern353 (x5) != 0)
        return -1;
      switch (pattern1041 (x2))
        {
        case 0:
          if (!
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()))
            return -1;
          return 840; /* *xor2andn */

        case 1:
          if (!
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()))
            return -1;
          return 841; /* *xor2andn */

        case 2:
          if (!(
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 842; /* *xor2andn */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (pattern370 (x1) != 0
          || !
#line 13776 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
        return -1;
      return 866; /* *xorsi_1_zext_imm */

    case ASHIFT:
      switch (pattern373 (x1, 
1))
        {
        case 0:
          x10 = XEXP (x4, 1);
          operands[2] = x10;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern934 (x3))
                {
                case 0:
                  if (
#line 18837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    return 1392; /* *btcsi */
                  break;

                case 1:
                  if ((
#line 18837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1394; /* *btcdi */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x10) != SUBREG)
            return -1;
          switch (pattern1316 (x3))
            {
            case 0:
              if (!
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              return 1396; /* *btcsi_mask */

            case 1:
              if (!(
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1398; /* *btcdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          return 1400; /* *btcsi_mask_1 */

        case 2:
          if (!(
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1402; /* *btcdi_mask_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != MINUS
          || GET_MODE (x6) != E_SImode)
        return -1;
      x7 = XEXP (x6, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return -1;
      x11 = XEXP (x6, 1);
      if (GET_CODE (x11) != SUBREG
          || maybe_ne (SUBREG_BYTE (x11), 0)
          || GET_MODE (x11) != E_SImode)
        return -1;
      x12 = XEXP (x11, 0);
      if (GET_CODE (x12) != CLZ
          || GET_MODE (x12) != E_DImode)
        return -1;
      x8 = XEXP (x3, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern231 (x5, 
E_CCmode, 
17) != 0)
        return -1;
      x9 = XEXP (x2, 0);
      operands[0] = x9;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x13 = XEXP (x12, 0);
      operands[1] = x13;
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !
#line 21341 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()))
        return -1;
      return 1530; /* *bsr_rex64_2 */

    case PLUS:
      x10 = XEXP (x4, 1);
      if (GET_CODE (x10) != CONST_INT
          || pattern347 (x1) != 0)
        return -1;
      x8 = XEXP (x3, 1);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      switch (XWINT (x10, 0))
        {
        case -1L:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern203 (x3, 
E_SImode) != 0
                  || !
#line 21895 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1578; /* *bmi_blsmsk_si */

            case E_DImode:
              if (pattern203 (x3, 
E_DImode) != 0
                  || !(
#line 21895 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1579; /* *bmi_blsmsk_di */

            default:
              return -1;
            }

        case 1L:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern203 (x3, 
E_SImode) != 0
                  || !
#line 22241 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1612; /* *tbm_blcmsk_si */

            case E_DImode:
              if (pattern203 (x3, 
E_DImode) != 0
                  || !(
#line 22241 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1613; /* *tbm_blcmsk_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_406 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      switch (pattern698 (x1))
        {
        case 0:
          return 1514; /* ctzsi2 */

        case 1:
          if (!
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1515; /* ctzdi2 */

        default:
          return -1;
        }

    case UNSPEC:
      if (pnum_clobbers == NULL)
        return -1;
      switch (pattern699 (x1))
        {
        case 0:
          *pnum_clobbers = 1;
          return 1516; /* *ctzsi2_falsedep */

        case 1:
          if (!
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1517; /* *ctzdi2_falsedep */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_410 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  switch (XVECLEN (x4, 0))
    {
    case 1:
      switch (XINT (x4, 1))
        {
        case 2:
          x5 = XVECEXP (x1, 0, 1);
          if (pattern231 (x5, 
E_CCmode, 
17) != 0)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x4) != E_SImode
                  || !register_operand (operands[1], E_SImode)
                  || !(
#line 27234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1859; /* allocate_stack_worker_probe_si */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x4) != E_DImode
                  || !register_operand (operands[1], E_DImode)
                  || !(
#line 27234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1860; /* allocate_stack_worker_probe_di */

            default:
              return -1;
            }

        case 11:
          if (pattern700 (x1, 
11) != 0
              || !
#line 29118 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1896; /* rdpmc_rex64 */

        case 9:
          if (pattern701 (x1, 
E_DImode, 
9) != 0
              || !
#line 29136 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1898; /* rdtsc_rex64 */

        case 10:
          if (pattern701 (x1, 
E_SImode, 
10) != 0
              || !
#line 29146 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1899; /* rdtscp */

        case 36:
          if (pattern700 (x1, 
36) != 0
              || !
#line 29360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1926; /* xgetbv_rex64 */

        case 44:
          switch (pattern702 (x1, 
44))
            {
            case 0:
              if (!
#line 29521 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDRND))
                return -1;
              return 1949; /* rdrandhi */

            case 1:
              if (!
#line 29521 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDRND))
                return -1;
              return 1950; /* rdrandsi */

            case 2:
              if (!(
#line 29521 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDRND) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1951; /* rdranddi */

            default:
              return -1;
            }

        case 45:
          switch (pattern702 (x1, 
45))
            {
            case 0:
              if (!
#line 29531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDSEED))
                return -1;
              return 1952; /* rdseedhi */

            case 1:
              if (!
#line 29531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDSEED))
                return -1;
              return 1953; /* rdseedsi */

            case 2:
              if (!(
#line 29531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDSEED) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1954; /* rdseeddi */

            default:
              return -1;
            }

        case 56:
          if (GET_MODE (x4) != E_SImode)
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != SET)
            return -1;
          x7 = XEXP (x5, 1);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_SImode))
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[2] = x6;
          if (!register_operand (operands[2], E_SImode))
            return -1;
          x8 = XEXP (x5, 0);
          operands[1] = x8;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 29774 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_PKU))
            return -1;
          return 1980; /* *rdpkru */

        default:
          return -1;
        }

    case 2:
      switch (XINT (x4, 1))
        {
        case 3:
          x5 = XVECEXP (x1, 0, 1);
          if (pattern231 (x5, 
E_CCmode, 
17) != 0)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          x9 = XVECEXP (x4, 0, 1);
          operands[2] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1423 (x4, 
E_SImode) != 0
                  || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))
                return -1;
              return 1865; /* probe_stack_range_si */

            case E_DImode:
              if (pattern1423 (x4, 
E_DImode) != 0
                  || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))
                return -1;
              return 1866; /* probe_stack_range_di */

            default:
              return -1;
            }

        case 99:
          if (pattern703 (x1, 
99) != 0
              || !
#line 31367 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10289; /* aesdec128klu8 */

        case 101:
          if (pattern703 (x1, 
101) != 0
              || !
#line 31367 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10290; /* aesdec256klu8 */

        case 100:
          if (pattern703 (x1, 
100) != 0
              || !
#line 31367 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10291; /* aesenc128klu8 */

        case 102:
          if (pattern703 (x1, 
102) != 0
              || !
#line 31367 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10292; /* aesenc256klu8 */

        case 110:
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != SET)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          x9 = XVECEXP (x4, 0, 1);
          operands[3] = x9;
          if (!const_int_operand (operands[3], E_SImode))
            return -1;
          x8 = XEXP (x5, 0);
          if (!rtx_equal_p (x8, operands[1]))
            return -1;
          x7 = XEXP (x5, 1);
          switch (GET_CODE (x7))
            {
            case PLUS:
              if (pnum_clobbers == NULL)
                return -1;
              x10 = XEXP (x7, 1);
              operands[2] = x10;
              x11 = XEXP (x7, 0);
              if (!rtx_equal_p (x11, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1551 (x1, 
E_QImode) != 0
                      || !
#line 703 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10922; /* atomic_fetch_addqi */

                case E_HImode:
                  if (pattern1551 (x1, 
E_HImode) != 0
                      || !
#line 703 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10923; /* atomic_fetch_addhi */

                case E_SImode:
                  if (pattern1551 (x1, 
E_SImode) != 0
                      || !
#line 703 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10924; /* atomic_fetch_addsi */

                case E_DImode:
                  if (pattern1551 (x1, 
E_DImode) != 0
                      || !(
#line 703 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10925; /* atomic_fetch_adddi */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              operands[2] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1481 (x4, 
E_QImode) != 0)
                    return -1;
                  return 10930; /* atomic_exchangeqi */

                case E_HImode:
                  if (pattern1481 (x4, 
E_HImode) != 0)
                    return -1;
                  return 10931; /* atomic_exchangehi */

                case E_SImode:
                  if (pattern1481 (x4, 
E_SImode) != 0)
                    return -1;
                  return 10932; /* atomic_exchangesi */

                case E_DImode:
                  if (pattern1481 (x4, 
E_DImode) != 0
                      || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10933; /* atomic_exchangedi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 111:
          x5 = XVECEXP (x1, 0, 1);
          if (pattern231 (x5, 
E_CCmode, 
17) != 0)
            return -1;
          x9 = XVECEXP (x4, 0, 1);
          operands[2] = x9;
          if (!const_int_operand (operands[2], E_SImode))
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          switch (GET_CODE (x6))
            {
            case PLUS:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10942; /* atomic_addqi */

                case 1:
                  return 10943; /* atomic_addhi */

                case 2:
                  return 10944; /* atomic_addsi */

                case 3:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10945; /* atomic_adddi */

                default:
                  return -1;
                }

            case MINUS:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10946; /* atomic_subqi */

                case 1:
                  return 10947; /* atomic_subhi */

                case 2:
                  return 10948; /* atomic_subsi */

                case 3:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10949; /* atomic_subdi */

                default:
                  return -1;
                }

            case AND:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10950; /* atomic_andqi */

                case 1:
                  return 10953; /* atomic_andhi */

                case 2:
                  return 10956; /* atomic_andsi */

                case 3:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10959; /* atomic_anddi */

                default:
                  return -1;
                }

            case IOR:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10951; /* atomic_orqi */

                case 1:
                  return 10954; /* atomic_orhi */

                case 2:
                  return 10957; /* atomic_orsi */

                case 3:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10960; /* atomic_ordi */

                default:
                  return -1;
                }

            case XOR:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10952; /* atomic_xorqi */

                case 1:
                  return 10955; /* atomic_xorhi */

                case 2:
                  return 10958; /* atomic_xorsi */

                case 3:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10961; /* atomic_xordi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_429 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != RETURN)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != USE)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 38
      || pattern718 (x4, 
E_DImode, 
7) != 0)
    return -1;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[1]))
    {
    case E_SImode:
      if (!symbol_operand (operands[1], E_SImode)
          || !(
#line 30313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return -1;
      return 10075; /* *restore_multiple_and_returnsi */

    case E_DImode:
      if (!symbol_operand (operands[1], E_DImode)
          || !(
#line 30313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 10076; /* *restore_multiple_and_returndi */

    default:
      return -1;
    }
}

 int
recog_431 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (XVECLEN (x1, 0))
    {
    case 1:
      switch (XINT (x1, 1))
        {
        case 1:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1486; /* blockage */

        case 5:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 1488; /* prologue_use */

        case 8:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!const_int_operand (operands[0], E_VOIDmode)
              || !
#line 20728 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            return -1;
          return 1496; /* nops */

        case 6:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!const_int_operand (operands[0], E_SImode))
            return -1;
          return 1506; /* split_stack_return */

        case 7:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1760; /* cld */

        case 0:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1886; /* ud2 */

        case 21:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 29193 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_FXSR))
            return -1;
          return 1903; /* fxrstor */

        case 23:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 29203 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FXSR))
            return -1;
          return 1904; /* fxrstor64 */

        case 41:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 29401 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          *pnum_clobbers = 8;
          return 1928; /* fldenv */

        case 43:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29420 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 1930; /* fnclex */

        case 12:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !(
#line 29435 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1931; /* lwp_llwpcbsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29435 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1932; /* lwp_llwpcbdi */

            default:
              return -1;
            }

        case 18:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29501 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1943; /* wrfsbasesi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29501 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1945; /* wrfsbasedi */

            default:
              return -1;
            }

        case 19:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29501 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1944; /* wrgsbasesi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29501 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1946; /* wrgsbasedi */

            default:
              return -1;
            }

        case 78:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || !
#line 29510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_PTWRITE))
                return -1;
              return 1947; /* ptwritesi */

            case E_DImode:
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !(
#line 29510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_PTWRITE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1948; /* ptwritedi */

            default:
              return -1;
            }

        case 60:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29568 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)))
                return -1;
              return 1958; /* incsspsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29568 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1959; /* incsspdi */

            default:
              return -1;
            }

        case 61:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29575 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1960; /* saveprevssp */

        case 62:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_DImode)
              || !
#line 29583 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1961; /* rstorssp */

        case 65:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29608 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1966; /* setssbsy */

        case 66:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_DImode)
              || !
#line 29616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1967; /* clrssbsy */

        case 58:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29623 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((flag_cf_protection & CF_BRANCH)))
            return -1;
          return 1968; /* nop_endbr */

        case 47:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29669 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RTM))
            return -1;
          return 1970; /* xend */

        case 48:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!const_0_to_255_operand (operands[0], E_SImode)
              || !
#line 29677 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_RTM))
            return -1;
          return 1971; /* xabort */

        case 51:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 29705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLWB))
            return -1;
          return 1973; /* clwb */

        case 52:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 29714 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLFLUSHOPT))
            return -1;
          return 1974; /* clflushopt */

        case 55:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !(
#line 29750 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLZERO) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1978; /* clzero_si */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29750 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLZERO) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1979; /* clzero_di */

            default:
              return -1;
            }

        case 38:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1984; /* wbinvd */

        case 39:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_WBNOINVD))
            return -1;
          return 1985; /* wbnoinvd */

        case 67:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29849 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TSXLDTRK))
            return -1;
          return 1990; /* xsusldtrk */

        case 68:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29849 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TSXLDTRK))
            return -1;
          return 1991; /* xresldtrk */

        case 72:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29874 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_UINTR && TARGET_64BIT))
            return -1;
          return 1996; /* clui */

        case 73:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29874 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_UINTR && TARGET_64BIT))
            return -1;
          return 1997; /* stui */

        case 75:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!register_operand (operands[0], E_DImode)
              || !
#line 29891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_UINTR && TARGET_64BIT))
            return -1;
          return 1999; /* senduipi */

        case 70:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !(
#line 29920 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_WAITPKG) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 2002; /* umonitor_si */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29920 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_WAITPKG) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 2003; /* umonitor_di */

            default:
              return -1;
            }

        case 76:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 29947 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLDEMOTE))
            return -1;
          return 2006; /* cldemote */

        case 77:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 2007; /* speculation_barrier */

        case 81:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29961 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SERIALIZE))
            return -1;
          return 2008; /* serialize */

        case 83:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!register_operand (operands[0], E_SImode)
              || !
#line 29983 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HRESET))
            return -1;
          return 2010; /* hreset */

        case 87:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 30101 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AMX_TILE))
            return -1;
          return 2013; /* ldtilecfg */

        case 90:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 6868 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX))
            return -1;
          *pnum_clobbers = 16;
          return 2387; /* *mmx_emms */

        case 91:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 6869 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
            return -1;
          *pnum_clobbers = 16;
          return 2388; /* *mmx_femms */

        case 92:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_SImode)
              || !
#line 22486 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 8508; /* sse_ldmxcsr */

        case 94:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 22510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 8510; /* sse2_clflush */

        default:
          return -1;
        }

    case 2:
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      x3 = XVECEXP (x1, 0, 1);
      operands[1] = x3;
      switch (XINT (x1, 1))
        {
        case 4:
          return 1497; /* max_skip_align */

        case 84:
          if (!local_func_symbolic_operand (operands[0], E_VOIDmode)
              || !const_int_operand (operands[1], E_SImode)
              || !
#line 29040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_PREFETCHI && TARGET_64BIT))
            return -1;
          return 1889; /* prefetchi */

        case 25:
          if (GET_MODE (x1) != E_BLKmode
              || !memory_operand (operands[0], E_BLKmode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 29292 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1917; /* xrstor */

        case 31:
          if (GET_MODE (x1) != E_BLKmode
              || !memory_operand (operands[0], E_BLKmode)
              || !register_operand (operands[1], E_DImode)
              || !(
#line 29292 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE) && 
#line 29235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_XSAVES)))
            return -1;
          return 1918; /* xrstors */

        case 37:
          if (GET_MODE (x1) != E_SImode
              || !register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 29332 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1923; /* xsetbv */

        case 63:
          switch (pattern397 ())
            {
            case 0:
              if (!
#line 29592 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
                return -1;
              return 1962; /* wrsssi */

            case 1:
              if (!(
#line 29592 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1963; /* wrssdi */

            default:
              return -1;
            }

        case 64:
          switch (pattern397 ())
            {
            case 0:
              if (!
#line 29601 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
                return -1;
              return 1964; /* wrusssi */

            case 1:
              if (!(
#line 29601 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1965; /* wrussdi */

            default:
              return -1;
            }

        case 82:
          if (!const_int_operand (operands[0], E_VOIDmode)
              || !const_int_operand (operands[1], E_VOIDmode))
            return -1;
          return 2009; /* patchable_area */

        case 86:
          if (!x86_64_szext_nonmemory_operand (operands[0], E_DImode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 30093 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USER_MSR && TARGET_64BIT))
            return -1;
          return 2012; /* uwrmsr */

        case 96:
          if (!register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_SImode)
              || !
#line 22523 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_MWAIT))
            return -1;
          return 8511; /* sse3_mwait */

        default:
          return -1;
        }

    case 3:
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      x3 = XVECEXP (x1, 0, 1);
      operands[1] = x3;
      x4 = XVECEXP (x1, 0, 2);
      operands[2] = x4;
      switch (XINT (x1, 1))
        {
        case 25:
          if (pattern570 (x1) != 0
              || !
#line 29305 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1919; /* xrstor_rex64 */

        case 31:
          if (pattern570 (x1) != 0
              || !(
#line 29305 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE) && 
#line 29235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_XSAVES)))
            return -1;
          return 1920; /* xrstors_rex64 */

        case 27:
          if (pattern570 (x1) != 0
              || !
#line 29319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1921; /* xrstor64 */

        case 33:
          if (pattern570 (x1) != 0
              || !(
#line 29319 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE) && 
#line 29239 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_XSAVES)))
            return -1;
          return 1922; /* xrstors64 */

        case 37:
          if (pattern571 (x1) != 0
              || !
#line 29342 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1924; /* xsetbv_rex64 */

        case 14:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !const_int_operand (operands[2], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29455 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP))
                return -1;
              return 1935; /* lwp_lwpvalsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29455 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1936; /* lwp_lwpvaldi */

            default:
              return -1;
            }

        case 54:
          if (!register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_SImode)
              || !register_operand (operands[2], E_SImode)
              || !
#line 29726 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MWAITX))
            return -1;
          return 1975; /* mwaitx */

        case 53:
          switch (pattern572 ())
            {
            case 0:
              if (!(
#line 29738 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MWAITX) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1976; /* monitorx_si */

            case 1:
              if (!(
#line 29738 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MWAITX) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1977; /* monitorx_di */

            default:
              return -1;
            }

        case 56:
          if (pattern571 (x1) != 0
              || !
#line 29793 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_PKU))
            return -1;
          return 1981; /* *wrpkru */

        case 95:
          switch (pattern572 ())
            {
            case 0:
              if (!(
#line 22535 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_MWAIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 8512; /* sse3_monitor_si */

            case 1:
              if (!(
#line 22535 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_MWAIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 8513; /* sse3_monitor_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4:
      if (pnum_clobbers == NULL
          || XINT (x1, 1) != 98
          || GET_MODE (x1) != E_V2DImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x3 = XVECEXP (x1, 0, 1);
      operands[1] = x3;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x4 = XVECEXP (x1, 0, 2);
      operands[2] = x4;
      if (!register_operand (operands[2], E_V2DImode))
        return -1;
      x5 = XVECEXP (x1, 0, 3);
      operands[3] = x5;
      if (!register_operand (operands[3], E_SImode)
          || !
#line 31233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
        return -1;
      *pnum_clobbers = 1;
      return 10286; /* loadiwkey */

    default:
      return -1;
    }
}

 rtx_insn *
split_14 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return NULL;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return NULL;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x8 = XEXP (x4, 0);
      operands[0] = x8;
      switch (pattern1472 (x5))
        {
        case 0:
          return gen_split_26 (insn, operands);

        case 1:
          if (!
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return NULL;
          return gen_split_27 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTRACT:
      x8 = XEXP (x4, 0);
      if (GET_CODE (x8) == SUBREG)
        {
          switch (pattern1304 (x4))
            {
            case 0:
              if ((
#line 19356 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 19358 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_842 (insn, operands);
              break;

            case 1:
              if (((
#line 19356 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19358 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_843 (insn, operands);
              break;

            default:
              break;
            }
        }
      x7 = XEXP (x5, 2);
      if (GET_CODE (x7) != SUBREG)
        return NULL;
      switch (pattern1306 (x4))
        {
        case 0:
          if (!(
#line 19437 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19442 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_850 (insn, operands);

        case 1:
          if (!((
#line 19437 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19442 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_851 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_19 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      operands[0] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          x4 = XEXP (x2, 1);
          if (GET_MODE (x4) != E_DImode)
            return NULL;
          if (register_operand (operands[0], E_DImode))
            {
              if (nonmemory_operand (operands[1], E_DImode)
                  && nonmemory_operand (operands[2], E_QImode)
                  && (
#line 15337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(epilogue_completed) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return gen_split_562 (insn, operands);
              if (nonimmediate_operand (operands[1], E_DImode)
                  && register_operand (operands[2], E_QImode)
                  && (
#line 16002 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_579 (insn, operands);
            }
          if (!general_reg_operand (operands[0], E_DImode)
              || !index_reg_operand (operands[1], E_DImode)
              || !const_0_to_3_operand (operands[2], E_VOIDmode)
              || !(
#line 16297 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && REGNO (operands[0]) != REGNO (operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_586 (insn, operands);

        case E_TImode:
          if (!register_operand (operands[0], E_TImode))
            return NULL;
          x4 = XEXP (x2, 1);
          if (GET_MODE (x4) != E_TImode
              || !nonmemory_operand (operands[1], E_TImode)
              || !nonmemory_operand (operands[2], E_QImode)
              || !(
#line 15337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(epilogue_completed) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_563 (insn, operands);

        default:
          return NULL;
        }

    case STRICT_LOW_PART:
      switch (pattern1234 (x2))
        {
        case 0:
          if (!(
#line 16247 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 16266 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_581 (insn, operands);

        case 1:
          if (!(
#line 16247 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 16266 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_582 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_23 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      if (pattern578 (x1, 
PLUS, 
E_CCCmode) != 0
          || GET_MODE (x3) != E_CCCmode)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[0] = x8;
      x9 = XEXP (x3, 1);
      if (!rtx_equal_p (x9, operands[1]))
        return NULL;
      x10 = XEXP (x7, 1);
      x11 = XEXP (x10, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return NULL;
      x12 = XEXP (x10, 1);
      if (!rtx_equal_p (x12, operands[2]))
        return NULL;
      switch (GET_MODE (x4))
        {
        case E_DImode:
          if (pattern1646 (x10, 
E_DImode) != 0
              || !((
#line 10093 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 10095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_206 (insn, operands);

        case E_TImode:
          if (pattern1646 (x10, 
E_TImode) != 0
              || !((
#line 10093 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10095 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_207 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      x9 = XEXP (x3, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SUBREG:
          switch (pattern810 (x1))
            {
            case 0:
              if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
                return NULL;
              return gen_split_346 (insn, operands);

            case 1:
              if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
                return NULL;
              return gen_split_349 (insn, operands);

            case 2:
              if (!((
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
                return NULL;
              return gen_split_352 (insn, operands);

            default:
              return NULL;
            }

        case NOT:
          if (GET_MODE (x5) != E_SImode)
            return NULL;
          x7 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x7) != CLOBBER)
            return NULL;
          x13 = XEXP (x2, 0);
          operands[0] = x13;
          if (!flags_reg_operand (operands[0], E_VOIDmode))
            return NULL;
          operands[1] = x3;
          if (!compare_operator (operands[1], E_VOIDmode)
              || GET_MODE (x4) != E_SImode)
            return NULL;
          x14 = XEXP (x5, 0);
          operands[2] = x14;
          if (!general_reg_operand (operands[2], E_SImode))
            return NULL;
          x6 = XEXP (x4, 1);
          operands[3] = x6;
          if (!nonimmediate_operand (operands[3], E_SImode))
            return NULL;
          x8 = XEXP (x7, 0);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 13430 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && optimize_insn_for_size_p () && optimize_size > 1
   && LEGACY_INT_REG_P (operands[2])
   && !REX_INT_REG_P (operands[3])
   && !reg_overlap_mentioned_p (operands[2], operands[3])))
            return NULL;
          return gen_split_384 (insn, operands);

        case NEG:
          x7 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x7) != SET)
            return NULL;
          x10 = XEXP (x7, 1);
          if (GET_CODE (x10) != AND)
            return NULL;
          x11 = XEXP (x10, 0);
          if (GET_CODE (x11) != NEG)
            return NULL;
          x13 = XEXP (x2, 0);
          operands[3] = x13;
          if (!flags_reg_operand (operands[3], E_VOIDmode))
            return NULL;
          operands[4] = x3;
          if (!compare_operator (operands[4], E_VOIDmode))
            return NULL;
          switch (pattern1488 (x1))
            {
            case 0:
              if (!
#line 21837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI
   && TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
                return NULL;
              return gen_split_906 (insn, operands);

            case 1:
              if (!(
#line 21837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI
   && TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_907 (insn, operands);

            default:
              return NULL;
            }

        case PLUS:
          x15 = XEXP (x5, 1);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + -1]
              || pattern676 (x1, 
SET, 
E_CCZmode) != 0)
            return NULL;
          x7 = XVECEXP (x1, 0, 1);
          x10 = XEXP (x7, 1);
          if (GET_CODE (x10) != AND)
            return NULL;
          x11 = XEXP (x10, 0);
          if (GET_CODE (x11) != PLUS)
            return NULL;
          x16 = XEXP (x11, 1);
          if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + -1]
              || GET_MODE (x3) != E_CCZmode)
            return NULL;
          switch (pattern1488 (x1))
            {
            case 0:
              if (!(
#line 21974 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 21976 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                return NULL;
              return gen_split_912 (insn, operands);

            case 1:
              if (!((
#line 21974 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21976 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
                return NULL;
              return gen_split_913 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      switch (pattern581 (x1, 
IOR))
        {
        case 0:
          if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_347 (insn, operands);

        case 1:
          if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_350 (insn, operands);

        case 2:
          if (!((
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_353 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern581 (x1, 
XOR))
        {
        case 0:
          if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_348 (insn, operands);

        case 1:
          if (!(
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_351 (insn, operands);

        case 2:
          if (!((
#line 13151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13155 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_354 (insn, operands);

        default:
          return NULL;
        }

    case NOT:
      x9 = XEXP (x3, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != SET)
        return NULL;
      x13 = XEXP (x2, 0);
      operands[0] = x13;
      if (!flags_reg_operand (operands[0], E_VOIDmode))
        return NULL;
      operands[2] = x3;
      if (!compare_operator (operands[2], E_VOIDmode))
        return NULL;
      x5 = XEXP (x4, 0);
      operands[3] = x5;
      x8 = XEXP (x7, 0);
      operands[1] = x8;
      x10 = XEXP (x7, 1);
      switch (GET_CODE (x10))
        {
        case NOT:
          x11 = XEXP (x10, 0);
          if (!rtx_equal_p (x11, operands[3]))
            return NULL;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[3], E_QImode)
                  || !nonimmediate_operand (operands[1], E_QImode)
                  || GET_MODE (x10) != E_QImode
                  || !
#line 15106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
                return NULL;
              return gen_split_550 (insn, operands);

            case E_HImode:
              if (!nonimmediate_operand (operands[3], E_HImode)
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || GET_MODE (x10) != E_HImode
                  || !
#line 15106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
                return NULL;
              return gen_split_551 (insn, operands);

            case E_SImode:
              if (!nonimmediate_operand (operands[3], E_SImode)
                  || !nonimmediate_operand (operands[1], E_SImode)
                  || GET_MODE (x10) != E_SImode
                  || !
#line 15106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
                return NULL;
              return gen_split_552 (insn, operands);

            case E_DImode:
              if (!nonimmediate_operand (operands[3], E_DImode)
                  || !nonimmediate_operand (operands[1], E_DImode)
                  || GET_MODE (x10) != E_DImode
                  || !(
#line 15106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_553 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          if (pattern1219 (x1, 
NOT) != 0
              || !nonimmediate_operand (operands[3], E_SImode)
              || !register_operand (operands[1], E_DImode))
            return NULL;
          x11 = XEXP (x10, 0);
          x17 = XEXP (x11, 0);
          if (!rtx_equal_p (x17, operands[3])
              || !
#line 15133 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
            return NULL;
          return gen_split_554 (insn, operands);

        default:
          return NULL;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x9 = XEXP (x3, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || pattern578 (x1, 
CTZ, 
E_CCCmode) != 0
          || GET_MODE (x3) != E_CCCmode)
        return NULL;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[0] = x8;
      x10 = XEXP (x7, 1);
      x11 = XEXP (x10, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return NULL;
      switch (pattern1475 (x10))
        {
        case 0:
          if (!(
#line 21026 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 21028 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_877 (insn, operands);

        case 1:
          if (!((
#line 21026 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21028 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_878 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_28 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  switch (pattern202 (x3))
    {
    case 0:
      x4 = XEXP (x3, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 1);
      x6 = XEXP (x5, 1);
      if (GET_CODE (x6) == SUBREG)
        {
          switch (pattern1320 (x5))
            {
            case 0:
              if (((
#line 16596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 16601 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_595 (insn, operands);
              break;

            case 1:
              if (((
#line 16596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 16601 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_597 (insn, operands);
              break;

            default:
              break;
            }
        }
      if (GET_MODE (x5) == E_SImode
          && nonimmediate_operand (operands[1], E_SImode))
        {
          if (register_operand (operands[0], E_SImode))
            {
              operands[2] = x6;
              if (register_operand (operands[2], E_QImode)
                  && 
#line 17449 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed))
                return gen_split_628 (insn, operands);
            }
          if (GET_CODE (x6) == SUBREG)
            {
              switch (pattern1489 (x6))
                {
                case 0:
                  if ((
#line 17854 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 17859 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_645 (insn, operands);
                  break;

                case 1:
                  if ((
#line 17902 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17906 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_657 (insn, operands);
                  break;

                case 2:
                  if ((
#line 17948 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17952 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return gen_split_669 (insn, operands);
                  break;

                default:
                  break;
                }
            }
        }
      operands[2] = x6;
      switch (pattern1235 (x3))
        {
        case 0:
          if (register_operand (operands[1], E_DImode)
              && nonmemory_operand (operands[2], E_QImode)
              && (
#line 16708 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(epilogue_completed) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return gen_split_603 (insn, operands);
          if (nonimmediate_operand (operands[1], E_DImode)
              && register_operand (operands[2], E_QImode)
              && (
#line 17449 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_630 (insn, operands);
          break;

        case 1:
          if ((
#line 16708 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(epilogue_completed) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_605 (insn, operands);
          break;

        case 2:
          if ((
#line 17652 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 17663 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return gen_split_634 (insn, operands);
          break;

        case 3:
          if ((
#line 17652 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 17663 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return gen_split_636 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_MODE (x5) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return NULL;
      switch (GET_CODE (x6))
        {
        case CONST_INT:
          if (pattern1150 (x3) != 0
              || !(
#line 17375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 17377 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_623 (insn, operands);

        case SUBREG:
          if (maybe_ne (SUBREG_BYTE (x6), 0)
              || GET_MODE (x6) != E_QImode)
            return NULL;
          operands[0] = x4;
          if (!nonimmediate_operand (operands[0], E_DImode))
            return NULL;
          x7 = XEXP (x6, 0);
          switch (pattern1151 (x7))
            {
            case 0:
              if (!((
#line 17854 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17859 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_648 (insn, operands);

            case 1:
              if (!((
#line 17902 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17906 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_660 (insn, operands);

            case 2:
              if (!((
#line 17948 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17952 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_672 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case 1:
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[1], E_DImode)
          && ((
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 16662 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return gen_split_599 (insn, operands);
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !nonimmediate_operand (operands[1], E_DImode)
          || !((
#line 17879 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_654 (insn, operands);

    case 2:
      if (!((
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 16662 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_601 (insn, operands);

    case 3:
      if (!(
#line 17879 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 17884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_651 (insn, operands);

    case 4:
      if (!(
#line 17926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_663 (insn, operands);

    case 5:
      if (!((
#line 17926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17930 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_666 (insn, operands);

    case 6:
      if (!(
#line 17978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17982 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_675 (insn, operands);

    case 7:
      if (!((
#line 17978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17982 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_678 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_39 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case LEU:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!int_nonimmediate_operand (operands[1], E_VOIDmode))
        return NULL;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      if (!const_int_operand (operands[2], E_VOIDmode))
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || GET_MODE (x4) != E_SImode
              || !
#line 26320 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(x86_64_immediate_operand (operands[2], VOIDmode)
   && INTVAL (operands[2]) != -1
   && INTVAL (operands[2]) != 2147483647))
            return NULL;
          return gen_split_943 (insn, operands);

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_DImode
              || !(
#line 26320 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(x86_64_immediate_operand (operands[2], VOIDmode)
   && INTVAL (operands[2]) != -1
   && INTVAL (operands[2]) != 2147483647) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_944 (insn, operands);

        default:
          return NULL;
        }

    case EQ:
      switch (pattern409 (x3))
        {
        case 0:
          return gen_split_945 (insn, operands);

        case 1:
          return gen_split_946 (insn, operands);

        case 2:
          return gen_split_947 (insn, operands);

        case 3:
          if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return NULL;
          return gen_split_948 (insn, operands);

        default:
          return NULL;
        }

    case NE:
      switch (pattern409 (x3))
        {
        case 0:
          return gen_split_949 (insn, operands);

        case 1:
          return gen_split_950 (insn, operands);

        case 2:
          return gen_split_951 (insn, operands);

        case 3:
          if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return NULL;
          return gen_split_952 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_41 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      operands[1] = x3;
      res = split_40 (x1, insn);
      if (res != NULL_RTX)
        return res;
      if (!bt_comparison_operator (x3, E_VOIDmode))
        return NULL;
      operands[3] = x3;
      x4 = XEXP (x3, 0);
      if (pattern83 (x4, 
E_CCZmode, 
130, 
2) != 0)
        return NULL;
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != AND)
        return NULL;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != NOT)
        return NULL;
      x7 = XVECEXP (x4, 0, 1);
      if (GET_CODE (x7) != AND)
        return NULL;
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != NOT)
        return NULL;
      x9 = XEXP (x3, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x10 = XEXP (x2, 2);
      if (GET_CODE (x10) != PC)
        return NULL;
      x11 = XEXP (x1, 0);
      if (GET_CODE (x11) != PC)
        return NULL;
      x12 = XEXP (x6, 0);
      operands[1] = x12;
      x13 = XEXP (x5, 1);
      operands[2] = x13;
      x14 = XEXP (x2, 1);
      operands[0] = x14;
      x15 = XEXP (x8, 0);
      if (!rtx_equal_p (x15, operands[1]))
        return NULL;
      x16 = XEXP (x7, 1);
      if (!rtx_equal_p (x16, operands[2]))
        return NULL;
      switch (GET_MODE (x5))
        {
        case E_V16QImode:
          if (pattern1744 (x4, 
E_V16QImode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3683 (insn, operands);

        case E_V8HImode:
          if (pattern1744 (x4, 
E_V8HImode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3684 (insn, operands);

        case E_V4SImode:
          if (pattern1744 (x4, 
E_V4SImode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3685 (insn, operands);

        case E_V2DImode:
          if (pattern1744 (x4, 
E_V2DImode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3686 (insn, operands);

        case E_V1TImode:
          if (pattern1744 (x4, 
E_V1TImode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3687 (insn, operands);

        case E_V4SFmode:
          if (pattern1744 (x4, 
E_V4SFmode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3688 (insn, operands);

        case E_V2DFmode:
          if (pattern1744 (x4, 
E_V2DFmode) != 0
              || !
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return NULL;
          return gen_split_3689 (insn, operands);

        case E_V32QImode:
          if (pattern1744 (x4, 
E_V32QImode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3690 (insn, operands);

        case E_V16HImode:
          if (pattern1744 (x4, 
E_V16HImode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3691 (insn, operands);

        case E_V8SImode:
          if (pattern1744 (x4, 
E_V8SImode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3692 (insn, operands);

        case E_V4DImode:
          if (pattern1744 (x4, 
E_V4DImode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3693 (insn, operands);

        case E_V2TImode:
          if (pattern1744 (x4, 
E_V2TImode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3694 (insn, operands);

        case E_V8SFmode:
          if (pattern1744 (x4, 
E_V8SFmode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 607 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3695 (insn, operands);

        case E_V4DFmode:
          if (pattern1744 (x4, 
E_V4DFmode) != 0
              || !(
#line 25441 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 607 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_3696 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_47 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return NULL;
  switch (pattern91 (x1))
    {
    case 0:
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2SFmode)
          || pattern962 (x2) != 0
          || !register_operand (operands[0], E_SFmode)
          || GET_MODE (x2) != E_SFmode
          || GET_MODE (x3) != E_SFmode)
        return NULL;
      x5 = XEXP (x2, 1);
      if (GET_MODE (x5) != E_SFmode)
        return NULL;
      x6 = XEXP (x5, 0);
      if (!rtx_equal_p (x6, operands[1])
          || !(
#line 1058 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE3 && TARGET_MMX_WITH_SSE && ix86_partial_vec_fp_math
   && ix86_pre_reload_split ()) && 
#line 1061 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( 1)))
        return NULL;
      return gen_split_1035 (insn, operands);

    case 1:
      switch (pattern847 (x2))
        {
        case 0:
          if (!
#line 22623 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
            return NULL;
          return gen_split_3474 (insn, operands);

        case 1:
          if (!
#line 22710 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
            return NULL;
          return gen_split_3477 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_48 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != CONST_INT)
    return NULL;
  x5 = XEXP (x2, 0);
  operands[1] = x5;
  switch (XWINT (x4, 0))
    {
    case 0L:
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          switch (pattern963 (x2))
            {
            case 0:
              if ((
#line 1783 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1786 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return gen_split_1038 (insn, operands);
              break;

            case 1:
              if ((
#line 12309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 12311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1562 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case E_SImode:
          if (nonimmediate_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode)
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V2SImode:
                  if (nonimmediate_operand (operands[1], E_V2SImode)
                      && (
#line 5729 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 5732 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1124 (insn, operands);
                  break;

                case E_V4SImode:
                  if (register_operand (operands[1], E_V4SImode)
                      && 
#line 21192 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
                    return gen_split_3396 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          break;

        case E_HFmode:
          switch (pattern964 (x2))
            {
            case 0:
              if (((
#line 13218 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 548 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1585 (insn, operands);
              break;

            case 1:
              if ((
#line 13218 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1586 (insn, operands);
              break;

            case 2:
              if ((
#line 13218 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1587 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case E_BFmode:
          switch (pattern965 (x2))
            {
            case 0:
              if (((
#line 13218 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 549 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1588 (insn, operands);
              break;

            case 1:
              if ((
#line 13218 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1589 (insn, operands);
              break;

            case 2:
              if ((
#line 13218 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1590 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case E_DFmode:
          if (register_operand (operands[0], E_DFmode)
              && GET_MODE (x2) == E_DFmode
              && nonimmediate_operand (operands[1], E_V2DFmode)
              && 
#line 14656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
            return gen_split_3179 (insn, operands);
          break;

        case E_QImode:
          if (memory_operand (operands[0], E_QImode)
              && GET_MODE (x2) == E_QImode
              && register_operand (operands[1], E_V16QImode)
              && ((
#line 21052 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !TARGET_SSE4_1
   && (TARGET_INTER_UNIT_MOVES_FROM_VEC
       || optimize_function_for_speed_p (cfun))
   && ix86_pre_reload_split ()) && 
#line 21045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)) && 
#line 21058 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3393 (insn, operands);
          break;

        case E_HImode:
          if (memory_operand (operands[0], E_HImode)
              && GET_MODE (x2) == E_HImode
              && register_operand (operands[1], E_V8HImode)
              && (
#line 21052 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !TARGET_SSE4_1
   && (TARGET_INTER_UNIT_MOVES_FROM_VEC
       || optimize_function_for_speed_p (cfun))
   && ix86_pre_reload_split ()) && 
#line 21058 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3394 (insn, operands);
          break;

        case E_TImode:
          if (nonimmediate_operand (operands[0], E_TImode)
              && GET_MODE (x2) == E_TImode)
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V4TImode:
                  if (register_operand (operands[1], E_V4TImode)
                      && (
#line 21426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && reload_completed
   && (TARGET_AVX512VL || !EXT_REX_SSE_REG_P (operands[1]))) && 
#line 21419 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return gen_split_3404 (insn, operands);
                  break;

                case E_V2TImode:
                  if (register_operand (operands[1], E_V2TImode)
                      && 
#line 21426 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && reload_completed
   && (TARGET_AVX512VL || !EXT_REX_SSE_REG_P (operands[1]))))
                    return gen_split_3405 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          break;

        default:
          break;
        }
      break;

    case 1L:
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (register_operand (operands[0], E_SFmode)
              && GET_MODE (x2) == E_SFmode
              && memory_operand (operands[1], E_V2SFmode)
              && 
#line 1827 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && reload_completed))
            return gen_split_1039 (insn, operands);
          break;

        case E_SImode:
          if (register_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode
              && memory_operand (operands[1], E_V2SImode)
              && 
#line 5816 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && reload_completed))
            return gen_split_1126 (insn, operands);
          break;

        case E_DFmode:
          if (register_operand (operands[0], E_DFmode)
              && GET_MODE (x2) == E_DFmode
              && memory_operand (operands[1], E_V2DFmode)
              && 
#line 14603 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
            return gen_split_3177 (insn, operands);
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (GET_MODE (x2) != E_SFmode)
        return NULL;
      if (nonimmediate_operand (operands[0], E_SFmode)
          && register_operand (operands[1], E_V4SFmode)
          && const_0_to_3_operand (operands[2], E_SImode)
          && (
#line 12320 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 12327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed && SSE_REG_P (operands[0]))))
        return gen_split_1563 (insn, operands);
      if (!register_operand (operands[0], E_SFmode)
          || !memory_operand (operands[1], E_V4SFmode)
          || !const_0_to_3_operand (operands[2], E_VOIDmode)
          || !(
#line 12363 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 12365 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
        return NULL;
      return gen_split_1564 (insn, operands);

    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x2) != E_QImode
          || !memory_operand (operands[1], E_V16QImode)
          || !const_0_to_15_operand (operands[2], E_VOIDmode)
          || !
#line 21379 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_3400 (insn, operands);

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x2) != E_HImode
          || !memory_operand (operands[1], E_V8HImode)
          || !const_0_to_7_operand (operands[2], E_VOIDmode)
          || !
#line 21379 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_3401 (insn, operands);

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x2) != E_SImode
          || !memory_operand (operands[1], E_V4SImode)
          || !const_0_to_3_operand (operands[2], E_VOIDmode)
          || !
#line 21379 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_3402 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_56 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (XINT (x2, 1) != 164)
    return NULL;
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XVECEXP (x2, 0, 3);
  operands[4] = x6;
  if (!const_0_to_255_operand (operands[4], E_SImode))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      if (pattern958 (x2, 
E_V64QImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V64QImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1593 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V64QImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1617 (insn, operands);

    case E_V32QImode:
      if (pattern958 (x2, 
E_V32QImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32QImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1594 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32QImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1618 (insn, operands);

    case E_V16QImode:
      if (pattern958 (x2, 
E_V16QImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16QImode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1595 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16QImode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1619 (insn, operands);

    case E_V32HImode:
      if (pattern958 (x2, 
E_V32HImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32HImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1596 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32HImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1620 (insn, operands);

    case E_V16HImode:
      if (pattern958 (x2, 
E_V16HImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16HImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1597 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16HImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1621 (insn, operands);

    case E_V8HImode:
      if (pattern958 (x2, 
E_V8HImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8HImode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1598 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8HImode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1622 (insn, operands);

    case E_V16SImode:
      if (pattern958 (x2, 
E_V16SImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16SImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1599 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16SImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1623 (insn, operands);

    case E_V8SImode:
      if (pattern958 (x2, 
E_V8SImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8SImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1600 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8SImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1624 (insn, operands);

    case E_V4SImode:
      if (pattern958 (x2, 
E_V4SImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4SImode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1601 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4SImode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1625 (insn, operands);

    case E_V8DImode:
      if (pattern958 (x2, 
E_V8DImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8DImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1602 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8DImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1626 (insn, operands);

    case E_V4DImode:
      if (pattern958 (x2, 
E_V4DImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4DImode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1603 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4DImode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1627 (insn, operands);

    case E_V2DImode:
      if (pattern958 (x2, 
E_V2DImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V2DImode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1604 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V2DImode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1628 (insn, operands);

    case E_V32HFmode:
      if (pattern958 (x2, 
E_V32HFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32HFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1605 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32HFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1629 (insn, operands);

    case E_V16HFmode:
      if (pattern958 (x2, 
E_V16HFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16HFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1606 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16HFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1630 (insn, operands);

    case E_V8HFmode:
      if (pattern958 (x2, 
E_V8HFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8HFmode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1607 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8HFmode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1631 (insn, operands);

    case E_V32BFmode:
      if (pattern958 (x2, 
E_V32BFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32BFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1608 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32BFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1632 (insn, operands);

    case E_V16BFmode:
      if (pattern958 (x2, 
E_V16BFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16BFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1609 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16BFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1633 (insn, operands);

    case E_V8BFmode:
      if (pattern958 (x2, 
E_V8BFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8BFmode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1610 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8BFmode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1634 (insn, operands);

    case E_V16SFmode:
      if (pattern958 (x2, 
E_V16SFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16SFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1611 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16SFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1635 (insn, operands);

    case E_V8SFmode:
      if (pattern958 (x2, 
E_V8SFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8SFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1612 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8SFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1636 (insn, operands);

    case E_V4SFmode:
      if (pattern958 (x2, 
E_V4SFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4SFmode)
          && 
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1613 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4SFmode)
          || !
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1637 (insn, operands);

    case E_V8DFmode:
      if (pattern958 (x2, 
E_V8DFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8DFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1614 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8DFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1638 (insn, operands);

    case E_V4DFmode:
      if (pattern958 (x2, 
E_V4DFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4DFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1615 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4DFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1639 (insn, operands);

    case E_V2DFmode:
      if (pattern958 (x2, 
E_V2DFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V2DFmode)
          && (
#line 13685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return gen_split_1616 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V2DFmode)
          || !(
#line 13706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return NULL;
      return gen_split_1640 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_70 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2007 (insn, operands);

        case 1:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2034 (insn, operands);

        case 2:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2061 (insn, operands);

        case 3:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2088 (insn, operands);

        case 4:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2115 (insn, operands);

        case 5:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2142 (insn, operands);

        case 6:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2169 (insn, operands);

        case 7:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2196 (insn, operands);

        case 8:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2223 (insn, operands);

        case 9:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2250 (insn, operands);

        case 10:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2277 (insn, operands);

        case 11:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2304 (insn, operands);

        case 12:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2010 (insn, operands);

        case 13:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2037 (insn, operands);

        case 14:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2064 (insn, operands);

        case 15:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2091 (insn, operands);

        case 16:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2118 (insn, operands);

        case 17:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2145 (insn, operands);

        case 18:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2172 (insn, operands);

        case 19:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2199 (insn, operands);

        case 20:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2226 (insn, operands);

        case 21:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2253 (insn, operands);

        case 22:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2280 (insn, operands);

        case 23:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2307 (insn, operands);

        case 24:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2013 (insn, operands);

        case 25:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2040 (insn, operands);

        case 26:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2067 (insn, operands);

        case 27:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2094 (insn, operands);

        case 28:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2121 (insn, operands);

        case 29:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2148 (insn, operands);

        case 30:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2175 (insn, operands);

        case 31:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2202 (insn, operands);

        case 32:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2229 (insn, operands);

        case 33:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2256 (insn, operands);

        case 34:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2283 (insn, operands);

        case 35:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2310 (insn, operands);

        case 36:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3075 (insn, operands);

        case 37:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3084 (insn, operands);

        case 38:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3093 (insn, operands);

        case 39:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3102 (insn, operands);

        case 40:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3111 (insn, operands);

        case 41:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3120 (insn, operands);

        case 42:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3129 (insn, operands);

        case 43:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3138 (insn, operands);

        case 44:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3147 (insn, operands);

        case 45:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3156 (insn, operands);

        case 46:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3165 (insn, operands);

        case 47:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3174 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2655 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2682 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2709 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2736 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2763 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2790 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2817 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2844 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2871 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2898 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2925 (insn, operands);

        case 11:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2952 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2658 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2685 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2712 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2739 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2766 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2793 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2820 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2847 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2874 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2901 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2928 (insn, operands);

        case 11:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2955 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2661 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2688 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2715 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2742 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2769 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2796 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2823 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2850 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2877 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2904 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2931 (insn, operands);

        case 11:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2958 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_78 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case MINUS:
      x4 = XEXP (x2, 1);
      if (GET_CODE (x4) != PLUS)
        return NULL;
      operands[6] = x2;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      x7 = XEXP (x4, 0);
      operands[3] = x7;
      x8 = XEXP (x4, 1);
      operands[4] = x8;
      x9 = XEXP (x2, 2);
      operands[5] = x9;
      if (!const_int_operand (operands[5], E_VOIDmode))
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1431 (x2, 
E_V8SFmode) != 0
              || !(
#line 3541 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1306 (insn, operands);

        case E_V4SFmode:
          if (pattern1431 (x2, 
E_V4SFmode) != 0
              || !
#line 3541 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
            return NULL;
          return gen_split_1307 (insn, operands);

        case E_V4DFmode:
          if (pattern1431 (x2, 
E_V4DFmode) != 0
              || !(
#line 3541 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1308 (insn, operands);

        case E_V2DFmode:
          if (pattern1431 (x2, 
E_V2DFmode) != 0
              || !(
#line 3541 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return NULL;
          return gen_split_1309 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      x4 = XEXP (x2, 1);
      if (GET_CODE (x4) != MINUS)
        return NULL;
      operands[6] = x2;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      x7 = XEXP (x4, 0);
      operands[3] = x7;
      x8 = XEXP (x4, 1);
      operands[4] = x8;
      x9 = XEXP (x2, 2);
      operands[5] = x9;
      if (!const_int_operand (operands[5], E_VOIDmode))
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1432 (x2, 
E_V8SFmode) != 0
              || !(
#line 3563 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1310 (insn, operands);

        case E_V4SFmode:
          if (pattern1432 (x2, 
E_V4SFmode) != 0
              || !
#line 3563 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
            return NULL;
          return gen_split_1311 (insn, operands);

        case E_V4DFmode:
          if (pattern1432 (x2, 
E_V4DFmode) != 0
              || !(
#line 3563 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1312 (insn, operands);

        case E_V2DFmode:
          if (pattern1432 (x2, 
E_V2DFmode) != 0
              || !(
#line 3563 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return NULL;
          return gen_split_1313 (insn, operands);

        default:
          return NULL;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case REG:
    case SUBREG:
    case MEM:
      switch (GET_CODE (x3))
        {
        case REG:
        case SUBREG:
        case MEM:
          res = split_57 (x1, insn);
          if (res != NULL_RTX)
            return res;
          break;

        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          switch (pattern317 (x2))
            {
            case 0:
              res = split_58 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case 1:
              if (vector_all_ones_operand (operands[1], E_V16QImode)
                  && const0_operand (operands[2], E_V16QImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3303 (insn, operands);
              if (const0_operand (operands[1], E_V16QImode)
                  && vector_all_ones_operand (operands[2], E_V16QImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3326 (insn, operands);
              break;

            case 2:
              if (vector_all_ones_operand (operands[1], E_V8HImode)
                  && const0_operand (operands[2], E_V8HImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3305 (insn, operands);
              if (const0_operand (operands[1], E_V8HImode)
                  && vector_all_ones_operand (operands[2], E_V8HImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3327 (insn, operands);
              break;

            case 3:
              if (vector_all_ones_operand (operands[1], E_V4SImode)
                  && const0_operand (operands[2], E_V4SImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3307 (insn, operands);
              if (const0_operand (operands[1], E_V4SImode)
                  && vector_all_ones_operand (operands[2], E_V4SImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3328 (insn, operands);
              break;

            case 4:
              if (vector_all_ones_operand (operands[1], E_V2DImode)
                  && const0_operand (operands[2], E_V2DImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3309 (insn, operands);
              if (const0_operand (operands[1], E_V2DImode)
                  && vector_all_ones_operand (operands[2], E_V2DImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3329 (insn, operands);
              break;

            case 5:
              if (vector_all_ones_operand (operands[1], E_V32QImode)
                  && const0_operand (operands[2], E_V32QImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3311 (insn, operands);
              if (const0_operand (operands[1], E_V32QImode)
                  && vector_all_ones_operand (operands[2], E_V32QImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3330 (insn, operands);
              break;

            case 6:
              if (vector_all_ones_operand (operands[1], E_V16HImode)
                  && const0_operand (operands[2], E_V16HImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3313 (insn, operands);
              if (const0_operand (operands[1], E_V16HImode)
                  && vector_all_ones_operand (operands[2], E_V16HImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3331 (insn, operands);
              break;

            case 7:
              if (vector_all_ones_operand (operands[1], E_V8SImode)
                  && const0_operand (operands[2], E_V8SImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3315 (insn, operands);
              if (const0_operand (operands[1], E_V8SImode)
                  && vector_all_ones_operand (operands[2], E_V8SImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3332 (insn, operands);
              break;

            case 8:
              if (vector_all_ones_operand (operands[1], E_V4DImode)
                  && const0_operand (operands[2], E_V4DImode)
                  && (
#line 18106 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3317 (insn, operands);
              if (const0_operand (operands[1], E_V4DImode)
                  && vector_all_ones_operand (operands[2], E_V4DImode)
                  && (
#line 18164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3333 (insn, operands);
              break;

            case 9:
              if (((
#line 4148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1326 (insn, operands);
              break;

            case 10:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3294 (insn, operands);
              break;

            case 11:
              if ((
#line 4148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 4150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1327 (insn, operands);
              break;

            case 12:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3290 (insn, operands);
              break;

            case 13:
              if (((
#line 4148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1328 (insn, operands);
              break;

            case 14:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3295 (insn, operands);
              break;

            case 15:
              if (((
#line 4148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4150 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1329 (insn, operands);
              break;

            case 16:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3291 (insn, operands);
              break;

            case 17:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3288 (insn, operands);
              break;

            case 18:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3289 (insn, operands);
              break;

            case 19:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3292 (insn, operands);
              break;

            case 20:
              if ((
#line 17981 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3293 (insn, operands);
              break;

            case 21:
              switch (GET_MODE (operands[0]))
                {
                case E_V16SImode:
                  if (register_operand (operands[0], E_V16SImode)
                      && GET_MODE (x2) == E_V16SImode
                      && register_operand (operands[1], E_HImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V16SImode)
                          && const0_operand (operands[3], E_V16SImode)
                          && ((
#line 10302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10306 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1528 (insn, operands);
                      if (const0_operand (operands[2], E_V16SImode)
                          && vector_all_ones_operand (operands[3], E_V16SImode)
                          && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1540 (insn, operands);
                    }
                  break;

                case E_V8SImode:
                  if (register_operand (operands[0], E_V8SImode)
                      && GET_MODE (x2) == E_V8SImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V8SImode)
                          && const0_operand (operands[3], E_V8SImode)
                          && ((
#line 10302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1529 (insn, operands);
                      if (const0_operand (operands[2], E_V8SImode)
                          && vector_all_ones_operand (operands[3], E_V8SImode)
                          && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1541 (insn, operands);
                    }
                  break;

                case E_V4SImode:
                  if (register_operand (operands[0], E_V4SImode)
                      && GET_MODE (x2) == E_V4SImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V4SImode)
                          && const0_operand (operands[3], E_V4SImode)
                          && ((
#line 10302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1530 (insn, operands);
                      if (const0_operand (operands[2], E_V4SImode)
                          && vector_all_ones_operand (operands[3], E_V4SImode)
                          && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 510 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1542 (insn, operands);
                    }
                  break;

                case E_V8DImode:
                  if (register_operand (operands[0], E_V8DImode)
                      && GET_MODE (x2) == E_V8DImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V8DImode)
                          && const0_operand (operands[3], E_V8DImode)
                          && ((
#line 10302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10306 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1531 (insn, operands);
                      if (const0_operand (operands[2], E_V8DImode)
                          && vector_all_ones_operand (operands[3], E_V8DImode)
                          && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1543 (insn, operands);
                    }
                  break;

                case E_V4DImode:
                  if (register_operand (operands[0], E_V4DImode)
                      && GET_MODE (x2) == E_V4DImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V4DImode)
                          && const0_operand (operands[3], E_V4DImode)
                          && ((
#line 10302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1532 (insn, operands);
                      if (const0_operand (operands[2], E_V4DImode)
                          && vector_all_ones_operand (operands[3], E_V4DImode)
                          && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1544 (insn, operands);
                    }
                  break;

                case E_V2DImode:
                  if (register_operand (operands[0], E_V2DImode)
                      && GET_MODE (x2) == E_V2DImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V2DImode)
                          && const0_operand (operands[3], E_V2DImode)
                          && ((
#line 10302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1533 (insn, operands);
                      if (const0_operand (operands[2], E_V2DImode)
                          && vector_all_ones_operand (operands[3], E_V2DImode)
                          && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1545 (insn, operands);
                    }
                  break;

                case E_V64QImode:
                  if (pattern1173 (x2, 
E_DImode, 
E_V64QImode) == 0
                      && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1534 (insn, operands);
                  break;

                case E_V32QImode:
                  if (pattern1173 (x2, 
E_SImode, 
E_V32QImode) == 0
                      && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 505 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1535 (insn, operands);
                  break;

                case E_V16QImode:
                  if (pattern1173 (x2, 
E_HImode, 
E_V16QImode) == 0
                      && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 506 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1536 (insn, operands);
                  break;

                case E_V32HImode:
                  if (pattern1173 (x2, 
E_SImode, 
E_V32HImode) == 0
                      && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 507 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1537 (insn, operands);
                  break;

                case E_V16HImode:
                  if (pattern1173 (x2, 
E_HImode, 
E_V16HImode) == 0
                      && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1538 (insn, operands);
                  break;

                case E_V8HImode:
                  if (pattern1173 (x2, 
E_QImode, 
E_V8HImode) == 0
                      && ((
#line 10328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 509 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1539 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      operands[1] = x3;
      switch (pattern320 (x2))
        {
        case 0:
          if (!((
#line 4175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1330 (insn, operands);

        case 1:
          if (!(
#line 4175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 4177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1331 (insn, operands);

        case 2:
          if (!((
#line 4175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1332 (insn, operands);

        case 3:
          if (!((
#line 4175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1333 (insn, operands);

        case 4:
          if (!((
#line 4196 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1334 (insn, operands);

        case 5:
          if (!(
#line 4196 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 4198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1335 (insn, operands);

        case 6:
          if (!((
#line 4196 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1336 (insn, operands);

        case 7:
          if (!((
#line 4196 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1337 (insn, operands);

        default:
          return NULL;
        }

    case VEC_DUPLICATE:
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case VEC_SELECT:
          x10 = XEXP (x5, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 1)
            return NULL;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          x9 = XEXP (x2, 2);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return NULL;
          switch (pattern997 (x2))
            {
            case 0:
              if (!(
#line 12023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1546 (insn, operands);

            case 1:
              if (!(
#line 12023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1547 (insn, operands);

            case 2:
              if (!(
#line 12023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1548 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          switch (pattern312 (x2))
            {
            case 0:
              if (!((
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 12065 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1549 (insn, operands);

            case 1:
              if (!(
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1550 (insn, operands);

            case 2:
              if (!(
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1551 (insn, operands);

            case 3:
              if (!((
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 12065 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1552 (insn, operands);

            case 4:
              if (!((
#line 12177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 12179 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1556 (insn, operands);

            case 5:
              if (!(
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1553 (insn, operands);

            case 6:
              if (!((
#line 12177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 12179 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1557 (insn, operands);

            case 7:
              if (!(
#line 12063 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1554 (insn, operands);

            case 8:
              if (!(
#line 12177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12179 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1558 (insn, operands);

            default:
              return NULL;
            }

        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          x4 = XEXP (x2, 1);
          switch (GET_CODE (x4))
            {
            case SUBREG:
            case MEM:
              if (!rtx_equal_p (x4, operands[0]))
                return NULL;
              x9 = XEXP (x2, 2);
              if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return NULL;
              operands[1] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SImode:
                  if (pattern1174 (x2, 
E_SImode, 
E_V4SImode) != 0
                      || !
#line 12253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
                    return NULL;
                  return gen_split_1560 (insn, operands);

                case E_V4SFmode:
                  if (pattern1174 (x2, 
E_SFmode, 
E_V4SFmode) != 0
                      || !
#line 12253 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
                    return NULL;
                  return gen_split_1561 (insn, operands);

                default:
                  return NULL;
                }

            case REG:
              operands[1] = x4;
              operands[2] = x5;
              x9 = XEXP (x2, 2);
              operands[3] = x9;
              if (!const_int_operand (operands[3], E_SImode))
                return NULL;
              switch (GET_MODE (operands[0]))
                {
                case E_V8HImode:
                  if (pattern1053 (x2, 
E_V8HImode, 
E_HImode) != 0
                      || !
#line 19935 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && reload_completed
   && INTVAL (operands[3]) > 1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8HImode))))
                    return NULL;
                  return gen_split_3390 (insn, operands);

                case E_V8HFmode:
                  if (pattern1053 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                      || !
#line 19935 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && reload_completed
   && INTVAL (operands[3]) > 1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8HFmode))))
                    return NULL;
                  return gen_split_3391 (insn, operands);

                case E_V8BFmode:
                  if (pattern1053 (x2, 
E_V8BFmode, 
E_BFmode) != 0
                      || !
#line 19935 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && reload_completed
   && INTVAL (operands[3]) > 1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8BFmode))))
                    return NULL;
                  return gen_split_3392 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_1 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return NULL;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case NEG:
      if (GET_MODE (x4) != E_QImode)
        return NULL;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != LTU
          || GET_MODE (x5) != E_QImode)
        return NULL;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17
          || GET_MODE (x6) != E_CCCmode)
        return NULL;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x8 = XEXP (x3, 1);
      if (GET_CODE (x8) != GEU
          || GET_MODE (x8) != E_QImode)
        return NULL;
      x9 = XEXP (x8, 0);
      if (GET_CODE (x9) != REG
          || REGNO (x9) != 17
          || GET_MODE (x9) != E_CCCmode)
        return NULL;
      x10 = XEXP (x8, 1);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || GET_MODE (x2) != E_CCCmode
          || GET_MODE (x3) != E_CCCmode
          || !
#line 2162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SLOW_STC && !optimize_insn_for_size_p ()))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_2 (insn, operands);

    case AND:
      x8 = XEXP (x3, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || GET_MODE (x2) != E_CCZmode
          || GET_MODE (x3) != E_CCZmode)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[0] = x5;
      x11 = XEXP (x4, 1);
      operands[1] = x11;
      if (!const_int_operand (operands[1], E_VOIDmode))
        return NULL;
      switch (GET_MODE (x4))
        {
        case E_HImode:
          if (!memory_operand (operands[0], E_HImode)
              || !
#line 12426 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_MEMORY_READ_STALL
   && !MEM_VOLATILE_P (operands[0])
   && offsettable_memref_p (operands[0])))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_124 (insn, operands);

        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || !
#line 12426 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_MEMORY_READ_STALL
   && !MEM_VOLATILE_P (operands[0])
   && offsettable_memref_p (operands[0])))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_125 (insn, operands);

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || !(
#line 12426 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_MEMORY_READ_STALL
   && !MEM_VOLATILE_P (operands[0])
   && offsettable_memref_p (operands[0])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_126 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_2 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      switch (pattern411 (x3, 
E_SImode))
        {
        case 0:
          if (!
#line 5977 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (SFmode)
   && optimize_insn_for_speed_p ()))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_56 (insn, operands);

        case 1:
          if (!
#line 5977 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (DFmode)
   && optimize_insn_for_speed_p ()))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_58 (insn, operands);

        default:
          return NULL;
        }

    case E_DImode:
      switch (pattern411 (x3, 
E_DImode))
        {
        case 0:
          if (!(
#line 5977 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (SFmode)
   && optimize_insn_for_speed_p ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_57 (insn, operands);

        case 1:
          if (!(
#line 5977 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (DFmode)
   && optimize_insn_for_speed_p ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_59 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_3 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2
      || peep2_current_count < 3)
    return NULL;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  if (!bt_comparison_operator (operands[1], E_QImode))
    return NULL;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCZmode)
    return NULL;
  x4 = XEXP (x2, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  if (!nonimmediate_operand (operands[0], E_QImode))
    return NULL;
  x6 = PATTERN (peep2_next_insn (1));
  if (pattern1240 (x6, 
0) != 0)
    return NULL;
  x7 = PATTERN (peep2_next_insn (2));
  x8 = XEXP (x7, 1);
  x9 = XEXP (x8, 0);
  operands[2] = x9;
  if (pattern1764 (x7) != 0)
    return NULL;
  x10 = XEXP (x8, 1);
  operands[3] = x10;
  if (!
#line 19683 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(peep2_regno_dead_p (3, FLAGS_REG)))
    return NULL;
  *pmatch_len_ = 2;
  return gen_peephole2_168 (insn, operands);
}

 rtx_insn *
peephole2_5 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
      if (peep2_current_count < 2)
        return NULL;
      operands[0] = x2;
      x3 = PATTERN (peep2_next_insn (1));
      if (GET_CODE (x3) != SET)
        return NULL;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != STRICT_LOW_PART)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!general_reg_operand (operands[0], E_SImode))
            return NULL;
          switch (pattern1328 ())
            {
            case 0:
              if (!
#line 4960 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (SImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_45 (insn, operands);

            case 1:
              if (!
#line 4960 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (SImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_47 (insn, operands);

            default:
              return NULL;
            }

        case E_DImode:
          if (!general_reg_operand (operands[0], E_DImode))
            return NULL;
          switch (pattern1328 ())
            {
            case 0:
              if (!(
#line 4960 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (DImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_46 (insn, operands);

            case 1:
              if (!(
#line 4960 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (DImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_48 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case SUBREG:
    case MEM:
      operands[0] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!memory_operand (operands[0], E_QImode)
              || !
#line 27840 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((QImode == HImode
       && TARGET_LCP_STALL)
       || (!TARGET_USE_MOV0
          && TARGET_SPLIT_LONG_MOVES
          && get_attr_length (insn) >= ix86_cur_cost ()->large_insn))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_256 (insn, operands);

        case E_HImode:
          if (!memory_operand (operands[0], E_HImode)
              || !
#line 27840 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((HImode == HImode
       && TARGET_LCP_STALL)
       || (!TARGET_USE_MOV0
          && TARGET_SPLIT_LONG_MOVES
          && get_attr_length (insn) >= ix86_cur_cost ()->large_insn))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_257 (insn, operands);

        default:
          return NULL;
        }

    case STRICT_LOW_PART:
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!general_reg_operand (operands[0], E_QImode)
              || !
#line 28527 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((! TARGET_USE_MOV0 || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_333 (insn, operands);

        case E_HImode:
          if (!general_reg_operand (operands[0], E_HImode)
              || !
#line 28527 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((! TARGET_USE_MOV0 || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_334 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  switch (GET_CODE (operands[0]))
    {
    case REG:
    case SUBREG:
      if (peep2_current_count < 2
          || peep2_current_count < 3)
        return NULL;
      x4 = PATTERN (peep2_next_insn (1));
      if (GET_CODE (x4) != PARALLEL
          || pattern835 (x4) != 0)
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!memory_operand (operands[1], E_QImode))
            return NULL;
          if (general_reg_operand (operands[0], E_QImode))
            {
              switch (pattern1515 (x4, 
E_QImode))
                {
                case 0:
                  if (
#line 8713 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_68 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if (
#line 9999 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_108 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if (
#line 8830 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_76 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 3:
                  if (
#line 8856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_80 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 4:
                  if (
#line 9314 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_90 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 5:
                  if (
#line 9340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_94 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
          if (!register_operand (operands[0], E_QImode))
            return NULL;
          switch (pattern1516 (x4, 
E_QImode))
            {
            case 0:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1])
                  && 
#line 28145 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 2;
                  res = gen_peephole2_297 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (peep2_current_count < 4
                  || pattern1787 (x6, 
E_QImode) != 0
                  || !
#line 28385 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_321 (insn, operands);

            case 1:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1]))
                {
                  x7 = PATTERN (peep2_next_insn (3));
                  if (pattern1785 (x7) == 0
                      && 
#line 28268 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (4, operands[0])
   && (QImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_313 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                }
              if (peep2_current_count < 5
                  || pattern1829 (x6, 
E_QImode) != 0
                  || !
#line 28345 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[5])
   && (QImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 4;
              return gen_peephole2_319 (insn, operands);

            default:
              return NULL;
            }

        case E_HImode:
          if (!memory_operand (operands[1], E_HImode))
            return NULL;
          if (general_reg_operand (operands[0], E_HImode))
            {
              switch (pattern1515 (x4, 
E_HImode))
                {
                case 0:
                  if (
#line 8713 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_69 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if (
#line 9999 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_109 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if (
#line 8830 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_77 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 3:
                  if (
#line 8856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_81 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 4:
                  if (
#line 9314 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_91 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 5:
                  if (
#line 9340 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_95 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
          if (!register_operand (operands[0], E_HImode))
            return NULL;
          switch (pattern1516 (x4, 
E_HImode))
            {
            case 0:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1])
                  && 
#line 28145 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 2;
                  res = gen_peephole2_298 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (peep2_current_count < 4
                  || pattern1787 (x6, 
E_HImode) != 0
                  || !
#line 28385 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_322 (insn, operands);

            case 1:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1]))
                {
                  x7 = PATTERN (peep2_next_insn (3));
                  if (pattern1785 (x7) == 0
                      && 
#line 28268 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (4, operands[0])
   && (HImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_314 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                }
              if (peep2_current_count < 5
                  || pattern1829 (x6, 
E_HImode) != 0
                  || !
#line 28345 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[5])
   && (HImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 4;
              return gen_peephole2_320 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!push_operand (operands[0], E_QImode)
              || !memory_operand (operands[1], E_QImode)
              || !
#line 27818 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_251 (insn, operands);

        case E_HImode:
          if (!push_operand (operands[0], E_HImode)
              || !memory_operand (operands[1], E_HImode)
              || !
#line 27818 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_252 (insn, operands);

        case E_SFmode:
          if (!push_operand (operands[0], E_SFmode)
              || !memory_operand (operands[1], E_SFmode)
              || !
#line 27829 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_255 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_17 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 0);
  if (!general_reg_operand (x3, E_DImode))
    return NULL;
  operands[8] = x3;
  switch (pattern949 (x1, 
E_DImode, 
E_TImode))
    {
    case 0:
      if ((
#line 9672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_101 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    case 1:
      if ((
#line 9727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (6, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && !reg_overlap_mentioned_p (operands[0], operands[10])
   && !reg_overlap_mentioned_p (operands[10], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[11])
   && !reg_overlap_mentioned_p (operands[11], operands[1])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 5;
          res = gen_peephole2_103 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  operands[0] = x3;
  if (pattern952 (x1, 
E_DImode) != 0
      || !(
#line 26563 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (2, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])
  && !reg_mentioned_p (operands[2], operands[6])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_208 (insn, operands);
}

 rtx_insn *
peephole2_21 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 1);
  if (!binary_fp_operator (x3, E_VOIDmode))
    return NULL;
  operands[2] = x3;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return NULL;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case REG:
      if (!rtx_equal_p (x5, operands[0]))
        return NULL;
      x6 = XEXP (x3, 1);
      operands[3] = x6;
      if (!memory_operand (operands[3], E_VOIDmode)
          || !
#line 26871 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_211 (insn, operands);

    case SUBREG:
    case MEM:
      operands[3] = x5;
      if (!memory_operand (operands[3], E_VOIDmode))
        return NULL;
      x6 = XEXP (x3, 1);
      if (!rtx_equal_p (x6, operands[0])
          || !
#line 26893 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_212 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_22 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count >= 3)
    {
      res = peephole2_20 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  operands[1] = x3;
  if (fp_register_operand (operands[1], E_VOIDmode)
      && fp_register_operand (operands[0], E_VOIDmode))
    {
      res = peephole2_21 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (general_reg_operand (operands[1], E_QImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x4, 
E_QImode) == 0
          && 
#line 28018 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (QImode != QImode
       || any_QIreg_operand (operands[1], QImode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_279 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (general_reg_operand (operands[1], E_HImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x4, 
E_HImode) == 0
          && 
#line 28018 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (HImode != QImode
       || any_QIreg_operand (operands[1], QImode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_280 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (general_reg_operand (operands[1], E_DImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x4, 
E_DImode) == 0
          && (
#line 28018 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (DImode != QImode
       || any_QIreg_operand (operands[1], QImode))) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_282 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count < 3
      || peep2_current_count < 4)
    return NULL;
  if (memory_operand (operands[1], E_QImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern724 (x4, 
E_QImode) == 0)
        {
          x5 = PATTERN (peep2_next_insn (2));
          x6 = XEXP (x5, 0);
          if (rtx_equal_p (x6, operands[1]))
            {
              x7 = PATTERN (peep2_next_insn (3));
              if (pattern1785 (x7) == 0
                  && 
#line 28109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 3;
                  res = gen_peephole2_293 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          if (peep2_current_count >= 5
              && pattern1786 (x6, 
E_QImode) == 0
              && 
#line 28307 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
            {
              *pmatch_len_ = 4;
              res = gen_peephole2_315 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
    }
  if (memory_operand (operands[1], E_HImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern724 (x4, 
E_HImode) == 0)
        {
          x5 = PATTERN (peep2_next_insn (2));
          x6 = XEXP (x5, 0);
          if (rtx_equal_p (x6, operands[1]))
            {
              x7 = PATTERN (peep2_next_insn (3));
              if (pattern1785 (x7) == 0
                  && 
#line 28109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 3;
                  res = gen_peephole2_294 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          if (peep2_current_count >= 5
              && pattern1786 (x6, 
E_HImode) == 0
              && 
#line 28307 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
            {
              *pmatch_len_ = 4;
              res = gen_peephole2_316 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
    }
  if (!memory_operand (operands[1], E_DImode)
      || !register_operand (operands[0], E_DImode))
    return NULL;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 2)
    return NULL;
  x8 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x8) != SET)
    return NULL;
  x9 = XEXP (x8, 1);
  if (!plusminuslogic_operator (x9, E_DImode))
    return NULL;
  operands[3] = x9;
  x10 = XVECEXP (x4, 0, 1);
  if (GET_CODE (x10) != CLOBBER)
    return NULL;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != REG
      || REGNO (x11) != 17
      || GET_MODE (x11) != E_CCmode)
    return NULL;
  x12 = XEXP (x9, 1);
  operands[2] = x12;
  if (!x86_64_nonmemory_operand (operands[2], E_DImode)
      || pattern723 (x8) != 0)
    return NULL;
  x5 = PATTERN (peep2_next_insn (2));
  x6 = XEXP (x5, 0);
  if (rtx_equal_p (x6, operands[1]))
    {
      x7 = PATTERN (peep2_next_insn (3));
      if (pattern1785 (x7) == 0
          && (
#line 28109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (DImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_296 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count < 5
      || pattern1786 (x6, 
E_DImode) != 0
      || !(
#line 28307 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && (DImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
    return NULL;
  *pmatch_len_ = 4;
  return gen_peephole2_318 (insn, operands);
}

 rtx_insn *
peephole2_35 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3)
    return NULL;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  if (!register_operand (operands[0], E_QImode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  if (pattern415 (x3, 
UNSPEC_VOLATILE, 
3) != 0)
    return NULL;
  x4 = XVECEXP (x3, 0, 0);
  x5 = XEXP (x4, 1);
  if (XVECLEN (x5, 0) == 4
      && XINT (x5, 1) == 109
      && GET_MODE (x5) == E_QImode)
    {
      res = peephole2_34 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (XVECLEN (x5, 0) != 2
      || XINT (x5, 1) != 110
      || GET_MODE (x5) != E_QImode)
    return NULL;
  x6 = XEXP (x1, 1);
  operands[2] = x6;
  if (!const_int_operand (operands[2], E_QImode))
    return NULL;
  x7 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != PLUS
      || GET_MODE (x8) != E_QImode
      || pattern1492 (x3) != 0
      || !memory_operand (operands[1], E_QImode)
      || pattern1674 (x3) != 0)
    return NULL;
  x9 = PATTERN (peep2_next_insn (2));
  x10 = XEXP (x9, 1);
  x11 = XEXP (x10, 1);
  operands[3] = x11;
  if (!const_int_operand (operands[3], E_QImode))
    return NULL;
  x12 = XEXP (x10, 0);
  if (!rtx_equal_p (x12, operands[0])
      || !
#line 724 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
    return NULL;
  *pmatch_len_ = 2;
  return gen_peephole2_415 (insn, operands);
}

 rtx_insn *
peephole2_42 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PLUS)
    return NULL;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_CCCmode)
    return NULL;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != E_CCCmode)
    return NULL;
  x7 = XEXP (x6, 1);
  if (!rtx_equal_p (x7, operands[0]))
    return NULL;
  x8 = XEXP (x3, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return NULL;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return NULL;
  x10 = XEXP (x6, 0);
  switch (GET_MODE (x10))
    {
    case E_QImode:
      if (!general_reg_operand (operands[0], E_QImode)
          || !memory_operand (operands[1], E_QImode)
          || GET_MODE (x3) != E_QImode
          || !
#line 9980 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (2, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_104 (insn, operands);

    case E_HImode:
      if (!general_reg_operand (operands[0], E_HImode)
          || !memory_operand (operands[1], E_HImode)
          || GET_MODE (x3) != E_HImode
          || !
#line 9980 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (2, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_105 (insn, operands);

    case E_SImode:
      if (!general_reg_operand (operands[0], E_SImode)
          || !memory_operand (operands[1], E_SImode)
          || GET_MODE (x3) != E_SImode
          || !
#line 9980 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (2, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_106 (insn, operands);

    case E_DImode:
      if (!general_reg_operand (operands[0], E_DImode)
          || !memory_operand (operands[1], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !(
#line 9980 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (2, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_107 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_44 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2)
    return NULL;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UMUL_HIGHPART)
    return NULL;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  x9 = XEXP (x2, 0);
  operands[1] = x9;
  x10 = XEXP (x3, 0);
  if (!rtx_equal_p (x10, operands[2]))
    return NULL;
  x11 = XEXP (x3, 1);
  if (!rtx_equal_p (x11, operands[3]))
    return NULL;
  x12 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x12) != SET)
    return NULL;
  x13 = XEXP (x12, 0);
  operands[4] = x13;
  x14 = XEXP (x12, 1);
  operands[5] = x14;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (pattern1559 (x1, 
E_SImode) != 0
          || !(
#line 10982 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2
   && ((REGNO (operands[5]) == REGNO (operands[0])
        && REGNO (operands[1]) != REGNO (operands[4]))
       || (REGNO (operands[5]) == REGNO (operands[1])
	   && REGNO (operands[0]) != REGNO (operands[4])))
   && peep2_reg_dead_p (2, operands[5])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_112 (insn, operands);

    case E_DImode:
      if (pattern1559 (x1, 
E_DImode) != 0
          || !(
#line 10982 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2
   && ((REGNO (operands[5]) == REGNO (operands[0])
        && REGNO (operands[1]) != REGNO (operands[4]))
       || (REGNO (operands[5]) == REGNO (operands[1])
	   && REGNO (operands[0]) != REGNO (operands[4])))
   && peep2_reg_dead_p (2, operands[5])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_113 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_47 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!arith_or_logical_operator (operands[3], E_QImode))
        return NULL;
      if (register_operand (operands[0], E_QImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_QImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27988 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_271 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_QImode)
              && rtx_equal_p (x5, operands[0])
              && 
#line 28001 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_275 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_QImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (nonmemory_operand (operands[1], E_QImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && 
#line 28076 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_285 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!nonmemory_operand (operands[1], E_QImode)
          || !rtx_equal_p (x5, operands[0])
          || !
#line 28090 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_289 (insn, operands);

    case E_HImode:
      if (!arith_or_logical_operator (operands[3], E_HImode))
        return NULL;
      if (register_operand (operands[0], E_HImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_HImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27988 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_272 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_HImode)
              && rtx_equal_p (x5, operands[0])
              && 
#line 28001 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_276 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_HImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (nonmemory_operand (operands[1], E_HImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && 
#line 28076 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_286 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!nonmemory_operand (operands[1], E_HImode)
          || !rtx_equal_p (x5, operands[0])
          || !
#line 28090 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_290 (insn, operands);

    case E_SImode:
      if (!arith_or_logical_operator (operands[3], E_SImode))
        return NULL;
      if (register_operand (operands[0], E_SImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_SImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27988 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_273 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_SImode)
              && rtx_equal_p (x5, operands[0])
              && 
#line 28001 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_277 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_SImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (x86_64_nonmemory_operand (operands[1], E_SImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && 
#line 28076 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_287 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!x86_64_nonmemory_operand (operands[1], E_SImode)
          || !rtx_equal_p (x5, operands[0])
          || !
#line 28090 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_291 (insn, operands);

    case E_DImode:
      if (!arith_or_logical_operator (operands[3], E_DImode))
        return NULL;
      if (register_operand (operands[0], E_DImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_DImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && (
#line 27988 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_274 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_DImode)
              && rtx_equal_p (x5, operands[0])
              && (
#line 28001 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_278 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_DImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (x86_64_nonmemory_operand (operands[1], E_DImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && (
#line 28076 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_288 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!x86_64_nonmemory_operand (operands[1], E_DImode)
          || !rtx_equal_p (x5, operands[0])
          || !(
#line 28090 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_292 (insn, operands);

    default:
      return NULL;
    }
}
