/* do not edit automatically generated by mc from M2Graph.  */
/* M2Graph.mod maintains the dependancy graph depth.

Copyright (C) 2022-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Graph_C

#include "GM2Graph.h"
#   include "GStorage.h"
#   include "GStrLib.h"
#   include "GNumberIO.h"
#   include "GStrIO.h"
#   include "GNameKey.h"
#   include "GLists.h"
#   include "GIndexing.h"
#   include "GM2Printf.h"
#   include "GSymbolTable.h"

#   define Debugging false
typedef struct M2Graph__T1_r M2Graph__T1;

typedef struct M2Graph__T2_r M2Graph__T2;

typedef M2Graph__T2 *M2Graph_node;

typedef enum {M2Graph_initial, M2Graph_started, M2Graph_ordered} M2Graph_state;

typedef M2Graph__T1 *M2Graph_Graph__opaque;

struct M2Graph__T1_r {
                       Indexing_Index nodes;
                     };

struct M2Graph__T2_r {
                       unsigned int moduleSym;
                       Indexing_Index deps;
                       M2Graph_state nstate;
                     };


/*
   InitGraph - creates and returns an empty graph.
*/

extern "C" M2Graph_Graph M2Graph_InitGraph (void);

/*
   KillGraph - deletes graph and all nodes.
*/

extern "C" void M2Graph_KillGraph (M2Graph_Graph *g);

/*
   AddDependent - adds moduleSym <- dependSym into the graph.
*/

extern "C" void M2Graph_AddDependent (M2Graph_Graph graph, unsigned int moduleSym, unsigned int dependSym);

/*
   SortGraph - returns a List containing the sorted graph.
*/

extern "C" Lists_List M2Graph_SortGraph (M2Graph_Graph g, unsigned int topModule);

/*
   KillNode - deletes the dynamic storage associated with nptr.
*/

static void KillNode (M2Graph_node nptr);

/*
   initNode - create a new node in graph and return the node.
*/

static M2Graph_node initNode (M2Graph_Graph__opaque graph, unsigned int moduleSym);

/*
   getNode - returns a node from graph representing moduleSym.
             If the node does not exist it is created.
*/

static M2Graph_node getNode (M2Graph_Graph__opaque graph, unsigned int moduleSym);

/*
   createDependent - mptr imports from dptr.
*/

static void createDependent (M2Graph_node mptr, M2Graph_node dptr);

/*
   resolveImports - recursively resolve imports using ISO Modula-2
                    rules for the order of module initialization.
*/

static void resolveImports (Lists_List sorted, M2Graph_node nptr);

/*
   setNodesInitial - changes the state of all nodes in graph to initial.
*/

static void setNodesInitial (M2Graph_Graph__opaque g);


/*
   KillNode - deletes the dynamic storage associated with nptr.
*/

static void KillNode (M2Graph_node nptr)
{
  nptr->deps = Indexing_KillIndex (nptr->deps);
}


/*
   initNode - create a new node in graph and return the node.
*/

static M2Graph_node initNode (M2Graph_Graph__opaque graph, unsigned int moduleSym)
{
  M2Graph_node nptr;

  Storage_ALLOCATE ((void **) &nptr, sizeof (M2Graph__T2));
  nptr->moduleSym = moduleSym;
  nptr->deps = Indexing_InitIndex (1);
  nptr->nstate = M2Graph_initial;
  Indexing_IncludeIndiceIntoIndex (graph->nodes, reinterpret_cast <void *> (nptr));
  return nptr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getNode - returns a node from graph representing moduleSym.
             If the node does not exist it is created.
*/

static M2Graph_node getNode (M2Graph_Graph__opaque graph, unsigned int moduleSym)
{
  unsigned int i;
  unsigned int n;
  M2Graph_node nptr;

  i = 1;
  n = Indexing_HighIndice (graph->nodes);
  while (i <= n)
    {
      nptr = static_cast<M2Graph_node> (Indexing_GetIndice (graph->nodes, i));
      if (nptr->moduleSym == moduleSym)
        {
          return nptr;
        }
      i += 1;
    }
  return initNode (graph, moduleSym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   createDependent - mptr imports from dptr.
*/

static void createDependent (M2Graph_node mptr, M2Graph_node dptr)
{
  Indexing_IncludeIndiceIntoIndex (mptr->deps, reinterpret_cast <void *> (dptr));
}


/*
   resolveImports - recursively resolve imports using ISO Modula-2
                    rules for the order of module initialization.
*/

static void resolveImports (Lists_List sorted, M2Graph_node nptr)
{
  unsigned int i;
  unsigned int n;
  NameKey_Name libname;
  NameKey_Name name;

  if (nptr->nstate == M2Graph_initial)
    {
      nptr->nstate = M2Graph_started;
      name = SymbolTable_GetSymName (nptr->moduleSym);
      libname = SymbolTable_GetLibName (nptr->moduleSym);
      i = 1;
      n = Indexing_HighIndice (nptr->deps);
      if (Debugging)
        {
          M2Printf_printf3 ((const char *) "resolving %a [%a] %d dependents\\n", 33, (const unsigned char *) &name, (sizeof (name)-1), (const unsigned char *) &libname, (sizeof (libname)-1), (const unsigned char *) &n, (sizeof (n)-1));
        }
      while (i <= n)
        {
          resolveImports (sorted, reinterpret_cast <M2Graph_node> (Indexing_GetIndice (nptr->deps, i)));
          i += 1;
        }
      nptr->nstate = M2Graph_ordered;
      Lists_IncludeItemIntoList (sorted, nptr->moduleSym);
    }
}


/*
   setNodesInitial - changes the state of all nodes in graph to initial.
*/

static void setNodesInitial (M2Graph_Graph__opaque g)
{
  unsigned int i;
  unsigned int n;
  M2Graph_node nptr;

  i = 1;
  n = Indexing_HighIndice (g->nodes);
  while (i <= n)
    {
      nptr = static_cast<M2Graph_node> (Indexing_GetIndice (g->nodes, i));
      nptr->nstate = M2Graph_initial;
      i += 1;
    }
}


/*
   InitGraph - creates and returns an empty graph.
*/

extern "C" M2Graph_Graph M2Graph_InitGraph (void)
{
  M2Graph_Graph__opaque g;

  Storage_ALLOCATE ((void **) &g, sizeof (M2Graph__T1));
  g->nodes = Indexing_InitIndex (1);
  return static_cast<M2Graph_Graph> (g);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillGraph - deletes graph and all nodes.
*/

extern "C" void M2Graph_KillGraph (M2Graph_Graph *g)
{
  unsigned int i;
  unsigned int n;
  M2Graph_node nptr;

  n = Indexing_HighIndice (static_cast<M2Graph_Graph__opaque> ((*g))->nodes);
  i = 1;
  while (i <= n)
    {
      nptr = static_cast<M2Graph_node> (Indexing_GetIndice (static_cast<M2Graph_Graph__opaque> ((*g))->nodes, i));
      KillNode (nptr);
      i += 1;
    }
  (*g) = static_cast<M2Graph_Graph> (NULL);
}


/*
   AddDependent - adds moduleSym <- dependSym into the graph.
*/

extern "C" void M2Graph_AddDependent (M2Graph_Graph graph, unsigned int moduleSym, unsigned int dependSym)
{
  M2Graph_node mptr;
  M2Graph_node dptr;

  if (((SymbolTable_IsModule (moduleSym)) || (! (SymbolTable_IsDefinitionForC (moduleSym)))) && ((SymbolTable_IsModule (dependSym)) || (! (SymbolTable_IsDefinitionForC (dependSym)))))
    {
      mptr = getNode (static_cast<M2Graph_Graph__opaque> (graph), moduleSym);
      dptr = getNode (static_cast<M2Graph_Graph__opaque> (graph), dependSym);
      createDependent (mptr, dptr);
    }
}


/*
   SortGraph - returns a List containing the sorted graph.
*/

extern "C" Lists_List M2Graph_SortGraph (M2Graph_Graph g, unsigned int topModule)
{
  Lists_List sorted;
  M2Graph_node nptr;

  Lists_InitList (&sorted);
  setNodesInitial (static_cast<M2Graph_Graph__opaque> (g));
  nptr = getNode (static_cast<M2Graph_Graph__opaque> (g), topModule);
  resolveImports (sorted, nptr);
  Lists_RemoveItemFromList (sorted, topModule);
  Lists_IncludeItemIntoList (sorted, topModule);  /* Ensure topModule is last.  */
  return sorted;  /* Ensure topModule is last.  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Graph_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Graph_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
