/* src/bazaar.p/bz-age-rating-attribute.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include "bz-context-row.h"

G_BEGIN_DECLS



#define BZ_TYPE_AGE_RATING_ATTRIBUTE (bz_age_rating_attribute_get_type ())
G_DECLARE_FINAL_TYPE (BzAgeRatingAttribute, bz_age_rating_attribute, BZ, AGE_RATING_ATTRIBUTE, GObject)

BzAgeRatingAttribute *
bz_age_rating_attribute_new (void);

BzImportance
bz_age_rating_attribute_get_importance (BzAgeRatingAttribute *self);

const char *
bz_age_rating_attribute_get_id (BzAgeRatingAttribute *self);

const char *
bz_age_rating_attribute_get_title (BzAgeRatingAttribute *self);

const char *
bz_age_rating_attribute_get_description (BzAgeRatingAttribute *self);

const char *
bz_age_rating_attribute_get_icon_name (BzAgeRatingAttribute *self);

void
bz_age_rating_attribute_set_importance (BzAgeRatingAttribute *self,
    BzImportance importance);

void
bz_age_rating_attribute_set_id (BzAgeRatingAttribute *self,
    const char *id);

void
bz_age_rating_attribute_set_title (BzAgeRatingAttribute *self,
    const char *title);

void
bz_age_rating_attribute_set_description (BzAgeRatingAttribute *self,
    const char *description);

void
bz_age_rating_attribute_set_icon_name (BzAgeRatingAttribute *self,
    const char *icon_name);

G_END_DECLS

/* End of src/bazaar.p/bz-age-rating-attribute.h */
