/* budgie_desktop_view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from budgie_desktop_view.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>

#define RAVEN_DBUS_NAME "org.budgie_desktop.Raven"
#define RAVEN_DBUS_OBJECT_PATH "/org/budgie_desktop/Raven"
#define ITEM_MARGIN 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RAVEN (raven_get_type ())
#define RAVEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAVEN, Raven))
#define IS_RAVEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAVEN))
#define RAVEN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RAVEN, RavenIface))

typedef struct _Raven Raven;
typedef struct _RavenIface RavenIface;

#define TYPE_RAVEN_PROXY (raven_proxy_get_type ())
typedef GDBusProxy RavenProxy;
typedef GDBusProxyClass RavenProxyClass;
typedef struct _raven_DismissReadyData raven_DismissReadyData;
typedef enum  {
	DESKTOP_ITEM_SIZE_SMALL = 0,
	DESKTOP_ITEM_SIZE_NORMAL = 1,
	DESKTOP_ITEM_SIZE_LARGE = 2,
	DESKTOP_ITEM_SIZE_MASSIVE = 3
} DesktopItemSize;

#define TYPE_DESKTOP_ITEM_SIZE (desktop_item_size_get_type ())

#define TYPE_DESKTOP_VIEW (desktop_view_get_type ())
#define DESKTOP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_VIEW, DesktopView))
#define DESKTOP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_VIEW, DesktopViewClass))
#define IS_DESKTOP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_VIEW))
#define IS_DESKTOP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_VIEW))
#define DESKTOP_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_VIEW, DesktopViewClass))

typedef struct _DesktopView DesktopView;
typedef struct _DesktopViewClass DesktopViewClass;
typedef struct _DesktopViewPrivate DesktopViewPrivate;

#define TYPE_UNIFIED_PROPS (unified_props_get_type ())
#define UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIFIED_PROPS, UnifiedProps))
#define UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIFIED_PROPS, UnifiedPropsClass))
#define IS_UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIFIED_PROPS))
#define IS_UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIFIED_PROPS))
#define UNIFIED_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIFIED_PROPS, UnifiedPropsClass))

typedef struct _UnifiedProps UnifiedProps;
typedef struct _UnifiedPropsClass UnifiedPropsClass;

#define TYPE_DESKTOP_MENU (desktop_menu_get_type ())
#define DESKTOP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_MENU, DesktopMenu))
#define DESKTOP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_MENU, DesktopMenuClass))
#define IS_DESKTOP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_MENU))
#define IS_DESKTOP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_MENU))
#define DESKTOP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_MENU, DesktopMenuClass))

typedef struct _DesktopMenu DesktopMenu;
typedef struct _DesktopMenuClass DesktopMenuClass;

#define TYPE_DESKTOP_ITEM (desktop_item_get_type ())
#define DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_ITEM, DesktopItem))
#define DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_ITEM, DesktopItemClass))
#define IS_DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_ITEM))
#define IS_DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_ITEM))
#define DESKTOP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_ITEM, DesktopItemClass))

typedef struct _DesktopItem DesktopItem;
typedef struct _DesktopItemClass DesktopItemClass;

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;

#define TYPE_MOUNT_ITEM (mount_item_get_type ())
#define MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ITEM, MountItem))
#define MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ITEM, MountItemClass))
#define IS_MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ITEM))
#define IS_MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ITEM))
#define MOUNT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ITEM, MountItemClass))

typedef struct _MountItem MountItem;
typedef struct _MountItemClass MountItemClass;
enum  {
	DESKTOP_VIEW_0_PROPERTY,
	DESKTOP_VIEW_NUM_PROPERTIES
};
static GParamSpec* desktop_view_properties[DESKTOP_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRectangle_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FILE_MENU (file_menu_get_type ())
#define FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_MENU, FileMenu))
#define FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_MENU, FileMenuClass))
#define IS_FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_MENU))
#define IS_FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_MENU))
#define FILE_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_MENU, FileMenuClass))

typedef struct _FileMenu FileMenu;
typedef struct _FileMenuClass FileMenuClass;
typedef struct _UnifiedPropsPrivate UnifiedPropsPrivate;
typedef struct _DesktopItemPrivate DesktopItemPrivate;
typedef struct _FileItemPrivate FileItemPrivate;
typedef struct _Block1Data Block1Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _MountItemPrivate MountItemPrivate;

struct _RavenIface {
	GTypeInterface parent_iface;
	void (*Dismiss) (Raven* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Dismiss_finish) (Raven* self, GAsyncResult* _res_, GError** error);
};

struct _raven_DismissReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _DesktopView {
	GtkApplicationWindow parent_instance;
	DesktopViewPrivate * priv;
};

struct _DesktopViewClass {
	GtkApplicationWindowClass parent_class;
};

struct _DesktopViewPrivate {
	GdkScreen* default_screen;
	GdkDisplay* default_display;
	GdkMonitor* primary_monitor;
	GdkRectangle* primary_monitor_geo;
	UnifiedProps* shared_props;
	Raven* raven;
	DesktopItemSize* item_size;
	gint* max_allocated_item_height;
	gint* max_allocated_item_width;
	gboolean show_home;
	gboolean show_mounts;
	gboolean show_trash;
	gboolean visible_setting;
	DesktopMenu* desktop_menu;
	GtkFlowBox* flow;
	GFile* desktop_file;
	gchar* desktop_file_uri;
	GFileMonitor* desktop_monitor;
	GVolumeMonitor* volume_monitor;
	FileItem* home_item;
	FileItem* trash_item;
	GHashTable* mount_items;
	GHashTable* file_items;
	GCompareFunc file_cmp;
};

struct _UnifiedProps {
	GObject parent_instance;
	UnifiedPropsPrivate * priv;
	GHashTable* files_currently_copying;
	gboolean is_launching;
	GdkCursor* blocked_cursor;
	GdkCursor* hand_cursor;
	GdkCursor* loading_cursor;
	GdkAppLaunchContext* launch_context;
	FileMenu* file_menu;
	GtkIconTheme* icon_theme;
	gint* icon_size;
	gint* s_factor;
};

struct _UnifiedPropsClass {
	GObjectClass parent_class;
};

struct _DesktopItem {
	GtkFlowBoxChild parent_instance;
	DesktopItemPrivate * priv;
	UnifiedProps* props;
	gint _label_width;
	gboolean _copying;
	gboolean _mount;
	gchar* _name;
	gchar* _type;
	gboolean _special_dir;
	GtkImage* image;
	GtkLabel* label;
	GtkEventBox* event_box;
	GtkBox* main_layout;
	GdkPixbuf* original_image_pixbuf;
	GIcon* icon;
};

struct _DesktopItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _FileItem {
	DesktopItem parent_instance;
	FileItemPrivate * priv;
	GFile* file;
	GFileInfo* info;
	GDesktopAppInfo* app_info;
	GKeyFile* keyfile;
	gboolean exclude_item;
};

struct _FileItemClass {
	DesktopItemClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	DesktopView* self;
	GFile* this_file;
	gchar* proposed_file_name;
	GFile* target_file;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GCancellable* file_cancellable;
};

struct _Block3Data {
	int _ref_count_;
	DesktopView* self;
	GFile* create_file_ref;
	GFile* file;
};

struct _MountItem {
	DesktopItem parent_instance;
	MountItemPrivate * priv;
	GMount* mount;
	GFile* mount_file;
	gchar* uuid;
};

struct _MountItemClass {
	DesktopItemClass parent_class;
};

static gint DesktopView_private_offset;
static gpointer desktop_view_parent_class = NULL;

VALA_EXTERN GType raven_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint raven_register_object (void* object,
                             GDBusConnection* connection,
                             const gchar* path,
                             GError** error);
VALA_EXTERN GType raven_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Raven, g_object_unref)
VALA_EXTERN void raven_Dismiss (Raven* self,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_);
VALA_EXTERN void raven_Dismiss_finish (Raven* self,
                           GAsyncResult* _res_,
                           GError** error);
static GType raven_get_type_once (void);
static void raven_proxy_g_signal (GDBusProxy* proxy,
                           const gchar* sender_name,
                           const gchar* signal_name,
                           GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void raven_proxy_Dismiss_async (Raven* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static void raven_proxy_Dismiss_finish (Raven* self,
                                 GAsyncResult* _res_,
                                 GError** error);
static void raven_proxy_raven_interface_init (RavenIface* iface);
static void _dbus_raven_Dismiss (Raven* self,
                          GVariant* _parameters_,
                          GDBusMethodInvocation* invocation);
static void _dbus_raven_Dismiss_ready (GObject * source_object,
                                GAsyncResult * _res_,
                                gpointer _user_data_);
static void raven_dbus_interface_method_call (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* method_name,
                                       GVariant* parameters,
                                       GDBusMethodInvocation* invocation,
                                       gpointer user_data);
static GVariant* raven_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data);
static gboolean raven_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data);
static void _raven_unregister_object (gpointer user_data);
VALA_EXTERN GType desktop_item_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType desktop_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopView, g_object_unref)
VALA_EXTERN GType unified_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnifiedProps, g_object_unref)
VALA_EXTERN GType desktop_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopMenu, g_object_unref)
VALA_EXTERN GType desktop_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopItem, g_object_unref)
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN GType mount_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountItem, g_object_unref)
static void _vala_GdkRectangle_free (GdkRectangle* self);
VALA_EXTERN DesktopView* desktop_view_new (GtkApplication* app);
VALA_EXTERN DesktopView* desktop_view_construct (GType object_type,
                                     GtkApplication* app);
VALA_EXTERN UnifiedProps* unified_props_new (void);
VALA_EXTERN UnifiedProps* unified_props_construct (GType object_type);
static void __lambda12_ (DesktopView* self,
                  GdkCursor* cursor);
static void ___lambda12__unified_props_cursor_changed (UnifiedProps* _sender,
                                                GdkCursor* cursor,
                                                gpointer self);
VALA_EXTERN void desktop_view_refresh_icon_sizes (DesktopView* self);
static void _desktop_view_refresh_icon_sizes_unified_props_thumbnail_size_changed (UnifiedProps* _sender,
                                                                            gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void unified_props_set_desktop_settings (UnifiedProps* self,
                                         GSettings* value);
VALA_EXTERN GSettings* unified_props_get_desktop_settings (UnifiedProps* self);
static void desktop_view_create_fileitem_sorter (DesktopView* self);
static void desktop_view_on_icon_size_changed (DesktopView* self);
static void _desktop_view_on_icon_size_changed_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self);
static void desktop_view_on_show_changed (DesktopView* self);
static void _desktop_view_on_show_changed_g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self);
VALA_EXTERN void desktop_view_on_show_active_mounts_changed (DesktopView* self);
static void _desktop_view_on_show_active_mounts_changed_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
VALA_EXTERN void desktop_view_on_show_home_folder_changed (DesktopView* self);
static void _desktop_view_on_show_home_folder_changed_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self);
VALA_EXTERN void desktop_view_on_show_trash_folder_changed (DesktopView* self);
static void _desktop_view_on_show_trash_folder_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self);
static void desktop_view_on_file_changed (DesktopView* self,
                                   GFile* file,
                                   GFile* other_file,
                                   GFileMonitorEvent type);
static void _desktop_view_on_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                           GFile* file,
                                                           GFile* other_file,
                                                           GFileMonitorEvent event_type,
                                                           gpointer self);
VALA_EXTERN void desktop_view_on_mount_added (DesktopView* self,
                                  GMount* mount);
static void _desktop_view_on_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                GMount* mount,
                                                                gpointer self);
VALA_EXTERN DesktopMenu* desktop_menu_new (void);
VALA_EXTERN DesktopMenu* desktop_menu_construct (GType object_type);
VALA_EXTERN FileMenu* file_menu_new (UnifiedProps* p);
VALA_EXTERN FileMenu* file_menu_construct (GType object_type,
                               UnifiedProps* p);
VALA_EXTERN GType file_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileMenu, g_object_unref)
static gint desktop_view_sorter (DesktopView* self,
                          GtkFlowBoxChild* child_one,
                          GtkFlowBoxChild* child_two);
static gint _desktop_view_sorter_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                  GtkFlowBoxChild* child2,
                                                  gpointer self);
static void desktop_view_get_display_geo (DesktopView* self);
VALA_EXTERN void desktop_view_set_window_transparent (DesktopView* self);
static void _desktop_view_set_window_transparent_gdk_screen_composited_changed (GdkScreen* _sender,
                                                                         gpointer self);
static void desktop_view_on_resolution_change (DesktopView* self);
static void _desktop_view_on_resolution_change_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                     gpointer self);
static void _desktop_view_on_resolution_change_gdk_screen_size_changed (GdkScreen* _sender,
                                                                 gpointer self);
VALA_EXTERN void desktop_view_setup_root_window_event_handler (DesktopView* self);
static void desktop_view_on_icon_theme_changed (DesktopView* self);
static void _desktop_view_on_icon_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                                 gpointer self);
static void desktop_view_get_item_size (DesktopView* self);
VALA_EXTERN void desktop_view_create_special_folders (DesktopView* self);
VALA_EXTERN void desktop_view_get_all_active_mounts (DesktopView* self);
static void desktop_view_get_all_desktop_files (DesktopView* self);
static void desktop_view_enforce_content_limit (DesktopView* self);
VALA_EXTERN gboolean desktop_view_on_key_pressed (DesktopView* self,
                                      GdkEventKey* key);
static gboolean _desktop_view_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                  GdkEventKey* event,
                                                                  gpointer self);
static gboolean desktop_view_on_button_release (DesktopView* self,
                                         GdkEventButton* event);
static gboolean _desktop_view_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self);
static void desktop_view_on_drag_data_received (DesktopView* self,
                                         GtkWidget* widget,
                                         GdkDragContext* c,
                                         gint x,
                                         gint y,
                                         GtkSelectionData* d,
                                         guint info,
                                         guint time);
static void _desktop_view_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        gint x,
                                                                        gint y,
                                                                        GtkSelectionData* selection_data,
                                                                        guint info,
                                                                        guint time_,
                                                                        gpointer self);
static void desktop_view_has_raven (DesktopView* self);
static void _desktop_view_has_raven_gbus_name_appeared_callback (GDBusConnection* connection,
                                                          const gchar* name,
                                                          const gchar* name_owner,
                                                          gpointer self);
static void desktop_view_on_raven_lost (DesktopView* self);
static void _desktop_view_on_raven_lost_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
VALA_EXTERN void desktop_view_clear_selection (DesktopView* self);
VALA_EXTERN void desktop_view_create_file_item (DesktopView* self,
                                    GFile* f,
                                    GFileInfo* info,
                                    gboolean skip_resort);
VALA_EXTERN FileItem* file_item_new (UnifiedProps* p,
                         GFile* f,
                         GFileInfo* finfo,
                         GIcon* override_icon);
VALA_EXTERN FileItem* file_item_construct (GType object_type,
                               UnifiedProps* p,
                               GFile* f,
                               GFileInfo* finfo,
                               GIcon* override_icon);
VALA_EXTERN void desktop_item_request_show (DesktopItem* self);
VALA_EXTERN void desktop_view_create_mount_item (DesktopView* self,
                                     GMount* mount,
                                     const gchar* uuid,
                                     gboolean skip_resort);
VALA_EXTERN MountItem* mount_item_new (UnifiedProps* p,
                           GMount* provided_mount,
                           const gchar* true_uuid);
VALA_EXTERN MountItem* mount_item_construct (GType object_type,
                                 UnifiedProps* p,
                                 GMount* provided_mount,
                                 const gchar* true_uuid);
VALA_EXTERN void desktop_view_on_mount_removed (DesktopView* self,
                                    MountItem* mount_item);
static void _desktop_view_on_mount_removed_mount_item_drive_disconnected (MountItem* _sender,
                                                                   MountItem* item,
                                                                   gpointer self);
static void __lambda19_ (DesktopView* self);
static void ___lambda19__mount_item_mount_name_changed (MountItem* _sender,
                                                 MountItem* item,
                                                 gpointer self);
VALA_EXTERN FileItem* desktop_view_create_special_file_item (DesktopView* self,
                                                 const gchar* item_type);
VALA_EXTERN void desktop_item_set_is_special (DesktopItem* self,
                                  gboolean value);
VALA_EXTERN void file_item_set_file_type (FileItem* self,
                              const gchar* value);
VALA_EXTERN void desktop_item_set_label_name (DesktopItem* self,
                                  const gchar* value);
VALA_EXTERN void desktop_view_delete_item (DesktopView* self,
                               GFile* f);
VALA_EXTERN void desktop_view_dismiss_raven (DesktopView* self);
static void ___lambda15_ (DesktopView* self,
                   GtkWidget* item);
static void ____lambda15__gfunc (gconstpointer data,
                          gpointer self);
static void __lambda27_ (DesktopView* self,
                  GDrive* drive);
static void __lambda28_ (DesktopView* self,
                  GVolume* volume);
VALA_EXTERN gchar* desktop_view_get_mount_uuid (DesktopView* self,
                                    GMount* mount);
static void ___lambda28__gfunc (gconstpointer data,
                         gpointer self);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ___lambda27__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda20_ (DesktopView* self);
VALA_EXTERN void unified_props_set_current_cursor (UnifiedProps* self,
                                       GdkCursor* value);
static void ___lambda20__g_app_launch_context_launch_started (GAppLaunchContext* _sender,
                                                       GAppInfo* info,
                                                       GVariant* platform_data,
                                                       gpointer self);
static void __lambda21_ (DesktopView* self);
static void ___lambda21__g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                      const gchar* startup_notify_id,
                                                      gpointer self);
static void __lambda22_ (DesktopView* self);
static void ___lambda22__g_app_launch_context_launched (GAppLaunchContext* _sender,
                                                 GAppInfo* info,
                                                 GVariant* platform_data,
                                                 gpointer self);
static GdkRectangle* _vala_GdkRectangle_copy (GdkRectangle* self);
static gint* _int_dup (gint* self);
static void desktop_view_update_window_position (DesktopView* self);
static DesktopItemSize* _desktop_item_size_dup (DesktopItemSize* self);
static gboolean _desktop_item_size_equal (const DesktopItemSize * s1,
                                   const DesktopItemSize * s2);
static void desktop_view_on_raven_get (DesktopView* self,
                                GObject* obj,
                                GAsyncResult* res);
static void _desktop_view_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                       GAsyncResult* res,
                                                       gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _____lambda29_ (Block2Data* _data2_,
                     GObject* obj,
                     GAsyncResult* res);
static void desktop_view_update_item_saturation (DesktopView* self,
                                          const gchar* item_name);
static void ______lambda29__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda17_ (Block3Data* _data3_);
static gboolean ____lambda17__gsource_func (gpointer self);
static gboolean ___lambda18_ (Block3Data* _data3_);
VALA_EXTERN void desktop_item_set_icon (DesktopItem* self,
                            GIcon* ico,
                            GError** error);
VALA_EXTERN GThemedIcon* file_item_get_mimetype_icon (FileItem* self);
static gboolean ____lambda18__gsource_func (gpointer self);
VALA_EXTERN void file_item_update_icon (FileItem* self,
                            GError** error);
static void __lambda25_ (DesktopView* self,
                  const gchar* key,
                  MountItem* mount_item);
static void ___lambda25__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void __lambda26_ (DesktopView* self,
                  const gchar* key,
                  FileItem* file_item);
static void ___lambda26__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
VALA_EXTERN gboolean desktop_item_get_is_special (DesktopItem* self);
VALA_EXTERN gboolean desktop_item_get_is_mount (DesktopItem* self);
VALA_EXTERN void file_item_move_to_trash (FileItem* self);
VALA_EXTERN void mount_item_launch (MountItem* self);
VALA_EXTERN void file_item_launch (FileItem* self,
                       gboolean in_terminal);
static gboolean __lambda23_ (DesktopView* self);
static gboolean ___lambda23__gsource_func (gpointer self);
static void __lambda13_ (DesktopView* self,
                  const gchar* key,
                  MountItem* mount_item);
VALA_EXTERN void desktop_item_set_icon_factors (DesktopItem* self,
                                    GError** error);
static void ___lambda13__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void __lambda14_ (DesktopView* self,
                  const gchar* key,
                  FileItem* file_item);
static void ___lambda14__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static GdkFilterReturn __lambda24_ (DesktopView* self,
                             GdkXEvent* xevent,
                             GdkEvent* e);
static GdkFilterReturn ___lambda24__gdk_filter_func (GdkXEvent* xevent,
                                              GdkEvent* event,
                                              gpointer self);
static gint __lambda16_ (FileItem* c1,
                  FileItem* c2);
VALA_EXTERN const gchar* desktop_item_get_item_type (DesktopItem* self);
VALA_EXTERN const gchar* desktop_item_get_label_name (DesktopItem* self);
static gint ___lambda16__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN gboolean unified_props_is_copying (UnifiedProps* self,
                                   const gchar* file_name);
VALA_EXTERN void desktop_item_set_is_copying (DesktopItem* self,
                                  gboolean value);
static void desktop_view_finalize (GObject * obj);
static GType desktop_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo * const _raven_dbus_arg_info_Dismiss_in[] = {NULL};
static const GDBusArgInfo * const _raven_dbus_arg_info_Dismiss_out[] = {NULL};
static const GDBusMethodInfo _raven_dbus_method_info_Dismiss = {-1, "Dismiss", (GDBusArgInfo **) (&_raven_dbus_arg_info_Dismiss_in), (GDBusArgInfo **) (&_raven_dbus_arg_info_Dismiss_out), NULL};
static const GDBusMethodInfo * const _raven_dbus_method_info[] = {&_raven_dbus_method_info_Dismiss, NULL};
static const GDBusSignalInfo * const _raven_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _raven_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _raven_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_raven_dbus_method_info), (GDBusSignalInfo **) (&_raven_dbus_signal_info), (GDBusPropertyInfo **) (&_raven_dbus_property_info), NULL};
static const GDBusInterfaceVTable _raven_dbus_interface_vtable = {raven_dbus_interface_method_call, raven_dbus_interface_get_property, raven_dbus_interface_set_property};
const gchar* SUPPORTED_TERMINALS[8] = {"alacritty", "gnome-terminal", "kgx", "kitty", "konsole", "mate-terminal", "terminator", "tilix"};

void
raven_Dismiss (Raven* self,
               GAsyncReadyCallback _callback_,
               gpointer _user_data_)
{
	RavenIface* _iface_;
	_iface_ = RAVEN_GET_INTERFACE (self);
	if (_iface_->Dismiss) {
		_iface_->Dismiss (self, _callback_, _user_data_);
	}
}

void
raven_Dismiss_finish (Raven* self,
                      GAsyncResult* _res_,
                      GError** error)
{
	RavenIface* _iface_;
	_iface_ = RAVEN_GET_INTERFACE (self);
	if (_iface_->Dismiss_finish) {
		_iface_->Dismiss_finish (self, _res_, error);
	}
}

static void
raven_default_init (RavenIface * iface,
                    gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
raven_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RavenIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType raven_type_id;
	raven_type_id = g_type_register_static (G_TYPE_INTERFACE, "Raven", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (raven_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (raven_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) raven_proxy_get_type);
	g_type_set_qdata (raven_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Raven");
	g_type_set_qdata (raven_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_raven_dbus_interface_info));
	g_type_set_qdata (raven_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) raven_register_object);
	return raven_type_id;
}

GType
raven_get_type (void)
{
	static volatile gsize raven_type_id__once = 0;
	if (g_once_init_enter (&raven_type_id__once)) {
		GType raven_type_id;
		raven_type_id = raven_get_type_once ();
		g_once_init_leave (&raven_type_id__once, raven_type_id);
	}
	return raven_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (RavenProxy, raven_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RAVEN, raven_proxy_raven_interface_init) )
static void
raven_proxy_class_init (RavenProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = raven_proxy_g_signal;
}

static void
raven_proxy_g_signal (GDBusProxy* proxy,
                      const gchar* sender_name,
                      const gchar* signal_name,
                      GVariant* parameters)
{
}

static void
raven_proxy_init (RavenProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_raven_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
raven_proxy_Dismiss_async (Raven* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "Dismiss");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
raven_proxy_Dismiss_finish (Raven* self,
                            GAsyncResult* _res_,
                            GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
raven_proxy_raven_interface_init (RavenIface* iface)
{
	iface->Dismiss = raven_proxy_Dismiss_async;
	iface->Dismiss_finish = raven_proxy_Dismiss_finish;
}

static void
_dbus_raven_Dismiss (Raven* self,
                     GVariant* _parameters_,
                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	raven_DismissReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (raven_DismissReadyData);
	_ready_data->_invocation_ = invocation;
	raven_Dismiss (self, (GAsyncReadyCallback) _dbus_raven_Dismiss_ready, _ready_data);
}

static void
_dbus_raven_Dismiss_ready (GObject * source_object,
                           GAsyncResult * _res_,
                           gpointer _user_data_)
{
	raven_DismissReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	raven_Dismiss_finish ((Raven*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (raven_DismissReadyData, _ready_data);
}

static void
raven_dbus_interface_method_call (GDBusConnection* connection,
                                  const gchar* sender,
                                  const gchar* object_path,
                                  const gchar* interface_name,
                                  const gchar* method_name,
                                  GVariant* parameters,
                                  GDBusMethodInvocation* invocation,
                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Dismiss") == 0) {
		_dbus_raven_Dismiss (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
raven_dbus_interface_get_property (GDBusConnection* connection,
                                   const gchar* sender,
                                   const gchar* object_path,
                                   const gchar* interface_name,
                                   const gchar* property_name,
                                   GError** error,
                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
raven_dbus_interface_set_property (GDBusConnection* connection,
                                   const gchar* sender,
                                   const gchar* object_path,
                                   const gchar* interface_name,
                                   const gchar* property_name,
                                   GVariant* value,
                                   GError** error,
                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
raven_register_object (gpointer object,
                       GDBusConnection* connection,
                       const gchar* path,
                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_raven_dbus_interface_info), &_raven_dbus_interface_vtable, data, _raven_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_raven_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

 G_GNUC_NO_INLINE static GType
desktop_item_size_get_type_once (void)
{
	static const GEnumValue values[] = {{DESKTOP_ITEM_SIZE_SMALL, "DESKTOP_ITEM_SIZE_SMALL", "small"}, {DESKTOP_ITEM_SIZE_NORMAL, "DESKTOP_ITEM_SIZE_NORMAL", "normal"}, {DESKTOP_ITEM_SIZE_LARGE, "DESKTOP_ITEM_SIZE_LARGE", "large"}, {DESKTOP_ITEM_SIZE_MASSIVE, "DESKTOP_ITEM_SIZE_MASSIVE", "massive"}, {0, NULL, NULL}};
	GType desktop_item_size_type_id;
	desktop_item_size_type_id = g_enum_register_static ("DesktopItemSize", values);
	return desktop_item_size_type_id;
}

GType
desktop_item_size_get_type (void)
{
	static volatile gsize desktop_item_size_type_id__once = 0;
	if (g_once_init_enter (&desktop_item_size_type_id__once)) {
		GType desktop_item_size_type_id;
		desktop_item_size_type_id = desktop_item_size_get_type_once ();
		g_once_init_leave (&desktop_item_size_type_id__once, desktop_item_size_type_id);
	}
	return desktop_item_size_type_id__once;
}

static inline gpointer
desktop_view_get_instance_private (DesktopView* self)
{
	return G_STRUCT_MEMBER_P (self, DesktopView_private_offset);
}

static void
_vala_GdkRectangle_free (GdkRectangle* self)
{
	g_boxed_free (gdk_rectangle_get_type (), self);
}

static void
__lambda12_ (DesktopView* self,
             GdkCursor* cursor)
{
	GdkWindow* _tmp0_;
	g_return_if_fail (cursor != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, cursor);
}

static void
___lambda12__unified_props_cursor_changed (UnifiedProps* _sender,
                                           GdkCursor* cursor,
                                           gpointer self)
{
	__lambda12_ ((DesktopView*) self, cursor);
}

static void
_desktop_view_refresh_icon_sizes_unified_props_thumbnail_size_changed (UnifiedProps* _sender,
                                                                       gpointer self)
{
	desktop_view_refresh_icon_sizes ((DesktopView*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_desktop_view_on_icon_size_changed_g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self)
{
	desktop_view_on_icon_size_changed ((DesktopView*) self);
}

static void
_desktop_view_on_show_changed_g_settings_changed (GSettings* _sender,
                                                  const gchar* key,
                                                  gpointer self)
{
	desktop_view_on_show_changed ((DesktopView*) self);
}

static void
_desktop_view_on_show_active_mounts_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	desktop_view_on_show_active_mounts_changed ((DesktopView*) self);
}

static void
_desktop_view_on_show_home_folder_changed_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self)
{
	desktop_view_on_show_home_folder_changed ((DesktopView*) self);
}

static void
_desktop_view_on_show_trash_folder_changed_g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self)
{
	desktop_view_on_show_trash_folder_changed ((DesktopView*) self);
}

static void
_desktop_view_on_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                      GFile* file,
                                                      GFile* other_file,
                                                      GFileMonitorEvent event_type,
                                                      gpointer self)
{
	desktop_view_on_file_changed ((DesktopView*) self, file, other_file, event_type);
}

static void
_desktop_view_on_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                           GMount* mount,
                                                           gpointer self)
{
	desktop_view_on_mount_added ((DesktopView*) self, mount);
}

static gint
_desktop_view_sorter_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                             GtkFlowBoxChild* child2,
                                             gpointer self)
{
	gint result;
	result = desktop_view_sorter ((DesktopView*) self, child1, child2);
	return result;
}

static void
_desktop_view_set_window_transparent_gdk_screen_composited_changed (GdkScreen* _sender,
                                                                    gpointer self)
{
	desktop_view_set_window_transparent ((DesktopView*) self);
}

static void
_desktop_view_on_resolution_change_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                gpointer self)
{
	desktop_view_on_resolution_change ((DesktopView*) self);
}

static void
_desktop_view_on_resolution_change_gdk_screen_size_changed (GdkScreen* _sender,
                                                            gpointer self)
{
	desktop_view_on_resolution_change ((DesktopView*) self);
}

static void
_desktop_view_on_icon_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                            gpointer self)
{
	desktop_view_on_icon_theme_changed ((DesktopView*) self);
}

static gboolean
_desktop_view_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                         GdkEventKey* event,
                                                         gpointer self)
{
	gboolean result;
	result = desktop_view_on_key_pressed ((DesktopView*) self, event);
	return result;
}

static gboolean
_desktop_view_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                 GdkEventButton* event,
                                                                 gpointer self)
{
	gboolean result;
	result = desktop_view_on_button_release ((DesktopView*) self, event);
	return result;
}

static void
_desktop_view_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   gint x,
                                                                   gint y,
                                                                   GtkSelectionData* selection_data,
                                                                   guint info,
                                                                   guint time_,
                                                                   gpointer self)
{
	desktop_view_on_drag_data_received ((DesktopView*) self, _sender, context, x, y, selection_data, info, time_);
}

static void
_desktop_view_has_raven_gbus_name_appeared_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     const gchar* name_owner,
                                                     gpointer self)
{
	desktop_view_has_raven ((DesktopView*) self);
}

static void
_desktop_view_on_raven_lost_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	desktop_view_on_raven_lost ((DesktopView*) self);
}

DesktopView*
desktop_view_construct (GType object_type,
                        GtkApplication* app)
{
	DesktopView * self = NULL;
	UnifiedProps* _tmp0_;
	UnifiedProps* _tmp1_;
	UnifiedProps* _tmp2_;
	GtkSettings* default_settings = NULL;
	GtkSettings* _tmp3_;
	GtkSettings* _tmp4_;
	GtkSettings* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	UnifiedProps* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	UnifiedProps* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	UnifiedProps* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	UnifiedProps* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	UnifiedProps* _tmp24_;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	UnifiedProps* _tmp27_;
	GSettings* _tmp28_;
	GSettings* _tmp29_;
	UnifiedProps* _tmp30_;
	GSettings* _tmp31_;
	GSettings* _tmp32_;
	UnifiedProps* _tmp33_;
	GSettings* _tmp34_;
	GSettings* _tmp35_;
	UnifiedProps* _tmp36_;
	GSettings* _tmp37_;
	GSettings* _tmp38_;
	UnifiedProps* _tmp39_;
	GSettings* _tmp40_;
	GSettings* _tmp41_;
	UnifiedProps* _tmp42_;
	GSettings* _tmp43_;
	GSettings* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	GFile* _tmp48_;
	GVolumeMonitor* _tmp56_;
	GVolumeMonitor* _tmp57_;
	GtkCssProvider* css = NULL;
	GtkCssProvider* _tmp58_;
	GtkCssProvider* _tmp59_;
	GdkScreen* _tmp60_;
	GtkCssProvider* _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	DesktopMenu* _tmp65_;
	UnifiedProps* _tmp66_;
	UnifiedProps* _tmp67_;
	FileMenu* _tmp68_;
	GtkFlowBox* _tmp69_;
	GtkFlowBox* _tmp70_;
	GtkStyleContext* _tmp71_;
	GtkFlowBox* _tmp72_;
	GtkFlowBox* _tmp73_;
	GtkFlowBox* _tmp74_;
	GtkFlowBox* _tmp75_;
	GtkFlowBox* _tmp76_;
	GdkScreen* _tmp77_;
	GdkScreen* _tmp78_;
	GdkScreen* _tmp79_;
	GtkFlowBox* _tmp80_;
	UnifiedProps* _tmp81_;
	GtkIconTheme* _tmp82_;
	GtkIconTheme* _tmp83_;
	UnifiedProps* _tmp84_;
	GtkIconTheme* _tmp85_;
	GtkFlowBox* _tmp86_;
	GtkFlowBox* _tmp87_;
	GtkTargetEntry* targets = NULL;
	GtkTargetEntry _tmp88_ = {0};
	GtkTargetEntry _tmp89_ = {0};
	GtkTargetEntry _tmp90_ = {0};
	GtkTargetEntry* _tmp91_;
	gint targets_length1;
	gint _targets_size_;
	GtkTargetEntry* _tmp92_;
	gint _tmp92__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	self = (DesktopView*) g_object_new (object_type, "application", app, "app-paintable", TRUE, "decorated", FALSE, "expand", FALSE, "icon-name", "user-desktop", "resizable", FALSE, "skip-pager-hint", TRUE, "skip-taskbar-hint", TRUE, "startup-id", "org.buddiesofbudgie.budgie-desktop-view", "type-hint", GDK_WINDOW_TYPE_HINT_DESKTOP, NULL);
	_tmp0_ = unified_props_new ();
	_g_object_unref0 (self->priv->shared_props);
	self->priv->shared_props = _tmp0_;
	_tmp1_ = self->priv->shared_props;
	g_signal_connect_object (_tmp1_, "cursor-changed", (GCallback) ___lambda12__unified_props_cursor_changed, self, 0);
	_tmp2_ = self->priv->shared_props;
	g_signal_connect_object (_tmp2_, "thumbnail-size-changed", (GCallback) _desktop_view_refresh_icon_sizes_unified_props_thumbnail_size_changed, self, 0);
	_tmp3_ = gtk_settings_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	default_settings = _tmp4_;
	_tmp5_ = default_settings;
	g_object_set (_tmp5_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->file_items);
	self->priv->file_items = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->mount_items);
	self->priv->mount_items = _tmp11_;
	_tmp12_ = self->priv->shared_props;
	_tmp13_ = g_settings_new ("org.buddiesofbudgie.budgie-desktop-view");
	_tmp14_ = _tmp13_;
	unified_props_set_desktop_settings (_tmp12_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->shared_props;
	_tmp16_ = unified_props_get_desktop_settings (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == NULL) {
		g_warning ("budgie_desktop_view.vala:108: Required gschema not installed.");
		gtk_window_close ((GtkWindow*) self);
	}
	desktop_view_create_fileitem_sorter (self);
	_tmp18_ = self->priv->shared_props;
	_tmp19_ = unified_props_get_desktop_settings (_tmp18_);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "changed::icon-size", (GCallback) _desktop_view_on_icon_size_changed_g_settings_changed, self, 0);
	_tmp21_ = self->priv->shared_props;
	_tmp22_ = unified_props_get_desktop_settings (_tmp21_);
	_tmp23_ = _tmp22_;
	g_signal_connect_object (_tmp23_, "changed::show", (GCallback) _desktop_view_on_show_changed_g_settings_changed, self, 0);
	_tmp24_ = self->priv->shared_props;
	_tmp25_ = unified_props_get_desktop_settings (_tmp24_);
	_tmp26_ = _tmp25_;
	g_signal_connect_object (_tmp26_, "changed::show-active-mounts", (GCallback) _desktop_view_on_show_active_mounts_changed_g_settings_changed, self, 0);
	_tmp27_ = self->priv->shared_props;
	_tmp28_ = unified_props_get_desktop_settings (_tmp27_);
	_tmp29_ = _tmp28_;
	g_signal_connect_object (_tmp29_, "changed::show-home-folder", (GCallback) _desktop_view_on_show_home_folder_changed_g_settings_changed, self, 0);
	_tmp30_ = self->priv->shared_props;
	_tmp31_ = unified_props_get_desktop_settings (_tmp30_);
	_tmp32_ = _tmp31_;
	g_signal_connect_object (_tmp32_, "changed::show-trash-folder", (GCallback) _desktop_view_on_show_trash_folder_changed_g_settings_changed, self, 0);
	_tmp33_ = self->priv->shared_props;
	_tmp34_ = unified_props_get_desktop_settings (_tmp33_);
	_tmp35_ = _tmp34_;
	self->priv->show_home = g_settings_get_boolean (_tmp35_, "show-home-folder");
	_tmp36_ = self->priv->shared_props;
	_tmp37_ = unified_props_get_desktop_settings (_tmp36_);
	_tmp38_ = _tmp37_;
	self->priv->show_mounts = g_settings_get_boolean (_tmp38_, "show-active-mounts");
	_tmp39_ = self->priv->shared_props;
	_tmp40_ = unified_props_get_desktop_settings (_tmp39_);
	_tmp41_ = _tmp40_;
	self->priv->show_trash = g_settings_get_boolean (_tmp41_, "show-trash-folder");
	_tmp42_ = self->priv->shared_props;
	_tmp43_ = unified_props_get_desktop_settings (_tmp42_);
	_tmp44_ = _tmp43_;
	self->priv->visible_setting = g_settings_get_boolean (_tmp44_, "show");
	_tmp45_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
	_tmp46_ = g_strdup (_tmp45_);
	_g_free0 (self->priv->desktop_file_uri);
	self->priv->desktop_file_uri = _tmp46_;
	_tmp47_ = self->priv->desktop_file_uri;
	_tmp48_ = g_file_new_for_path (_tmp47_);
	_g_object_unref0 (self->priv->desktop_file);
	self->priv->desktop_file = _tmp48_;
	{
		GFileMonitor* _tmp49_ = NULL;
		GFile* _tmp50_;
		GFileMonitor* _tmp51_;
		GFileMonitor* _tmp52_;
		GFileMonitor* _tmp53_;
		_tmp50_ = self->priv->desktop_file;
		_tmp51_ = g_file_monitor (_tmp50_, G_FILE_MONITOR_WATCH_MOVES, NULL, &_inner_error0_);
		_tmp49_ = _tmp51_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp52_ = _tmp49_;
		_tmp49_ = NULL;
		_g_object_unref0 (self->priv->desktop_monitor);
		self->priv->desktop_monitor = _tmp52_;
		_tmp53_ = self->priv->desktop_monitor;
		g_signal_connect_object (_tmp53_, "changed", (GCallback) _desktop_view_on_file_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp49_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp54_;
		const gchar* _tmp55_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp54_ = e;
		_tmp55_ = _tmp54_->message;
		g_warning ("budgie_desktop_view.vala:132: Failed to obtain a monitor for file chan" \
"ges to the Desktop folder. Will not be able to watch for changes: %s", _tmp55_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (default_settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp56_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp56_;
	_tmp57_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp57_, "mount-added", (GCallback) _desktop_view_on_mount_added_g_volume_monitor_mount_added, self, 0);
	_tmp58_ = gtk_css_provider_new ();
	css = _tmp58_;
	_tmp59_ = css;
	gtk_css_provider_load_from_resource (_tmp59_, "org/buddiesofbudgie/budgie-desktop-view/view.css");
	_tmp60_ = gdk_screen_get_default ();
	_tmp61_ = css;
	gtk_style_context_add_provider_for_screen (_tmp60_, (GtkStyleProvider*) _tmp61_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp62_ = gtk_widget_get_app_paintable ((GtkWidget*) self);
	_tmp63_ = _tmp62_;
	if (!_tmp63_) {
		GtkStyleContext* _tmp64_;
		_tmp64_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp64_, "debug");
	}
	gtk_window_set_keep_below ((GtkWindow*) self, TRUE);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
	gtk_application_window_set_show_menubar ((GtkApplicationWindow*) self, FALSE);
	_tmp65_ = desktop_menu_new ();
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->desktop_menu);
	self->priv->desktop_menu = _tmp65_;
	_tmp66_ = self->priv->shared_props;
	_tmp67_ = self->priv->shared_props;
	_tmp68_ = file_menu_new (_tmp67_);
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (_tmp66_->file_menu);
	_tmp66_->file_menu = _tmp68_;
	_tmp69_ = (GtkFlowBox*) gtk_flow_box_new ();
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->flow);
	self->priv->flow = _tmp69_;
	_tmp70_ = self->priv->flow;
	_tmp71_ = gtk_widget_get_style_context ((GtkWidget*) _tmp70_);
	gtk_style_context_add_class (_tmp71_, "flow");
	_tmp72_ = self->priv->flow;
	gtk_widget_set_halign ((GtkWidget*) _tmp72_, GTK_ALIGN_START);
	_tmp73_ = self->priv->flow;
	g_object_set ((GtkWidget*) _tmp73_, "expand", FALSE, NULL);
	_tmp74_ = self->priv->flow;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp74_, GTK_ORIENTATION_VERTICAL);
	_tmp75_ = self->priv->flow;
	gtk_flow_box_set_sort_func (_tmp75_, _desktop_view_sorter_gtk_flow_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp76_ = self->priv->flow;
	gtk_widget_set_valign ((GtkWidget*) _tmp76_, GTK_ALIGN_START);
	desktop_view_get_display_geo (self);
	_tmp77_ = self->priv->default_screen;
	g_signal_connect_object (_tmp77_, "composited-changed", (GCallback) _desktop_view_set_window_transparent_gdk_screen_composited_changed, self, 0);
	_tmp78_ = self->priv->default_screen;
	g_signal_connect_object (_tmp78_, "monitors-changed", (GCallback) _desktop_view_on_resolution_change_gdk_screen_monitors_changed, self, 0);
	_tmp79_ = self->priv->default_screen;
	g_signal_connect_object (_tmp79_, "size-changed", (GCallback) _desktop_view_on_resolution_change_gdk_screen_size_changed, self, 0);
	desktop_view_setup_root_window_event_handler (self);
	_tmp80_ = self->priv->flow;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp80_);
	_tmp81_ = self->priv->shared_props;
	_tmp82_ = gtk_icon_theme_get_default ();
	_tmp83_ = _g_object_ref0 (_tmp82_);
	_g_object_unref0 (_tmp81_->icon_theme);
	_tmp81_->icon_theme = _tmp83_;
	_tmp84_ = self->priv->shared_props;
	_tmp85_ = _tmp84_->icon_theme;
	g_signal_connect_object (_tmp85_, "changed", (GCallback) _desktop_view_on_icon_theme_changed_gtk_icon_theme_changed, self, 0);
	desktop_view_get_item_size (self);
	desktop_view_create_special_folders (self);
	desktop_view_get_all_active_mounts (self);
	desktop_view_get_all_desktop_files (self);
	_tmp86_ = self->priv->flow;
	gtk_flow_box_invalidate_sort (_tmp86_);
	desktop_view_enforce_content_limit (self);
	_tmp87_ = self->priv->flow;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp87_, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _desktop_view_on_key_pressed_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _desktop_view_on_button_release_gtk_widget_button_release_event, self, 0);
	memset (&_tmp88_, 0, sizeof (GtkTargetEntry));
	_tmp88_.target = "application/x-icon-tasklist-launcher-id";
	_tmp88_.flags = (guint) 0;
	_tmp88_.info = (guint) 0;
	memset (&_tmp89_, 0, sizeof (GtkTargetEntry));
	_tmp89_.target = "text/uri-list";
	_tmp89_.flags = (guint) 0;
	_tmp89_.info = (guint) 0;
	memset (&_tmp90_, 0, sizeof (GtkTargetEntry));
	_tmp90_.target = "application/x-desktop";
	_tmp90_.flags = (guint) 0;
	_tmp90_.info = (guint) 0;
	_tmp91_ = g_new0 (GtkTargetEntry, 3);
	_tmp91_[0] = _tmp88_;
	_tmp91_[1] = _tmp89_;
	_tmp91_[2] = _tmp90_;
	targets = _tmp91_;
	targets_length1 = 3;
	_targets_size_ = targets_length1;
	_tmp92_ = targets;
	_tmp92__length1 = targets_length1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp92_, (gint) _tmp92__length1, GDK_ACTION_COPY);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _desktop_view_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	desktop_view_set_window_transparent (self);
	if (self->priv->visible_setting) {
		gtk_widget_show ((GtkWidget*) self);
		desktop_view_get_display_geo (self);
	}
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, RAVEN_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_desktop_view_has_raven_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _desktop_view_has_raven_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_desktop_view_on_raven_lost_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _desktop_view_on_raven_lost_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	targets = (g_free (targets), NULL);
	_g_object_unref0 (css);
	_g_object_unref0 (default_settings);
	return self;
}

DesktopView*
desktop_view_new (GtkApplication* app)
{
	return desktop_view_construct (TYPE_DESKTOP_VIEW, app);
}

void
desktop_view_clear_selection (DesktopView* self)
{
	GtkFlowBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flow;
	gtk_flow_box_unselect_all (_tmp0_);
	gtk_window_set_focus ((GtkWindow*) self, NULL);
}

void
desktop_view_create_file_item (DesktopView* self,
                               GFile* f,
                               GFileInfo* info,
                               gboolean skip_resort)
{
	gchar* created_file_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	GFileType created_file_type = 0;
	gboolean _tmp4_ = FALSE;
	gboolean supported_type = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	g_return_if_fail (info != NULL);
	if (g_file_info_get_is_hidden (info)) {
		return;
	}
	_tmp0_ = g_file_info_get_display_name (info);
	_tmp1_ = g_strdup (_tmp0_);
	created_file_name = _tmp1_;
	_tmp2_ = self->priv->file_items;
	_tmp3_ = created_file_name;
	if (g_hash_table_contains (_tmp2_, _tmp3_)) {
		_g_free0 (created_file_name);
		return;
	}
	created_file_type = g_file_info_get_file_type (info);
	if (created_file_type == G_FILE_TYPE_DIRECTORY) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = created_file_type == G_FILE_TYPE_REGULAR;
	}
	supported_type = _tmp4_;
	if (supported_type) {
		FileItem* item = NULL;
		UnifiedProps* _tmp5_;
		FileItem* _tmp6_;
		FileItem* _tmp7_;
		GHashTable* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		FileItem* _tmp11_;
		FileItem* _tmp12_;
		GtkFlowBox* _tmp13_;
		FileItem* _tmp14_;
		_tmp5_ = self->priv->shared_props;
		_tmp6_ = file_item_new (_tmp5_, f, info, NULL);
		g_object_ref_sink (_tmp6_);
		item = _tmp6_;
		_tmp7_ = item;
		if (_tmp7_->exclude_item) {
			_g_object_unref0 (item);
			_g_free0 (created_file_name);
			return;
		}
		_tmp8_ = self->priv->file_items;
		_tmp9_ = created_file_name;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = item;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		g_hash_table_insert (_tmp8_, _tmp10_, _tmp12_);
		_tmp13_ = self->priv->flow;
		_tmp14_ = item;
		gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		if (self->priv->visible_setting) {
			FileItem* _tmp15_;
			_tmp15_ = item;
			desktop_item_request_show ((DesktopItem*) _tmp15_);
		}
		if (!skip_resort) {
			GtkFlowBox* _tmp16_;
			_tmp16_ = self->priv->flow;
			gtk_flow_box_invalidate_sort (_tmp16_);
		}
		_g_object_unref0 (item);
	}
	_g_free0 (created_file_name);
}

static void
_desktop_view_on_mount_removed_mount_item_drive_disconnected (MountItem* _sender,
                                                              MountItem* item,
                                                              gpointer self)
{
	desktop_view_on_mount_removed ((DesktopView*) self, item);
}

static void
__lambda19_ (DesktopView* self)
{
	GtkFlowBox* _tmp0_;
	_tmp0_ = self->priv->flow;
	gtk_flow_box_invalidate_sort (_tmp0_);
}

static void
___lambda19__mount_item_mount_name_changed (MountItem* _sender,
                                            MountItem* item,
                                            gpointer self)
{
	__lambda19_ ((DesktopView*) self);
}

void
desktop_view_create_mount_item (DesktopView* self,
                                GMount* mount,
                                const gchar* uuid,
                                gboolean skip_resort)
{
	GHashTable* _tmp0_;
	MountItem* mount_item = NULL;
	UnifiedProps* _tmp1_;
	MountItem* _tmp2_;
	MountItem* _tmp3_;
	MountItem* _tmp4_;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	MountItem* _tmp7_;
	MountItem* _tmp8_;
	GtkFlowBox* _tmp9_;
	MountItem* _tmp10_;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->mount_items;
	if (g_hash_table_contains (_tmp0_, uuid)) {
		return;
	}
	_tmp1_ = self->priv->shared_props;
	_tmp2_ = mount_item_new (_tmp1_, mount, uuid);
	g_object_ref_sink (_tmp2_);
	mount_item = _tmp2_;
	_tmp3_ = mount_item;
	g_signal_connect_object (_tmp3_, "drive-disconnected", (GCallback) _desktop_view_on_mount_removed_mount_item_drive_disconnected, self, 0);
	_tmp4_ = mount_item;
	g_signal_connect_object (_tmp4_, "mount-name-changed", (GCallback) ___lambda19__mount_item_mount_name_changed, self, 0);
	_tmp5_ = self->priv->mount_items;
	_tmp6_ = g_strdup (uuid);
	_tmp7_ = mount_item;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	g_hash_table_insert (_tmp5_, _tmp6_, _tmp8_);
	_tmp9_ = self->priv->flow;
	_tmp10_ = mount_item;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	if (self->priv->visible_setting) {
		_tmp11_ = self->priv->show_mounts;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		MountItem* _tmp12_;
		_tmp12_ = mount_item;
		desktop_item_request_show ((DesktopItem*) _tmp12_);
	}
	if (!skip_resort) {
		GtkFlowBox* _tmp13_;
		_tmp13_ = self->priv->flow;
		gtk_flow_box_invalidate_sort (_tmp13_);
	}
	_g_object_unref0 (mount_item);
}

void
desktop_view_create_special_folders (DesktopView* self)
{
	FileItem* _tmp0_;
	FileItem* _tmp1_;
	FileItem* _tmp4_;
	FileItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = desktop_view_create_special_file_item (self, "home");
	_g_object_unref0 (self->priv->home_item);
	self->priv->home_item = _tmp0_;
	_tmp1_ = self->priv->home_item;
	if (_tmp1_ != NULL) {
		GtkFlowBox* _tmp2_;
		FileItem* _tmp3_;
		_tmp2_ = self->priv->flow;
		_tmp3_ = self->priv->home_item;
		gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	}
	_tmp4_ = desktop_view_create_special_file_item (self, "trash");
	_g_object_unref0 (self->priv->trash_item);
	self->priv->trash_item = _tmp4_;
	_tmp5_ = self->priv->trash_item;
	if (_tmp5_ != NULL) {
		GtkFlowBox* _tmp6_;
		FileItem* _tmp7_;
		_tmp6_ = self->priv->flow;
		_tmp7_ = self->priv->trash_item;
		gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	}
}

FileItem*
desktop_view_create_special_file_item (DesktopView* self,
                                       const gchar* item_type)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* special_file = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GCancellable* c = NULL;
	GCancellable* _tmp11_;
	GFileInfo* special_file_info = NULL;
	gboolean _tmp19_ = FALSE;
	GCancellable* _tmp20_;
	GThemedIcon* special_icon = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GThemedIcon* _tmp24_;
	GThemedIcon* _tmp25_;
	FileItem* special_item = NULL;
	UnifiedProps* _tmp26_;
	GFile* _tmp27_;
	GFileInfo* _tmp28_;
	GThemedIcon* _tmp29_;
	FileItem* _tmp30_;
	FileItem* _tmp31_;
	FileItem* _tmp32_;
	GError* _inner_error0_ = NULL;
	FileItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_type != NULL, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	if (g_strcmp0 (item_type, "trash") == 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = path;
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, ".local", "share", "Trash", "files", NULL);
		_g_free0 (path);
		path = _tmp3_;
	} else {
		if (g_strcmp0 (item_type, "home") != 0) {
			result = NULL;
			_g_free0 (path);
			return result;
		}
	}
	_tmp4_ = path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	special_file = _tmp5_;
	if (g_strcmp0 (item_type, "trash") == 0) {
		GFile* _tmp6_;
		_tmp6_ = special_file;
		if (!g_file_query_exists (_tmp6_, NULL)) {
			g_warning ("budgie_desktop_view.vala:296: Trash folder does not exist. Creating th" \
"e necessary directories.");
			{
				GFile* _tmp7_;
				_tmp7_ = special_file;
				g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp8_;
				GError* _tmp9_;
				const gchar* _tmp10_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = path;
				_tmp9_ = e;
				_tmp10_ = _tmp9_->message;
				g_warning ("budgie_desktop_view.vala:301: Failed to create %s: %s", _tmp8_, _tmp10_);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (special_file);
				_g_free0 (path);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (special_file);
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp11_ = g_cancellable_new ();
	c = _tmp11_;
	special_file_info = NULL;
	{
		GFileInfo* _tmp12_ = NULL;
		GFile* _tmp13_;
		GCancellable* _tmp14_;
		GFileInfo* _tmp15_;
		GFileInfo* _tmp16_;
		_tmp13_ = special_file;
		_tmp14_ = c;
		_tmp15_ = g_file_query_info (_tmp13_, "standard::*", G_FILE_QUERY_INFO_NONE, _tmp14_, &_inner_error0_);
		_tmp12_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp16_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (special_file_info);
		special_file_info = _tmp16_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("budgie_desktop_view.vala:313: Failed to get requested information on t" \
"his directory: %s", _tmp18_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (special_file_info);
		_g_object_unref0 (c);
		_g_object_unref0 (special_file);
		_g_free0 (path);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (special_file_info);
		_g_object_unref0 (c);
		_g_object_unref0 (special_file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = c;
	if (g_cancellable_is_cancelled (_tmp20_)) {
		_tmp19_ = TRUE;
	} else {
		GFileInfo* _tmp21_;
		_tmp21_ = special_file_info;
		_tmp19_ = _tmp21_ == NULL;
	}
	if (_tmp19_) {
		g_warning ("budgie_desktop_view.vala:318: Failed to get information on this direct" \
"ory.");
		result = NULL;
		_g_object_unref0 (special_file_info);
		_g_object_unref0 (c);
		_g_object_unref0 (special_file);
		_g_free0 (path);
		return result;
	}
	_tmp22_ = g_strconcat ("user-", item_type, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = (GThemedIcon*) g_themed_icon_new (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	special_icon = _tmp25_;
	_tmp26_ = self->priv->shared_props;
	_tmp27_ = special_file;
	_tmp28_ = special_file_info;
	_tmp29_ = special_icon;
	_tmp30_ = file_item_new (_tmp26_, _tmp27_, _tmp28_, (GIcon*) _tmp29_);
	g_object_ref_sink (_tmp30_);
	special_item = _tmp30_;
	_tmp31_ = special_item;
	desktop_item_set_is_special ((DesktopItem*) _tmp31_, TRUE);
	_tmp32_ = special_item;
	file_item_set_file_type (_tmp32_, item_type);
	if (g_strcmp0 (item_type, "trash") == 0) {
		FileItem* _tmp33_;
		_tmp33_ = special_item;
		desktop_item_set_label_name ((DesktopItem*) _tmp33_, _ ("Trash"));
	}
	result = special_item;
	_g_object_unref0 (special_icon);
	_g_object_unref0 (special_file_info);
	_g_object_unref0 (c);
	_g_object_unref0 (special_file);
	_g_free0 (path);
	return result;
}

void
desktop_view_delete_item (DesktopView* self,
                          GFile* f)
{
	gchar* deleted_file_name = NULL;
	gchar* _tmp0_;
	FileItem* file_item = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	FileItem* _tmp7_;
	FileItem* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	_tmp0_ = g_file_get_basename (f);
	deleted_file_name = _tmp0_;
	{
		GFileInfo* delete_file_info = NULL;
		GFileInfo* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_file_query_info (f, "standard::*", 0, NULL, &_inner_error0_);
		delete_file_info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_info_get_display_name (delete_file_info);
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (deleted_file_name);
		deleted_file_name = _tmp3_;
		_g_object_unref0 (delete_file_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (deleted_file_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->priv->file_items;
	_tmp5_ = deleted_file_name;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 ((FileItem*) _tmp6_);
	file_item = _tmp7_;
	_tmp8_ = file_item;
	if (_tmp8_ != NULL) {
		GtkFlowBox* _tmp9_;
		FileItem* _tmp10_;
		GHashTable* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = self->priv->flow;
		_tmp10_ = file_item;
		gtk_container_remove ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = self->priv->file_items;
		_tmp12_ = deleted_file_name;
		g_hash_table_remove (_tmp11_, _tmp12_);
	}
	_g_object_unref0 (file_item);
	_g_free0 (deleted_file_name);
}

void
desktop_view_dismiss_raven (DesktopView* self)
{
	Raven* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven;
	if (_tmp0_ != NULL) {
		Raven* _tmp1_;
		_tmp1_ = self->priv->raven;
		raven_Dismiss (_tmp1_, NULL, NULL);
	}
}

static void
___lambda15_ (DesktopView* self,
              GtkWidget* item)
{
	g_return_if_fail (item != NULL);
	gtk_widget_hide (item);
}

static void
____lambda15__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda15_ ((DesktopView*) self, (GtkWidget*) data);
}

static void
desktop_view_enforce_content_limit (DesktopView* self)
{
	GList* flow_children = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gint height = 0;
	GdkRectangle* _tmp4_;
	gint width = 0;
	GdkRectangle* _tmp5_;
	gint row_count = 0;
	gint* _tmp6_;
	gint column_count = 0;
	gint* _tmp7_;
	gint max_files_allowed = 0;
	GList* mount_vals = NULL;
	GHashTable* _tmp9_;
	GList* _tmp10_;
	GList* file_vals = NULL;
	GHashTable* _tmp11_;
	GList* _tmp12_;
	GCompareFunc _tmp13_;
	FileItem* _tmp18_;
	guint file_vals_len = 0U;
	GList* _tmp22_;
	guint show_count = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flow;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	flow_children = _tmp1_;
	_tmp2_ = flow_children;
	if (g_list_length (_tmp2_) == ((guint) 0)) {
		(flow_children == NULL) ? NULL : (flow_children = (g_list_free (flow_children), NULL));
		return;
	}
	if (!self->priv->visible_setting) {
		GList* _tmp3_;
		_tmp3_ = flow_children;
		g_list_foreach (_tmp3_, ____lambda15__gfunc, self);
		(flow_children == NULL) ? NULL : (flow_children = (g_list_free (flow_children), NULL));
		return;
	}
	_tmp4_ = self->priv->primary_monitor_geo;
	height = (*_tmp4_).height;
	_tmp5_ = self->priv->primary_monitor_geo;
	width = (*_tmp5_).width;
	_tmp6_ = self->priv->max_allocated_item_height;
	row_count = (gint) (height / (*_tmp6_));
	_tmp7_ = self->priv->max_allocated_item_width;
	column_count = (gint) ((width / (*_tmp7_)) - 1);
	max_files_allowed = row_count * column_count;
	if (row_count != 1) {
		GtkFlowBox* _tmp8_;
		_tmp8_ = self->priv->flow;
		gtk_flow_box_set_max_children_per_line (_tmp8_, (guint) row_count);
	}
	_tmp9_ = self->priv->mount_items;
	_tmp10_ = g_hash_table_get_values (_tmp9_);
	mount_vals = _tmp10_;
	_tmp11_ = self->priv->file_items;
	_tmp12_ = g_hash_table_get_values (_tmp11_);
	file_vals = _tmp12_;
	file_vals = g_list_reverse (file_vals);
	_tmp13_ = self->priv->file_cmp;
	file_vals = g_list_sort (file_vals, _tmp13_);
	if (self->priv->show_mounts) {
		GList* _tmp14_;
		_tmp14_ = mount_vals;
		max_files_allowed -= (gint) g_list_length (_tmp14_);
	}
	if (self->priv->show_home) {
		gint _tmp15_;
		FileItem* _tmp16_;
		_tmp15_ = max_files_allowed;
		max_files_allowed = _tmp15_ - 1;
		_tmp16_ = self->priv->home_item;
		desktop_item_request_show ((DesktopItem*) _tmp16_);
	} else {
		FileItem* _tmp17_;
		_tmp17_ = self->priv->home_item;
		gtk_widget_hide ((GtkWidget*) _tmp17_);
	}
	_tmp18_ = self->priv->trash_item;
	if (_tmp18_ != NULL) {
		if (self->priv->show_trash) {
			gint _tmp19_;
			FileItem* _tmp20_;
			_tmp19_ = max_files_allowed;
			max_files_allowed = _tmp19_ - 1;
			_tmp20_ = self->priv->trash_item;
			desktop_item_request_show ((DesktopItem*) _tmp20_);
		} else {
			FileItem* _tmp21_;
			_tmp21_ = self->priv->trash_item;
			gtk_widget_hide ((GtkWidget*) _tmp21_);
		}
	}
	_tmp22_ = file_vals;
	file_vals_len = g_list_length (_tmp22_);
	show_count = (guint) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				GList* _tmp25_;
				MountItem* item = NULL;
				GList* _tmp26_;
				gconstpointer _tmp27_;
				MountItem* _tmp28_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = mount_vals;
				if (!(((guint) i) < g_list_length (_tmp25_))) {
					break;
				}
				_tmp26_ = mount_vals;
				_tmp27_ = g_list_nth_data (_tmp26_, (guint) i);
				_tmp28_ = _g_object_ref0 ((MountItem*) _tmp27_);
				item = _tmp28_;
				if (self->priv->show_mounts) {
					MountItem* _tmp29_;
					_tmp29_ = item;
					desktop_item_request_show ((DesktopItem*) _tmp29_);
				} else {
					MountItem* _tmp30_;
					_tmp30_ = item;
					gtk_widget_hide ((GtkWidget*) _tmp30_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				FileItem* item = NULL;
				GList* _tmp33_;
				gconstpointer _tmp34_;
				FileItem* _tmp35_;
				FileItem* _tmp36_;
				FileItem* _tmp37_;
				guint _tmp38_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				if (!(i < max_files_allowed)) {
					break;
				}
				_tmp33_ = file_vals;
				_tmp34_ = g_list_nth_data (_tmp33_, (guint) i);
				_tmp35_ = _g_object_ref0 ((FileItem*) _tmp34_);
				item = _tmp35_;
				_tmp36_ = item;
				if (_tmp36_ == NULL) {
					_g_object_unref0 (item);
					break;
				}
				_tmp37_ = item;
				desktop_item_request_show ((DesktopItem*) _tmp37_);
				_tmp38_ = show_count;
				show_count = _tmp38_ + 1;
				_g_object_unref0 (item);
			}
		}
	}
	if (file_vals_len > ((guint) max_files_allowed)) {
		{
			gint i = 0;
			i = max_files_allowed;
			{
				gboolean _tmp39_ = FALSE;
				_tmp39_ = TRUE;
				while (TRUE) {
					FileItem* item = NULL;
					GList* _tmp41_;
					gconstpointer _tmp42_;
					FileItem* _tmp43_;
					FileItem* _tmp44_;
					FileItem* _tmp45_;
					if (!_tmp39_) {
						gint _tmp40_;
						_tmp40_ = i;
						i = _tmp40_ + 1;
					}
					_tmp39_ = FALSE;
					if (!(((guint) i) < file_vals_len)) {
						break;
					}
					_tmp41_ = file_vals;
					_tmp42_ = g_list_nth_data (_tmp41_, (guint) i);
					_tmp43_ = _g_object_ref0 ((FileItem*) _tmp42_);
					item = _tmp43_;
					_tmp44_ = item;
					if (_tmp44_ == NULL) {
						_g_object_unref0 (item);
						break;
					}
					_tmp45_ = item;
					gtk_widget_hide ((GtkWidget*) _tmp45_);
					_g_object_unref0 (item);
				}
			}
		}
	}
	(file_vals == NULL) ? NULL : (file_vals = (g_list_free (file_vals), NULL));
	(mount_vals == NULL) ? NULL : (mount_vals = (g_list_free (mount_vals), NULL));
	(flow_children == NULL) ? NULL : (flow_children = (g_list_free (flow_children), NULL));
}

static void
__lambda28_ (DesktopView* self,
             GVolume* volume)
{
	GMount* volume_mount = NULL;
	GMount* _tmp0_;
	GMount* _tmp1_;
	gchar* mount_uuid = NULL;
	GMount* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* mount_file = NULL;
	GMount* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GMount* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (volume != NULL);
	_tmp0_ = g_volume_get_mount (volume);
	volume_mount = _tmp0_;
	_tmp1_ = volume_mount;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (volume_mount);
		return;
	}
	_tmp2_ = volume_mount;
	_tmp3_ = desktop_view_get_mount_uuid (self, _tmp2_);
	mount_uuid = _tmp3_;
	_tmp4_ = mount_uuid;
	if (g_strcmp0 (_tmp4_, "FAILED_TO_GET_UUID") == 0) {
		_g_free0 (mount_uuid);
		_g_object_unref0 (volume_mount);
		return;
	}
	_tmp5_ = volume_mount;
	_tmp6_ = g_mount_get_default_location (_tmp5_);
	mount_file = _tmp6_;
	_tmp7_ = mount_file;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (mount_file);
		_g_free0 (mount_uuid);
		_g_object_unref0 (volume_mount);
		return;
	}
	_tmp8_ = volume_mount;
	_tmp9_ = mount_uuid;
	desktop_view_create_mount_item (self, _tmp8_, _tmp9_, TRUE);
	_g_object_unref0 (mount_file);
	_g_free0 (mount_uuid);
	_g_object_unref0 (volume_mount);
}

static void
___lambda28__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda28_ ((DesktopView*) self, (GVolume*) data);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda27_ (DesktopView* self,
             GDrive* drive)
{
	GList* drive_volumes = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (drive != NULL);
	if (!g_drive_has_volumes (drive)) {
		return;
	}
	_tmp0_ = g_drive_get_volumes (drive);
	drive_volumes = _tmp0_;
	_tmp1_ = drive_volumes;
	g_list_foreach (_tmp1_, ___lambda28__gfunc, self);
	(drive_volumes == NULL) ? NULL : (drive_volumes = (_g_list_free__g_object_unref0_ (drive_volumes), NULL));
}

static void
___lambda27__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda27_ ((DesktopView*) self, (GDrive*) data);
}

void
desktop_view_get_all_active_mounts (DesktopView* self)
{
	GList* connected_drives = NULL;
	GVolumeMonitor* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_monitor;
	_tmp1_ = g_volume_monitor_get_connected_drives (_tmp0_);
	connected_drives = _tmp1_;
	g_list_foreach (connected_drives, ___lambda27__gfunc, self);
	(connected_drives == NULL) ? NULL : (connected_drives = (_g_list_free__g_object_unref0_ (connected_drives), NULL));
}

static void
desktop_view_get_all_desktop_files (DesktopView* self)
{
	GCancellable* c = NULL;
	GCancellable* _tmp0_;
	GFileEnumerator* desktop_file_enumerator = NULL;
	GFileEnumerator* _tmp7_;
	GCancellable* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	c = _tmp0_;
	desktop_file_enumerator = NULL;
	{
		GFileEnumerator* _tmp1_ = NULL;
		GFile* _tmp2_;
		GCancellable* _tmp3_;
		GFileEnumerator* _tmp4_;
		GFileEnumerator* _tmp5_;
		_tmp2_ = self->priv->desktop_file;
		_tmp3_ = c;
		_tmp4_ = g_file_enumerate_children (_tmp2_, "standard::*,standard::display-name", G_FILE_QUERY_INFO_NONE, _tmp3_, &_inner_error0_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (desktop_file_enumerator);
		desktop_file_enumerator = _tmp5_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e->message;
		g_error ("budgie_desktop_view.vala:489: Failed to get requested information on o" \
"ur Desktop: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (desktop_file_enumerator);
		_g_object_unref0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = desktop_file_enumerator;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (desktop_file_enumerator);
		_g_object_unref0 (c);
		return;
	}
	{
		GFileInfo* file_info = NULL;
		file_info = NULL;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			GCancellable* _tmp9_;
			GFileInfo* _tmp16_;
			_tmp9_ = c;
			if (!g_cancellable_is_cancelled (_tmp9_)) {
				GFileInfo* _tmp10_ = NULL;
				GFileEnumerator* _tmp11_;
				GCancellable* _tmp12_;
				GFileInfo* _tmp13_;
				GFileInfo* _tmp14_;
				GFileInfo* _tmp15_;
				_tmp11_ = desktop_file_enumerator;
				_tmp12_ = c;
				_tmp13_ = g_file_enumerator_next_file (_tmp11_, _tmp12_, &_inner_error0_);
				_tmp10_ = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file_info);
					goto __catch1_g_error;
				}
				_tmp14_ = _tmp10_;
				_tmp10_ = NULL;
				_g_object_unref0 (file_info);
				file_info = _tmp14_;
				_tmp15_ = file_info;
				_tmp8_ = _tmp15_ != NULL;
				_g_object_unref0 (_tmp10_);
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp16_ = file_info;
			if (!g_file_info_get_is_hidden (_tmp16_)) {
				GFile* f = NULL;
				GFileEnumerator* _tmp17_;
				GFileInfo* _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
				GFileInfo* _tmp21_;
				_tmp17_ = desktop_file_enumerator;
				_tmp18_ = file_info;
				_tmp19_ = g_file_enumerator_get_child (_tmp17_, _tmp18_);
				f = _tmp19_;
				_tmp20_ = f;
				_tmp21_ = file_info;
				desktop_view_create_file_item (self, _tmp20_, _tmp21_, TRUE);
				_g_object_unref0 (f);
			}
		}
		_g_object_unref0 (file_info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("budgie_desktop_view.vala:505: Failed to iterate on files in Desktop fo" \
"lder: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (desktop_file_enumerator);
		_g_object_unref0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp24_ = c;
	if (g_cancellable_is_cancelled (_tmp24_)) {
		g_warning ("budgie_desktop_view.vala:509: Desktop reading was cancelled");
	}
	_g_object_unref0 (desktop_file_enumerator);
	_g_object_unref0 (c);
}

static void
__lambda20_ (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	UnifiedProps* _tmp1_;
	UnifiedProps* _tmp2_;
	GdkCursor* _tmp3_;
	_tmp0_ = self->priv->shared_props;
	_tmp0_->is_launching = TRUE;
	_tmp1_ = self->priv->shared_props;
	_tmp2_ = self->priv->shared_props;
	_tmp3_ = _tmp2_->loading_cursor;
	unified_props_set_current_cursor (_tmp1_, _tmp3_);
}

static void
___lambda20__g_app_launch_context_launch_started (GAppLaunchContext* _sender,
                                                  GAppInfo* info,
                                                  GVariant* platform_data,
                                                  gpointer self)
{
	__lambda20_ ((DesktopView*) self);
}

static void
__lambda21_ (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	UnifiedProps* _tmp1_;
	UnifiedProps* _tmp2_;
	GdkCursor* _tmp3_;
	_tmp0_ = self->priv->shared_props;
	_tmp0_->is_launching = FALSE;
	_tmp1_ = self->priv->shared_props;
	_tmp2_ = self->priv->shared_props;
	_tmp3_ = _tmp2_->hand_cursor;
	unified_props_set_current_cursor (_tmp1_, _tmp3_);
}

static void
___lambda21__g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                 const gchar* startup_notify_id,
                                                 gpointer self)
{
	__lambda21_ ((DesktopView*) self);
}

static void
__lambda22_ (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	UnifiedProps* _tmp1_;
	UnifiedProps* _tmp2_;
	GdkCursor* _tmp3_;
	_tmp0_ = self->priv->shared_props;
	_tmp0_->is_launching = FALSE;
	_tmp1_ = self->priv->shared_props;
	_tmp2_ = self->priv->shared_props;
	_tmp3_ = _tmp2_->hand_cursor;
	unified_props_set_current_cursor (_tmp1_, _tmp3_);
}

static void
___lambda22__g_app_launch_context_launched (GAppLaunchContext* _sender,
                                            GAppInfo* info,
                                            GVariant* platform_data,
                                            gpointer self)
{
	__lambda22_ ((DesktopView*) self);
}

static GdkRectangle*
_vala_GdkRectangle_copy (GdkRectangle* self)
{
	return g_boxed_copy (gdk_rectangle_get_type (), self);
}

static gpointer
__vala_GdkRectangle_copy0 (gpointer self)
{
	return self ? _vala_GdkRectangle_copy (self) : NULL;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
desktop_view_get_display_geo (DesktopView* self)
{
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	UnifiedProps* _tmp5_;
	GdkDisplay* _tmp6_;
	GdkCursor* _tmp7_;
	UnifiedProps* _tmp8_;
	GdkDisplay* _tmp9_;
	GdkCursor* _tmp10_;
	UnifiedProps* _tmp11_;
	GdkDisplay* _tmp12_;
	GdkCursor* _tmp13_;
	UnifiedProps* _tmp14_;
	GdkDisplay* _tmp15_;
	GdkAppLaunchContext* _tmp16_;
	UnifiedProps* _tmp17_;
	GdkAppLaunchContext* _tmp18_;
	GdkScreen* _tmp19_;
	UnifiedProps* _tmp20_;
	GdkAppLaunchContext* _tmp21_;
	UnifiedProps* _tmp22_;
	GdkAppLaunchContext* _tmp23_;
	UnifiedProps* _tmp24_;
	GdkAppLaunchContext* _tmp25_;
	GdkDisplay* _tmp26_;
	GdkMonitor* _tmp27_;
	GdkMonitor* _tmp28_;
	GdkMonitor* _tmp29_;
	GdkRectangle _tmp30_ = {0};
	GdkRectangle* _tmp31_;
	UnifiedProps* _tmp32_;
	GdkMonitor* _tmp33_;
	gint _tmp34_;
	gint* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->default_screen);
	self->priv->default_screen = _tmp1_;
	_tmp2_ = self->priv->default_screen;
	gtk_window_set_screen ((GtkWindow*) self, _tmp2_);
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->default_display);
	self->priv->default_display = _tmp4_;
	_tmp5_ = self->priv->shared_props;
	_tmp6_ = self->priv->default_display;
	_tmp7_ = gdk_cursor_new_from_name (_tmp6_, "not-allowed");
	_g_object_unref0 (_tmp5_->blocked_cursor);
	_tmp5_->blocked_cursor = _tmp7_;
	_tmp8_ = self->priv->shared_props;
	_tmp9_ = self->priv->default_display;
	_tmp10_ = gdk_cursor_new_for_display (_tmp9_, GDK_ARROW);
	_g_object_unref0 (_tmp8_->hand_cursor);
	_tmp8_->hand_cursor = _tmp10_;
	_tmp11_ = self->priv->shared_props;
	_tmp12_ = self->priv->default_display;
	_tmp13_ = gdk_cursor_new_from_name (_tmp12_, "progress");
	_g_object_unref0 (_tmp11_->loading_cursor);
	_tmp11_->loading_cursor = _tmp13_;
	_tmp14_ = self->priv->shared_props;
	_tmp15_ = self->priv->default_display;
	_tmp16_ = gdk_display_get_app_launch_context (_tmp15_);
	_g_object_unref0 (_tmp14_->launch_context);
	_tmp14_->launch_context = _tmp16_;
	_tmp17_ = self->priv->shared_props;
	_tmp18_ = _tmp17_->launch_context;
	_tmp19_ = self->priv->default_screen;
	gdk_app_launch_context_set_screen (_tmp18_, _tmp19_);
	_tmp20_ = self->priv->shared_props;
	_tmp21_ = _tmp20_->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp21_, "launch-started", (GCallback) ___lambda20__g_app_launch_context_launch_started, self, 0);
	_tmp22_ = self->priv->shared_props;
	_tmp23_ = _tmp22_->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp23_, "launch-failed", (GCallback) ___lambda21__g_app_launch_context_launch_failed, self, 0);
	_tmp24_ = self->priv->shared_props;
	_tmp25_ = _tmp24_->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp25_, "launched", (GCallback) ___lambda22__g_app_launch_context_launched, self, 0);
	_tmp26_ = self->priv->default_display;
	_tmp27_ = gdk_display_get_primary_monitor (_tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (self->priv->primary_monitor);
	self->priv->primary_monitor = _tmp28_;
	_tmp29_ = self->priv->primary_monitor;
	gdk_monitor_get_workarea (_tmp29_, &_tmp30_);
	_tmp31_ = __vala_GdkRectangle_copy0 (&_tmp30_);
	__vala_GdkRectangle_free0 (self->priv->primary_monitor_geo);
	self->priv->primary_monitor_geo = _tmp31_;
	_tmp32_ = self->priv->shared_props;
	_tmp33_ = self->priv->primary_monitor;
	_tmp34_ = gdk_monitor_get_scale_factor (_tmp33_);
	_tmp35_ = __int_dup0 (&_tmp34_);
	_g_free0 (_tmp32_->s_factor);
	_tmp32_->s_factor = _tmp35_;
	desktop_view_update_window_position (self);
}

gchar*
desktop_view_get_mount_uuid (DesktopView* self,
                             GMount* mount)
{
	GVolume* volume = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	gchar* mount_uuid = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* volume_uuid = NULL;
	GVolume* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GDrive* drive = NULL;
	GDrive* _tmp8_;
	GDrive* _tmp9_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mount != NULL, NULL);
	_tmp0_ = g_mount_get_volume (mount);
	volume = _tmp0_;
	_tmp1_ = volume;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_object_unref0 (volume);
		return result;
	}
	_tmp3_ = g_mount_get_uuid (mount);
	mount_uuid = _tmp3_;
	_tmp4_ = mount_uuid;
	if (_tmp4_ != NULL) {
		result = mount_uuid;
		_g_object_unref0 (volume);
		return result;
	}
	_tmp5_ = volume;
	_tmp6_ = g_volume_get_uuid (_tmp5_);
	volume_uuid = _tmp6_;
	_tmp7_ = volume_uuid;
	if (_tmp7_ != NULL) {
		result = volume_uuid;
		_g_free0 (mount_uuid);
		_g_object_unref0 (volume);
		return result;
	}
	_tmp8_ = g_mount_get_drive (mount);
	drive = _tmp8_;
	_tmp9_ = drive;
	if (_tmp9_ != NULL) {
		gchar* drive_identifier = NULL;
		GDrive* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = drive;
		_tmp11_ = g_drive_get_identifier (_tmp10_, G_DRIVE_IDENTIFIER_KIND_UNIX_DEVICE);
		drive_identifier = _tmp11_;
		_tmp12_ = drive_identifier;
		if (_tmp12_ != NULL) {
			result = drive_identifier;
			_g_object_unref0 (drive);
			_g_free0 (volume_uuid);
			_g_free0 (mount_uuid);
			_g_object_unref0 (volume);
			return result;
		}
		_g_free0 (drive_identifier);
	}
	_tmp13_ = g_strdup ("FAILED_TO_GET_UUID");
	result = _tmp13_;
	_g_object_unref0 (drive);
	_g_free0 (volume_uuid);
	_g_free0 (mount_uuid);
	_g_object_unref0 (volume);
	return result;
}

static DesktopItemSize*
_desktop_item_size_dup (DesktopItemSize* self)
{
	DesktopItemSize* dup;
	dup = g_new0 (DesktopItemSize, 1);
	memcpy (dup, self, sizeof (DesktopItemSize));
	return dup;
}

static gpointer
__desktop_item_size_dup0 (gpointer self)
{
	return self ? _desktop_item_size_dup (self) : NULL;
}

static gboolean
_desktop_item_size_equal (const DesktopItemSize * s1,
                          const DesktopItemSize * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
desktop_view_get_item_size (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	DesktopItemSize _tmp3_;
	DesktopItemSize* _tmp4_;
	DesktopItemSize* _tmp5_;
	DesktopItemSize _tmp6_;
	gint* _tmp33_;
	gint _tmp34_;
	gint* _tmp35_;
	UnifiedProps* _tmp36_;
	gint* _tmp37_;
	gint _tmp38_;
	gint* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shared_props;
	_tmp1_ = unified_props_get_desktop_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (DesktopItemSize) g_settings_get_enum (_tmp2_, "icon-size");
	_tmp4_ = __desktop_item_size_dup0 (&_tmp3_);
	_g_free0 (self->priv->item_size);
	self->priv->item_size = _tmp4_;
	_tmp5_ = self->priv->item_size;
	_tmp6_ = DESKTOP_ITEM_SIZE_SMALL;
	if (_desktop_item_size_equal (_tmp5_, &_tmp6_) == TRUE) {
		UnifiedProps* _tmp7_;
		gint _tmp8_;
		gint* _tmp9_;
		gint _tmp10_;
		gint* _tmp11_;
		_tmp7_ = self->priv->shared_props;
		_tmp8_ = 32;
		_tmp9_ = __int_dup0 (&_tmp8_);
		_g_free0 (_tmp7_->icon_size);
		_tmp7_->icon_size = _tmp9_;
		_tmp10_ = 90;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_g_free0 (self->priv->max_allocated_item_width);
		self->priv->max_allocated_item_width = _tmp11_;
	} else {
		DesktopItemSize* _tmp12_;
		DesktopItemSize _tmp13_;
		_tmp12_ = self->priv->item_size;
		_tmp13_ = DESKTOP_ITEM_SIZE_NORMAL;
		if (_desktop_item_size_equal (_tmp12_, &_tmp13_) == TRUE) {
			UnifiedProps* _tmp14_;
			gint _tmp15_;
			gint* _tmp16_;
			gint _tmp17_;
			gint* _tmp18_;
			_tmp14_ = self->priv->shared_props;
			_tmp15_ = 48;
			_tmp16_ = __int_dup0 (&_tmp15_);
			_g_free0 (_tmp14_->icon_size);
			_tmp14_->icon_size = _tmp16_;
			_tmp17_ = 90;
			_tmp18_ = __int_dup0 (&_tmp17_);
			_g_free0 (self->priv->max_allocated_item_width);
			self->priv->max_allocated_item_width = _tmp18_;
		} else {
			DesktopItemSize* _tmp19_;
			DesktopItemSize _tmp20_;
			_tmp19_ = self->priv->item_size;
			_tmp20_ = DESKTOP_ITEM_SIZE_LARGE;
			if (_desktop_item_size_equal (_tmp19_, &_tmp20_) == TRUE) {
				UnifiedProps* _tmp21_;
				gint _tmp22_;
				gint* _tmp23_;
				gint _tmp24_;
				gint* _tmp25_;
				_tmp21_ = self->priv->shared_props;
				_tmp22_ = 64;
				_tmp23_ = __int_dup0 (&_tmp22_);
				_g_free0 (_tmp21_->icon_size);
				_tmp21_->icon_size = _tmp23_;
				_tmp24_ = 150;
				_tmp25_ = __int_dup0 (&_tmp24_);
				_g_free0 (self->priv->max_allocated_item_width);
				self->priv->max_allocated_item_width = _tmp25_;
			} else {
				DesktopItemSize* _tmp26_;
				DesktopItemSize _tmp27_;
				_tmp26_ = self->priv->item_size;
				_tmp27_ = DESKTOP_ITEM_SIZE_MASSIVE;
				if (_desktop_item_size_equal (_tmp26_, &_tmp27_) == TRUE) {
					UnifiedProps* _tmp28_;
					gint _tmp29_;
					gint* _tmp30_;
					gint _tmp31_;
					gint* _tmp32_;
					_tmp28_ = self->priv->shared_props;
					_tmp29_ = 96;
					_tmp30_ = __int_dup0 (&_tmp29_);
					_g_free0 (_tmp28_->icon_size);
					_tmp28_->icon_size = _tmp30_;
					_tmp31_ = 160;
					_tmp32_ = __int_dup0 (&_tmp31_);
					_g_free0 (self->priv->max_allocated_item_width);
					self->priv->max_allocated_item_width = _tmp32_;
				}
			}
		}
	}
	_tmp33_ = self->priv->max_allocated_item_width;
	_tmp34_ = (*_tmp33_) + (ITEM_MARGIN * 2);
	_tmp35_ = __int_dup0 (&_tmp34_);
	_g_free0 (self->priv->max_allocated_item_width);
	self->priv->max_allocated_item_width = _tmp35_;
	_tmp36_ = self->priv->shared_props;
	_tmp37_ = _tmp36_->icon_size;
	_tmp38_ = (*_tmp37_) + (ITEM_MARGIN * 7);
	_tmp39_ = __int_dup0 (&_tmp38_);
	_g_free0 (self->priv->max_allocated_item_height);
	self->priv->max_allocated_item_height = _tmp39_;
}

static void
_desktop_view_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                  GAsyncResult* res,
                                                  gpointer self)
{
	desktop_view_on_raven_get ((DesktopView*) self, source_object, res);
	g_object_unref (self);
}

static void
desktop_view_has_raven (DesktopView* self)
{
	Raven* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (TYPE_RAVEN_PROXY, 0, NULL, _desktop_view_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Raven", NULL);
	}
}

static gboolean
desktop_view_on_button_release (DesktopView* self,
                                GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 1)) {
		DesktopMenu* _tmp0_;
		_tmp0_ = self->priv->desktop_menu;
		gtk_menu_popdown ((GtkMenu*) _tmp0_);
		desktop_view_clear_selection (self);
		desktop_view_dismiss_raven (self);
		result = GDK_EVENT_PROPAGATE;
		return result;
	} else {
		if (event->button == ((guint) 3)) {
			DesktopMenu* _tmp1_;
			GdkMonitor* _tmp2_;
			DesktopMenu* _tmp3_;
			GdkScreen* _tmp4_;
			DesktopMenu* _tmp5_;
			desktop_view_dismiss_raven (self);
			_tmp1_ = self->priv->desktop_menu;
			_tmp2_ = self->priv->primary_monitor;
			gtk_menu_place_on_monitor ((GtkMenu*) _tmp1_, _tmp2_);
			_tmp3_ = self->priv->desktop_menu;
			_tmp4_ = self->priv->default_screen;
			gtk_menu_set_screen ((GtkMenu*) _tmp3_, _tmp4_);
			_tmp5_ = self->priv->desktop_menu;
			gtk_menu_popup_at_pointer ((GtkMenu*) _tmp5_, (GdkEvent*) event);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
	}
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DesktopView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->target_file);
		_g_free0 (_data1_->proposed_file_name);
		_g_object_unref0 (_data1_->this_file);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DesktopView* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->file_cancellable);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_____lambda29_ (Block2Data* _data2_,
                GObject* obj,
                GAsyncResult* res)
{
	Block1Data* _data1_;
	DesktopView* self;
	UnifiedProps* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->shared_props;
	_tmp1_ = _tmp0_->files_currently_copying;
	_tmp2_ = _data1_->proposed_file_name;
	g_hash_table_remove (_tmp1_, _tmp2_);
	_tmp3_ = _data1_->proposed_file_name;
	desktop_view_update_item_saturation (self, _tmp3_);
	{
		GFile* _tmp4_;
		_tmp4_ = _data1_->this_file;
		g_file_copy_finish (_tmp4_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GCancellable* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _data2_->file_cancellable;
		if (!g_cancellable_is_cancelled (_tmp5_)) {
			const gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			_tmp6_ = _data1_->proposed_file_name;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("budgie_desktop_view.vala:718: Failed to copy %s: %s", _tmp6_, _tmp8_);
			_tmp9_ = _data1_->target_file;
			desktop_view_delete_item (self, _tmp9_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
______lambda29__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	_____lambda29_ (self, source_object, res);
	block2_data_unref (self);
}

static void
desktop_view_on_drag_data_received (DesktopView* self,
                                    GtkWidget* widget,
                                    GdkDragContext* c,
                                    gint x,
                                    gint y,
                                    GtkSelectionData* d,
                                    guint info,
                                    guint time)
{
	gchar* uri = NULL;
	guint8* _tmp0_;
	gchar* _tmp1_;
	gchar** uris = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint uris_length1;
	gint _uris_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (d != NULL);
	_tmp0_ = gtk_selection_data_get_data (d);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = string_chomp (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "\n", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	uris = _tmp7_;
	uris_length1 = _tmp7__length1;
	_uris_size_ = uris_length1;
	_tmp8_ = uris;
	_tmp8__length1 = uris_length1;
	{
		gchar** file_uri_collection = NULL;
		gint file_uri_collection_length1 = 0;
		gint _file_uri_collection_size_ = 0;
		gint file_uri_it = 0;
		file_uri_collection = _tmp8_;
		file_uri_collection_length1 = _tmp8__length1;
		for (file_uri_it = 0; file_uri_it < file_uri_collection_length1; file_uri_it = file_uri_it + 1) {
			gchar* _tmp9_;
			gchar* file_uri = NULL;
			_tmp9_ = g_strdup (file_uri_collection[file_uri_it]);
			file_uri = _tmp9_;
			{
				Block1Data* _data1_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				gchar* file_base = NULL;
				GFile* _tmp14_;
				gchar* _tmp15_;
				gchar* file_dir = NULL;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				GCancellable* can = NULL;
				GCancellable* _tmp23_;
				GFileInfo* finfo = NULL;
				gboolean _tmp31_ = FALSE;
				GCancellable* _tmp32_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* copy_file_name = NULL;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				GHashTable* _tmp38_;
				const gchar* _tmp39_;
				GFileType type = 0;
				GFileInfo* _tmp67_;
				gchar* target_path = NULL;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				GFile* _tmp72_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				_tmp10_ = file_uri;
				_tmp11_ = string_chomp (_tmp10_);
				_g_free0 (file_uri);
				file_uri = _tmp11_;
				_tmp12_ = file_uri;
				_tmp13_ = g_file_new_for_uri (_tmp12_);
				_data1_->this_file = _tmp13_;
				_tmp14_ = _data1_->this_file;
				_tmp15_ = g_file_get_basename (_tmp14_);
				file_base = _tmp15_;
				_tmp16_ = file_uri;
				_tmp17_ = file_base;
				_tmp18_ = string_replace (_tmp16_, _tmp17_, "");
				file_dir = _tmp18_;
				_tmp19_ = file_dir;
				_tmp20_ = string_replace (_tmp19_, "file://", "");
				_g_free0 (file_dir);
				file_dir = _tmp20_;
				_tmp21_ = file_base;
				_tmp22_ = self->priv->desktop_file_uri;
				if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
					_g_free0 (file_dir);
					_g_free0 (file_base);
					_g_free0 (file_uri);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					continue;
				}
				_tmp23_ = g_cancellable_new ();
				can = _tmp23_;
				finfo = NULL;
				{
					GFileInfo* _tmp24_ = NULL;
					GFile* _tmp25_;
					GCancellable* _tmp26_;
					GFileInfo* _tmp27_;
					GFileInfo* _tmp28_;
					_tmp25_ = _data1_->this_file;
					_tmp26_ = can;
					_tmp27_ = g_file_query_info (_tmp25_, "standard::*", G_FILE_QUERY_INFO_NONE, _tmp26_, &_inner_error0_);
					_tmp24_ = _tmp27_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp28_ = _tmp24_;
					_tmp24_ = NULL;
					_g_object_unref0 (finfo);
					finfo = _tmp28_;
					_g_object_unref0 (_tmp24_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp29_;
					const gchar* _tmp30_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp29_ = e;
					_tmp30_ = _tmp29_->message;
					g_warning ("budgie_desktop_view.vala:654: Failed to get requested information on t" \
"his file: %s", _tmp30_);
					_g_error_free0 (e);
					_g_object_unref0 (finfo);
					_g_object_unref0 (can);
					_g_free0 (file_dir);
					_g_free0 (file_base);
					_g_free0 (file_uri);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (finfo);
					_g_object_unref0 (can);
					_g_free0 (file_dir);
					_g_free0 (file_base);
					_g_free0 (file_uri);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp32_ = can;
				if (g_cancellable_is_cancelled (_tmp32_)) {
					_tmp31_ = TRUE;
				} else {
					GFileInfo* _tmp33_;
					_tmp33_ = finfo;
					_tmp31_ = _tmp33_ == NULL;
				}
				if (_tmp31_) {
					g_warning ("budgie_desktop_view.vala:659: Failed to get information on this file.");
					_g_object_unref0 (finfo);
					_g_object_unref0 (can);
					_g_free0 (file_dir);
					_g_free0 (file_base);
					_g_free0 (file_uri);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					continue;
				}
				_tmp34_ = file_base;
				_tmp35_ = g_strdup (_tmp34_);
				_data1_->proposed_file_name = _tmp35_;
				_tmp36_ = _data1_->proposed_file_name;
				_tmp37_ = g_strdup (_tmp36_);
				copy_file_name = _tmp37_;
				_tmp38_ = self->priv->file_items;
				_tmp39_ = file_base;
				if (g_hash_table_contains (_tmp38_, _tmp39_)) {
					gboolean have_file_as_copy = FALSE;
					have_file_as_copy = TRUE;
					while (TRUE) {
						gchar* primitive_name = NULL;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* ext = NULL;
						gchar* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp51_;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						GFile* copy_file = NULL;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						GFile* _tmp60_;
						GFile* _tmp61_;
						GFile* _tmp62_;
						if (!have_file_as_copy) {
							break;
						}
						_tmp40_ = copy_file_name;
						_tmp41_ = g_strdup (_tmp40_);
						primitive_name = _tmp41_;
						_tmp42_ = g_strdup ("");
						ext = _tmp42_;
						_tmp43_ = primitive_name;
						if (string_contains (_tmp43_, ".")) {
							gint last_dot_pos = 0;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							gchar* _tmp49_;
							const gchar* _tmp50_;
							_tmp44_ = primitive_name;
							last_dot_pos = string_last_index_of (_tmp44_, ".", 0);
							_tmp45_ = copy_file_name;
							_tmp46_ = string_substring (_tmp45_, (glong) 0, (glong) last_dot_pos);
							_g_free0 (primitive_name);
							primitive_name = _tmp46_;
							_tmp47_ = primitive_name;
							g_warning ("budgie_desktop_view.vala:676: Super primitive Name: %s", _tmp47_);
							_tmp48_ = copy_file_name;
							_tmp49_ = string_substring (_tmp48_, (glong) last_dot_pos, (glong) -1);
							_g_free0 (ext);
							ext = _tmp49_;
							_tmp50_ = ext;
							g_warning ("budgie_desktop_view.vala:678: Extension: %s", _tmp50_);
						}
						_tmp51_ = primitive_name;
						_tmp52_ = ext;
						_tmp53_ = g_strconcat (" (Copy)", _tmp52_, NULL);
						_tmp54_ = _tmp53_;
						_tmp55_ = g_strconcat (_tmp51_, _tmp54_, NULL);
						_g_free0 (primitive_name);
						primitive_name = _tmp55_;
						_g_free0 (_tmp54_);
						_tmp56_ = self->priv->desktop_file_uri;
						_tmp57_ = primitive_name;
						_tmp58_ = g_build_filename (_tmp56_, _tmp57_, NULL);
						_tmp59_ = _tmp58_;
						_tmp60_ = g_file_new_for_path (_tmp59_);
						_tmp61_ = _tmp60_;
						_g_free0 (_tmp59_);
						copy_file = _tmp61_;
						_tmp62_ = copy_file;
						if (!g_file_query_exists (_tmp62_, NULL)) {
							const gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp63_ = primitive_name;
							_tmp64_ = g_strdup (_tmp63_);
							_g_free0 (_data1_->proposed_file_name);
							_data1_->proposed_file_name = _tmp64_;
							have_file_as_copy = FALSE;
							_g_object_unref0 (copy_file);
							_g_free0 (ext);
							_g_free0 (primitive_name);
							break;
						} else {
							const gchar* _tmp65_;
							gchar* _tmp66_;
							_tmp65_ = primitive_name;
							_tmp66_ = g_strdup (_tmp65_);
							_g_free0 (copy_file_name);
							copy_file_name = _tmp66_;
						}
						_g_object_unref0 (copy_file);
						_g_free0 (ext);
						_g_free0 (primitive_name);
					}
				}
				_tmp67_ = finfo;
				type = g_file_info_get_file_type (_tmp67_);
				_tmp68_ = self->priv->desktop_file_uri;
				_tmp69_ = _data1_->proposed_file_name;
				_tmp70_ = g_build_filename (_tmp68_, _tmp69_, NULL);
				target_path = _tmp70_;
				_tmp71_ = target_path;
				_tmp72_ = g_file_new_for_path (_tmp71_);
				_data1_->target_file = _tmp72_;
				if (type == G_FILE_TYPE_DIRECTORY) {
					{
						GFile* _tmp73_;
						GFile* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						_tmp73_ = _data1_->target_file;
						_tmp74_ = _data1_->this_file;
						_tmp75_ = g_file_get_path (_tmp74_);
						_tmp76_ = _tmp75_;
						g_file_make_symbolic_link (_tmp73_, _tmp76_, NULL, &_inner_error0_);
						_g_free0 (_tmp76_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp77_;
						GError* _tmp78_;
						const gchar* _tmp79_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp77_ = target_path;
						_tmp78_ = e;
						_tmp79_ = _tmp78_->message;
						g_warning ("budgie_desktop_view.vala:704: Failed to symlink to %s: %s", _tmp77_, _tmp79_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (target_path);
						_g_free0 (copy_file_name);
						_g_object_unref0 (finfo);
						_g_object_unref0 (can);
						_g_free0 (file_dir);
						_g_free0 (file_base);
						_g_free0 (file_uri);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (uri);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					Block2Data* _data2_;
					GCancellable* _tmp80_;
					UnifiedProps* _tmp81_;
					GHashTable* _tmp82_;
					const gchar* _tmp83_;
					gchar* _tmp84_;
					GCancellable* _tmp85_;
					GCancellable* _tmp86_;
					GFile* _tmp87_;
					GFile* _tmp88_;
					GCancellable* _tmp89_;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					_tmp80_ = g_cancellable_new ();
					_data2_->file_cancellable = _tmp80_;
					_tmp81_ = self->priv->shared_props;
					_tmp82_ = _tmp81_->files_currently_copying;
					_tmp83_ = _data1_->proposed_file_name;
					_tmp84_ = g_strdup (_tmp83_);
					_tmp85_ = _data2_->file_cancellable;
					_tmp86_ = _g_object_ref0 (_tmp85_);
					g_hash_table_insert (_tmp82_, _tmp84_, _tmp86_);
					_tmp87_ = _data1_->this_file;
					_tmp88_ = _data1_->target_file;
					_tmp89_ = _data2_->file_cancellable;
					g_file_copy_async (_tmp87_, _tmp88_, G_FILE_COPY_NOFOLLOW_SYMLINKS, 0, _tmp89_, NULL, NULL, ______lambda29__gasync_ready_callback, block2_data_ref (_data2_));
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
				_g_free0 (target_path);
				_g_free0 (copy_file_name);
				_g_object_unref0 (finfo);
				_g_object_unref0 (can);
				_g_free0 (file_dir);
				_g_free0 (file_base);
				_g_free0 (file_uri);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	gtk_drag_finish (c, TRUE, TRUE, (guint32) time);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (uri);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		DesktopView* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->create_file_ref);
		_g_object_unref0 (_data3_->file);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda17_ (Block3Data* _data3_)
{
	DesktopView* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data3_->self;
	{
		GFileInfo* created_file_info = NULL;
		GFile* _tmp0_;
		GFileInfo* _tmp1_;
		gchar* file_name = NULL;
		GFileInfo* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp9_;
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		_tmp0_ = _data3_->create_file_ref;
		_tmp1_ = g_file_query_info (_tmp0_, "standard::*", 0, NULL, &_inner_error0_);
		created_file_info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = created_file_info;
		_tmp3_ = g_file_info_get_display_name (_tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		file_name = _tmp4_;
		_tmp6_ = self->priv->file_items;
		_tmp7_ = file_name;
		if (g_hash_table_contains (_tmp6_, _tmp7_)) {
			_tmp5_ = TRUE;
		} else {
			GFileInfo* _tmp8_;
			_tmp8_ = created_file_info;
			_tmp5_ = g_file_info_get_is_hidden (_tmp8_);
		}
		if (_tmp5_) {
			result = FALSE;
			_g_free0 (file_name);
			_g_object_unref0 (created_file_info);
			return result;
		}
		_tmp9_ = _data3_->create_file_ref;
		_tmp10_ = created_file_info;
		desktop_view_create_file_item (self, _tmp9_, _tmp10_, FALSE);
		_tmp11_ = file_name;
		desktop_view_update_item_saturation (self, _tmp11_);
		desktop_view_enforce_content_limit (self);
		_g_free0 (file_name);
		_g_object_unref0 (created_file_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("budgie_desktop_view.vala:782: Failed to create file item: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda17_ (self);
	return result;
}

static gboolean
___lambda18_ (Block3Data* _data3_)
{
	DesktopView* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data3_->self;
	{
		GFileInfo* existing_file_info = NULL;
		GFileInfo* _tmp0_;
		gchar* file_name = NULL;
		GFileInfo* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		GHashTable* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = g_file_query_info (_data3_->file, "standard::*", 0, NULL, &_inner_error0_);
		existing_file_info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = existing_file_info;
		_tmp2_ = g_file_info_get_display_name (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		file_name = _tmp3_;
		_tmp4_ = self->priv->file_items;
		_tmp5_ = file_name;
		if (g_hash_table_contains (_tmp4_, _tmp5_)) {
			FileItem* file_item = NULL;
			GHashTable* _tmp6_;
			const gchar* _tmp7_;
			gconstpointer _tmp8_;
			FileItem* _tmp9_;
			FileItem* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			FileItem* _tmp13_;
			FileItem* _tmp14_;
			GThemedIcon* _tmp15_;
			GThemedIcon* _tmp16_;
			_tmp6_ = self->priv->file_items;
			_tmp7_ = file_name;
			_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
			_tmp9_ = _g_object_ref0 ((FileItem*) _tmp8_);
			file_item = _tmp9_;
			_tmp10_ = file_item;
			_tmp11_ = existing_file_info;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (_tmp10_->info);
			_tmp10_->info = _tmp12_;
			_tmp13_ = file_item;
			_tmp14_ = file_item;
			_tmp15_ = file_item_get_mimetype_icon (_tmp14_);
			_tmp16_ = _tmp15_;
			desktop_item_set_icon ((DesktopItem*) _tmp13_, (GIcon*) _tmp16_, &_inner_error0_);
			_g_object_unref0 (_tmp16_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_item);
				_g_free0 (file_name);
				_g_object_unref0 (existing_file_info);
				goto __catch0_g_error;
			}
			_g_object_unref0 (file_item);
		}
		_g_free0 (file_name);
		_g_object_unref0 (existing_file_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("budgie_desktop_view.vala:810: Failed to get updated attributes for fil" \
"e. %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp19_;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda18_ (self);
	return result;
}

static void
desktop_view_on_file_changed (DesktopView* self,
                              GFile* file,
                              GFile* other_file,
                              GFileMonitorEvent type)
{
	Block3Data* _data3_;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean do_create = FALSE;
	gboolean do_delete = FALSE;
	GFile* delete_file_ref = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data3_->file);
	_data3_->file = _tmp0_;
	if (type == G_FILE_MONITOR_EVENT_PRE_UNMOUNT) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == G_FILE_MONITOR_EVENT_UNMOUNTED;
	}
	if (_tmp1_) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp2_ = g_file_get_basename (_data3_->file);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (_tmp3_, ".");
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	do_create = FALSE;
	do_delete = FALSE;
	_data3_->create_file_ref = NULL;
	delete_file_ref = NULL;
	if (type == G_FILE_MONITOR_EVENT_RENAMED) {
		GFile* _tmp5_;
		GFile* _tmp6_;
		do_create = TRUE;
		do_delete = TRUE;
		_tmp5_ = _g_object_ref0 (other_file);
		_g_object_unref0 (_data3_->create_file_ref);
		_data3_->create_file_ref = _tmp5_;
		_tmp6_ = _g_object_ref0 (_data3_->file);
		_g_object_unref0 (delete_file_ref);
		delete_file_ref = _tmp6_;
	} else {
		gboolean _tmp7_ = FALSE;
		if (type == G_FILE_MONITOR_EVENT_MOVED_IN) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = type == G_FILE_MONITOR_EVENT_CREATED;
		}
		if (_tmp7_) {
			GFile* _tmp8_;
			do_create = TRUE;
			_tmp8_ = _g_object_ref0 (_data3_->file);
			_g_object_unref0 (_data3_->create_file_ref);
			_data3_->create_file_ref = _tmp8_;
		} else {
			gboolean _tmp9_ = FALSE;
			if (type == G_FILE_MONITOR_EVENT_MOVED_OUT) {
				_tmp9_ = TRUE;
			} else {
				_tmp9_ = type == G_FILE_MONITOR_EVENT_DELETED;
			}
			if (_tmp9_) {
				GFile* _tmp10_;
				do_delete = TRUE;
				_tmp10_ = _g_object_ref0 (_data3_->file);
				_g_object_unref0 (delete_file_ref);
				delete_file_ref = _tmp10_;
			}
		}
	}
	if (do_delete) {
		GFile* _tmp12_;
		_tmp12_ = delete_file_ref;
		_tmp11_ = _tmp12_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GFile* _tmp13_;
		_tmp13_ = delete_file_ref;
		desktop_view_delete_item (self, _tmp13_);
		desktop_view_enforce_content_limit (self);
	}
	if (do_create) {
		GFile* _tmp15_;
		_tmp15_ = _data3_->create_file_ref;
		_tmp14_ = _tmp15_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean _tmp19_;
		_tmp16_ = _data3_->create_file_ref;
		_tmp17_ = g_file_get_basename (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_str_has_prefix (_tmp18_, ".");
		_g_free0 (_tmp18_);
		if (_tmp19_) {
			_g_object_unref0 (delete_file_ref);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda17__gsource_func, block3_data_ref (_data3_), block3_data_unref);
		_g_object_unref0 (delete_file_ref);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	if (g_file_query_exists (_data3_->file, NULL)) {
		_tmp22_ = !do_create;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = !do_delete;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gboolean _tmp23_ = FALSE;
		if (type == G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = type == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT;
		}
		_tmp20_ = _tmp23_;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gchar* _tmp24_;
		gchar* _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = g_file_get_basename (_data3_->file);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_str_has_prefix (_tmp25_, ".");
		_g_free0 (_tmp25_);
		if (_tmp26_) {
			_g_object_unref0 (delete_file_ref);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, ____lambda18__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	}
	_g_object_unref0 (delete_file_ref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
__lambda25_ (DesktopView* self,
             const gchar* key,
             MountItem* mount_item)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (key != NULL);
	{
		GIcon* _tmp0_;
		_tmp0_ = ((DesktopItem*) mount_item)->icon;
		desktop_item_set_icon ((DesktopItem*) mount_item, _tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("budgie_desktop_view.vala:838: Failed to set icon factors for a MountIt" \
"em when refreshing icon sizes: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda25__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda25_ ((DesktopView*) self, (const gchar*) key, (MountItem*) value);
}

static void
__lambda26_ (DesktopView* self,
             const gchar* key,
             FileItem* file_item)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (key != NULL);
	{
		file_item_update_icon (file_item, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("budgie_desktop_view.vala:846: Failed to set icon factors for a FileIte" \
"m when refreshing icon sizes: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda26__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda26_ ((DesktopView*) self, (const gchar*) key, (FileItem*) value);
}

static void
desktop_view_on_icon_theme_changed (DesktopView* self)
{
	FileItem* _tmp3_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		FileItem* _tmp0_;
		_tmp0_ = self->priv->home_item;
		file_item_update_icon (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("budgie_desktop_view.vala:823: Failed to update the icon for the Home i" \
"tem: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->trash_item;
	if (_tmp3_ != NULL) {
		{
			FileItem* _tmp4_;
			_tmp4_ = self->priv->trash_item;
			file_item_update_icon (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("budgie_desktop_view.vala:830: Failed to update the icon for the Trash " \
"item: %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = self->priv->mount_items;
	g_hash_table_foreach (_tmp7_, ___lambda25__gh_func, self);
	_tmp8_ = self->priv->file_items;
	g_hash_table_foreach (_tmp8_, ___lambda26__gh_func, self);
}

static void
desktop_view_on_icon_size_changed (DesktopView* self)
{
	g_return_if_fail (self != NULL);
	desktop_view_get_item_size (self);
	desktop_view_refresh_icon_sizes (self);
}

gboolean
desktop_view_on_key_pressed (DesktopView* self,
                             GdkEventKey* key)
{
	GList* selected_children = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	gboolean have_selected_children = FALSE;
	GList* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean is_arrow_key = FALSE;
	gboolean is_enter_key = FALSE;
	gboolean is_delete_key = FALSE;
	gboolean is_esc_key = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->flow;
	_tmp1_ = gtk_flow_box_get_selected_children (_tmp0_);
	selected_children = _tmp1_;
	_tmp2_ = selected_children;
	have_selected_children = g_list_length (_tmp2_) != ((guint) 0);
	if (key->keyval >= ((guint) 65361)) {
		_tmp3_ = key->keyval <= ((guint) 65364);
	} else {
		_tmp3_ = FALSE;
	}
	is_arrow_key = _tmp3_;
	is_enter_key = key->keyval == ((guint) 65293);
	is_delete_key = key->keyval == ((guint) 65535);
	is_esc_key = key->keyval == ((guint) 65307);
	if (is_arrow_key) {
		_tmp4_ = !have_selected_children;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkFlowBox* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = self->priv->flow;
		_tmp6_ = gtk_container_get_children ((GtkContainer*) _tmp5_);
		{
			GList* item_collection = NULL;
			GList* item_it = NULL;
			item_collection = _tmp6_;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				GtkWidget* _tmp7_;
				GtkWidget* item = NULL;
				_tmp7_ = _g_object_ref0 ((GtkWidget*) item_it->data);
				item = _tmp7_;
				{
					GtkWidget* _tmp8_;
					_tmp8_ = item;
					if (gtk_widget_is_visible (_tmp8_)) {
						GtkFlowBox* _tmp9_;
						GtkWidget* _tmp10_;
						GtkWidget* _tmp11_;
						_tmp9_ = self->priv->flow;
						_tmp10_ = item;
						gtk_flow_box_select_child (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_flow_box_child_get_type (), GtkFlowBoxChild));
						_tmp11_ = item;
						gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_flow_box_child_get_type (), GtkFlowBoxChild));
						_g_object_unref0 (item);
						break;
					}
					_g_object_unref0 (item);
				}
			}
			(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
		}
		result = GDK_EVENT_STOP;
		(selected_children == NULL) ? NULL : (selected_children = (g_list_free (selected_children), NULL));
		return result;
	} else {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		if (is_delete_key) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = is_enter_key;
		}
		if (_tmp13_) {
			_tmp12_ = have_selected_children;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			DesktopItem* generic_item = NULL;
			GList* _tmp14_;
			gconstpointer _tmp15_;
			DesktopItem* _tmp16_;
			_tmp14_ = selected_children;
			_tmp15_ = g_list_nth_data (_tmp14_, (guint) 0);
			_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkFlowBoxChild*) _tmp15_, TYPE_DESKTOP_ITEM, DesktopItem));
			generic_item = _tmp16_;
			if (is_delete_key) {
				gboolean _tmp17_ = FALSE;
				DesktopItem* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				FileItem* item_as_file = NULL;
				DesktopItem* _tmp24_;
				FileItem* _tmp25_;
				FileItem* _tmp26_;
				_tmp18_ = generic_item;
				_tmp19_ = desktop_item_get_is_special (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_) {
					_tmp17_ = TRUE;
				} else {
					DesktopItem* _tmp21_;
					gboolean _tmp22_;
					gboolean _tmp23_;
					_tmp21_ = generic_item;
					_tmp22_ = desktop_item_get_is_mount (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp17_ = _tmp23_;
				}
				if (_tmp17_) {
					result = GDK_EVENT_STOP;
					_g_object_unref0 (generic_item);
					(selected_children == NULL) ? NULL : (selected_children = (g_list_free (selected_children), NULL));
					return result;
				}
				_tmp24_ = generic_item;
				_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_FILE_ITEM, FileItem));
				item_as_file = _tmp25_;
				_tmp26_ = item_as_file;
				file_item_move_to_trash (_tmp26_);
				_g_object_unref0 (item_as_file);
			} else {
				DesktopItem* _tmp27_;
				gboolean _tmp28_;
				gboolean _tmp29_;
				_tmp27_ = generic_item;
				_tmp28_ = desktop_item_get_is_mount (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_) {
					MountItem* item_as_mount = NULL;
					DesktopItem* _tmp30_;
					MountItem* _tmp31_;
					MountItem* _tmp32_;
					_tmp30_ = generic_item;
					_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_MOUNT_ITEM, MountItem));
					item_as_mount = _tmp31_;
					_tmp32_ = item_as_mount;
					mount_item_launch (_tmp32_);
					_g_object_unref0 (item_as_mount);
				} else {
					FileItem* item_as_file = NULL;
					DesktopItem* _tmp33_;
					FileItem* _tmp34_;
					FileItem* _tmp35_;
					_tmp33_ = generic_item;
					_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_FILE_ITEM, FileItem));
					item_as_file = _tmp34_;
					_tmp35_ = item_as_file;
					file_item_launch (_tmp35_, FALSE);
					_g_object_unref0 (item_as_file);
				}
			}
			desktop_view_clear_selection (self);
			_g_object_unref0 (generic_item);
		} else {
			if (is_esc_key) {
				desktop_view_clear_selection (self);
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	(selected_children == NULL) ? NULL : (selected_children = (g_list_free (selected_children), NULL));
	return result;
}

void
desktop_view_on_mount_added (DesktopView* self,
                             GMount* mount)
{
	gchar* mount_uuid = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = desktop_view_get_mount_uuid (self, mount);
	mount_uuid = _tmp0_;
	_tmp1_ = mount_uuid;
	if (g_strcmp0 (_tmp1_, "FAILED_TO_GET_UUID") == 0) {
		_g_free0 (mount_uuid);
		return;
	}
	_tmp2_ = self->priv->mount_items;
	_tmp3_ = mount_uuid;
	if (g_hash_table_contains (_tmp2_, _tmp3_)) {
		_g_free0 (mount_uuid);
		return;
	}
	_tmp4_ = mount_uuid;
	desktop_view_create_mount_item (self, mount, _tmp4_, FALSE);
	desktop_view_enforce_content_limit (self);
	_g_free0 (mount_uuid);
}

void
desktop_view_on_mount_removed (DesktopView* self,
                               MountItem* mount_item)
{
	GtkFlowBox* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount_item != NULL);
	_tmp0_ = self->priv->flow;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) mount_item);
	_tmp1_ = self->priv->mount_items;
	_tmp2_ = mount_item->uuid;
	g_hash_table_remove (_tmp1_, _tmp2_);
	desktop_view_enforce_content_limit (self);
}

static void
desktop_view_on_raven_get (DesktopView* self,
                           GObject* obj,
                           GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		Raven* _tmp0_ = NULL;
		Raven* _tmp1_;
		Raven* _tmp2_;
		Raven* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (Raven*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (Raven*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven);
		self->priv->raven = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("budgie_desktop_view.vala:933: Failed to gain Raven: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
desktop_view_on_raven_lost (DesktopView* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->raven);
	self->priv->raven = NULL;
}

static gboolean
__lambda23_ (DesktopView* self)
{
	gboolean result;
	desktop_view_get_display_geo (self);
	desktop_view_get_item_size (self);
	desktop_view_enforce_content_limit (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda23_ ((DesktopView*) self);
	return result;
}

static void
desktop_view_on_resolution_change (DesktopView* self)
{
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, ___lambda23__gsource_func, g_object_ref (self), g_object_unref);
}

static void
desktop_view_on_show_changed (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	desktop_view_set_window_transparent (self);
	_tmp0_ = self->priv->shared_props;
	_tmp1_ = unified_props_get_desktop_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->visible_setting = g_settings_get_boolean (_tmp2_, "show");
	desktop_view_enforce_content_limit (self);
	if (self->priv->visible_setting) {
		gtk_widget_show ((GtkWidget*) self);
		desktop_view_update_window_position (self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}

void
desktop_view_on_show_active_mounts_changed (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shared_props;
	_tmp1_ = unified_props_get_desktop_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->show_mounts = g_settings_get_boolean (_tmp2_, "show-active-mounts");
	desktop_view_enforce_content_limit (self);
}

void
desktop_view_on_show_home_folder_changed (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shared_props;
	_tmp1_ = unified_props_get_desktop_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->show_home = g_settings_get_boolean (_tmp2_, "show-home-folder");
	desktop_view_enforce_content_limit (self);
}

void
desktop_view_on_show_trash_folder_changed (DesktopView* self)
{
	UnifiedProps* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shared_props;
	_tmp1_ = unified_props_get_desktop_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->show_trash = g_settings_get_boolean (_tmp2_, "show-trash-folder");
	desktop_view_enforce_content_limit (self);
}

static void
__lambda13_ (DesktopView* self,
             const gchar* key,
             MountItem* mount_item)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (key != NULL);
	{
		desktop_item_set_icon_factors ((DesktopItem*) mount_item, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("budgie_desktop_view.vala:1005: Failed to set icon factors for a MountI" \
"tem when refreshing icon sizes: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda13__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda13_ ((DesktopView*) self, (const gchar*) key, (MountItem*) value);
}

static void
__lambda14_ (DesktopView* self,
             const gchar* key,
             FileItem* file_item)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (key != NULL);
	{
		file_item_update_icon (file_item, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("budgie_desktop_view.vala:1013: Failed to set icon factors for a FileIt" \
"em when refreshing icon sizes: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda14__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda14_ ((DesktopView*) self, (const gchar*) key, (FileItem*) value);
}

void
desktop_view_refresh_icon_sizes (DesktopView* self)
{
	FileItem* _tmp3_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		FileItem* _tmp0_;
		_tmp0_ = self->priv->home_item;
		file_item_update_icon (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("budgie_desktop_view.vala:990: Failed to update the icon for the Home i" \
"tem: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->trash_item;
	if (_tmp3_ != NULL) {
		{
			FileItem* _tmp4_;
			_tmp4_ = self->priv->trash_item;
			file_item_update_icon (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("budgie_desktop_view.vala:997: Failed to update the icon for the Trash " \
"item: %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = self->priv->mount_items;
	g_hash_table_foreach (_tmp7_, ___lambda13__gh_func, self);
	_tmp8_ = self->priv->file_items;
	g_hash_table_foreach (_tmp8_, ___lambda14__gh_func, self);
	desktop_view_enforce_content_limit (self);
}

static GdkFilterReturn
__lambda24_ (DesktopView* self,
             GdkXEvent* xevent,
             GdkEvent* e)
{
	XEvent xev = {0};
	XEvent _tmp0_;
	XEvent _tmp1_;
	XPropertyEvent _tmp2_;
	GdkFilterReturn result;
	g_return_val_if_fail (xevent != NULL, 0);
	g_return_val_if_fail (e != NULL, 0);
	xev = *((XEvent*) xevent);
	_tmp0_ = xev;
	if (_tmp0_.type != ((gint) PropertyNotify)) {
		result = GDK_FILTER_CONTINUE;
		return result;
	}
	_tmp1_ = xev;
	_tmp2_ = _tmp1_.xproperty;
	if (_tmp2_.atom == gdk_x11_get_xatom_by_name ("_NET_WORKAREA")) {
		desktop_view_get_display_geo (self);
	}
	result = GDK_FILTER_CONTINUE;
	return result;
}

static GdkFilterReturn
___lambda24__gdk_filter_func (GdkXEvent* xevent,
                              GdkEvent* event,
                              gpointer self)
{
	GdkFilterReturn result;
	result = __lambda24_ ((DesktopView*) self, xevent, event);
	return result;
}

void
desktop_view_setup_root_window_event_handler (DesktopView* self)
{
	GdkWindow* root_window = NULL;
	GdkScreen* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_screen;
	_tmp1_ = gdk_screen_get_root_window (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	root_window = _tmp2_;
	gdk_window_set_events (root_window, GDK_ALL_EVENTS_MASK);
	gdk_window_add_filter (root_window, ___lambda24__gdk_filter_func, self);
	_g_object_unref0 (root_window);
}

static gint
__lambda16_ (FileItem* c1,
             FileItem* c2)
{
	gboolean c1_is_dir = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean c2_is_dir = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gchar* c1_ck = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* c2_ck = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GCompareFunc _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint result;
	g_return_val_if_fail (c1 != NULL, 0);
	g_return_val_if_fail (c2 != NULL, 0);
	_tmp0_ = desktop_item_get_item_type ((DesktopItem*) c1);
	_tmp1_ = _tmp0_;
	c1_is_dir = g_strcmp0 (_tmp1_, "dir") == 0;
	_tmp2_ = desktop_item_get_item_type ((DesktopItem*) c2);
	_tmp3_ = _tmp2_;
	c2_is_dir = g_strcmp0 (_tmp3_, "dir") == 0;
	if (c1_is_dir) {
		_tmp4_ = !c2_is_dir;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = -1;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		if (!c1_is_dir) {
			_tmp5_ = c2_is_dir;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = 1;
			return result;
		}
	}
	_tmp6_ = desktop_item_get_label_name ((DesktopItem*) c1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate_key_for_filename (_tmp7_, (gssize) -1);
	c1_ck = _tmp8_;
	_tmp9_ = desktop_item_get_label_name ((DesktopItem*) c2);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_utf8_collate_key_for_filename (_tmp10_, (gssize) -1);
	c2_ck = _tmp11_;
	_tmp12_ = ((GCompareFunc) g_strcmp0);
	_tmp13_ = c1_ck;
	_tmp14_ = c2_ck;
	result = _tmp12_ (_tmp13_, _tmp14_);
	_g_free0 (c2_ck);
	_g_free0 (c1_ck);
	return result;
}

static gint
___lambda16__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda16_ ((FileItem*) a, (FileItem*) b);
	return result;
}

static void
desktop_view_create_fileitem_sorter (DesktopView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->file_cmp = ___lambda16__gcompare_func;
}

static void
desktop_view_update_item_saturation (DesktopView* self,
                                     const gchar* item_name)
{
	FileItem* file_item = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	FileItem* _tmp2_;
	FileItem* _tmp3_;
	FileItem* _tmp4_;
	UnifiedProps* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_name != NULL);
	_tmp0_ = self->priv->file_items;
	_tmp1_ = g_hash_table_lookup (_tmp0_, item_name);
	_tmp2_ = _g_object_ref0 ((FileItem*) _tmp1_);
	file_item = _tmp2_;
	_tmp3_ = file_item;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (file_item);
		return;
	}
	_tmp4_ = file_item;
	_tmp5_ = self->priv->shared_props;
	desktop_item_set_is_copying ((DesktopItem*) _tmp4_, unified_props_is_copying (_tmp5_, item_name));
	_g_object_unref0 (file_item);
}

static gint
desktop_view_sorter (DesktopView* self,
                     GtkFlowBoxChild* child_one,
                     GtkFlowBoxChild* child_two)
{
	DesktopItem* c1 = NULL;
	DesktopItem* _tmp0_;
	DesktopItem* c2 = NULL;
	DesktopItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	DesktopItem* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean c1_is_mount = FALSE;
	DesktopItem* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gboolean c2_is_mount = FALSE;
	DesktopItem* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gboolean _tmp50_ = FALSE;
	GCompareFunc _tmp74_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (child_one != NULL, 0);
	g_return_val_if_fail (child_two != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child_one, TYPE_DESKTOP_ITEM, DesktopItem));
	c1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child_two, TYPE_DESKTOP_ITEM, DesktopItem));
	c2 = _tmp1_;
	_tmp3_ = c1;
	_tmp4_ = desktop_item_get_is_special (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		DesktopItem* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = c2;
		_tmp7_ = desktop_item_get_is_special (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = !_tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = -1;
		_g_object_unref0 (c2);
		_g_object_unref0 (c1);
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		DesktopItem* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = c1;
		_tmp11_ = desktop_item_get_is_special (_tmp10_);
		_tmp12_ = _tmp11_;
		if (!_tmp12_) {
			DesktopItem* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = c2;
			_tmp14_ = desktop_item_get_is_special (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = 1;
			_g_object_unref0 (c2);
			_g_object_unref0 (c1);
			return result;
		} else {
			gboolean _tmp16_ = FALSE;
			DesktopItem* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = c1;
			_tmp18_ = desktop_item_get_is_special (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_) {
				DesktopItem* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				_tmp20_ = c2;
				_tmp21_ = desktop_item_get_is_special (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp16_ = _tmp22_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gchar* c1_ck = NULL;
				DesktopItem* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				DesktopItem* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gchar* _tmp31_;
				gchar* c2_ck = NULL;
				DesktopItem* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				DesktopItem* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gchar* _tmp40_;
				GCompareFunc _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				_tmp23_ = c1;
				_tmp24_ = gtk_widget_get_name ((GtkWidget*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = c1;
				_tmp27_ = gtk_widget_get_name ((GtkWidget*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = strlen (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_utf8_collate_key_for_filename (_tmp25_, (gssize) _tmp30_);
				c1_ck = _tmp31_;
				_tmp32_ = c2;
				_tmp33_ = gtk_widget_get_name ((GtkWidget*) _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = c2;
				_tmp36_ = gtk_widget_get_name ((GtkWidget*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = strlen (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_utf8_collate_key_for_filename (_tmp34_, (gssize) _tmp39_);
				c2_ck = _tmp40_;
				_tmp41_ = ((GCompareFunc) g_strcmp0);
				_tmp42_ = c1_ck;
				_tmp43_ = c2_ck;
				result = _tmp41_ (_tmp42_, _tmp43_);
				_g_free0 (c2_ck);
				_g_free0 (c1_ck);
				_g_object_unref0 (c2);
				_g_object_unref0 (c1);
				return result;
			}
		}
	}
	_tmp44_ = c1;
	_tmp45_ = desktop_item_get_item_type (_tmp44_);
	_tmp46_ = _tmp45_;
	c1_is_mount = g_strcmp0 (_tmp46_, "mount") == 0;
	_tmp47_ = c2;
	_tmp48_ = desktop_item_get_item_type (_tmp47_);
	_tmp49_ = _tmp48_;
	c2_is_mount = g_strcmp0 (_tmp49_, "mount") == 0;
	if (c1_is_mount) {
		_tmp50_ = !c2_is_mount;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		result = -1;
		_g_object_unref0 (c2);
		_g_object_unref0 (c1);
		return result;
	} else {
		gboolean _tmp51_ = FALSE;
		if (!c1_is_mount) {
			_tmp51_ = c2_is_mount;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			result = 1;
			_g_object_unref0 (c2);
			_g_object_unref0 (c1);
			return result;
		} else {
			gboolean _tmp52_ = FALSE;
			if (c1_is_mount) {
				_tmp52_ = c2_is_mount;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				gchar* c1_ck = NULL;
				DesktopItem* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				DesktopItem* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				gchar* _tmp61_;
				gchar* c2_ck = NULL;
				DesktopItem* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				DesktopItem* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				gchar* _tmp70_;
				GCompareFunc _tmp71_;
				const gchar* _tmp72_;
				const gchar* _tmp73_;
				_tmp53_ = c1;
				_tmp54_ = desktop_item_get_label_name (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = c1;
				_tmp57_ = desktop_item_get_label_name (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = strlen (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_utf8_collate_key_for_filename (_tmp55_, (gssize) _tmp60_);
				c1_ck = _tmp61_;
				_tmp62_ = c2;
				_tmp63_ = desktop_item_get_label_name (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = c2;
				_tmp66_ = desktop_item_get_label_name (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = strlen (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = g_utf8_collate_key_for_filename (_tmp64_, (gssize) _tmp69_);
				c2_ck = _tmp70_;
				_tmp71_ = ((GCompareFunc) g_strcmp0);
				_tmp72_ = c1_ck;
				_tmp73_ = c2_ck;
				result = _tmp71_ (_tmp72_, _tmp73_);
				_g_free0 (c2_ck);
				_g_free0 (c1_ck);
				_g_object_unref0 (c2);
				_g_object_unref0 (c1);
				return result;
			}
		}
	}
	_tmp74_ = self->priv->file_cmp;
	result = _tmp74_ (G_TYPE_CHECK_INSTANCE_CAST (child_one, TYPE_FILE_ITEM, FileItem), G_TYPE_CHECK_INSTANCE_CAST (child_two, TYPE_FILE_ITEM, FileItem));
	_g_object_unref0 (c2);
	_g_object_unref0 (c1);
	return result;
}

void
desktop_view_set_window_transparent (DesktopView* self)
{
	GdkVisual* vis = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	vis = _tmp3_;
	_tmp4_ = vis;
	if (_tmp4_ == NULL) {
		g_warning ("budgie_desktop_view.vala:1106: Compositing is not supported. Please fi" \
"le a bug.");
	} else {
		GdkVisual* _tmp5_;
		_tmp5_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	_g_object_unref0 (vis);
}

static void
desktop_view_update_window_position (DesktopView* self)
{
	GdkRectangle* _tmp0_;
	GdkRectangle* _tmp1_;
	GtkFlowBox* _tmp2_;
	GdkRectangle* _tmp3_;
	GdkRectangle* _tmp4_;
	GdkRectangle* _tmp5_;
	GdkRectangle* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_monitor_geo;
	_tmp1_ = self->priv->primary_monitor_geo;
	gtk_window_set_default_size ((GtkWindow*) self, (*_tmp0_).width, (*_tmp1_).height);
	_tmp2_ = self->priv->flow;
	_tmp3_ = self->priv->primary_monitor_geo;
	_tmp4_ = self->priv->primary_monitor_geo;
	gtk_widget_set_size_request ((GtkWidget*) _tmp2_, (*_tmp3_).width, (*_tmp4_).height);
	_tmp5_ = self->priv->primary_monitor_geo;
	_tmp6_ = self->priv->primary_monitor_geo;
	gtk_window_move ((GtkWindow*) self, (*_tmp5_).x, (*_tmp6_).y);
}

static void
desktop_view_class_init (DesktopViewClass * klass,
                         gpointer klass_data)
{
	desktop_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DesktopView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = desktop_view_finalize;
}

static void
desktop_view_instance_init (DesktopView * self,
                            gpointer klass)
{
	self->priv = desktop_view_get_instance_private (self);
	self->priv->primary_monitor_geo = NULL;
	self->priv->raven = NULL;
	self->priv->home_item = NULL;
	self->priv->trash_item = NULL;
}

static void
desktop_view_finalize (GObject * obj)
{
	DesktopView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESKTOP_VIEW, DesktopView);
	_g_object_unref0 (self->priv->default_screen);
	_g_object_unref0 (self->priv->default_display);
	_g_object_unref0 (self->priv->primary_monitor);
	__vala_GdkRectangle_free0 (self->priv->primary_monitor_geo);
	_g_object_unref0 (self->priv->shared_props);
	_g_object_unref0 (self->priv->raven);
	_g_free0 (self->priv->item_size);
	_g_free0 (self->priv->max_allocated_item_height);
	_g_free0 (self->priv->max_allocated_item_width);
	_g_object_unref0 (self->priv->desktop_menu);
	_g_object_unref0 (self->priv->flow);
	_g_object_unref0 (self->priv->desktop_file);
	_g_free0 (self->priv->desktop_file_uri);
	_g_object_unref0 (self->priv->desktop_monitor);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->home_item);
	_g_object_unref0 (self->priv->trash_item);
	_g_hash_table_unref0 (self->priv->mount_items);
	_g_hash_table_unref0 (self->priv->file_items);
	G_OBJECT_CLASS (desktop_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
desktop_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DesktopViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopView), 0, (GInstanceInitFunc) desktop_view_instance_init, NULL };
	GType desktop_view_type_id;
	desktop_view_type_id = g_type_register_static (gtk_application_window_get_type (), "DesktopView", &g_define_type_info, 0);
	DesktopView_private_offset = g_type_add_instance_private (desktop_view_type_id, sizeof (DesktopViewPrivate));
	return desktop_view_type_id;
}

GType
desktop_view_get_type (void)
{
	static volatile gsize desktop_view_type_id__once = 0;
	if (g_once_init_enter (&desktop_view_type_id__once)) {
		GType desktop_view_type_id;
		desktop_view_type_id = desktop_view_get_type_once ();
		g_once_init_leave (&desktop_view_type_id__once, desktop_view_type_id);
	}
	return desktop_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

