/* NMVisualizer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NMVisualizer.vala, do not modify */

/*
 * Copyright (c) 2015-2018 elementary LLC (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "networkapplet.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <NetworkManager.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_NM_VISUALIZER_0_PROPERTY,
	NETWORK_WIDGETS_NM_VISUALIZER_SECURE_PROPERTY,
	NETWORK_WIDGETS_NM_VISUALIZER_EXTRA_INFO_PROPERTY,
	NETWORK_WIDGETS_NM_VISUALIZER_STATE_PROPERTY,
	NETWORK_WIDGETS_NM_VISUALIZER_NUM_PROPERTIES
};
static GParamSpec* network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _NetworkWidgetsNMVisualizerPrivate {
	gboolean _secure;
	gchar* _extra_info;
	NetworkState _state;
};

static gint NetworkWidgetsNMVisualizer_private_offset;
static gpointer network_widgets_nm_visualizer_parent_class = NULL;
static GType network_widgets_nm_visualizer_type_id = 0;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void network_widgets_nm_visualizer_real_build_ui (NetworkWidgetsNMVisualizer* self);
static void network_widgets_nm_visualizer_real_add_interface (NetworkWidgetsNMVisualizer* self,
                                                       NetworkWidgetNMInterface* widget_interface);
static void network_widgets_nm_visualizer_real_remove_interface (NetworkWidgetsNMVisualizer* self,
                                                          NetworkWidgetNMInterface* widget_interface);
static void network_widgets_nm_visualizer_device_removed_cb (NetworkWidgetsNMVisualizer* self,
                                                      NMDevice* device);
static void network_widgets_nm_visualizer_update_interfaces_names (NetworkWidgetsNMVisualizer* self);
static void network_widgets_nm_visualizer_update_state (NetworkWidgetsNMVisualizer* self);
static gint* _int_dup (gint* self);
static void network_widgets_nm_visualizer_device_added_cb (NetworkWidgetsNMVisualizer* self,
                                                    NMDevice* device);
static void _network_widgets_nm_visualizer_update_state_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void network_widgets_nm_visualizer_update_all (NetworkWidgetsNMVisualizer* self);
static void network_widgets_nm_visualizer_create_vpn_interface (NetworkWidgetsNMVisualizer* self);
static void network_widgets_nm_visualizer_set_state (NetworkWidgetsNMVisualizer* self,
                                              NetworkState value);
static void network_widgets_nm_visualizer_update_vpn_connection (NetworkWidgetsNMVisualizer* self);
static void __lambda35_ (NetworkWidgetsNMVisualizer* self,
                  NMActiveConnection* ac);
static void network_widgets_nm_visualizer_update_vpn_state (NetworkWidgetsNMVisualizer* self,
                                                     NMVpnConnectionState state);
static void ___lambda36_ (NetworkWidgetsNMVisualizer* self);
static void ____lambda36__nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                        guint state,
                                                        guint reason,
                                                        gpointer self);
static void ___lambda35__gfunc (gconstpointer data,
                         gpointer self);
static void network_widgets_nm_visualizer_set_secure (NetworkWidgetsNMVisualizer* self,
                                               gboolean value);
static GObject * network_widgets_nm_visualizer_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _network_widgets_nm_visualizer_update_vpn_connection_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void _network_widgets_nm_visualizer_device_added_cb_nm_client_device_added (NMClient* _sender,
                                                                            NMDevice* device,
                                                                            gpointer self);
static void _network_widgets_nm_visualizer_device_removed_cb_nm_client_device_removed (NMClient* _sender,
                                                                                NMDevice* device,
                                                                                gpointer self);
static void network_widgets_nm_visualizer_finalize (GObject * obj);
static void _vala_network_widgets_nm_visualizer_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_network_widgets_nm_visualizer_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
network_widgets_nm_visualizer_get_instance_private (NetworkWidgetsNMVisualizer* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsNMVisualizer_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
network_widgets_nm_visualizer_real_build_ui (NetworkWidgetsNMVisualizer* self)
{
	g_critical ("Type `%s' does not implement abstract method `network_widgets_nm_visualizer_build_ui'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
network_widgets_nm_visualizer_build_ui (NetworkWidgetsNMVisualizer* self)
{
	NetworkWidgetsNMVisualizerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_NM_VISUALIZER_GET_CLASS (self);
	if (_klass_->build_ui) {
		_klass_->build_ui (self);
	}
}

static void
network_widgets_nm_visualizer_real_add_interface (NetworkWidgetsNMVisualizer* self,
                                                  NetworkWidgetNMInterface* widget_interface)
{
	g_critical ("Type `%s' does not implement abstract method `network_widgets_nm_visualizer_add_interface'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
network_widgets_nm_visualizer_add_interface (NetworkWidgetsNMVisualizer* self,
                                             NetworkWidgetNMInterface* widget_interface)
{
	NetworkWidgetsNMVisualizerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_NM_VISUALIZER_GET_CLASS (self);
	if (_klass_->add_interface) {
		_klass_->add_interface (self, widget_interface);
	}
}

static void
network_widgets_nm_visualizer_real_remove_interface (NetworkWidgetsNMVisualizer* self,
                                                     NetworkWidgetNMInterface* widget_interface)
{
	g_critical ("Type `%s' does not implement abstract method `network_widgets_nm_visualizer_remove_interface'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
network_widgets_nm_visualizer_remove_interface (NetworkWidgetsNMVisualizer* self,
                                                NetworkWidgetNMInterface* widget_interface)
{
	NetworkWidgetsNMVisualizerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_NM_VISUALIZER_GET_CLASS (self);
	if (_klass_->remove_interface) {
		_klass_->remove_interface (self, widget_interface);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
network_widgets_nm_visualizer_device_removed_cb (NetworkWidgetsNMVisualizer* self,
                                                 NMDevice* device)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->network_interface;
	{
		GList* widget_interface_collection = NULL;
		GList* widget_interface_it = NULL;
		widget_interface_collection = _tmp0_;
		for (widget_interface_it = widget_interface_collection; widget_interface_it != NULL; widget_interface_it = widget_interface_it->next) {
			NetworkWidgetNMInterface* _tmp1_;
			NetworkWidgetNMInterface* widget_interface = NULL;
			_tmp1_ = _g_object_ref0 ((NetworkWidgetNMInterface*) widget_interface_it->data);
			widget_interface = _tmp1_;
			{
				NetworkWidgetNMInterface* _tmp2_;
				_tmp2_ = widget_interface;
				if (network_widget_nm_interface_is_device (_tmp2_, device)) {
					NetworkWidgetNMInterface* _tmp3_;
					NetworkWidgetNMInterface* _tmp4_;
					_tmp3_ = widget_interface;
					self->network_interface = vala_g_list_remove_full (self->network_interface, _tmp3_, _g_object_unref0_);
					_tmp4_ = widget_interface;
					network_widgets_nm_visualizer_remove_interface (self, _tmp4_);
					_g_object_unref0 (widget_interface);
					break;
				}
				_g_object_unref0 (widget_interface);
			}
		}
	}
	network_widgets_nm_visualizer_update_interfaces_names (self);
	network_widgets_nm_visualizer_update_state (self);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static void
network_widgets_nm_visualizer_update_interfaces_names (NetworkWidgetsNMVisualizer* self)
{
	GeeHashMap* count_type = NULL;
	GeeHashMap* _tmp0_;
	GList* _tmp1_;
	GList* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, (GBoxedCopyFunc) _int_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	count_type = _tmp0_;
	_tmp1_ = self->network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp1_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* _tmp2_;
			NetworkWidgetNMInterface* iface = NULL;
			_tmp2_ = _g_object_ref0 ((NetworkWidgetNMInterface*) iface_it->data);
			iface = _tmp2_;
			{
				gchar* type = NULL;
				NetworkWidgetNMInterface* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				GeeHashMap* _tmp6_;
				const gchar* _tmp7_;
				_tmp3_ = iface;
				_tmp4_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp3_));
				_tmp5_ = g_strdup (_tmp4_);
				type = _tmp5_;
				_tmp6_ = count_type;
				_tmp7_ = type;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_)) {
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					GeeHashMap* _tmp10_;
					const gchar* _tmp11_;
					gpointer _tmp12_;
					gint* _tmp13_;
					gint _tmp14_;
					_tmp8_ = count_type;
					_tmp9_ = type;
					_tmp10_ = count_type;
					_tmp11_ = type;
					_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
					_tmp13_ = (gint*) _tmp12_;
					_tmp14_ = (*_tmp13_) + 1;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, &_tmp14_);
					_g_free0 (_tmp13_);
				} else {
					GeeHashMap* _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					_tmp15_ = count_type;
					_tmp16_ = type;
					_tmp17_ = 1;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp16_, &_tmp17_);
				}
				_g_free0 (type);
				_g_object_unref0 (iface);
			}
		}
	}
	_tmp18_ = self->network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp18_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* _tmp19_;
			NetworkWidgetNMInterface* iface = NULL;
			_tmp19_ = _g_object_ref0 ((NetworkWidgetNMInterface*) iface_it->data);
			iface = _tmp19_;
			{
				gchar* type = NULL;
				NetworkWidgetNMInterface* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				NetworkWidgetNMInterface* _tmp23_;
				GeeHashMap* _tmp24_;
				const gchar* _tmp25_;
				gpointer _tmp26_;
				gint* _tmp27_;
				_tmp20_ = iface;
				_tmp21_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp20_));
				_tmp22_ = g_strdup (_tmp21_);
				type = _tmp22_;
				_tmp23_ = iface;
				_tmp24_ = count_type;
				_tmp25_ = type;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
				_tmp27_ = (gint*) _tmp26_;
				network_widget_nm_interface_update_name (_tmp23_, *_tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (type);
				_g_object_unref0 (iface);
			}
		}
	}
	_g_object_unref0 (count_type);
}

static void
_network_widgets_nm_visualizer_update_state_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	network_widgets_nm_visualizer_update_state ((NetworkWidgetsNMVisualizer*) self);
}

static void
network_widgets_nm_visualizer_device_added_cb (NetworkWidgetsNMVisualizer* self,
                                               NMDevice* device)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	NetworkWidgetNMInterface* widget_interface = NULL;
	NetworkWidgetNMInterface* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp3_ = nm_device_get_iface (device);
	if (g_str_has_prefix (_tmp3_, "vmnet")) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = nm_device_get_iface (device);
		_tmp2_ = g_str_has_prefix (_tmp4_, "lo");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = nm_device_get_iface (device);
		_tmp1_ = g_str_has_prefix (_tmp5_, "veth");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = nm_device_get_iface (device);
		_tmp0_ = g_str_has_prefix (_tmp6_, "vboxnet");
	}
	if (_tmp0_) {
		return;
	}
	widget_interface = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_wifi_get_type ())) {
		NMClient* _tmp7_;
		NetworkWifiInterface* _tmp8_;
		_tmp7_ = self->nm_client;
		_tmp8_ = network_wifi_interface_new (_tmp7_, device);
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (widget_interface);
		widget_interface = (NetworkWidgetNMInterface*) _tmp8_;
		g_debug ("NMVisualizer.vala:106: Wifi interface added");
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_ethernet_get_type ())) {
			NMClient* _tmp9_;
			NetworkEtherInterface* _tmp10_;
			_tmp9_ = self->nm_client;
			_tmp10_ = network_ether_interface_new (_tmp9_, device);
			g_object_ref_sink (_tmp10_);
			_g_object_unref0 (widget_interface);
			widget_interface = (NetworkWidgetNMInterface*) _tmp10_;
			g_debug ("NMVisualizer.vala:109: Wired interface added");
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_modem_get_type ())) {
				NMClient* _tmp11_;
				NetworkModemInterface* _tmp12_;
				_tmp11_ = self->nm_client;
				_tmp12_ = network_modem_interface_new (_tmp11_, device);
				g_object_ref_sink (_tmp12_);
				_g_object_unref0 (widget_interface);
				widget_interface = (NetworkWidgetNMInterface*) _tmp12_;
				g_debug ("NMVisualizer.vala:112: Modem interface added");
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_bt_get_type ())) {
					NMClient* _tmp13_;
					NetworkBluetoothInterface* _tmp14_;
					_tmp13_ = self->nm_client;
					_tmp14_ = network_bluetooth_interface_new (_tmp13_, device);
					g_object_ref_sink (_tmp14_);
					_g_object_unref0 (widget_interface);
					widget_interface = (NetworkWidgetNMInterface*) _tmp14_;
					g_debug ("NMVisualizer.vala:115: Bluetooth interface added");
				} else {
					GEnumValue* _tmp15_;
					_tmp15_ = g_enum_get_value (g_type_class_ref (nm_device_type_get_type ()), nm_device_get_device_type (device));
					g_debug ("NMVisualizer.vala:117: Unknown device: %s\n", (_tmp15_ != NULL) ? _tmp15_->value_name : NULL);
				}
			}
		}
	}
	_tmp16_ = widget_interface;
	if (_tmp16_ != NULL) {
		NetworkWidgetNMInterface* _tmp17_;
		NetworkWidgetNMInterface* _tmp18_;
		NetworkWidgetNMInterface* _tmp19_;
		NetworkWidgetNMInterface* _tmp20_;
		NetworkWidgetNMInterface* _tmp21_;
		_tmp17_ = widget_interface;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		self->network_interface = g_list_append (self->network_interface, _tmp18_);
		_tmp19_ = widget_interface;
		network_widgets_nm_visualizer_add_interface (self, _tmp19_);
		_tmp20_ = widget_interface;
		g_signal_connect_object ((GObject*) _tmp20_, "notify::state", (GCallback) _network_widgets_nm_visualizer_update_state_g_object_notify, self, 0);
		_tmp21_ = widget_interface;
		g_signal_connect_object ((GObject*) _tmp21_, "notify::extra-info", (GCallback) _network_widgets_nm_visualizer_update_state_g_object_notify, self, 0);
	}
	network_widgets_nm_visualizer_update_interfaces_names (self);
	network_widgets_nm_visualizer_update_all (self);
	network_widgets_nm_visualizer_update_state (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (widget_interface);
}

static void
network_widgets_nm_visualizer_create_vpn_interface (NetworkWidgetsNMVisualizer* self)
{
	NetworkWidgetNMInterface* widget_interface = NULL;
	NMClient* _tmp0_;
	NetworkVpnInterface* _tmp1_;
	NetworkWidgetNMInterface* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->nm_client;
	_tmp1_ = network_vpn_interface_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	widget_interface = (NetworkWidgetNMInterface*) _tmp1_;
	_tmp2_ = _g_object_ref0 (widget_interface);
	self->network_interface = g_list_append (self->network_interface, _tmp2_);
	network_widgets_nm_visualizer_add_interface (self, widget_interface);
	g_signal_connect_object ((GObject*) widget_interface, "notify::state", (GCallback) _network_widgets_nm_visualizer_update_state_g_object_notify, self, 0);
	_g_object_unref0 (widget_interface);
}

static void
network_widgets_nm_visualizer_update_all (NetworkWidgetsNMVisualizer* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->network_interface;
	{
		GList* inter_collection = NULL;
		GList* inter_it = NULL;
		inter_collection = _tmp0_;
		for (inter_it = inter_collection; inter_it != NULL; inter_it = inter_it->next) {
			NetworkWidgetNMInterface* _tmp1_;
			NetworkWidgetNMInterface* inter = NULL;
			_tmp1_ = _g_object_ref0 ((NetworkWidgetNMInterface*) inter_it->data);
			inter = _tmp1_;
			{
				NetworkWidgetNMInterface* _tmp2_;
				_tmp2_ = inter;
				network_widget_nm_interface_update (_tmp2_);
				_g_object_unref0 (inter);
			}
		}
	}
}

static void
network_widgets_nm_visualizer_update_state (NetworkWidgetsNMVisualizer* self)
{
	NMClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->nm_client;
	if (!nm_client_networking_get_enabled (_tmp0_)) {
		network_widgets_nm_visualizer_set_state (self, NETWORK_STATE_DISCONNECTED_AIRPLANE_MODE);
	} else {
		NetworkState next_state = 0;
		gint best_score = 0;
		GList* _tmp1_;
		next_state = NETWORK_STATE_DISCONNECTED;
		best_score = G_MAXINT;
		_tmp1_ = self->network_interface;
		{
			GList* inter_collection = NULL;
			GList* inter_it = NULL;
			inter_collection = _tmp1_;
			for (inter_it = inter_collection; inter_it != NULL; inter_it = inter_it->next) {
				NetworkWidgetNMInterface* _tmp2_;
				NetworkWidgetNMInterface* inter = NULL;
				_tmp2_ = _g_object_ref0 ((NetworkWidgetNMInterface*) inter_it->data);
				inter = _tmp2_;
				{
					gint score = 0;
					NetworkWidgetNMInterface* _tmp3_;
					NetworkState _tmp4_;
					NetworkState _tmp5_;
					_tmp3_ = inter;
					_tmp4_ = network_widget_nm_interface_get_state (_tmp3_);
					_tmp5_ = _tmp4_;
					score = network_state_get_priority (_tmp5_);
					if (score < best_score) {
						NetworkWidgetNMInterface* _tmp6_;
						NetworkState _tmp7_;
						NetworkState _tmp8_;
						NetworkWidgetNMInterface* _tmp9_;
						const gchar* _tmp10_;
						const gchar* _tmp11_;
						_tmp6_ = inter;
						_tmp7_ = network_widget_nm_interface_get_state (_tmp6_);
						_tmp8_ = _tmp7_;
						next_state = _tmp8_;
						best_score = score;
						_tmp9_ = inter;
						_tmp10_ = network_widget_nm_interface_get_extra_info (_tmp9_);
						_tmp11_ = _tmp10_;
						network_widgets_nm_visualizer_set_extra_info (self, _tmp11_);
					}
					_g_object_unref0 (inter);
				}
			}
		}
		network_widgets_nm_visualizer_set_state (self, next_state);
	}
}

static void
___lambda36_ (NetworkWidgetsNMVisualizer* self)
{
	NMVpnConnection* _tmp0_;
	_tmp0_ = self->active_vpn_connection;
	network_widgets_nm_visualizer_update_vpn_state (self, nm_vpn_connection_get_vpn_state (_tmp0_));
}

static void
____lambda36__nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                   guint state,
                                                   guint reason,
                                                   gpointer self)
{
	___lambda36_ ((NetworkWidgetsNMVisualizer*) self);
}

static void
__lambda35_ (NetworkWidgetsNMVisualizer* self,
             NMActiveConnection* ac)
{
	gboolean _tmp0_ = FALSE;
	NMVpnConnection* _tmp1_;
	g_return_if_fail (ac != NULL);
	_tmp1_ = self->active_vpn_connection;
	if (_tmp1_ == NULL) {
		_tmp0_ = nm_active_connection_get_vpn (ac);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NMVpnConnection* _tmp2_;
		NMVpnConnection* _tmp3_;
		NMVpnConnection* _tmp4_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ac, nm_vpn_connection_get_type (), NMVpnConnection));
		_g_object_unref0 (self->active_vpn_connection);
		self->active_vpn_connection = _tmp2_;
		_tmp3_ = self->active_vpn_connection;
		network_widgets_nm_visualizer_update_vpn_state (self, nm_vpn_connection_get_vpn_state (_tmp3_));
		_tmp4_ = self->active_vpn_connection;
		g_signal_connect_object (_tmp4_, "vpn-state-changed", (GCallback) ____lambda36__nm_vpn_connection_vpn_state_changed, self, 0);
	}
}

static void
___lambda35__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda35_ ((NetworkWidgetsNMVisualizer*) self, (NMActiveConnection*) data);
}

static void
network_widgets_nm_visualizer_update_vpn_connection (NetworkWidgetsNMVisualizer* self)
{
	NMClient* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->active_vpn_connection);
	self->active_vpn_connection = NULL;
	_tmp0_ = self->nm_client;
	_tmp1_ = nm_client_get_active_connections (_tmp0_);
	g_ptr_array_foreach (_tmp1_, ___lambda35__gfunc, self);
}

static void
network_widgets_nm_visualizer_update_vpn_state (NetworkWidgetsNMVisualizer* self,
                                                NMVpnConnectionState state)
{
	g_return_if_fail (self != NULL);
	switch (state) {
		case NM_VPN_CONNECTION_STATE_DISCONNECTED:
		case NM_VPN_CONNECTION_STATE_PREPARE:
		case NM_VPN_CONNECTION_STATE_IP_CONFIG_GET:
		case NM_VPN_CONNECTION_STATE_CONNECT:
		case NM_VPN_CONNECTION_STATE_FAILED:
		{
			network_widgets_nm_visualizer_set_secure (self, FALSE);
			break;
		}
		case NM_VPN_CONNECTION_STATE_ACTIVATED:
		{
			network_widgets_nm_visualizer_set_secure (self, TRUE);
			break;
		}
		default:
		break;
	}
}

NetworkWidgetsNMVisualizer*
network_widgets_nm_visualizer_construct (GType object_type)
{
	NetworkWidgetsNMVisualizer * self = NULL;
	self = (NetworkWidgetsNMVisualizer*) g_object_new (object_type, NULL);
	return self;
}

gboolean
network_widgets_nm_visualizer_get_secure (NetworkWidgetsNMVisualizer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_secure;
	return result;
}

static void
network_widgets_nm_visualizer_set_secure (NetworkWidgetsNMVisualizer* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_nm_visualizer_get_secure (self);
	if (old_value != value) {
		self->priv->_secure = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_SECURE_PROPERTY]);
	}
}

const gchar*
network_widgets_nm_visualizer_get_extra_info (NetworkWidgetsNMVisualizer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extra_info;
	result = _tmp0_;
	return result;
}

void
network_widgets_nm_visualizer_set_extra_info (NetworkWidgetsNMVisualizer* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_nm_visualizer_get_extra_info (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extra_info);
		self->priv->_extra_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_EXTRA_INFO_PROPERTY]);
	}
}

NetworkState
network_widgets_nm_visualizer_get_state (NetworkWidgetsNMVisualizer* self)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
network_widgets_nm_visualizer_set_state (NetworkWidgetsNMVisualizer* self,
                                         NetworkState value)
{
	NetworkState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_nm_visualizer_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_STATE_PROPERTY]);
	}
}

static void
_network_widgets_nm_visualizer_update_vpn_connection_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	network_widgets_nm_visualizer_update_vpn_connection ((NetworkWidgetsNMVisualizer*) self);
}

static void
_network_widgets_nm_visualizer_device_added_cb_nm_client_device_added (NMClient* _sender,
                                                                       NMDevice* device,
                                                                       gpointer self)
{
	network_widgets_nm_visualizer_device_added_cb ((NetworkWidgetsNMVisualizer*) self, device);
}

static void
_network_widgets_nm_visualizer_device_removed_cb_nm_client_device_removed (NMClient* _sender,
                                                                           NMDevice* device,
                                                                           gpointer self)
{
	network_widgets_nm_visualizer_device_removed_cb ((NetworkWidgetsNMVisualizer*) self, device);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static GObject *
network_widgets_nm_visualizer_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsNMVisualizer * self;
	NMClient* _tmp5_;
	NMClient* _tmp6_;
	NMClient* _tmp7_;
	NMClient* _tmp8_;
	GPtrArray* devices = NULL;
	NMClient* _tmp9_;
	GPtrArray* _tmp10_;
	GPtrArray* _tmp11_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (network_widgets_nm_visualizer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_NM_VISUALIZER, NetworkWidgetsNMVisualizer);
	(self->network_interface == NULL) ? NULL : (self->network_interface = (_g_list_free__g_object_unref0_ (self->network_interface), NULL));
	self->network_interface = NULL;
	network_widgets_nm_visualizer_build_ui (self);
	{
		NMClient* _tmp0_ = NULL;
		NMClient* _tmp1_;
		NMClient* _tmp2_;
		_tmp1_ = nm_client_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->nm_client);
		self->nm_client = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("NMVisualizer.vala:37: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp5_ = self->nm_client;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::active-connections", (GCallback) _network_widgets_nm_visualizer_update_vpn_connection_g_object_notify, self, 0);
	_tmp6_ = self->nm_client;
	g_signal_connect_object (_tmp6_, "device-added", (GCallback) _network_widgets_nm_visualizer_device_added_cb_nm_client_device_added, self, 0);
	_tmp7_ = self->nm_client;
	g_signal_connect_object (_tmp7_, "device-removed", (GCallback) _network_widgets_nm_visualizer_device_removed_cb_nm_client_device_removed, self, 0);
	_tmp8_ = self->nm_client;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::networking-enabled", (GCallback) _network_widgets_nm_visualizer_update_state_g_object_notify, self, 0);
	_tmp9_ = self->nm_client;
	_tmp10_ = nm_client_get_devices (_tmp9_);
	_tmp11_ = _g_ptr_array_ref0 (_tmp10_);
	devices = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				GPtrArray* _tmp17_;
				gconstpointer _tmp18_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = devices;
				_tmp15_ = vala_g_ptr_array_get_length (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(i < _tmp16_)) {
					break;
				}
				_tmp17_ = devices;
				_tmp18_ = g_ptr_array_index (_tmp17_, (guint) i);
				network_widgets_nm_visualizer_device_added_cb (self, (NMDevice*) _tmp18_);
			}
		}
	}
	network_widgets_nm_visualizer_create_vpn_interface (self);
	gtk_widget_show_all ((GtkWidget*) self);
	network_widgets_nm_visualizer_update_vpn_connection (self);
	_g_ptr_array_unref0 (devices);
	return obj;
}

static void
network_widgets_nm_visualizer_class_init (NetworkWidgetsNMVisualizerClass * klass,
                                          gpointer klass_data)
{
	network_widgets_nm_visualizer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsNMVisualizer_private_offset);
	((NetworkWidgetsNMVisualizerClass *) klass)->build_ui = (void (*) (NetworkWidgetsNMVisualizer*)) network_widgets_nm_visualizer_real_build_ui;
	((NetworkWidgetsNMVisualizerClass *) klass)->add_interface = (void (*) (NetworkWidgetsNMVisualizer*, NetworkWidgetNMInterface*)) network_widgets_nm_visualizer_real_add_interface;
	((NetworkWidgetsNMVisualizerClass *) klass)->remove_interface = (void (*) (NetworkWidgetsNMVisualizer*, NetworkWidgetNMInterface*)) network_widgets_nm_visualizer_real_remove_interface;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_widgets_nm_visualizer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_widgets_nm_visualizer_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_widgets_nm_visualizer_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_nm_visualizer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_NM_VISUALIZER_SECURE_PROPERTY, network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_SECURE_PROPERTY] = g_param_spec_boolean ("secure", "secure", "secure", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_NM_VISUALIZER_EXTRA_INFO_PROPERTY, network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_EXTRA_INFO_PROPERTY] = g_param_spec_string ("extra-info", "extra-info", "extra-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_NM_VISUALIZER_STATE_PROPERTY, network_widgets_nm_visualizer_properties[NETWORK_WIDGETS_NM_VISUALIZER_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", NETWORK_TYPE_STATE, NETWORK_STATE_CONNECTING_WIRED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
network_widgets_nm_visualizer_instance_init (NetworkWidgetsNMVisualizer * self,
                                             gpointer klass)
{
	self->priv = network_widgets_nm_visualizer_get_instance_private (self);
	self->active_vpn_connection = NULL;
	self->priv->_secure = FALSE;
	self->priv->_extra_info = NULL;
	self->priv->_state = NETWORK_STATE_CONNECTING_WIRED;
}

static void
network_widgets_nm_visualizer_finalize (GObject * obj)
{
	NetworkWidgetsNMVisualizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_NM_VISUALIZER, NetworkWidgetsNMVisualizer);
	_g_object_unref0 (self->nm_client);
	_g_object_unref0 (self->active_vpn_connection);
	(self->network_interface == NULL) ? NULL : (self->network_interface = (_g_list_free__g_object_unref0_ (self->network_interface), NULL));
	_g_free0 (self->priv->_extra_info);
	G_OBJECT_CLASS (network_widgets_nm_visualizer_parent_class)->finalize (obj);
}

GType
network_widgets_nm_visualizer_get_type (void)
{
	return network_widgets_nm_visualizer_type_id;
}

GType
network_widgets_nm_visualizer_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsNMVisualizerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_nm_visualizer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsNMVisualizer), 0, (GInstanceInitFunc) network_widgets_nm_visualizer_instance_init, NULL };
	network_widgets_nm_visualizer_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "NetworkWidgetsNMVisualizer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	NetworkWidgetsNMVisualizer_private_offset = sizeof (NetworkWidgetsNMVisualizerPrivate);
	return network_widgets_nm_visualizer_type_id;
}

static void
_vala_network_widgets_nm_visualizer_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	NetworkWidgetsNMVisualizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_NM_VISUALIZER, NetworkWidgetsNMVisualizer);
	switch (property_id) {
		case NETWORK_WIDGETS_NM_VISUALIZER_SECURE_PROPERTY:
		g_value_set_boolean (value, network_widgets_nm_visualizer_get_secure (self));
		break;
		case NETWORK_WIDGETS_NM_VISUALIZER_EXTRA_INFO_PROPERTY:
		g_value_set_string (value, network_widgets_nm_visualizer_get_extra_info (self));
		break;
		case NETWORK_WIDGETS_NM_VISUALIZER_STATE_PROPERTY:
		g_value_set_enum (value, network_widgets_nm_visualizer_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_widgets_nm_visualizer_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	NetworkWidgetsNMVisualizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_NM_VISUALIZER, NetworkWidgetsNMVisualizer);
	switch (property_id) {
		case NETWORK_WIDGETS_NM_VISUALIZER_SECURE_PROPERTY:
		network_widgets_nm_visualizer_set_secure (self, g_value_get_boolean (value));
		break;
		case NETWORK_WIDGETS_NM_VISUALIZER_EXTRA_INFO_PROPERTY:
		network_widgets_nm_visualizer_set_extra_info (self, g_value_get_string (value));
		break;
		case NETWORK_WIDGETS_NM_VISUALIZER_STATE_PROPERTY:
		network_widgets_nm_visualizer_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

