// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/repository_branch.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RepositoryBranch struct {
	state                              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                      string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name                    string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_LatestCommitName        string                 `protobuf:"bytes,3,opt,name=latest_commit_name,json=latestCommitName,proto3"`
	xxx_hidden_IsMainBranch            bool                   `protobuf:"varint,4,opt,name=is_main_branch,json=isMainBranch,proto3"`
	xxx_hidden_LastUpdateTime          *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_update_time,json=lastUpdateTime,proto3"`
	xxx_hidden_LastUpdateUserId        string                 `protobuf:"bytes,6,opt,name=last_update_user_id,json=lastUpdateUserId,proto3"`
	xxx_hidden_LastUpdateGitAuthorName string                 `protobuf:"bytes,7,opt,name=last_update_git_author_name,json=lastUpdateGitAuthorName,proto3"`
	xxx_hidden_LastUpdateGitCommitHash string                 `protobuf:"bytes,8,opt,name=last_update_git_commit_hash,json=lastUpdateGitCommitHash,proto3"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *RepositoryBranch) Reset() {
	*x = RepositoryBranch{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryBranch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryBranch) ProtoMessage() {}

func (x *RepositoryBranch) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryBranch) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RepositoryBranch) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *RepositoryBranch) GetLatestCommitName() string {
	if x != nil {
		return x.xxx_hidden_LatestCommitName
	}
	return ""
}

func (x *RepositoryBranch) GetIsMainBranch() bool {
	if x != nil {
		return x.xxx_hidden_IsMainBranch
	}
	return false
}

func (x *RepositoryBranch) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_LastUpdateTime
	}
	return nil
}

func (x *RepositoryBranch) GetLastUpdateUserId() string {
	if x != nil {
		return x.xxx_hidden_LastUpdateUserId
	}
	return ""
}

func (x *RepositoryBranch) GetLastUpdateGitAuthorName() string {
	if x != nil {
		return x.xxx_hidden_LastUpdateGitAuthorName
	}
	return ""
}

func (x *RepositoryBranch) GetLastUpdateGitCommitHash() string {
	if x != nil {
		return x.xxx_hidden_LastUpdateGitCommitHash
	}
	return ""
}

func (x *RepositoryBranch) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RepositoryBranch) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *RepositoryBranch) SetLatestCommitName(v string) {
	x.xxx_hidden_LatestCommitName = v
}

func (x *RepositoryBranch) SetIsMainBranch(v bool) {
	x.xxx_hidden_IsMainBranch = v
}

func (x *RepositoryBranch) SetLastUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_LastUpdateTime = v
}

func (x *RepositoryBranch) SetLastUpdateUserId(v string) {
	x.xxx_hidden_LastUpdateUserId = v
}

func (x *RepositoryBranch) SetLastUpdateGitAuthorName(v string) {
	x.xxx_hidden_LastUpdateGitAuthorName = v
}

func (x *RepositoryBranch) SetLastUpdateGitCommitHash(v string) {
	x.xxx_hidden_LastUpdateGitCommitHash = v
}

func (x *RepositoryBranch) HasLastUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LastUpdateTime != nil
}

func (x *RepositoryBranch) ClearLastUpdateTime() {
	x.xxx_hidden_LastUpdateTime = nil
}

type RepositoryBranch_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique.
	// branches are based on labels, so when a branch is pushed to, the ID will point to the
	// updated entry in the labels table.
	Id string
	// The name of the repository branch.
	Name string
	// The name of the latest commit on the branch.
	LatestCommitName string
	// is_main_branch denotes whether this branch is considered the main branch of the repository.
	IsMainBranch bool
	// The last update time of the branch.
	LastUpdateTime *timestamppb.Timestamp
	// The ID of the user who updated the branch.
	LastUpdateUserId string
	// The author name of the most recent associated git commit of the branch. May be an empty string
	// if no commit in the branch history contains any associated git commit.
	LastUpdateGitAuthorName string
	// The git commit hash of the most recent associated git commit of the branch. May be an empty
	// string if no commit in the branch history contains any associated git commit.
	LastUpdateGitCommitHash string
}

func (b0 RepositoryBranch_builder) Build() *RepositoryBranch {
	m0 := &RepositoryBranch{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_LatestCommitName = b.LatestCommitName
	x.xxx_hidden_IsMainBranch = b.IsMainBranch
	x.xxx_hidden_LastUpdateTime = b.LastUpdateTime
	x.xxx_hidden_LastUpdateUserId = b.LastUpdateUserId
	x.xxx_hidden_LastUpdateGitAuthorName = b.LastUpdateGitAuthorName
	x.xxx_hidden_LastUpdateGitCommitHash = b.LastUpdateGitCommitHash
	return m0
}

type GetRepositoryBranchRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_Name         string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetRepositoryBranchRequest) Reset() {
	*x = GetRepositoryBranchRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryBranchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryBranchRequest) ProtoMessage() {}

func (x *GetRepositoryBranchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryBranchRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *GetRepositoryBranchRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetRepositoryBranchRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *GetRepositoryBranchRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

type GetRepositoryBranchRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which the branch is requested.
	RepositoryId string
	// The name of the branch to get.
	Name string
}

func (b0 GetRepositoryBranchRequest_builder) Build() *GetRepositoryBranchRequest {
	m0 := &GetRepositoryBranchRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_Name = b.Name
	return m0
}

type GetRepositoryBranchResponse struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Branch *RepositoryBranch      `protobuf:"bytes,1,opt,name=branch,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GetRepositoryBranchResponse) Reset() {
	*x = GetRepositoryBranchResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryBranchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryBranchResponse) ProtoMessage() {}

func (x *GetRepositoryBranchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryBranchResponse) GetBranch() *RepositoryBranch {
	if x != nil {
		return x.xxx_hidden_Branch
	}
	return nil
}

func (x *GetRepositoryBranchResponse) SetBranch(v *RepositoryBranch) {
	x.xxx_hidden_Branch = v
}

func (x *GetRepositoryBranchResponse) HasBranch() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Branch != nil
}

func (x *GetRepositoryBranchResponse) ClearBranch() {
	x.xxx_hidden_Branch = nil
}

type GetRepositoryBranchResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Branch *RepositoryBranch
}

func (b0 GetRepositoryBranchResponse_builder) Build() *GetRepositoryBranchResponse {
	m0 := &GetRepositoryBranchResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Branch = b.Branch
	return m0
}

type ListRepositoryBranchesRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_PageSize     uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken    string                 `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListRepositoryBranchesRequest) Reset() {
	*x = ListRepositoryBranchesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryBranchesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryBranchesRequest) ProtoMessage() {}

func (x *ListRepositoryBranchesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryBranchesRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListRepositoryBranchesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryBranchesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryBranchesRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListRepositoryBranchesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryBranchesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

type ListRepositoryBranchesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository whose branches should be listed.
	RepositoryId string
	PageSize     uint32
	// The first page is returned if this is empty.
	PageToken string
}

func (b0 ListRepositoryBranchesRequest_builder) Build() *ListRepositoryBranchesRequest {
	m0 := &ListRepositoryBranchesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	return m0
}

type ListRepositoryBranchesResponse struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryBranches *[]*RepositoryBranch   `protobuf:"bytes,1,rep,name=repository_branches,json=repositoryBranches,proto3"`
	xxx_hidden_NextPageToken      string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *ListRepositoryBranchesResponse) Reset() {
	*x = ListRepositoryBranchesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryBranchesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryBranchesResponse) ProtoMessage() {}

func (x *ListRepositoryBranchesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryBranchesResponse) GetRepositoryBranches() []*RepositoryBranch {
	if x != nil {
		if x.xxx_hidden_RepositoryBranches != nil {
			return *x.xxx_hidden_RepositoryBranches
		}
	}
	return nil
}

func (x *ListRepositoryBranchesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryBranchesResponse) SetRepositoryBranches(v []*RepositoryBranch) {
	x.xxx_hidden_RepositoryBranches = &v
}

func (x *ListRepositoryBranchesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryBranchesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryBranches []*RepositoryBranch
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoryBranchesResponse_builder) Build() *ListRepositoryBranchesResponse {
	m0 := &ListRepositoryBranchesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryBranches = &b.RepositoryBranches
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListRepositoryBranchesByReferenceRequest struct {
	state                   protoimpl.MessageState                               `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                                               `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_PageSize     uint32                                               `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken    string                                               `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reference    isListRepositoryBranchesByReferenceRequest_Reference `protobuf_oneof:"reference"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListRepositoryBranchesByReferenceRequest) Reset() {
	*x = ListRepositoryBranchesByReferenceRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryBranchesByReferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryBranchesByReferenceRequest) ProtoMessage() {}

func (x *ListRepositoryBranchesByReferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryBranchesByReferenceRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListRepositoryBranchesByReferenceRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryBranchesByReferenceRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryBranchesByReferenceRequest) GetCommitName() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Reference.(*listRepositoryBranchesByReferenceRequest_CommitName); ok {
			return x.CommitName
		}
	}
	return ""
}

func (x *ListRepositoryBranchesByReferenceRequest) GetVcsCommitHash() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Reference.(*listRepositoryBranchesByReferenceRequest_VcsCommitHash); ok {
			return x.VcsCommitHash
		}
	}
	return ""
}

func (x *ListRepositoryBranchesByReferenceRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListRepositoryBranchesByReferenceRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryBranchesByReferenceRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryBranchesByReferenceRequest) SetCommitName(v string) {
	x.xxx_hidden_Reference = &listRepositoryBranchesByReferenceRequest_CommitName{v}
}

func (x *ListRepositoryBranchesByReferenceRequest) SetVcsCommitHash(v string) {
	x.xxx_hidden_Reference = &listRepositoryBranchesByReferenceRequest_VcsCommitHash{v}
}

func (x *ListRepositoryBranchesByReferenceRequest) HasReference() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Reference != nil
}

func (x *ListRepositoryBranchesByReferenceRequest) HasCommitName() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Reference.(*listRepositoryBranchesByReferenceRequest_CommitName)
	return ok
}

func (x *ListRepositoryBranchesByReferenceRequest) HasVcsCommitHash() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Reference.(*listRepositoryBranchesByReferenceRequest_VcsCommitHash)
	return ok
}

func (x *ListRepositoryBranchesByReferenceRequest) ClearReference() {
	x.xxx_hidden_Reference = nil
}

func (x *ListRepositoryBranchesByReferenceRequest) ClearCommitName() {
	if _, ok := x.xxx_hidden_Reference.(*listRepositoryBranchesByReferenceRequest_CommitName); ok {
		x.xxx_hidden_Reference = nil
	}
}

func (x *ListRepositoryBranchesByReferenceRequest) ClearVcsCommitHash() {
	if _, ok := x.xxx_hidden_Reference.(*listRepositoryBranchesByReferenceRequest_VcsCommitHash); ok {
		x.xxx_hidden_Reference = nil
	}
}

const ListRepositoryBranchesByReferenceRequest_Reference_not_set_case case_ListRepositoryBranchesByReferenceRequest_Reference = 0
const ListRepositoryBranchesByReferenceRequest_CommitName_case case_ListRepositoryBranchesByReferenceRequest_Reference = 4
const ListRepositoryBranchesByReferenceRequest_VcsCommitHash_case case_ListRepositoryBranchesByReferenceRequest_Reference = 5

func (x *ListRepositoryBranchesByReferenceRequest) WhichReference() case_ListRepositoryBranchesByReferenceRequest_Reference {
	if x == nil {
		return ListRepositoryBranchesByReferenceRequest_Reference_not_set_case
	}
	switch x.xxx_hidden_Reference.(type) {
	case *listRepositoryBranchesByReferenceRequest_CommitName:
		return ListRepositoryBranchesByReferenceRequest_CommitName_case
	case *listRepositoryBranchesByReferenceRequest_VcsCommitHash:
		return ListRepositoryBranchesByReferenceRequest_VcsCommitHash_case
	default:
		return ListRepositoryBranchesByReferenceRequest_Reference_not_set_case
	}
}

type ListRepositoryBranchesByReferenceRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository whose branches should be listed.
	RepositoryId string
	PageSize     uint32
	// The first page is returned if this is empty.
	PageToken string
	// The reference by which to filter the returned branches.

	// Fields of oneof xxx_hidden_Reference:
	// The name of a BSR commit. This will filter the branches to only those that include the commit.
	CommitName *string
	// The hash of a VCS commit. This will filter the branches to only those that include the commit
	// associated with the VCS hash.
	VcsCommitHash *string
	// -- end of xxx_hidden_Reference
}

func (b0 ListRepositoryBranchesByReferenceRequest_builder) Build() *ListRepositoryBranchesByReferenceRequest {
	m0 := &ListRepositoryBranchesByReferenceRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	if b.CommitName != nil {
		x.xxx_hidden_Reference = &listRepositoryBranchesByReferenceRequest_CommitName{*b.CommitName}
	}
	if b.VcsCommitHash != nil {
		x.xxx_hidden_Reference = &listRepositoryBranchesByReferenceRequest_VcsCommitHash{*b.VcsCommitHash}
	}
	return m0
}

type case_ListRepositoryBranchesByReferenceRequest_Reference protoreflect.FieldNumber

func (x case_ListRepositoryBranchesByReferenceRequest_Reference) String() string {
	md := file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[5].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isListRepositoryBranchesByReferenceRequest_Reference interface {
	isListRepositoryBranchesByReferenceRequest_Reference()
}

type listRepositoryBranchesByReferenceRequest_CommitName struct {
	// The name of a BSR commit. This will filter the branches to only those that include the commit.
	CommitName string `protobuf:"bytes,4,opt,name=commit_name,json=commitName,proto3,oneof"`
}

type listRepositoryBranchesByReferenceRequest_VcsCommitHash struct {
	// The hash of a VCS commit. This will filter the branches to only those that include the commit
	// associated with the VCS hash.
	VcsCommitHash string `protobuf:"bytes,5,opt,name=vcs_commit_hash,json=vcsCommitHash,proto3,oneof"`
}

func (*listRepositoryBranchesByReferenceRequest_CommitName) isListRepositoryBranchesByReferenceRequest_Reference() {
}

func (*listRepositoryBranchesByReferenceRequest_VcsCommitHash) isListRepositoryBranchesByReferenceRequest_Reference() {
}

type ListRepositoryBranchesByReferenceResponse struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryBranches *[]*RepositoryBranch   `protobuf:"bytes,1,rep,name=repository_branches,json=repositoryBranches,proto3"`
	xxx_hidden_NextPageToken      string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *ListRepositoryBranchesByReferenceResponse) Reset() {
	*x = ListRepositoryBranchesByReferenceResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryBranchesByReferenceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryBranchesByReferenceResponse) ProtoMessage() {}

func (x *ListRepositoryBranchesByReferenceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryBranchesByReferenceResponse) GetRepositoryBranches() []*RepositoryBranch {
	if x != nil {
		if x.xxx_hidden_RepositoryBranches != nil {
			return *x.xxx_hidden_RepositoryBranches
		}
	}
	return nil
}

func (x *ListRepositoryBranchesByReferenceResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryBranchesByReferenceResponse) SetRepositoryBranches(v []*RepositoryBranch) {
	x.xxx_hidden_RepositoryBranches = &v
}

func (x *ListRepositoryBranchesByReferenceResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryBranchesByReferenceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryBranches []*RepositoryBranch
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListRepositoryBranchesByReferenceResponse_builder) Build() *ListRepositoryBranchesByReferenceResponse {
	m0 := &ListRepositoryBranchesByReferenceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryBranches = &b.RepositoryBranches
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type GetCurrentDefaultBranchRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetCurrentDefaultBranchRequest) Reset() {
	*x = GetCurrentDefaultBranchRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCurrentDefaultBranchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCurrentDefaultBranchRequest) ProtoMessage() {}

func (x *GetCurrentDefaultBranchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCurrentDefaultBranchRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *GetCurrentDefaultBranchRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type GetCurrentDefaultBranchRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository whose current default branch is returned.
	RepositoryId string
}

func (b0 GetCurrentDefaultBranchRequest_builder) Build() *GetCurrentDefaultBranchRequest {
	m0 := &GetCurrentDefaultBranchRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type GetCurrentDefaultBranchResponse struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CurrentDefaultBranch *RepositoryBranch      `protobuf:"bytes,1,opt,name=current_default_branch,json=currentDefaultBranch,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *GetCurrentDefaultBranchResponse) Reset() {
	*x = GetCurrentDefaultBranchResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCurrentDefaultBranchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCurrentDefaultBranchResponse) ProtoMessage() {}

func (x *GetCurrentDefaultBranchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCurrentDefaultBranchResponse) GetCurrentDefaultBranch() *RepositoryBranch {
	if x != nil {
		return x.xxx_hidden_CurrentDefaultBranch
	}
	return nil
}

func (x *GetCurrentDefaultBranchResponse) SetCurrentDefaultBranch(v *RepositoryBranch) {
	x.xxx_hidden_CurrentDefaultBranch = v
}

func (x *GetCurrentDefaultBranchResponse) HasCurrentDefaultBranch() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CurrentDefaultBranch != nil
}

func (x *GetCurrentDefaultBranchResponse) ClearCurrentDefaultBranch() {
	x.xxx_hidden_CurrentDefaultBranch = nil
}

type GetCurrentDefaultBranchResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	CurrentDefaultBranch *RepositoryBranch
}

func (b0 GetCurrentDefaultBranchResponse_builder) Build() *GetCurrentDefaultBranchResponse {
	m0 := &GetCurrentDefaultBranchResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CurrentDefaultBranch = b.CurrentDefaultBranch
	return m0
}

var File_buf_alpha_registry_v1alpha1_repository_branch_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_repository_branch_proto_rawDesc = "" +
	"\n" +
	"3buf/alpha/registry/v1alpha1/repository_branch.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xfb\x02\n" +
	"\x10RepositoryBranch\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12,\n" +
	"\x12latest_commit_name\x18\x03 \x01(\tR\x10latestCommitName\x12$\n" +
	"\x0eis_main_branch\x18\x04 \x01(\bR\fisMainBranch\x12D\n" +
	"\x10last_update_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\x0elastUpdateTime\x12-\n" +
	"\x13last_update_user_id\x18\x06 \x01(\tR\x10lastUpdateUserId\x12<\n" +
	"\x1blast_update_git_author_name\x18\a \x01(\tR\x17lastUpdateGitAuthorName\x12<\n" +
	"\x1blast_update_git_commit_hash\x18\b \x01(\tR\x17lastUpdateGitCommitHash\"U\n" +
	"\x1aGetRepositoryBranchRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\"d\n" +
	"\x1bGetRepositoryBranchResponse\x12E\n" +
	"\x06branch\x18\x01 \x01(\v2-.buf.alpha.registry.v1alpha1.RepositoryBranchR\x06branch\"\x80\x01\n" +
	"\x1dListRepositoryBranchesRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\"\xa8\x01\n" +
	"\x1eListRepositoryBranchesResponse\x12^\n" +
	"\x13repository_branches\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.RepositoryBranchR\x12repositoryBranches\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xe5\x01\n" +
	"(ListRepositoryBranchesByReferenceRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12!\n" +
	"\vcommit_name\x18\x04 \x01(\tH\x00R\n" +
	"commitName\x12(\n" +
	"\x0fvcs_commit_hash\x18\x05 \x01(\tH\x00R\rvcsCommitHashB\v\n" +
	"\treference\"\xb3\x01\n" +
	")ListRepositoryBranchesByReferenceResponse\x12^\n" +
	"\x13repository_branches\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.RepositoryBranchR\x12repositoryBranches\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"E\n" +
	"\x1eGetCurrentDefaultBranchRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"\x86\x01\n" +
	"\x1fGetCurrentDefaultBranchResponse\x12c\n" +
	"\x16current_default_branch\x18\x01 \x01(\v2-.buf.alpha.registry.v1alpha1.RepositoryBranchR\x14currentDefaultBranch2\x98\x05\n" +
	"\x17RepositoryBranchService\x12\x8d\x01\n" +
	"\x13GetRepositoryBranch\x127.buf.alpha.registry.v1alpha1.GetRepositoryBranchRequest\x1a8.buf.alpha.registry.v1alpha1.GetRepositoryBranchResponse\"\x03\x90\x02\x01\x12\x96\x01\n" +
	"\x16ListRepositoryBranches\x12:.buf.alpha.registry.v1alpha1.ListRepositoryBranchesRequest\x1a;.buf.alpha.registry.v1alpha1.ListRepositoryBranchesResponse\"\x03\x90\x02\x01\x12\xb7\x01\n" +
	"!ListRepositoryBranchesByReference\x12E.buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceRequest\x1aF.buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceResponse\"\x03\x90\x02\x01\x12\x99\x01\n" +
	"\x17GetCurrentDefaultBranch\x12;.buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchRequest\x1a<.buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchResponse\"\x03\x90\x02\x01B\xa2\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x15RepositoryBranchProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_buf_alpha_registry_v1alpha1_repository_branch_proto_goTypes = []any{
	(*RepositoryBranch)(nil),                          // 0: buf.alpha.registry.v1alpha1.RepositoryBranch
	(*GetRepositoryBranchRequest)(nil),                // 1: buf.alpha.registry.v1alpha1.GetRepositoryBranchRequest
	(*GetRepositoryBranchResponse)(nil),               // 2: buf.alpha.registry.v1alpha1.GetRepositoryBranchResponse
	(*ListRepositoryBranchesRequest)(nil),             // 3: buf.alpha.registry.v1alpha1.ListRepositoryBranchesRequest
	(*ListRepositoryBranchesResponse)(nil),            // 4: buf.alpha.registry.v1alpha1.ListRepositoryBranchesResponse
	(*ListRepositoryBranchesByReferenceRequest)(nil),  // 5: buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceRequest
	(*ListRepositoryBranchesByReferenceResponse)(nil), // 6: buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceResponse
	(*GetCurrentDefaultBranchRequest)(nil),            // 7: buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchRequest
	(*GetCurrentDefaultBranchResponse)(nil),           // 8: buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchResponse
	(*timestamppb.Timestamp)(nil),                     // 9: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_repository_branch_proto_depIdxs = []int32{
	9, // 0: buf.alpha.registry.v1alpha1.RepositoryBranch.last_update_time:type_name -> google.protobuf.Timestamp
	0, // 1: buf.alpha.registry.v1alpha1.GetRepositoryBranchResponse.branch:type_name -> buf.alpha.registry.v1alpha1.RepositoryBranch
	0, // 2: buf.alpha.registry.v1alpha1.ListRepositoryBranchesResponse.repository_branches:type_name -> buf.alpha.registry.v1alpha1.RepositoryBranch
	0, // 3: buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceResponse.repository_branches:type_name -> buf.alpha.registry.v1alpha1.RepositoryBranch
	0, // 4: buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchResponse.current_default_branch:type_name -> buf.alpha.registry.v1alpha1.RepositoryBranch
	1, // 5: buf.alpha.registry.v1alpha1.RepositoryBranchService.GetRepositoryBranch:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryBranchRequest
	3, // 6: buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranches:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryBranchesRequest
	5, // 7: buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranchesByReference:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceRequest
	7, // 8: buf.alpha.registry.v1alpha1.RepositoryBranchService.GetCurrentDefaultBranch:input_type -> buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchRequest
	2, // 9: buf.alpha.registry.v1alpha1.RepositoryBranchService.GetRepositoryBranch:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryBranchResponse
	4, // 10: buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranches:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryBranchesResponse
	6, // 11: buf.alpha.registry.v1alpha1.RepositoryBranchService.ListRepositoryBranchesByReference:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryBranchesByReferenceResponse
	8, // 12: buf.alpha.registry.v1alpha1.RepositoryBranchService.GetCurrentDefaultBranch:output_type -> buf.alpha.registry.v1alpha1.GetCurrentDefaultBranchResponse
	9, // [9:13] is the sub-list for method output_type
	5, // [5:9] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_repository_branch_proto_init() }
func file_buf_alpha_registry_v1alpha1_repository_branch_proto_init() {
	if File_buf_alpha_registry_v1alpha1_repository_branch_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes[5].OneofWrappers = []any{
		(*listRepositoryBranchesByReferenceRequest_CommitName)(nil),
		(*listRepositoryBranchesByReferenceRequest_VcsCommitHash)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_repository_branch_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_repository_branch_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_repository_branch_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_repository_branch_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_repository_branch_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_repository_branch_proto = out.File
	file_buf_alpha_registry_v1alpha1_repository_branch_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_repository_branch_proto_depIdxs = nil
}
