//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha3

import (
	unsafe "unsafe"

	metav1 "github.com/cert-manager/cert-manager/pkg/apis/meta/v1"
	acme "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/acme"
	acmev1alpha3 "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/acme/v1alpha3"
	certmanager "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/certmanager"
	meta "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/meta"
	apismetav1 "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/meta/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*CAIssuer)(nil), (*certmanager.CAIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(a.(*CAIssuer), b.(*certmanager.CAIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CAIssuer)(nil), (*CAIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(a.(*certmanager.CAIssuer), b.(*CAIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Certificate)(nil), (*certmanager.Certificate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Certificate_To_certmanager_Certificate(a.(*Certificate), b.(*certmanager.Certificate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.Certificate)(nil), (*Certificate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_Certificate_To_v1alpha3_Certificate(a.(*certmanager.Certificate), b.(*Certificate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateAdditionalOutputFormat)(nil), (*certmanager.CertificateAdditionalOutputFormat)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(a.(*CertificateAdditionalOutputFormat), b.(*certmanager.CertificateAdditionalOutputFormat), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateAdditionalOutputFormat)(nil), (*CertificateAdditionalOutputFormat)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateAdditionalOutputFormat_To_v1alpha3_CertificateAdditionalOutputFormat(a.(*certmanager.CertificateAdditionalOutputFormat), b.(*CertificateAdditionalOutputFormat), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateCondition)(nil), (*certmanager.CertificateCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(a.(*CertificateCondition), b.(*certmanager.CertificateCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateCondition)(nil), (*CertificateCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(a.(*certmanager.CertificateCondition), b.(*CertificateCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateKeystores)(nil), (*certmanager.CertificateKeystores)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(a.(*CertificateKeystores), b.(*certmanager.CertificateKeystores), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateKeystores)(nil), (*CertificateKeystores)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(a.(*certmanager.CertificateKeystores), b.(*CertificateKeystores), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateList)(nil), (*certmanager.CertificateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateList_To_certmanager_CertificateList(a.(*CertificateList), b.(*certmanager.CertificateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateList)(nil), (*CertificateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateList_To_v1alpha3_CertificateList(a.(*certmanager.CertificateList), b.(*CertificateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificatePrivateKey)(nil), (*certmanager.CertificatePrivateKey)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(a.(*CertificatePrivateKey), b.(*certmanager.CertificatePrivateKey), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateRequest)(nil), (*certmanager.CertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(a.(*CertificateRequest), b.(*certmanager.CertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequest)(nil), (*CertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(a.(*certmanager.CertificateRequest), b.(*CertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateRequestCondition)(nil), (*certmanager.CertificateRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(a.(*CertificateRequestCondition), b.(*certmanager.CertificateRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestCondition)(nil), (*CertificateRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(a.(*certmanager.CertificateRequestCondition), b.(*CertificateRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateRequestList)(nil), (*certmanager.CertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(a.(*CertificateRequestList), b.(*certmanager.CertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestList)(nil), (*CertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(a.(*certmanager.CertificateRequestList), b.(*CertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateRequestStatus)(nil), (*certmanager.CertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(a.(*CertificateRequestStatus), b.(*certmanager.CertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestStatus)(nil), (*CertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(a.(*certmanager.CertificateRequestStatus), b.(*CertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateSecretTemplate)(nil), (*certmanager.CertificateSecretTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(a.(*CertificateSecretTemplate), b.(*certmanager.CertificateSecretTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateSecretTemplate)(nil), (*CertificateSecretTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateSecretTemplate_To_v1alpha3_CertificateSecretTemplate(a.(*certmanager.CertificateSecretTemplate), b.(*CertificateSecretTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CertificateStatus)(nil), (*certmanager.CertificateStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(a.(*CertificateStatus), b.(*certmanager.CertificateStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateStatus)(nil), (*CertificateStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(a.(*certmanager.CertificateStatus), b.(*CertificateStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterIssuer)(nil), (*certmanager.ClusterIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(a.(*ClusterIssuer), b.(*certmanager.ClusterIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ClusterIssuer)(nil), (*ClusterIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(a.(*certmanager.ClusterIssuer), b.(*ClusterIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterIssuerList)(nil), (*certmanager.ClusterIssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(a.(*ClusterIssuerList), b.(*certmanager.ClusterIssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ClusterIssuerList)(nil), (*ClusterIssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(a.(*certmanager.ClusterIssuerList), b.(*ClusterIssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Issuer)(nil), (*certmanager.Issuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Issuer_To_certmanager_Issuer(a.(*Issuer), b.(*certmanager.Issuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.Issuer)(nil), (*Issuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_Issuer_To_v1alpha3_Issuer(a.(*certmanager.Issuer), b.(*Issuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IssuerCondition)(nil), (*certmanager.IssuerCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(a.(*IssuerCondition), b.(*certmanager.IssuerCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerCondition)(nil), (*IssuerCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(a.(*certmanager.IssuerCondition), b.(*IssuerCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IssuerConfig)(nil), (*certmanager.IssuerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(a.(*IssuerConfig), b.(*certmanager.IssuerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerConfig)(nil), (*IssuerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(a.(*certmanager.IssuerConfig), b.(*IssuerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IssuerList)(nil), (*certmanager.IssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerList_To_certmanager_IssuerList(a.(*IssuerList), b.(*certmanager.IssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerList)(nil), (*IssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerList_To_v1alpha3_IssuerList(a.(*certmanager.IssuerList), b.(*IssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IssuerSpec)(nil), (*certmanager.IssuerSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(a.(*IssuerSpec), b.(*certmanager.IssuerSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerSpec)(nil), (*IssuerSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(a.(*certmanager.IssuerSpec), b.(*IssuerSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IssuerStatus)(nil), (*certmanager.IssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(a.(*IssuerStatus), b.(*certmanager.IssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerStatus)(nil), (*IssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(a.(*certmanager.IssuerStatus), b.(*IssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*JKSKeystore)(nil), (*certmanager.JKSKeystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(a.(*JKSKeystore), b.(*certmanager.JKSKeystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.JKSKeystore)(nil), (*JKSKeystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(a.(*certmanager.JKSKeystore), b.(*JKSKeystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NameConstraintItem)(nil), (*certmanager.NameConstraintItem)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_NameConstraintItem_To_certmanager_NameConstraintItem(a.(*NameConstraintItem), b.(*certmanager.NameConstraintItem), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.NameConstraintItem)(nil), (*NameConstraintItem)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_NameConstraintItem_To_v1alpha3_NameConstraintItem(a.(*certmanager.NameConstraintItem), b.(*NameConstraintItem), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NameConstraints)(nil), (*certmanager.NameConstraints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_NameConstraints_To_certmanager_NameConstraints(a.(*NameConstraints), b.(*certmanager.NameConstraints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.NameConstraints)(nil), (*NameConstraints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_NameConstraints_To_v1alpha3_NameConstraints(a.(*certmanager.NameConstraints), b.(*NameConstraints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OtherName)(nil), (*certmanager.OtherName)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OtherName_To_certmanager_OtherName(a.(*OtherName), b.(*certmanager.OtherName), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.OtherName)(nil), (*OtherName)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_OtherName_To_v1alpha3_OtherName(a.(*certmanager.OtherName), b.(*OtherName), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PKCS12Keystore)(nil), (*certmanager.PKCS12Keystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(a.(*PKCS12Keystore), b.(*certmanager.PKCS12Keystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.PKCS12Keystore)(nil), (*PKCS12Keystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(a.(*certmanager.PKCS12Keystore), b.(*PKCS12Keystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SelfSignedIssuer)(nil), (*certmanager.SelfSignedIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(a.(*SelfSignedIssuer), b.(*certmanager.SelfSignedIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.SelfSignedIssuer)(nil), (*SelfSignedIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(a.(*certmanager.SelfSignedIssuer), b.(*SelfSignedIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServiceAccountRef)(nil), (*certmanager.ServiceAccountRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ServiceAccountRef_To_certmanager_ServiceAccountRef(a.(*ServiceAccountRef), b.(*certmanager.ServiceAccountRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ServiceAccountRef)(nil), (*ServiceAccountRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ServiceAccountRef_To_v1alpha3_ServiceAccountRef(a.(*certmanager.ServiceAccountRef), b.(*ServiceAccountRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VaultAppRole)(nil), (*certmanager.VaultAppRole)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(a.(*VaultAppRole), b.(*certmanager.VaultAppRole), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultAppRole)(nil), (*VaultAppRole)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(a.(*certmanager.VaultAppRole), b.(*VaultAppRole), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VaultAuth)(nil), (*certmanager.VaultAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(a.(*VaultAuth), b.(*certmanager.VaultAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultAuth)(nil), (*VaultAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(a.(*certmanager.VaultAuth), b.(*VaultAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VaultClientCertificateAuth)(nil), (*certmanager.VaultClientCertificateAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(a.(*VaultClientCertificateAuth), b.(*certmanager.VaultClientCertificateAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultClientCertificateAuth)(nil), (*VaultClientCertificateAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultClientCertificateAuth_To_v1alpha3_VaultClientCertificateAuth(a.(*certmanager.VaultClientCertificateAuth), b.(*VaultClientCertificateAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VaultIssuer)(nil), (*certmanager.VaultIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(a.(*VaultIssuer), b.(*certmanager.VaultIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultIssuer)(nil), (*VaultIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(a.(*certmanager.VaultIssuer), b.(*VaultIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VaultKubernetesAuth)(nil), (*certmanager.VaultKubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(a.(*VaultKubernetesAuth), b.(*certmanager.VaultKubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VenafiCloud)(nil), (*certmanager.VenafiCloud)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(a.(*VenafiCloud), b.(*certmanager.VenafiCloud), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiCloud)(nil), (*VenafiCloud)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(a.(*certmanager.VenafiCloud), b.(*VenafiCloud), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VenafiIssuer)(nil), (*certmanager.VenafiIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(a.(*VenafiIssuer), b.(*certmanager.VenafiIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiIssuer)(nil), (*VenafiIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(a.(*certmanager.VenafiIssuer), b.(*VenafiIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VenafiTPP)(nil), (*certmanager.VenafiTPP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(a.(*VenafiTPP), b.(*certmanager.VenafiTPP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiTPP)(nil), (*VenafiTPP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(a.(*certmanager.VenafiTPP), b.(*VenafiTPP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*X509Subject)(nil), (*certmanager.X509Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_X509Subject_To_certmanager_X509Subject(a.(*X509Subject), b.(*certmanager.X509Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.CertificatePrivateKey)(nil), (*CertificatePrivateKey)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificatePrivateKey_To_v1alpha3_CertificatePrivateKey(a.(*certmanager.CertificatePrivateKey), b.(*CertificatePrivateKey), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.CertificateRequestSpec)(nil), (*CertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestSpec_To_v1alpha3_CertificateRequestSpec(a.(*certmanager.CertificateRequestSpec), b.(*CertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.CertificateSpec)(nil), (*CertificateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateSpec_To_v1alpha3_CertificateSpec(a.(*certmanager.CertificateSpec), b.(*CertificateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.VaultKubernetesAuth)(nil), (*VaultKubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(a.(*certmanager.VaultKubernetesAuth), b.(*VaultKubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.X509Subject)(nil), (*X509Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_X509Subject_To_v1alpha3_X509Subject(a.(*certmanager.X509Subject), b.(*X509Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*CertificateRequestSpec)(nil), (*certmanager.CertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(a.(*CertificateRequestSpec), b.(*certmanager.CertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*CertificateSpec)(nil), (*certmanager.CertificateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateSpec_To_certmanager_CertificateSpec(a.(*CertificateSpec), b.(*certmanager.CertificateSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(in *CAIssuer, out *certmanager.CAIssuer, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	out.OCSPServers = *(*[]string)(unsafe.Pointer(&in.OCSPServers))
	out.IssuingCertificateURLs = *(*[]string)(unsafe.Pointer(&in.IssuingCertificateURLs))
	return nil
}

// Convert_v1alpha3_CAIssuer_To_certmanager_CAIssuer is an autogenerated conversion function.
func Convert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(in *CAIssuer, out *certmanager.CAIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(in, out, s)
}

func autoConvert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(in *certmanager.CAIssuer, out *CAIssuer, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	out.OCSPServers = *(*[]string)(unsafe.Pointer(&in.OCSPServers))
	out.IssuingCertificateURLs = *(*[]string)(unsafe.Pointer(&in.IssuingCertificateURLs))
	return nil
}

// Convert_certmanager_CAIssuer_To_v1alpha3_CAIssuer is an autogenerated conversion function.
func Convert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(in *certmanager.CAIssuer, out *CAIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(in, out, s)
}

func autoConvert_v1alpha3_Certificate_To_certmanager_Certificate(in *Certificate, out *certmanager.Certificate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_CertificateSpec_To_certmanager_CertificateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Certificate_To_certmanager_Certificate is an autogenerated conversion function.
func Convert_v1alpha3_Certificate_To_certmanager_Certificate(in *Certificate, out *certmanager.Certificate, s conversion.Scope) error {
	return autoConvert_v1alpha3_Certificate_To_certmanager_Certificate(in, out, s)
}

func autoConvert_certmanager_Certificate_To_v1alpha3_Certificate(in *certmanager.Certificate, out *Certificate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_CertificateSpec_To_v1alpha3_CertificateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_Certificate_To_v1alpha3_Certificate is an autogenerated conversion function.
func Convert_certmanager_Certificate_To_v1alpha3_Certificate(in *certmanager.Certificate, out *Certificate, s conversion.Scope) error {
	return autoConvert_certmanager_Certificate_To_v1alpha3_Certificate(in, out, s)
}

func autoConvert_v1alpha3_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(in *CertificateAdditionalOutputFormat, out *certmanager.CertificateAdditionalOutputFormat, s conversion.Scope) error {
	out.Type = certmanager.CertificateOutputFormatType(in.Type)
	return nil
}

// Convert_v1alpha3_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat is an autogenerated conversion function.
func Convert_v1alpha3_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(in *CertificateAdditionalOutputFormat, out *certmanager.CertificateAdditionalOutputFormat, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(in, out, s)
}

func autoConvert_certmanager_CertificateAdditionalOutputFormat_To_v1alpha3_CertificateAdditionalOutputFormat(in *certmanager.CertificateAdditionalOutputFormat, out *CertificateAdditionalOutputFormat, s conversion.Scope) error {
	out.Type = CertificateOutputFormatType(in.Type)
	return nil
}

// Convert_certmanager_CertificateAdditionalOutputFormat_To_v1alpha3_CertificateAdditionalOutputFormat is an autogenerated conversion function.
func Convert_certmanager_CertificateAdditionalOutputFormat_To_v1alpha3_CertificateAdditionalOutputFormat(in *certmanager.CertificateAdditionalOutputFormat, out *CertificateAdditionalOutputFormat, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateAdditionalOutputFormat_To_v1alpha3_CertificateAdditionalOutputFormat(in, out, s)
}

func autoConvert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(in *CertificateCondition, out *certmanager.CertificateCondition, s conversion.Scope) error {
	out.Type = certmanager.CertificateConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition is an autogenerated conversion function.
func Convert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(in *CertificateCondition, out *certmanager.CertificateCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(in, out, s)
}

func autoConvert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(in *certmanager.CertificateCondition, out *CertificateCondition, s conversion.Scope) error {
	out.Type = CertificateConditionType(in.Type)
	out.Status = metav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition is an autogenerated conversion function.
func Convert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(in *certmanager.CertificateCondition, out *CertificateCondition, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(in, out, s)
}

func autoConvert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(in *CertificateKeystores, out *certmanager.CertificateKeystores, s conversion.Scope) error {
	if in.JKS != nil {
		in, out := &in.JKS, &out.JKS
		*out = new(certmanager.JKSKeystore)
		if err := Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JKS = nil
	}
	if in.PKCS12 != nil {
		in, out := &in.PKCS12, &out.PKCS12
		*out = new(certmanager.PKCS12Keystore)
		if err := Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PKCS12 = nil
	}
	return nil
}

// Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores is an autogenerated conversion function.
func Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(in *CertificateKeystores, out *certmanager.CertificateKeystores, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(in, out, s)
}

func autoConvert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(in *certmanager.CertificateKeystores, out *CertificateKeystores, s conversion.Scope) error {
	if in.JKS != nil {
		in, out := &in.JKS, &out.JKS
		*out = new(JKSKeystore)
		if err := Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JKS = nil
	}
	if in.PKCS12 != nil {
		in, out := &in.PKCS12, &out.PKCS12
		*out = new(PKCS12Keystore)
		if err := Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PKCS12 = nil
	}
	return nil
}

// Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores is an autogenerated conversion function.
func Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(in *certmanager.CertificateKeystores, out *CertificateKeystores, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(in, out, s)
}

func autoConvert_v1alpha3_CertificateList_To_certmanager_CertificateList(in *CertificateList, out *certmanager.CertificateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.Certificate, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_Certificate_To_certmanager_Certificate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_CertificateList_To_certmanager_CertificateList is an autogenerated conversion function.
func Convert_v1alpha3_CertificateList_To_certmanager_CertificateList(in *CertificateList, out *certmanager.CertificateList, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateList_To_certmanager_CertificateList(in, out, s)
}

func autoConvert_certmanager_CertificateList_To_v1alpha3_CertificateList(in *certmanager.CertificateList, out *CertificateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Certificate, len(*in))
		for i := range *in {
			if err := Convert_certmanager_Certificate_To_v1alpha3_Certificate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_CertificateList_To_v1alpha3_CertificateList is an autogenerated conversion function.
func Convert_certmanager_CertificateList_To_v1alpha3_CertificateList(in *certmanager.CertificateList, out *CertificateList, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateList_To_v1alpha3_CertificateList(in, out, s)
}

func autoConvert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in *CertificatePrivateKey, out *certmanager.CertificatePrivateKey, s conversion.Scope) error {
	out.RotationPolicy = certmanager.PrivateKeyRotationPolicy(in.RotationPolicy)
	return nil
}

// Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey is an autogenerated conversion function.
func Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in *CertificatePrivateKey, out *certmanager.CertificatePrivateKey, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in, out, s)
}

func autoConvert_certmanager_CertificatePrivateKey_To_v1alpha3_CertificatePrivateKey(in *certmanager.CertificatePrivateKey, out *CertificatePrivateKey, s conversion.Scope) error {
	out.RotationPolicy = PrivateKeyRotationPolicy(in.RotationPolicy)
	// WARNING: in.Encoding requires manual conversion: does not exist in peer-type
	// WARNING: in.Algorithm requires manual conversion: does not exist in peer-type
	// WARNING: in.Size requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(in *CertificateRequest, out *certmanager.CertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(in *CertificateRequest, out *certmanager.CertificateRequest, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(in, out, s)
}

func autoConvert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(in *certmanager.CertificateRequest, out *CertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_CertificateRequestSpec_To_v1alpha3_CertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest is an autogenerated conversion function.
func Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(in *certmanager.CertificateRequest, out *CertificateRequest, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(in, out, s)
}

func autoConvert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in *CertificateRequestCondition, out *certmanager.CertificateRequestCondition, s conversion.Scope) error {
	out.Type = certmanager.CertificateRequestConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in *CertificateRequestCondition, out *certmanager.CertificateRequestCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in, out, s)
}

func autoConvert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(in *certmanager.CertificateRequestCondition, out *CertificateRequestCondition, s conversion.Scope) error {
	out.Type = CertificateRequestConditionType(in.Type)
	out.Status = metav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(in *certmanager.CertificateRequestCondition, out *CertificateRequestCondition, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(in, out, s)
}

func autoConvert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(in *CertificateRequestList, out *certmanager.CertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.CertificateRequest, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(in *CertificateRequestList, out *certmanager.CertificateRequestList, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(in, out, s)
}

func autoConvert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(in *certmanager.CertificateRequestList, out *CertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CertificateRequest, len(*in))
		for i := range *in {
			if err := Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(in *certmanager.CertificateRequestList, out *CertificateRequestList, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(in, out, s)
}

func autoConvert_v1alpha3_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(in *CertificateRequestSpec, out *certmanager.CertificateRequestSpec, s conversion.Scope) error {
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	if err := apismetav1.Convert_v1_IssuerReference_To_meta_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	// WARNING: in.CSRPEM requires manual conversion: does not exist in peer-type
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanager.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.Username = in.Username
	out.UID = in.UID
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Extra = *(*map[string][]string)(unsafe.Pointer(&in.Extra))
	return nil
}

func autoConvert_certmanager_CertificateRequestSpec_To_v1alpha3_CertificateRequestSpec(in *certmanager.CertificateRequestSpec, out *CertificateRequestSpec, s conversion.Scope) error {
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	if err := apismetav1.Convert_meta_IssuerReference_To_v1_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	// WARNING: in.Request requires manual conversion: does not exist in peer-type
	out.IsCA = in.IsCA
	out.Usages = *(*[]KeyUsage)(unsafe.Pointer(&in.Usages))
	out.Username = in.Username
	out.UID = in.UID
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Extra = *(*map[string][]string)(unsafe.Pointer(&in.Extra))
	return nil
}

func autoConvert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in *CertificateRequestStatus, out *certmanager.CertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.CertificateRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.CA = *(*[]byte)(unsafe.Pointer(&in.CA))
	out.FailureTime = (*v1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in *CertificateRequestStatus, out *certmanager.CertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in, out, s)
}

func autoConvert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(in *certmanager.CertificateRequestStatus, out *CertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]CertificateRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.CA = *(*[]byte)(unsafe.Pointer(&in.CA))
	out.FailureTime = (*v1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(in *certmanager.CertificateRequestStatus, out *CertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(in, out, s)
}

func autoConvert_v1alpha3_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(in *CertificateSecretTemplate, out *certmanager.CertificateSecretTemplate, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1alpha3_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate is an autogenerated conversion function.
func Convert_v1alpha3_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(in *CertificateSecretTemplate, out *certmanager.CertificateSecretTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(in, out, s)
}

func autoConvert_certmanager_CertificateSecretTemplate_To_v1alpha3_CertificateSecretTemplate(in *certmanager.CertificateSecretTemplate, out *CertificateSecretTemplate, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_certmanager_CertificateSecretTemplate_To_v1alpha3_CertificateSecretTemplate is an autogenerated conversion function.
func Convert_certmanager_CertificateSecretTemplate_To_v1alpha3_CertificateSecretTemplate(in *certmanager.CertificateSecretTemplate, out *CertificateSecretTemplate, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateSecretTemplate_To_v1alpha3_CertificateSecretTemplate(in, out, s)
}

func autoConvert_v1alpha3_CertificateSpec_To_certmanager_CertificateSpec(in *CertificateSpec, out *certmanager.CertificateSpec, s conversion.Scope) error {
	if in.Subject != nil {
		in, out := &in.Subject, &out.Subject
		*out = new(certmanager.X509Subject)
		if err := Convert_v1alpha3_X509Subject_To_certmanager_X509Subject(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Subject = nil
	}
	out.LiteralSubject = in.LiteralSubject
	out.CommonName = in.CommonName
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	out.RenewBefore = (*v1.Duration)(unsafe.Pointer(in.RenewBefore))
	out.RenewBeforePercentage = (*int32)(unsafe.Pointer(in.RenewBeforePercentage))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	// WARNING: in.URISANs requires manual conversion: does not exist in peer-type
	// WARNING: in.EmailSANs requires manual conversion: does not exist in peer-type
	out.OtherNames = *(*[]certmanager.OtherName)(unsafe.Pointer(&in.OtherNames))
	out.SecretName = in.SecretName
	out.SecretTemplate = (*certmanager.CertificateSecretTemplate)(unsafe.Pointer(in.SecretTemplate))
	if in.Keystores != nil {
		in, out := &in.Keystores, &out.Keystores
		*out = new(certmanager.CertificateKeystores)
		if err := Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Keystores = nil
	}
	if err := apismetav1.Convert_v1_IssuerReference_To_meta_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanager.KeyUsage)(unsafe.Pointer(&in.Usages))
	// WARNING: in.KeySize requires manual conversion: does not exist in peer-type
	// WARNING: in.KeyAlgorithm requires manual conversion: does not exist in peer-type
	// WARNING: in.KeyEncoding requires manual conversion: does not exist in peer-type
	if in.PrivateKey != nil {
		in, out := &in.PrivateKey, &out.PrivateKey
		*out = new(certmanager.CertificatePrivateKey)
		if err := Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PrivateKey = nil
	}
	out.EncodeUsagesInRequest = (*bool)(unsafe.Pointer(in.EncodeUsagesInRequest))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.AdditionalOutputFormats = *(*[]certmanager.CertificateAdditionalOutputFormat)(unsafe.Pointer(&in.AdditionalOutputFormats))
	out.NameConstraints = (*certmanager.NameConstraints)(unsafe.Pointer(in.NameConstraints))
	out.SignatureAlgorithm = certmanager.SignatureAlgorithm(in.SignatureAlgorithm)
	return nil
}

func autoConvert_certmanager_CertificateSpec_To_v1alpha3_CertificateSpec(in *certmanager.CertificateSpec, out *CertificateSpec, s conversion.Scope) error {
	if in.Subject != nil {
		in, out := &in.Subject, &out.Subject
		*out = new(X509Subject)
		if err := Convert_certmanager_X509Subject_To_v1alpha3_X509Subject(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Subject = nil
	}
	out.LiteralSubject = in.LiteralSubject
	out.CommonName = in.CommonName
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	out.RenewBefore = (*v1.Duration)(unsafe.Pointer(in.RenewBefore))
	out.RenewBeforePercentage = (*int32)(unsafe.Pointer(in.RenewBeforePercentage))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	// WARNING: in.URIs requires manual conversion: does not exist in peer-type
	// WARNING: in.EmailAddresses requires manual conversion: does not exist in peer-type
	out.OtherNames = *(*[]OtherName)(unsafe.Pointer(&in.OtherNames))
	out.SecretName = in.SecretName
	out.SecretTemplate = (*CertificateSecretTemplate)(unsafe.Pointer(in.SecretTemplate))
	if in.Keystores != nil {
		in, out := &in.Keystores, &out.Keystores
		*out = new(CertificateKeystores)
		if err := Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Keystores = nil
	}
	if err := apismetav1.Convert_meta_IssuerReference_To_v1_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.IsCA = in.IsCA
	out.Usages = *(*[]KeyUsage)(unsafe.Pointer(&in.Usages))
	if in.PrivateKey != nil {
		in, out := &in.PrivateKey, &out.PrivateKey
		*out = new(CertificatePrivateKey)
		if err := Convert_certmanager_CertificatePrivateKey_To_v1alpha3_CertificatePrivateKey(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PrivateKey = nil
	}
	out.SignatureAlgorithm = SignatureAlgorithm(in.SignatureAlgorithm)
	out.EncodeUsagesInRequest = (*bool)(unsafe.Pointer(in.EncodeUsagesInRequest))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.AdditionalOutputFormats = *(*[]CertificateAdditionalOutputFormat)(unsafe.Pointer(&in.AdditionalOutputFormats))
	out.NameConstraints = (*NameConstraints)(unsafe.Pointer(in.NameConstraints))
	return nil
}

func autoConvert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(in *CertificateStatus, out *certmanager.CertificateStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.CertificateCondition)(unsafe.Pointer(&in.Conditions))
	out.LastFailureTime = (*v1.Time)(unsafe.Pointer(in.LastFailureTime))
	out.NotBefore = (*v1.Time)(unsafe.Pointer(in.NotBefore))
	out.NotAfter = (*v1.Time)(unsafe.Pointer(in.NotAfter))
	out.RenewalTime = (*v1.Time)(unsafe.Pointer(in.RenewalTime))
	out.Revision = (*int)(unsafe.Pointer(in.Revision))
	out.NextPrivateKeySecretName = (*string)(unsafe.Pointer(in.NextPrivateKeySecretName))
	out.FailedIssuanceAttempts = (*int)(unsafe.Pointer(in.FailedIssuanceAttempts))
	return nil
}

// Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus is an autogenerated conversion function.
func Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(in *CertificateStatus, out *certmanager.CertificateStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(in, out, s)
}

func autoConvert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(in *certmanager.CertificateStatus, out *CertificateStatus, s conversion.Scope) error {
	out.Conditions = *(*[]CertificateCondition)(unsafe.Pointer(&in.Conditions))
	out.LastFailureTime = (*v1.Time)(unsafe.Pointer(in.LastFailureTime))
	out.NotBefore = (*v1.Time)(unsafe.Pointer(in.NotBefore))
	out.NotAfter = (*v1.Time)(unsafe.Pointer(in.NotAfter))
	out.RenewalTime = (*v1.Time)(unsafe.Pointer(in.RenewalTime))
	out.Revision = (*int)(unsafe.Pointer(in.Revision))
	out.NextPrivateKeySecretName = (*string)(unsafe.Pointer(in.NextPrivateKeySecretName))
	out.FailedIssuanceAttempts = (*int)(unsafe.Pointer(in.FailedIssuanceAttempts))
	return nil
}

// Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus is an autogenerated conversion function.
func Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(in *certmanager.CertificateStatus, out *CertificateStatus, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(in, out, s)
}

func autoConvert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(in *ClusterIssuer, out *certmanager.ClusterIssuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer is an autogenerated conversion function.
func Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(in *ClusterIssuer, out *certmanager.ClusterIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(in, out, s)
}

func autoConvert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(in *certmanager.ClusterIssuer, out *ClusterIssuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer is an autogenerated conversion function.
func Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(in *certmanager.ClusterIssuer, out *ClusterIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(in, out, s)
}

func autoConvert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(in *ClusterIssuerList, out *certmanager.ClusterIssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.ClusterIssuer, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList is an autogenerated conversion function.
func Convert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(in *ClusterIssuerList, out *certmanager.ClusterIssuerList, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(in, out, s)
}

func autoConvert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(in *certmanager.ClusterIssuerList, out *ClusterIssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterIssuer, len(*in))
		for i := range *in {
			if err := Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList is an autogenerated conversion function.
func Convert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(in *certmanager.ClusterIssuerList, out *ClusterIssuerList, s conversion.Scope) error {
	return autoConvert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(in, out, s)
}

func autoConvert_v1alpha3_Issuer_To_certmanager_Issuer(in *Issuer, out *certmanager.Issuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Issuer_To_certmanager_Issuer is an autogenerated conversion function.
func Convert_v1alpha3_Issuer_To_certmanager_Issuer(in *Issuer, out *certmanager.Issuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_Issuer_To_certmanager_Issuer(in, out, s)
}

func autoConvert_certmanager_Issuer_To_v1alpha3_Issuer(in *certmanager.Issuer, out *Issuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_Issuer_To_v1alpha3_Issuer is an autogenerated conversion function.
func Convert_certmanager_Issuer_To_v1alpha3_Issuer(in *certmanager.Issuer, out *Issuer, s conversion.Scope) error {
	return autoConvert_certmanager_Issuer_To_v1alpha3_Issuer(in, out, s)
}

func autoConvert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(in *IssuerCondition, out *certmanager.IssuerCondition, s conversion.Scope) error {
	out.Type = certmanager.IssuerConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition is an autogenerated conversion function.
func Convert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(in *IssuerCondition, out *certmanager.IssuerCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(in, out, s)
}

func autoConvert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(in *certmanager.IssuerCondition, out *IssuerCondition, s conversion.Scope) error {
	out.Type = IssuerConditionType(in.Type)
	out.Status = metav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition is an autogenerated conversion function.
func Convert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(in *certmanager.IssuerCondition, out *IssuerCondition, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(in, out, s)
}

func autoConvert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(in *IssuerConfig, out *certmanager.IssuerConfig, s conversion.Scope) error {
	if in.ACME != nil {
		in, out := &in.ACME, &out.ACME
		*out = new(acme.ACMEIssuer)
		if err := acmev1alpha3.Convert_v1alpha3_ACMEIssuer_To_acme_ACMEIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ACME = nil
	}
	out.CA = (*certmanager.CAIssuer)(unsafe.Pointer(in.CA))
	if in.Vault != nil {
		in, out := &in.Vault, &out.Vault
		*out = new(certmanager.VaultIssuer)
		if err := Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Vault = nil
	}
	out.SelfSigned = (*certmanager.SelfSignedIssuer)(unsafe.Pointer(in.SelfSigned))
	if in.Venafi != nil {
		in, out := &in.Venafi, &out.Venafi
		*out = new(certmanager.VenafiIssuer)
		if err := Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Venafi = nil
	}
	return nil
}

// Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig is an autogenerated conversion function.
func Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(in *IssuerConfig, out *certmanager.IssuerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(in, out, s)
}

func autoConvert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(in *certmanager.IssuerConfig, out *IssuerConfig, s conversion.Scope) error {
	if in.ACME != nil {
		in, out := &in.ACME, &out.ACME
		*out = new(acmev1alpha3.ACMEIssuer)
		if err := acmev1alpha3.Convert_acme_ACMEIssuer_To_v1alpha3_ACMEIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ACME = nil
	}
	out.CA = (*CAIssuer)(unsafe.Pointer(in.CA))
	if in.Vault != nil {
		in, out := &in.Vault, &out.Vault
		*out = new(VaultIssuer)
		if err := Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Vault = nil
	}
	out.SelfSigned = (*SelfSignedIssuer)(unsafe.Pointer(in.SelfSigned))
	if in.Venafi != nil {
		in, out := &in.Venafi, &out.Venafi
		*out = new(VenafiIssuer)
		if err := Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Venafi = nil
	}
	return nil
}

// Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig is an autogenerated conversion function.
func Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(in *certmanager.IssuerConfig, out *IssuerConfig, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(in, out, s)
}

func autoConvert_v1alpha3_IssuerList_To_certmanager_IssuerList(in *IssuerList, out *certmanager.IssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.Issuer, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_Issuer_To_certmanager_Issuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_IssuerList_To_certmanager_IssuerList is an autogenerated conversion function.
func Convert_v1alpha3_IssuerList_To_certmanager_IssuerList(in *IssuerList, out *certmanager.IssuerList, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerList_To_certmanager_IssuerList(in, out, s)
}

func autoConvert_certmanager_IssuerList_To_v1alpha3_IssuerList(in *certmanager.IssuerList, out *IssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Issuer, len(*in))
		for i := range *in {
			if err := Convert_certmanager_Issuer_To_v1alpha3_Issuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_IssuerList_To_v1alpha3_IssuerList is an autogenerated conversion function.
func Convert_certmanager_IssuerList_To_v1alpha3_IssuerList(in *certmanager.IssuerList, out *IssuerList, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerList_To_v1alpha3_IssuerList(in, out, s)
}

func autoConvert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(in *IssuerSpec, out *certmanager.IssuerSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(&in.IssuerConfig, &out.IssuerConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec is an autogenerated conversion function.
func Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(in *IssuerSpec, out *certmanager.IssuerSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(in, out, s)
}

func autoConvert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(in *certmanager.IssuerSpec, out *IssuerSpec, s conversion.Scope) error {
	if err := Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(&in.IssuerConfig, &out.IssuerConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec is an autogenerated conversion function.
func Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(in *certmanager.IssuerSpec, out *IssuerSpec, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(in, out, s)
}

func autoConvert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(in *IssuerStatus, out *certmanager.IssuerStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.IssuerCondition)(unsafe.Pointer(&in.Conditions))
	out.ACME = (*acme.ACMEIssuerStatus)(unsafe.Pointer(in.ACME))
	return nil
}

// Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus is an autogenerated conversion function.
func Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(in *IssuerStatus, out *certmanager.IssuerStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(in, out, s)
}

func autoConvert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(in *certmanager.IssuerStatus, out *IssuerStatus, s conversion.Scope) error {
	out.Conditions = *(*[]IssuerCondition)(unsafe.Pointer(&in.Conditions))
	out.ACME = (*acmev1alpha3.ACMEIssuerStatus)(unsafe.Pointer(in.ACME))
	return nil
}

// Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus is an autogenerated conversion function.
func Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(in *certmanager.IssuerStatus, out *IssuerStatus, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(in, out, s)
}

func autoConvert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(in *JKSKeystore, out *certmanager.JKSKeystore, s conversion.Scope) error {
	out.Create = in.Create
	if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	out.Alias = (*string)(unsafe.Pointer(in.Alias))
	return nil
}

// Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore is an autogenerated conversion function.
func Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(in *JKSKeystore, out *certmanager.JKSKeystore, s conversion.Scope) error {
	return autoConvert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(in, out, s)
}

func autoConvert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(in *certmanager.JKSKeystore, out *JKSKeystore, s conversion.Scope) error {
	out.Create = in.Create
	if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	out.Alias = (*string)(unsafe.Pointer(in.Alias))
	return nil
}

// Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore is an autogenerated conversion function.
func Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(in *certmanager.JKSKeystore, out *JKSKeystore, s conversion.Scope) error {
	return autoConvert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(in, out, s)
}

func autoConvert_v1alpha3_NameConstraintItem_To_certmanager_NameConstraintItem(in *NameConstraintItem, out *certmanager.NameConstraintItem, s conversion.Scope) error {
	out.DNSDomains = *(*[]string)(unsafe.Pointer(&in.DNSDomains))
	out.IPRanges = *(*[]string)(unsafe.Pointer(&in.IPRanges))
	out.EmailAddresses = *(*[]string)(unsafe.Pointer(&in.EmailAddresses))
	out.URIDomains = *(*[]string)(unsafe.Pointer(&in.URIDomains))
	return nil
}

// Convert_v1alpha3_NameConstraintItem_To_certmanager_NameConstraintItem is an autogenerated conversion function.
func Convert_v1alpha3_NameConstraintItem_To_certmanager_NameConstraintItem(in *NameConstraintItem, out *certmanager.NameConstraintItem, s conversion.Scope) error {
	return autoConvert_v1alpha3_NameConstraintItem_To_certmanager_NameConstraintItem(in, out, s)
}

func autoConvert_certmanager_NameConstraintItem_To_v1alpha3_NameConstraintItem(in *certmanager.NameConstraintItem, out *NameConstraintItem, s conversion.Scope) error {
	out.DNSDomains = *(*[]string)(unsafe.Pointer(&in.DNSDomains))
	out.IPRanges = *(*[]string)(unsafe.Pointer(&in.IPRanges))
	out.EmailAddresses = *(*[]string)(unsafe.Pointer(&in.EmailAddresses))
	out.URIDomains = *(*[]string)(unsafe.Pointer(&in.URIDomains))
	return nil
}

// Convert_certmanager_NameConstraintItem_To_v1alpha3_NameConstraintItem is an autogenerated conversion function.
func Convert_certmanager_NameConstraintItem_To_v1alpha3_NameConstraintItem(in *certmanager.NameConstraintItem, out *NameConstraintItem, s conversion.Scope) error {
	return autoConvert_certmanager_NameConstraintItem_To_v1alpha3_NameConstraintItem(in, out, s)
}

func autoConvert_v1alpha3_NameConstraints_To_certmanager_NameConstraints(in *NameConstraints, out *certmanager.NameConstraints, s conversion.Scope) error {
	out.Critical = in.Critical
	out.Permitted = (*certmanager.NameConstraintItem)(unsafe.Pointer(in.Permitted))
	out.Excluded = (*certmanager.NameConstraintItem)(unsafe.Pointer(in.Excluded))
	return nil
}

// Convert_v1alpha3_NameConstraints_To_certmanager_NameConstraints is an autogenerated conversion function.
func Convert_v1alpha3_NameConstraints_To_certmanager_NameConstraints(in *NameConstraints, out *certmanager.NameConstraints, s conversion.Scope) error {
	return autoConvert_v1alpha3_NameConstraints_To_certmanager_NameConstraints(in, out, s)
}

func autoConvert_certmanager_NameConstraints_To_v1alpha3_NameConstraints(in *certmanager.NameConstraints, out *NameConstraints, s conversion.Scope) error {
	out.Critical = in.Critical
	out.Permitted = (*NameConstraintItem)(unsafe.Pointer(in.Permitted))
	out.Excluded = (*NameConstraintItem)(unsafe.Pointer(in.Excluded))
	return nil
}

// Convert_certmanager_NameConstraints_To_v1alpha3_NameConstraints is an autogenerated conversion function.
func Convert_certmanager_NameConstraints_To_v1alpha3_NameConstraints(in *certmanager.NameConstraints, out *NameConstraints, s conversion.Scope) error {
	return autoConvert_certmanager_NameConstraints_To_v1alpha3_NameConstraints(in, out, s)
}

func autoConvert_v1alpha3_OtherName_To_certmanager_OtherName(in *OtherName, out *certmanager.OtherName, s conversion.Scope) error {
	out.OID = in.OID
	out.UTF8Value = in.UTF8Value
	return nil
}

// Convert_v1alpha3_OtherName_To_certmanager_OtherName is an autogenerated conversion function.
func Convert_v1alpha3_OtherName_To_certmanager_OtherName(in *OtherName, out *certmanager.OtherName, s conversion.Scope) error {
	return autoConvert_v1alpha3_OtherName_To_certmanager_OtherName(in, out, s)
}

func autoConvert_certmanager_OtherName_To_v1alpha3_OtherName(in *certmanager.OtherName, out *OtherName, s conversion.Scope) error {
	out.OID = in.OID
	out.UTF8Value = in.UTF8Value
	return nil
}

// Convert_certmanager_OtherName_To_v1alpha3_OtherName is an autogenerated conversion function.
func Convert_certmanager_OtherName_To_v1alpha3_OtherName(in *certmanager.OtherName, out *OtherName, s conversion.Scope) error {
	return autoConvert_certmanager_OtherName_To_v1alpha3_OtherName(in, out, s)
}

func autoConvert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(in *PKCS12Keystore, out *certmanager.PKCS12Keystore, s conversion.Scope) error {
	out.Create = in.Create
	if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	out.Profile = certmanager.PKCS12Profile(in.Profile)
	return nil
}

// Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore is an autogenerated conversion function.
func Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(in *PKCS12Keystore, out *certmanager.PKCS12Keystore, s conversion.Scope) error {
	return autoConvert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(in, out, s)
}

func autoConvert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(in *certmanager.PKCS12Keystore, out *PKCS12Keystore, s conversion.Scope) error {
	out.Create = in.Create
	if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	out.Profile = PKCS12Profile(in.Profile)
	return nil
}

// Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore is an autogenerated conversion function.
func Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(in *certmanager.PKCS12Keystore, out *PKCS12Keystore, s conversion.Scope) error {
	return autoConvert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(in, out, s)
}

func autoConvert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in *SelfSignedIssuer, out *certmanager.SelfSignedIssuer, s conversion.Scope) error {
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer is an autogenerated conversion function.
func Convert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in *SelfSignedIssuer, out *certmanager.SelfSignedIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in, out, s)
}

func autoConvert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(in *certmanager.SelfSignedIssuer, out *SelfSignedIssuer, s conversion.Scope) error {
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer is an autogenerated conversion function.
func Convert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(in *certmanager.SelfSignedIssuer, out *SelfSignedIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(in, out, s)
}

func autoConvert_v1alpha3_ServiceAccountRef_To_certmanager_ServiceAccountRef(in *ServiceAccountRef, out *certmanager.ServiceAccountRef, s conversion.Scope) error {
	out.Name = in.Name
	out.TokenAudiences = *(*[]string)(unsafe.Pointer(&in.TokenAudiences))
	return nil
}

// Convert_v1alpha3_ServiceAccountRef_To_certmanager_ServiceAccountRef is an autogenerated conversion function.
func Convert_v1alpha3_ServiceAccountRef_To_certmanager_ServiceAccountRef(in *ServiceAccountRef, out *certmanager.ServiceAccountRef, s conversion.Scope) error {
	return autoConvert_v1alpha3_ServiceAccountRef_To_certmanager_ServiceAccountRef(in, out, s)
}

func autoConvert_certmanager_ServiceAccountRef_To_v1alpha3_ServiceAccountRef(in *certmanager.ServiceAccountRef, out *ServiceAccountRef, s conversion.Scope) error {
	out.Name = in.Name
	out.TokenAudiences = *(*[]string)(unsafe.Pointer(&in.TokenAudiences))
	return nil
}

// Convert_certmanager_ServiceAccountRef_To_v1alpha3_ServiceAccountRef is an autogenerated conversion function.
func Convert_certmanager_ServiceAccountRef_To_v1alpha3_ServiceAccountRef(in *certmanager.ServiceAccountRef, out *ServiceAccountRef, s conversion.Scope) error {
	return autoConvert_certmanager_ServiceAccountRef_To_v1alpha3_ServiceAccountRef(in, out, s)
}

func autoConvert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(in *VaultAppRole, out *certmanager.VaultAppRole, s conversion.Scope) error {
	out.Path = in.Path
	out.RoleId = in.RoleId
	if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole is an autogenerated conversion function.
func Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(in *VaultAppRole, out *certmanager.VaultAppRole, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(in, out, s)
}

func autoConvert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(in *certmanager.VaultAppRole, out *VaultAppRole, s conversion.Scope) error {
	out.Path = in.Path
	out.RoleId = in.RoleId
	if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole is an autogenerated conversion function.
func Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(in *certmanager.VaultAppRole, out *VaultAppRole, s conversion.Scope) error {
	return autoConvert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(in, out, s)
}

func autoConvert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(in *VaultAuth, out *certmanager.VaultAuth, s conversion.Scope) error {
	if in.TokenSecretRef != nil {
		in, out := &in.TokenSecretRef, &out.TokenSecretRef
		*out = new(meta.SecretKeySelector)
		if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TokenSecretRef = nil
	}
	if in.AppRole != nil {
		in, out := &in.AppRole, &out.AppRole
		*out = new(certmanager.VaultAppRole)
		if err := Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AppRole = nil
	}
	out.ClientCertificate = (*certmanager.VaultClientCertificateAuth)(unsafe.Pointer(in.ClientCertificate))
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(certmanager.VaultKubernetesAuth)
		if err := Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubernetes = nil
	}
	return nil
}

// Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth is an autogenerated conversion function.
func Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(in *VaultAuth, out *certmanager.VaultAuth, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(in, out, s)
}

func autoConvert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(in *certmanager.VaultAuth, out *VaultAuth, s conversion.Scope) error {
	if in.TokenSecretRef != nil {
		in, out := &in.TokenSecretRef, &out.TokenSecretRef
		*out = new(metav1.SecretKeySelector)
		if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TokenSecretRef = nil
	}
	if in.AppRole != nil {
		in, out := &in.AppRole, &out.AppRole
		*out = new(VaultAppRole)
		if err := Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AppRole = nil
	}
	out.ClientCertificate = (*VaultClientCertificateAuth)(unsafe.Pointer(in.ClientCertificate))
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(VaultKubernetesAuth)
		if err := Convert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubernetes = nil
	}
	return nil
}

// Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth is an autogenerated conversion function.
func Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(in *certmanager.VaultAuth, out *VaultAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(in, out, s)
}

func autoConvert_v1alpha3_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(in *VaultClientCertificateAuth, out *certmanager.VaultClientCertificateAuth, s conversion.Scope) error {
	out.Path = in.Path
	out.SecretName = in.SecretName
	out.Name = in.Name
	return nil
}

// Convert_v1alpha3_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth is an autogenerated conversion function.
func Convert_v1alpha3_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(in *VaultClientCertificateAuth, out *certmanager.VaultClientCertificateAuth, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(in, out, s)
}

func autoConvert_certmanager_VaultClientCertificateAuth_To_v1alpha3_VaultClientCertificateAuth(in *certmanager.VaultClientCertificateAuth, out *VaultClientCertificateAuth, s conversion.Scope) error {
	out.Path = in.Path
	out.SecretName = in.SecretName
	out.Name = in.Name
	return nil
}

// Convert_certmanager_VaultClientCertificateAuth_To_v1alpha3_VaultClientCertificateAuth is an autogenerated conversion function.
func Convert_certmanager_VaultClientCertificateAuth_To_v1alpha3_VaultClientCertificateAuth(in *certmanager.VaultClientCertificateAuth, out *VaultClientCertificateAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultClientCertificateAuth_To_v1alpha3_VaultClientCertificateAuth(in, out, s)
}

func autoConvert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(in *VaultIssuer, out *certmanager.VaultIssuer, s conversion.Scope) error {
	if err := Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(&in.Auth, &out.Auth, s); err != nil {
		return err
	}
	out.Server = in.Server
	out.ServerName = in.ServerName
	out.Path = in.Path
	out.Namespace = in.Namespace
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(meta.SecretKeySelector)
		if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	if in.ClientCertSecretRef != nil {
		in, out := &in.ClientCertSecretRef, &out.ClientCertSecretRef
		*out = new(meta.SecretKeySelector)
		if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientCertSecretRef = nil
	}
	if in.ClientKeySecretRef != nil {
		in, out := &in.ClientKeySecretRef, &out.ClientKeySecretRef
		*out = new(meta.SecretKeySelector)
		if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientKeySecretRef = nil
	}
	return nil
}

// Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer is an autogenerated conversion function.
func Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(in *VaultIssuer, out *certmanager.VaultIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(in, out, s)
}

func autoConvert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(in *certmanager.VaultIssuer, out *VaultIssuer, s conversion.Scope) error {
	if err := Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(&in.Auth, &out.Auth, s); err != nil {
		return err
	}
	out.Server = in.Server
	out.ServerName = in.ServerName
	out.Path = in.Path
	out.Namespace = in.Namespace
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(metav1.SecretKeySelector)
		if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	if in.ClientCertSecretRef != nil {
		in, out := &in.ClientCertSecretRef, &out.ClientCertSecretRef
		*out = new(metav1.SecretKeySelector)
		if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientCertSecretRef = nil
	}
	if in.ClientKeySecretRef != nil {
		in, out := &in.ClientKeySecretRef, &out.ClientKeySecretRef
		*out = new(metav1.SecretKeySelector)
		if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientKeySecretRef = nil
	}
	return nil
}

// Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer is an autogenerated conversion function.
func Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(in *certmanager.VaultIssuer, out *VaultIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(in, out, s)
}

func autoConvert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in *VaultKubernetesAuth, out *certmanager.VaultKubernetesAuth, s conversion.Scope) error {
	out.Path = in.Path
	if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	out.ServiceAccountRef = (*certmanager.ServiceAccountRef)(unsafe.Pointer(in.ServiceAccountRef))
	out.Role = in.Role
	return nil
}

// Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth is an autogenerated conversion function.
func Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in *VaultKubernetesAuth, out *certmanager.VaultKubernetesAuth, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in, out, s)
}

func autoConvert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(in *certmanager.VaultKubernetesAuth, out *VaultKubernetesAuth, s conversion.Scope) error {
	out.Path = in.Path
	if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	out.ServiceAccountRef = (*ServiceAccountRef)(unsafe.Pointer(in.ServiceAccountRef))
	out.Role = in.Role
	return nil
}

func autoConvert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(in *VenafiCloud, out *certmanager.VenafiCloud, s conversion.Scope) error {
	out.URL = in.URL
	if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.APITokenSecretRef, &out.APITokenSecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud is an autogenerated conversion function.
func Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(in *VenafiCloud, out *certmanager.VenafiCloud, s conversion.Scope) error {
	return autoConvert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(in, out, s)
}

func autoConvert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(in *certmanager.VenafiCloud, out *VenafiCloud, s conversion.Scope) error {
	out.URL = in.URL
	if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.APITokenSecretRef, &out.APITokenSecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud is an autogenerated conversion function.
func Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(in *certmanager.VenafiCloud, out *VenafiCloud, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(in, out, s)
}

func autoConvert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(in *VenafiIssuer, out *certmanager.VenafiIssuer, s conversion.Scope) error {
	out.Zone = in.Zone
	if in.TPP != nil {
		in, out := &in.TPP, &out.TPP
		*out = new(certmanager.VenafiTPP)
		if err := Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TPP = nil
	}
	if in.Cloud != nil {
		in, out := &in.Cloud, &out.Cloud
		*out = new(certmanager.VenafiCloud)
		if err := Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cloud = nil
	}
	return nil
}

// Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer is an autogenerated conversion function.
func Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(in *VenafiIssuer, out *certmanager.VenafiIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(in, out, s)
}

func autoConvert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(in *certmanager.VenafiIssuer, out *VenafiIssuer, s conversion.Scope) error {
	out.Zone = in.Zone
	if in.TPP != nil {
		in, out := &in.TPP, &out.TPP
		*out = new(VenafiTPP)
		if err := Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TPP = nil
	}
	if in.Cloud != nil {
		in, out := &in.Cloud, &out.Cloud
		*out = new(VenafiCloud)
		if err := Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cloud = nil
	}
	return nil
}

// Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer is an autogenerated conversion function.
func Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(in *certmanager.VenafiIssuer, out *VenafiIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(in, out, s)
}

func autoConvert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(in *VenafiTPP, out *certmanager.VenafiTPP, s conversion.Scope) error {
	out.URL = in.URL
	if err := apismetav1.Convert_v1_LocalObjectReference_To_meta_LocalObjectReference(&in.CredentialsRef, &out.CredentialsRef, s); err != nil {
		return err
	}
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(meta.SecretKeySelector)
		if err := apismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	return nil
}

// Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP is an autogenerated conversion function.
func Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(in *VenafiTPP, out *certmanager.VenafiTPP, s conversion.Scope) error {
	return autoConvert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(in, out, s)
}

func autoConvert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(in *certmanager.VenafiTPP, out *VenafiTPP, s conversion.Scope) error {
	out.URL = in.URL
	if err := apismetav1.Convert_meta_LocalObjectReference_To_v1_LocalObjectReference(&in.CredentialsRef, &out.CredentialsRef, s); err != nil {
		return err
	}
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(metav1.SecretKeySelector)
		if err := apismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	return nil
}

// Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP is an autogenerated conversion function.
func Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(in *certmanager.VenafiTPP, out *VenafiTPP, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(in, out, s)
}

func autoConvert_v1alpha3_X509Subject_To_certmanager_X509Subject(in *X509Subject, out *certmanager.X509Subject, s conversion.Scope) error {
	out.Organizations = *(*[]string)(unsafe.Pointer(&in.Organizations))
	out.Countries = *(*[]string)(unsafe.Pointer(&in.Countries))
	out.OrganizationalUnits = *(*[]string)(unsafe.Pointer(&in.OrganizationalUnits))
	out.Localities = *(*[]string)(unsafe.Pointer(&in.Localities))
	out.Provinces = *(*[]string)(unsafe.Pointer(&in.Provinces))
	out.StreetAddresses = *(*[]string)(unsafe.Pointer(&in.StreetAddresses))
	out.PostalCodes = *(*[]string)(unsafe.Pointer(&in.PostalCodes))
	out.SerialNumber = in.SerialNumber
	return nil
}

// Convert_v1alpha3_X509Subject_To_certmanager_X509Subject is an autogenerated conversion function.
func Convert_v1alpha3_X509Subject_To_certmanager_X509Subject(in *X509Subject, out *certmanager.X509Subject, s conversion.Scope) error {
	return autoConvert_v1alpha3_X509Subject_To_certmanager_X509Subject(in, out, s)
}

func autoConvert_certmanager_X509Subject_To_v1alpha3_X509Subject(in *certmanager.X509Subject, out *X509Subject, s conversion.Scope) error {
	out.Organizations = *(*[]string)(unsafe.Pointer(&in.Organizations))
	out.Countries = *(*[]string)(unsafe.Pointer(&in.Countries))
	out.OrganizationalUnits = *(*[]string)(unsafe.Pointer(&in.OrganizationalUnits))
	out.Localities = *(*[]string)(unsafe.Pointer(&in.Localities))
	out.Provinces = *(*[]string)(unsafe.Pointer(&in.Provinces))
	out.StreetAddresses = *(*[]string)(unsafe.Pointer(&in.StreetAddresses))
	out.PostalCodes = *(*[]string)(unsafe.Pointer(&in.PostalCodes))
	out.SerialNumber = in.SerialNumber
	return nil
}
