/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_DDE_SHELL_V1_CLIENT_PROTOCOL_H
#define TREELAND_DDE_SHELL_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_dde_shell_v1 The treeland_dde_shell_v1 protocol
 * @section page_ifaces_treeland_dde_shell_v1 Interfaces
 * - @subpage page_iface_treeland_dde_shell_manager_v1 - dde shell manager
 * - @subpage page_iface_treeland_window_overlap_checker - An opened toplevel
 * - @subpage page_iface_treeland_dde_shell_surface_v1 - metadata interface
 * - @subpage page_iface_treeland_dde_active_v1 - metadata interface
 * - @subpage page_iface_treeland_multitaskview_v1 - multitaskview context interface
 * - @subpage page_iface_treeland_window_picker_v1 - window picker interface
 * - @subpage page_iface_treeland_lockscreen_v1 - lockscreen interface
 * @section page_copyright_treeland_dde_shell_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_dde_active_v1;
struct treeland_dde_shell_manager_v1;
struct treeland_dde_shell_surface_v1;
struct treeland_lockscreen_v1;
struct treeland_multitaskview_v1;
struct treeland_window_overlap_checker;
struct treeland_window_picker_v1;
struct wl_output;
struct wl_seat;
struct wl_surface;

#ifndef TREELAND_DDE_SHELL_MANAGER_V1_INTERFACE
#define TREELAND_DDE_SHELL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_dde_shell_manager_v1 treeland_dde_shell_manager_v1
 * @section page_iface_treeland_dde_shell_manager_v1_desc Description
 *
 * This interface allows DDE change some treeland function.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_dde_shell_manager_v1_api API
 * See @ref iface_treeland_dde_shell_manager_v1.
 */
/**
 * @defgroup iface_treeland_dde_shell_manager_v1 The treeland_dde_shell_manager_v1 interface
 *
 * This interface allows DDE change some treeland function.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_dde_shell_manager_v1_interface;
#endif
#ifndef TREELAND_WINDOW_OVERLAP_CHECKER_INTERFACE
#define TREELAND_WINDOW_OVERLAP_CHECKER_INTERFACE
/**
 * @page page_iface_treeland_window_overlap_checker treeland_window_overlap_checker
 * @section page_iface_treeland_window_overlap_checker_desc Description
 *
 * A treeland_dde_shell_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_window_overlap_checker_api API
 * See @ref iface_treeland_window_overlap_checker.
 */
/**
 * @defgroup iface_treeland_window_overlap_checker The treeland_window_overlap_checker interface
 *
 * A treeland_dde_shell_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_window_overlap_checker_interface;
#endif
#ifndef TREELAND_DDE_SHELL_SURFACE_V1_INTERFACE
#define TREELAND_DDE_SHELL_SURFACE_V1_INTERFACE
/**
 * @page page_iface_treeland_dde_shell_surface_v1 treeland_dde_shell_surface_v1
 * @section page_iface_treeland_dde_shell_surface_v1_desc Description
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface role, set skip, set the position
 * set auto placement in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * treeland_dde_shell_surface_v1.destroy() must be called before
 * destroying the wl_surface object.
 * @section page_iface_treeland_dde_shell_surface_v1_api API
 * See @ref iface_treeland_dde_shell_surface_v1.
 */
/**
 * @defgroup iface_treeland_dde_shell_surface_v1 The treeland_dde_shell_surface_v1 interface
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface role, set skip, set the position
 * set auto placement in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * treeland_dde_shell_surface_v1.destroy() must be called before
 * destroying the wl_surface object.
 */
extern const struct wl_interface treeland_dde_shell_surface_v1_interface;
#endif
#ifndef TREELAND_DDE_ACTIVE_V1_INTERFACE
#define TREELAND_DDE_ACTIVE_V1_INTERFACE
/**
 * @page page_iface_treeland_dde_active_v1 treeland_dde_active_v1
 * @section page_iface_treeland_dde_active_v1_desc Description
 *
 * An interface used to monitor special events.
 * @section page_iface_treeland_dde_active_v1_api API
 * See @ref iface_treeland_dde_active_v1.
 */
/**
 * @defgroup iface_treeland_dde_active_v1 The treeland_dde_active_v1 interface
 *
 * An interface used to monitor special events.
 */
extern const struct wl_interface treeland_dde_active_v1_interface;
#endif
#ifndef TREELAND_MULTITASKVIEW_V1_INTERFACE
#define TREELAND_MULTITASKVIEW_V1_INTERFACE
/**
 * @page page_iface_treeland_multitaskview_v1 treeland_multitaskview_v1
 * @section page_iface_treeland_multitaskview_v1_desc Description
 *
 * An interface used to control multitaskview.
 * @section page_iface_treeland_multitaskview_v1_api API
 * See @ref iface_treeland_multitaskview_v1.
 */
/**
 * @defgroup iface_treeland_multitaskview_v1 The treeland_multitaskview_v1 interface
 *
 * An interface used to control multitaskview.
 */
extern const struct wl_interface treeland_multitaskview_v1_interface;
#endif
#ifndef TREELAND_WINDOW_PICKER_V1_INTERFACE
#define TREELAND_WINDOW_PICKER_V1_INTERFACE
/**
 * @page page_iface_treeland_window_picker_v1 treeland_window_picker_v1
 * @section page_iface_treeland_window_picker_v1_desc Description
 *
 * An interface used to pick window and return credentials.
 * @section page_iface_treeland_window_picker_v1_api API
 * See @ref iface_treeland_window_picker_v1.
 */
/**
 * @defgroup iface_treeland_window_picker_v1 The treeland_window_picker_v1 interface
 *
 * An interface used to pick window and return credentials.
 */
extern const struct wl_interface treeland_window_picker_v1_interface;
#endif
#ifndef TREELAND_LOCKSCREEN_V1_INTERFACE
#define TREELAND_LOCKSCREEN_V1_INTERFACE
/**
 * @page page_iface_treeland_lockscreen_v1 treeland_lockscreen_v1
 * @section page_iface_treeland_lockscreen_v1_desc Description
 *
 * An interface used to operate lockscreen.
 * @section page_iface_treeland_lockscreen_v1_api API
 * See @ref iface_treeland_lockscreen_v1.
 */
/**
 * @defgroup iface_treeland_lockscreen_v1 The treeland_lockscreen_v1 interface
 *
 * An interface used to operate lockscreen.
 */
extern const struct wl_interface treeland_lockscreen_v1_interface;
#endif

#define TREELAND_DDE_SHELL_MANAGER_V1_GET_WINDOW_OVERLAP_CHECKER 0
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_SHELL_SURFACE 1
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_DDE_ACTIVE 2
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_MULTITASKVIEW 3
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_WINDOW_PICKER 4
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_LOCKSCREEN 5


/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_WINDOW_OVERLAP_CHECKER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_SHELL_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_DDE_ACTIVE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_MULTITASKVIEW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_WINDOW_PICKER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_LOCKSCREEN_SINCE_VERSION 1

/** @ingroup iface_treeland_dde_shell_manager_v1 */
static inline void
treeland_dde_shell_manager_v1_set_user_data(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_dde_shell_manager_v1, user_data);
}

/** @ingroup iface_treeland_dde_shell_manager_v1 */
static inline void *
treeland_dde_shell_manager_v1_get_user_data(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_dde_shell_manager_v1);
}

static inline uint32_t
treeland_dde_shell_manager_v1_get_version(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1);
}

/** @ingroup iface_treeland_dde_shell_manager_v1 */
static inline void
treeland_dde_shell_manager_v1_destroy(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) treeland_dde_shell_manager_v1);
}

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
static inline struct treeland_window_overlap_checker *
treeland_dde_shell_manager_v1_get_window_overlap_checker(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_manager_v1,
			 TREELAND_DDE_SHELL_MANAGER_V1_GET_WINDOW_OVERLAP_CHECKER, &treeland_window_overlap_checker_interface, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1), 0, NULL);

	return (struct treeland_window_overlap_checker *) id;
}

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 *
 * Create a shell surface for an existing wl_surface.
 *
 * Only one shell surface can be associated with a given surface.
 *
 * Recommended for use with xdg_surface.
 */
static inline struct treeland_dde_shell_surface_v1 *
treeland_dde_shell_manager_v1_get_shell_surface(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_manager_v1,
			 TREELAND_DDE_SHELL_MANAGER_V1_GET_SHELL_SURFACE, &treeland_dde_shell_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1), 0, NULL, surface);

	return (struct treeland_dde_shell_surface_v1 *) id;
}

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 *
 * Create a new dde active for a given seat.
 */
static inline struct treeland_dde_active_v1 *
treeland_dde_shell_manager_v1_get_treeland_dde_active(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1, struct wl_seat *seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_manager_v1,
			 TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_DDE_ACTIVE, &treeland_dde_active_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1), 0, NULL, seat);

	return (struct treeland_dde_active_v1 *) id;
}

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 *
 * Create a new multitaskview context for toggle.
 */
static inline struct treeland_multitaskview_v1 *
treeland_dde_shell_manager_v1_get_treeland_multitaskview(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_manager_v1,
			 TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_MULTITASKVIEW, &treeland_multitaskview_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1), 0, NULL);

	return (struct treeland_multitaskview_v1 *) id;
}

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 *
 * Create a new window picker to pick window.
 */
static inline struct treeland_window_picker_v1 *
treeland_dde_shell_manager_v1_get_treeland_window_picker(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_manager_v1,
			 TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_WINDOW_PICKER, &treeland_window_picker_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1), 0, NULL);

	return (struct treeland_window_picker_v1 *) id;
}

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 *
 * Create a new lockscreen context for toggle.
 */
static inline struct treeland_lockscreen_v1 *
treeland_dde_shell_manager_v1_get_treeland_lockscreen(struct treeland_dde_shell_manager_v1 *treeland_dde_shell_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_manager_v1,
			 TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_LOCKSCREEN, &treeland_lockscreen_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_manager_v1), 0, NULL);

	return (struct treeland_lockscreen_v1 *) id;
}

#ifndef TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM
#define TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM
/**
 * @ingroup iface_treeland_window_overlap_checker
 * same layershell
 *
 * same layershell
 */
enum treeland_window_overlap_checker_anchor {
	/**
	 * the top edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_TOP = 1,
	/**
	 * the bottom edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_BOTTOM = 2,
	/**
	 * the left edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_LEFT = 4,
	/**
	 * the right edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_RIGHT = 8,
};
#endif /* TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM */

/**
 * @ingroup iface_treeland_window_overlap_checker
 * @struct treeland_window_overlap_checker_listener
 */
struct treeland_window_overlap_checker_listener {
	/**
	 * Window has overlapped
	 *
	 * This event is sent when windows overlapped. This event is sent
	 * only once.
	 */
	void (*enter)(void *data,
		      struct treeland_window_overlap_checker *treeland_window_overlap_checker);
	/**
	 * Window not has overlapped
	 *
	 * This event is sent when windows not overlapped. This event is
	 * sent only once.
	 */
	void (*leave)(void *data,
		      struct treeland_window_overlap_checker *treeland_window_overlap_checker);
};

/**
 * @ingroup iface_treeland_window_overlap_checker
 */
static inline int
treeland_window_overlap_checker_add_listener(struct treeland_window_overlap_checker *treeland_window_overlap_checker,
					     const struct treeland_window_overlap_checker_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_window_overlap_checker,
				     (void (**)(void)) listener, data);
}

#define TREELAND_WINDOW_OVERLAP_CHECKER_UPDATE 0
#define TREELAND_WINDOW_OVERLAP_CHECKER_DESTROY 1

/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_LEAVE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_UPDATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_window_overlap_checker */
static inline void
treeland_window_overlap_checker_set_user_data(struct treeland_window_overlap_checker *treeland_window_overlap_checker, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_window_overlap_checker, user_data);
}

/** @ingroup iface_treeland_window_overlap_checker */
static inline void *
treeland_window_overlap_checker_get_user_data(struct treeland_window_overlap_checker *treeland_window_overlap_checker)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_window_overlap_checker);
}

static inline uint32_t
treeland_window_overlap_checker_get_version(struct treeland_window_overlap_checker *treeland_window_overlap_checker)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_window_overlap_checker);
}

/**
 * @ingroup iface_treeland_window_overlap_checker
 *
 * This interface is used to receive the detected surface.
 * When the xdgshell window in the workspace overlaps with the detected window,
 * an event will be sent to notify the client to process it.
 * The window position will only be recorded when this interface is called.
 * If the window moves, this interface needs to be called again.
 */
static inline void
treeland_window_overlap_checker_update(struct treeland_window_overlap_checker *treeland_window_overlap_checker, int32_t width, int32_t height, uint32_t anchor, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_window_overlap_checker,
			 TREELAND_WINDOW_OVERLAP_CHECKER_UPDATE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_window_overlap_checker), 0, width, height, anchor, output);
}

/**
 * @ingroup iface_treeland_window_overlap_checker
 *
 * Destroys the treeland_window_overlap_checker object.
 *
 * This request should be called either when the client does not want to
 * use the toplevel anymore or after the closed event to finalize the
 * destruction of the object.
 */
static inline void
treeland_window_overlap_checker_destroy(struct treeland_window_overlap_checker *treeland_window_overlap_checker)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_window_overlap_checker,
			 TREELAND_WINDOW_OVERLAP_CHECKER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_window_overlap_checker), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM
#define TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 * available roles for surfaces
 *
 * These values indicate which roles a surface can be rendered in, They
 * are ordered by z depth.
 *
 * Displayed below wlr-layer-shell, at the overlay level of the workspace.
 *
 * Multiple surfaces can share a single role, and ordering within a single
 * role is undefined.
 */
enum treeland_dde_shell_surface_v1_role {
	TREELAND_DDE_SHELL_SURFACE_V1_ROLE_OVERLAY = 1,
};
#endif /* TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM */

#define TREELAND_DDE_SHELL_SURFACE_V1_DESTROY 0
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SURFACE_POSITION 1
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_ROLE 2
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_AUTO_PLACEMENT 3
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_SWITCHER 4
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_DOCK_PREVIEW 5
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_MUTI_TASK_VIEW 6
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_ACCEPT_KEYBOARD_FOCUS 7


/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SURFACE_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_ROLE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_AUTO_PLACEMENT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_SWITCHER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_DOCK_PREVIEW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_MUTI_TASK_VIEW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_ACCEPT_KEYBOARD_FOCUS_SINCE_VERSION 1

/** @ingroup iface_treeland_dde_shell_surface_v1 */
static inline void
treeland_dde_shell_surface_v1_set_user_data(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_dde_shell_surface_v1, user_data);
}

/** @ingroup iface_treeland_dde_shell_surface_v1 */
static inline void *
treeland_dde_shell_surface_v1_get_user_data(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_dde_shell_surface_v1);
}

static inline uint32_t
treeland_dde_shell_surface_v1_get_version(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * The treeland_dde_shell_surface_v1 interface is removed from the
 * wl_surface object that was turned into a shell surface with the
 * treeland_shell_v1.get_treeland_dde_shell_surface request.
 *
 * The shell surface role is lost and wl_surface is unmapped.
 */
static inline void
treeland_dde_shell_surface_v1_destroy(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Move the surface to new coordinates.
 *
 * Coordinates are global, for example 50,50 for a 1920,0+1920x1080 output
 * is 1970,50 in global coordinates space.
 */
static inline void
treeland_dde_shell_surface_v1_set_surface_position(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_SURFACE_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, x, y);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Assign a role to a shell surface.
 */
static inline void
treeland_dde_shell_surface_v1_set_role(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, uint32_t role)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_ROLE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, role);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Set the vertical alignment of the surface within the cursor width.
 *
 * Do not use it together with set_surface_position to avoid exceptions.
 *
 * The position of the surface will be controlled by the compositor after the
 * request, including preventing it from being displayed beyond the edge of
 * the output.
 */
static inline void
treeland_dde_shell_surface_v1_set_auto_placement(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, uint32_t y_offset)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_AUTO_PLACEMENT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, y_offset);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Setting this bit will indicate that the window prefers not to be listed in a switcher.
 */
static inline void
treeland_dde_shell_surface_v1_set_skip_switcher(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_SWITCHER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, skip);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Setting this bit will indicate that the window prefers not to be listed in a dock preview.
 */
static inline void
treeland_dde_shell_surface_v1_set_skip_dock_preview(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_DOCK_PREVIEW, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, skip);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Setting this bit will indicate that the window prefers not to be listed in a mutitask view.
 */
static inline void
treeland_dde_shell_surface_v1_set_skip_muti_task_view(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_MUTI_TASK_VIEW, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, skip);
}

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 *
 * Setting this will determine whether the surface can receive keyboard focus.
 * When set to 0, the surface will not receive keyboard focus even when clicked or activated.
 * When set to 1 (default), the surface will receive keyboard focus normally.
 */
static inline void
treeland_dde_shell_surface_v1_set_accept_keyboard_focus(struct treeland_dde_shell_surface_v1 *treeland_dde_shell_surface_v1, uint32_t accept)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_shell_surface_v1,
			 TREELAND_DDE_SHELL_SURFACE_V1_SET_ACCEPT_KEYBOARD_FOCUS, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_shell_surface_v1), 0, accept);
}

#ifndef TREELAND_DDE_ACTIVE_V1_REASON_ENUM
#define TREELAND_DDE_ACTIVE_V1_REASON_ENUM
/**
 * @ingroup iface_treeland_dde_active_v1
 * event reason
 */
enum treeland_dde_active_v1_reason {
	TREELAND_DDE_ACTIVE_V1_REASON_MOUSE = 0,
	TREELAND_DDE_ACTIVE_V1_REASON_WHEEL = 1,
};
#endif /* TREELAND_DDE_ACTIVE_V1_REASON_ENUM */

/**
 * @ingroup iface_treeland_dde_active_v1
 * @struct treeland_dde_active_v1_listener
 */
struct treeland_dde_active_v1_listener {
	/**
	 * activeIn event
	 *
	 * 
	 */
	void (*active_in)(void *data,
			  struct treeland_dde_active_v1 *treeland_dde_active_v1,
			  uint32_t reason);
	/**
	 * activeOut event
	 *
	 * 
	 */
	void (*active_out)(void *data,
			   struct treeland_dde_active_v1 *treeland_dde_active_v1,
			   uint32_t reason);
	/**
	 * sent when the compositor starts a drag operation
	 *
	 * 
	 */
	void (*start_drag)(void *data,
			   struct treeland_dde_active_v1 *treeland_dde_active_v1);
	/**
	 * sent when the compositor drop operation
	 *
	 * 
	 */
	void (*drop)(void *data,
		     struct treeland_dde_active_v1 *treeland_dde_active_v1);
};

/**
 * @ingroup iface_treeland_dde_active_v1
 */
static inline int
treeland_dde_active_v1_add_listener(struct treeland_dde_active_v1 *treeland_dde_active_v1,
				    const struct treeland_dde_active_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_dde_active_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_DDE_ACTIVE_V1_DESTROY 0

/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_ACTIVE_IN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_ACTIVE_OUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_START_DRAG_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_DROP_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_dde_active_v1 */
static inline void
treeland_dde_active_v1_set_user_data(struct treeland_dde_active_v1 *treeland_dde_active_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_dde_active_v1, user_data);
}

/** @ingroup iface_treeland_dde_active_v1 */
static inline void *
treeland_dde_active_v1_get_user_data(struct treeland_dde_active_v1 *treeland_dde_active_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_dde_active_v1);
}

static inline uint32_t
treeland_dde_active_v1_get_version(struct treeland_dde_active_v1 *treeland_dde_active_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_dde_active_v1);
}

/**
 * @ingroup iface_treeland_dde_active_v1
 *
 */
static inline void
treeland_dde_active_v1_destroy(struct treeland_dde_active_v1 *treeland_dde_active_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dde_active_v1,
			 TREELAND_DDE_ACTIVE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dde_active_v1), WL_MARSHAL_FLAG_DESTROY);
}

#define TREELAND_MULTITASKVIEW_V1_DESTROY 0
#define TREELAND_MULTITASKVIEW_V1_TOGGLE 1


/**
 * @ingroup iface_treeland_multitaskview_v1
 */
#define TREELAND_MULTITASKVIEW_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_multitaskview_v1
 */
#define TREELAND_MULTITASKVIEW_V1_TOGGLE_SINCE_VERSION 1

/** @ingroup iface_treeland_multitaskview_v1 */
static inline void
treeland_multitaskview_v1_set_user_data(struct treeland_multitaskview_v1 *treeland_multitaskview_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_multitaskview_v1, user_data);
}

/** @ingroup iface_treeland_multitaskview_v1 */
static inline void *
treeland_multitaskview_v1_get_user_data(struct treeland_multitaskview_v1 *treeland_multitaskview_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_multitaskview_v1);
}

static inline uint32_t
treeland_multitaskview_v1_get_version(struct treeland_multitaskview_v1 *treeland_multitaskview_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_multitaskview_v1);
}

/**
 * @ingroup iface_treeland_multitaskview_v1
 *
 */
static inline void
treeland_multitaskview_v1_destroy(struct treeland_multitaskview_v1 *treeland_multitaskview_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_multitaskview_v1,
			 TREELAND_MULTITASKVIEW_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_multitaskview_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_multitaskview_v1
 *
 * Show or hide the multitaskview.
 */
static inline void
treeland_multitaskview_v1_toggle(struct treeland_multitaskview_v1 *treeland_multitaskview_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_multitaskview_v1,
			 TREELAND_MULTITASKVIEW_V1_TOGGLE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_multitaskview_v1), 0);
}

/**
 * @ingroup iface_treeland_window_picker_v1
 * @struct treeland_window_picker_v1_listener
 */
struct treeland_window_picker_v1_listener {
	/**
	 * window picked
	 *
	 * Picked window information.
	 * @param pid Pid of picked window
	 */
	void (*window)(void *data,
		       struct treeland_window_picker_v1 *treeland_window_picker_v1,
		       int32_t pid);
};

/**
 * @ingroup iface_treeland_window_picker_v1
 */
static inline int
treeland_window_picker_v1_add_listener(struct treeland_window_picker_v1 *treeland_window_picker_v1,
				       const struct treeland_window_picker_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_window_picker_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_WINDOW_PICKER_V1_DESTROY 0
#define TREELAND_WINDOW_PICKER_V1_PICK 1

/**
 * @ingroup iface_treeland_window_picker_v1
 */
#define TREELAND_WINDOW_PICKER_V1_WINDOW_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_picker_v1
 */
#define TREELAND_WINDOW_PICKER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_picker_v1
 */
#define TREELAND_WINDOW_PICKER_V1_PICK_SINCE_VERSION 1

/** @ingroup iface_treeland_window_picker_v1 */
static inline void
treeland_window_picker_v1_set_user_data(struct treeland_window_picker_v1 *treeland_window_picker_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_window_picker_v1, user_data);
}

/** @ingroup iface_treeland_window_picker_v1 */
static inline void *
treeland_window_picker_v1_get_user_data(struct treeland_window_picker_v1 *treeland_window_picker_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_window_picker_v1);
}

static inline uint32_t
treeland_window_picker_v1_get_version(struct treeland_window_picker_v1 *treeland_window_picker_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_window_picker_v1);
}

/**
 * @ingroup iface_treeland_window_picker_v1
 *
 */
static inline void
treeland_window_picker_v1_destroy(struct treeland_window_picker_v1 *treeland_window_picker_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_window_picker_v1,
			 TREELAND_WINDOW_PICKER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_window_picker_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_window_picker_v1
 *
 * Pick a window to get information.
 */
static inline void
treeland_window_picker_v1_pick(struct treeland_window_picker_v1 *treeland_window_picker_v1, const char *hint)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_window_picker_v1,
			 TREELAND_WINDOW_PICKER_V1_PICK, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_window_picker_v1), 0, hint);
}

#define TREELAND_LOCKSCREEN_V1_DESTROY 0
#define TREELAND_LOCKSCREEN_V1_LOCK 1
#define TREELAND_LOCKSCREEN_V1_SHUTDOWN 2
#define TREELAND_LOCKSCREEN_V1_SWITCH_USER 3


/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_LOCK_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_SHUTDOWN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_SWITCH_USER_SINCE_VERSION 1

/** @ingroup iface_treeland_lockscreen_v1 */
static inline void
treeland_lockscreen_v1_set_user_data(struct treeland_lockscreen_v1 *treeland_lockscreen_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_lockscreen_v1, user_data);
}

/** @ingroup iface_treeland_lockscreen_v1 */
static inline void *
treeland_lockscreen_v1_get_user_data(struct treeland_lockscreen_v1 *treeland_lockscreen_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_lockscreen_v1);
}

static inline uint32_t
treeland_lockscreen_v1_get_version(struct treeland_lockscreen_v1 *treeland_lockscreen_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_lockscreen_v1);
}

/**
 * @ingroup iface_treeland_lockscreen_v1
 *
 */
static inline void
treeland_lockscreen_v1_destroy(struct treeland_lockscreen_v1 *treeland_lockscreen_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_lockscreen_v1,
			 TREELAND_LOCKSCREEN_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_lockscreen_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_lockscreen_v1
 *
 * Lock the screen.
 */
static inline void
treeland_lockscreen_v1_lock(struct treeland_lockscreen_v1 *treeland_lockscreen_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_lockscreen_v1,
			 TREELAND_LOCKSCREEN_V1_LOCK, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_lockscreen_v1), 0);
}

/**
 * @ingroup iface_treeland_lockscreen_v1
 *
 * Show shutdown.
 */
static inline void
treeland_lockscreen_v1_shutdown(struct treeland_lockscreen_v1 *treeland_lockscreen_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_lockscreen_v1,
			 TREELAND_LOCKSCREEN_V1_SHUTDOWN, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_lockscreen_v1), 0);
}

/**
 * @ingroup iface_treeland_lockscreen_v1
 *
 * Switch user.
 */
static inline void
treeland_lockscreen_v1_switch_user(struct treeland_lockscreen_v1 *treeland_lockscreen_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_lockscreen_v1,
			 TREELAND_LOCKSCREEN_V1_SWITCH_USER, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_lockscreen_v1), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
