/*************************************************************************
** Calculator.hpp                                                       **
**                                                                      **
** This file is part of dvisvgm -- a fast DVI to SVG converter          **
** Copyright (C) 2005-2025 Martin Gieseking <martin.gieseking@uos.de>   **
**                                                                      **
** This program is free software; you can redistribute it and/or        **
** modify it under the terms of the GNU General Public License as       **
** published by the Free Software Foundation; either version 3 of       **
** the License, or (at your option) any later version.                  **
**                                                                      **
** This program is distributed in the hope that it will be useful, but  **
** WITHOUT ANY WARRANTY; without even the implied warranty of           **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, see <http://www.gnu.org/licenses/>. **
*************************************************************************/

#ifndef CALCULATOR_HPP
#define CALCULATOR_HPP

#include <istream>
#include <map>
#include <string>
#include <mpark/variant.hpp>
#include "MessageException.hpp"

struct CalculatorException : MessageException {
	explicit CalculatorException (const std::string &msg) : MessageException(msg) {}
};

class Calculator {
	public:
		double eval (std::istream &is) const;
		double eval (const std::string &expr) const;
		void setVariable (const std::string &name, double value) {_variables[name] = value;}
		double getVariable (const std::string &name) const;

	protected:
		double expr (std::istream &is, bool skip) const;
		double term (std::istream &is, bool skip) const;
		double prim (std::istream &is, bool skip) const;

		using Token = mpark::variant<bool, char, double, std::string>;
		static Token lex (std::istream &is);
		static Token lookAhead (std::istream &is);

	private:
		std::map<std::string,double> _variables;
};

#endif
