// Code generated by smithy-go-codegen DO NOT EDIT.

package eks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all managed capabilities in your Amazon EKS cluster. You can use this
// operation to get an overview of all capabilities and their current status.
func (c *Client) ListCapabilities(ctx context.Context, params *ListCapabilitiesInput, optFns ...func(*Options)) (*ListCapabilitiesOutput, error) {
	if params == nil {
		params = &ListCapabilitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCapabilities", params, optFns, c.addOperationListCapabilitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCapabilitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCapabilitiesInput struct {

	// The name of the Amazon EKS cluster for which you want to list capabilities.
	//
	// This member is required.
	ClusterName *string

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. If you
	// don't specify a value, the default is 100 results.
	MaxResults *int32

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCapabilitiesOutput struct {

	// A list of capability summary objects, each containing basic information about a
	// capability including its name, ARN, type, status, version, and timestamps.
	Capabilities []types.CapabilitySummary

	// The nextToken value to include in a future ListCapabilities request. When the
	// results of a ListCapabilities request exceed maxResults , you can use this value
	// to retrieve the next page of results. This value is null when there are no more
	// results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCapabilitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCapabilities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCapabilities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCapabilities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCapabilitiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCapabilities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCapabilitiesPaginatorOptions is the paginator options for ListCapabilities
type ListCapabilitiesPaginatorOptions struct {
	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. If you
	// don't specify a value, the default is 100 results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCapabilitiesPaginator is a paginator for ListCapabilities
type ListCapabilitiesPaginator struct {
	options   ListCapabilitiesPaginatorOptions
	client    ListCapabilitiesAPIClient
	params    *ListCapabilitiesInput
	nextToken *string
	firstPage bool
}

// NewListCapabilitiesPaginator returns a new ListCapabilitiesPaginator
func NewListCapabilitiesPaginator(client ListCapabilitiesAPIClient, params *ListCapabilitiesInput, optFns ...func(*ListCapabilitiesPaginatorOptions)) *ListCapabilitiesPaginator {
	if params == nil {
		params = &ListCapabilitiesInput{}
	}

	options := ListCapabilitiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCapabilitiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCapabilitiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCapabilities page.
func (p *ListCapabilitiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCapabilitiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCapabilities(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCapabilitiesAPIClient is a client that implements the ListCapabilities
// operation.
type ListCapabilitiesAPIClient interface {
	ListCapabilities(context.Context, *ListCapabilitiesInput, ...func(*Options)) (*ListCapabilitiesOutput, error)
}

var _ ListCapabilitiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCapabilities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCapabilities",
	}
}
