// Code generated by smithy-go-codegen DO NOT EDIT.

package outposts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/outposts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets current and historical billing information about the specified Outpost.
func (c *Client) GetOutpostBillingInformation(ctx context.Context, params *GetOutpostBillingInformationInput, optFns ...func(*Options)) (*GetOutpostBillingInformationOutput, error) {
	if params == nil {
		params = &GetOutpostBillingInformationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetOutpostBillingInformation", params, optFns, c.addOperationGetOutpostBillingInformationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetOutpostBillingInformationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetOutpostBillingInformationInput struct {

	// The ID or ARN of the Outpost.
	//
	// This member is required.
	OutpostIdentifier *string

	// The maximum page size.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type GetOutpostBillingInformationOutput struct {

	// The date the current contract term ends for the specified Outpost. You must
	// start the renewal or decommission process at least 5 business days before the
	// current term for your Amazon Web Services Outposts ends. Failing to complete
	// these steps at least 5 business days before the current term ends might result
	// in unanticipated charges.
	ContractEndDate *string

	// The pagination token.
	NextToken *string

	// The subscription details for the specified Outpost.
	Subscriptions []types.Subscription

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetOutpostBillingInformationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetOutpostBillingInformation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetOutpostBillingInformation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetOutpostBillingInformation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetOutpostBillingInformationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetOutpostBillingInformation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetOutpostBillingInformationPaginatorOptions is the paginator options for
// GetOutpostBillingInformation
type GetOutpostBillingInformationPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetOutpostBillingInformationPaginator is a paginator for
// GetOutpostBillingInformation
type GetOutpostBillingInformationPaginator struct {
	options   GetOutpostBillingInformationPaginatorOptions
	client    GetOutpostBillingInformationAPIClient
	params    *GetOutpostBillingInformationInput
	nextToken *string
	firstPage bool
}

// NewGetOutpostBillingInformationPaginator returns a new
// GetOutpostBillingInformationPaginator
func NewGetOutpostBillingInformationPaginator(client GetOutpostBillingInformationAPIClient, params *GetOutpostBillingInformationInput, optFns ...func(*GetOutpostBillingInformationPaginatorOptions)) *GetOutpostBillingInformationPaginator {
	if params == nil {
		params = &GetOutpostBillingInformationInput{}
	}

	options := GetOutpostBillingInformationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetOutpostBillingInformationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetOutpostBillingInformationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetOutpostBillingInformation page.
func (p *GetOutpostBillingInformationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetOutpostBillingInformationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetOutpostBillingInformation(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetOutpostBillingInformationAPIClient is a client that implements the
// GetOutpostBillingInformation operation.
type GetOutpostBillingInformationAPIClient interface {
	GetOutpostBillingInformation(context.Context, *GetOutpostBillingInformationInput, ...func(*Options)) (*GetOutpostBillingInformationOutput, error)
}

var _ GetOutpostBillingInformationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetOutpostBillingInformation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetOutpostBillingInformation",
	}
}
