// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The requester doesn't have permissions to perform the requested operation.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error returned if an attempt is made to register a patch group with a patch
// baseline that is already registered with a different patch baseline.
type AlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *AlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You must disassociate a document from all managed nodes before you can delete
// it.
type AssociatedInstances struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AssociatedInstances) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssociatedInstances) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssociatedInstances) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssociatedInstances"
	}
	return *e.ErrorCodeOverride
}
func (e *AssociatedInstances) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified association already exists.
type AssociationAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AssociationAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssociationAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssociationAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssociationAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *AssociationAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified association doesn't exist.
type AssociationDoesNotExist struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AssociationDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssociationDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssociationDoesNotExist) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssociationDoesNotExist"
	}
	return *e.ErrorCodeOverride
}
func (e *AssociationDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified execution ID doesn't exist. Verify the ID number and try again.
type AssociationExecutionDoesNotExist struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AssociationExecutionDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssociationExecutionDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssociationExecutionDoesNotExist) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssociationExecutionDoesNotExist"
	}
	return *e.ErrorCodeOverride
}
func (e *AssociationExecutionDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can have at most 2,000 active associations.
type AssociationLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AssociationLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssociationLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssociationLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssociationLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *AssociationLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the maximum number versions allowed for an association. Each
// association has a limit of 1,000 versions.
type AssociationVersionLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AssociationVersionLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AssociationVersionLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AssociationVersionLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AssociationVersionLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *AssociationVersionLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Indicates that the Change Manager change template used in the change request
// was rejected or is still in a pending state.
type AutomationDefinitionNotApprovedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AutomationDefinitionNotApprovedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AutomationDefinitionNotApprovedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AutomationDefinitionNotApprovedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AutomationDefinitionNotApprovedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AutomationDefinitionNotApprovedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An Automation runbook with the specified name couldn't be found.
type AutomationDefinitionNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AutomationDefinitionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AutomationDefinitionNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AutomationDefinitionNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AutomationDefinitionNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AutomationDefinitionNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An Automation runbook with the specified name and version couldn't be found.
type AutomationDefinitionVersionNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AutomationDefinitionVersionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AutomationDefinitionVersionNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AutomationDefinitionVersionNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AutomationDefinitionVersionNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AutomationDefinitionVersionNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of simultaneously running Automation executions exceeded the
// allowable limit.
type AutomationExecutionLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AutomationExecutionLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AutomationExecutionLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AutomationExecutionLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AutomationExecutionLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *AutomationExecutionLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is no automation execution information for the requested automation
// execution ID.
type AutomationExecutionNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AutomationExecutionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AutomationExecutionNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AutomationExecutionNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AutomationExecutionNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AutomationExecutionNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified step name and execution ID don't exist. Verify the information
// and try again.
type AutomationStepNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AutomationStepNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AutomationStepNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AutomationStepNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AutomationStepNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AutomationStepNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You specified too many custom compliance types. You can specify a maximum of 10
// different types.
type ComplianceTypeCountLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ComplianceTypeCountLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ComplianceTypeCountLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ComplianceTypeCountLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ComplianceTypeCountLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ComplianceTypeCountLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have exceeded the limit for custom schemas. Delete one or more custom
// schemas and try again.
type CustomSchemaCountLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomSchemaCountLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomSchemaCountLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomSchemaCountLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomSchemaCountLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomSchemaCountLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified document already exists.
type DocumentAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DocumentAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DocumentAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DocumentAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DocumentAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DocumentAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can have at most 500 active SSM documents.
type DocumentLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DocumentLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DocumentLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DocumentLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DocumentLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DocumentLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The document can't be shared with more Amazon Web Services accounts. You can
// specify a maximum of 20 accounts per API operation to share a private document.
//
// By default, you can share a private document with a maximum of 1,000 accounts
// and publicly share up to five documents.
//
// If you need to increase the quota for privately or publicly shared Systems
// Manager documents, contact Amazon Web Services Support.
type DocumentPermissionLimit struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DocumentPermissionLimit) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DocumentPermissionLimit) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DocumentPermissionLimit) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DocumentPermissionLimit"
	}
	return *e.ErrorCodeOverride
}
func (e *DocumentPermissionLimit) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The document has too many versions. Delete one or more document versions and
// try again.
type DocumentVersionLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DocumentVersionLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DocumentVersionLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DocumentVersionLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DocumentVersionLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DocumentVersionLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error returned when the ID specified for a resource, such as a maintenance
// window or patch baseline, doesn't exist.
//
// For information about resource quotas in Amazon Web Services Systems Manager,
// see [Systems Manager service quotas]in the Amazon Web Services General Reference.
//
// [Systems Manager service quotas]: https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm
type DoesNotExistException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DoesNotExistException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DoesNotExistException"
	}
	return *e.ErrorCodeOverride
}
func (e *DoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The content of the association document matches another document. Change the
// content of the document and try again.
type DuplicateDocumentContent struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateDocumentContent) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateDocumentContent) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateDocumentContent) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateDocumentContent"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateDocumentContent) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The version name has already been used in this document. Specify a different
// version name, and then try again.
type DuplicateDocumentVersionName struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateDocumentVersionName) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateDocumentVersionName) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateDocumentVersionName) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateDocumentVersionName"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateDocumentVersionName) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't specify a managed node ID in more than one association.
type DuplicateInstanceId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateInstanceId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateInstanceId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateInstanceId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateInstanceId"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateInstanceId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You attempted to register a LAMBDA or STEP_FUNCTIONS task in a region where the
// corresponding service isn't available.
type FeatureNotAvailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FeatureNotAvailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FeatureNotAvailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FeatureNotAvailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FeatureNotAvailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *FeatureNotAvailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A hierarchy can have a maximum of 15 levels. For more information, see [Requirements and constraints for parameter names] in the
// Amazon Web Services Systems Manager User Guide.
//
// [Requirements and constraints for parameter names]: https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html
type HierarchyLevelLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HierarchyLevelLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HierarchyLevelLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HierarchyLevelLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HierarchyLevelLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *HierarchyLevelLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Parameter Store doesn't support changing a parameter type in a hierarchy. For
// example, you can't change a parameter from a String type to a SecureString
// type. You must create a new, unique parameter.
type HierarchyTypeMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HierarchyTypeMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HierarchyTypeMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HierarchyTypeMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HierarchyTypeMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *HierarchyTypeMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error returned when an idempotent operation is retried and the parameters don't
// match the original call to the API with the same idempotency token.
type IdempotentParameterMismatch struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatch) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatch) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatch) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IdempotentParameterMismatch"
	}
	return *e.ErrorCodeOverride
}
func (e *IdempotentParameterMismatch) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There is a conflict in the policies specified for this parameter. You can't,
// for example, specify two Expiration policies for a parameter. Review your
// policies, and try again.
type IncompatiblePolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IncompatiblePolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IncompatiblePolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IncompatiblePolicyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IncompatiblePolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *IncompatiblePolicyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An error occurred on the server side.
type InternalServerError struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServerError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServerError) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServerError"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServerError) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The activation isn't valid. The activation might have been deleted, or the
// ActivationId and the ActivationCode don't match.
type InvalidActivation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidActivation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidActivation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidActivation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidActivation"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidActivation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The activation ID isn't valid. Verify that you entered the correct ActivationId
// or ActivationCode and try again.
type InvalidActivationId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidActivationId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidActivationId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidActivationId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidActivationId"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidActivationId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified aggregator isn't valid for the group type. Verify that the
// aggregator you provided is supported.
type InvalidAggregatorException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAggregatorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAggregatorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAggregatorException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAggregatorException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAggregatorException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request doesn't meet the regular expression requirement.
type InvalidAllowedPatternException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAllowedPatternException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAllowedPatternException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAllowedPatternException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAllowedPatternException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAllowedPatternException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The association isn't valid or doesn't exist.
type InvalidAssociation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAssociation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAssociation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAssociation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAssociation"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAssociation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The version you specified isn't valid. Use ListAssociationVersions to view all
// versions of an association according to the association ID. Or, use the $LATEST
// parameter to view the latest version of the association.
type InvalidAssociationVersion struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAssociationVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAssociationVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAssociationVersion) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAssociationVersion"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAssociationVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The supplied parameters for invoking the specified Automation runbook are
// incorrect. For example, they may not match the set of parameters permitted for
// the specified Automation document.
type InvalidAutomationExecutionParametersException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAutomationExecutionParametersException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAutomationExecutionParametersException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAutomationExecutionParametersException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAutomationExecutionParametersException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAutomationExecutionParametersException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The signal isn't valid for the current Automation execution.
type InvalidAutomationSignalException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAutomationSignalException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAutomationSignalException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAutomationSignalException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAutomationSignalException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAutomationSignalException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified update status operation isn't valid.
type InvalidAutomationStatusUpdateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAutomationStatusUpdateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAutomationStatusUpdateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAutomationStatusUpdateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidAutomationStatusUpdateException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAutomationStatusUpdateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified command ID isn't valid. Verify the ID and try again.
type InvalidCommandId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCommandId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCommandId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCommandId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCommandId"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCommandId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more of the parameters specified for the delete operation isn't valid.
// Verify all parameters and try again.
type InvalidDeleteInventoryParametersException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDeleteInventoryParametersException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeleteInventoryParametersException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeleteInventoryParametersException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDeleteInventoryParametersException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDeleteInventoryParametersException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The ID specified for the delete operation doesn't exist or isn't valid. Verify
// the ID and try again.
type InvalidDeletionIdException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDeletionIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeletionIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeletionIdException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDeletionIdException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDeletionIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified SSM document doesn't exist.
type InvalidDocument struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDocument) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDocument) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDocument) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDocument"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDocument) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The content for the document isn't valid.
type InvalidDocumentContent struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDocumentContent) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDocumentContent) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDocumentContent) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDocumentContent"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDocumentContent) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You attempted to delete a document while it is still shared. You must stop
// sharing the document before you can delete it.
type InvalidDocumentOperation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDocumentOperation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDocumentOperation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDocumentOperation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDocumentOperation"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDocumentOperation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The version of the document schema isn't supported.
type InvalidDocumentSchemaVersion struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDocumentSchemaVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDocumentSchemaVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDocumentSchemaVersion) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDocumentSchemaVersion"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDocumentSchemaVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The SSM document type isn't valid. Valid document types are described in the
// DocumentType property.
type InvalidDocumentType struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDocumentType) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDocumentType) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDocumentType) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDocumentType"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDocumentType) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The document version isn't valid or doesn't exist.
type InvalidDocumentVersion struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDocumentVersion) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDocumentVersion) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDocumentVersion) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDocumentVersion"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDocumentVersion) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The filter name isn't valid. Verify that you entered the correct name and try
// again.
type InvalidFilter struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFilter) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFilter) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFilter) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidFilter"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFilter) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified key isn't valid.
type InvalidFilterKey struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFilterKey) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFilterKey) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFilterKey) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidFilterKey"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFilterKey) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified filter option isn't valid. Valid options are Equals and
// BeginsWith. For Path filter, valid options are Recursive and OneLevel.
type InvalidFilterOption struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFilterOption) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFilterOption) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFilterOption) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidFilterOption"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFilterOption) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The filter value isn't valid. Verify the value and try again.
type InvalidFilterValue struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidFilterValue) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFilterValue) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFilterValue) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidFilterValue"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidFilterValue) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running. Verify
//     that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running , Pending
//     , Stopped , and Stopping . Invalid states are: Shutting-down and Terminated .
type InvalidInstanceId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInstanceId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInstanceId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInstanceId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInstanceId"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInstanceId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified filter value isn't valid.
type InvalidInstanceInformationFilterValue struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInstanceInformationFilterValue) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInstanceInformationFilterValue) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInstanceInformationFilterValue) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInstanceInformationFilterValue"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInstanceInformationFilterValue) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified filter value isn't valid.
type InvalidInstancePropertyFilterValue struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInstancePropertyFilterValue) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInstancePropertyFilterValue) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInstancePropertyFilterValue) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInstancePropertyFilterValue"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInstancePropertyFilterValue) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified inventory group isn't valid.
type InvalidInventoryGroupException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInventoryGroupException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInventoryGroupException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInventoryGroupException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInventoryGroupException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInventoryGroupException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You specified invalid keys or values in the Context attribute for InventoryItem
// . Verify the keys and values, and try again.
type InvalidInventoryItemContextException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInventoryItemContextException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInventoryItemContextException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInventoryItemContextException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInventoryItemContextException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInventoryItemContextException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request isn't valid.
type InvalidInventoryRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInventoryRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInventoryRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInventoryRequestException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInventoryRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInventoryRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more content items isn't valid.
type InvalidItemContentException struct {
	Message *string

	ErrorCodeOverride *string

	TypeName *string

	noSmithyDocumentSerde
}

func (e *InvalidItemContentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidItemContentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidItemContentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidItemContentException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidItemContentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The query key ID isn't valid.
type InvalidKeyId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidKeyId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidKeyId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidKeyId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidKeyId"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidKeyId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified token isn't valid.
type InvalidNextToken struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNextToken) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextToken) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextToken) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNextToken"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNextToken) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more configuration items isn't valid. Verify that a valid Amazon
// Resource Name (ARN) was provided for an Amazon Simple Notification Service
// topic.
type InvalidNotificationConfig struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNotificationConfig) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNotificationConfig) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNotificationConfig) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNotificationConfig"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNotificationConfig) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The delete inventory option specified isn't valid. Verify the option and try
// again.
type InvalidOptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOptionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The S3 bucket doesn't exist.
type InvalidOutputFolder struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOutputFolder) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOutputFolder) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOutputFolder) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOutputFolder"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOutputFolder) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The output location isn't valid or doesn't exist.
type InvalidOutputLocation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOutputLocation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOutputLocation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOutputLocation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOutputLocation"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOutputLocation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You must specify values for all required parameters in the Amazon Web Services
// Systems Manager document (SSM document). You can only supply values to
// parameters defined in the SSM document.
type InvalidParameters struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameters) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameters) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameters) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameters"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameters) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The permission type isn't supported. Share is the only supported permission
// type.
type InvalidPermissionType struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPermissionType) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPermissionType) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPermissionType) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPermissionType"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPermissionType) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The plugin name isn't valid.
type InvalidPluginName struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPluginName) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPluginName) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPluginName) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPluginName"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPluginName) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A policy attribute or its value is invalid.
type InvalidPolicyAttributeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPolicyAttributeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPolicyAttributeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPolicyAttributeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPolicyAttributeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPolicyAttributeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The policy type isn't supported. Parameter Store supports the following policy
// types: Expiration, ExpirationNotification, and NoChangeNotification.
type InvalidPolicyTypeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPolicyTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPolicyTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPolicyTypeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPolicyTypeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPolicyTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource ID isn't valid. Verify that you entered the correct ID and try
// again.
type InvalidResourceId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceId) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResourceId"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResourceId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource type isn't valid. For example, if you are attempting to tag an EC2
// instance, the instance must be a registered managed node.
type InvalidResourceType struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceType) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceType) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceType) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResourceType"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResourceType) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified inventory item result attribute isn't valid.
type InvalidResultAttributeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResultAttributeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResultAttributeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResultAttributeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResultAttributeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResultAttributeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The role name can't contain invalid characters. Also verify that you specified
// an IAM role for notifications that includes the required trust policy. For
// information about configuring the IAM role for Run Command notifications, see [Monitoring Systems Manager status changes using Amazon SNS notifications]
// in the Amazon Web Services Systems Manager User Guide.
//
// [Monitoring Systems Manager status changes using Amazon SNS notifications]: https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html
type InvalidRole struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRole) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRole) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRole) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRole"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRole) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The schedule is invalid. Verify your cron or rate expression and try again.
type InvalidSchedule struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSchedule) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSchedule) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSchedule) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSchedule"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSchedule) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified tag key or value isn't valid.
type InvalidTag struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTag) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTag) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTag) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTag"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTag) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target isn't valid or doesn't exist. It might not be configured for Systems
// Manager or you might not have permission to perform the operation.
type InvalidTarget struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTarget) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTarget) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTarget) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTarget"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTarget) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// TargetMap parameter isn't valid.
type InvalidTargetMaps struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetMaps) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetMaps) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetMaps) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTargetMaps"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTargetMaps) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The parameter type name isn't valid.
type InvalidTypeNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTypeNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTypeNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTypeNameException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTypeNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTypeNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The update isn't valid.
type InvalidUpdate struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUpdate) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUpdate) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUpdate) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidUpdate"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUpdate) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The command ID and managed node ID you specified didn't match any invocations.
// Verify the command ID and the managed node ID and try again.
type InvocationDoesNotExist struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvocationDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvocationDoesNotExist) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvocationDoesNotExist) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvocationDoesNotExist"
	}
	return *e.ErrorCodeOverride
}
func (e *InvocationDoesNotExist) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The inventory item has invalid content.
type ItemContentMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	TypeName *string

	noSmithyDocumentSerde
}

func (e *ItemContentMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ItemContentMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ItemContentMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ItemContentMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *ItemContentMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The inventory item size has exceeded the size limit.
type ItemSizeLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	TypeName *string

	noSmithyDocumentSerde
}

func (e *ItemSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ItemSizeLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ItemSizeLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ItemSizeLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ItemSizeLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified policy document is malformed or invalid, or excessive
// PutResourcePolicy or DeleteResourcePolicy calls have been made.
type MalformedResourcePolicyDocumentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MalformedResourcePolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedResourcePolicyDocumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedResourcePolicyDocumentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MalformedResourcePolicyDocumentException"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedResourcePolicyDocumentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The size limit of a document is 64 KB.
type MaxDocumentSizeExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxDocumentSizeExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxDocumentSizeExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxDocumentSizeExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxDocumentSizeExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxDocumentSizeExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation is no longer supported by Systems Manager.
type NoLongerSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoLongerSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoLongerSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoLongerSupportedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoLongerSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoLongerSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You don't have permission to view OpsItems in the specified account. Verify
// that your account is configured either as a Systems Manager delegated
// administrator or that you are logged into the Organizations management account.
type OpsItemAccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsItemAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemAccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemAccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemAccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemAccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The OpsItem already exists.
type OpsItemAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	OpsItemId *string

	noSmithyDocumentSerde
}

func (e *OpsItemAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified OpsItem is in the process of being deleted.
type OpsItemConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsItemConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified parameter argument isn't valid. Verify the available arguments and
// try again.
type OpsItemInvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	ParameterNames []string

	noSmithyDocumentSerde
}

func (e *OpsItemInvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemInvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemInvalidParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemInvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemInvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request caused OpsItems to exceed one or more quotas.
type OpsItemLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceTypes []string
	Limit         int32
	LimitType     *string

	noSmithyDocumentSerde
}

func (e *OpsItemLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified OpsItem ID doesn't exist. Verify the ID and try again.
type OpsItemNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsItemNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon Resource Name (ARN) is already associated with the OpsItem.
type OpsItemRelatedItemAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceUri *string
	OpsItemId   *string

	noSmithyDocumentSerde
}

func (e *OpsItemRelatedItemAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemRelatedItemAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemRelatedItemAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemRelatedItemAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemRelatedItemAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The association wasn't found using the parameters you specified in the call.
// Verify the information and try again.
type OpsItemRelatedItemAssociationNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsItemRelatedItemAssociationNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsItemRelatedItemAssociationNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsItemRelatedItemAssociationNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsItemRelatedItemAssociationNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsItemRelatedItemAssociationNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An OpsMetadata object already exists for the selected resource.
type OpsMetadataAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsMetadataAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsMetadataAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsMetadataAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsMetadataAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsMetadataAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One of the arguments passed is invalid.
type OpsMetadataInvalidArgumentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsMetadataInvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsMetadataInvalidArgumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsMetadataInvalidArgumentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsMetadataInvalidArgumentException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsMetadataInvalidArgumentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The OpsMetadata object exceeds the maximum number of OpsMetadata keys that you
// can assign to an application in Application Manager.
type OpsMetadataKeyLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsMetadataKeyLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsMetadataKeyLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsMetadataKeyLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsMetadataKeyLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsMetadataKeyLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Your account reached the maximum number of OpsMetadata objects allowed by
// Application Manager. The maximum is 200 OpsMetadata objects. Delete one or more
// OpsMetadata object and try again.
type OpsMetadataLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsMetadataLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsMetadataLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsMetadataLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsMetadataLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsMetadataLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The OpsMetadata object doesn't exist.
type OpsMetadataNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsMetadataNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsMetadataNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsMetadataNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsMetadataNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsMetadataNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The system is processing too many concurrent updates. Wait a few moments and
// try again.
type OpsMetadataTooManyUpdatesException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OpsMetadataTooManyUpdatesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OpsMetadataTooManyUpdatesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OpsMetadataTooManyUpdatesException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OpsMetadataTooManyUpdatesException"
	}
	return *e.ErrorCodeOverride
}
func (e *OpsMetadataTooManyUpdatesException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The parameter already exists. You can't create duplicate parameters.
type ParameterAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the number of parameters for this Amazon Web Services
// account. Delete one or more parameters and try again.
type ParameterLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Parameter Store retains the 100 most recently created versions of a parameter.
// After this number of versions has been created, Parameter Store deletes the
// oldest version when a new one is created. However, if the oldest version has a
// label attached to it, Parameter Store won't delete the version and instead
// presents this error message:
//
//	An error occurred (ParameterMaxVersionLimitExceeded) when calling the
//	PutParameter operation: You attempted to create a new version of parameter-name
//	by calling the PutParameter API with the overwrite flag. Version version-number,
//	the oldest version, can't be deleted because it has a label associated with it.
//	Move the label to another version of the parameter, and try again.
//
// This safeguard is to prevent parameter versions with mission critical labels
// assigned to them from being deleted. To continue creating new parameters, first
// move the label from the oldest version of the parameter to a newer one for use
// in your operations. For information about moving parameter labels, see [Move a parameter label (console)]or [Move a parameter label (CLI)] in
// the Amazon Web Services Systems Manager User Guide.
//
// [Move a parameter label (CLI)]: https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move
// [Move a parameter label (console)]: https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move
type ParameterMaxVersionLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterMaxVersionLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterMaxVersionLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterMaxVersionLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterMaxVersionLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterMaxVersionLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The parameter couldn't be found. Verify the name and try again.
//
// For the DeleteParameter and GetParameter actions, if the specified parameter
// doesn't exist, the ParameterNotFound exception is not recorded in CloudTrail
// event logs.
type ParameterNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The parameter name isn't valid.
type ParameterPatternMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterPatternMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterPatternMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterPatternMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterPatternMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterPatternMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A parameter version can have a maximum of ten labels.
type ParameterVersionLabelLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterVersionLabelLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterVersionLabelLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterVersionLabelLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterVersionLabelLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterVersionLabelLimitExceeded) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified parameter version wasn't found. Verify the parameter name and
// version, and try again.
type ParameterVersionNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParameterVersionNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParameterVersionNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParameterVersionNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParameterVersionNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ParameterVersionNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You specified more than the maximum number of allowed policies for the
// parameter. The maximum is 10.
type PoliciesLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PoliciesLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PoliciesLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PoliciesLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PoliciesLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *PoliciesLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A sync configuration with the same name already exists.
type ResourceDataSyncAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	SyncName *string

	noSmithyDocumentSerde
}

func (e *ResourceDataSyncAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceDataSyncAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceDataSyncAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceDataSyncAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceDataSyncAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Another UpdateResourceDataSync request is being processed. Wait a few minutes
// and try again.
type ResourceDataSyncConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceDataSyncConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceDataSyncConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceDataSyncConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceDataSyncConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceDataSyncConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the allowed maximum sync configurations.
type ResourceDataSyncCountExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceDataSyncCountExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceDataSyncCountExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceDataSyncCountExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceDataSyncCountExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceDataSyncCountExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified sync configuration is invalid.
type ResourceDataSyncInvalidConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceDataSyncInvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceDataSyncInvalidConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceDataSyncInvalidConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceDataSyncInvalidConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceDataSyncInvalidConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified sync name wasn't found.
type ResourceDataSyncNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	SyncName *string
	SyncType *string

	noSmithyDocumentSerde
}

func (e *ResourceDataSyncNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceDataSyncNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceDataSyncNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceDataSyncNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceDataSyncNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error returned if an attempt is made to delete a patch baseline that is
// registered for a patch group.
type ResourceInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error returned when the caller has exceeded the default resource quotas. For
// example, too many maintenance windows or patch baselines have been created.
//
// For information about resource quotas in Systems Manager, see [Systems Manager service quotas] in the Amazon
// Web Services General Reference.
//
// [Systems Manager service quotas]: https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm
type ResourceLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified parameter to be shared could not be found.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The hash provided in the call doesn't match the stored hash. This exception is
// thrown when trying to update an obsolete policy version or when multiple
// requests to update a policy are sent.
type ResourcePolicyConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourcePolicyConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more parameters specified for the call aren't valid. Verify the
// parameters and their values and try again.
type ResourcePolicyInvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	ParameterNames []string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyInvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyInvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyInvalidParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourcePolicyInvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyInvalidParameterException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The PutResourcePolicy API action enforces two limits. A policy can't be greater than 1024 bytes
// in size. And only one policy can be attached to OpsItemGroup . Verify these
// limits and try again.
type ResourcePolicyLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	Limit     int32
	LimitType *string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourcePolicyLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// No policies with the specified policy ID and hash could be found.
type ResourcePolicyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourcePolicyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request exceeds the service quota. Service quotas, also referred to as
// limits, are the maximum number of service resources or operations for your
// Amazon Web Services account.
type ServiceQuotaExceededException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceId   *string
	ResourceType *string
	QuotaCode    *string
	ServiceCode  *string

	noSmithyDocumentSerde
}

func (e *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceQuotaExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceQuotaExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceQuotaExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceQuotaExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified service setting wasn't found. Either the service name or the
// setting hasn't been provisioned by the Amazon Web Services service team.
type ServiceSettingNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceSettingNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceSettingNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceSettingNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceSettingNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceSettingNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The updated status is the same as the current status.
type StatusUnchanged struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StatusUnchanged) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StatusUnchanged) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StatusUnchanged) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StatusUnchanged"
	}
	return *e.ErrorCodeOverride
}
func (e *StatusUnchanged) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The sub-type count exceeded the limit for the inventory type.
type SubTypeCountLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubTypeCountLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubTypeCountLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubTypeCountLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubTypeCountLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *SubTypeCountLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You specified the Safe option for the DeregisterTargetFromMaintenanceWindow
// operation, but the target is still referenced in a task.
type TargetInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TargetInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TargetInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TargetInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TargetInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *TargetInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified target managed node for the session isn't fully configured for
// use with Session Manager. For more information, see [Setting up Session Manager]in the Amazon Web Services
// Systems Manager User Guide. This error is also returned if you attempt to start
// a session on a managed node that is located in a different account or Region
//
// [Setting up Session Manager]: https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html
type TargetNotConnected struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TargetNotConnected) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TargetNotConnected) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TargetNotConnected) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TargetNotConnected"
	}
	return *e.ErrorCodeOverride
}
func (e *TargetNotConnected) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request or operation couldn't be performed because the service is
// throttling requests.
type ThrottlingException struct {
	Message *string

	ErrorCodeOverride *string

	QuotaCode   *string
	ServiceCode *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottlingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Targets parameter includes too many tags. Remove one or more tags and try
// the command again.
type TooManyTagsError struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsError) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsError"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsError) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There are concurrent updates for a resource that supports one update at a time.
type TooManyUpdates struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyUpdates) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyUpdates) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyUpdates) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyUpdates"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyUpdates) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The size of inventory data has exceeded the total size limit for the resource.
type TotalSizeLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TotalSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TotalSizeLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TotalSizeLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TotalSizeLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *TotalSizeLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The calendar entry contained in the specified SSM document isn't supported.
type UnsupportedCalendarException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedCalendarException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedCalendarException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedCalendarException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedCalendarException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedCalendarException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Patching for applications released by Microsoft is only available on EC2
// instances and advanced instances. To patch applications released by Microsoft on
// on-premises servers and VMs, you must enable advanced instances. For more
// information, see [Turning on the advanced-instances tier]in the Amazon Web Services Systems Manager User Guide.
//
// [Turning on the advanced-instances tier]: https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html
type UnsupportedFeatureRequiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedFeatureRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedFeatureRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedFeatureRequiredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedFeatureRequiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedFeatureRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Context attribute that you specified for the InventoryItem isn't allowed
// for this inventory type. You can only use the Context attribute with inventory
// types like AWS:ComplianceItem .
type UnsupportedInventoryItemContextException struct {
	Message *string

	ErrorCodeOverride *string

	TypeName *string

	noSmithyDocumentSerde
}

func (e *UnsupportedInventoryItemContextException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedInventoryItemContextException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedInventoryItemContextException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedInventoryItemContextException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedInventoryItemContextException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Inventory item type schema version has to match supported versions in the
// service. Check output of GetInventorySchema to see the available schema version
// for each type.
type UnsupportedInventorySchemaVersionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedInventorySchemaVersionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedInventorySchemaVersionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedInventorySchemaVersionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedInventorySchemaVersionException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedInventorySchemaVersionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The operating systems you specified isn't supported, or the operation isn't
// supported for the operating system.
type UnsupportedOperatingSystem struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperatingSystem) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperatingSystem) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperatingSystem) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOperatingSystem"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperatingSystem) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This operation is not supported for the current account. You must first enable
// the Systems Manager integrated experience in your account.
type UnsupportedOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The parameter type isn't supported.
type UnsupportedParameterType struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedParameterType) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedParameterType) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedParameterType) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedParameterType"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedParameterType) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The document doesn't support the platform type of the given managed node IDs.
// For example, you sent an document for a Windows managed node to a Linux node.
type UnsupportedPlatformType struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedPlatformType) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedPlatformType) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedPlatformType) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedPlatformType"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedPlatformType) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request isn't valid. Verify that you entered valid contents for the command
// and try again.
type ValidationException struct {
	Message *string

	ErrorCodeOverride *string

	ReasonCode *string

	noSmithyDocumentSerde
}

func (e *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
