/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM RedirectBlockedEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "RedirectBlockedEvent.h"
#include "RedirectBlockedEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RedirectBlockedEvent.h"
#include "nsGlobalWindowInner.h"
#include "nsIURI.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(RedirectBlockedEvent)

NS_IMPL_ADDREF_INHERITED(RedirectBlockedEvent, Event)
NS_IMPL_RELEASE_INHERITED(RedirectBlockedEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(RedirectBlockedEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mRequestingWindow)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mRedirectURI)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(RedirectBlockedEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(RedirectBlockedEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mRequestingWindow)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mRedirectURI)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(RedirectBlockedEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

RedirectBlockedEvent::RedirectBlockedEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

RedirectBlockedEvent::~RedirectBlockedEvent()
{
}

RedirectBlockedEvent*
RedirectBlockedEvent::AsRedirectBlockedEvent()
{
  return this;
}

JSObject*
RedirectBlockedEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return RedirectBlockedEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<RedirectBlockedEvent>
RedirectBlockedEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const RedirectBlockedEventInit& aEventInitDict)
{
  RefPtr<RedirectBlockedEvent> e = new RedirectBlockedEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mRequestingWindow = aEventInitDict.mRequestingWindow;
  e->mRedirectURI = aEventInitDict.mRedirectURI;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<RedirectBlockedEvent>
RedirectBlockedEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const RedirectBlockedEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

nsGlobalWindowInner*
RedirectBlockedEvent::GetRequestingWindow() const
{
  return mRequestingWindow;
}

nsIURI*
RedirectBlockedEvent::GetRedirectURI() const
{
  return mRedirectURI;
}


} // namespace mozilla::dom
