//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PVsyncChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/VsyncChild.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/PBrowserChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PVsyncChild::PVsyncChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PVsyncChild);
}

PVsyncChild::~PVsyncChild()
{
    MOZ_COUNT_DTOR(PVsyncChild);
}

auto PVsyncChild::ActorAlloc() -> void
{
    AddRef();
}

auto PVsyncChild::ActorDealloc() -> void
{
    Release();
}

auto PVsyncChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PVsyncChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PVsyncChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PVsyncChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PVsyncChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PVsyncChild::SendObserve() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVsync::Msg_Observe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVsync", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVsyncChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVsync::Msg_Observe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVsyncChild::SendUnobserve() -> bool
{
    UniquePtr<IPC::Message> msg__ = PVsync::Msg_Unobserve(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PVsync", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVsyncChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVsync::Msg_Unobserve", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PVsyncChild::Send__delete__(PVsyncChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PVsync::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PVsync", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PVsyncChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PVsync::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PVsyncChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PVsyncChild::OnMessageReceived(const Message& msg__) -> PVsyncChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PVsync::Msg_Notify__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PVsync", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PVsyncChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PVsync::Msg_Notify", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aVsync = IPC::ReadParam<VsyncEvent>((&(reader__)));
            if (!maybe__aVsync) {
                FatalError("Error deserializing 'VsyncEvent'");
                return MsgValueError;

            }
            auto& aVsync = *maybe__aVsync;
            // Sentinel = 'aVsync'
            if ((!(((&(reader__)))->ReadSentinel(141558389)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VsyncEvent'");
                return MsgValueError;
            }
            auto maybe__aVsyncRate = IPC::ReadParam<float>((&(reader__)));
            if (!maybe__aVsyncRate) {
                FatalError("Error deserializing 'float'");
                return MsgValueError;

            }
            auto& aVsyncRate = *maybe__aVsyncRate;
            // Sentinel = 'aVsyncRate'
            if ((!(((&(reader__)))->ReadSentinel(368837633)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'float'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<VsyncChild*>(this))->RecvNotify(std::move(aVsync), std::move(aVsyncRate));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PVsync::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PVsyncChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PVsyncChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PVsyncChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PVsync'
    (aWriter)->WriteSentinel(134873700);
}

auto ParamTraits<::mozilla::dom::PVsyncChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PVsync actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PVsync'
    if ((!((aReader)->ReadSentinel(134873700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PVsync actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PVsyncMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PVsync)");

        return {};
    }
    return static_cast<::mozilla::dom::PVsyncChild*>(actor);
}

} // namespace IPC
