
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in BezierSurfacePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of BezierSurfacePy
PyTypeObject BezierSurfacePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.BezierSurface",     /*tp_name*/
    sizeof(BezierSurfacePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Describes a rational or non-rational Bezier surface\n"
    "                -- A non-rational Bezier surface is defined by a table of poles (also known as control points).\n"
    "                -- A rational Bezier surface is defined by a table of poles with varying associated weights.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::BezierSurfacePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::BezierSurfacePy::GetterSetter,                     /*tp_getset */
    &Part::GeometrySurfacePy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::BezierSurfacePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of BezierSurfacePy
PyMethodDef BezierSurfacePy::Methods[] = {
    {"bounds",
        reinterpret_cast<PyCFunction>( staticCallback_bounds ),
        METH_VARARGS,
        "Returns the parametric bounds (U1, U2, V1, V2) of this Bezier surface."
    },
    {"isURational",
        reinterpret_cast<PyCFunction>( staticCallback_isURational ),
        METH_VARARGS,
        "Returns false if the equation of this Bezier surface is polynomial\n"
        "                    (e.g. non-rational) in the u or v parametric direction.\n"
        "                    In other words, returns false if for each row of poles, the associated\n"
        "                    weights are identical"
    },
    {"isVRational",
        reinterpret_cast<PyCFunction>( staticCallback_isVRational ),
        METH_VARARGS,
        "Returns false if the equation of this Bezier surface is polynomial\n"
        "                    (e.g. non-rational) in the u or v parametric direction.\n"
        "                    In other words, returns false if for each column of poles, the associated\n"
        "                    weights are identical"
    },
    {"isUPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_isUPeriodic ),
        METH_VARARGS,
        "Returns false."
    },
    {"isVPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_isVPeriodic ),
        METH_VARARGS,
        "Returns false."
    },
    {"isUClosed",
        reinterpret_cast<PyCFunction>( staticCallback_isUClosed ),
        METH_VARARGS,
        "Checks if this surface is closed in the u parametric direction.\n"
        "                    Returns true if, in the table of poles the first row and the last\n"
        "                    row are identical."
    },
    {"isVClosed",
        reinterpret_cast<PyCFunction>( staticCallback_isVClosed ),
        METH_VARARGS,
        "Checks if this surface is closed in the v parametric direction.\n"
        "                    Returns true if, in the table of poles the first column and the\n"
        "                    last column are identical."
    },
    {"increase",
        reinterpret_cast<PyCFunction>( staticCallback_increase ),
        METH_VARARGS,
        "increase(Int=DegreeU,Int=DegreeV)\n"
        "                    Increases the degree of this Bezier surface in the two\n"
        "                    parametric directions."
    },
    {"insertPoleColAfter",
        reinterpret_cast<PyCFunction>( staticCallback_insertPoleColAfter ),
        METH_VARARGS,
        "Inserts into the table of poles of this surface, after the column\n"
        "                    of poles of index.\n"
        "                    If this Bezier surface is non-rational, it can become rational if\n"
        "                    the weights associated with the new poles are different from each\n"
        "                    other, or collectively different from the existing weights in the\n"
        "                    table."
    },
    {"insertPoleRowAfter",
        reinterpret_cast<PyCFunction>( staticCallback_insertPoleRowAfter ),
        METH_VARARGS,
        "Inserts into the table of poles of this surface, after the row\n"
        "                    of poles of index.\n"
        "                    If this Bezier surface is non-rational, it can become rational if\n"
        "                    the weights associated with the new poles are different from each\n"
        "                    other, or collectively different from the existing weights in the\n"
        "                    table."
    },
    {"insertPoleColBefore",
        reinterpret_cast<PyCFunction>( staticCallback_insertPoleColBefore ),
        METH_VARARGS,
        "Inserts into the table of poles of this surface, before the column\n"
        "                    of poles of index.\n"
        "                    If this Bezier surface is non-rational, it can become rational if\n"
        "                    the weights associated with the new poles are different from each\n"
        "                    other, or collectively different from the existing weights in the\n"
        "                    table."
    },
    {"insertPoleRowBefore",
        reinterpret_cast<PyCFunction>( staticCallback_insertPoleRowBefore ),
        METH_VARARGS,
        "Inserts into the table of poles of this surface, before the row\n"
        "                    of poles of index.\n"
        "                    If this Bezier surface is non-rational, it can become rational if\n"
        "                    the weights associated with the new poles are different from each\n"
        "                    other, or collectively different from the existing weights in the\n"
        "                    table."
    },
    {"removePoleCol",
        reinterpret_cast<PyCFunction>( staticCallback_removePoleCol ),
        METH_VARARGS,
        "removePoleRow(int=VIndex)\n"
        "                    Removes the column of poles of index VIndex from the table of\n"
        "                    poles of this Bezier surface.\n"
        "                    If this Bezier curve is rational, it can become non-rational."
    },
    {"removePoleRow",
        reinterpret_cast<PyCFunction>( staticCallback_removePoleRow ),
        METH_VARARGS,
        "removePoleRow(int=UIndex)\n"
        "                    Removes the row of poles of index UIndex from the table of\n"
        "                    poles of this Bezier surface.\n"
        "                    If this Bezier curve is rational, it can become non-rational."
    },
    {"segment",
        reinterpret_cast<PyCFunction>( staticCallback_segment ),
        METH_VARARGS,
        "segment(double=U1,double=U2,double=V1,double=V2)\n"
        "                    Modifies this Bezier surface by segmenting it between U1 and U2\n"
        "                    in the u parametric direction, and between V1 and V2 in the v\n"
        "                    parametric direction.\n"
        "                    U1, U2, V1, and V2 can be outside the bounds of this surface.\n"
        "\n"
        "                    -- U1 and U2 isoparametric Bezier curves, segmented between\n"
        "                       V1 and V2, become the two bounds of the surface in the v\n"
        "                       parametric direction (0. and 1. u isoparametric curves).\n"
        "                    -- V1 and V2 isoparametric Bezier curves, segmented between\n"
        "                       U1 and U2, become the two bounds of the surface in the u\n"
        "                       parametric direction (0. and 1. v isoparametric curves).\n"
        "\n"
        "                    The poles and weights tables are modified, but the degree of\n"
        "                    this surface in the u and v parametric directions does not\n"
        "                    change.U1 can be greater than U2, and V1 can be greater than V2.\n"
        "                    In these cases, the corresponding parametric direction is inverted.\n"
        "                    The orientation of the surface is inverted if one (and only one)\n"
        "                    parametric direction is inverted."
    },
    {"setPole",
        reinterpret_cast<PyCFunction>( staticCallback_setPole ),
        METH_VARARGS,
        "Set a pole of the Bezier surface."
    },
    {"setPoleCol",
        reinterpret_cast<PyCFunction>( staticCallback_setPoleCol ),
        METH_VARARGS,
        "Set the column of poles of the Bezier surface."
    },
    {"setPoleRow",
        reinterpret_cast<PyCFunction>( staticCallback_setPoleRow ),
        METH_VARARGS,
        "Set the row of poles of the Bezier surface."
    },
    {"getPole",
        reinterpret_cast<PyCFunction>( staticCallback_getPole ),
        METH_VARARGS,
        "Get a pole of index (UIndex,VIndex) of the Bezier surface."
    },
    {"getPoles",
        reinterpret_cast<PyCFunction>( staticCallback_getPoles ),
        METH_VARARGS,
        "Get all poles of the Bezier surface."
    },
    {"setWeight",
        reinterpret_cast<PyCFunction>( staticCallback_setWeight ),
        METH_VARARGS,
        "Set the weight of pole of the index (UIndex, VIndex)\n"
        "                    for the Bezier surface."
    },
    {"setWeightCol",
        reinterpret_cast<PyCFunction>( staticCallback_setWeightCol ),
        METH_VARARGS,
        "Set the weights of the poles in the column of poles\n"
        "                    of index VIndex of the Bezier surface."
    },
    {"setWeightRow",
        reinterpret_cast<PyCFunction>( staticCallback_setWeightRow ),
        METH_VARARGS,
        "Set the weights of the poles in the row of poles\n"
        "                    of index UIndex of the Bezier surface."
    },
    {"getWeight",
        reinterpret_cast<PyCFunction>( staticCallback_getWeight ),
        METH_VARARGS,
        "Get a weight of the pole of index (UIndex,VIndex)\n"
        "                    of the Bezier surface."
    },
    {"getWeights",
        reinterpret_cast<PyCFunction>( staticCallback_getWeights ),
        METH_VARARGS,
        "Get all weights of the Bezier surface."
    },
    {"getResolution",
        reinterpret_cast<PyCFunction>( staticCallback_getResolution ),
        METH_VARARGS,
        "Computes two tolerance values for this Bezier surface, based on the\n"
        "                    given tolerance in 3D space Tolerance3D. The tolerances computed are:\n"
        "                    -- UTolerance in the u parametric direction and\n"
        "                    -- VTolerance in the v parametric direction.\n"
        "\n"
        "                    If f(u,v) is the equation of this Bezier surface, UTolerance and VTolerance\n"
        "                    guarantee that:\n"
        "                    |u1 - u0| < UTolerance\n"
        "                    |v1 - v0| < VTolerance\n"
        "                    ====> ||f(u1, v1) - f(u2, v2)|| < Tolerance3D"
    },
    {"exchangeUV",
        reinterpret_cast<PyCFunction>( staticCallback_exchangeUV ),
        METH_VARARGS,
        "Exchanges the u and v parametric directions on this Bezier surface.\n"
        "                    As a consequence:\n"
        "                    -- the poles and weights tables are transposed,\n"
        "                    -- degrees, rational characteristics and so on are exchanged between\n"
        "                       the two parametric directions, and\n"
        "                    -- the orientation of the surface is reversed."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of BezierSurfacePy
PyGetSetDef BezierSurfacePy::GetterSetter[] = {
    {"UDegree",
        (getter) staticCallback_getUDegree,
        (setter) staticCallback_setUDegree,
        "Returns the polynomial degree in u direction of this Bezier surface,\n"
        "                    which is equal to the number of poles minus 1.",
        nullptr
    },
    {"VDegree",
        (getter) staticCallback_getVDegree,
        (setter) staticCallback_setVDegree,
        "Returns the polynomial degree in v direction of this Bezier surface,\n"
        "                    which is equal to the number of poles minus 1.",
        nullptr
    },
    {"MaxDegree",
        (getter) staticCallback_getMaxDegree,
        (setter) staticCallback_setMaxDegree,
        "Returns the value of the maximum polynomial degree of any\n"
        "                    Bezier surface. This value is 25.",
        nullptr
    },
    {"NbUPoles",
        (getter) staticCallback_getNbUPoles,
        (setter) staticCallback_setNbUPoles,
        "Returns the number of poles in u direction of this Bezier surface.",
        nullptr
    },
    {"NbVPoles",
        (getter) staticCallback_getNbVPoles,
        (setter) staticCallback_setNbVPoles,
        "Returns the number of poles in v direction of this Bezier surface.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// bounds() callback and implementer
// PyObject*  BezierSurfacePy::bounds(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_bounds (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'bounds' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->bounds(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isURational() callback and implementer
// PyObject*  BezierSurfacePy::isURational(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_isURational (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isURational' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->isURational(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isVRational() callback and implementer
// PyObject*  BezierSurfacePy::isVRational(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_isVRational (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isVRational' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->isVRational(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isUPeriodic() callback and implementer
// PyObject*  BezierSurfacePy::isUPeriodic(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_isUPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isUPeriodic' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->isUPeriodic(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isVPeriodic() callback and implementer
// PyObject*  BezierSurfacePy::isVPeriodic(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_isVPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isVPeriodic' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->isVPeriodic(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isUClosed() callback and implementer
// PyObject*  BezierSurfacePy::isUClosed(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_isUClosed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isUClosed' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->isUClosed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isVClosed() callback and implementer
// PyObject*  BezierSurfacePy::isVClosed(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_isVClosed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isVClosed' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->isVClosed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// increase() callback and implementer
// PyObject*  BezierSurfacePy::increase(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_increase (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'increase' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->increase(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertPoleColAfter() callback and implementer
// PyObject*  BezierSurfacePy::insertPoleColAfter(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_insertPoleColAfter (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertPoleColAfter' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->insertPoleColAfter(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertPoleRowAfter() callback and implementer
// PyObject*  BezierSurfacePy::insertPoleRowAfter(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_insertPoleRowAfter (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertPoleRowAfter' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->insertPoleRowAfter(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertPoleColBefore() callback and implementer
// PyObject*  BezierSurfacePy::insertPoleColBefore(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_insertPoleColBefore (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertPoleColBefore' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->insertPoleColBefore(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertPoleRowBefore() callback and implementer
// PyObject*  BezierSurfacePy::insertPoleRowBefore(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_insertPoleRowBefore (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertPoleRowBefore' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->insertPoleRowBefore(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removePoleCol() callback and implementer
// PyObject*  BezierSurfacePy::removePoleCol(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_removePoleCol (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removePoleCol' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->removePoleCol(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removePoleRow() callback and implementer
// PyObject*  BezierSurfacePy::removePoleRow(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_removePoleRow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removePoleRow' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->removePoleRow(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// segment() callback and implementer
// PyObject*  BezierSurfacePy::segment(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_segment (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'segment' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->segment(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPole() callback and implementer
// PyObject*  BezierSurfacePy::setPole(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_setPole (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPole' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->setPole(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPoleCol() callback and implementer
// PyObject*  BezierSurfacePy::setPoleCol(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_setPoleCol (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPoleCol' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->setPoleCol(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPoleRow() callback and implementer
// PyObject*  BezierSurfacePy::setPoleRow(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_setPoleRow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPoleRow' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->setPoleRow(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPole() callback and implementer
// PyObject*  BezierSurfacePy::getPole(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getPole (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPole' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->getPole(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPoles() callback and implementer
// PyObject*  BezierSurfacePy::getPoles(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getPoles (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPoles' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->getPoles(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setWeight() callback and implementer
// PyObject*  BezierSurfacePy::setWeight(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_setWeight (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setWeight' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->setWeight(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setWeightCol() callback and implementer
// PyObject*  BezierSurfacePy::setWeightCol(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_setWeightCol (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setWeightCol' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->setWeightCol(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setWeightRow() callback and implementer
// PyObject*  BezierSurfacePy::setWeightRow(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_setWeightRow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setWeightRow' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->setWeightRow(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getWeight() callback and implementer
// PyObject*  BezierSurfacePy::getWeight(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getWeight (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getWeight' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->getWeight(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getWeights() callback and implementer
// PyObject*  BezierSurfacePy::getWeights(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getWeights (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getWeights' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->getWeights(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getResolution() callback and implementer
// PyObject*  BezierSurfacePy::getResolution(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getResolution (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getResolution' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->getResolution(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exchangeUV() callback and implementer
// PyObject*  BezierSurfacePy::exchangeUV(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_exchangeUV (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exchangeUV' of 'Part.GeomBezierSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BezierSurfacePy*>(self)->exchangeUV(args);
        if (ret != nullptr)
            static_cast<BezierSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// UDegree() callback and implementer
// PyObject*  BezierSurfacePy::UDegree(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getUDegree (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BezierSurfacePy*>(self)->getUDegree());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UDegree' of object 'GeomBezierSurface'");
        return nullptr;
    }
}

int BezierSurfacePy::staticCallback_setUDegree (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UDegree' of object 'GeomBezierSurface' is read-only");
    return -1;
}

// VDegree() callback and implementer
// PyObject*  BezierSurfacePy::VDegree(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getVDegree (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BezierSurfacePy*>(self)->getVDegree());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'VDegree' of object 'GeomBezierSurface'");
        return nullptr;
    }
}

int BezierSurfacePy::staticCallback_setVDegree (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'VDegree' of object 'GeomBezierSurface' is read-only");
    return -1;
}

// MaxDegree() callback and implementer
// PyObject*  BezierSurfacePy::MaxDegree(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getMaxDegree (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BezierSurfacePy*>(self)->getMaxDegree());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MaxDegree' of object 'GeomBezierSurface'");
        return nullptr;
    }
}

int BezierSurfacePy::staticCallback_setMaxDegree (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MaxDegree' of object 'GeomBezierSurface' is read-only");
    return -1;
}

// NbUPoles() callback and implementer
// PyObject*  BezierSurfacePy::NbUPoles(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getNbUPoles (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BezierSurfacePy*>(self)->getNbUPoles());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbUPoles' of object 'GeomBezierSurface'");
        return nullptr;
    }
}

int BezierSurfacePy::staticCallback_setNbUPoles (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NbUPoles' of object 'GeomBezierSurface' is read-only");
    return -1;
}

// NbVPoles() callback and implementer
// PyObject*  BezierSurfacePy::NbVPoles(PyObject *args){};
// has to be implemented in BezierSurfacePyImp.cpp
PyObject * BezierSurfacePy::staticCallback_getNbVPoles (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BezierSurfacePy*>(self)->getNbVPoles());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbVPoles' of object 'GeomBezierSurface'");
        return nullptr;
    }
}

int BezierSurfacePy::staticCallback_setNbVPoles (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NbVPoles' of object 'GeomBezierSurface' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
BezierSurfacePy::BezierSurfacePy(GeomBezierSurface *pcObject, PyTypeObject *T)
    : GeometrySurfacePy(static_cast<GeometrySurfacePy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
BezierSurfacePy::~BezierSurfacePy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// BezierSurfacePy representation
//--------------------------------------------------------------------------
PyObject *BezierSurfacePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// BezierSurfacePy Attributes
//--------------------------------------------------------------------------
PyObject *BezierSurfacePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return GeometrySurfacePy::_getattr(attr);
}

int BezierSurfacePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return GeometrySurfacePy::_setattr(attr, value);
}

GeomBezierSurface *BezierSurfacePy::getGeomBezierSurfacePtr() const
{
    return static_cast<GeomBezierSurface *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in BezierSurfacePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *BezierSurfacePy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of BezierSurfacePy and the Twin object
    return new BezierSurfacePy(new GeomBezierSurface);
}

// constructor method
int BezierSurfacePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string BezierSurfacePy::representation() const
{
    return {"<GeomBezierSurface object>"};
}

PyObject* BezierSurfacePy::bounds(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::isURational(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::isVRational(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::isUPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::isVPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::isUClosed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::isVClosed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::increase(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::insertPoleColAfter(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::insertPoleRowAfter(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::insertPoleColBefore(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::insertPoleRowBefore(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::removePoleCol(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::removePoleRow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::segment(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::setPole(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::setPoleCol(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::setPoleRow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::getPole(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::getPoles(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::setWeight(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::setWeightCol(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::setWeightRow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::getWeight(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::getWeights(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::getResolution(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BezierSurfacePy::exchangeUV(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Long BezierSurfacePy::getUDegree() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BezierSurfacePy::getVDegree() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BezierSurfacePy::getMaxDegree() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BezierSurfacePy::getNbUPoles() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BezierSurfacePy::getNbVPoles() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *BezierSurfacePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int BezierSurfacePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



