
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in VoronoiEdgePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Path;

/// Type structure of VoronoiEdgePy
PyTypeObject VoronoiEdgePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Path.Voronoi.Edge",     /*tp_name*/
    sizeof(VoronoiEdgePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Edge of a Voronoi diagram",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    Path::VoronoiEdgePy::richCompare,      /*tp_richcompare*/
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Path::VoronoiEdgePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Path::VoronoiEdgePy::GetterSetter,                     /*tp_getset */
    &Base::BaseClassPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Path::VoronoiEdgePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of VoronoiEdgePy
PyMethodDef VoronoiEdgePy::Methods[] = {
    {"isFinite",
        reinterpret_cast<PyCFunction>( staticCallback_isFinite ),
        METH_VARARGS,
        "Returns true if both vertices are finite"
    },
    {"isInfinite",
        reinterpret_cast<PyCFunction>( staticCallback_isInfinite ),
        METH_VARARGS,
        "Returns true if the end vertex is infinite"
    },
    {"isLinear",
        reinterpret_cast<PyCFunction>( staticCallback_isLinear ),
        METH_VARARGS,
        "Returns true if edge is straight"
    },
    {"isCurved",
        reinterpret_cast<PyCFunction>( staticCallback_isCurved ),
        METH_VARARGS,
        "Returns true if edge is curved"
    },
    {"isPrimary",
        reinterpret_cast<PyCFunction>( staticCallback_isPrimary ),
        METH_VARARGS,
        "Returns false if edge goes through endpoint of the segment site"
    },
    {"isSecondary",
        reinterpret_cast<PyCFunction>( staticCallback_isSecondary ),
        METH_VARARGS,
        "Returns true if edge goes through endpoint of the segment site"
    },
    {"isBorderline",
        reinterpret_cast<PyCFunction>( staticCallback_isBorderline ),
        METH_VARARGS,
        "Returns true if the point is on the segment"
    },
    {"toShape",
        reinterpret_cast<PyCFunction>( staticCallback_toShape ),
        METH_VARARGS,
        "Returns a shape for the edge"
    },
    {"getDistances",
        reinterpret_cast<PyCFunction>( staticCallback_getDistances ),
        METH_VARARGS,
        "Returns the distance of the vertices to the input source"
    },
    {"getSegmentAngle",
        reinterpret_cast<PyCFunction>( staticCallback_getSegmentAngle ),
        METH_VARARGS,
        "Returns the angle (in degree) of the segments if the edge was formed by two segments"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of VoronoiEdgePy
PyGetSetDef VoronoiEdgePy::GetterSetter[] = {
    {"Index",
        (getter) staticCallback_getIndex,
        (setter) staticCallback_setIndex,
        "Internal id of the element.",
        nullptr
    },
    {"Color",
        (getter) staticCallback_getColor,
        (setter) staticCallback_setColor,
        "Assigned color of the receiver.",
        nullptr
    },
    {"Cell",
        (getter) staticCallback_getCell,
        (setter) staticCallback_setCell,
        "cell the edge belongs to",
        nullptr
    },
    {"Vertices",
        (getter) staticCallback_getVertices,
        (setter) staticCallback_setVertices,
        "Begin and End voronoi vertex",
        nullptr
    },
    {"Next",
        (getter) staticCallback_getNext,
        (setter) staticCallback_setNext,
        "CCW next edge within voronoi cell",
        nullptr
    },
    {"Prev",
        (getter) staticCallback_getPrev,
        (setter) staticCallback_setPrev,
        "CCW previous edge within voronoi cell",
        nullptr
    },
    {"RotNext",
        (getter) staticCallback_getRotNext,
        (setter) staticCallback_setRotNext,
        "Rotated CCW next edge within voronoi cell",
        nullptr
    },
    {"RotPrev",
        (getter) staticCallback_getRotPrev,
        (setter) staticCallback_setRotPrev,
        "Rotated CCW previous edge within voronoi cell",
        nullptr
    },
    {"Twin",
        (getter) staticCallback_getTwin,
        (setter) staticCallback_setTwin,
        "Twin edge",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// isFinite() callback and implementer
// PyObject*  VoronoiEdgePy::isFinite(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isFinite (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isFinite' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isFinite(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isInfinite() callback and implementer
// PyObject*  VoronoiEdgePy::isInfinite(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isInfinite (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isInfinite' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isInfinite(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isLinear() callback and implementer
// PyObject*  VoronoiEdgePy::isLinear(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isLinear (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isLinear' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isLinear(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isCurved() callback and implementer
// PyObject*  VoronoiEdgePy::isCurved(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isCurved (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isCurved' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isCurved(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isPrimary() callback and implementer
// PyObject*  VoronoiEdgePy::isPrimary(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isPrimary (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isPrimary' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isPrimary(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isSecondary() callback and implementer
// PyObject*  VoronoiEdgePy::isSecondary(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isSecondary (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isSecondary' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isSecondary(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isBorderline() callback and implementer
// PyObject*  VoronoiEdgePy::isBorderline(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_isBorderline (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isBorderline' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->isBorderline(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toShape() callback and implementer
// PyObject*  VoronoiEdgePy::toShape(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_toShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toShape' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->toShape(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getDistances() callback and implementer
// PyObject*  VoronoiEdgePy::getDistances(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getDistances (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getDistances' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->getDistances(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getSegmentAngle() callback and implementer
// PyObject*  VoronoiEdgePy::getSegmentAngle(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getSegmentAngle (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getSegmentAngle' of 'Path.VoronoiEdge' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<VoronoiEdgePy*>(self)->getSegmentAngle(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Index() callback and implementer
// PyObject*  VoronoiEdgePy::Index(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getIndex (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getIndex());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Index' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setIndex (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Index' of object 'VoronoiEdge' is read-only");
    return -1;
}

// Color() callback and implementer
// PyObject*  VoronoiEdgePy::Color(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getColor (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getColor());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Color' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setColor (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<VoronoiEdgePy*>(self)->setColor(Py::Long(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Color' of object 'VoronoiEdge'");
        return -1;
    }
}

// Cell() callback and implementer
// PyObject*  VoronoiEdgePy::Cell(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getCell (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getCell());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Cell' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setCell (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Cell' of object 'VoronoiEdge' is read-only");
    return -1;
}

// Vertices() callback and implementer
// PyObject*  VoronoiEdgePy::Vertices(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getVertices (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getVertices());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Vertices' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setVertices (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Vertices' of object 'VoronoiEdge' is read-only");
    return -1;
}

// Next() callback and implementer
// PyObject*  VoronoiEdgePy::Next(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getNext (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getNext());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Next' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setNext (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Next' of object 'VoronoiEdge' is read-only");
    return -1;
}

// Prev() callback and implementer
// PyObject*  VoronoiEdgePy::Prev(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getPrev (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getPrev());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Prev' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setPrev (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Prev' of object 'VoronoiEdge' is read-only");
    return -1;
}

// RotNext() callback and implementer
// PyObject*  VoronoiEdgePy::RotNext(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getRotNext (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getRotNext());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RotNext' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setRotNext (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RotNext' of object 'VoronoiEdge' is read-only");
    return -1;
}

// RotPrev() callback and implementer
// PyObject*  VoronoiEdgePy::RotPrev(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getRotPrev (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getRotPrev());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RotPrev' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setRotPrev (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RotPrev' of object 'VoronoiEdge' is read-only");
    return -1;
}

// Twin() callback and implementer
// PyObject*  VoronoiEdgePy::Twin(PyObject *args){};
// has to be implemented in VoronoiEdgePyImp.cpp
PyObject * VoronoiEdgePy::staticCallback_getTwin (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<VoronoiEdgePy*>(self)->getTwin());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Twin' of object 'VoronoiEdge'");
        return nullptr;
    }
}

int VoronoiEdgePy::staticCallback_setTwin (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Twin' of object 'VoronoiEdge' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
VoronoiEdgePy::VoronoiEdgePy(VoronoiEdge *pcObject, PyTypeObject *T)
    : BaseClassPy(static_cast<BaseClassPy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
VoronoiEdgePy::~VoronoiEdgePy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    VoronoiEdgePy::PointerType ptr = static_cast<VoronoiEdgePy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// VoronoiEdgePy representation
//--------------------------------------------------------------------------
PyObject *VoronoiEdgePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// VoronoiEdgePy Attributes
//--------------------------------------------------------------------------
PyObject *VoronoiEdgePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return BaseClassPy::_getattr(attr);
}

int VoronoiEdgePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return BaseClassPy::_setattr(attr, value);
}

VoronoiEdge *VoronoiEdgePy::getVoronoiEdgePtr() const
{
    return static_cast<VoronoiEdge *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in VoronoiEdgePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *VoronoiEdgePy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of VoronoiEdgePy and the Twin object
    return new VoronoiEdgePy(new VoronoiEdge);
}

// constructor method
int VoronoiEdgePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string VoronoiEdgePy::representation() const
{
    return {"<VoronoiEdge object>"};
}

PyObject* VoronoiEdgePy::isFinite(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::isInfinite(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::isLinear(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::isCurved(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::isPrimary(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::isSecondary(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::isBorderline(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::toShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::getDistances(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* VoronoiEdgePy::getSegmentAngle(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}


PyObject* VoronoiEdgePy::richCompare(PyObject *v, PyObject *w, int op)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

Py::Long VoronoiEdgePy::getIndex() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long VoronoiEdgePy::getColor() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

void  VoronoiEdgePy::setColor(Py::Long arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object VoronoiEdgePy::getCell() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::List VoronoiEdgePy::getVertices() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object VoronoiEdgePy::getNext() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object VoronoiEdgePy::getPrev() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object VoronoiEdgePy::getRotNext() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object VoronoiEdgePy::getRotPrev() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object VoronoiEdgePy::getTwin() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *VoronoiEdgePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int VoronoiEdgePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



