/* DesktopIntegration.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DesktopIntegration.vala, do not modify */

/*
 * Copyright 2022-2025 elementary, Inc. <https://elementary.io>
 * Copyright 2022 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <meta/meta-plugin.h>
#include <meta/window.h>
#include <meta/display.h>
#include <meta/meta-workspace-manager.h>
#include <string.h>
#include <stdlib.h>
#include "gala.h"
#include <mtk/mtk.h>
#include <meta/workspace.h>
#include <meta/meta-sound-player.h>
#include <glib/gi18n-lib.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <meta/compositor-mutter.h>
#include <meta/meta-window-actor.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_DESKTOP_INTEGRATION (gala_desktop_integration_get_type ())
#define GALA_DESKTOP_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration))
#define GALA_DESKTOP_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegrationClass))
#define GALA_IS_DESKTOP_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DESKTOP_INTEGRATION))
#define GALA_IS_DESKTOP_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DESKTOP_INTEGRATION))
#define GALA_DESKTOP_INTEGRATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegrationClass))

typedef struct _GalaDesktopIntegration GalaDesktopIntegration;
typedef struct _GalaDesktopIntegrationClass GalaDesktopIntegrationClass;
typedef struct _GalaDesktopIntegrationPrivate GalaDesktopIntegrationPrivate;

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;
enum  {
	GALA_DESKTOP_INTEGRATION_0_PROPERTY,
	GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY,
	GALA_DESKTOP_INTEGRATION_NUM_PROPERTIES
};
static GParamSpec* gala_desktop_integration_properties[GALA_DESKTOP_INTEGRATION_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;

#define GALA_DESKTOP_INTEGRATION_TYPE_RUNNING_APPLICATION (gala_desktop_integration_running_application_get_type ())
typedef struct _GalaDesktopIntegrationRunningApplication GalaDesktopIntegrationRunningApplication;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_DESKTOP_INTEGRATION_TYPE_WINDOW (gala_desktop_integration_window_get_type ())
typedef struct _GalaDesktopIntegrationWindow GalaDesktopIntegrationWindow;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_DESKTOP_INTEGRATION_RUNNING_APPLICATIONS_CHANGED_SIGNAL,
	GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL,
	GALA_DESKTOP_INTEGRATION_ACTIVE_WORKSPACE_CHANGED_SIGNAL,
	GALA_DESKTOP_INTEGRATION_WORKSPACE_REMOVED_SIGNAL,
	GALA_DESKTOP_INTEGRATION_NUM_SIGNALS
};
static guint gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_NUM_SIGNALS] = {0};

struct _GalaDesktopIntegration {
	GObject parent_instance;
	GalaDesktopIntegrationPrivate * priv;
};

struct _GalaDesktopIntegrationClass {
	GObjectClass parent_class;
};

struct _GalaDesktopIntegrationPrivate {
	guint _version;
	GalaWindowManagerGala* wm;
	GHashTable* time_appeared_on_workspace;
	gboolean notifying;
};

struct _GalaDesktopIntegrationRunningApplication {
	gchar* app_id;
	GHashTable* details;
};

struct _GalaDesktopIntegrationWindow {
	guint64 uid;
	GHashTable* properties;
};

static gint GalaDesktopIntegration_private_offset;
static gpointer gala_desktop_integration_parent_class = NULL;

VALA_EXTERN GType gala_desktop_integration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDesktopIntegration, g_object_unref)
VALA_EXTERN guint gala_desktop_integration_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GalaDesktopIntegration* gala_desktop_integration_new (GalaWindowManagerGala* wm);
VALA_EXTERN GalaDesktopIntegration* gala_desktop_integration_construct (GType object_type,
                                                            GalaWindowManagerGala* wm);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
VALA_EXTERN GalaWindowTracker* gala_window_manager_gala_get_window_tracker (GalaWindowManagerGala* self);
static void __lambda137_ (GalaDesktopIntegration* self);
static void ___lambda137__gala_window_tracker_windows_changed (GalaWindowTracker* _sender,
                                                        gpointer self);
static void __lambda138_ (GalaDesktopIntegration* self);
static void ___lambda138__meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                    gpointer self);
static void __lambda139_ (GalaDesktopIntegration* self);
static void ___lambda139__meta_workspace_manager_workspaces_reordered (MetaWorkspaceManager* _sender,
                                                                gpointer self);
static void __lambda140_ (GalaDesktopIntegration* self);
static void ___lambda140__meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                           gint object,
                                                           gpointer self);
static void __lambda141_ (GalaDesktopIntegration* self,
                   gint index);
static void ___lambda141__meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                             gint object,
                                                             gpointer self);
static void __lambda142_ (GalaDesktopIntegration* self,
                   MetaWindow* window);
static gint64* _int64_dup (gint64* self);
static void __lambda143_ (GalaDesktopIntegration* self,
                   MetaWindow* _window);
static void ___lambda143__meta_window_workspace_changed (MetaWindow* _sender,
                                                  gpointer self);
static void __lambda144_ (GalaDesktopIntegration* self,
                   MetaWindow* _window);
static void ___lambda144__meta_window_unmanaging (MetaWindow* _sender,
                                           gpointer self);
static void ___lambda142__meta_display_window_created (MetaDisplay* _sender,
                                                MetaWindow* object,
                                                gpointer self);
VALA_EXTERN GType gala_desktop_integration_running_application_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaDesktopIntegrationRunningApplication* gala_desktop_integration_running_application_dup (const GalaDesktopIntegrationRunningApplication* self);
VALA_EXTERN void gala_desktop_integration_running_application_free (GalaDesktopIntegrationRunningApplication* self);
VALA_EXTERN void gala_desktop_integration_running_application_copy (const GalaDesktopIntegrationRunningApplication* self,
                                                        GalaDesktopIntegrationRunningApplication* dest);
VALA_EXTERN void gala_desktop_integration_running_application_destroy (GalaDesktopIntegrationRunningApplication* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaDesktopIntegrationRunningApplication, gala_desktop_integration_running_application_destroy)
VALA_EXTERN GalaDesktopIntegrationRunningApplication* gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                                                             gint* result_length1,
                                                                                             GError** error);
static void _g_variant_unref0_ (gpointer var);
static void _vala_array_add2 (GalaDesktopIntegrationRunningApplication* * array,
                       gint* length,
                       gint* size,
                       const GalaDesktopIntegrationRunningApplication* value);
static void _vala_GalaDesktopIntegrationRunningApplication_array_free (GalaDesktopIntegrationRunningApplication * array,
                                                                gssize array_length);
static gboolean gala_desktop_integration_is_eligible_window (GalaDesktopIntegration* self,
                                                      MetaWindow* window);
VALA_EXTERN GType gala_desktop_integration_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaDesktopIntegrationWindow* gala_desktop_integration_window_dup (const GalaDesktopIntegrationWindow* self);
VALA_EXTERN void gala_desktop_integration_window_free (GalaDesktopIntegrationWindow* self);
VALA_EXTERN void gala_desktop_integration_window_copy (const GalaDesktopIntegrationWindow* self,
                                           GalaDesktopIntegrationWindow* dest);
VALA_EXTERN void gala_desktop_integration_window_destroy (GalaDesktopIntegrationWindow* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaDesktopIntegrationWindow, gala_desktop_integration_window_destroy)
VALA_EXTERN GalaDesktopIntegrationWindow* gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                                                    gint* result_length1,
                                                                    GError** error);
static void _vala_array_add3 (GalaDesktopIntegrationWindow* * array,
                       gint* length,
                       gint* size,
                       const GalaDesktopIntegrationWindow* value);
static void _vala_GalaDesktopIntegrationWindow_array_free (GalaDesktopIntegrationWindow * array,
                                                    gssize array_length);
static MetaWindow* gala_desktop_integration_find_window_by_uid (GalaDesktopIntegration* self,
                                                         guint64 uid,
                                                         GError** error);
VALA_EXTERN void gala_desktop_integration_focus_window (GalaDesktopIntegration* self,
                                            guint64 uid,
                                            GError** error);
static void gala_desktop_integration_notify_already_focused (GalaDesktopIntegration* self,
                                                      MetaWindow* window);
VALA_EXTERN void gala_desktop_integration_move_window_to_workspace (GalaDesktopIntegration* self,
                                                        guint64 uid,
                                                        gint index,
                                                        GError** error);
VALA_EXTERN void gala_desktop_integration_activate_workspace (GalaDesktopIntegration* self,
                                                  gint index,
                                                  GError** error);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
VALA_EXTERN gint gala_desktop_integration_get_n_workspaces (GalaDesktopIntegration* self,
                                                GError** error);
VALA_EXTERN gint gala_desktop_integration_get_active_workspace (GalaDesktopIntegration* self,
                                                    GError** error);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static void __lambda145_ (GalaDesktopIntegration* self);
static void ___lambda145__clutter_timeline_stopped (ClutterTimeline* _sender,
                                             gboolean is_finished,
                                             gpointer self);
VALA_EXTERN void gala_desktop_integration_show_windows_for (GalaDesktopIntegration* self,
                                                const gchar* app_id,
                                                GError** error);
VALA_EXTERN GalaActivatableComponent* gala_window_manager_gala_get_window_overview (GalaWindowManagerGala* self);
static void _vala_array_add4 (guint64* * array,
                       gint* length,
                       gint* size,
                       guint64 value);
static GVariant* _variant_new1 (guint64* value,
                         gint value_length1);
VALA_EXTERN void gala_desktop_integration_reorder_workspace (GalaDesktopIntegration* self,
                                                 gint index,
                                                 gint new_index,
                                                 GError** error);
VALA_EXTERN guint gala_desktop_integration_get_version (GalaDesktopIntegration* self);
static void gala_desktop_integration_finalize (GObject * obj);
static GType gala_desktop_integration_get_type_once (void);
static void _vala_gala_desktop_integration_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _dbus_gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_focus_window (GalaDesktopIntegration* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_move_window_to_workspace (GalaDesktopIntegration* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_activate_workspace (GalaDesktopIntegration* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_get_n_workspaces (GalaDesktopIntegration* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_get_active_workspace (GalaDesktopIntegration* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_show_windows_for (GalaDesktopIntegration* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_reorder_workspace (GalaDesktopIntegration* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void gala_desktop_integration_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* gala_desktop_integration_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static GVariant* _dbus_gala_desktop_integration_get_version (GalaDesktopIntegration* self);
static gboolean gala_desktop_integration_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _dbus_gala_desktop_integration_running_applications_changed (GObject* _sender,
                                                                  gpointer* _data);
static void _dbus_gala_desktop_integration_windows_changed (GObject* _sender,
                                                     gpointer* _data);
static void _dbus_gala_desktop_integration_active_workspace_changed (GObject* _sender,
                                                              gpointer* _data);
static void _dbus_gala_desktop_integration_workspace_removed (GObject* _sender,
                                                       gint index,
                                                       gpointer* _data);
static void _gala_desktop_integration_unregister_object (gpointer user_data);

static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_get_running_applications_result = {-1, "result", "a(sa{sv})", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_running_applications_in[] = {NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_running_applications_out[] = {&_gala_desktop_integration_dbus_arg_info_get_running_applications_result, NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_get_running_applications = {-1, "GetRunningApplications", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_running_applications_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_running_applications_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_get_windows_result = {-1, "result", "a(ta{sv})", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_windows_in[] = {NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_windows_out[] = {&_gala_desktop_integration_dbus_arg_info_get_windows_result, NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_get_windows = {-1, "GetWindows", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_windows_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_windows_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_focus_window_uid = {-1, "uid", "t", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_focus_window_in[] = {&_gala_desktop_integration_dbus_arg_info_focus_window_uid, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_focus_window_out[] = {NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_focus_window = {-1, "FocusWindow", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_focus_window_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_focus_window_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_move_window_to_workspace_uid = {-1, "uid", "t", NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_move_window_to_workspace_index = {-1, "index", "i", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_move_window_to_workspace_in[] = {&_gala_desktop_integration_dbus_arg_info_move_window_to_workspace_uid, &_gala_desktop_integration_dbus_arg_info_move_window_to_workspace_index, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_move_window_to_workspace_out[] = {NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_move_window_to_workspace = {-1, "MoveWindowToWorkspace", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_move_window_to_workspace_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_move_window_to_workspace_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_activate_workspace_index = {-1, "index", "i", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_activate_workspace_in[] = {&_gala_desktop_integration_dbus_arg_info_activate_workspace_index, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_activate_workspace_out[] = {NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_activate_workspace = {-1, "ActivateWorkspace", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_activate_workspace_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_activate_workspace_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_get_n_workspaces_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_n_workspaces_in[] = {NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_n_workspaces_out[] = {&_gala_desktop_integration_dbus_arg_info_get_n_workspaces_result, NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_get_n_workspaces = {-1, "GetNWorkspaces", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_n_workspaces_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_n_workspaces_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_get_active_workspace_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_active_workspace_in[] = {NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_active_workspace_out[] = {&_gala_desktop_integration_dbus_arg_info_get_active_workspace_result, NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_get_active_workspace = {-1, "GetActiveWorkspace", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_active_workspace_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_active_workspace_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_show_windows_for_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_show_windows_for_in[] = {&_gala_desktop_integration_dbus_arg_info_show_windows_for_app_id, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_show_windows_for_out[] = {NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_show_windows_for = {-1, "ShowWindowsFor", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_show_windows_for_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_show_windows_for_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_reorder_workspace_index = {-1, "index", "i", NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_reorder_workspace_new_index = {-1, "new_index", "i", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_reorder_workspace_in[] = {&_gala_desktop_integration_dbus_arg_info_reorder_workspace_index, &_gala_desktop_integration_dbus_arg_info_reorder_workspace_new_index, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_reorder_workspace_out[] = {NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_reorder_workspace = {-1, "ReorderWorkspace", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_reorder_workspace_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_reorder_workspace_out), NULL};
static const GDBusMethodInfo * const _gala_desktop_integration_dbus_method_info[] = {&_gala_desktop_integration_dbus_method_info_get_running_applications, &_gala_desktop_integration_dbus_method_info_get_windows, &_gala_desktop_integration_dbus_method_info_focus_window, &_gala_desktop_integration_dbus_method_info_move_window_to_workspace, &_gala_desktop_integration_dbus_method_info_activate_workspace, &_gala_desktop_integration_dbus_method_info_get_n_workspaces, &_gala_desktop_integration_dbus_method_info_get_active_workspace, &_gala_desktop_integration_dbus_method_info_show_windows_for, &_gala_desktop_integration_dbus_method_info_reorder_workspace, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_running_applications_changed[] = {NULL};
static const GDBusSignalInfo _gala_desktop_integration_dbus_signal_info_running_applications_changed = {-1, "RunningApplicationsChanged", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_running_applications_changed), NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_windows_changed[] = {NULL};
static const GDBusSignalInfo _gala_desktop_integration_dbus_signal_info_windows_changed = {-1, "WindowsChanged", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_windows_changed), NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_active_workspace_changed[] = {NULL};
static const GDBusSignalInfo _gala_desktop_integration_dbus_signal_info_active_workspace_changed = {-1, "ActiveWorkspaceChanged", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_active_workspace_changed), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_workspace_removed_index = {-1, "index", "i", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_workspace_removed[] = {&_gala_desktop_integration_dbus_arg_info_workspace_removed_index, NULL};
static const GDBusSignalInfo _gala_desktop_integration_dbus_signal_info_workspace_removed = {-1, "WorkspaceRemoved", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_workspace_removed), NULL};
static const GDBusSignalInfo * const _gala_desktop_integration_dbus_signal_info[] = {&_gala_desktop_integration_dbus_signal_info_running_applications_changed, &_gala_desktop_integration_dbus_signal_info_windows_changed, &_gala_desktop_integration_dbus_signal_info_active_workspace_changed, &_gala_desktop_integration_dbus_signal_info_workspace_removed, NULL};
static const GDBusPropertyInfo _gala_desktop_integration_dbus_property_info_version = {-1, "Version", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _gala_desktop_integration_dbus_property_info[] = {&_gala_desktop_integration_dbus_property_info_version, NULL};
static const GDBusInterfaceInfo _gala_desktop_integration_dbus_interface_info = {-1, "org.pantheon.gala.DesktopIntegration", (GDBusMethodInfo **) (&_gala_desktop_integration_dbus_method_info), (GDBusSignalInfo **) (&_gala_desktop_integration_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_desktop_integration_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_desktop_integration_dbus_interface_vtable = {gala_desktop_integration_dbus_interface_method_call, gala_desktop_integration_dbus_interface_get_property, gala_desktop_integration_dbus_interface_set_property};

static inline gpointer
gala_desktop_integration_get_instance_private (GalaDesktopIntegration* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDesktopIntegration_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
__lambda137_ (GalaDesktopIntegration* self)
{
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_RUNNING_APPLICATIONS_CHANGED_SIGNAL], 0);
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL], 0);
}

static void
___lambda137__gala_window_tracker_windows_changed (GalaWindowTracker* _sender,
                                                   gpointer self)
{
	__lambda137_ ((GalaDesktopIntegration*) self);
}

static void
__lambda138_ (GalaDesktopIntegration* self)
{
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_ACTIVE_WORKSPACE_CHANGED_SIGNAL], 0);
}

static void
___lambda138__meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                               gpointer self)
{
	__lambda138_ ((GalaDesktopIntegration*) self);
}

static void
__lambda139_ (GalaDesktopIntegration* self)
{
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL], 0);
}

static void
___lambda139__meta_workspace_manager_workspaces_reordered (MetaWorkspaceManager* _sender,
                                                           gpointer self)
{
	__lambda139_ ((GalaDesktopIntegration*) self);
}

static void
__lambda140_ (GalaDesktopIntegration* self)
{
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL], 0);
}

static void
___lambda140__meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                      gint object,
                                                      gpointer self)
{
	__lambda140_ ((GalaDesktopIntegration*) self);
}

static void
__lambda141_ (GalaDesktopIntegration* self,
              gint index)
{
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WORKSPACE_REMOVED_SIGNAL], 0, index);
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL], 0);
}

static void
___lambda141__meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                        gint object,
                                                        gpointer self)
{
	__lambda141_ ((GalaDesktopIntegration*) self, object);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static void
__lambda143_ (GalaDesktopIntegration* self,
              MetaWindow* _window)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	gint64 _tmp2_;
	gint64* _tmp3_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->time_appeared_on_workspace;
	_tmp1_ = _g_object_ref0 (_window);
	_tmp2_ = g_get_monotonic_time ();
	_tmp3_ = __int64_dup0 (&_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL], 0);
}

static void
___lambda143__meta_window_workspace_changed (MetaWindow* _sender,
                                             gpointer self)
{
	__lambda143_ ((GalaDesktopIntegration*) self, _sender);
}

static void
__lambda144_ (GalaDesktopIntegration* self,
              MetaWindow* _window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->time_appeared_on_workspace;
	g_hash_table_remove (_tmp0_, _window);
}

static void
___lambda144__meta_window_unmanaging (MetaWindow* _sender,
                                      gpointer self)
{
	__lambda144_ ((GalaDesktopIntegration*) self, _sender);
}

static void
__lambda142_ (GalaDesktopIntegration* self,
              MetaWindow* window)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	gint64 _tmp2_;
	gint64* _tmp3_;
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->time_appeared_on_workspace;
	_tmp1_ = _g_object_ref0 (window);
	_tmp2_ = g_get_monotonic_time ();
	_tmp3_ = __int64_dup0 (&_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
	g_signal_connect_object (window, "workspace-changed", (GCallback) ___lambda143__meta_window_workspace_changed, self, 0);
	g_signal_connect_object (window, "unmanaging", (GCallback) ___lambda144__meta_window_unmanaging, self, 0);
}

static void
___lambda142__meta_display_window_created (MetaDisplay* _sender,
                                           MetaWindow* object,
                                           gpointer self)
{
	__lambda142_ ((GalaDesktopIntegration*) self, object);
}

GalaDesktopIntegration*
gala_desktop_integration_construct (GType object_type,
                                    GalaWindowManagerGala* wm)
{
	GalaDesktopIntegration * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GalaWindowTracker* _tmp3_;
	GalaWindowTracker* _tmp4_;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp5_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaWorkspaceManager* _tmp6_;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaDesktopIntegration*) g_object_new (object_type, NULL);
	self->priv->wm = wm;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->time_appeared_on_workspace);
	self->priv->time_appeared_on_workspace = _tmp2_;
	_tmp3_ = gala_window_manager_gala_get_window_tracker (wm);
	_tmp4_ = _tmp3_;
	g_signal_connect_object (_tmp4_, "windows-changed", (GCallback) ___lambda137__gala_window_tracker_windows_changed, self, 0);
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) wm);
	display = _tmp5_;
	_tmp6_ = meta_display_get_workspace_manager (display);
	workspace_manager = _tmp6_;
	g_signal_connect_object (workspace_manager, "active-workspace-changed", (GCallback) ___lambda138__meta_workspace_manager_active_workspace_changed, self, 0);
	g_signal_connect_object (workspace_manager, "workspaces-reordered", (GCallback) ___lambda139__meta_workspace_manager_workspaces_reordered, self, 0);
	g_signal_connect_object (workspace_manager, "workspace-added", (GCallback) ___lambda140__meta_workspace_manager_workspace_added, self, 0);
	g_signal_connect_object (workspace_manager, "workspace-removed", (GCallback) ___lambda141__meta_workspace_manager_workspace_removed, self, 0);
	g_signal_connect_object (display, "window-created", (GCallback) ___lambda142__meta_display_window_created, self, 0);
	return self;
}

GalaDesktopIntegration*
gala_desktop_integration_new (GalaWindowManagerGala* wm)
{
	return gala_desktop_integration_construct (GALA_TYPE_DESKTOP_INTEGRATION, wm);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
_vala_array_add2 (GalaDesktopIntegrationRunningApplication* * array,
                  gint* length,
                  gint* size,
                  const GalaDesktopIntegrationRunningApplication* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GalaDesktopIntegrationRunningApplication, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_GalaDesktopIntegrationRunningApplication_array_free (GalaDesktopIntegrationRunningApplication * array,
                                                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_desktop_integration_running_application_destroy (&array[i]);
		}
	}
	g_free (array);
}

GalaDesktopIntegrationRunningApplication*
gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                   gint* result_length1,
                                                   GError** error)
{
	GalaDesktopIntegrationRunningApplication* returned_apps = NULL;
	GalaDesktopIntegrationRunningApplication* _tmp0_;
	gint returned_apps_length1;
	gint _returned_apps_size_;
	GList* apps = NULL;
	GalaAppSystem* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GalaDesktopIntegrationRunningApplication* _tmp12_;
	gint _tmp12__length1;
	GalaDesktopIntegrationRunningApplication* _tmp13_;
	gint _tmp13__length1;
	GalaDesktopIntegrationRunningApplication* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GalaDesktopIntegrationRunningApplication, 0);
	returned_apps = _tmp0_;
	returned_apps_length1 = 0;
	_returned_apps_size_ = returned_apps_length1;
	_tmp1_ = gala_app_system_get_default ();
	_tmp2_ = gala_app_system_get_running_apps (_tmp1_);
	apps = _tmp2_;
	_tmp3_ = apps;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp3_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GalaApp* app = NULL;
			app = (GalaApp*) app_it->data;
			{
				GalaApp* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GHashFunc _tmp8_;
				GEqualFunc _tmp9_;
				GHashTable* _tmp10_;
				GalaDesktopIntegrationRunningApplication _tmp11_ = {0};
				_tmp4_ = app;
				_tmp5_ = gala_app_get_id (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				_tmp8_ = g_str_hash;
				_tmp9_ = g_str_equal;
				_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, NULL, _g_variant_unref0_);
				memset (&_tmp11_, 0, sizeof (GalaDesktopIntegrationRunningApplication));
				_g_free0 (_tmp11_.app_id);
				_tmp11_.app_id = _tmp7_;
				_g_hash_table_unref0 (_tmp11_.details);
				_tmp11_.details = _tmp10_;
				_vala_array_add2 (&returned_apps, &returned_apps_length1, &_returned_apps_size_, &_tmp11_);
			}
		}
	}
	_tmp12_ = returned_apps;
	_tmp12__length1 = returned_apps_length1;
	returned_apps = NULL;
	returned_apps_length1 = 0;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
	returned_apps = (_vala_GalaDesktopIntegrationRunningApplication_array_free (returned_apps, returned_apps_length1), NULL);
	return result;
}

static gboolean
gala_desktop_integration_is_eligible_window (GalaDesktopIntegration* self,
                                             MetaWindow* window)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	if (meta_window_is_override_redirect (window)) {
		result = FALSE;
		return result;
	}
	switch (meta_window_get_window_type (window)) {
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		case META_WINDOW_UTILITY:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
_vala_array_add3 (GalaDesktopIntegrationWindow* * array,
                  gint* length,
                  gint* size,
                  const GalaDesktopIntegrationWindow* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GalaDesktopIntegrationWindow, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_GalaDesktopIntegrationWindow_array_free (GalaDesktopIntegrationWindow * array,
                                               gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_desktop_integration_window_destroy (&array[i]);
		}
	}
	g_free (array);
}

GalaDesktopIntegrationWindow*
gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                      gint* result_length1,
                                      GError** error)
{
	GalaDesktopIntegrationWindow* returned_windows = NULL;
	GalaDesktopIntegrationWindow* _tmp0_;
	gint returned_windows_length1;
	gint _returned_windows_size_;
	GList* apps = NULL;
	GalaAppSystem* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GalaDesktopIntegrationWindow* _tmp69_;
	gint _tmp69__length1;
	GalaDesktopIntegrationWindow* _tmp70_;
	gint _tmp70__length1;
	GalaDesktopIntegrationWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GalaDesktopIntegrationWindow, 0);
	returned_windows = _tmp0_;
	returned_windows_length1 = 0;
	_returned_windows_size_ = returned_windows_length1;
	_tmp1_ = gala_app_system_get_default ();
	_tmp2_ = gala_app_system_get_running_apps (_tmp1_);
	apps = _tmp2_;
	_tmp3_ = apps;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp3_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GalaApp* app = NULL;
			app = (GalaApp*) app_it->data;
			{
				GalaApp* _tmp4_;
				GSList* _tmp5_;
				_tmp4_ = app;
				_tmp5_ = gala_app_get_windows (_tmp4_);
				{
					GSList* window_collection = NULL;
					GSList* window_it = NULL;
					window_collection = _tmp5_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							MetaWindow* _tmp6_;
							GHashTable* properties = NULL;
							GHashFunc _tmp7_;
							GEqualFunc _tmp8_;
							GHashTable* _tmp9_;
							MtkRectangle frame_rect = {0};
							MetaWindow* _tmp10_;
							MtkRectangle _tmp11_ = {0};
							const gchar* title = NULL;
							MetaWindow* _tmp12_;
							const gchar* _tmp13_;
							const gchar* wm_class = NULL;
							MetaWindow* _tmp14_;
							const gchar* _tmp15_;
							const gchar* sandboxed_app_id = NULL;
							MetaWindow* _tmp16_;
							const gchar* _tmp17_;
							GHashTable* _tmp18_;
							GalaApp* _tmp19_;
							const gchar* _tmp20_;
							const gchar* _tmp21_;
							GVariant* _tmp22_;
							GHashTable* _tmp23_;
							MetaWindow* _tmp24_;
							GVariant* _tmp25_;
							GHashTable* _tmp26_;
							MetaWindow* _tmp27_;
							GVariant* _tmp28_;
							GHashTable* _tmp29_;
							MetaWindow* _tmp30_;
							GVariant* _tmp31_;
							GHashTable* _tmp32_;
							MetaWindow* _tmp33_;
							MetaWorkspace* _tmp34_;
							GVariant* _tmp35_;
							GHashTable* _tmp36_;
							MtkRectangle _tmp37_;
							GVariant* _tmp38_;
							GHashTable* _tmp39_;
							MtkRectangle _tmp40_;
							GVariant* _tmp41_;
							const gchar* _tmp42_;
							const gchar* _tmp46_;
							const gchar* _tmp50_;
							gboolean _tmp54_ = FALSE;
							GHashTable* _tmp55_;
							MetaWindow* _tmp56_;
							MetaWindow* _tmp65_;
							GHashTable* _tmp66_;
							GHashTable* _tmp67_;
							GalaDesktopIntegrationWindow _tmp68_ = {0};
							_tmp6_ = window;
							if (!gala_desktop_integration_is_eligible_window (self, _tmp6_)) {
								continue;
							}
							_tmp7_ = g_str_hash;
							_tmp8_ = g_str_equal;
							_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, _g_variant_unref0_);
							properties = _tmp9_;
							_tmp10_ = window;
							meta_window_get_frame_rect (_tmp10_, &_tmp11_);
							frame_rect = _tmp11_;
							_tmp12_ = window;
							_tmp13_ = meta_window_get_title (_tmp12_);
							title = _tmp13_;
							_tmp14_ = window;
							_tmp15_ = meta_window_get_wm_class (_tmp14_);
							wm_class = _tmp15_;
							_tmp16_ = window;
							_tmp17_ = meta_window_get_sandboxed_app_id (_tmp16_);
							sandboxed_app_id = _tmp17_;
							_tmp18_ = properties;
							_tmp19_ = app;
							_tmp20_ = gala_app_get_id (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_variant_new_string (_tmp21_);
							g_variant_ref_sink (_tmp22_);
							g_hash_table_insert (_tmp18_, "app-id", _tmp22_);
							_tmp23_ = properties;
							_tmp24_ = window;
							_tmp25_ = g_variant_new_uint32 ((guint32) meta_window_get_client_type (_tmp24_));
							g_variant_ref_sink (_tmp25_);
							g_hash_table_insert (_tmp23_, "client-type", _tmp25_);
							_tmp26_ = properties;
							_tmp27_ = window;
							_tmp28_ = g_variant_new_boolean (meta_window_is_hidden (_tmp27_));
							g_variant_ref_sink (_tmp28_);
							g_hash_table_insert (_tmp26_, "is-hidden", _tmp28_);
							_tmp29_ = properties;
							_tmp30_ = window;
							_tmp31_ = g_variant_new_boolean (meta_window_has_focus (_tmp30_));
							g_variant_ref_sink (_tmp31_);
							g_hash_table_insert (_tmp29_, "has-focus", _tmp31_);
							_tmp32_ = properties;
							_tmp33_ = window;
							_tmp34_ = meta_window_get_workspace (_tmp33_);
							_tmp35_ = g_variant_new_int32 ((gint32) meta_workspace_index (_tmp34_));
							g_variant_ref_sink (_tmp35_);
							g_hash_table_insert (_tmp32_, "workspace-index", _tmp35_);
							_tmp36_ = properties;
							_tmp37_ = frame_rect;
							_tmp38_ = g_variant_new_uint32 ((guint32) _tmp37_.width);
							g_variant_ref_sink (_tmp38_);
							g_hash_table_insert (_tmp36_, "width", _tmp38_);
							_tmp39_ = properties;
							_tmp40_ = frame_rect;
							_tmp41_ = g_variant_new_uint32 ((guint32) _tmp40_.height);
							g_variant_ref_sink (_tmp41_);
							g_hash_table_insert (_tmp39_, "height", _tmp41_);
							_tmp42_ = title;
							if (_tmp42_ != NULL) {
								GHashTable* _tmp43_;
								const gchar* _tmp44_;
								GVariant* _tmp45_;
								_tmp43_ = properties;
								_tmp44_ = title;
								_tmp45_ = g_variant_new_string (_tmp44_);
								g_variant_ref_sink (_tmp45_);
								g_hash_table_insert (_tmp43_, "title", _tmp45_);
							}
							_tmp46_ = wm_class;
							if (_tmp46_ != NULL) {
								GHashTable* _tmp47_;
								const gchar* _tmp48_;
								GVariant* _tmp49_;
								_tmp47_ = properties;
								_tmp48_ = wm_class;
								_tmp49_ = g_variant_new_string (_tmp48_);
								g_variant_ref_sink (_tmp49_);
								g_hash_table_insert (_tmp47_, "wm-class", _tmp49_);
							}
							_tmp50_ = sandboxed_app_id;
							if (_tmp50_ != NULL) {
								GHashTable* _tmp51_;
								const gchar* _tmp52_;
								GVariant* _tmp53_;
								_tmp51_ = properties;
								_tmp52_ = sandboxed_app_id;
								_tmp53_ = g_variant_new_string (_tmp52_);
								g_variant_ref_sink (_tmp53_);
								g_hash_table_insert (_tmp51_, "sandboxed-app-id", _tmp53_);
							}
							_tmp55_ = self->priv->time_appeared_on_workspace;
							_tmp56_ = window;
							if (g_hash_table_contains (_tmp55_, _tmp56_)) {
								GHashTable* _tmp57_;
								MetaWindow* _tmp58_;
								gconstpointer _tmp59_;
								_tmp57_ = self->priv->time_appeared_on_workspace;
								_tmp58_ = window;
								_tmp59_ = g_hash_table_lookup (_tmp57_, _tmp58_);
								_tmp54_ = ((gint64*) _tmp59_) != NULL;
							} else {
								_tmp54_ = FALSE;
							}
							if (_tmp54_) {
								GHashTable* _tmp60_;
								GHashTable* _tmp61_;
								MetaWindow* _tmp62_;
								gconstpointer _tmp63_;
								GVariant* _tmp64_;
								_tmp60_ = properties;
								_tmp61_ = self->priv->time_appeared_on_workspace;
								_tmp62_ = window;
								_tmp63_ = g_hash_table_lookup (_tmp61_, _tmp62_);
								_tmp64_ = g_variant_new_int64 (*((gint64*) _tmp63_));
								g_variant_ref_sink (_tmp64_);
								g_hash_table_insert (_tmp60_, "time-appeared-on-workspace", _tmp64_);
							}
							_tmp65_ = window;
							_tmp66_ = properties;
							_tmp67_ = _g_hash_table_ref0 (_tmp66_);
							memset (&_tmp68_, 0, sizeof (GalaDesktopIntegrationWindow));
							_tmp68_.uid = meta_window_get_id (_tmp65_);
							_g_hash_table_unref0 (_tmp68_.properties);
							_tmp68_.properties = _tmp67_;
							_vala_array_add3 (&returned_windows, &returned_windows_length1, &_returned_windows_size_, &_tmp68_);
							_g_hash_table_unref0 (properties);
						}
					}
				}
			}
		}
	}
	_tmp69_ = returned_windows;
	_tmp69__length1 = returned_windows_length1;
	returned_windows = NULL;
	returned_windows_length1 = 0;
	_tmp70_ = _tmp69_;
	_tmp70__length1 = _tmp69__length1;
	if (result_length1) {
		*result_length1 = _tmp70__length1;
	}
	result = _tmp70_;
	(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
	returned_windows = (_vala_GalaDesktopIntegrationWindow_array_free (returned_windows, returned_windows_length1), NULL);
	return result;
}

static MetaWindow*
gala_desktop_integration_find_window_by_uid (GalaDesktopIntegration* self,
                                             guint64 uid,
                                             GError** error)
{
	GList* apps = NULL;
	GalaAppSystem* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _inner_error0_ = NULL;
	MetaWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gala_app_system_get_default ();
	_tmp1_ = gala_app_system_get_running_apps (_tmp0_);
	apps = _tmp1_;
	_tmp2_ = apps;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp2_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GalaApp* app = NULL;
			app = (GalaApp*) app_it->data;
			{
				GalaApp* _tmp3_;
				GSList* _tmp4_;
				_tmp3_ = app;
				_tmp4_ = gala_app_get_windows (_tmp3_);
				{
					GSList* window_collection = NULL;
					GSList* window_it = NULL;
					window_collection = _tmp4_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							MetaWindow* _tmp5_;
							_tmp5_ = window;
							if (meta_window_get_id (_tmp5_) == uid) {
								MetaWindow* _tmp6_;
								MetaWindow* _tmp7_;
								_tmp6_ = window;
								_tmp7_ = _g_object_ref0 (_tmp6_);
								result = _tmp7_;
								(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
								return result;
							}
						}
					}
				}
			}
		}
	}
	_tmp8_ = g_strdup_printf ("%" G_GUINT64_FORMAT, uid);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("Window with UID ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, " not found", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_inner_error0_ = _tmp15_;
	if (_inner_error0_->domain == G_IO_ERROR) {
		g_propagate_error (error, _inner_error0_);
		(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
		return NULL;
	} else {
		(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
gala_desktop_integration_focus_window (GalaDesktopIntegration* self,
                                       guint64 uid,
                                       GError** error)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_desktop_integration_find_window_by_uid (self, uid, &_inner_error0_);
	window = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (meta_window_has_focus (window)) {
		gala_desktop_integration_notify_already_focused (self, window);
	} else {
		MetaWorkspace* _tmp1_;
		GalaWindowManagerGala* _tmp2_;
		MetaDisplay* _tmp3_;
		_tmp1_ = meta_window_get_workspace (window);
		_tmp2_ = self->priv->wm;
		_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
		meta_workspace_activate_with_focus (_tmp1_, window, meta_display_get_current_time (_tmp3_));
	}
	_g_object_unref0 (window);
}

void
gala_desktop_integration_move_window_to_workspace (GalaDesktopIntegration* self,
                                                   guint64 uid,
                                                   gint index,
                                                   GError** error)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_desktop_integration_find_window_by_uid (self, uid, &_inner_error0_);
	window = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	meta_window_change_workspace_by_index (window, index, FALSE);
	_g_object_unref0 (window);
}

void
gala_desktop_integration_activate_workspace (GalaDesktopIntegration* self,
                                             gint index,
                                             GError** error)
{
	MetaWorkspace* workspace = NULL;
	GalaWindowManagerGala* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaDisplay* display = NULL;
	GalaWindowManagerGala* _tmp6_;
	MetaDisplay* _tmp7_;
	gint active_workspace_index = 0;
	MetaDisplay* _tmp8_;
	MetaWorkspaceManager* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	_tmp3_ = meta_workspace_manager_get_workspace_by_index (_tmp2_, index);
	workspace = _tmp3_;
	_tmp4_ = workspace;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Workspace not found");
		_inner_error0_ = _tmp5_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = self->priv->wm;
	_tmp7_ = meta_plugin_get_display ((MetaPlugin*) _tmp6_);
	display = _tmp7_;
	_tmp8_ = display;
	_tmp9_ = meta_display_get_workspace_manager (_tmp8_);
	active_workspace_index = meta_workspace_manager_get_active_workspace_index (_tmp9_);
	if (active_workspace_index == index) {
		MetaDisplay* _tmp10_;
		_tmp10_ = display;
		gala_internal_utils_bell_notify (_tmp10_);
	} else {
		MetaWorkspace* _tmp11_;
		MetaDisplay* _tmp12_;
		_tmp11_ = workspace;
		_tmp12_ = display;
		meta_workspace_activate (_tmp11_, meta_display_get_current_time (_tmp12_));
	}
}

gint
gala_desktop_integration_get_n_workspaces (GalaDesktopIntegration* self,
                                           GError** error)
{
	GalaWindowManagerGala* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	_tmp3_ = meta_workspace_manager_get_n_workspaces (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

gint
gala_desktop_integration_get_active_workspace (GalaDesktopIntegration* self,
                                               GError** error)
{
	GalaWindowManagerGala* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	result = meta_workspace_manager_get_active_workspace_index (_tmp2_);
	return result;
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static void
__lambda145_ (GalaDesktopIntegration* self)
{
	GalaWindowManagerGala* _tmp0_;
	MetaDisplay* _tmp1_;
	self->priv->notifying = FALSE;
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_enable_unredirect_for_display (_tmp1_);
}

static void
___lambda145__clutter_timeline_stopped (ClutterTimeline* _sender,
                                        gboolean is_finished,
                                        gpointer self)
{
	__lambda145_ ((GalaDesktopIntegration*) self);
}

static void
gala_desktop_integration_notify_already_focused (GalaDesktopIntegration* self,
                                                 MetaWindow* window)
{
	GalaWindowManagerGala* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaSoundPlayer* _tmp2_;
	ClutterKeyframeTransition* transition = NULL;
	ClutterKeyframeTransition* _tmp3_ = NULL;
	ClutterKeyframeTransition* _tmp4_;
	GValue _tmp5_ = {0};
	ClutterKeyframeTransition* _tmp6_;
	GValue _tmp7_ = {0};
	ClutterKeyframeTransition* _tmp8_;
	gdouble* _tmp9_;
	gdouble* _tmp10_;
	gint _tmp10__length1;
	gint offset = 0;
	GalaWindowManagerGala* _tmp11_;
	MetaDisplay* _tmp12_;
	ClutterKeyframeTransition* _tmp13_;
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue* _tmp16_;
	GValue* _tmp17_;
	gint _tmp17__length1;
	ClutterKeyframeTransition* _tmp18_;
	GalaWindowManagerGala* _tmp19_;
	MetaDisplay* _tmp20_;
	GObject* _tmp21_;
	ClutterKeyframeTransition* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (self->priv->notifying) {
		return;
	}
	self->priv->notifying = TRUE;
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_sound_player (_tmp1_);
	meta_sound_player_play_from_theme (_tmp2_, "bell", _ ("Window has already focus"), NULL);
	if (meta_window_get_maximized (window) == META_MAXIMIZE_BOTH) {
		self->priv->notifying = FALSE;
		return;
	}
	_tmp3_ = (ClutterKeyframeTransition*) clutter_keyframe_transition_new ("translation-x");
	clutter_timeline_set_repeat_count ((ClutterTimeline*) _tmp3_, 5);
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp3_, (guint) 100);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp3_, TRUE);
	transition = _tmp3_;
	_tmp4_ = transition;
	g_value_init (&_tmp5_, G_TYPE_INT);
	g_value_set_int (&_tmp5_, 0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp4_, &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
	_tmp6_ = transition;
	g_value_init (&_tmp7_, G_TYPE_INT);
	g_value_set_int (&_tmp7_, 0);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp6_, &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	_tmp8_ = transition;
	_tmp9_ = g_new0 (gdouble, 2);
	_tmp9_[0] = 0.5;
	_tmp9_[1] = -0.5;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	clutter_keyframe_transition_set_key_frames (_tmp8_, (guint) 2, _tmp10_);
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp11_ = self->priv->wm;
	_tmp12_ = meta_plugin_get_display ((MetaPlugin*) _tmp11_);
	offset = gala_utils_scale_to_int (15, meta_display_get_monitor_scale (_tmp12_, meta_window_get_monitor (window)));
	_tmp13_ = transition;
	g_value_init (&_tmp14_, G_TYPE_INT);
	g_value_set_int (&_tmp14_, -offset);
	g_value_init (&_tmp15_, G_TYPE_INT);
	g_value_set_int (&_tmp15_, offset);
	_tmp16_ = g_new0 (GValue, 2);
	_tmp16_[0] = _tmp14_;
	_tmp16_[1] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 2;
	clutter_keyframe_transition_set_values (_tmp13_, (guint) 2, _tmp17_);
	_tmp17_ = (_vala_GValue_array_free (_tmp17_, _tmp17__length1), NULL);
	_tmp18_ = transition;
	g_signal_connect_object ((ClutterTimeline*) _tmp18_, "stopped", (GCallback) ___lambda145__clutter_timeline_stopped, self, 0);
	_tmp19_ = self->priv->wm;
	_tmp20_ = meta_plugin_get_display ((MetaPlugin*) _tmp19_);
	meta_disable_unredirect_for_display (_tmp20_);
	_tmp21_ = meta_window_get_compositor_private (window);
	_tmp22_ = transition;
	clutter_actor_add_transition ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, meta_window_actor_get_type (), MetaWindowActor), "notify-already-focused", (ClutterTransition*) _tmp22_);
	_g_object_unref0 (transition);
}

static void
_vala_array_add4 (guint64* * array,
                  gint* length,
                  gint* size,
                  guint64 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint64, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static GVariant*
_variant_new1 (guint64* value,
               gint value_length1)
{
	guint64* _tmp20_;
	GVariantBuilder _tmp21_;
	gint _tmp22_;
	_tmp20_ = value;
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("at"));
	for (_tmp22_ = 0; _tmp22_ < value_length1; _tmp22_++) {
		g_variant_builder_add_value (&_tmp21_, g_variant_new_uint64 (*_tmp20_));
		_tmp20_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp21_));
}

void
gala_desktop_integration_show_windows_for (GalaDesktopIntegration* self,
                                           const gchar* app_id,
                                           GError** error)
{
	GalaWindowManagerGala* _tmp0_;
	GalaActivatableComponent* _tmp1_;
	GalaActivatableComponent* _tmp2_;
	GalaApp* app = NULL;
	GalaAppSystem* _tmp4_;
	GalaApp* _tmp5_;
	GalaApp* _tmp6_;
	GalaApp* _tmp7_;
	guint64* window_ids = NULL;
	guint64* _tmp9_;
	gint window_ids_length1;
	gint _window_ids_size_;
	GalaApp* _tmp10_;
	GSList* _tmp11_;
	GHashTable* hints = NULL;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	guint64* _tmp19_;
	gint _tmp19__length1;
	GVariant* _tmp23_;
	GalaWindowManagerGala* _tmp24_;
	GalaActivatableComponent* _tmp25_;
	GalaActivatableComponent* _tmp26_;
	GalaWindowManagerGala* _tmp30_;
	GalaActivatableComponent* _tmp31_;
	GalaActivatableComponent* _tmp32_;
	GHashTable* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_id != NULL);
	_tmp0_ = self->priv->wm;
	_tmp1_ = gala_window_manager_gala_get_window_overview (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Window overview not provided by window manager");
		_inner_error0_ = _tmp3_;
		if ((_inner_error0_->domain == G_IO_ERROR) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = gala_app_system_get_default ();
	_tmp5_ = gala_app_system_lookup_app (_tmp4_, app_id);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (app);
	app = _tmp6_;
	_tmp7_ = app;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "App not found");
		_inner_error0_ = _tmp8_;
		if ((_inner_error0_->domain == G_IO_ERROR) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (app);
			return;
		} else {
			_g_object_unref0 (app);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = g_new0 (guint64, 0);
	window_ids = _tmp9_;
	window_ids_length1 = 0;
	_window_ids_size_ = window_ids_length1;
	_tmp10_ = app;
	_tmp11_ = gala_app_get_windows (_tmp10_);
	{
		GSList* window_collection = NULL;
		GSList* window_it = NULL;
		window_collection = _tmp11_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* _tmp12_;
			MetaWindow* window = NULL;
			_tmp12_ = _g_object_ref0 ((MetaWindow*) window_it->data);
			window = _tmp12_;
			{
				MetaWindow* _tmp13_;
				_tmp13_ = window;
				_vala_array_add4 (&window_ids, &window_ids_length1, &_window_ids_size_, meta_window_get_id (_tmp13_));
				_g_object_unref0 (window);
			}
		}
	}
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, _g_free0_, _g_variant_unref0_);
	hints = _tmp16_;
	_tmp17_ = hints;
	_tmp18_ = g_strdup ("windows");
	_tmp19_ = window_ids;
	_tmp19__length1 = window_ids_length1;
	_tmp23_ = _variant_new1 (_tmp19_, _tmp19__length1);
	g_hash_table_insert (_tmp17_, _tmp18_, _tmp23_);
	_tmp24_ = self->priv->wm;
	_tmp25_ = gala_window_manager_gala_get_window_overview (_tmp24_);
	_tmp26_ = _tmp25_;
	if (gala_activatable_component_is_opened (_tmp26_)) {
		GalaWindowManagerGala* _tmp27_;
		GalaActivatableComponent* _tmp28_;
		GalaActivatableComponent* _tmp29_;
		_tmp27_ = self->priv->wm;
		_tmp28_ = gala_window_manager_gala_get_window_overview (_tmp27_);
		_tmp29_ = _tmp28_;
		gala_activatable_component_close (_tmp29_, NULL);
	}
	_tmp30_ = self->priv->wm;
	_tmp31_ = gala_window_manager_gala_get_window_overview (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = hints;
	gala_activatable_component_open (_tmp32_, _tmp33_);
	_g_hash_table_unref0 (hints);
	window_ids = (g_free (window_ids), NULL);
	_g_object_unref0 (app);
}

void
gala_desktop_integration_reorder_workspace (GalaDesktopIntegration* self,
                                            gint index,
                                            gint new_index,
                                            GError** error)
{
	MetaWorkspaceManager* workspace_manager = NULL;
	GalaWindowManagerGala* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspaceManager* _tmp7_;
	MetaWorkspace* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	workspace_manager = _tmp2_;
	_tmp3_ = workspace_manager;
	_tmp4_ = meta_workspace_manager_get_workspace_by_index (_tmp3_, index);
	workspace = _tmp4_;
	_tmp5_ = workspace;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Invalid index, workspace not found");
		_inner_error0_ = _tmp6_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = workspace_manager;
	_tmp8_ = workspace;
	meta_workspace_manager_reorder_workspace (_tmp7_, _tmp8_, new_index);
}

guint
gala_desktop_integration_get_version (GalaDesktopIntegration* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_version;
	return result;
}

void
gala_desktop_integration_running_application_copy (const GalaDesktopIntegrationRunningApplication* self,
                                                   GalaDesktopIntegrationRunningApplication* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	_tmp0_ = (*self).app_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).app_id);
	(*dest).app_id = _tmp1_;
	_tmp2_ = (*self).details;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 ((*dest).details);
	(*dest).details = _tmp3_;
}

void
gala_desktop_integration_running_application_destroy (GalaDesktopIntegrationRunningApplication* self)
{
	_g_free0 ((*self).app_id);
	_g_hash_table_unref0 ((*self).details);
}

GalaDesktopIntegrationRunningApplication*
gala_desktop_integration_running_application_dup (const GalaDesktopIntegrationRunningApplication* self)
{
	GalaDesktopIntegrationRunningApplication* dup;
	dup = g_new0 (GalaDesktopIntegrationRunningApplication, 1);
	gala_desktop_integration_running_application_copy (self, dup);
	return dup;
}

void
gala_desktop_integration_running_application_free (GalaDesktopIntegrationRunningApplication* self)
{
	gala_desktop_integration_running_application_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gala_desktop_integration_running_application_get_type_once (void)
{
	GType gala_desktop_integration_running_application_type_id;
	gala_desktop_integration_running_application_type_id = g_boxed_type_register_static ("GalaDesktopIntegrationRunningApplication", (GBoxedCopyFunc) gala_desktop_integration_running_application_dup, (GBoxedFreeFunc) gala_desktop_integration_running_application_free);
	return gala_desktop_integration_running_application_type_id;
}

GType
gala_desktop_integration_running_application_get_type (void)
{
	static gsize gala_desktop_integration_running_application_type_id__once = 0;
	if (g_once_init_enter (&gala_desktop_integration_running_application_type_id__once)) {
		GType gala_desktop_integration_running_application_type_id;
		gala_desktop_integration_running_application_type_id = gala_desktop_integration_running_application_get_type_once ();
		g_once_init_leave (&gala_desktop_integration_running_application_type_id__once, gala_desktop_integration_running_application_type_id);
	}
	return gala_desktop_integration_running_application_type_id__once;
}

void
gala_desktop_integration_window_copy (const GalaDesktopIntegrationWindow* self,
                                      GalaDesktopIntegrationWindow* dest)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	(*dest).uid = (*self).uid;
	_tmp0_ = (*self).properties;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp1_;
}

void
gala_desktop_integration_window_destroy (GalaDesktopIntegrationWindow* self)
{
	_g_hash_table_unref0 ((*self).properties);
}

GalaDesktopIntegrationWindow*
gala_desktop_integration_window_dup (const GalaDesktopIntegrationWindow* self)
{
	GalaDesktopIntegrationWindow* dup;
	dup = g_new0 (GalaDesktopIntegrationWindow, 1);
	gala_desktop_integration_window_copy (self, dup);
	return dup;
}

void
gala_desktop_integration_window_free (GalaDesktopIntegrationWindow* self)
{
	gala_desktop_integration_window_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gala_desktop_integration_window_get_type_once (void)
{
	GType gala_desktop_integration_window_type_id;
	gala_desktop_integration_window_type_id = g_boxed_type_register_static ("GalaDesktopIntegrationWindow", (GBoxedCopyFunc) gala_desktop_integration_window_dup, (GBoxedFreeFunc) gala_desktop_integration_window_free);
	return gala_desktop_integration_window_type_id;
}

GType
gala_desktop_integration_window_get_type (void)
{
	static gsize gala_desktop_integration_window_type_id__once = 0;
	if (g_once_init_enter (&gala_desktop_integration_window_type_id__once)) {
		GType gala_desktop_integration_window_type_id;
		gala_desktop_integration_window_type_id = gala_desktop_integration_window_get_type_once ();
		g_once_init_leave (&gala_desktop_integration_window_type_id__once, gala_desktop_integration_window_type_id);
	}
	return gala_desktop_integration_window_type_id__once;
}

static void
gala_desktop_integration_class_init (GalaDesktopIntegrationClass * klass,
                                     gpointer klass_data)
{
	gala_desktop_integration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDesktopIntegration_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_desktop_integration_get_property;
	G_OBJECT_CLASS (klass)->finalize = gala_desktop_integration_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY, gala_desktop_integration_properties[GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY] = g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT, (guint) 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_RUNNING_APPLICATIONS_CHANGED_SIGNAL] = g_signal_new ("running-applications-changed", GALA_TYPE_DESKTOP_INTEGRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL] = g_signal_new ("windows-changed", GALA_TYPE_DESKTOP_INTEGRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_ACTIVE_WORKSPACE_CHANGED_SIGNAL] = g_signal_new ("active-workspace-changed", GALA_TYPE_DESKTOP_INTEGRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WORKSPACE_REMOVED_SIGNAL] = g_signal_new ("workspace-removed", GALA_TYPE_DESKTOP_INTEGRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
gala_desktop_integration_instance_init (GalaDesktopIntegration * self,
                                        gpointer klass)
{
	self->priv = gala_desktop_integration_get_instance_private (self);
	self->priv->_version = (guint) 1;
	self->priv->notifying = FALSE;
}

static void
gala_desktop_integration_finalize (GObject * obj)
{
	GalaDesktopIntegration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration);
	_g_hash_table_unref0 (self->priv->time_appeared_on_workspace);
	G_OBJECT_CLASS (gala_desktop_integration_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_desktop_integration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDesktopIntegrationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_desktop_integration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDesktopIntegration), 0, (GInstanceInitFunc) gala_desktop_integration_instance_init, NULL };
	GType gala_desktop_integration_type_id;
	gala_desktop_integration_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDesktopIntegration", &g_define_type_info, 0);
	g_type_set_qdata (gala_desktop_integration_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_desktop_integration_register_object);
	GalaDesktopIntegration_private_offset = g_type_add_instance_private (gala_desktop_integration_type_id, sizeof (GalaDesktopIntegrationPrivate));
	return gala_desktop_integration_type_id;
}

GType
gala_desktop_integration_get_type (void)
{
	static gsize gala_desktop_integration_type_id__once = 0;
	if (g_once_init_enter (&gala_desktop_integration_type_id__once)) {
		GType gala_desktop_integration_type_id;
		gala_desktop_integration_type_id = gala_desktop_integration_get_type_once ();
		g_once_init_leave (&gala_desktop_integration_type_id__once, gala_desktop_integration_type_id);
	}
	return gala_desktop_integration_type_id__once;
}

static void
_vala_gala_desktop_integration_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GalaDesktopIntegration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration);
	switch (property_id) {
		case GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY:
		g_value_set_uint (value, gala_desktop_integration_get_version (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GalaDesktopIntegrationRunningApplication* result;
	gint result_length1 = 0;
	GalaDesktopIntegrationRunningApplication* _tmp30_;
	GVariantBuilder _tmp31_;
	gint _tmp32_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = gala_desktop_integration_get_running_applications (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp30_ = result;
	g_variant_builder_init (&_tmp31_, G_VARIANT_TYPE ("a(sa{sv})"));
	for (_tmp32_ = 0; _tmp32_ < result_length1; _tmp32_++) {
		GVariantBuilder _tmp33_;
		GVariantBuilder _tmp34_;
		GHashTableIter _tmp35_;
		gpointer _tmp36_;
		gpointer _tmp37_;
		g_variant_builder_init (&_tmp33_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp33_, g_variant_new_string ((*_tmp30_).app_id));
		g_hash_table_iter_init (&_tmp35_, (*_tmp30_).details);
		g_variant_builder_init (&_tmp34_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp35_, &_tmp36_, &_tmp37_)) {
			const gchar* _key;
			GVariant* _value;
			_key = (const gchar*) _tmp36_;
			_value = (GVariant*) _tmp37_;
			g_variant_builder_add (&_tmp34_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp33_, g_variant_builder_end (&_tmp34_));
		g_variant_builder_add_value (&_tmp31_, g_variant_builder_end (&_tmp33_));
		_tmp30_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp31_));
	result = (_vala_GalaDesktopIntegrationRunningApplication_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GalaDesktopIntegrationWindow* result;
	gint result_length1 = 0;
	GalaDesktopIntegrationWindow* _tmp38_;
	GVariantBuilder _tmp39_;
	gint _tmp40_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = gala_desktop_integration_get_windows (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp38_ = result;
	g_variant_builder_init (&_tmp39_, G_VARIANT_TYPE ("a(ta{sv})"));
	for (_tmp40_ = 0; _tmp40_ < result_length1; _tmp40_++) {
		GVariantBuilder _tmp41_;
		GVariantBuilder _tmp42_;
		GHashTableIter _tmp43_;
		gpointer _tmp44_;
		gpointer _tmp45_;
		g_variant_builder_init (&_tmp41_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp41_, g_variant_new_uint64 ((*_tmp38_).uid));
		g_hash_table_iter_init (&_tmp43_, (*_tmp38_).properties);
		g_variant_builder_init (&_tmp42_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp43_, &_tmp44_, &_tmp45_)) {
			const gchar* _key;
			GVariant* _value;
			_key = (const gchar*) _tmp44_;
			_value = (GVariant*) _tmp45_;
			g_variant_builder_add (&_tmp42_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp41_, g_variant_builder_end (&_tmp42_));
		g_variant_builder_add_value (&_tmp39_, g_variant_builder_end (&_tmp41_));
		_tmp38_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp39_));
	result = (_vala_GalaDesktopIntegrationWindow_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_focus_window (GalaDesktopIntegration* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint64 uid = 0ULL;
	GVariant* _tmp46_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	uid = g_variant_get_uint64 (_tmp46_);
	g_variant_unref (_tmp46_);
	gala_desktop_integration_focus_window (self, uid, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_move_window_to_workspace (GalaDesktopIntegration* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint64 uid = 0ULL;
	GVariant* _tmp47_;
	gint index = 0;
	GVariant* _tmp48_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	uid = g_variant_get_uint64 (_tmp47_);
	g_variant_unref (_tmp47_);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_int32 (_tmp48_);
	g_variant_unref (_tmp48_);
	gala_desktop_integration_move_window_to_workspace (self, uid, index, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_activate_workspace (GalaDesktopIntegration* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint index = 0;
	GVariant* _tmp49_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp49_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_int32 (_tmp49_);
	g_variant_unref (_tmp49_);
	gala_desktop_integration_activate_workspace (self, index, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_get_n_workspaces (GalaDesktopIntegration* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = gala_desktop_integration_get_n_workspaces (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_get_active_workspace (GalaDesktopIntegration* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = gala_desktop_integration_get_active_workspace (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_show_windows_for (GalaDesktopIntegration* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_id = NULL;
	GVariant* _tmp50_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp50_ = g_variant_iter_next_value (&_arguments_iter);
	app_id = g_variant_dup_string (_tmp50_, NULL);
	g_variant_unref (_tmp50_);
	gala_desktop_integration_show_windows_for (self, app_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (app_id);
	;
}

static void
_dbus_gala_desktop_integration_reorder_workspace (GalaDesktopIntegration* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint index = 0;
	GVariant* _tmp51_;
	gint new_index = 0;
	GVariant* _tmp52_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp51_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_int32 (_tmp51_);
	g_variant_unref (_tmp51_);
	_tmp52_ = g_variant_iter_next_value (&_arguments_iter);
	new_index = g_variant_get_int32 (_tmp52_);
	g_variant_unref (_tmp52_);
	gala_desktop_integration_reorder_workspace (self, index, new_index, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_desktop_integration_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetRunningApplications") == 0) {
		_dbus_gala_desktop_integration_get_running_applications (object, parameters, invocation);
	} else if (strcmp (method_name, "GetWindows") == 0) {
		_dbus_gala_desktop_integration_get_windows (object, parameters, invocation);
	} else if (strcmp (method_name, "FocusWindow") == 0) {
		_dbus_gala_desktop_integration_focus_window (object, parameters, invocation);
	} else if (strcmp (method_name, "MoveWindowToWorkspace") == 0) {
		_dbus_gala_desktop_integration_move_window_to_workspace (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateWorkspace") == 0) {
		_dbus_gala_desktop_integration_activate_workspace (object, parameters, invocation);
	} else if (strcmp (method_name, "GetNWorkspaces") == 0) {
		_dbus_gala_desktop_integration_get_n_workspaces (object, parameters, invocation);
	} else if (strcmp (method_name, "GetActiveWorkspace") == 0) {
		_dbus_gala_desktop_integration_get_active_workspace (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowWindowsFor") == 0) {
		_dbus_gala_desktop_integration_show_windows_for (object, parameters, invocation);
	} else if (strcmp (method_name, "ReorderWorkspace") == 0) {
		_dbus_gala_desktop_integration_reorder_workspace (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_gala_desktop_integration_get_version (GalaDesktopIntegration* self)
{
	guint result;
	GVariant* _reply;
	result = gala_desktop_integration_get_version (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
gala_desktop_integration_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Version") == 0) {
		return _dbus_gala_desktop_integration_get_version (object);
	}
	return NULL;
}

static gboolean
gala_desktop_integration_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_desktop_integration_running_applications_changed (GObject* _sender,
                                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.DesktopIntegration", "RunningApplicationsChanged", _arguments, NULL);
}

static void
_dbus_gala_desktop_integration_windows_changed (GObject* _sender,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.DesktopIntegration", "WindowsChanged", _arguments, NULL);
}

static void
_dbus_gala_desktop_integration_active_workspace_changed (GObject* _sender,
                                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.DesktopIntegration", "ActiveWorkspaceChanged", _arguments, NULL);
}

static void
_dbus_gala_desktop_integration_workspace_removed (GObject* _sender,
                                                  gint index,
                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (index));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.DesktopIntegration", "WorkspaceRemoved", _arguments, NULL);
}

guint
gala_desktop_integration_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_desktop_integration_dbus_interface_info), &_gala_desktop_integration_dbus_interface_vtable, data, _gala_desktop_integration_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "running-applications-changed", (GCallback) _dbus_gala_desktop_integration_running_applications_changed, data);
	g_signal_connect (object, "windows-changed", (GCallback) _dbus_gala_desktop_integration_windows_changed, data);
	g_signal_connect (object, "active-workspace-changed", (GCallback) _dbus_gala_desktop_integration_active_workspace_changed, data);
	g_signal_connect (object, "workspace-removed", (GCallback) _dbus_gala_desktop_integration_workspace_removed, data);
	return result;
}

static void
_gala_desktop_integration_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_desktop_integration_running_applications_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_desktop_integration_windows_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_desktop_integration_active_workspace_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_desktop_integration_workspace_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

