/* gitg-ui-elements.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ui-elements.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <libpeas/peas.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libgitg-ext.h"
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_UI_ELEMENTS (gitg_ui_elements_get_type ())
#define GITG_UI_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_UI_ELEMENTS, GitgUIElements))
#define GITG_UI_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_UI_ELEMENTS, GitgUIElementsClass))
#define GITG_IS_UI_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_UI_ELEMENTS))
#define GITG_IS_UI_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_UI_ELEMENTS))
#define GITG_UI_ELEMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_UI_ELEMENTS, GitgUIElementsClass))

typedef struct _GitgUIElements GitgUIElements;
typedef struct _GitgUIElementsClass GitgUIElementsClass;
typedef struct _GitgUIElementsPrivate GitgUIElementsPrivate;
enum  {
	GITG_UI_ELEMENTS_0_PROPERTY,
	GITG_UI_ELEMENTS_T_TYPE,
	GITG_UI_ELEMENTS_T_DUP_FUNC,
	GITG_UI_ELEMENTS_T_DESTROY_FUNC,
	GITG_UI_ELEMENTS_CURRENT_PROPERTY,
	GITG_UI_ELEMENTS_NUM_PROPERTIES
};
static GParamSpec* gitg_ui_elements_properties[GITG_UI_ELEMENTS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef gboolean (*GitgUIElementsForeachUIElementFunc) (GitgExtUIElement* element, gpointer user_data);

struct _GitgUIElements {
	GObject parent_instance;
	GitgUIElementsPrivate * priv;
};

struct _GitgUIElementsClass {
	GObjectClass parent_class;
};

struct _GitgUIElementsPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	PeasExtensionSet* d_extensions;
	GeeHashMap* d_elements;
	GList* d_available_elements;
	GitgExtUIElement* d_current;
	GtkStack* d_stack;
	GeeHashMap* d_builtin_elements;
};

static gint GitgUIElements_private_offset;
static gpointer gitg_ui_elements_parent_class = NULL;

VALA_EXTERN GType gitg_ui_elements_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgUIElements, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN gpointer* gitg_ui_elements_get_available_elements (GitgUIElements* self,
                                                   gint* result_length1);
static void _vala_array_add28 (gpointer* * array,
                        gint* length,
                        gint* size,
                        gpointer value);
VALA_EXTERN void gitg_ui_elements_update (GitgUIElements* self);
static gboolean gitg_ui_elements_is_available (GitgUIElements* self,
                                        GitgExtUIElement* element);
static void gitg_ui_elements_remove_available (GitgUIElements* self,
                                        GitgExtUIElement* e);
static void gitg_ui_elements_add_available (GitgUIElements* self,
                                     GitgExtUIElement* e);
static void gitg_ui_elements_set_first_enabled_current (GitgUIElements* self);
static void gitg_ui_elements_set_current_impl (GitgUIElements* self,
                                        GitgExtUIElement* element);
VALA_EXTERN gpointer gitg_ui_elements_lookup (GitgUIElements* self,
                                  const gchar* id);
static gboolean gitg_ui_elements_order_after (GitgUIElements* self,
                                       GitgExtUIElement* a,
                                       GitgExtUIElement* b);
static void gitg_ui_elements_available_changed (GitgUIElements* self,
                                         GObject* o,
                                         GParamSpec* spec);
static void gitg_ui_elements_enabled_changed (GitgUIElements* self,
                                       GObject* o,
                                       GParamSpec* spec);
static void gitg_ui_elements_on_element_activate (GitgUIElements* self,
                                           GitgExtUIElement* e);
static void gitg_ui_elements_add_ui_element (GitgUIElements* self,
                                      GitgExtUIElement* e);
static void _gitg_ui_elements_available_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _gitg_ui_elements_enabled_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _gitg_ui_elements_on_element_activate_gitg_ext_ui_element_activate (GitgExtUIElement* _sender,
                                                                         gpointer self);
static void gitg_ui_elements_remove_ui_element (GitgUIElements* self,
                                         GitgExtUIElement* e);
static void gitg_ui_elements_extension_initial (GitgUIElements* self,
                                         PeasExtensionSet* s,
                                         PeasPluginInfo* info,
                                         GObject* obj);
static void gitg_ui_elements_extension_added (GitgUIElements* self,
                                       PeasExtensionSet* s,
                                       PeasPluginInfo* info,
                                       GObject* obj);
static void gitg_ui_elements_extension_removed (GitgUIElements* self,
                                         PeasExtensionSet* s,
                                         PeasPluginInfo* info,
                                         GObject* obj);
VALA_EXTERN void gitg_ui_elements_foreach (GitgUIElements* self,
                               GitgUIElementsForeachUIElementFunc func,
                               gpointer func_target);
static void gitg_ui_elements_on_visible_child_changed (GitgUIElements* self,
                                                GObject* obj,
                                                GParamSpec* pspec);
VALA_EXTERN GitgUIElements* gitg_ui_elements_new_with_builtin (GType t_type,
                                                   GBoxedCopyFunc t_dup_func,
                                                   GDestroyNotify t_destroy_func,
                                                   gpointer* builtin,
                                                   gint builtin_length1,
                                                   PeasExtensionSet* extensions,
                                                   GtkStack* stack);
VALA_EXTERN GitgUIElements* gitg_ui_elements_construct_with_builtin (GType object_type,
                                                         GType t_type,
                                                         GBoxedCopyFunc t_dup_func,
                                                         GDestroyNotify t_destroy_func,
                                                         gpointer* builtin,
                                                         gint builtin_length1,
                                                         PeasExtensionSet* extensions,
                                                         GtkStack* stack);
static void _gitg_ui_elements_extension_initial_peas_extension_set_foreach_func (PeasExtensionSet* set,
                                                                          PeasPluginInfo* info,
                                                                          PeasExtension* exten,
                                                                          gpointer self);
static void _gitg_ui_elements_extension_added_peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                           PeasPluginInfo* info,
                                                                           GObject* exten,
                                                                           gpointer self);
static void _gitg_ui_elements_extension_removed_peas_extension_set_extension_removed (PeasExtensionSet* _sender,
                                                                               PeasPluginInfo* info,
                                                                               GObject* exten,
                                                                               gpointer self);
static void _gitg_ui_elements_on_visible_child_changed_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
VALA_EXTERN GitgUIElements* gitg_ui_elements_new (GType t_type,
                                      GBoxedCopyFunc t_dup_func,
                                      GDestroyNotify t_destroy_func,
                                      PeasExtensionSet* extensions,
                                      GtkStack* stack);
VALA_EXTERN GitgUIElements* gitg_ui_elements_construct (GType object_type,
                                            GType t_type,
                                            GBoxedCopyFunc t_dup_func,
                                            GDestroyNotify t_destroy_func,
                                            PeasExtensionSet* extensions,
                                            GtkStack* stack);
VALA_EXTERN gconstpointer gitg_ui_elements_get_current (GitgUIElements* self);
VALA_EXTERN void gitg_ui_elements_set_current (GitgUIElements* self,
                                   gconstpointer value);
static void gitg_ui_elements_finalize (GObject * obj);
static GType gitg_ui_elements_get_type_once (void);
static void _vala_gitg_ui_elements_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_gitg_ui_elements_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_ui_elements_get_instance_private (GitgUIElements* self)
{
	return G_STRUCT_MEMBER_P (self, GitgUIElements_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add28 (gpointer* * array,
                   gint* length,
                   gint* size,
                   gpointer value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gpointer, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gpointer*
gitg_ui_elements_get_available_elements (GitgUIElements* self,
                                         gint* result_length1)
{
	gpointer* ret = NULL;
	gpointer* _tmp0_;
	gint ret_length1;
	gint _ret_size_;
	GList* _tmp1_;
	gpointer* _tmp5_;
	gint _tmp5__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gpointer, 0);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = self->priv->d_available_elements;
	{
		GList* elem_collection = NULL;
		GList* elem_it = NULL;
		elem_collection = _tmp1_;
		for (elem_it = elem_collection; elem_it != NULL; elem_it = elem_it->next) {
			GitgExtUIElement* _tmp2_;
			GitgExtUIElement* elem = NULL;
			_tmp2_ = _g_object_ref0 ((GitgExtUIElement*) elem_it->data);
			elem = _tmp2_;
			{
				GitgExtUIElement* _tmp3_;
				gpointer _tmp4_;
				_tmp3_ = elem;
				_tmp4_ = ((((gconstpointer) _tmp3_) != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) ((gconstpointer) _tmp3_)) : ((gpointer) ((gconstpointer) _tmp3_));
				_vala_array_add28 (&ret, &ret_length1, &_ret_size_, _tmp4_);
				_g_object_unref0 (elem);
			}
		}
	}
	_tmp5_ = ret;
	_tmp5__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

void
gitg_ui_elements_update (GitgUIElements* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _elem_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->d_elements;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_elem_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GitgExtUIElement* elem = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			gboolean wasavail = FALSE;
			GitgExtUIElement* _tmp9_;
			gboolean isavail = FALSE;
			GitgExtUIElement* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp6_ = _elem_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _elem_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			elem = (GitgExtUIElement*) _tmp8_;
			_tmp9_ = elem;
			wasavail = gitg_ui_elements_is_available (self, _tmp9_);
			_tmp10_ = elem;
			_tmp11_ = gitg_ext_ui_element_get_available (_tmp10_);
			_tmp12_ = _tmp11_;
			isavail = _tmp12_;
			if (wasavail) {
				_tmp13_ = !isavail;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GitgExtUIElement* _tmp14_;
				_tmp14_ = elem;
				gitg_ui_elements_remove_available (self, _tmp14_);
			} else {
				gboolean _tmp15_ = FALSE;
				if (!wasavail) {
					_tmp15_ = isavail;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					GitgExtUIElement* _tmp16_;
					_tmp16_ = elem;
					gitg_ui_elements_add_available (self, _tmp16_);
				} else {
					if (wasavail) {
						gboolean _tmp17_ = FALSE;
						GitgExtUIElement* _tmp18_;
						gboolean _tmp19_;
						gboolean _tmp20_;
						_tmp18_ = elem;
						_tmp19_ = gitg_ext_ui_element_get_enabled (_tmp18_);
						_tmp20_ = _tmp19_;
						if (!_tmp20_) {
							GitgExtUIElement* _tmp21_;
							GitgExtUIElement* _tmp22_;
							_tmp21_ = self->priv->d_current;
							_tmp22_ = elem;
							_tmp17_ = _tmp21_ == _tmp22_;
						} else {
							_tmp17_ = FALSE;
						}
						if (_tmp17_) {
							_g_object_unref0 (self->priv->d_current);
							self->priv->d_current = NULL;
						}
					}
				}
			}
			_g_object_unref0 (elem);
		}
		_g_object_unref0 (_elem_it);
	}
	gitg_ui_elements_set_first_enabled_current (self);
}

static void
gitg_ui_elements_set_first_enabled_current (GitgUIElements* self)
{
	GitgExtUIElement* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_current;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->d_available_elements;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GitgExtUIElement* _tmp2_;
			GitgExtUIElement* item = NULL;
			_tmp2_ = _g_object_ref0 ((GitgExtUIElement*) item_it->data);
			item = _tmp2_;
			{
				GitgExtUIElement* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = item;
				_tmp4_ = gitg_ext_ui_element_get_enabled (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_) {
					GitgExtUIElement* _tmp6_;
					_tmp6_ = item;
					gitg_ui_elements_set_current_impl (self, _tmp6_);
					_g_object_unref0 (item);
					break;
				}
				_g_object_unref0 (item);
			}
		}
	}
}

gpointer
gitg_ui_elements_lookup (GitgUIElements* self,
                         const gchar* id)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->d_elements;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, id);
	result = (gpointer) ((GitgExtUIElement*) _tmp1_);
	return result;
}

static gboolean
gitg_ui_elements_is_available (GitgUIElements* self,
                               GitgExtUIElement* element)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element != NULL, FALSE);
	_tmp0_ = self->priv->d_available_elements;
	_tmp1_ = g_list_find (_tmp0_, element);
	result = _tmp1_ != NULL;
	return result;
}

static void
gitg_ui_elements_set_current_impl (GitgUIElements* self,
                                   GitgExtUIElement* element)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GitgExtUIElement* _tmp10_;
	GitgExtUIElement* _tmp11_;
	GtkStack* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp3_ = gitg_ext_ui_element_get_available (element);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = gitg_ext_ui_element_get_enabled (element);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		GitgExtUIElement* _tmp8_;
		_tmp8_ = self->priv->d_current;
		if (_tmp8_ != NULL) {
			GitgExtUIElement* _tmp9_;
			_tmp9_ = self->priv->d_current;
			_tmp7_ = _tmp9_ == element;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !gitg_ui_elements_is_available (self, element);
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = self->priv->d_current;
	if (_tmp10_ == element) {
		return;
	}
	_tmp11_ = _g_object_ref0 (element);
	_g_object_unref0 (self->priv->d_current);
	self->priv->d_current = _tmp11_;
	_tmp12_ = self->priv->d_stack;
	if (_tmp12_ != NULL) {
		GtkStack* _tmp13_;
		GtkWidget* _tmp14_;
		GtkWidget* _tmp15_;
		GtkWidget* _tmp16_;
		_tmp13_ = self->priv->d_stack;
		_tmp14_ = gitg_ext_ui_element_get_widget (element);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		gtk_stack_set_visible_child (_tmp13_, _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	g_object_notify ((GObject*) self, "current");
	g_signal_emit_by_name (element, "activate");
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
gitg_ui_elements_remove_available (GitgUIElements* self,
                                   GitgExtUIElement* e)
{
	GitgExtUIElement* _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	if (!gitg_ui_elements_is_available (self, e)) {
		return;
	}
	_tmp0_ = self->priv->d_current;
	if (e == _tmp0_) {
		_g_object_unref0 (self->priv->d_current);
		self->priv->d_current = NULL;
	}
	_tmp1_ = self->priv->d_stack;
	_tmp2_ = gitg_ext_ui_element_get_widget (e);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	gtk_container_remove ((GtkContainer*) _tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	self->priv->d_available_elements = vala_g_list_remove_full (self->priv->d_available_elements, e, _g_object_unref0_);
}

static gboolean
gitg_ui_elements_order_after (GitgUIElements* self,
                              GitgExtUIElement* a,
                              GitgExtUIElement* b)
{
	gboolean ab = FALSE;
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean bb = FALSE;
	GeeHashMap* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp11_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = self->priv->d_builtin_elements;
	_tmp1_ = gitg_ext_ui_element_get_id (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	ab = _tmp4_;
	_tmp5_ = self->priv->d_builtin_elements;
	_tmp6_ = gitg_ext_ui_element_get_id (b);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	bb = _tmp9_;
	if (ab != bb) {
		gboolean _tmp10_ = FALSE;
		if (ab) {
			_tmp10_ = FALSE;
		} else {
			_tmp10_ = TRUE;
		}
		result = _tmp10_;
		return result;
	}
	if (ab) {
		_tmp11_ = bb;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gint ai = 0;
		GeeHashMap* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gpointer _tmp16_;
		gint _tmp17_;
		gint bi = 0;
		GeeHashMap* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gpointer _tmp22_;
		gint _tmp23_;
		_tmp12_ = self->priv->d_builtin_elements;
		_tmp13_ = gitg_ext_ui_element_get_id (a);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp15_);
		_tmp17_ = (gint) ((gintptr) _tmp16_);
		_g_free0 (_tmp15_);
		ai = _tmp17_;
		_tmp18_ = self->priv->d_builtin_elements;
		_tmp19_ = gitg_ext_ui_element_get_id (b);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp21_);
		_tmp23_ = (gint) ((gintptr) _tmp22_);
		_g_free0 (_tmp21_);
		bi = _tmp23_;
		result = ai > bi;
		return result;
	}
	result = gitg_ext_ui_element_negotiate_order (a, b) > 0;
	return result;
}

static void
gitg_ui_elements_add_available (GitgUIElements* self,
                                GitgExtUIElement* e)
{
	gint insert_position = 0;
	GList* item = NULL;
	GList* _tmp0_;
	GitgExtUIElement* _tmp8_;
	GtkStack* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	insert_position = 0;
	_tmp0_ = self->priv->d_available_elements;
	item = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		GList* _tmp2_;
		GList* _tmp5_;
		GList* _tmp6_;
		gint _tmp7_;
		_tmp2_ = item;
		if (_tmp2_ != NULL) {
			GList* _tmp3_;
			gconstpointer _tmp4_;
			_tmp3_ = item;
			_tmp4_ = _tmp3_->data;
			_tmp1_ = gitg_ui_elements_order_after (self, e, (GitgExtUIElement*) _tmp4_);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = item;
		_tmp6_ = _tmp5_->next;
		item = _tmp6_;
		_tmp7_ = insert_position;
		insert_position = _tmp7_ + 1;
	}
	_tmp8_ = _g_object_ref0 (e);
	self->priv->d_available_elements = g_list_insert (self->priv->d_available_elements, _tmp8_, insert_position);
	_tmp9_ = self->priv->d_stack;
	_tmp10_ = gitg_ext_ui_element_get_widget (e);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = gitg_ext_ui_element_get_id (e);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = gitg_ext_ui_element_get_description (e);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = gitg_ext_ui_element_get_icon (e);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	gtk_container_add_with_properties ((GtkContainer*) _tmp9_, _tmp12_, "name", _tmp15_, "title", _tmp18_, "icon-name", _tmp21_, "position", insert_position, NULL);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_object_unref0 (_tmp12_);
}

static void
gitg_ui_elements_available_changed (GitgUIElements* self,
                                    GObject* o,
                                    GParamSpec* spec)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (spec != NULL);
	gitg_ui_elements_update (self);
}

static void
gitg_ui_elements_enabled_changed (GitgUIElements* self,
                                  GObject* o,
                                  GParamSpec* spec)
{
	GitgExtUIElement* e = NULL;
	GitgExtUIElement* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (o, GITG_EXT_TYPE_UI_ELEMENT) ? ((GitgExtUIElement*) o) : NULL);
	e = _tmp0_;
	_tmp1_ = gitg_ext_ui_element_get_widget (e);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_ext_ui_element_get_enabled (e);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive (_tmp3_, _tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (e);
}

static void
gitg_ui_elements_on_element_activate (GitgUIElements* self,
                                      GitgExtUIElement* e)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	gitg_ui_elements_set_current_impl (self, e);
}

static void
_gitg_ui_elements_available_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	gitg_ui_elements_available_changed ((GitgUIElements*) self, _sender, pspec);
}

static void
_gitg_ui_elements_enabled_changed_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	gitg_ui_elements_enabled_changed ((GitgUIElements*) self, _sender, pspec);
}

static void
_gitg_ui_elements_on_element_activate_gitg_ext_ui_element_activate (GitgExtUIElement* _sender,
                                                                    gpointer self)
{
	gitg_ui_elements_on_element_activate ((GitgUIElements*) self, _sender);
}

static void
gitg_ui_elements_add_ui_element (GitgUIElements* self,
                                 GitgExtUIElement* e)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = self->priv->d_elements;
	_tmp1_ = gitg_ext_ui_element_get_id (e);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, e);
	_g_free0 (_tmp3_);
	_tmp4_ = gitg_ext_ui_element_get_available (e);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		gitg_ui_elements_add_available (self, e);
	}
	g_signal_connect_object ((GObject*) e, "notify::available", (GCallback) _gitg_ui_elements_available_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) e, "notify::enabled", (GCallback) _gitg_ui_elements_enabled_changed_g_object_notify, self, 0);
	g_signal_connect_object (e, "activate", (GCallback) _gitg_ui_elements_on_element_activate_gitg_ext_ui_element_activate, self, 0);
}

static void
gitg_ui_elements_remove_ui_element (GitgUIElements* self,
                                    GitgExtUIElement* e)
{
	guint _tmp0_;
	GQuark _tmp1_;
	guint _tmp2_;
	GeeHashMap* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	gitg_ui_elements_remove_available (self, e);
	g_signal_parse_name ("notify::available", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) e, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _gitg_ui_elements_available_changed_g_object_notify, self);
	g_signal_parse_name ("activate", GITG_EXT_TYPE_UI_ELEMENT, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (e, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gitg_ui_elements_on_element_activate_gitg_ext_ui_element_activate, self);
	_tmp3_ = self->priv->d_elements;
	_tmp4_ = gitg_ext_ui_element_get_id (e);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, _tmp6_, NULL);
	_g_free0 (_tmp6_);
}

static void
gitg_ui_elements_extension_initial (GitgUIElements* self,
                                    PeasExtensionSet* s,
                                    PeasPluginInfo* info,
                                    GObject* obj)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (obj != NULL);
	gitg_ui_elements_add_ui_element (self, G_TYPE_CHECK_INSTANCE_TYPE (obj, GITG_EXT_TYPE_UI_ELEMENT) ? ((GitgExtUIElement*) obj) : NULL);
}

static void
gitg_ui_elements_extension_added (GitgUIElements* self,
                                  PeasExtensionSet* s,
                                  PeasPluginInfo* info,
                                  GObject* obj)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (obj != NULL);
	gitg_ui_elements_add_ui_element (self, G_TYPE_CHECK_INSTANCE_TYPE (obj, GITG_EXT_TYPE_UI_ELEMENT) ? ((GitgExtUIElement*) obj) : NULL);
	gitg_ui_elements_set_first_enabled_current (self);
}

static void
gitg_ui_elements_extension_removed (GitgUIElements* self,
                                    PeasExtensionSet* s,
                                    PeasPluginInfo* info,
                                    GObject* obj)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (obj != NULL);
	gitg_ui_elements_remove_ui_element (self, G_TYPE_CHECK_INSTANCE_TYPE (obj, GITG_EXT_TYPE_UI_ELEMENT) ? ((GitgExtUIElement*) obj) : NULL);
}

void
gitg_ui_elements_foreach (GitgUIElements* self,
                          GitgUIElementsForeachUIElementFunc func,
                          gpointer func_target)
{
	GList* vals = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_available_elements;
	_tmp1_ = g_list_copy (_tmp0_);
	vals = _tmp1_;
	_tmp2_ = vals;
	{
		GList* val_collection = NULL;
		GList* val_it = NULL;
		val_collection = _tmp2_;
		for (val_it = val_collection; val_it != NULL; val_it = val_it->next) {
			GitgExtUIElement* val = NULL;
			val = (GitgExtUIElement*) val_it->data;
			{
				GitgExtUIElement* _tmp3_;
				_tmp3_ = val;
				if (!func (_tmp3_, func_target)) {
					break;
				}
			}
		}
	}
	(vals == NULL) ? NULL : (vals = (g_list_free (vals), NULL));
}

static void
gitg_ui_elements_on_visible_child_changed (GitgUIElements* self,
                                           GObject* obj,
                                           GParamSpec* pspec)
{
	gchar* name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->d_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	if (_tmp3_ != NULL) {
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_;
		GitgExtUIElement* _tmp7_;
		_tmp4_ = self->priv->d_elements;
		_tmp5_ = name;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (GitgExtUIElement*) _tmp6_;
		gitg_ui_elements_set_current_impl (self, _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
	_g_free0 (name);
}

static void
_gitg_ui_elements_extension_initial_peas_extension_set_foreach_func (PeasExtensionSet* set,
                                                                     PeasPluginInfo* info,
                                                                     PeasExtension* exten,
                                                                     gpointer self)
{
	gitg_ui_elements_extension_initial ((GitgUIElements*) self, set, info, exten);
}

static void
_gitg_ui_elements_extension_added_peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                      PeasPluginInfo* info,
                                                                      GObject* exten,
                                                                      gpointer self)
{
	gitg_ui_elements_extension_added ((GitgUIElements*) self, _sender, info, exten);
}

static void
_gitg_ui_elements_extension_removed_peas_extension_set_extension_removed (PeasExtensionSet* _sender,
                                                                          PeasPluginInfo* info,
                                                                          GObject* exten,
                                                                          gpointer self)
{
	gitg_ui_elements_extension_removed ((GitgUIElements*) self, _sender, info, exten);
}

static void
_gitg_ui_elements_on_visible_child_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	gitg_ui_elements_on_visible_child_changed ((GitgUIElements*) self, _sender, pspec);
}

GitgUIElements*
gitg_ui_elements_construct_with_builtin (GType object_type,
                                         GType t_type,
                                         GBoxedCopyFunc t_dup_func,
                                         GDestroyNotify t_destroy_func,
                                         gpointer* builtin,
                                         gint builtin_length1,
                                         PeasExtensionSet* extensions,
                                         GtkStack* stack)
{
	GitgUIElements * self = NULL;
	PeasExtensionSet* _tmp0_;
	GtkStack* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	gint i = 0;
	PeasExtensionSet* _tmp14_;
	PeasExtensionSet* _tmp15_;
	PeasExtensionSet* _tmp16_;
	GtkStack* _tmp17_;
	g_return_val_if_fail (extensions != NULL, NULL);
	self = (GitgUIElements*) g_object_new (object_type, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = _g_object_ref0 (extensions);
	_g_object_unref0 (self->priv->d_extensions);
	self->priv->d_extensions = _tmp0_;
	_tmp1_ = _g_object_ref0 (stack);
	_g_object_unref0 (self->priv->d_stack);
	self->priv->d_stack = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_builtin_elements);
	self->priv->d_builtin_elements = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_EXT_TYPE_UI_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_elements);
	self->priv->d_elements = _tmp3_;
	i = 0;
	{
		gpointer* b_collection = NULL;
		gint b_collection_length1 = 0;
		gint _b_collection_size_ = 0;
		gint b_it = 0;
		b_collection = builtin;
		b_collection_length1 = builtin_length1;
		for (b_it = 0; b_it < b_collection_length1; b_it = b_it + 1) {
			gpointer _tmp4_;
			gpointer b = NULL;
			_tmp4_ = ((b_collection[b_it] != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) b_collection[b_it]) : ((gpointer) b_collection[b_it]);
			b = _tmp4_;
			{
				GitgExtUIElement* elem = NULL;
				gconstpointer _tmp5_;
				GitgExtUIElement* _tmp6_;
				GeeHashMap* _tmp7_;
				GitgExtUIElement* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gint _tmp12_;
				GitgExtUIElement* _tmp13_;
				_tmp5_ = b;
				_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GITG_EXT_TYPE_UI_ELEMENT, GitgExtUIElement));
				elem = _tmp6_;
				_tmp7_ = self->priv->d_builtin_elements;
				_tmp8_ = elem;
				_tmp9_ = gitg_ext_ui_element_get_id (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_;
				_tmp12_ = i;
				i = _tmp12_ + 1;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp11_, (gpointer) ((gintptr) _tmp12_));
				_g_free0 (_tmp11_);
				_tmp13_ = elem;
				gitg_ui_elements_add_ui_element (self, _tmp13_);
				_g_object_unref0 (elem);
				((b == NULL) || (t_destroy_func == NULL)) ? NULL : (b = (t_destroy_func (b), NULL));
			}
		}
	}
	_tmp14_ = self->priv->d_extensions;
	peas_extension_set_foreach (_tmp14_, _gitg_ui_elements_extension_initial_peas_extension_set_foreach_func, self);
	gitg_ui_elements_set_first_enabled_current (self);
	_tmp15_ = self->priv->d_extensions;
	g_signal_connect_object (_tmp15_, "extension-added", (GCallback) _gitg_ui_elements_extension_added_peas_extension_set_extension_added, self, 0);
	_tmp16_ = self->priv->d_extensions;
	g_signal_connect_object (_tmp16_, "extension-removed", (GCallback) _gitg_ui_elements_extension_removed_peas_extension_set_extension_removed, self, 0);
	_tmp17_ = self->priv->d_stack;
	if (_tmp17_ != NULL) {
		GtkStack* _tmp18_;
		_tmp18_ = self->priv->d_stack;
		g_signal_connect_object ((GObject*) _tmp18_, "notify::visible-child", (GCallback) _gitg_ui_elements_on_visible_child_changed_g_object_notify, self, 0);
	}
	return self;
}

GitgUIElements*
gitg_ui_elements_new_with_builtin (GType t_type,
                                   GBoxedCopyFunc t_dup_func,
                                   GDestroyNotify t_destroy_func,
                                   gpointer* builtin,
                                   gint builtin_length1,
                                   PeasExtensionSet* extensions,
                                   GtkStack* stack)
{
	return gitg_ui_elements_construct_with_builtin (GITG_TYPE_UI_ELEMENTS, t_type, t_dup_func, t_destroy_func, builtin, builtin_length1, extensions, stack);
}

GitgUIElements*
gitg_ui_elements_construct (GType object_type,
                            GType t_type,
                            GBoxedCopyFunc t_dup_func,
                            GDestroyNotify t_destroy_func,
                            PeasExtensionSet* extensions,
                            GtkStack* stack)
{
	GitgUIElements * self = NULL;
	gpointer* _tmp0_;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (extensions != NULL, NULL);
	_tmp0_ = g_new0 (gpointer, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	self = (GitgUIElements*) gitg_ui_elements_construct_with_builtin (object_type, t_type, t_dup_func, t_destroy_func, _tmp1_, (gint) 0, extensions, stack);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) t_destroy_func), NULL);
	return self;
}

GitgUIElements*
gitg_ui_elements_new (GType t_type,
                      GBoxedCopyFunc t_dup_func,
                      GDestroyNotify t_destroy_func,
                      PeasExtensionSet* extensions,
                      GtkStack* stack)
{
	return gitg_ui_elements_construct (GITG_TYPE_UI_ELEMENTS, t_type, t_dup_func, t_destroy_func, extensions, stack);
}

gconstpointer
gitg_ui_elements_get_current (GitgUIElements* self)
{
	gconstpointer result;
	GitgExtUIElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_current;
	if (_tmp0_ != NULL) {
		GitgExtUIElement* _tmp1_;
		_tmp1_ = self->priv->d_current;
		result = (gconstpointer) _tmp1_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

void
gitg_ui_elements_set_current (GitgUIElements* self,
                              gconstpointer value)
{
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		gitg_ui_elements_set_current_impl (self, G_TYPE_CHECK_INSTANCE_CAST (value, GITG_EXT_TYPE_UI_ELEMENT, GitgExtUIElement));
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_ui_elements_properties[GITG_UI_ELEMENTS_CURRENT_PROPERTY]);
}

static void
gitg_ui_elements_class_init (GitgUIElementsClass * klass,
                             gpointer klass_data)
{
	gitg_ui_elements_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgUIElements_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ui_elements_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ui_elements_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_ui_elements_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_UI_ELEMENTS_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_UI_ELEMENTS_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_UI_ELEMENTS_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_UI_ELEMENTS_CURRENT_PROPERTY, gitg_ui_elements_properties[GITG_UI_ELEMENTS_CURRENT_PROPERTY] = g_param_spec_pointer ("current", "current", "current", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gitg_ui_elements_instance_init (GitgUIElements * self,
                                gpointer klass)
{
	self->priv = gitg_ui_elements_get_instance_private (self);
}

static void
gitg_ui_elements_finalize (GObject * obj)
{
	GitgUIElements * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_UI_ELEMENTS, GitgUIElements);
	_g_object_unref0 (self->priv->d_extensions);
	_g_object_unref0 (self->priv->d_elements);
	(self->priv->d_available_elements == NULL) ? NULL : (self->priv->d_available_elements = (_g_list_free__g_object_unref0_ (self->priv->d_available_elements), NULL));
	_g_object_unref0 (self->priv->d_current);
	_g_object_unref0 (self->priv->d_stack);
	_g_object_unref0 (self->priv->d_builtin_elements);
	G_OBJECT_CLASS (gitg_ui_elements_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_ui_elements_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgUIElementsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ui_elements_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgUIElements), 0, (GInstanceInitFunc) gitg_ui_elements_instance_init, NULL };
	GType gitg_ui_elements_type_id;
	gitg_ui_elements_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgUIElements", &g_define_type_info, 0);
	GitgUIElements_private_offset = g_type_add_instance_private (gitg_ui_elements_type_id, sizeof (GitgUIElementsPrivate));
	return gitg_ui_elements_type_id;
}

GType
gitg_ui_elements_get_type (void)
{
	static gsize gitg_ui_elements_type_id__once = 0;
	if (g_once_init_enter (&gitg_ui_elements_type_id__once)) {
		GType gitg_ui_elements_type_id;
		gitg_ui_elements_type_id = gitg_ui_elements_get_type_once ();
		g_once_init_leave (&gitg_ui_elements_type_id__once, gitg_ui_elements_type_id);
	}
	return gitg_ui_elements_type_id__once;
}

static void
_vala_gitg_ui_elements_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GitgUIElements * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_UI_ELEMENTS, GitgUIElements);
	switch (property_id) {
		case GITG_UI_ELEMENTS_CURRENT_PROPERTY:
		g_value_set_pointer (value, gitg_ui_elements_get_current (self));
		break;
		case GITG_UI_ELEMENTS_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case GITG_UI_ELEMENTS_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case GITG_UI_ELEMENTS_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_ui_elements_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GitgUIElements * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_UI_ELEMENTS, GitgUIElements);
	switch (property_id) {
		case GITG_UI_ELEMENTS_CURRENT_PROPERTY:
		gitg_ui_elements_set_current (self, g_value_get_pointer (value));
		break;
		case GITG_UI_ELEMENTS_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case GITG_UI_ELEMENTS_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case GITG_UI_ELEMENTS_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

