/* game-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-window.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "libgnome-games-support.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_CLI_COLS_PROPERTY,
	GAME_WINDOW_CLI_ROWS_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWENTY_FORTY_EIGHT (twenty_forty_eight_get_type ())
#define TWENTY_FORTY_EIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEight))
#define TWENTY_FORTY_EIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEightClass))
#define IS_TWENTY_FORTY_EIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWENTY_FORTY_EIGHT))
#define IS_TWENTY_FORTY_EIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWENTY_FORTY_EIGHT))
#define TWENTY_FORTY_EIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWENTY_FORTY_EIGHT, TwentyFortyEightClass))

typedef struct _TwentyFortyEight TwentyFortyEight;
typedef struct _TwentyFortyEightClass TwentyFortyEightClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GAME_WINDOW_POPOVER_CLOSED_SIGNAL,
	GAME_WINDOW_NUM_SIGNALS
};
static guint game_window_signals[GAME_WINDOW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GameWindow {
	AdwApplicationWindow parent_instance;
	GameWindowPrivate * priv;
};

struct _GameWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	GSettings* _settings;
	AdwHeaderBar* _header_bar;
	GtkLabel* _score;
	GtkMenuButton* _new_game_button;
	GtkMenuButton* _hamburger_button;
	AdwWindowTitle* _window_title;
	Game* _game;
	GtkButton* _unfullscreen_button;
	guint8 _cli_cols;
	guint8 _cli_rows;
	GSimpleAction* undo_action;
	GamesScoresContext* _scores_ctx;
	GamesScoresCategory* _grid4_cat;
	GamesScoresCategory* _grid3_cat;
	GamesScoresCategory* _grid5_cat;
};

static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;

VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void game_window_new_game_sized_cb (GameWindow* self,
                                    GSimpleAction* action,
                                    GVariant* variant);
static void _game_window_new_game_sized_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void game_window_toggle_new_game_cb (GameWindow* self);
static void _game_window_toggle_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void game_window_toggle_hamburger_menu (GameWindow* self);
static void _game_window_toggle_hamburger_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static inline void game_window_scores_cb (GameWindow* self);
static void _game_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void game_window_about_cb (GameWindow* self);
static void _game_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void _gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
VALA_EXTERN GType twenty_forty_eight_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TwentyFortyEight, g_object_unref)
VALA_EXTERN GameWindow* game_window_new (TwentyFortyEight* application,
                             guint8 cols,
                             guint8 rows);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   TwentyFortyEight* application,
                                   guint8 cols,
                                   guint8 rows);
VALA_EXTERN gboolean game_restore_game (Game* self,
                            GSettings** settings);
static void _game_window_init_game (GameWindow* self);
static guint8 game_window_get_cli_cols (GameWindow* self);
static guint8 game_window_get_cli_rows (GameWindow* self);
VALA_EXTERN void game_window_set_score (GameWindow* self,
                            GObject* game,
                            GParamSpec* unused);
static void _game_window_set_score_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self);
static void __lambda9_ (GameWindow* self,
                 gboolean show_scores);
VALA_EXTERN void game_window_finished (GameWindow* self);
static inline void _game_window_show_best_scores (GameWindow* self);
static void ___lambda9__game_finished (Game* _sender,
                                gboolean show_scores,
                                gpointer self);
static inline void game_window_target_value_reached_cb (GameWindow* self,
                                          guint target_value);
static void _game_window_target_value_reached_cb_game_target_value_reached (Game* _sender,
                                                                     guint val,
                                                                     gpointer self);
static void __lambda12_ (GameWindow* self);
static void ___lambda12__game_undo_enabled (Game* _sender,
                                     gpointer self);
static void __lambda13_ (GameWindow* self);
static void ___lambda13__game_undo_disabled (Game* _sender,
                                      gpointer self);
static void _game_window_init_window (GameWindow* self);
static void __lambda14_ (GameWindow* self);
static void ___lambda14__game_window_popover_closed (GameWindow* _sender,
                                              gpointer self);
static void __lambda15_ (GameWindow* self,
                  GSettings* settings,
                  const gchar* key_name);
VALA_EXTERN void _game_window_update_new_game_menu (GameWindow* self,
                                        guint8 rows,
                                        guint8 cols);
VALA_EXTERN void _game_window_update_hamburger_menu (GameWindow* self,
                                         gboolean allow_undo);
VALA_EXTERN void game_load_settings (Game* self,
                         GSettings** settings);
static void ___lambda15__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void game_window_test_popover_closed (GameWindow* self);
VALA_EXTERN gboolean game_window_has_popover (GameWindow* self);
VALA_EXTERN void game_window_clear_subtitle (GameWindow* self);
VALA_EXTERN glong game_get_score (Game* self);
static inline void _game_window_append_undo_section (GMenu** menu);
static inline void _game_window_append_scores_section (GMenu** menu);
static inline void _game_window_append_app_actions_section (GMenu** menu);
static void _game_window_append_new_game_item (const gchar* label,
                                        guint8 rows,
                                        guint8 cols,
                                        GMenu** menu);
VALA_EXTERN gboolean grid_is_disallowed_grid_size (guint8* rows,
                                       guint8* cols);
static void _game_window_install_ui_action_entries (GameWindow* self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_new_game (Game* self,
                    GSettings** settings);
static void ___lambda11_ (GameWindow* self,
                   const gchar* response);
static void ____lambda11__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                              const gchar* response,
                                              gpointer self);
static inline void _game_window_create_scores_dialog (GameWindow* self);
static inline GamesScoresCategory* game_window_category_request (GameWindow* self,
                                                   const gchar* key);
static GamesScoresCategory* _game_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                               gpointer self);
static void __lambda10_ (GameWindow* self,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void game_window_set_cli_cols (GameWindow* self,
                               guint8 value);
static void game_window_set_cli_rows (GameWindow* self,
                               guint8 value);
static GObject * game_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _game_window_test_popover_closed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _game_window___lambda16_ (GameWindow* self);
static void __game_window___lambda16__g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static gboolean _game_window___lambda17_ (GameWindow* self);
VALA_EXTERN void game_save_game (Game* self);
static gboolean __game_window___lambda17__gtk_window_close_request (GtkWindow* _sender,
                                                             gpointer self);
static void game_window_finalize (GObject * obj);
static GType game_window_get_type_once (void);
static void _vala_game_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_game_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry GAME_WINDOW__ui_action_entries[8] = {{"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"new-game-sized", _game_window_new_game_sized_cb_gsimple_action_activate_callback, "(yy)"}, {"toggle-new-game", _game_window_toggle_new_game_cb_gsimple_action_activate_callback}, {"toggle-hamburger", _game_window_toggle_hamburger_menu_gsimple_action_activate_callback}, {"scores", _game_window_scores_cb_gsimple_action_activate_callback}, {"about", _game_window_about_cb_gsimple_action_activate_callback}, {"unfullscreen", _gtk_window_unfullscreen_gsimple_action_activate_callback}};

static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}

static void
_game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_undo_cb ((GameWindow*) self);
}

static void
_game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	game_window_new_game_cb ((GameWindow*) self);
}

static void
_game_window_new_game_sized_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	game_window_new_game_sized_cb ((GameWindow*) self, action, parameter);
}

static void
_game_window_toggle_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	game_window_toggle_new_game_cb ((GameWindow*) self);
}

static void
_game_window_toggle_hamburger_menu_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	game_window_toggle_hamburger_menu ((GameWindow*) self);
}

static void
_game_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	game_window_scores_cb ((GameWindow*) self);
}

static void
_game_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	game_window_about_cb ((GameWindow*) self);
}

static void
_gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	gtk_window_unfullscreen ((GtkWindow*) self);
}

GameWindow*
game_window_construct (GType object_type,
                       TwentyFortyEight* application,
                       guint8 cols,
                       guint8 rows)
{
	GameWindow * self = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (application != NULL, NULL);
	self = (GameWindow*) g_object_new (object_type, "application", application, "visible", TRUE, "cli-cols", cols, "cli-rows", rows, NULL);
	if (((gint) cols) != 0) {
		_tmp0_ = ((gint) rows) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		game_window_new_game_cb (self);
	} else {
		Game* _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = self->priv->_game;
		_tmp2_ = game_restore_game (_tmp1_, &self->priv->_settings);
		if (!_tmp2_) {
			game_window_new_game_cb (self);
		}
	}
	return self;
}

GameWindow*
game_window_new (TwentyFortyEight* application,
                 guint8 cols,
                 guint8 rows)
{
	return game_window_construct (TYPE_GAME_WINDOW, application, cols, rows);
}

static void
_game_window_set_score_g_object_notify (GObject* _sender,
                                        GParamSpec* pspec,
                                        gpointer self)
{
	game_window_set_score ((GameWindow*) self, _sender, pspec);
}

static void
__lambda9_ (GameWindow* self,
            gboolean show_scores)
{
	game_window_finished (self);
	if (show_scores) {
		_game_window_show_best_scores (self);
	}
	g_debug ("game-window.vala:103: finished");
}

static void
___lambda9__game_finished (Game* _sender,
                           gboolean show_scores,
                           gpointer self)
{
	__lambda9_ ((GameWindow*) self, show_scores);
}

static void
_game_window_target_value_reached_cb_game_target_value_reached (Game* _sender,
                                                                guint val,
                                                                gpointer self)
{
	game_window_target_value_reached_cb ((GameWindow*) self, val);
}

static void
__lambda12_ (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
}

static void
___lambda12__game_undo_enabled (Game* _sender,
                                gpointer self)
{
	__lambda12_ ((GameWindow*) self);
}

static void
__lambda13_ (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
}

static void
___lambda13__game_undo_disabled (Game* _sender,
                                 gpointer self)
{
	__lambda13_ ((GameWindow*) self);
}

static void
_game_window_init_game (GameWindow* self)
{
	gboolean _tmp0_ = FALSE;
	guint8 _tmp1_;
	Game* _tmp9_;
	Game* _tmp10_;
	Game* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_cli_cols;
	if (((gint) _tmp1_) != 0) {
		guint8 _tmp2_;
		_tmp2_ = self->priv->_cli_rows;
		_tmp0_ = ((gint) _tmp2_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		guint8 _tmp5_;
		GSettings* _tmp6_;
		guint8 _tmp7_;
		GSettings* _tmp8_;
		_tmp3_ = self->priv->_settings;
		g_settings_delay (_tmp3_);
		_tmp4_ = self->priv->_settings;
		_tmp5_ = self->priv->_cli_cols;
		g_settings_set_int (_tmp4_, "cols", (gint) _tmp5_);
		_tmp6_ = self->priv->_settings;
		_tmp7_ = self->priv->_cli_rows;
		g_settings_set_int (_tmp6_, "rows", (gint) _tmp7_);
		_tmp8_ = self->priv->_settings;
		g_settings_apply (_tmp8_);
		g_settings_sync ();
	}
	_tmp9_ = self->priv->_game;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::score", (GCallback) _game_window_set_score_g_object_notify, self, 0);
	_tmp10_ = self->priv->_game;
	g_signal_connect_object (_tmp10_, "finished", (GCallback) ___lambda9__game_finished, self, 0);
	_tmp11_ = self->priv->_game;
	g_signal_connect_object (_tmp11_, "target-value-reached", (GCallback) _game_window_target_value_reached_cb_game_target_value_reached, self, 0);
	_tmp12_ = self->priv->_game;
	g_signal_connect_object (_tmp12_, "undo-enabled", (GCallback) ___lambda12__game_undo_enabled, self, 0);
	_tmp13_ = self->priv->_game;
	g_signal_connect_object (_tmp13_, "undo-disabled", (GCallback) ___lambda13__game_undo_disabled, self, 0);
}

static void
__lambda14_ (GameWindow* self)
{
	Game* _tmp0_;
	_tmp0_ = self->priv->_game;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
___lambda14__game_window_popover_closed (GameWindow* _sender,
                                         gpointer self)
{
	__lambda14_ ((GameWindow*) self);
}

static void
__lambda15_ (GameWindow* self,
             GSettings* settings,
             const gchar* key_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key_name != NULL);
	_tmp0_ = key_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("cols")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("rows"))))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				GSettings* _tmp4_;
				_tmp3_ = self->priv->_settings;
				_tmp4_ = self->priv->_settings;
				_game_window_update_new_game_menu (self, (guint8) g_settings_get_int (_tmp3_, "rows"), (guint8) g_settings_get_int (_tmp4_, "cols"));
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("allow-undo")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp5_;
				Game* _tmp6_;
				_tmp5_ = self->priv->_settings;
				_game_window_update_hamburger_menu (self, g_settings_get_boolean (_tmp5_, "allow-undo"));
				_tmp6_ = self->priv->_game;
				game_load_settings (_tmp6_, &self->priv->_settings);
				return;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("allow-undo-max")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("animations-speed"))))) {
		switch (0) {
			default:
			{
				Game* _tmp7_;
				_tmp7_ = self->priv->_game;
				game_load_settings (_tmp7_, &self->priv->_settings);
				return;
			}
		}
	}
}

static void
___lambda15__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda15_ ((GameWindow*) self, _sender, key);
}

static void
_game_window_init_window (GameWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	Game* _tmp4_;
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self, "popover-closed", (GCallback) ___lambda14__game_window_popover_closed, self, 0);
	_tmp0_ = self->priv->_settings;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) ___lambda15__g_settings_changed, self, 0);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = self->priv->_settings;
	_game_window_update_new_game_menu (self, (guint8) g_settings_get_int (_tmp1_, "rows"), (guint8) g_settings_get_int (_tmp2_, "cols"));
	_tmp3_ = self->priv->_settings;
	_game_window_update_hamburger_menu (self, g_settings_get_boolean (_tmp3_, "allow-undo"));
	_tmp4_ = self->priv->_game;
	game_load_settings (_tmp4_, &self->priv->_settings);
}

static void
game_window_test_popover_closed (GameWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!game_window_has_popover (self)) {
		g_signal_emit (self, game_window_signals[GAME_WINDOW_POPOVER_CLOSED_SIGNAL], 0);
	}
}

gboolean
game_window_has_popover (GameWindow* self)
{
	gboolean _tmp0_ = FALSE;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_hamburger_button;
	_tmp2_ = gtk_menu_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkMenuButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->_new_game_button;
		_tmp5_ = gtk_menu_button_get_active (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

void
game_window_clear_subtitle (GameWindow* self)
{
	AdwWindowTitle* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_title;
	adw_window_title_set_subtitle (_tmp0_, "");
}

void
game_window_finished (GameWindow* self)
{
	AdwWindowTitle* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_title;
	adw_window_title_set_subtitle (_tmp0_, _ ("Game Over"));
}

void
game_window_set_score (GameWindow* self,
                       GObject* game,
                       GParamSpec* unused)
{
	GtkLabel* _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (unused != NULL);
	_tmp0_ = self->priv->_score;
	_tmp1_ = game_get_score (G_TYPE_CHECK_INSTANCE_CAST (game, TYPE_GAME, Game));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%li", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
}

void
_game_window_update_hamburger_menu (GameWindow* self,
                                    gboolean allow_undo)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GtkMenuButton* _tmp2_;
	GMenu* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	if (allow_undo) {
		_game_window_append_undo_section (&menu);
	}
	_game_window_append_scores_section (&menu);
	_game_window_append_app_actions_section (&menu);
	_tmp1_ = menu;
	g_menu_freeze (_tmp1_);
	_tmp2_ = self->priv->_hamburger_button;
	_tmp3_ = menu;
	gtk_menu_button_set_menu_model (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (menu);
}

static inline void
_game_window_append_undo_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Undo"), "ui.undo");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

static inline void
_game_window_append_scores_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Scores"), "ui.scores");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

static inline void
_game_window_append_app_actions_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Keyboard Shortcuts"), "win.show-help-overlay");
	g_menu_append (section, _ ("About 2048"), "ui.about");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

void
_game_window_update_new_game_menu (GameWindow* self,
                                   guint8 rows,
                                   guint8 cols)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	gboolean is_square = FALSE;
	gboolean disallowed_grid = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GMenu* _tmp8_;
	GtkMenuButton* _tmp9_;
	GMenu* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	_game_window_append_new_game_item (_ ("3 × 3"), (guint8) 3, (guint8) 3, &menu);
	_game_window_append_new_game_item (_ ("4 × 4"), (guint8) 4, (guint8) 4, &menu);
	_game_window_append_new_game_item (_ ("5 × 5"), (guint8) 5, (guint8) 5, &menu);
	is_square = rows == cols;
	_tmp1_ = grid_is_disallowed_grid_size (&rows, &cols);
	disallowed_grid = _tmp1_;
	if (disallowed_grid) {
		_tmp2_ = !is_square;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		g_warning ("game-window.vala:257: %s", _ ("Grids of size 1 by 2 are disallowed."));
	}
	if (!disallowed_grid) {
		gboolean _tmp4_ = FALSE;
		if (!is_square) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if (is_square) {
				_tmp7_ = ((gint) rows) != 4;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = ((gint) rows) != 3;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				_tmp5_ = ((gint) rows) != 5;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp4_ = _tmp5_;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_game_window_append_new_game_item (_ ("Custom"), rows, cols, &menu);
	}
	_tmp8_ = menu;
	g_menu_freeze (_tmp8_);
	_tmp9_ = self->priv->_new_game_button;
	_tmp10_ = menu;
	gtk_menu_button_set_menu_model (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (menu);
}

static void
_game_window_append_new_game_item (const gchar* label,
                                   guint8 rows,
                                   guint8 cols,
                                   GMenu** menu)
{
	GVariant* variant = NULL;
	GVariant* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_variant_new ("(yy)", rows, cols, NULL);
	g_variant_ref_sink (_tmp0_);
	variant = _tmp0_;
	_tmp1_ = g_variant_print (variant, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("ui.new-game-sized(", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ")", NULL);
	_tmp6_ = _tmp5_;
	g_menu_append (*menu, label, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_g_variant_unref0 (variant);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_game_window_install_ui_action_entries (GameWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, GAME_WINDOW__ui_action_entries, (gint) G_N_ELEMENTS (GAME_WINDOW__ui_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "ui", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "undo");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp2_;
	_tmp3_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_g_object_unref0 (action_group);
}

static void
game_window_undo_cb (GameWindow* self)
{
	GSettings* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	if (!g_settings_get_boolean (_tmp0_, "allow-undo")) {
		return;
	}
	game_window_clear_subtitle (self);
	_tmp1_ = self->priv->_game;
	game_undo (_tmp1_);
	_tmp2_ = self->priv->_game;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
}

static void
game_window_new_game_cb (GameWindow* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	game_window_clear_subtitle (self);
	_tmp0_ = self->priv->_game;
	game_new_game (_tmp0_, &self->priv->_settings);
	_tmp1_ = self->priv->_game;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}

static void
game_window_new_game_sized_cb (GameWindow* self,
                               GSimpleAction* action,
                               GVariant* variant)
{
	guint8 rows = 0U;
	guint8 cols = 0U;
	guint8 _tmp0_ = 0U;
	guint8 _tmp1_ = 0U;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	g_variant_get ((GVariant*) variant, "(yy)", &_tmp0_, &_tmp1_, NULL);
	rows = _tmp0_;
	cols = _tmp1_;
	_tmp2_ = self->priv->_settings;
	g_settings_delay (_tmp2_);
	_tmp3_ = self->priv->_settings;
	g_settings_set_int (_tmp3_, "rows", (gint) rows);
	_tmp4_ = self->priv->_settings;
	g_settings_set_int (_tmp4_, "cols", (gint) cols);
	_tmp5_ = self->priv->_settings;
	g_settings_apply (_tmp5_);
	game_window_new_game_cb (self);
}

static void
game_window_toggle_new_game_cb (GameWindow* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_new_game_button;
	_tmp1_ = self->priv->_new_game_button;
	_tmp2_ = gtk_menu_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_menu_button_set_active (_tmp0_, !_tmp3_);
}

static void
game_window_toggle_hamburger_menu (GameWindow* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_hamburger_button;
	_tmp1_ = self->priv->_hamburger_button;
	_tmp2_ = gtk_menu_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_menu_button_set_active (_tmp0_, !_tmp3_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
___lambda11_ (GameWindow* self,
              const gchar* response)
{
	g_return_if_fail (response != NULL);
	if (g_strcmp0 (response, "new-game") == 0) {
		game_window_new_game_cb (self);
	}
}

static void
____lambda11__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                         const gchar* response,
                                         gpointer self)
{
	___lambda11_ ((GameWindow*) self, response);
}

static inline void
game_window_target_value_reached_cb (GameWindow* self,
                                     guint target_value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	if (g_settings_get_boolean (_tmp0_, "do-congrat")) {
		GSettings* _tmp1_;
		AdwAlertDialog* dialog = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		AdwAlertDialog* _tmp6_;
		AdwAlertDialog* _tmp7_;
		AdwAlertDialog* _tmp8_;
		AdwAlertDialog* _tmp9_;
		AdwAlertDialog* _tmp10_;
		AdwAlertDialog* _tmp11_;
		AdwAlertDialog* _tmp12_;
		_tmp1_ = self->priv->_settings;
		g_settings_set_boolean (_tmp1_, "do-congrat", FALSE);
		_tmp2_ = g_strdup_printf ("%u", target_value);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_replace (_ ("You have obtained the %u tile for the first time!"), "%u", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Congratulations!"), _tmp5_);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		dialog = _tmp7_;
		_tmp8_ = dialog;
		adw_alert_dialog_add_responses (_tmp8_, "new-game", _ ("_New Game"), "continue", _ ("_Keep Playing"), NULL, NULL);
		_tmp9_ = dialog;
		adw_alert_dialog_set_default_response (_tmp9_, "new-game");
		_tmp10_ = dialog;
		adw_alert_dialog_set_close_response (_tmp10_, "continue");
		_tmp11_ = dialog;
		g_signal_connect_object (_tmp11_, "response", (GCallback) ____lambda11__adw_alert_dialog_response, self, 0);
		_tmp12_ = dialog;
		adw_dialog_present ((AdwDialog*) _tmp12_, (GtkWidget*) self);
		_g_object_unref0 (dialog);
	}
	g_debug ("game-window.vala:378: target value reached");
}

static GamesScoresCategory*
_game_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                          gpointer self)
{
	GamesScoresCategory* result;
	result = game_window_category_request ((GameWindow*) self, category_key);
	return result;
}

static inline void
_game_window_create_scores_dialog (GameWindow* self)
{
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresContext* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_category_new ("grid3", _ ("Grid 3 × 3"));
	_g_object_unref0 (self->priv->_grid3_cat);
	self->priv->_grid3_cat = _tmp0_;
	_tmp1_ = games_scores_category_new ("grid4", _ ("Grid 4 × 4"));
	_g_object_unref0 (self->priv->_grid4_cat);
	self->priv->_grid4_cat = _tmp1_;
	_tmp2_ = games_scores_category_new ("grid5", _ ("Grid 5 × 5"));
	_g_object_unref0 (self->priv->_grid5_cat);
	self->priv->_grid5_cat = _tmp2_;
	_tmp3_ = games_scores_context_new ("gnome-2048", _ ("Grid Size"), _game_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "org.gnome.TwentyFortyEight", 10);
	_g_object_unref0 (self->priv->_scores_ctx);
	self->priv->_scores_ctx = _tmp3_;
}

static inline GamesScoresCategory*
game_window_category_request (GameWindow* self,
                              const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("grid4")))) {
		switch (0) {
			default:
			{
				GamesScoresCategory* _tmp3_;
				GamesScoresCategory* _tmp4_;
				_tmp3_ = self->priv->_grid4_cat;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("grid3")))) {
		switch (0) {
			default:
			{
				GamesScoresCategory* _tmp5_;
				GamesScoresCategory* _tmp6_;
				_tmp5_ = self->priv->_grid3_cat;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("grid5")))) {
		switch (0) {
			default:
			{
				GamesScoresCategory* _tmp7_;
				GamesScoresCategory* _tmp8_;
				_tmp7_ = self->priv->_grid5_cat;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static inline void
game_window_scores_cb (GameWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_scores_ctx;
	games_scores_context_present_dialog (_tmp0_, (GtkWindow*) self, NULL);
}

static void
__lambda10_ (GameWindow* self,
             GObject* object,
             GAsyncResult* _result_)
{
	GamesScoresContext* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->_scores_ctx;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->priv->_scores_ctx;
	games_scores_context_present_dialog (_tmp4_, (GtkWindow*) self, NULL);
	g_debug ("game-window.vala:441: score added");
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ ((GameWindow*) self, source_object, res);
	g_object_unref (self);
}

static inline void
_game_window_show_best_scores (GameWindow* self)
{
	guint8 rows = 0U;
	GSettings* _tmp0_;
	guint8 cols = 0U;
	GSettings* _tmp1_;
	GamesScoresCategory* cat = NULL;
	GamesScoresContext* _tmp8_;
	Game* _tmp9_;
	glong _tmp10_;
	glong _tmp11_;
	GamesScoresCategory* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	rows = (guint8) g_settings_get_int (_tmp0_, "rows");
	_tmp1_ = self->priv->_settings;
	cols = (guint8) g_settings_get_int (_tmp1_, "cols");
	if (rows != cols) {
		return;
	}
	switch (rows) {
		case 4:
		{
			GamesScoresCategory* _tmp2_;
			GamesScoresCategory* _tmp3_;
			_tmp2_ = self->priv->_grid4_cat;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_g_object_unref0 (cat);
			cat = _tmp3_;
			break;
		}
		case 3:
		{
			GamesScoresCategory* _tmp4_;
			GamesScoresCategory* _tmp5_;
			_tmp4_ = self->priv->_grid3_cat;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (cat);
			cat = _tmp5_;
			break;
		}
		case 5:
		{
			GamesScoresCategory* _tmp6_;
			GamesScoresCategory* _tmp7_;
			_tmp6_ = self->priv->_grid5_cat;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (cat);
			cat = _tmp7_;
			break;
		}
		default:
		{
			_g_object_unref0 (cat);
			return;
		}
	}
	_tmp8_ = self->priv->_scores_ctx;
	_tmp9_ = self->priv->_game;
	_tmp10_ = game_get_score (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = cat;
	games_scores_context_add_score (_tmp8_, _tmp11_, _tmp12_, NULL, NULL, ___lambda10__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (cat);
}

static void
game_window_about_cb (GameWindow* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Juan R. García Blanco");
	_tmp1_ = g_strdup ("Arnaud Bonatti");
	_tmp2_ = g_strdup ("Andrey Kutejko");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	authors = _tmp3_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp4_ = g_strconcat (_ ("Copyright \xc2\xa9 2014-2015 – Juan R. García Blanco"), "\n", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2016, (guint) 2020);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u – Andrey Kutejko"), (guint) 2025);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	adw_show_about_dialog ((GtkWidget*) self, "application-name", _ ("2048"), "application-icon", "org.gnome.TwentyFortyEight", "version", VERSION, "comments", _ ("A clone of 2048 for GNOME"), "license-type", GTK_LICENSE_GPL_3_0, "copyright", _tmp15_, "developers", authors, "translator-credits", _ ("translator-credits"), "website", "https://gitlab.gnome.org/GNOME/gnome-2048/", NULL, NULL);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static guint8
game_window_get_cli_cols (GameWindow* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_cli_cols;
	return result;
}

static void
game_window_set_cli_cols (GameWindow* self,
                          guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_cli_cols (self);
	if (old_value != value) {
		self->priv->_cli_cols = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_CLI_COLS_PROPERTY]);
	}
}

static guint8
game_window_get_cli_rows (GameWindow* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_cli_rows;
	return result;
}

static void
game_window_set_cli_rows (GameWindow* self,
                          guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_cli_rows (self);
	if (old_value != value) {
		self->priv->_cli_rows = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_CLI_ROWS_PROPERTY]);
	}
}

static void
_game_window_test_popover_closed_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	game_window_test_popover_closed ((GameWindow*) self);
}

static void
_game_window___lambda16_ (GameWindow* self)
{
	Game* _tmp0_;
	_tmp0_ = self->priv->_game;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
__game_window___lambda16__g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	_game_window___lambda16_ ((GameWindow*) self);
}

static gboolean
_game_window___lambda17_ (GameWindow* self)
{
	Game* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_game;
	game_save_game (_tmp0_);
	result = FALSE;
	return result;
}

static gboolean
__game_window___lambda17__gtk_window_close_request (GtkWindow* _sender,
                                                    gpointer self)
{
	gboolean result;
	result = _game_window___lambda17_ ((GameWindow*) self);
	return result;
}

static GObject *
game_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameWindow * self;
	GSettings* _tmp0_;
	AdwWindowTitle* _tmp1_;
	AdwHeaderBar* _tmp2_;
	AdwWindowTitle* _tmp3_;
	GtkMenuButton* _tmp4_;
	GtkMenuButton* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	parent_class = G_OBJECT_CLASS (game_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_tmp0_ = g_settings_new ("org.gnome.TwentyFortyEight");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = (AdwWindowTitle*) adw_window_title_new (_ ("GNOME 2048"), "");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_window_title);
	self->priv->_window_title = _tmp1_;
	_tmp2_ = self->priv->_header_bar;
	_tmp3_ = self->priv->_window_title;
	adw_header_bar_set_title_widget (_tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_hamburger_button;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::active", (GCallback) _game_window_test_popover_closed_g_object_notify, self, 0);
	_tmp5_ = self->priv->_new_game_button;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::active", (GCallback) _game_window_test_popover_closed_g_object_notify, self, 0);
	_game_window_install_ui_action_entries (self);
	_game_window_init_game (self);
	_game_window_init_window (self);
	_game_window_create_scores_dialog (self);
	g_signal_connect_object ((GObject*) self, "notify::has-toplevel-focus", (GCallback) __game_window___lambda16__g_object_notify, self, 0);
	_tmp6_ = self->priv->_settings;
	g_settings_bind (_tmp6_, "window-width", (GObject*) self, "default-width", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->_settings;
	g_settings_bind (_tmp7_, "window-height", (GObject*) self, "default-height", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = self->priv->_settings;
	g_settings_bind (_tmp8_, "window-maximized", (GObject*) self, "maximized", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object ((GtkWindow*) self, "close-request", (GCallback) __game_window___lambda17__gtk_window_close_request, self, 0);
	return obj;
}

static void
game_window_class_init (GameWindowClass * klass,
                        gpointer klass_data)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_CLI_COLS_PROPERTY, game_window_properties[GAME_WINDOW_CLI_COLS_PROPERTY] = g_param_spec_uchar ("cli-cols", "cli-cols", "cli-cols", 0, G_MAXUINT8, (guint8) 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_CLI_ROWS_PROPERTY, game_window_properties[GAME_WINDOW_CLI_ROWS_PROPERTY] = g_param_spec_uchar ("cli-rows", "cli-rows", "cli-rows", 0, G_MAXUINT8, (guint8) 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/TwentyFortyEight/ui/game-window.ui");
	game_window_signals[GAME_WINDOW_POPOVER_CLOSED_SIGNAL] = g_signal_new ("popover-closed", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_header_bar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_score", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _score));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_new_game_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_hamburger_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _hamburger_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_game", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _game));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_unfullscreen_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, _unfullscreen_button));
}

static void
game_window_instance_init (GameWindow * self,
                           gpointer klass)
{
	self->priv = game_window_get_instance_private (self);
	self->priv->_cli_cols = (guint8) 0;
	self->priv->_cli_rows = (guint8) 0;
	g_type_ensure (TYPE_GAME);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_window_title);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->_scores_ctx);
	_g_object_unref0 (self->priv->_grid4_cat);
	_g_object_unref0 (self->priv->_grid3_cat);
	_g_object_unref0 (self->priv->_grid5_cat);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}

static GType
game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
	GType game_window_type_id;
	game_window_type_id = g_type_register_static (adw_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
	GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
	return game_window_type_id;
}

GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__once = 0;
	if (g_once_init_enter (&game_window_type_id__once)) {
		GType game_window_type_id;
		game_window_type_id = game_window_get_type_once ();
		g_once_init_leave (&game_window_type_id__once, game_window_type_id);
	}
	return game_window_type_id__once;
}

static void
_vala_game_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_CLI_COLS_PROPERTY:
		g_value_set_uchar (value, game_window_get_cli_cols (self));
		break;
		case GAME_WINDOW_CLI_ROWS_PROPERTY:
		g_value_set_uchar (value, game_window_get_cli_rows (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_CLI_COLS_PROPERTY:
		game_window_set_cli_cols (self, g_value_get_uchar (value));
		break;
		case GAME_WINDOW_CLI_ROWS_PROPERTY:
		game_window_set_cli_rows (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

