/* game.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <graphene-gobject.h>
#include <pango/pango.h>
#include <gsk/gsk.h>

#define GAME_KEYCODE_W ((guint16) 25)
#define GAME_KEYCODE_A ((guint16) 38)
#define GAME_KEYCODE_S ((guint16) 39)
#define GAME_KEYCODE_D ((guint16) 40)
#define GAME_KEYCODE_H ((guint16) 43)
#define GAME_KEYCODE_J ((guint16) 44)
#define GAME_KEYCODE_K ((guint16) 45)
#define GAME_KEYCODE_L ((guint16) 46)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;
typedef enum  {
	GAME_GAME_STATE_STOPPED,
	GAME_GAME_STATE_IDLE,
	GAME_GAME_STATE_MOVING,
	GAME_GAME_STATE_SHOWING_FIRST_TILE,
	GAME_GAME_STATE_SHOWING_NEW_TILE,
	GAME_GAME_STATE_RESTORING_TILES
} GameGameState;

#define GAME_TYPE_GAME_STATE (game_game_state_get_type ())
enum  {
	GAME_0_PROPERTY,
	GAME_SCORE_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	MOVE_REQUEST_UP,
	MOVE_REQUEST_RIGHT,
	MOVE_REQUEST_DOWN,
	MOVE_REQUEST_LEFT
} MoveRequest;

#define TYPE_MOVE_REQUEST (move_request_get_type ())
#define _tile_movement_free0(var) ((var == NULL) ? NULL : (var = (tile_movement_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))
enum  {
	GAME_FINISHED_SIGNAL,
	GAME_TARGET_VALUE_REACHED_SIGNAL,
	GAME_UNDO_ENABLED_SIGNAL,
	GAME_UNDO_DISABLED_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GtkWidget parent_instance;
	GamePrivate * priv;
	GSettings* settings;
};

struct _GameClass {
	GtkWidgetClass parent_class;
};

struct _GridPosition {
	gint8 row;
	gint8 col;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

struct _Tile {
	GridPosition pos;
	guint8 val;
};

struct _GamePrivate {
	gint BLANK_COL_WIDTH;
	gint BLANK_ROW_HEIGHT;
	Grid* _grid;
	TileView** _foreground_cur;
	gint _foreground_cur_length1;
	gint _foreground_cur_length2;
	TileView** _foreground_nxt;
	gint _foreground_nxt_length1;
	gint _foreground_nxt_length2;
	GeeLinkedList* _to_move;
	GeeLinkedList* _to_hide;
	GeeLinkedList* _to_show;
	GameGameState _state;
	AdwAnimation* _show_hide_trans;
	GeeArrayList* _show_trans_tiles;
	GeeArrayList* _hide_trans_tiles;
	gdouble _show_hide_trans_value;
	AdwAnimation* _move_trans;
	gdouble _move_trans_value;
	GeeArrayList* _move_trans_tiles;
	gint _animations_duration;
	gchar* _saved_path;
	GdkRGBA _background_color;
	GdkRGBA _empty_tile_color;
	GdkRGBA _text_color;
	gboolean _just_restored;
	glong _score;
	guint _finish_move_id;
	gboolean _update_handled;
	gboolean _allow_undo;
	guint _undo_stack_max_size;
	GeeLinkedList* _undo_stack;
};

struct _Block1Data {
	int _ref_count_;
	Game* self;
	GridPosition pos;
};

struct _Block2Data {
	int _ref_count_;
	Game* self;
	GridPosition pos;
};

struct _Block3Data {
	int _ref_count_;
	Game* self;
	GridPosition pos;
};

static gint Game_private_offset;
static gpointer game_parent_class = NULL;

VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Grid, g_object_unref)
VALA_EXTERN GType rounded_rectangle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RoundedRectangle, g_object_unref)
VALA_EXTERN GType tile_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TileView, g_object_unref)
VALA_EXTERN GType tile_movement_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType grid_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GridPosition* grid_position_dup (const GridPosition* self);
VALA_EXTERN void grid_position_free (GridPosition* self);
VALA_EXTERN TileMovement* tile_movement_dup (const TileMovement* self);
VALA_EXTERN void tile_movement_free (TileMovement* self);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Tile* tile_dup (const Tile* self);
VALA_EXTERN void tile_free (Tile* self);
static GType game_game_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* game_game_state_to_string (GameGameState state);
static void _game_init_grid (Game* self,
                      guint8 rows,
                      guint8 cols);
VALA_EXTERN Grid* grid_new (guint8 rows,
                guint8 cols);
VALA_EXTERN Grid* grid_construct (GType object_type,
                      guint8 rows,
                      guint8 cols);
static inline gboolean game_on_key_pressed (Game* self,
                              GtkEventControllerKey* _key_controller,
                              guint keyval,
                              guint keycode,
                              GdkModifierType state);
VALA_EXTERN gboolean game_cannot_move (Game* self);
VALA_EXTERN GType move_request_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void game_move (Game* self,
                MoveRequest request);
static inline guint _game_upper_key (guint keyval);
static inline void _game_on_swipe (Game* self,
                     GtkGestureSwipe* _gesture_swipe,
                     gdouble velocity_x,
                     gdouble velocity_y);
static void game_real_snapshot (GtkWidget* base,
                         GtkSnapshot* snapshot);
VALA_EXTERN guint8 grid_get_rows (Grid* self);
VALA_EXTERN guint8 grid_get_cols (Grid* self);
static void game_draw_tile (Game* self,
                     GtkSnapshot* snapshot,
                     gfloat tile_width,
                     gfloat tile_height,
                     TileView* tile,
                     gfloat opacity,
                     PangoLayout* layout);
static inline gboolean _game_is_tile_animating_hide (Game* self,
                                       GridPosition* pos);
static inline gboolean _game_is_tile_animating_show (Game* self,
                                       GridPosition* pos);
static inline TileMovement* _game_is_tile_animating_move (Game* self,
                                            GridPosition* pos);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block1Data* _data1_,
                     GridPosition* p);
static gboolean ___lambda7__gee_predicate (gconstpointer g,
                                    gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block2Data* _data2_,
                     GridPosition* p);
static gboolean ___lambda6__gee_predicate (gconstpointer g,
                                    gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block3Data* _data3_,
                     TileMovement* p);
static gboolean ___lambda8__gee_predicate (gconstpointer g,
                                    gpointer self);
VALA_EXTERN void rounded_rectangle_color_rgba (RoundedRectangle* self,
                                   GdkRGBA* result);
VALA_EXTERN guint8 rounded_rectangle_get_color (RoundedRectangle* self);
VALA_EXTERN void game_new_game (Game* self,
                    GSettings** settings);
static inline void _game_clean_finish_move_animation (Game* self);
VALA_EXTERN void grid_clear (Grid* self);
static void _game_clear_history (Game* self);
static void _game_init_foreground (Game* self);
static void game_set_score (Game* self,
                     glong value);
static void _game_create_random_tile (Game* self);
VALA_EXTERN void game_save_game (Game* self);
VALA_EXTERN void grid_save_game (Grid* self,
                     const gchar* path);
VALA_EXTERN gboolean game_restore_game (Game* self,
                            GSettings** settings);
VALA_EXTERN gboolean grid_restore_game (Grid* self,
                            const gchar* path);
VALA_EXTERN glong grid_get_score (Grid* self);
static void _game_restore_foreground (Game* self,
                               gboolean animate);
VALA_EXTERN void game_load_settings (Game* self,
                         GSettings** settings);
static void _game_load_undo_settings (Game* self,
                               GSettings** settings);
VALA_EXTERN void grid_new_tile (Grid* self,
                    Tile* tile);
static void _game_create_show_hide_transition (Game* self,
                                        gboolean animate);
static void _game_create_tile (Game* self,
                        Tile* tile);
static void _game_show_tile (Game* self,
                      GridPosition* pos);
VALA_EXTERN TileView* tile_view_new (guint8 val);
VALA_EXTERN TileView* tile_view_construct (GType object_type,
                               guint8 val);
VALA_EXTERN gchar* grid_position_to_string (GridPosition *self);
static void _game_move_tile (Game* self,
                      GridPosition* from,
                      GridPosition* to);
static void _game_prepare_move_tile (Game* self,
                              GridPosition* from,
                              GridPosition* to);
static void _game_dim_tile (Game* self,
                     GridPosition* pos);
static void _game_clear_foreground (Game* self);
VALA_EXTERN guint8 grid_get (Grid* self,
                 guint8 row,
                 guint8 col);
static void _game_apply_move (Game* self);
VALA_EXTERN gchar* move_request_debug_string (MoveRequest request);
VALA_EXTERN Grid* grid_clone (Grid* self);
static void __lambda5_ (Game* self,
                 gdouble value);
static void ___lambda5__adw_animation_target_func (gdouble value,
                                            gpointer self);
static void _game_on_move_trans_stopped (Game* self);
static void __game_on_move_trans_stopped_adw_animation_done (AdwAnimation* _sender,
                                                      gpointer self);
VALA_EXTERN void grid_move (Grid* self,
                MoveRequest request,
                GeeLinkedList** to_move,
                GeeLinkedList** to_hide,
                GeeLinkedList** to_show);
static void _game_store_movement (Game* self,
                           Grid* clone);
VALA_EXTERN gchar* grid_to_string (Grid* self);
VALA_EXTERN glong game_get_score (Game* self);
static void __lambda4_ (Game* self,
                 gdouble value);
static void ___lambda4__adw_animation_target_func (gdouble value,
                                            gpointer self);
static void _game_on_show_hide_trans_stopped (Game* self);
static void __game_on_show_hide_trans_stopped_adw_animation_done (AdwAnimation* _sender,
                                                           gpointer self);
VALA_EXTERN gboolean grid_get_target_value_reached (Grid* self);
VALA_EXTERN guint grid_get_target_value (Grid* self);
VALA_EXTERN void grid_set_target_value_reached (Grid* self,
                                    gboolean value);
static gboolean _game_finish_move (Game* self);
static gboolean __game_finish_move_gsource_func (gpointer self);
VALA_EXTERN gboolean grid_is_finished (Grid* self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN Game* game_new (void);
VALA_EXTERN Game* game_construct (GType object_type);
static GObject * game_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties);
static gboolean _game_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                    guint keyval,
                                                                    guint keycode,
                                                                    GdkModifierType state,
                                                                    gpointer self);
static void __game_on_swipe_gtk_gesture_swipe_swipe (GtkGestureSwipe* _sender,
                                              gdouble velocity_x,
                                              gdouble velocity_y,
                                              gpointer self);
static void game_finalize (GObject * obj);
static GType game_get_type_once (void);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

static gchar*
game_game_state_to_string (GameGameState state)
{
	gchar* result;
	switch (state) {
		case GAME_GAME_STATE_STOPPED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("stopped");
			result = _tmp0_;
			return result;
		}
		case GAME_GAME_STATE_IDLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("idle");
			result = _tmp1_;
			return result;
		}
		case GAME_GAME_STATE_MOVING:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("moving");
			result = _tmp2_;
			return result;
		}
		case GAME_GAME_STATE_SHOWING_FIRST_TILE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("showing first tile");
			result = _tmp3_;
			return result;
		}
		case GAME_GAME_STATE_SHOWING_NEW_TILE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("showing new tile");
			result = _tmp4_;
			return result;
		}
		case GAME_GAME_STATE_RESTORING_TILES:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("restoring tiles");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
game_game_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_GAME_STATE_STOPPED, "GAME_GAME_STATE_STOPPED", "stopped"}, {GAME_GAME_STATE_IDLE, "GAME_GAME_STATE_IDLE", "idle"}, {GAME_GAME_STATE_MOVING, "GAME_GAME_STATE_MOVING", "moving"}, {GAME_GAME_STATE_SHOWING_FIRST_TILE, "GAME_GAME_STATE_SHOWING_FIRST_TILE", "showing-first-tile"}, {GAME_GAME_STATE_SHOWING_NEW_TILE, "GAME_GAME_STATE_SHOWING_NEW_TILE", "showing-new-tile"}, {GAME_GAME_STATE_RESTORING_TILES, "GAME_GAME_STATE_RESTORING_TILES", "restoring-tiles"}, {0, NULL, NULL}};
	GType game_game_state_type_id;
	game_game_state_type_id = g_enum_register_static ("GameGameState", values);
	return game_game_state_type_id;
}

static GType
game_game_state_get_type (void)
{
	static volatile gsize game_game_state_type_id__once = 0;
	if (g_once_init_enter (&game_game_state_type_id__once)) {
		GType game_game_state_type_id;
		game_game_state_type_id = game_game_state_get_type_once ();
		g_once_init_leave (&game_game_state_type_id__once, game_game_state_type_id);
	}
	return game_game_state_type_id__once;
}

static void
_game_init_grid (Game* self,
                 guint8 rows,
                 guint8 cols)
{
	Grid* _tmp0_;
	GSettings* _tmp1_;
	Grid* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = grid_new (rows, cols);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_grid = _tmp0_;
	_tmp1_ = self->settings;
	_tmp2_ = self->priv->_grid;
	g_settings_bind (_tmp1_, "target-value", (GObject*) _tmp2_, "target-value", G_SETTINGS_BIND_DEFAULT | G_SETTINGS_BIND_NO_SENSITIVITY);
}

static inline gboolean
game_on_key_pressed (Game* self,
                     GtkEventControllerKey* _key_controller,
                     guint keyval,
                     guint keycode,
                     GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	if (game_cannot_move (self)) {
		result = FALSE;
		return result;
	}
	switch (keycode) {
		case GAME_KEYCODE_W:
		{
			game_move (self, MOVE_REQUEST_UP);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_A:
		{
			game_move (self, MOVE_REQUEST_LEFT);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_S:
		{
			game_move (self, MOVE_REQUEST_DOWN);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_D:
		{
			game_move (self, MOVE_REQUEST_RIGHT);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_H:
		{
			game_move (self, MOVE_REQUEST_LEFT);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_J:
		{
			game_move (self, MOVE_REQUEST_DOWN);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_K:
		{
			game_move (self, MOVE_REQUEST_UP);
			result = TRUE;
			return result;
		}
		case GAME_KEYCODE_L:
		{
			game_move (self, MOVE_REQUEST_RIGHT);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	switch (_game_upper_key (keyval)) {
		case GDK_KEY_Up:
		{
			game_move (self, MOVE_REQUEST_UP);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Left:
		{
			game_move (self, MOVE_REQUEST_LEFT);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Down:
		{
			game_move (self, MOVE_REQUEST_DOWN);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Right:
		{
			game_move (self, MOVE_REQUEST_RIGHT);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static inline guint
_game_upper_key (guint keyval)
{
	guint _tmp0_ = 0U;
	guint result;
	if (keyval > ((guint) 255)) {
		_tmp0_ = keyval;
	} else {
		_tmp0_ = (guint) g_ascii_toupper ((gchar) keyval);
	}
	result = _tmp0_;
	return result;
}

static inline void
_game_on_swipe (Game* self,
                GtkGestureSwipe* _gesture_swipe,
                gdouble velocity_x,
                gdouble velocity_y)
{
	guint button = 0U;
	gboolean _tmp0_ = FALSE;
	gdouble abs_x = 0.0;
	gdouble abs_y = 0.0;
	gboolean left_or_right = FALSE;
	gboolean up_or_down = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_gesture_swipe != NULL);
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _gesture_swipe);
	if (button != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = button != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (game_cannot_move (self)) {
		return;
	}
	abs_x = fabs (velocity_x);
	abs_y = fabs (velocity_y);
	if (((abs_x * abs_x) + (abs_y * abs_y)) < 400.0) {
		return;
	}
	left_or_right = (abs_y * 4.0) < abs_x;
	up_or_down = (abs_x * 4.0) < abs_y;
	if (left_or_right) {
		if (velocity_x < (-10.0)) {
			game_move (self, MOVE_REQUEST_LEFT);
		} else {
			if (velocity_x > 10.0) {
				game_move (self, MOVE_REQUEST_RIGHT);
			}
		}
	} else {
		if (up_or_down) {
			if (velocity_y < (-10.0)) {
				game_move (self, MOVE_REQUEST_UP);
			} else {
				if (velocity_y > 10.0) {
					game_move (self, MOVE_REQUEST_DOWN);
				}
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
game_real_snapshot (GtkWidget* base,
                    GtkSnapshot* snapshot)
{
	Game * self;
	gint width = 0;
	gint height = 0;
	graphene_rect_t rect = {0};
	graphene_point_t _tmp0_ = {0};
	graphene_size_t _tmp1_ = {0};
	graphene_rect_t _tmp2_ = {0};
	GdkRGBA _tmp3_;
	graphene_rect_t _tmp4_;
	guint8 rows = 0U;
	Grid* _tmp5_;
	guint8 _tmp6_;
	guint8 _tmp7_;
	guint8 cols = 0U;
	Grid* _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	gfloat tile_width = 0.0F;
	gfloat tile_height = 0.0F;
	graphene_rect_t tile_rect = {0};
	graphene_point_t _tmp11_ = {0};
	graphene_size_t _tmp12_ = {0};
	graphene_rect_t _tmp13_ = {0};
	gfloat _tmp14_ = 0.0F;
	gfloat radius = 0.0F;
	graphene_size_t rounded_corner = {0};
	graphene_size_t _tmp15_ = {0};
	PangoLayout* layout = NULL;
	PangoContext* _tmp16_;
	PangoLayout* _tmp17_;
	PangoFontDescription* font_desc = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	PangoFontDescription* _tmp20_;
	PangoFontDescription* _tmp21_;
	PangoLayout* _tmp22_;
	PangoFontDescription* _tmp23_;
	self = (Game*) base;
	g_return_if_fail (snapshot != NULL);
	width = gtk_widget_get_width ((GtkWidget*) self);
	height = gtk_widget_get_height ((GtkWidget*) self);
	_tmp0_.x = (gfloat) 0;
	_tmp0_.y = (gfloat) 0;
	_tmp1_.width = (gfloat) width;
	_tmp1_.height = (gfloat) height;
	memset (&_tmp2_, 0, sizeof (graphene_rect_t));
	_tmp2_.origin = _tmp0_;
	_tmp2_.size = _tmp1_;
	rect = _tmp2_;
	_tmp3_ = self->priv->_background_color;
	_tmp4_ = rect;
	gtk_snapshot_append_color (snapshot, &_tmp3_, &_tmp4_);
	_tmp5_ = self->priv->_grid;
	_tmp6_ = grid_get_rows (_tmp5_);
	_tmp7_ = _tmp6_;
	rows = _tmp7_;
	_tmp8_ = self->priv->_grid;
	_tmp9_ = grid_get_cols (_tmp8_);
	_tmp10_ = _tmp9_;
	cols = _tmp10_;
	tile_width = (gfloat) ((width - ((cols + 1) * self->priv->BLANK_COL_WIDTH)) / cols);
	tile_height = (gfloat) ((height - ((rows + 1) * self->priv->BLANK_ROW_HEIGHT)) / rows);
	_tmp11_.x = (gfloat) 0;
	_tmp11_.y = (gfloat) 0;
	_tmp12_.width = tile_width;
	_tmp12_.height = tile_height;
	memset (&_tmp13_, 0, sizeof (graphene_rect_t));
	_tmp13_.origin = _tmp11_;
	_tmp13_.size = _tmp12_;
	tile_rect = _tmp13_;
	if (tile_height > tile_width) {
		_tmp14_ = tile_height / 20.0f;
	} else {
		_tmp14_ = tile_width / 20.0f;
	}
	radius = _tmp14_;
	memset (&_tmp15_, 0, sizeof (graphene_size_t));
	_tmp15_.height = radius;
	_tmp15_.width = radius;
	rounded_corner = _tmp15_;
	_tmp16_ = gtk_widget_get_pango_context ((GtkWidget*) self);
	_tmp17_ = pango_layout_new (_tmp16_);
	layout = _tmp17_;
	_tmp18_ = g_strdup_printf ("Sans Bold %dpx", ((gint) tile_height) / 4);
	_tmp19_ = _tmp18_;
	_tmp20_ = pango_font_description_from_string (_tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	font_desc = _tmp21_;
	_tmp22_ = layout;
	_tmp23_ = font_desc;
	pango_layout_set_font_description (_tmp22_, _tmp23_);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				if (!_tmp24_) {
					guint8 _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							gfloat x = 0.0F;
							gfloat y = 0.0F;
							graphene_point_t _tmp28_ = {0};
							PangoLayout* _tmp29_;
							if (!_tmp26_) {
								guint8 _tmp27_;
								_tmp27_ = j;
								j = _tmp27_ + 1;
							}
							_tmp26_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							x = ((j * tile_width) + ((j + 1) * self->priv->BLANK_COL_WIDTH)) + (tile_width / 2);
							y = ((i * tile_height) + ((i + 1) * self->priv->BLANK_ROW_HEIGHT)) + (tile_height / 2);
							gtk_snapshot_save (snapshot);
							memset (&_tmp28_, 0, sizeof (graphene_point_t));
							_tmp28_.x = x;
							_tmp28_.y = y;
							gtk_snapshot_translate (snapshot, &_tmp28_);
							_tmp29_ = layout;
							game_draw_tile (self, snapshot, tile_width, tile_height, NULL, 1.0f, _tmp29_);
							gtk_snapshot_restore (snapshot);
						}
					}
				}
			}
		}
	}
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				if (!_tmp30_) {
					guint8 _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							TileView** tiles = NULL;
							TileView** _tmp34_;
							gint _tmp34__length1;
							gint _tmp34__length2;
							TileView* _tmp35_;
							TileView* _tmp36_;
							TileView** _tmp37_;
							gint _tmp37__length1;
							gint _tmp37__length2;
							TileView* _tmp38_;
							TileView* _tmp39_;
							TileView** _tmp40_;
							gint tiles_length1;
							gint _tiles_size_;
							TileView** _tmp41_;
							gint _tmp41__length1;
							if (!_tmp32_) {
								guint8 _tmp33_;
								_tmp33_ = j;
								j = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp34_ = self->priv->_foreground_cur;
							_tmp34__length1 = self->priv->_foreground_cur_length1;
							_tmp34__length2 = self->priv->_foreground_cur_length2;
							_tmp35_ = _tmp34_[(i * _tmp34__length2) + j];
							_tmp36_ = _g_object_ref0 (_tmp35_);
							_tmp37_ = self->priv->_foreground_nxt;
							_tmp37__length1 = self->priv->_foreground_nxt_length1;
							_tmp37__length2 = self->priv->_foreground_nxt_length2;
							_tmp38_ = _tmp37_[(i * _tmp37__length2) + j];
							_tmp39_ = _g_object_ref0 (_tmp38_);
							_tmp40_ = g_new0 (TileView*, 2 + 1);
							_tmp40_[0] = _tmp36_;
							_tmp40_[1] = _tmp39_;
							tiles = _tmp40_;
							tiles_length1 = 2;
							_tiles_size_ = tiles_length1;
							_tmp41_ = tiles;
							_tmp41__length1 = tiles_length1;
							{
								TileView** tile_collection = NULL;
								gint tile_collection_length1 = 0;
								gint _tile_collection_size_ = 0;
								gint tile_it = 0;
								tile_collection = _tmp41_;
								tile_collection_length1 = _tmp41__length1;
								for (tile_it = 0; tile_it < tile_collection_length1; tile_it = tile_it + 1) {
									TileView* _tmp42_;
									TileView* tile = NULL;
									_tmp42_ = _g_object_ref0 (tile_collection[tile_it]);
									tile = _tmp42_;
									{
										TileView* _tmp43_;
										_tmp43_ = tile;
										if (_tmp43_ != NULL) {
											GridPosition pos = {0};
											GridPosition _tmp44_ = {0};
											gfloat x = 0.0F;
											gfloat y = 0.0F;
											graphene_point_t _tmp45_ = {0};
											TileMovement* move_anim = NULL;
											GridPosition _tmp46_;
											_tmp44_.row = (gint8) i;
											_tmp44_.col = (gint8) j;
											pos = _tmp44_;
											x = ((j * tile_width) + ((j + 1) * self->priv->BLANK_COL_WIDTH)) + (tile_width / 2);
											y = ((i * tile_height) + ((i + 1) * self->priv->BLANK_ROW_HEIGHT)) + (tile_height / 2);
											gtk_snapshot_save (snapshot);
											memset (&_tmp45_, 0, sizeof (graphene_point_t));
											_tmp45_.x = x;
											_tmp45_.y = y;
											gtk_snapshot_translate (snapshot, &_tmp45_);
											move_anim = NULL;
											_tmp46_ = pos;
											if (_game_is_tile_animating_hide (self, &_tmp46_)) {
												gfloat opacity = 0.0F;
												TileView* _tmp47_;
												PangoLayout* _tmp48_;
												opacity = 1.0f - ((gfloat) self->priv->_show_hide_trans_value);
												_tmp47_ = tile;
												_tmp48_ = layout;
												game_draw_tile (self, snapshot, tile_width, tile_height, _tmp47_, opacity, _tmp48_);
											} else {
												GridPosition _tmp49_;
												_tmp49_ = pos;
												if (_game_is_tile_animating_show (self, &_tmp49_)) {
													gfloat factor = 0.0F;
													gfloat opacity = 0.0F;
													TileView* _tmp50_;
													PangoLayout* _tmp51_;
													factor = 1.0f - (2.0f * fabsf (((gfloat) self->priv->_show_hide_trans_value) - 0.5f));
													factor = 1.0f + (0.1f * factor);
													opacity = (gfloat) self->priv->_show_hide_trans_value;
													_tmp50_ = tile;
													_tmp51_ = layout;
													game_draw_tile (self, snapshot, factor * tile_width, factor * tile_height, _tmp50_, opacity, _tmp51_);
												} else {
													GridPosition _tmp52_;
													TileMovement* _tmp53_;
													TileMovement* _tmp54_;
													_tmp52_ = pos;
													_tmp53_ = _game_is_tile_animating_move (self, &_tmp52_);
													_tile_movement_free0 (move_anim);
													move_anim = _tmp53_;
													_tmp54_ = move_anim;
													if (_tmp54_ != NULL) {
														gfloat from_j = 0.0F;
														TileMovement* _tmp55_;
														GridPosition _tmp56_;
														gfloat from_i = 0.0F;
														TileMovement* _tmp57_;
														GridPosition _tmp58_;
														gfloat from_x = 0.0F;
														gfloat from_y = 0.0F;
														gfloat offset_x = 0.0F;
														gfloat offset_y = 0.0F;
														graphene_point_t _tmp59_ = {0};
														TileView* _tmp60_;
														PangoLayout* _tmp61_;
														_tmp55_ = move_anim;
														_tmp56_ = ((TileMovement) (*_tmp55_)).from;
														from_j = (gfloat) _tmp56_.col;
														_tmp57_ = move_anim;
														_tmp58_ = ((TileMovement) (*_tmp57_)).from;
														from_i = (gfloat) _tmp58_.row;
														from_x = ((from_j * tile_width) + ((from_j + 1) * self->priv->BLANK_COL_WIDTH)) + (tile_width / 2);
														from_y = ((from_i * tile_height) + ((from_i + 1) * self->priv->BLANK_ROW_HEIGHT)) + (tile_height / 2);
														offset_x = (1.0f - ((gfloat) self->priv->_move_trans_value)) * (from_x - x);
														offset_y = (1.0f - ((gfloat) self->priv->_move_trans_value)) * (from_y - y);
														gtk_snapshot_save (snapshot);
														memset (&_tmp59_, 0, sizeof (graphene_point_t));
														_tmp59_.x = offset_x;
														_tmp59_.y = offset_y;
														gtk_snapshot_translate (snapshot, &_tmp59_);
														_tmp60_ = tile;
														_tmp61_ = layout;
														game_draw_tile (self, snapshot, tile_width, tile_height, _tmp60_, 1.0f, _tmp61_);
														gtk_snapshot_restore (snapshot);
													} else {
														TileView* _tmp62_;
														PangoLayout* _tmp63_;
														_tmp62_ = tile;
														_tmp63_ = layout;
														game_draw_tile (self, snapshot, tile_width, tile_height, _tmp62_, 1.0f, _tmp63_);
													}
												}
											}
											gtk_snapshot_restore (snapshot);
											_tile_movement_free0 (move_anim);
										}
										_g_object_unref0 (tile);
									}
								}
							}
							tiles = (_vala_array_free (tiles, tiles_length1, (GDestroyNotify) g_object_unref), NULL);
						}
					}
				}
			}
		}
	}
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (layout);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Game* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda7_ (Block1Data* _data1_,
            GridPosition* p)
{
	Game* self;
	gboolean _tmp0_ = FALSE;
	GridPosition _tmp1_;
	gboolean result;
	self = _data1_->self;
	_tmp1_ = _data1_->pos;
	if (((GridPosition) (*p)).row == _tmp1_.row) {
		GridPosition _tmp2_;
		_tmp2_ = _data1_->pos;
		_tmp0_ = ((GridPosition) (*p)).col == _tmp2_.col;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda7__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, (GridPosition*) g);
	return result;
}

static inline gboolean
_game_is_tile_animating_show (Game* self,
                              GridPosition* pos)
{
	Block1Data* _data1_;
	GridPosition _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pos != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = *pos;
	_data1_->pos = _tmp0_;
	if (self->priv->_show_hide_trans_value < 0.0) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp1_ = self->priv->_show_trans_tiles;
	result = gee_traversable_any_match ((GeeTraversable*) _tmp1_, ___lambda7__gee_predicate, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Game* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda6_ (Block2Data* _data2_,
            GridPosition* p)
{
	Game* self;
	gboolean _tmp0_ = FALSE;
	GridPosition _tmp1_;
	gboolean result;
	self = _data2_->self;
	_tmp1_ = _data2_->pos;
	if (((GridPosition) (*p)).row == _tmp1_.row) {
		GridPosition _tmp2_;
		_tmp2_ = _data2_->pos;
		_tmp0_ = ((GridPosition) (*p)).col == _tmp2_.col;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda6__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda6_ (self, (GridPosition*) g);
	return result;
}

static inline gboolean
_game_is_tile_animating_hide (Game* self,
                              GridPosition* pos)
{
	Block2Data* _data2_;
	GridPosition _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pos != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = *pos;
	_data2_->pos = _tmp0_;
	if (self->priv->_show_hide_trans_value < 0.0) {
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp1_ = self->priv->_hide_trans_tiles;
	result = gee_traversable_any_match ((GeeTraversable*) _tmp1_, ___lambda6__gee_predicate, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Game* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda8_ (Block3Data* _data3_,
            TileMovement* p)
{
	Game* self;
	gboolean _tmp0_ = FALSE;
	GridPosition _tmp1_;
	GridPosition _tmp2_;
	gboolean result;
	self = _data3_->self;
	_tmp1_ = ((TileMovement) (*p)).to;
	_tmp2_ = _data3_->pos;
	if (_tmp1_.row == _tmp2_.row) {
		GridPosition _tmp3_;
		GridPosition _tmp4_;
		_tmp3_ = ((TileMovement) (*p)).to;
		_tmp4_ = _data3_->pos;
		_tmp0_ = _tmp3_.col == _tmp4_.col;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda8__gee_predicate (gconstpointer g,
                           gpointer self)
{
	gboolean result;
	result = __lambda8_ (self, (TileMovement*) g);
	return result;
}

static inline TileMovement*
_game_is_tile_animating_move (Game* self,
                              GridPosition* pos)
{
	Block3Data* _data3_;
	GridPosition _tmp0_;
	GeeArrayList* _tmp1_;
	gpointer _tmp2_;
	TileMovement* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pos != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = *pos;
	_data3_->pos = _tmp0_;
	if (self->priv->_move_trans_value < 0.0) {
		result = NULL;
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp1_ = self->priv->_move_trans_tiles;
	_tmp2_ = gee_traversable_first_match ((GeeTraversable*) _tmp1_, ___lambda8__gee_predicate, block3_data_ref (_data3_), block3_data_unref);
	result = (TileMovement*) _tmp2_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
game_draw_tile (Game* self,
                GtkSnapshot* snapshot,
                gfloat tile_width,
                gfloat tile_height,
                TileView* tile,
                gfloat opacity,
                PangoLayout* layout)
{
	graphene_rect_t tile_rect = {0};
	graphene_point_t _tmp0_ = {0};
	graphene_size_t _tmp1_ = {0};
	graphene_rect_t _tmp2_ = {0};
	gfloat _tmp3_ = 0.0F;
	gfloat radius = 0.0F;
	graphene_size_t rounded_corner = {0};
	graphene_size_t _tmp4_ = {0};
	graphene_point_t _tmp5_ = {0};
	GskRoundedRect _tmp6_ = {0};
	graphene_rect_t _tmp7_;
	graphene_size_t _tmp8_;
	graphene_size_t _tmp9_;
	graphene_size_t _tmp10_;
	graphene_size_t _tmp11_;
	GskRoundedRect _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (layout != NULL);
	_tmp0_.x = (gfloat) 0;
	_tmp0_.y = (gfloat) 0;
	_tmp1_.width = tile_width;
	_tmp1_.height = tile_height;
	memset (&_tmp2_, 0, sizeof (graphene_rect_t));
	_tmp2_.origin = _tmp0_;
	_tmp2_.size = _tmp1_;
	tile_rect = _tmp2_;
	if (tile_height > tile_width) {
		_tmp3_ = tile_height / 20.0f;
	} else {
		_tmp3_ = tile_width / 20.0f;
	}
	radius = _tmp3_;
	memset (&_tmp4_, 0, sizeof (graphene_size_t));
	_tmp4_.height = radius;
	_tmp4_.width = radius;
	rounded_corner = _tmp4_;
	gtk_snapshot_save (snapshot);
	memset (&_tmp5_, 0, sizeof (graphene_point_t));
	_tmp5_.x = (-tile_width) / 2;
	_tmp5_.y = (-tile_height) / 2;
	gtk_snapshot_translate (snapshot, &_tmp5_);
	memset (&_tmp6_, 0, sizeof (GskRoundedRect));
	_tmp7_ = tile_rect;
	_tmp8_ = rounded_corner;
	_tmp9_ = rounded_corner;
	_tmp10_ = rounded_corner;
	_tmp11_ = rounded_corner;
	_tmp12_ = (GskRoundedRect) (*gsk_rounded_rect_init (&_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_));
	gtk_snapshot_push_rounded_clip (snapshot, &_tmp12_);
	if (tile != NULL) {
		GdkRGBA color = {0};
		GdkRGBA _tmp13_ = {0};
		GdkRGBA _tmp14_;
		graphene_rect_t _tmp15_;
		guint8 _tmp16_;
		guint8 _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		PangoRectangle logical_rect = {0};
		PangoRectangle _tmp20_ = {0};
		PangoRectangle _tmp21_;
		PangoRectangle _tmp22_;
		graphene_point_t _tmp23_ = {0};
		GdkRGBA _tmp24_;
		rounded_rectangle_color_rgba ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile, TYPE_TILE_VIEW, TileView), &_tmp13_);
		color = _tmp13_;
		color.alpha = opacity;
		_tmp14_ = color;
		_tmp15_ = tile_rect;
		gtk_snapshot_append_color (snapshot, &_tmp14_, &_tmp15_);
		_tmp16_ = rounded_rectangle_get_color ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile, TYPE_TILE_VIEW, TileView));
		_tmp17_ = _tmp16_;
		_tmp18_ = double_to_string (pow ((gdouble) 2, (gdouble) _tmp17_));
		_tmp19_ = _tmp18_;
		pango_layout_set_text (layout, _tmp19_, -1);
		_g_free0 (_tmp19_);
		pango_layout_get_extents (layout, NULL, &_tmp20_);
		logical_rect = _tmp20_;
		gtk_snapshot_save (snapshot);
		_tmp21_ = logical_rect;
		_tmp22_ = logical_rect;
		memset (&_tmp23_, 0, sizeof (graphene_point_t));
		_tmp23_.x = (tile_width / 2) - ((_tmp21_.width / 2) / PANGO_SCALE);
		_tmp23_.y = (tile_height / 2) - ((_tmp22_.height / 2) / PANGO_SCALE);
		gtk_snapshot_translate (snapshot, &_tmp23_);
		_tmp24_ = self->priv->_text_color;
		gtk_snapshot_append_layout (snapshot, layout, &_tmp24_);
		gtk_snapshot_restore (snapshot);
	} else {
		GdkRGBA _tmp25_;
		graphene_rect_t _tmp26_;
		_tmp25_ = self->priv->_empty_tile_color;
		_tmp26_ = tile_rect;
		gtk_snapshot_append_color (snapshot, &_tmp25_, &_tmp26_);
	}
	gtk_snapshot_pop (snapshot);
	gtk_snapshot_restore (snapshot);
}

void
game_new_game (Game* self,
               GSettings** settings)
{
	gboolean _tmp0_ = FALSE;
	Grid* _tmp1_;
	guint8 cols = 0U;
	guint8 rows = 0U;
	gboolean _tmp2_ = FALSE;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*settings != NULL);
	if (self->priv->_state != GAME_GAME_STATE_IDLE) {
		_tmp0_ = self->priv->_state != GAME_GAME_STATE_STOPPED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_game_clean_finish_move_animation (self);
	_tmp1_ = self->priv->_grid;
	grid_clear (_tmp1_);
	_game_clear_history (self);
	cols = (guint8) g_settings_get_int (*settings, "cols");
	rows = (guint8) g_settings_get_int (*settings, "rows");
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_rows (_tmp3_);
	_tmp5_ = _tmp4_;
	if (rows != _tmp5_) {
		_tmp2_ = TRUE;
	} else {
		Grid* _tmp6_;
		guint8 _tmp7_;
		guint8 _tmp8_;
		_tmp6_ = self->priv->_grid;
		_tmp7_ = grid_get_cols (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = cols != _tmp8_;
	}
	if (_tmp2_) {
		_game_init_grid (self, rows, cols);
	}
	_game_init_foreground (self);
	game_set_score (self, (glong) 0);
	self->priv->_state = GAME_GAME_STATE_SHOWING_FIRST_TILE;
	_game_create_random_tile (self);
	g_signal_emit (self, game_signals[GAME_UNDO_DISABLED_SIGNAL], 0);
	self->priv->_just_restored = FALSE;
}

void
game_save_game (Game* self)
{
	Grid* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = self->priv->_saved_path;
	grid_save_game (_tmp0_, _tmp1_);
}

gboolean
game_restore_game (Game* self,
                   GSettings** settings)
{
	Grid* _tmp0_;
	const gchar* _tmp1_;
	Grid* _tmp2_;
	guint8 rows = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	guint8 cols = 0U;
	Grid* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*settings != NULL, FALSE);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = self->priv->_saved_path;
	if (!grid_restore_game (_tmp0_, _tmp1_)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_grid;
	game_set_score (self, grid_get_score (_tmp2_));
	_game_init_foreground (self);
	_game_restore_foreground (self, TRUE);
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_rows (_tmp3_);
	_tmp5_ = _tmp4_;
	rows = _tmp5_;
	_tmp6_ = self->priv->_grid;
	_tmp7_ = grid_get_cols (_tmp6_);
	_tmp8_ = _tmp7_;
	cols = _tmp8_;
	if (((gint) rows) == 3) {
		_tmp12_ = ((gint) cols) != 3;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		if (((gint) rows) == 4) {
			_tmp13_ = ((gint) cols) != 4;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp11_ = _tmp13_;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		if (((gint) rows) == 5) {
			_tmp14_ = ((gint) cols) != 5;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp10_ = _tmp14_;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		if (((gint) rows) != 3) {
			_tmp16_ = ((gint) rows) != 4;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			_tmp15_ = ((gint) rows) != 5;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp9_ = _tmp15_;
	}
	if (_tmp9_) {
		g_settings_delay (*settings);
		g_settings_set_int (*settings, "rows", (gint) rows);
		g_settings_set_int (*settings, "cols", (gint) cols);
		g_settings_apply (*settings);
	}
	self->priv->_just_restored = TRUE;
	g_debug ("game.vala:439: game restored successfully");
	result = TRUE;
	return result;
}

gboolean
game_cannot_move (Game* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_state != GAME_GAME_STATE_IDLE) {
		_tmp0_ = self->priv->_state != GAME_GAME_STATE_SHOWING_NEW_TILE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
game_load_settings (Game* self,
                    GSettings** settings)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*settings != NULL);
	self->priv->_animations_duration = (gint) g_settings_get_double (*settings, "animations-speed");
	_game_load_undo_settings (self, settings);
}

static void
_game_init_foreground (Game* self)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	TileView** _tmp6_;
	TileView** _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_tmp6_ = g_new0 (TileView*, (rows * cols) + 1);
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_cur = _tmp6_;
	self->priv->_foreground_cur_length1 = rows;
	self->priv->_foreground_cur_length2 = cols;
	_tmp7_ = g_new0 (TileView*, (rows * cols) + 1);
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_nxt = _tmp7_;
	self->priv->_foreground_nxt_length1 = rows;
	self->priv->_foreground_nxt_length2 = cols;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				if (!_tmp8_) {
					guint8 _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							TileView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							TileView** _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							if (!_tmp10_) {
								guint8 _tmp11_;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp12_ = self->priv->_foreground_cur;
							_tmp12__length1 = self->priv->_foreground_cur_length1;
							_tmp12__length2 = self->priv->_foreground_cur_length2;
							_g_object_unref0 (_tmp12_[(i * _tmp12__length2) + j]);
							_tmp12_[(i * _tmp12__length2) + j] = NULL;
							_tmp13_ = self->priv->_foreground_nxt;
							_tmp13__length1 = self->priv->_foreground_nxt_length1;
							_tmp13__length2 = self->priv->_foreground_nxt_length2;
							_g_object_unref0 (_tmp13_[(i * _tmp13__length2) + j]);
							_tmp13_[(i * _tmp13__length2) + j] = NULL;
						}
					}
				}
			}
		}
	}
}

static void
_game_create_random_tile (Game* self)
{
	Tile tile = {0};
	Grid* _tmp0_;
	Tile _tmp1_ = {0};
	Tile _tmp2_;
	GeeLinkedList* _tmp3_;
	Tile _tmp4_;
	Tile _tmp5_;
	GridPosition _tmp6_;
	AdwAnimation* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	grid_new_tile (_tmp0_, &_tmp1_);
	tile = _tmp1_;
	if (self->priv->_state == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
		self->priv->_update_handled = TRUE;
	} else {
		self->priv->_update_handled = FALSE;
		self->priv->_state = GAME_GAME_STATE_SHOWING_NEW_TILE;
	}
	_game_create_show_hide_transition (self, TRUE);
	_tmp2_ = tile;
	_game_create_tile (self, &_tmp2_);
	_tmp3_ = self->priv->_to_show;
	_tmp4_ = tile;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, &_tmp4_);
	_tmp5_ = tile;
	_tmp6_ = _tmp5_.pos;
	_game_show_tile (self, &_tmp6_);
	_tmp7_ = self->priv->_show_hide_trans;
	adw_animation_play (_tmp7_);
}

static void
_game_create_tile (Game* self,
                   Tile* tile)
{
	GridPosition pos = {0};
	Tile _tmp0_;
	GridPosition _tmp1_;
	TileView** _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	GridPosition _tmp3_;
	GridPosition _tmp4_;
	TileView* _tmp5_;
	TileView** _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	GridPosition _tmp7_;
	GridPosition _tmp8_;
	Tile _tmp9_;
	TileView* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = *tile;
	_tmp1_ = _tmp0_.pos;
	pos = _tmp1_;
	_tmp2_ = self->priv->_foreground_nxt;
	_tmp2__length1 = self->priv->_foreground_nxt_length1;
	_tmp2__length2 = self->priv->_foreground_nxt_length2;
	_tmp3_ = pos;
	_tmp4_ = pos;
	_tmp5_ = _tmp2_[(_tmp3_.row * _tmp2__length2) + _tmp4_.col];
	_vala_assert (_tmp5_ == NULL, "_foreground_nxt [pos.row, pos.col] == null");
	_tmp6_ = self->priv->_foreground_nxt;
	_tmp6__length1 = self->priv->_foreground_nxt_length1;
	_tmp6__length2 = self->priv->_foreground_nxt_length2;
	_tmp7_ = pos;
	_tmp8_ = pos;
	_tmp9_ = *tile;
	_tmp10_ = tile_view_new (_tmp9_.val);
	_g_object_unref0 (_tmp6_[(_tmp7_.row * _tmp6__length2) + _tmp8_.col]);
	_tmp6_[(_tmp7_.row * _tmp6__length2) + _tmp8_.col] = _tmp10_;
}

static void
_game_show_tile (Game* self,
                 GridPosition* pos)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	TileView* tile_view = NULL;
	TileView** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	GridPosition _tmp5_;
	GridPosition _tmp6_;
	TileView* _tmp7_;
	TileView* _tmp8_;
	GeeArrayList* _tmp9_;
	GridPosition _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = grid_position_to_string (pos);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("show tile pos ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("game.vala:503: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->_foreground_nxt;
	_tmp4__length1 = self->priv->_foreground_nxt_length1;
	_tmp4__length2 = self->priv->_foreground_nxt_length2;
	_tmp5_ = *pos;
	_tmp6_ = *pos;
	_tmp7_ = _tmp4_[(_tmp5_.row * _tmp4__length2) + _tmp6_.col];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	tile_view = _tmp8_;
	if (tile_view == NULL) {
		g_assert_not_reached ();
	}
	_tmp9_ = self->priv->_show_trans_tiles;
	_tmp10_ = *pos;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, &_tmp10_);
	_g_object_unref0 (tile_view);
}

static void
_game_move_tile (Game* self,
                 GridPosition* from,
                 GridPosition* to)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GridPosition _tmp6_;
	GridPosition _tmp7_;
	TileView** _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	GridPosition _tmp9_;
	GridPosition _tmp10_;
	TileView** _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	GridPosition _tmp12_;
	GridPosition _tmp13_;
	TileView* _tmp14_;
	TileView* _tmp15_;
	TileView** _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	GridPosition _tmp17_;
	GridPosition _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = grid_position_to_string (from);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (to);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("move tile from ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("game.vala:514: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = *from;
	_tmp7_ = *to;
	_game_prepare_move_tile (self, &_tmp6_, &_tmp7_);
	_tmp8_ = self->priv->_foreground_nxt;
	_tmp8__length1 = self->priv->_foreground_nxt_length1;
	_tmp8__length2 = self->priv->_foreground_nxt_length2;
	_tmp9_ = *to;
	_tmp10_ = *to;
	_tmp11_ = self->priv->_foreground_cur;
	_tmp11__length1 = self->priv->_foreground_cur_length1;
	_tmp11__length2 = self->priv->_foreground_cur_length2;
	_tmp12_ = *from;
	_tmp13_ = *from;
	_tmp14_ = _tmp11_[(_tmp12_.row * _tmp11__length2) + _tmp13_.col];
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (_tmp8_[(_tmp9_.row * _tmp8__length2) + _tmp10_.col]);
	_tmp8_[(_tmp9_.row * _tmp8__length2) + _tmp10_.col] = _tmp15_;
	_tmp16_ = self->priv->_foreground_cur;
	_tmp16__length1 = self->priv->_foreground_cur_length1;
	_tmp16__length2 = self->priv->_foreground_cur_length2;
	_tmp17_ = *from;
	_tmp18_ = *from;
	_g_object_unref0 (_tmp16_[(_tmp17_.row * _tmp16__length2) + _tmp18_.col]);
	_tmp16_[(_tmp17_.row * _tmp16__length2) + _tmp18_.col] = NULL;
}

static void
_game_prepare_move_tile (Game* self,
                         GridPosition* from,
                         GridPosition* to)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TileView* tile_view = NULL;
	TileView** _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	GridPosition _tmp7_;
	GridPosition _tmp8_;
	TileView* _tmp9_;
	TileView* _tmp10_;
	GeeArrayList* _tmp11_;
	GridPosition _tmp12_;
	GridPosition _tmp13_;
	TileMovement _tmp14_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = grid_position_to_string (from);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (to);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("prepare move tile from ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("game.vala:524: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->_foreground_cur;
	_tmp6__length1 = self->priv->_foreground_cur_length1;
	_tmp6__length2 = self->priv->_foreground_cur_length2;
	_tmp7_ = *from;
	_tmp8_ = *from;
	_tmp9_ = _tmp6_[(_tmp7_.row * _tmp6__length2) + _tmp8_.col];
	_tmp10_ = _g_object_ref0 (_tmp9_);
	tile_view = _tmp10_;
	if (tile_view == NULL) {
		g_assert_not_reached ();
	}
	_tmp11_ = self->priv->_move_trans_tiles;
	_tmp12_ = *to;
	_tmp13_ = *from;
	memset (&_tmp14_, 0, sizeof (TileMovement));
	_tmp14_.to = _tmp12_;
	_tmp14_.from = _tmp13_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, &_tmp14_);
	_g_object_unref0 (tile_view);
}

static void
_game_dim_tile (Game* self,
                GridPosition* pos)
{
	TileView* tile_view = NULL;
	TileView** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	GridPosition _tmp1_;
	GridPosition _tmp2_;
	TileView* _tmp3_;
	TileView* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeArrayList* _tmp15_;
	GridPosition _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = self->priv->_foreground_cur;
	_tmp0__length1 = self->priv->_foreground_cur_length1;
	_tmp0__length2 = self->priv->_foreground_cur_length2;
	_tmp1_ = *pos;
	_tmp2_ = *pos;
	_tmp3_ = _tmp0_[(_tmp1_.row * _tmp0__length2) + _tmp2_.col];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tile_view = _tmp4_;
	if (tile_view == NULL) {
		g_assert_not_reached ();
	}
	_tmp5_ = grid_position_to_string (pos);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("diming tile at ", _tmp6_, " ", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = rounded_rectangle_get_color ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile_view, TYPE_TILE_VIEW, TileView));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%hhu", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	g_debug ("game.vala:538: %s", _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp15_ = self->priv->_hide_trans_tiles;
	_tmp16_ = *pos;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, &_tmp16_);
	_g_object_unref0 (tile_view);
}

static void
_game_clear_foreground (Game* self)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					guint8 _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							TileView** _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							TileView** _tmp11_;
							gint _tmp11__length1;
							gint _tmp11__length2;
							if (!_tmp8_) {
								guint8 _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp10_ = self->priv->_foreground_cur;
							_tmp10__length1 = self->priv->_foreground_cur_length1;
							_tmp10__length2 = self->priv->_foreground_cur_length2;
							_g_object_unref0 (_tmp10_[(i * _tmp10__length2) + j]);
							_tmp10_[(i * _tmp10__length2) + j] = NULL;
							_tmp11_ = self->priv->_foreground_nxt;
							_tmp11__length1 = self->priv->_foreground_nxt_length1;
							_tmp11__length2 = self->priv->_foreground_nxt_length2;
							_g_object_unref0 (_tmp11_[(i * _tmp11__length2) + j]);
							_tmp11_[(i * _tmp11__length2) + j] = NULL;
						}
					}
				}
			}
		}
	}
}

static void
_game_restore_foreground (Game* self,
                          gboolean animate)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	GeeLinkedList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_game_create_show_hide_transition (self, animate);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					guint8 _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							guint8 val = 0U;
							Grid* _tmp10_;
							if (!_tmp8_) {
								guint8 _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp10_ = self->priv->_grid;
							val = grid_get (_tmp10_, i, j);
							if (((gint) val) != 0) {
								GridPosition pos = {0};
								GridPosition _tmp11_ = {0};
								Tile tile = {0};
								GridPosition _tmp12_;
								Tile _tmp13_ = {0};
								Tile _tmp14_;
								GeeLinkedList* _tmp15_;
								Tile _tmp16_;
								GridPosition _tmp17_;
								_tmp11_.row = (gint8) i;
								_tmp11_.col = (gint8) j;
								pos = _tmp11_;
								_tmp12_ = pos;
								_tmp13_.pos = _tmp12_;
								_tmp13_.val = val;
								tile = _tmp13_;
								_tmp14_ = tile;
								_game_create_tile (self, &_tmp14_);
								_tmp15_ = self->priv->_to_show;
								_tmp16_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, &_tmp16_);
								_tmp17_ = pos;
								_game_show_tile (self, &_tmp17_);
							}
						}
					}
				}
			}
		}
	}
	_tmp18_ = self->priv->_to_show;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		AdwAnimation* _tmp21_;
		self->priv->_state = GAME_GAME_STATE_RESTORING_TILES;
		_tmp21_ = self->priv->_show_hide_trans;
		adw_animation_play (_tmp21_);
	}
}

static void
__lambda5_ (Game* self,
            gdouble value)
{
	self->priv->_move_trans_value = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda5__adw_animation_target_func (gdouble value,
                                       gpointer self)
{
	__lambda5_ ((Game*) self, value);
}

static void
__game_on_move_trans_stopped_adw_animation_done (AdwAnimation* _sender,
                                                 gpointer self)
{
	_game_on_move_trans_stopped ((Game*) self);
}

void
game_move (Game* self,
           MoveRequest request)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	Grid* clone = NULL;
	Grid* _tmp2_;
	Grid* _tmp3_;
	AdwCallbackAnimationTarget* _tmp4_;
	AdwTimedAnimation* _tmp5_;
	AdwAnimation* _tmp6_;
	Grid* _tmp7_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeLinkedList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	g_return_if_fail (self != NULL);
	if (self->priv->_state == GAME_GAME_STATE_SHOWING_NEW_TILE) {
		_game_apply_move (self);
	} else {
		if (self->priv->_state != GAME_GAME_STATE_IDLE) {
			g_assert_not_reached ();
		}
	}
	_tmp0_ = move_request_debug_string (request);
	_tmp1_ = _tmp0_;
	g_debug ("game.vala:598: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->_grid;
	_tmp3_ = grid_clone (_tmp2_);
	clone = _tmp3_;
	_tmp4_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (___lambda5__adw_animation_target_func, g_object_ref (self), g_object_unref);
	_tmp5_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, 0.0, 1.0, (guint) self->priv->_animations_duration, (AdwAnimationTarget*) _tmp4_);
	_g_object_unref0 (self->priv->_move_trans);
	self->priv->_move_trans = (AdwAnimation*) _tmp5_;
	_tmp6_ = self->priv->_move_trans;
	g_signal_connect_object (_tmp6_, "done", (GCallback) __game_on_move_trans_stopped_adw_animation_done, self, 0);
	_tmp7_ = self->priv->_grid;
	grid_move (_tmp7_, request, &self->priv->_to_move, &self->priv->_to_hide, &self->priv->_to_show);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_;
		gint _e_size = 0;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _e_index = 0;
		_tmp8_ = self->priv->_to_move;
		_e_list = _tmp8_;
		_tmp9_ = _e_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_e_size = _tmp11_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp14_;
			gpointer _tmp15_;
			TileMovement* _tmp16_;
			TileMovement* _tmp17_;
			GridPosition _tmp18_;
			TileMovement* _tmp19_;
			GridPosition _tmp20_;
			_e_index = _e_index + 1;
			_tmp12_ = _e_index;
			_tmp13_ = _e_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _e_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _e_index);
			e = (TileMovement*) _tmp15_;
			_tmp16_ = e;
			if (_tmp16_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp17_ = e;
			_tmp18_ = ((TileMovement) (*_tmp17_)).from;
			_tmp19_ = e;
			_tmp20_ = ((TileMovement) (*_tmp19_)).to;
			_game_move_tile (self, &_tmp18_, &_tmp20_);
			_tile_movement_free0 (e);
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp21_;
		gint _e_size = 0;
		GeeLinkedList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _e_index = 0;
		_tmp21_ = self->priv->_to_hide;
		_e_list = _tmp21_;
		_tmp22_ = _e_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_e_size = _tmp24_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp27_;
			gpointer _tmp28_;
			TileMovement* _tmp29_;
			TileMovement* _tmp30_;
			GridPosition _tmp31_;
			TileMovement* _tmp32_;
			GridPosition _tmp33_;
			_e_index = _e_index + 1;
			_tmp25_ = _e_index;
			_tmp26_ = _e_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _e_list;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _e_index);
			e = (TileMovement*) _tmp28_;
			_tmp29_ = e;
			if (_tmp29_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp30_ = e;
			_tmp31_ = ((TileMovement) (*_tmp30_)).from;
			_tmp32_ = e;
			_tmp33_ = ((TileMovement) (*_tmp32_)).to;
			_game_prepare_move_tile (self, &_tmp31_, &_tmp33_);
			_tile_movement_free0 (e);
		}
	}
	_tmp36_ = self->priv->_to_move;
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		_tmp35_ = TRUE;
	} else {
		GeeLinkedList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp39_ = self->priv->_to_hide;
		_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp35_ = _tmp41_ > 0;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		GeeLinkedList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		_tmp42_ = self->priv->_to_show;
		_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp34_ = _tmp44_ > 0;
	}
	if (_tmp34_) {
		AdwAnimation* _tmp45_;
		Grid* _tmp46_;
		self->priv->_state = GAME_GAME_STATE_MOVING;
		_tmp45_ = self->priv->_move_trans;
		adw_animation_play (_tmp45_);
		_tmp46_ = clone;
		_game_store_movement (self, _tmp46_);
	}
	self->priv->_just_restored = FALSE;
	_g_object_unref0 (clone);
}

static void
_game_on_move_trans_stopped (Game* self)
{
	Grid* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	glong delta_score = 0L;
	glong _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("move animation stopped\n", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_debug ("game.vala:637: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	self->priv->_move_trans_value = (gdouble) -1;
	_tmp5_ = self->priv->_move_trans_tiles;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp6_;
		gint _e_size = 0;
		GeeLinkedList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _e_index = 0;
		_tmp6_ = self->priv->_to_hide;
		_e_list = _tmp6_;
		_tmp7_ = _e_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_e_size = _tmp9_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp12_;
			gpointer _tmp13_;
			TileMovement* _tmp14_;
			TileMovement* _tmp15_;
			GridPosition _tmp16_;
			_e_index = _e_index + 1;
			_tmp10_ = _e_index;
			_tmp11_ = _e_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _e_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _e_index);
			e = (TileMovement*) _tmp13_;
			_tmp14_ = e;
			if (_tmp14_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp15_ = e;
			_tmp16_ = ((TileMovement) (*_tmp15_)).from;
			_game_dim_tile (self, &_tmp16_);
			_tile_movement_free0 (e);
		}
	}
	delta_score = (glong) 0;
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp17_;
		gint _e_size = 0;
		GeeLinkedList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _e_index = 0;
		_tmp17_ = self->priv->_to_show;
		_e_list = _tmp17_;
		_tmp18_ = _e_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_e_size = _tmp20_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			Tile* e = NULL;
			GeeLinkedList* _tmp23_;
			gpointer _tmp24_;
			Tile* _tmp25_;
			Tile* _tmp26_;
			Tile _tmp27_;
			Tile* _tmp28_;
			GridPosition _tmp29_;
			Tile* _tmp30_;
			_e_index = _e_index + 1;
			_tmp21_ = _e_index;
			_tmp22_ = _e_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _e_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _e_index);
			e = (Tile*) _tmp24_;
			_tmp25_ = e;
			if (_tmp25_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp26_ = e;
			_tmp27_ = (Tile) (*_tmp26_);
			_game_create_tile (self, &_tmp27_);
			_tmp28_ = e;
			_tmp29_ = ((Tile) (*_tmp28_)).pos;
			_game_show_tile (self, &_tmp29_);
			_tmp30_ = e;
			delta_score += (glong) pow ((gdouble) 2, (gdouble) ((Tile) (*_tmp30_)).val);
			_tile_free0 (e);
		}
	}
	_tmp31_ = self->priv->_score;
	game_set_score (self, _tmp31_ + delta_score);
	_game_create_random_tile (self);
}

static void
__lambda4_ (Game* self,
            gdouble value)
{
	self->priv->_show_hide_trans_value = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda4__adw_animation_target_func (gdouble value,
                                       gpointer self)
{
	__lambda4_ ((Game*) self, value);
}

static void
__game_on_show_hide_trans_stopped_adw_animation_done (AdwAnimation* _sender,
                                                      gpointer self)
{
	_game_on_show_hide_trans_stopped ((Game*) self);
}

static void
_game_create_show_hide_transition (Game* self,
                                   gboolean animate)
{
	gint _tmp0_ = 0;
	AdwCallbackAnimationTarget* _tmp1_;
	AdwTimedAnimation* _tmp2_;
	AdwAnimation* _tmp3_;
	g_return_if_fail (self != NULL);
	if (animate) {
		_tmp0_ = self->priv->_animations_duration;
	} else {
		_tmp0_ = 10;
	}
	_tmp1_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (___lambda4__adw_animation_target_func, g_object_ref (self), g_object_unref);
	_tmp2_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, 0.0, 1.0, (guint) _tmp0_, (AdwAnimationTarget*) _tmp1_);
	_g_object_unref0 (self->priv->_show_hide_trans);
	self->priv->_show_hide_trans = (AdwAnimation*) _tmp2_;
	_tmp3_ = self->priv->_show_hide_trans;
	g_signal_connect_object (_tmp3_, "done", (GCallback) __game_on_show_hide_trans_stopped_adw_animation_done, self, 0);
}

static void
_game_on_show_hide_trans_stopped (Game* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_debug ("game.vala:691: show/hide animation stopped");
	self->priv->_show_hide_trans_value = (gdouble) -1;
	_tmp0_ = self->priv->_show_trans_tiles;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_hide_trans_tiles;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_game_apply_move (self);
}

static gboolean
__game_finish_move_gsource_func (gpointer self)
{
	gboolean result;
	result = _game_finish_move ((Game*) self);
	return result;
}

static void
_game_apply_move (Game* self)
{
	Grid* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeLinkedList* _tmp75_;
	GeeLinkedList* _tmp76_;
	GeeLinkedList* _tmp77_;
	Grid* _tmp78_;
	gboolean _tmp79_;
	gboolean _tmp80_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("game.vala:700: %s", _tmp2_);
	_g_free0 (_tmp2_);
	if (self->priv->_update_handled) {
		_tmp3_ = self->priv->_state != GAME_GAME_STATE_SHOWING_FIRST_TILE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		return;
	}
	self->priv->_update_handled = TRUE;
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp4_;
		gint _e_size = 0;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _e_index = 0;
		_tmp4_ = self->priv->_to_hide;
		_e_list = _tmp4_;
		_tmp5_ = _e_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_e_size = _tmp7_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp10_;
			gpointer _tmp11_;
			TileMovement* _tmp12_;
			GridPosition pos = {0};
			TileMovement* _tmp13_;
			GridPosition _tmp14_;
			TileView* tile_view = NULL;
			TileView** _tmp15_;
			gint _tmp15__length1;
			gint _tmp15__length2;
			GridPosition _tmp16_;
			GridPosition _tmp17_;
			TileView* _tmp18_;
			TileView* _tmp19_;
			TileView* _tmp20_;
			TileView* _tmp21_;
			guint8 _tmp22_;
			guint8 _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			TileView** _tmp28_;
			gint _tmp28__length1;
			gint _tmp28__length2;
			GridPosition _tmp29_;
			GridPosition _tmp30_;
			_e_index = _e_index + 1;
			_tmp8_ = _e_index;
			_tmp9_ = _e_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _e_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _e_index);
			e = (TileMovement*) _tmp11_;
			_tmp12_ = e;
			if (_tmp12_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp13_ = e;
			_tmp14_ = ((TileMovement) (*_tmp13_)).from;
			pos = _tmp14_;
			_tmp15_ = self->priv->_foreground_cur;
			_tmp15__length1 = self->priv->_foreground_cur_length1;
			_tmp15__length2 = self->priv->_foreground_cur_length2;
			_tmp16_ = pos;
			_tmp17_ = pos;
			_tmp18_ = _tmp15_[(_tmp16_.row * _tmp15__length2) + _tmp17_.col];
			_tmp19_ = _g_object_ref0 (_tmp18_);
			tile_view = _tmp19_;
			_tmp20_ = tile_view;
			if (_tmp20_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp21_ = tile_view;
			_tmp22_ = rounded_rectangle_get_color ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_TILE_VIEW, TileView));
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup_printf ("%hhu", _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat ("remove child ", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			g_debug ("game.vala:715: %s", _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp28_ = self->priv->_foreground_cur;
			_tmp28__length1 = self->priv->_foreground_cur_length1;
			_tmp28__length2 = self->priv->_foreground_cur_length2;
			_tmp29_ = pos;
			_tmp30_ = pos;
			_g_object_unref0 (_tmp28_[(_tmp29_.row * _tmp28__length2) + _tmp30_.col]);
			_tmp28_[(_tmp29_.row * _tmp28__length2) + _tmp30_.col] = NULL;
			_g_object_unref0 (tile_view);
			_tile_movement_free0 (e);
		}
	}
	if (self->priv->_state == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
		self->priv->_state = GAME_GAME_STATE_SHOWING_NEW_TILE;
		g_debug ("game.vala:724: state show second tile");
		_game_create_random_tile (self);
	} else {
		if (self->priv->_state != GAME_GAME_STATE_IDLE) {
			self->priv->_state = GAME_GAME_STATE_IDLE;
			g_debug ("game.vala:730: state idle");
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp31_;
		gint _e_size = 0;
		GeeLinkedList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _e_index = 0;
		_tmp31_ = self->priv->_to_move;
		_e_list = _tmp31_;
		_tmp32_ = _e_list;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_e_size = _tmp34_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp37_;
			gpointer _tmp38_;
			TileMovement* _tmp39_;
			GridPosition to = {0};
			TileMovement* _tmp40_;
			GridPosition _tmp41_;
			TileView** _tmp42_;
			gint _tmp42__length1;
			gint _tmp42__length2;
			GridPosition _tmp43_;
			GridPosition _tmp44_;
			TileView** _tmp45_;
			gint _tmp45__length1;
			gint _tmp45__length2;
			GridPosition _tmp46_;
			GridPosition _tmp47_;
			TileView* _tmp48_;
			TileView* _tmp49_;
			TileView** _tmp50_;
			gint _tmp50__length1;
			gint _tmp50__length2;
			GridPosition _tmp51_;
			GridPosition _tmp52_;
			_e_index = _e_index + 1;
			_tmp35_ = _e_index;
			_tmp36_ = _e_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _e_list;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _e_index);
			e = (TileMovement*) _tmp38_;
			_tmp39_ = e;
			if (_tmp39_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp40_ = e;
			_tmp41_ = ((TileMovement) (*_tmp40_)).to;
			to = _tmp41_;
			_tmp42_ = self->priv->_foreground_cur;
			_tmp42__length1 = self->priv->_foreground_cur_length1;
			_tmp42__length2 = self->priv->_foreground_cur_length2;
			_tmp43_ = to;
			_tmp44_ = to;
			_tmp45_ = self->priv->_foreground_nxt;
			_tmp45__length1 = self->priv->_foreground_nxt_length1;
			_tmp45__length2 = self->priv->_foreground_nxt_length2;
			_tmp46_ = to;
			_tmp47_ = to;
			_tmp48_ = _tmp45_[(_tmp46_.row * _tmp45__length2) + _tmp47_.col];
			_tmp49_ = _g_object_ref0 (_tmp48_);
			_g_object_unref0 (_tmp42_[(_tmp43_.row * _tmp42__length2) + _tmp44_.col]);
			_tmp42_[(_tmp43_.row * _tmp42__length2) + _tmp44_.col] = _tmp49_;
			_tmp50_ = self->priv->_foreground_nxt;
			_tmp50__length1 = self->priv->_foreground_nxt_length1;
			_tmp50__length2 = self->priv->_foreground_nxt_length2;
			_tmp51_ = to;
			_tmp52_ = to;
			_g_object_unref0 (_tmp50_[(_tmp51_.row * _tmp50__length2) + _tmp52_.col]);
			_tmp50_[(_tmp51_.row * _tmp50__length2) + _tmp52_.col] = NULL;
			_tile_movement_free0 (e);
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp53_;
		gint _e_size = 0;
		GeeLinkedList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _e_index = 0;
		_tmp53_ = self->priv->_to_show;
		_e_list = _tmp53_;
		_tmp54_ = _e_list;
		_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_e_size = _tmp56_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp57_;
			gint _tmp58_;
			Tile* e = NULL;
			GeeLinkedList* _tmp59_;
			gpointer _tmp60_;
			Tile* _tmp61_;
			GridPosition pos = {0};
			Tile* _tmp62_;
			GridPosition _tmp63_;
			TileView** _tmp64_;
			gint _tmp64__length1;
			gint _tmp64__length2;
			GridPosition _tmp65_;
			GridPosition _tmp66_;
			TileView** _tmp67_;
			gint _tmp67__length1;
			gint _tmp67__length2;
			GridPosition _tmp68_;
			GridPosition _tmp69_;
			TileView* _tmp70_;
			TileView* _tmp71_;
			TileView** _tmp72_;
			gint _tmp72__length1;
			gint _tmp72__length2;
			GridPosition _tmp73_;
			GridPosition _tmp74_;
			_e_index = _e_index + 1;
			_tmp57_ = _e_index;
			_tmp58_ = _e_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _e_list;
			_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp59_, _e_index);
			e = (Tile*) _tmp60_;
			_tmp61_ = e;
			if (_tmp61_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp62_ = e;
			_tmp63_ = ((Tile) (*_tmp62_)).pos;
			pos = _tmp63_;
			_tmp64_ = self->priv->_foreground_cur;
			_tmp64__length1 = self->priv->_foreground_cur_length1;
			_tmp64__length2 = self->priv->_foreground_cur_length2;
			_tmp65_ = pos;
			_tmp66_ = pos;
			_tmp67_ = self->priv->_foreground_nxt;
			_tmp67__length1 = self->priv->_foreground_nxt_length1;
			_tmp67__length2 = self->priv->_foreground_nxt_length2;
			_tmp68_ = pos;
			_tmp69_ = pos;
			_tmp70_ = _tmp67_[(_tmp68_.row * _tmp67__length2) + _tmp69_.col];
			_tmp71_ = _g_object_ref0 (_tmp70_);
			_g_object_unref0 (_tmp64_[(_tmp65_.row * _tmp64__length2) + _tmp66_.col]);
			_tmp64_[(_tmp65_.row * _tmp64__length2) + _tmp66_.col] = _tmp71_;
			_tmp72_ = self->priv->_foreground_nxt;
			_tmp72__length1 = self->priv->_foreground_nxt_length1;
			_tmp72__length2 = self->priv->_foreground_nxt_length2;
			_tmp73_ = pos;
			_tmp74_ = pos;
			_g_object_unref0 (_tmp72_[(_tmp73_.row * _tmp72__length2) + _tmp74_.col]);
			_tmp72_[(_tmp73_.row * _tmp72__length2) + _tmp74_.col] = NULL;
			_tile_free0 (e);
		}
	}
	_tmp75_ = self->priv->_to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp75_);
	_tmp76_ = self->priv->_to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
	_tmp77_ = self->priv->_to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
	_tmp78_ = self->priv->_grid;
	_tmp79_ = grid_get_target_value_reached (_tmp78_);
	_tmp80_ = _tmp79_;
	if (_tmp80_) {
		Grid* _tmp81_;
		guint _tmp82_;
		guint _tmp83_;
		Grid* _tmp84_;
		_tmp81_ = self->priv->_grid;
		_tmp82_ = grid_get_target_value (_tmp81_);
		_tmp83_ = _tmp82_;
		g_signal_emit (self, game_signals[GAME_TARGET_VALUE_REACHED_SIGNAL], 0, _tmp83_);
		_tmp84_ = self->priv->_grid;
		grid_set_target_value_reached (_tmp84_, FALSE);
	}
	if (!self->priv->_just_restored) {
		self->priv->_finish_move_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __game_finish_move_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		Grid* _tmp85_;
		_tmp85_ = self->priv->_grid;
		if (grid_is_finished (_tmp85_)) {
			g_signal_emit (self, game_signals[GAME_FINISHED_SIGNAL], 0, FALSE);
		}
	}
}

static gboolean
_game_finish_move (Game* self)
{
	Grid* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_grid;
	if (grid_is_finished (_tmp0_)) {
		g_signal_emit (self, game_signals[GAME_FINISHED_SIGNAL], 0, TRUE);
	}
	self->priv->_finish_move_id = (guint) 0;
	result = FALSE;
	return result;
}

static inline void
_game_clean_finish_move_animation (Game* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_finish_move_id > ((guint) 0)) {
		g_source_remove (self->priv->_finish_move_id);
	}
}

void
game_undo (Game* self)
{
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	Grid* _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->_allow_undo == TRUE, "_allow_undo == true");
	if (self->priv->_state != GAME_GAME_STATE_IDLE) {
		return;
	}
	_game_clear_foreground (self);
	_tmp0_ = self->priv->_undo_stack;
	_tmp1_ = gee_deque_poll_head ((GeeDeque*) _tmp0_);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_grid = G_TYPE_CHECK_INSTANCE_CAST ((Grid*) _tmp1_, TYPE_GRID, Grid);
	_game_restore_foreground (self, FALSE);
	_tmp2_ = self->priv->_grid;
	game_set_score (self, grid_get_score (_tmp2_));
	_tmp3_ = self->priv->_undo_stack;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		g_signal_emit (self, game_signals[GAME_UNDO_DISABLED_SIGNAL], 0);
	}
	self->priv->_update_handled = FALSE;
}

static void
_game_load_undo_settings (Game* self,
                          GSettings** settings)
{
	gboolean allow_undo = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*settings != NULL);
	allow_undo = g_settings_get_boolean (*settings, "allow-undo");
	if (self->priv->_allow_undo) {
		_tmp0_ = !allow_undo;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_game_clear_history (self);
		g_signal_emit (self, game_signals[GAME_UNDO_DISABLED_SIGNAL], 0);
	}
	self->priv->_allow_undo = allow_undo;
	self->priv->_undo_stack_max_size = g_settings_get_uint (*settings, "allow-undo-max");
}

static void
_game_clear_history (Game* self)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_undo_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
}

static void
_game_store_movement (Game* self,
                      Grid* clone)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeLinkedList* _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clone != NULL);
	if (!self->priv->_allow_undo) {
		return;
	}
	_tmp0_ = self->priv->_undo_stack;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (((guint) _tmp2_) >= self->priv->_undo_stack_max_size) {
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		Grid* _tmp5_;
		_tmp3_ = self->priv->_undo_stack;
		_tmp4_ = gee_deque_poll_tail ((GeeDeque*) _tmp3_);
		_tmp5_ = (Grid*) _tmp4_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->_undo_stack;
	gee_deque_offer_head ((GeeDeque*) _tmp6_, clone);
	_tmp7_ = self->priv->_undo_stack;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 1) {
		g_signal_emit (self, game_signals[GAME_UNDO_ENABLED_SIGNAL], 0);
	}
}

Game*
game_construct (GType object_type)
{
	Game * self = NULL;
	self = (Game*) g_object_new (object_type, NULL);
	return self;
}

Game*
game_new (void)
{
	return game_construct (TYPE_GAME);
}

glong
game_get_score (Game* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_score;
	return result;
}

static void
game_set_score (Game* self,
                glong value)
{
	glong old_value;
	g_return_if_fail (self != NULL);
	old_value = game_get_score (self);
	if (old_value != value) {
		self->priv->_score = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SCORE_PROPERTY]);
	}
}

static gboolean
_game_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                           guint keyval,
                                                           guint keycode,
                                                           GdkModifierType state,
                                                           gpointer self)
{
	gboolean result;
	result = game_on_key_pressed ((Game*) self, _sender, keyval, keycode, state);
	return result;
}

static void
__game_on_swipe_gtk_gesture_swipe_swipe (GtkGestureSwipe* _sender,
                                         gdouble velocity_x,
                                         gdouble velocity_y,
                                         gpointer self)
{
	_game_on_swipe ((Game*) self, _sender, velocity_x, velocity_y);
}

static GObject *
game_constructor (GType type,
                  guint n_construct_properties,
                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Game * self;
	GSettings* _tmp0_;
	guint8 cols = 0U;
	GSettings* _tmp1_;
	guint8 rows = 0U;
	GSettings* _tmp2_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp3_;
	GtkEventControllerKey* _tmp4_;
	GtkEventControllerKey* _tmp5_;
	GtkEventController* _tmp6_;
	GtkGestureSwipe* gesture_swipe = NULL;
	GtkGestureSwipe* _tmp7_;
	GtkGestureSwipe* _tmp8_;
	GtkGestureSwipe* _tmp9_;
	GtkGestureSwipe* _tmp10_;
	GtkGestureSwipe* _tmp11_;
	GtkEventController* _tmp12_;
	parent_class = G_OBJECT_CLASS (game_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_tmp0_ = g_settings_new ("org.gnome.TwentyFortyEight");
	_g_object_unref0 (self->settings);
	self->settings = _tmp0_;
	gdk_rgba_parse (&self->priv->_background_color, "#babdb6");
	gdk_rgba_parse (&self->priv->_empty_tile_color, "#ffffff");
	gdk_rgba_parse (&self->priv->_text_color, "#ffffff");
	g_object_set ((GtkWidget*) self, "width-request", 350, NULL);
	g_object_set ((GtkWidget*) self, "height-request", 350, NULL);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	_tmp1_ = self->settings;
	cols = (guint8) g_settings_get_int (_tmp1_, "cols");
	_tmp2_ = self->settings;
	rows = (guint8) g_settings_get_int (_tmp2_, "rows");
	_game_init_grid (self, rows, cols);
	_tmp3_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp3_;
	_tmp4_ = key_controller;
	g_signal_connect_object (_tmp4_, "key-pressed", (GCallback) _game_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp5_ = key_controller;
	_tmp6_ = _g_object_ref0 ((GtkEventController*) _tmp5_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp6_);
	_tmp7_ = (GtkGestureSwipe*) gtk_gesture_swipe_new ();
	gesture_swipe = _tmp7_;
	_tmp8_ = gesture_swipe;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp8_, GTK_PHASE_CAPTURE);
	_tmp9_ = gesture_swipe;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp9_, (guint) 0);
	_tmp10_ = gesture_swipe;
	g_signal_connect_object (_tmp10_, "swipe", (GCallback) __game_on_swipe_gtk_gesture_swipe_swipe, self, 0);
	_tmp11_ = gesture_swipe;
	_tmp12_ = _g_object_ref0 ((GtkEventController*) _tmp11_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp12_);
	_g_object_unref0 (gesture_swipe);
	_g_object_unref0 (key_controller);
	return obj;
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) game_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE_PROPERTY, game_properties[GAME_SCORE_PROPERTY] = g_param_spec_long ("score", "score", "score", G_MINLONG, G_MAXLONG, (glong) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_FINISHED_SIGNAL] = g_signal_new ("finished", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	game_signals[GAME_TARGET_VALUE_REACHED_SIGNAL] = g_signal_new ("target-value-reached", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	game_signals[GAME_UNDO_ENABLED_SIGNAL] = g_signal_new ("undo-enabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_UNDO_DISABLED_SIGNAL] = g_signal_new ("undo-disabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GeeLinkedList* _tmp8_;
	self->priv = game_get_instance_private (self);
	self->priv->BLANK_COL_WIDTH = 10;
	self->priv->BLANK_ROW_HEIGHT = 10;
	_tmp0_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	self->priv->_to_move = _tmp0_;
	_tmp1_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	self->priv->_to_hide = _tmp1_;
	_tmp2_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, (GDestroyNotify) tile_free, NULL, NULL, NULL);
	self->priv->_to_show = _tmp2_;
	self->priv->_state = GAME_GAME_STATE_STOPPED;
	_tmp3_ = gee_array_list_new (TYPE_GRID_POSITION, (GBoxedCopyFunc) grid_position_dup, (GDestroyNotify) grid_position_free, NULL, NULL, NULL);
	self->priv->_show_trans_tiles = _tmp3_;
	_tmp4_ = gee_array_list_new (TYPE_GRID_POSITION, (GBoxedCopyFunc) grid_position_dup, (GDestroyNotify) grid_position_free, NULL, NULL, NULL);
	self->priv->_hide_trans_tiles = _tmp4_;
	self->priv->_show_hide_trans_value = (gdouble) -1;
	self->priv->_move_trans_value = (gdouble) -1;
	_tmp5_ = gee_array_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	self->priv->_move_trans_tiles = _tmp5_;
	_tmp6_ = g_get_user_data_dir ();
	_tmp7_ = g_build_filename (_tmp6_, "gnome-2048", "saved", NULL);
	self->priv->_saved_path = _tmp7_;
	self->priv->_just_restored = TRUE;
	self->priv->_score = (glong) 0;
	self->priv->_finish_move_id = (guint) 0;
	self->priv->_update_handled = FALSE;
	self->priv->_allow_undo = FALSE;
	_tmp8_ = gee_linked_list_new (TYPE_GRID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_undo_stack = _tmp8_;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_to_move);
	_g_object_unref0 (self->priv->_to_hide);
	_g_object_unref0 (self->priv->_to_show);
	_g_object_unref0 (self->priv->_show_hide_trans);
	_g_object_unref0 (self->priv->_show_trans_tiles);
	_g_object_unref0 (self->priv->_hide_trans_tiles);
	_g_object_unref0 (self->priv->_move_trans);
	_g_object_unref0 (self->priv->_move_trans_tiles);
	_g_free0 (self->priv->_saved_path);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->_undo_stack);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

static GType
game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
	GType game_type_id;
	game_type_id = g_type_register_static (gtk_widget_get_type (), "Game", &g_define_type_info, 0);
	Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
	return game_type_id;
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__once = 0;
	if (g_once_init_enter (&game_type_id__once)) {
		GType game_type_id;
		game_type_id = game_get_type_once ();
		g_once_init_leave (&game_type_id__once, game_type_id);
	}
	return game_type_id__once;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SCORE_PROPERTY:
		g_value_set_long (value, game_get_score (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SCORE_PROPERTY:
		game_set_score (self, g_value_get_long (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

