/* view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from view.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;
typedef struct _RoundedRectanglePrivate RoundedRectanglePrivate;
enum  {
	ROUNDED_RECTANGLE_0_PROPERTY,
	ROUNDED_RECTANGLE_COLOR_PROPERTY,
	ROUNDED_RECTANGLE_NUM_PROPERTIES
};
static GParamSpec* rounded_rectangle_properties[ROUNDED_RECTANGLE_NUM_PROPERTIES];
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;
typedef struct _TileViewPrivate TileViewPrivate;
enum  {
	TILE_VIEW_0_PROPERTY,
	TILE_VIEW_NUM_PROPERTIES
};
static GParamSpec* tile_view_properties[TILE_VIEW_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RoundedRectangle {
	GObject parent_instance;
	RoundedRectanglePrivate * priv;
};

struct _RoundedRectangleClass {
	GObjectClass parent_class;
};

struct _RoundedRectanglePrivate {
	GdkRGBA _color;
	guint8 _color_index;
};

struct _TileView {
	RoundedRectangle parent_instance;
	TileViewPrivate * priv;
};

struct _TileViewClass {
	RoundedRectangleClass parent_class;
};

static gint RoundedRectangle_private_offset;
static gpointer rounded_rectangle_parent_class = NULL;
static GHashTable* rounded_rectangle_colors;
static GHashTable* rounded_rectangle_colors = NULL;
static gpointer tile_view_parent_class = NULL;

VALA_EXTERN GType rounded_rectangle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RoundedRectangle, g_object_unref)
static void _vala_GdkRGBA_free (GdkRGBA* self);
static void __vala_GdkRGBA_free0_ (gpointer var);
VALA_EXTERN RoundedRectangle* rounded_rectangle_new (void);
VALA_EXTERN RoundedRectangle* rounded_rectangle_construct (GType object_type);
static void rounded_rectangle_color_from_string (const gchar* color,
                                          GdkRGBA* result);
VALA_EXTERN void rounded_rectangle_color_rgba (RoundedRectangle* self,
                                   GdkRGBA* result);
static void _rounded_rectangle_new_color (guint8 tile_value,
                                   GdkRGBA* color);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN guint8 rounded_rectangle_get_color (RoundedRectangle* self);
static void rounded_rectangle_set_color (RoundedRectangle* self,
                                  guint8 value);
static void rounded_rectangle_finalize (GObject * obj);
static GType rounded_rectangle_get_type_once (void);
static void _vala_rounded_rectangle_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_rounded_rectangle_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
VALA_EXTERN GType tile_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TileView, g_object_unref)
VALA_EXTERN TileView* tile_view_new (guint8 val);
VALA_EXTERN TileView* tile_view_construct (GType object_type,
                               guint8 val);
static GType tile_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rounded_rectangle_get_instance_private (RoundedRectangle* self)
{
	return G_STRUCT_MEMBER_P (self, RoundedRectangle_private_offset);
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
__vala_GdkRGBA_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL));
}

RoundedRectangle*
rounded_rectangle_construct (GType object_type)
{
	RoundedRectangle * self = NULL;
	self = (RoundedRectangle*) g_object_new (object_type, "color", 0, NULL);
	return self;
}

RoundedRectangle*
rounded_rectangle_new (void)
{
	return rounded_rectangle_construct (TYPE_ROUNDED_RECTANGLE);
}

static void
rounded_rectangle_color_from_string (const gchar* color,
                                     GdkRGBA* result)
{
	GdkRGBA c = {0};
	g_return_if_fail (color != NULL);
	memset (&c, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&c, color);
	*result = c;
	return;
}

void
rounded_rectangle_color_rgba (RoundedRectangle* self,
                              GdkRGBA* result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_color;
	*result = _tmp0_;
	return;
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
_rounded_rectangle_new_color (guint8 tile_value,
                              GdkRGBA* color)
{
	GdkRGBA _vala_color = {0};
	GdkRGBA* nullable_color = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GdkRGBA* _tmp2_;
	guint8 sbits = 0U;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GHashTable* _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA* _tmp8_;
	_vala_return_if_fail (((gint) tile_value) >= 12, "tile_value >= 12");
	_vala_return_if_fail (((gint) tile_value) <= 81, "tile_value <= 81");
	_tmp0_ = rounded_rectangle_colors;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) (((tile_value - 1) % 11) + 1)));
	_tmp2_ = __vala_GdkRGBA_copy0 ((GdkRGBA*) _tmp1_);
	nullable_color = _tmp2_;
	if (nullable_color == NULL) {
		g_assert_not_reached ();
	}
	_vala_color = (GdkRGBA) (*nullable_color);
	sbits = (guint8) fmod (pow ((gdouble) 2, (gdouble) tile_value), 7);
	_tmp3_ = _vala_color;
	_vala_color.red = ((gfloat) (((guint8) (_tmp3_.red * 255)) << sbits)) / 255;
	_tmp4_ = _vala_color;
	_vala_color.green = ((gfloat) (((guint8) (_tmp4_.green * 255)) << sbits)) / 255;
	_tmp5_ = _vala_color;
	_vala_color.blue = ((gfloat) (((guint8) (_tmp5_.blue * 255)) << sbits)) / 255;
	_tmp6_ = rounded_rectangle_colors;
	_tmp7_ = _vala_color;
	_tmp8_ = __vala_GdkRGBA_copy0 (&_tmp7_);
	g_hash_table_insert (_tmp6_, (gpointer) ((gintptr) tile_value), _tmp8_);
	__vala_GdkRGBA_free0 (nullable_color);
	if (color) {
		*color = _vala_color;
	}
}

guint8
rounded_rectangle_get_color (RoundedRectangle* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_color_index;
	return result;
}

static void
rounded_rectangle_set_color (RoundedRectangle* self,
                             guint8 value)
{
	GdkRGBA* color = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GdkRGBA* _tmp2_;
	GdkRGBA* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_color_index = value;
	_tmp0_ = rounded_rectangle_colors;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) value));
	_tmp2_ = __vala_GdkRGBA_copy0 ((GdkRGBA*) _tmp1_);
	color = _tmp2_;
	_tmp3_ = color;
	if (_tmp3_ == NULL) {
		GdkRGBA _tmp4_ = {0};
		_rounded_rectangle_new_color (value, &_tmp4_);
		self->priv->_color = _tmp4_;
	} else {
		GdkRGBA* _tmp5_;
		_tmp5_ = color;
		self->priv->_color = (GdkRGBA) (*_tmp5_);
	}
	__vala_GdkRGBA_free0 (color);
}

static void
rounded_rectangle_class_init (RoundedRectangleClass * klass,
                              gpointer klass_data)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA* _tmp5_;
	GHashTable* _tmp6_;
	GdkRGBA _tmp7_ = {0};
	GdkRGBA* _tmp8_;
	GHashTable* _tmp9_;
	GdkRGBA _tmp10_ = {0};
	GdkRGBA* _tmp11_;
	GHashTable* _tmp12_;
	GdkRGBA _tmp13_ = {0};
	GdkRGBA* _tmp14_;
	GHashTable* _tmp15_;
	GdkRGBA _tmp16_ = {0};
	GdkRGBA* _tmp17_;
	GHashTable* _tmp18_;
	GdkRGBA _tmp19_ = {0};
	GdkRGBA* _tmp20_;
	GHashTable* _tmp21_;
	GdkRGBA _tmp22_ = {0};
	GdkRGBA* _tmp23_;
	GHashTable* _tmp24_;
	GdkRGBA _tmp25_ = {0};
	GdkRGBA* _tmp26_;
	GHashTable* _tmp27_;
	GdkRGBA _tmp28_ = {0};
	GdkRGBA* _tmp29_;
	GHashTable* _tmp30_;
	GdkRGBA _tmp31_ = {0};
	GdkRGBA* _tmp32_;
	GHashTable* _tmp33_;
	GdkRGBA _tmp34_ = {0};
	GdkRGBA* _tmp35_;
	GHashTable* _tmp36_;
	GdkRGBA _tmp37_ = {0};
	GdkRGBA* _tmp38_;
	rounded_rectangle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RoundedRectangle_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rounded_rectangle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rounded_rectangle_set_property;
	G_OBJECT_CLASS (klass)->finalize = rounded_rectangle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_COLOR_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_COLOR_PROPERTY] = g_param_spec_uchar ("color", "color", "color", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __vala_GdkRGBA_free0_);
	rounded_rectangle_colors = _tmp2_;
	_tmp3_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#ffffff", &_tmp4_);
	_tmp5_ = __vala_GdkRGBA_copy0 (&_tmp4_);
	g_hash_table_insert (_tmp3_, (gpointer) ((gintptr) 0), _tmp5_);
	_tmp6_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#fce94f", &_tmp7_);
	_tmp8_ = __vala_GdkRGBA_copy0 (&_tmp7_);
	g_hash_table_insert (_tmp6_, (gpointer) ((gintptr) 1), _tmp8_);
	_tmp9_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#8ae234", &_tmp10_);
	_tmp11_ = __vala_GdkRGBA_copy0 (&_tmp10_);
	g_hash_table_insert (_tmp9_, (gpointer) ((gintptr) 2), _tmp11_);
	_tmp12_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#fcaf3e", &_tmp13_);
	_tmp14_ = __vala_GdkRGBA_copy0 (&_tmp13_);
	g_hash_table_insert (_tmp12_, (gpointer) ((gintptr) 3), _tmp14_);
	_tmp15_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#729fcf", &_tmp16_);
	_tmp17_ = __vala_GdkRGBA_copy0 (&_tmp16_);
	g_hash_table_insert (_tmp15_, (gpointer) ((gintptr) 4), _tmp17_);
	_tmp18_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#ad7fa8", &_tmp19_);
	_tmp20_ = __vala_GdkRGBA_copy0 (&_tmp19_);
	g_hash_table_insert (_tmp18_, (gpointer) ((gintptr) 5), _tmp20_);
	_tmp21_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#c17d11", &_tmp22_);
	_tmp23_ = __vala_GdkRGBA_copy0 (&_tmp22_);
	g_hash_table_insert (_tmp21_, (gpointer) ((gintptr) 6), _tmp23_);
	_tmp24_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#ef2929", &_tmp25_);
	_tmp26_ = __vala_GdkRGBA_copy0 (&_tmp25_);
	g_hash_table_insert (_tmp24_, (gpointer) ((gintptr) 7), _tmp26_);
	_tmp27_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#c4a000", &_tmp28_);
	_tmp29_ = __vala_GdkRGBA_copy0 (&_tmp28_);
	g_hash_table_insert (_tmp27_, (gpointer) ((gintptr) 8), _tmp29_);
	_tmp30_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#4e9a06", &_tmp31_);
	_tmp32_ = __vala_GdkRGBA_copy0 (&_tmp31_);
	g_hash_table_insert (_tmp30_, (gpointer) ((gintptr) 9), _tmp32_);
	_tmp33_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#ce5c00", &_tmp34_);
	_tmp35_ = __vala_GdkRGBA_copy0 (&_tmp34_);
	g_hash_table_insert (_tmp33_, (gpointer) ((gintptr) 10), _tmp35_);
	_tmp36_ = rounded_rectangle_colors;
	rounded_rectangle_color_from_string ("#204a87", &_tmp37_);
	_tmp38_ = __vala_GdkRGBA_copy0 (&_tmp37_);
	g_hash_table_insert (_tmp36_, (gpointer) ((gintptr) 11), _tmp38_);
}

static void
rounded_rectangle_instance_init (RoundedRectangle * self,
                                 gpointer klass)
{
	self->priv = rounded_rectangle_get_instance_private (self);
}

static void
rounded_rectangle_finalize (GObject * obj)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	G_OBJECT_CLASS (rounded_rectangle_parent_class)->finalize (obj);
}

static GType
rounded_rectangle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RoundedRectangleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rounded_rectangle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RoundedRectangle), 0, (GInstanceInitFunc) rounded_rectangle_instance_init, NULL };
	GType rounded_rectangle_type_id;
	rounded_rectangle_type_id = g_type_register_static (G_TYPE_OBJECT, "RoundedRectangle", &g_define_type_info, 0);
	RoundedRectangle_private_offset = g_type_add_instance_private (rounded_rectangle_type_id, sizeof (RoundedRectanglePrivate));
	return rounded_rectangle_type_id;
}

GType
rounded_rectangle_get_type (void)
{
	static volatile gsize rounded_rectangle_type_id__once = 0;
	if (g_once_init_enter (&rounded_rectangle_type_id__once)) {
		GType rounded_rectangle_type_id;
		rounded_rectangle_type_id = rounded_rectangle_get_type_once ();
		g_once_init_leave (&rounded_rectangle_type_id__once, rounded_rectangle_type_id);
	}
	return rounded_rectangle_type_id__once;
}

static void
_vala_rounded_rectangle_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	switch (property_id) {
		case ROUNDED_RECTANGLE_COLOR_PROPERTY:
		g_value_set_uchar (value, rounded_rectangle_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rounded_rectangle_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	switch (property_id) {
		case ROUNDED_RECTANGLE_COLOR_PROPERTY:
		rounded_rectangle_set_color (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

TileView*
tile_view_construct (GType object_type,
                     guint8 val)
{
	TileView * self = NULL;
	self = (TileView*) g_object_new (object_type, "color", val, NULL);
	return self;
}

TileView*
tile_view_new (guint8 val)
{
	return tile_view_construct (TYPE_TILE_VIEW, val);
}

static void
tile_view_class_init (TileViewClass * klass,
                      gpointer klass_data)
{
	tile_view_parent_class = g_type_class_peek_parent (klass);
}

static void
tile_view_instance_init (TileView * self,
                         gpointer klass)
{
}

static GType
tile_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TileViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileView), 0, (GInstanceInitFunc) tile_view_instance_init, NULL };
	GType tile_view_type_id;
	tile_view_type_id = g_type_register_static (TYPE_ROUNDED_RECTANGLE, "TileView", &g_define_type_info, 0);
	return tile_view_type_id;
}

GType
tile_view_get_type (void)
{
	static volatile gsize tile_view_type_id__once = 0;
	if (g_once_init_enter (&tile_view_type_id__once)) {
		GType tile_view_type_id;
		tile_view_type_id = tile_view_get_type_once ();
		g_once_init_leave (&tile_view_type_id__once, tile_view_type_id);
	}
	return tile_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

