/* colourwheel.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from colourwheel.vala, do not modify */

/*
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2025 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][~)(}{_!$ "-](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <graphene-gobject.h>
#include <gsk/gsk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#define COLOUR_WHEEL_SEGMENT_PIx2 6.28318530717958647692528676655900577
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_COLOUR_WHEEL_SEGMENT (colour_wheel_segment_get_type ())
#define COLOUR_WHEEL_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment))
#define COLOUR_WHEEL_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegmentClass))
#define IS_COLOUR_WHEEL_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOUR_WHEEL_SEGMENT))
#define IS_COLOUR_WHEEL_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOUR_WHEEL_SEGMENT))
#define COLOUR_WHEEL_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegmentClass))

typedef struct _ColourWheelSegment ColourWheelSegment;
typedef struct _ColourWheelSegmentClass ColourWheelSegmentClass;
typedef struct _ColourWheelSegmentPrivate ColourWheelSegmentPrivate;
enum  {
	COLOUR_WHEEL_SEGMENT_0_PROPERTY,
	COLOUR_WHEEL_SEGMENT_COLOUR_PROPERTY,
	COLOUR_WHEEL_SEGMENT_NUM_PROPERTIES
};
static GParamSpec* colour_wheel_segment_properties[COLOUR_WHEEL_SEGMENT_NUM_PROPERTIES];
#define _gsk_path_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_unref (var), NULL)))

#define TYPE_COLOUR_WHEEL (colour_wheel_get_type ())
#define COLOUR_WHEEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOUR_WHEEL, ColourWheel))
#define COLOUR_WHEEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOUR_WHEEL, ColourWheelClass))
#define IS_COLOUR_WHEEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOUR_WHEEL))
#define IS_COLOUR_WHEEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOUR_WHEEL))
#define COLOUR_WHEEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOUR_WHEEL, ColourWheelClass))

typedef struct _ColourWheel ColourWheel;
typedef struct _ColourWheelClass ColourWheelClass;
#define _gsk_path_builder_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_builder_unref (var), NULL)))
typedef struct _ColourWheelPrivate ColourWheelPrivate;
typedef void (*ColourWheelResultFunction) (gint r, gpointer user_data);
enum  {
	COLOUR_WHEEL_0_PROPERTY,
	COLOUR_WHEEL_NUM_PROPERTIES
};
static GParamSpec* colour_wheel_properties[COLOUR_WHEEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

struct _ColourWheelSegment {
	GtkWidget parent_instance;
	ColourWheelSegmentPrivate * priv;
	gboolean transparent;
	graphene_point_t offset_from_parent;
};

struct _ColourWheelSegmentClass {
	GtkWidgetClass parent_class;
};

struct _ColourWheelSegmentPrivate {
	gulong _colour;
	GskPath* segment_path;
};

struct _ColourWheel {
	GtkWidget parent_instance;
	ColourWheelPrivate * priv;
};

struct _ColourWheelClass {
	GtkWidgetClass parent_class;
};

struct _ColourWheelPrivate {
	ColourWheelSegment* __initilisation_segment;
	ColourWheelResultFunction result_function;
	gpointer result_function_target;
	graphene_point_t mouse_point;
	gboolean mouse_point_valid;
	gboolean mouse_depressed;
};

static gint ColourWheelSegment_private_offset;
static gpointer colour_wheel_segment_parent_class = NULL;
static gint ColourWheel_private_offset;
static gpointer colour_wheel_parent_class = NULL;

VALA_EXTERN GType colour_wheel_segment_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ColourWheelSegment, g_object_unref)
VALA_EXTERN GskPath* colour_wheel_segment_get_path (ColourWheelSegment* self);
static void colour_wheel_segment_real_snapshot (GtkWidget* base,
                                         GtkSnapshot* snapshot);
VALA_EXTERN GType colour_wheel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ColourWheel, g_object_unref)
VALA_EXTERN gint colour_wheel_GetVisibleID (ColourWheel* self,
                                ColourWheelSegment* s);
VALA_EXTERN guint colour_wheel_GetVisibleSegmentCount (ColourWheel* self);
VALA_EXTERN GskPath* colour_wheel_segment_calculate_segment_path (ColourWheelSegment* self,
                                                      guint width,
                                                      guint height,
                                                      guint ID,
                                                      guint segment_count);
static gboolean colour_wheel_segment_real_focus (GtkWidget* base,
                                          GtkDirectionType direction);
VALA_EXTERN ColourWheelSegment* colour_wheel_segment_new (void);
VALA_EXTERN ColourWheelSegment* colour_wheel_segment_construct (GType object_type);
VALA_EXTERN gulong colour_wheel_segment_get_colour (ColourWheelSegment* self);
VALA_EXTERN void colour_wheel_segment_set_colour (ColourWheelSegment* self,
                                      gulong value);
static GObject * colour_wheel_segment_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void colour_wheel_segment_finalize (GObject * obj);
static GType colour_wheel_segment_get_type_once (void);
static void _vala_colour_wheel_segment_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_colour_wheel_segment_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static ColourWheelSegment** colour_wheel_get_visible_segments (ColourWheel* self,
                                                        gint* result_length1);
static void _vala_array_add1 (ColourWheelSegment** * array,
                       gint* length,
                       gint* size,
                       ColourWheelSegment* value);
static void _vala_array_add2 (ColourWheelSegment** * array,
                       gint* length,
                       gint* size,
                       ColourWheelSegment* value);
static void colour_wheel_real_size_allocate (GtkWidget* base,
                                      gint width,
                                      gint height,
                                      gint baseline);
static gboolean colour_wheel_real_focus (GtkWidget* base,
                                  GtkDirectionType direction);
VALA_EXTERN ColourWheelSegment* colour_wheel_get_is_focus_child (ColourWheel* self);
VALA_EXTERN ColourWheelSegment* colour_wheel_get_mouse_point_segment (ColourWheel* self);
static void colour_wheel_move_mouse (ColourWheel* self);
static void colour_wheel_select (ColourWheel* self,
                          ColourWheelSegment* segment);
VALA_EXTERN void colour_wheel_do_select_segment (ColourWheel* self,
                                     gint current_selection,
                                     ColourWheelResultFunction result_function,
                                     gpointer result_function_target);
static void colour_wheel_real_snapshot (GtkWidget* base,
                                 GtkSnapshot* snapshot);
static void colour_wheel_draw_label (ColourWheel* self,
                              GtkSnapshot* snapshot,
                              gdouble width,
                              gdouble height,
                              const gchar* text);
static gint colour_wheel_calculate_font_size (ColourWheel* self,
                                       const gchar* text,
                                       gint target_width,
                                       gdouble* width,
                                       gdouble* height);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void colour_wheel_draw_text_font_size (ColourWheel* self,
                                       GtkSnapshot* snapshot,
                                       gint x,
                                       gint y,
                                       const gchar* text,
                                       gint font_size);
static void colour_wheel_get_text_offsets (ColourWheel* self,
                                    const gchar* text,
                                    gint font_size,
                                    gint* x_offset,
                                    gint* y_offset);
VALA_EXTERN ColourWheel* colour_wheel_new (void);
VALA_EXTERN ColourWheel* colour_wheel_construct (GType object_type);
static GObject * colour_wheel_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _colour_wheel___lambda10_ (ColourWheel* self,
                                gdouble x,
                                gdouble y);
static void __colour_wheel___lambda10__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self);
static void _colour_wheel___lambda11_ (ColourWheel* self,
                                gdouble x,
                                gdouble y);
static void __colour_wheel___lambda11__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   gpointer self);
static void _colour_wheel___lambda12_ (ColourWheel* self);
static void __colour_wheel___lambda12__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                   gpointer self);
static gboolean _colour_wheel___lambda13_ (ColourWheel* self,
                                    GdkEvent* event);
static gboolean __colour_wheel___lambda13__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                                       GdkEvent* event,
                                                                       gpointer self);
static void _colour_wheel___lambda14_ (ColourWheel* self,
                                guint keyval,
                                guint keycode,
                                GdkModifierType state);
static void __colour_wheel___lambda14__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state,
                                                                       gpointer self);
static void colour_wheel_finalize (GObject * obj);
static GType colour_wheel_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
colour_wheel_segment_get_instance_private (ColourWheelSegment* self)
{
	return G_STRUCT_MEMBER_P (self, ColourWheelSegment_private_offset);
}

static gpointer
_gsk_path_ref0 (gpointer self)
{
	return self ? gsk_path_ref (self) : NULL;
}

GskPath*
colour_wheel_segment_get_path (ColourWheelSegment* self)
{
	GskPath* _tmp0_;
	GskPath* _tmp1_;
	GskPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->segment_path;
	_tmp1_ = _gsk_path_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
colour_wheel_segment_real_snapshot (GtkWidget* base,
                                    GtkSnapshot* snapshot)
{
	ColourWheelSegment * self;
	self = (ColourWheelSegment*) base;
	g_return_if_fail (snapshot != NULL);
	if (!self->transparent) {
		gint ID = 0;
		GtkWidget* _tmp0_;
		gint parent_width = 0;
		GtkWidget* _tmp1_;
		gint parent_height = 0;
		GtkWidget* _tmp2_;
		gdouble _tmp3_ = 0.0;
		gdouble radius = 0.0;
		gdouble segment = 0.0;
		GtkWidget* _tmp4_;
		GskPathBuilder* p = NULL;
		GskPathBuilder* _tmp5_;
		gdouble cx = 0.0;
		GtkWidget* _tmp6_;
		graphene_point_t _tmp7_;
		gdouble cy = 0.0;
		GtkWidget* _tmp8_;
		graphene_point_t _tmp9_;
		GskPathBuilder* _tmp10_;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		GskPathBuilder* _tmp11_;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		GskPathBuilder* _tmp12_;
		GskPathBuilder* _tmp13_;
		GskPathBuilder* _tmp14_;
		GskPath* _tmp15_;
		GskPath* _tmp16_;
		GdkRGBA _tmp17_ = {0};
		_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
		ID = colour_wheel_GetVisibleID (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_COLOUR_WHEEL, ColourWheel), self);
		_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
		parent_width = gtk_widget_get_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_COLOUR_WHEEL, ColourWheel));
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
		parent_height = gtk_widget_get_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_COLOUR_WHEEL, ColourWheel));
		if (parent_width > parent_height) {
			_tmp3_ = parent_height / 2.0;
		} else {
			_tmp3_ = parent_width / 2.0;
		}
		radius = _tmp3_;
		_tmp4_ = gtk_widget_get_parent ((GtkWidget*) self);
		segment = COLOUR_WHEEL_SEGMENT_PIx2 / colour_wheel_GetVisibleSegmentCount (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_COLOUR_WHEEL, ColourWheel));
		_tmp5_ = gsk_path_builder_new ();
		p = _tmp5_;
		_tmp6_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp7_ = self->offset_from_parent;
		cx = (gtk_widget_get_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_COLOUR_WHEEL, ColourWheel)) / 2.0) - _tmp7_.x;
		_tmp8_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp9_ = self->offset_from_parent;
		cy = (gtk_widget_get_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_COLOUR_WHEEL, ColourWheel)) / 2.0) - _tmp9_.y;
		if (gtk_widget_is_focus ((GtkWidget*) self)) {
			cx += sin ((segment * ID) + (segment / 2)) * (radius / 10);
			cy -= cos ((segment * ID) + (segment / 2)) * (radius / 10);
		}
		_tmp10_ = p;
		gsk_path_builder_move_to (_tmp10_, (gfloat) cx, (gfloat) cy);
		x1 = (sin (segment * ID) * radius) + cx;
		y1 = ((-cos (segment * ID)) * radius) + cy;
		_tmp11_ = p;
		gsk_path_builder_line_to (_tmp11_, (gfloat) x1, (gfloat) y1);
		x2 = (sin (segment * (ID + 1)) * radius) + cx;
		y2 = ((-cos (segment * (ID + 1))) * radius) + cy;
		_tmp12_ = p;
		gsk_path_builder_svg_arc_to (_tmp12_, (gfloat) radius, (gfloat) radius, (gfloat) segment, FALSE, TRUE, (gfloat) x2, (gfloat) y2);
		_tmp13_ = p;
		gsk_path_builder_close (_tmp13_);
		_tmp14_ = p;
		_tmp15_ = gsk_path_builder_to_path (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_.red = ((self->priv->_colour >> 16) & 0xff) / 255.0f;
		_tmp17_.green = ((self->priv->_colour >> 8) & 0xff) / 255.0f;
		_tmp17_.blue = (self->priv->_colour & 0xff) / 255.0f;
		_tmp17_.alpha = (gfloat) 1;
		gtk_snapshot_append_fill (snapshot, _tmp16_, GSK_FILL_RULE_EVEN_ODD, &_tmp17_);
		_gsk_path_unref0 (_tmp16_);
		_gsk_path_builder_unref0 (p);
	}
}

GskPath*
colour_wheel_segment_calculate_segment_path (ColourWheelSegment* self,
                                             guint width,
                                             guint height,
                                             guint ID,
                                             guint segment_count)
{
	GskPathBuilder* p = NULL;
	GskPathBuilder* _tmp0_;
	GskPathBuilder* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble radius = 0.0;
	gdouble segment = 0.0;
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	GskPathBuilder* _tmp3_;
	GskPathBuilder* _tmp4_;
	GskPathBuilder* _tmp5_;
	GskPathBuilder* _tmp6_;
	GskPath* _tmp7_;
	GskPath* _tmp8_;
	GskPath* _tmp9_;
	GskPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gsk_path_builder_new ();
	p = _tmp0_;
	_tmp1_ = p;
	gsk_path_builder_move_to (_tmp1_, width / 2.0f, height / 2.0f);
	if (width > height) {
		_tmp2_ = height / 2.0;
	} else {
		_tmp2_ = width / 2.0;
	}
	radius = _tmp2_;
	segment = COLOUR_WHEEL_SEGMENT_PIx2 / segment_count;
	cx = (width / 2.0) + (sin ((segment * ID) + (segment / 2)) * (radius / 10));
	cy = (height / 2.0) - (cos ((segment * ID) + (segment / 2)) * (radius / 10));
	_tmp3_ = p;
	gsk_path_builder_line_to (_tmp3_, (gfloat) ((sin (segment * ID) * radius) + cx), (gfloat) (((-cos (segment * ID)) * radius) + cy));
	_tmp4_ = p;
	gsk_path_builder_svg_arc_to (_tmp4_, (gfloat) radius, (gfloat) radius, (gfloat) segment, FALSE, TRUE, (gfloat) ((sin (segment * (ID + 1)) * radius) + cx), (gfloat) (((-cos (segment * (ID + 1))) * radius) + cy));
	_tmp5_ = p;
	gsk_path_builder_close (_tmp5_);
	_tmp6_ = p;
	_tmp7_ = gsk_path_builder_to_path (_tmp6_);
	_gsk_path_unref0 (self->priv->segment_path);
	self->priv->segment_path = _tmp7_;
	_tmp8_ = self->priv->segment_path;
	_tmp9_ = _gsk_path_ref0 (_tmp8_);
	result = _tmp9_;
	_gsk_path_builder_unref0 (p);
	return result;
}

static gboolean
colour_wheel_segment_real_focus (GtkWidget* base,
                                 GtkDirectionType direction)
{
	ColourWheelSegment * self;
	gboolean result;
	self = (ColourWheelSegment*) base;
	gtk_widget_grab_focus ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	return result;
}

ColourWheelSegment*
colour_wheel_segment_construct (GType object_type)
{
	ColourWheelSegment * self = NULL;
	self = (ColourWheelSegment*) g_object_new (object_type, NULL);
	return self;
}

ColourWheelSegment*
colour_wheel_segment_new (void)
{
	return colour_wheel_segment_construct (TYPE_COLOUR_WHEEL_SEGMENT);
}

gulong
colour_wheel_segment_get_colour (ColourWheelSegment* self)
{
	gulong result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_colour;
	return result;
}

void
colour_wheel_segment_set_colour (ColourWheelSegment* self,
                                 gulong value)
{
	g_return_if_fail (self != NULL);
	self->transparent = FALSE;
	self->priv->_colour = value;
	g_object_notify_by_pspec ((GObject *) self, colour_wheel_segment_properties[COLOUR_WHEEL_SEGMENT_COLOUR_PROPERTY]);
}

static GObject *
colour_wheel_segment_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ColourWheelSegment * self;
	parent_class = G_OBJECT_CLASS (colour_wheel_segment_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_focus_on_click ((GtkWidget*) self, TRUE);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	return obj;
}

static void
colour_wheel_segment_class_init (ColourWheelSegmentClass * klass,
                                 gpointer klass_data)
{
	colour_wheel_segment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ColourWheelSegment_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) colour_wheel_segment_real_snapshot;
	((GtkWidgetClass *) klass)->focus = (gboolean (*) (GtkWidget*, GtkDirectionType)) colour_wheel_segment_real_focus;
	G_OBJECT_CLASS (klass)->get_property = _vala_colour_wheel_segment_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_colour_wheel_segment_set_property;
	G_OBJECT_CLASS (klass)->constructor = colour_wheel_segment_constructor;
	G_OBJECT_CLASS (klass)->finalize = colour_wheel_segment_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COLOUR_WHEEL_SEGMENT_COLOUR_PROPERTY, colour_wheel_segment_properties[COLOUR_WHEEL_SEGMENT_COLOUR_PROPERTY] = g_param_spec_ulong ("colour", "colour", "colour", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/colourwheelsegment.ui");
}

static void
colour_wheel_segment_instance_init (ColourWheelSegment * self,
                                    gpointer klass)
{
	self->priv = colour_wheel_segment_get_instance_private (self);
	self->transparent = TRUE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
colour_wheel_segment_finalize (GObject * obj)
{
	ColourWheelSegment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment);
	_gsk_path_unref0 (self->priv->segment_path);
	G_OBJECT_CLASS (colour_wheel_segment_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
colour_wheel_segment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ColourWheelSegmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) colour_wheel_segment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ColourWheelSegment), 0, (GInstanceInitFunc) colour_wheel_segment_instance_init, NULL };
	GType colour_wheel_segment_type_id;
	colour_wheel_segment_type_id = g_type_register_static (gtk_widget_get_type (), "ColourWheelSegment", &g_define_type_info, 0);
	ColourWheelSegment_private_offset = g_type_add_instance_private (colour_wheel_segment_type_id, sizeof (ColourWheelSegmentPrivate));
	return colour_wheel_segment_type_id;
}

GType
colour_wheel_segment_get_type (void)
{
	static gsize colour_wheel_segment_type_id__once = 0;
	if (g_once_init_enter (&colour_wheel_segment_type_id__once)) {
		GType colour_wheel_segment_type_id;
		colour_wheel_segment_type_id = colour_wheel_segment_get_type_once ();
		g_once_init_leave (&colour_wheel_segment_type_id__once, colour_wheel_segment_type_id);
	}
	return colour_wheel_segment_type_id__once;
}

static void
_vala_colour_wheel_segment_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ColourWheelSegment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment);
	switch (property_id) {
		case COLOUR_WHEEL_SEGMENT_COLOUR_PROPERTY:
		g_value_set_ulong (value, colour_wheel_segment_get_colour (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_colour_wheel_segment_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ColourWheelSegment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment);
	switch (property_id) {
		case COLOUR_WHEEL_SEGMENT_COLOUR_PROPERTY:
		colour_wheel_segment_set_colour (self, g_value_get_ulong (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
colour_wheel_get_instance_private (ColourWheel* self)
{
	return G_STRUCT_MEMBER_P (self, ColourWheel_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gint
colour_wheel_GetVisibleID (ColourWheel* self,
                           ColourWheelSegment* s)
{
	GtkWidget* p = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gint id = 0;
	GtkWidget* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	p = _tmp1_;
	id = 0;
	_tmp2_ = p;
	if (NULL != _tmp2_) {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp3_ = p;
		if (G_TYPE_CHECK_INSTANCE_CAST (s, gtk_widget_get_type (), GtkWidget) == _tmp3_) {
			gint _tmp4_ = 0;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp5_ = gtk_widget_get_visible ((GtkWidget*) s);
			_tmp6_ = _tmp5_;
			if (_tmp6_) {
				_tmp4_ = id;
			} else {
				_tmp4_ = -1;
			}
			result = _tmp4_;
			_g_object_unref0 (p);
			return result;
		}
		_tmp7_ = p;
		_tmp8_ = gtk_widget_get_visible (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			gint _tmp10_;
			_tmp10_ = id;
			id = _tmp10_ + 1;
		}
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp12_;
				GtkWidget* _tmp13_;
				GtkWidget* _tmp14_;
				GtkWidget* _tmp15_;
				GtkWidget* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				if (!_tmp11_) {
				}
				_tmp11_ = FALSE;
				_tmp12_ = p;
				_tmp13_ = gtk_widget_get_next_sibling (_tmp12_);
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_g_object_unref0 (p);
				p = _tmp14_;
				_tmp15_ = p;
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = p;
				_tmp17_ = gtk_widget_get_visible (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_) {
					GtkWidget* _tmp19_;
					gint _tmp20_;
					_tmp19_ = p;
					if (G_TYPE_CHECK_INSTANCE_CAST (s, gtk_widget_get_type (), GtkWidget) == _tmp19_) {
						result = id;
						_g_object_unref0 (p);
						return result;
					}
					_tmp20_ = id;
					id = _tmp20_ + 1;
				} else {
					GtkWidget* _tmp21_;
					_tmp21_ = p;
					if (G_TYPE_CHECK_INSTANCE_CAST (s, gtk_widget_get_type (), GtkWidget) == _tmp21_) {
						result = -1;
						_g_object_unref0 (p);
						return result;
					}
				}
			}
		}
	}
	result = -1;
	_g_object_unref0 (p);
	return result;
}

guint
colour_wheel_GetVisibleSegmentCount (ColourWheel* self)
{
	GtkWidget* p = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	guint count = 0U;
	GtkWidget* _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	p = _tmp1_;
	count = (guint) 0;
	_tmp2_ = p;
	if (NULL != _tmp2_) {
		GtkWidget* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = p;
		_tmp4_ = gtk_widget_get_visible (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			guint _tmp6_;
			_tmp6_ = count;
			count = _tmp6_ + 1;
		}
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp8_;
				GtkWidget* _tmp9_;
				GtkWidget* _tmp10_;
				GtkWidget* _tmp11_;
				GtkWidget* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				if (!_tmp7_) {
				}
				_tmp7_ = FALSE;
				_tmp8_ = p;
				_tmp9_ = gtk_widget_get_next_sibling (_tmp8_);
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (p);
				p = _tmp10_;
				_tmp11_ = p;
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = p;
				_tmp13_ = gtk_widget_get_visible (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_) {
					guint _tmp15_;
					_tmp15_ = count;
					count = _tmp15_ + 1;
				}
			}
		}
	}
	result = count;
	_g_object_unref0 (p);
	return result;
}

static void
_vala_array_add1 (ColourWheelSegment** * array,
                  gint* length,
                  gint* size,
                  ColourWheelSegment* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ColourWheelSegment*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (ColourWheelSegment** * array,
                  gint* length,
                  gint* size,
                  ColourWheelSegment* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ColourWheelSegment*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static ColourWheelSegment**
colour_wheel_get_visible_segments (ColourWheel* self,
                                   gint* result_length1)
{
	ColourWheelSegment** segments = NULL;
	ColourWheelSegment** _tmp0_;
	gint segments_length1;
	gint _segments_size_;
	GtkWidget* p = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	ColourWheelSegment** _tmp19_;
	gint _tmp19__length1;
	ColourWheelSegment** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (ColourWheelSegment*, 0 + 1);
	segments = _tmp0_;
	segments_length1 = 0;
	_segments_size_ = segments_length1;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	p = _tmp2_;
	_tmp3_ = p;
	if (NULL != _tmp3_) {
		GtkWidget* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = p;
		_tmp5_ = gtk_widget_get_visible (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			GtkWidget* _tmp7_;
			ColourWheelSegment* _tmp8_;
			_tmp7_ = p;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment));
			_vala_array_add1 (&segments, &segments_length1, &_segments_size_, _tmp8_);
		}
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp10_;
				GtkWidget* _tmp11_;
				GtkWidget* _tmp12_;
				GtkWidget* _tmp13_;
				GtkWidget* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				if (!_tmp9_) {
				}
				_tmp9_ = FALSE;
				_tmp10_ = p;
				_tmp11_ = gtk_widget_get_next_sibling (_tmp10_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (p);
				p = _tmp12_;
				_tmp13_ = p;
				if (!(_tmp13_ != NULL)) {
					break;
				}
				_tmp14_ = p;
				_tmp15_ = gtk_widget_get_visible (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					GtkWidget* _tmp17_;
					ColourWheelSegment* _tmp18_;
					_tmp17_ = p;
					_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment));
					_vala_array_add2 (&segments, &segments_length1, &_segments_size_, _tmp18_);
				}
			}
		}
	}
	_tmp19_ = segments;
	_tmp19__length1 = segments_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	_g_object_unref0 (p);
	return result;
}

static void
colour_wheel_real_size_allocate (GtkWidget* base,
                                 gint width,
                                 gint height,
                                 gint baseline)
{
	ColourWheel * self;
	ColourWheelSegment** segments = NULL;
	gint _tmp0_ = 0;
	ColourWheelSegment** _tmp1_;
	gint segments_length1;
	gint _segments_size_;
	guint count = 0U;
	ColourWheelSegment** _tmp2_;
	gint _tmp2__length1;
	self = (ColourWheel*) base;
	_tmp1_ = colour_wheel_get_visible_segments (self, &_tmp0_);
	segments = _tmp1_;
	segments_length1 = _tmp0_;
	_segments_size_ = segments_length1;
	count = (guint) 0;
	_tmp2_ = segments;
	_tmp2__length1 = segments_length1;
	{
		ColourWheelSegment** segment_collection = NULL;
		gint segment_collection_length1 = 0;
		gint _segment_collection_size_ = 0;
		gint segment_it = 0;
		segment_collection = _tmp2_;
		segment_collection_length1 = _tmp2__length1;
		for (segment_it = 0; segment_it < segment_collection_length1; segment_it = segment_it + 1) {
			ColourWheelSegment* _tmp3_;
			ColourWheelSegment* segment = NULL;
			_tmp3_ = _g_object_ref0 (segment_collection[segment_it]);
			segment = _tmp3_;
			{
				GskPath* p = NULL;
				ColourWheelSegment* _tmp4_;
				ColourWheelSegment** _tmp5_;
				gint _tmp5__length1;
				GskPath* _tmp6_;
				graphene_rect_t r = {0};
				GskPath* _tmp7_;
				graphene_rect_t _tmp8_ = {0};
				ColourWheelSegment* _tmp9_;
				graphene_rect_t _tmp10_;
				graphene_point_t _tmp11_;
				ColourWheelSegment* _tmp12_;
				graphene_rect_t _tmp13_;
				graphene_point_t _tmp14_;
				graphene_rect_t _tmp15_;
				graphene_point_t _tmp16_;
				graphene_rect_t _tmp17_;
				graphene_size_t _tmp18_;
				graphene_rect_t _tmp19_;
				graphene_size_t _tmp20_;
				GtkAllocation _tmp21_ = {0};
				guint _tmp22_;
				_tmp4_ = segment;
				_tmp5_ = segments;
				_tmp5__length1 = segments_length1;
				_tmp6_ = colour_wheel_segment_calculate_segment_path (_tmp4_, (guint) width, (guint) height, count, (guint) _tmp5__length1);
				p = _tmp6_;
				_tmp7_ = p;
				gsk_path_get_bounds (_tmp7_, &_tmp8_);
				r = _tmp8_;
				_tmp9_ = segment;
				_tmp10_ = r;
				_tmp11_ = _tmp10_.origin;
				_tmp9_->offset_from_parent = _tmp11_;
				_tmp12_ = segment;
				_tmp13_ = r;
				_tmp14_ = _tmp13_.origin;
				_tmp15_ = r;
				_tmp16_ = _tmp15_.origin;
				_tmp17_ = r;
				_tmp18_ = _tmp17_.size;
				_tmp19_ = r;
				_tmp20_ = _tmp19_.size;
				_tmp21_.x = (gint) _tmp14_.x;
				_tmp21_.y = (gint) _tmp16_.y;
				_tmp21_.width = (gint) _tmp18_.width;
				_tmp21_.height = (gint) _tmp20_.height;
				gtk_widget_size_allocate ((GtkWidget*) _tmp12_, &_tmp21_, baseline);
				_tmp22_ = count;
				count = _tmp22_ + 1;
				_gsk_path_unref0 (p);
				_g_object_unref0 (segment);
			}
		}
	}
	GTK_WIDGET_CLASS (colour_wheel_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), width, height, baseline);
	segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_object_unref), NULL);
}

static gboolean
colour_wheel_real_focus (GtkWidget* base,
                         GtkDirectionType direction)
{
	ColourWheel * self;
	guint segment_count = 0U;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_;
	gint focus_id = 0;
	gboolean result;
	self = (ColourWheel*) base;
	segment_count = colour_wheel_GetVisibleSegmentCount (self);
	_tmp1_ = gtk_widget_get_focus_child ((GtkWidget*) self);
	if (NULL != _tmp1_) {
		GtkWidget* _tmp2_;
		_tmp2_ = gtk_widget_get_focus_child ((GtkWidget*) self);
		_tmp0_ = colour_wheel_GetVisibleID (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_COLOUR_WHEEL_SEGMENT, ColourWheelSegment));
	} else {
		_tmp0_ = -1;
	}
	focus_id = _tmp0_;
	switch (direction) {
		case GTK_DIR_TAB_FORWARD:
		{
			if (focus_id < 0) {
				gint _tmp3_ = 0;
				ColourWheelSegment** _tmp4_;
				ColourWheelSegment** _tmp5_;
				gint _tmp5__length1;
				ColourWheelSegment* _tmp6_;
				gint _tmp7_ = 0;
				ColourWheelSegment** _tmp8_;
				ColourWheelSegment** _tmp9_;
				gint _tmp9__length1;
				ColourWheelSegment* _tmp10_;
				_tmp4_ = colour_wheel_get_visible_segments (self, &_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp5__length1 = _tmp3_;
				_tmp6_ = _tmp5_[0];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp6_);
				_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
				GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
				_tmp8_ = colour_wheel_get_visible_segments (self, &_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp9__length1 = _tmp7_;
				_tmp10_ = _tmp9_[0];
				gtk_widget_queue_draw ((GtkWidget*) _tmp10_);
				_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
				result = TRUE;
				return result;
			} else {
				if (((guint) focus_id) < (segment_count - 1)) {
					gint _tmp11_ = 0;
					ColourWheelSegment** _tmp12_;
					ColourWheelSegment** _tmp13_;
					gint _tmp13__length1;
					ColourWheelSegment* _tmp14_;
					gint _tmp15_ = 0;
					ColourWheelSegment** _tmp16_;
					ColourWheelSegment** _tmp17_;
					gint _tmp17__length1;
					ColourWheelSegment* _tmp18_;
					_tmp12_ = colour_wheel_get_visible_segments (self, &_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp13__length1 = _tmp11_;
					_tmp14_ = _tmp13_[focus_id + 1];
					gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp14_);
					_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_object_unref), NULL);
					GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
					_tmp16_ = colour_wheel_get_visible_segments (self, &_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp17__length1 = _tmp15_;
					_tmp18_ = _tmp17_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp18_);
					_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_object_unref), NULL);
					result = TRUE;
					return result;
				} else {
					gint _tmp19_ = 0;
					ColourWheelSegment** _tmp20_;
					ColourWheelSegment** _tmp21_;
					gint _tmp21__length1;
					ColourWheelSegment* _tmp22_;
					_tmp20_ = colour_wheel_get_visible_segments (self, &_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp21__length1 = _tmp19_;
					_tmp22_ = _tmp21_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp22_);
					_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_object_unref), NULL);
					result = FALSE;
					return result;
				}
			}
		}
		case GTK_DIR_TAB_BACKWARD:
		{
			if (focus_id < 0) {
				gint _tmp23_ = 0;
				ColourWheelSegment** _tmp24_;
				ColourWheelSegment** _tmp25_;
				gint _tmp25__length1;
				ColourWheelSegment* _tmp26_;
				_tmp24_ = colour_wheel_get_visible_segments (self, &_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp25__length1 = _tmp23_;
				_tmp26_ = _tmp25_[segment_count - 1];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp26_);
				_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_object_unref), NULL);
				GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
				result = TRUE;
				return result;
			} else {
				if (focus_id > 0) {
					gint _tmp27_ = 0;
					ColourWheelSegment** _tmp28_;
					ColourWheelSegment** _tmp29_;
					gint _tmp29__length1;
					ColourWheelSegment* _tmp30_;
					gint _tmp31_ = 0;
					ColourWheelSegment** _tmp32_;
					ColourWheelSegment** _tmp33_;
					gint _tmp33__length1;
					ColourWheelSegment* _tmp34_;
					_tmp28_ = colour_wheel_get_visible_segments (self, &_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp29__length1 = _tmp27_;
					_tmp30_ = _tmp29_[focus_id - 1];
					gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp30_);
					_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_object_unref), NULL);
					GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
					_tmp32_ = colour_wheel_get_visible_segments (self, &_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp33__length1 = _tmp31_;
					_tmp34_ = _tmp33_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp34_);
					_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_object_unref), NULL);
					result = TRUE;
					return result;
				} else {
					gint _tmp35_ = 0;
					ColourWheelSegment** _tmp36_;
					ColourWheelSegment** _tmp37_;
					gint _tmp37__length1;
					ColourWheelSegment* _tmp38_;
					_tmp36_ = colour_wheel_get_visible_segments (self, &_tmp35_);
					_tmp37_ = _tmp36_;
					_tmp37__length1 = _tmp35_;
					_tmp38_ = _tmp37_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp38_);
					_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_object_unref), NULL);
					result = FALSE;
					return result;
				}
			}
		}
		case GTK_DIR_UP:
		{
			if (focus_id < 0) {
				guint segment_degrees = 0U;
				gint _tmp39_ = 0;
				ColourWheelSegment** _tmp40_;
				ColourWheelSegment** _tmp41_;
				gint _tmp41__length1;
				ColourWheelSegment* _tmp42_;
				segment_degrees = 360 / segment_count;
				_tmp40_ = colour_wheel_get_visible_segments (self, &_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp41__length1 = _tmp39_;
				_tmp42_ = _tmp41_[180 / segment_degrees];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp42_);
				_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_object_unref), NULL);
				GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp43_ = FALSE;
				if (focus_id == 0) {
					_tmp43_ = TRUE;
				} else {
					_tmp43_ = ((guint) focus_id) == (segment_count - 1);
				}
				if (_tmp43_) {
					gint _tmp44_ = 0;
					ColourWheelSegment** _tmp45_;
					ColourWheelSegment** _tmp46_;
					gint _tmp46__length1;
					ColourWheelSegment* _tmp47_;
					_tmp45_ = colour_wheel_get_visible_segments (self, &_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp46__length1 = _tmp44_;
					_tmp47_ = _tmp46_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp47_);
					_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_object_unref), NULL);
					result = FALSE;
					return result;
				} else {
					gint _tmp56_ = 0;
					ColourWheelSegment** _tmp57_;
					ColourWheelSegment** _tmp58_;
					gint _tmp58__length1;
					ColourWheelSegment* _tmp59_;
					if (((guint) focus_id) < (segment_count / 2)) {
						gint _tmp48_ = 0;
						ColourWheelSegment** _tmp49_;
						ColourWheelSegment** _tmp50_;
						gint _tmp50__length1;
						ColourWheelSegment* _tmp51_;
						_tmp49_ = colour_wheel_get_visible_segments (self, &_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp50__length1 = _tmp48_;
						_tmp51_ = _tmp50_[focus_id - 1];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp51_);
						_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_object_unref), NULL);
					} else {
						gint _tmp52_ = 0;
						ColourWheelSegment** _tmp53_;
						ColourWheelSegment** _tmp54_;
						gint _tmp54__length1;
						ColourWheelSegment* _tmp55_;
						_tmp53_ = colour_wheel_get_visible_segments (self, &_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp54__length1 = _tmp52_;
						_tmp55_ = _tmp54_[focus_id + 1];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp55_);
						_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_object_unref), NULL);
					}
					GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
					_tmp57_ = colour_wheel_get_visible_segments (self, &_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp58__length1 = _tmp56_;
					_tmp59_ = _tmp58_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp59_);
					_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_object_unref), NULL);
					result = TRUE;
					return result;
				}
			}
		}
		case GTK_DIR_DOWN:
		{
			if (focus_id < 0) {
				gint _tmp60_ = 0;
				ColourWheelSegment** _tmp61_;
				ColourWheelSegment** _tmp62_;
				gint _tmp62__length1;
				ColourWheelSegment* _tmp63_;
				_tmp61_ = colour_wheel_get_visible_segments (self, &_tmp60_);
				_tmp62_ = _tmp61_;
				_tmp62__length1 = _tmp60_;
				_tmp63_ = _tmp62_[0];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp63_);
				_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_object_unref), NULL);
				GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp64_ = FALSE;
				gboolean _tmp65_ = FALSE;
				if ((segment_count & 0x1) == ((guint) 0)) {
					gboolean _tmp66_ = FALSE;
					if (((guint) focus_id) == (segment_count / 2)) {
						_tmp66_ = TRUE;
					} else {
						_tmp66_ = ((guint) focus_id) == ((segment_count / 2) - 1);
					}
					_tmp65_ = _tmp66_;
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					_tmp64_ = TRUE;
				} else {
					gboolean _tmp67_ = FALSE;
					if ((segment_count & 0x1) == ((guint) 1)) {
						_tmp67_ = ((guint) focus_id) == (segment_count / 2);
					} else {
						_tmp67_ = FALSE;
					}
					_tmp64_ = _tmp67_;
				}
				if (_tmp64_) {
					gint _tmp68_ = 0;
					ColourWheelSegment** _tmp69_;
					ColourWheelSegment** _tmp70_;
					gint _tmp70__length1;
					ColourWheelSegment* _tmp71_;
					_tmp69_ = colour_wheel_get_visible_segments (self, &_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp70__length1 = _tmp68_;
					_tmp71_ = _tmp70_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp71_);
					_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_object_unref), NULL);
					result = FALSE;
					return result;
				} else {
					gint _tmp80_ = 0;
					ColourWheelSegment** _tmp81_;
					ColourWheelSegment** _tmp82_;
					gint _tmp82__length1;
					ColourWheelSegment* _tmp83_;
					if (((guint) focus_id) < (segment_count / 2)) {
						gint _tmp72_ = 0;
						ColourWheelSegment** _tmp73_;
						ColourWheelSegment** _tmp74_;
						gint _tmp74__length1;
						ColourWheelSegment* _tmp75_;
						_tmp73_ = colour_wheel_get_visible_segments (self, &_tmp72_);
						_tmp74_ = _tmp73_;
						_tmp74__length1 = _tmp72_;
						_tmp75_ = _tmp74_[focus_id + 1];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp75_);
						_tmp74_ = (_vala_array_free (_tmp74_, _tmp74__length1, (GDestroyNotify) g_object_unref), NULL);
					} else {
						gint _tmp76_ = 0;
						ColourWheelSegment** _tmp77_;
						ColourWheelSegment** _tmp78_;
						gint _tmp78__length1;
						ColourWheelSegment* _tmp79_;
						_tmp77_ = colour_wheel_get_visible_segments (self, &_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp78__length1 = _tmp76_;
						_tmp79_ = _tmp78_[focus_id - 1];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp79_);
						_tmp78_ = (_vala_array_free (_tmp78_, _tmp78__length1, (GDestroyNotify) g_object_unref), NULL);
					}
					GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
					_tmp81_ = colour_wheel_get_visible_segments (self, &_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp82__length1 = _tmp80_;
					_tmp83_ = _tmp82_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp83_);
					_tmp82_ = (_vala_array_free (_tmp82_, _tmp82__length1, (GDestroyNotify) g_object_unref), NULL);
					result = TRUE;
					return result;
				}
			}
		}
		case GTK_DIR_LEFT:
		{
			guint segment_degrees = 0U;
			segment_degrees = 360 / segment_count;
			if (focus_id < 0) {
				gint _tmp84_ = 0;
				ColourWheelSegment** _tmp85_;
				ColourWheelSegment** _tmp86_;
				gint _tmp86__length1;
				ColourWheelSegment* _tmp87_;
				_tmp85_ = colour_wheel_get_visible_segments (self, &_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp86__length1 = _tmp84_;
				_tmp87_ = _tmp86_[90 / segment_degrees];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp87_);
				_tmp86_ = (_vala_array_free (_tmp86_, _tmp86__length1, (GDestroyNotify) g_object_unref), NULL);
				GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp88_ = FALSE;
				if (((guint) focus_id) == (270 / segment_degrees)) {
					_tmp88_ = TRUE;
				} else {
					gboolean _tmp89_ = FALSE;
					if ((270 % segment_degrees) == ((guint) 0)) {
						_tmp89_ = ((guint) focus_id) == ((270 / segment_degrees) - 1);
					} else {
						_tmp89_ = FALSE;
					}
					_tmp88_ = _tmp89_;
				}
				if (_tmp88_) {
					gint _tmp90_ = 0;
					ColourWheelSegment** _tmp91_;
					ColourWheelSegment** _tmp92_;
					gint _tmp92__length1;
					ColourWheelSegment* _tmp93_;
					_tmp91_ = colour_wheel_get_visible_segments (self, &_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp92__length1 = _tmp90_;
					_tmp93_ = _tmp92_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp93_);
					_tmp92_ = (_vala_array_free (_tmp92_, _tmp92__length1, (GDestroyNotify) g_object_unref), NULL);
					result = FALSE;
					return result;
				} else {
					gboolean _tmp94_ = FALSE;
					gint _tmp104_ = 0;
					ColourWheelSegment** _tmp105_;
					ColourWheelSegment** _tmp106_;
					gint _tmp106__length1;
					ColourWheelSegment* _tmp107_;
					if (((guint) focus_id) < (270 / segment_degrees)) {
						_tmp94_ = ((guint) focus_id) >= (90 / segment_degrees);
					} else {
						_tmp94_ = FALSE;
					}
					if (_tmp94_) {
						gint _tmp95_ = 0;
						ColourWheelSegment** _tmp96_;
						ColourWheelSegment** _tmp97_;
						gint _tmp97__length1;
						ColourWheelSegment* _tmp98_;
						_tmp96_ = colour_wheel_get_visible_segments (self, &_tmp95_);
						_tmp97_ = _tmp96_;
						_tmp97__length1 = _tmp95_;
						_tmp98_ = _tmp97_[focus_id + 1];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp98_);
						_tmp97_ = (_vala_array_free (_tmp97_, _tmp97__length1, (GDestroyNotify) g_object_unref), NULL);
					} else {
						guint _tmp99_ = 0U;
						gint _tmp100_ = 0;
						ColourWheelSegment** _tmp101_;
						ColourWheelSegment** _tmp102_;
						gint _tmp102__length1;
						ColourWheelSegment* _tmp103_;
						if (focus_id > 0) {
							_tmp99_ = (guint) (focus_id - 1);
						} else {
							_tmp99_ = segment_count - 1;
						}
						_tmp101_ = colour_wheel_get_visible_segments (self, &_tmp100_);
						_tmp102_ = _tmp101_;
						_tmp102__length1 = _tmp100_;
						_tmp103_ = _tmp102_[_tmp99_];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp103_);
						_tmp102_ = (_vala_array_free (_tmp102_, _tmp102__length1, (GDestroyNotify) g_object_unref), NULL);
					}
					GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
					_tmp105_ = colour_wheel_get_visible_segments (self, &_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp106__length1 = _tmp104_;
					_tmp107_ = _tmp106_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp107_);
					_tmp106_ = (_vala_array_free (_tmp106_, _tmp106__length1, (GDestroyNotify) g_object_unref), NULL);
					result = TRUE;
					return result;
				}
			}
		}
		case GTK_DIR_RIGHT:
		{
			guint segment_degrees = 0U;
			segment_degrees = 360 / segment_count;
			if (focus_id < 0) {
				gint _tmp108_ = 0;
				ColourWheelSegment** _tmp109_;
				ColourWheelSegment** _tmp110_;
				gint _tmp110__length1;
				ColourWheelSegment* _tmp111_;
				_tmp109_ = colour_wheel_get_visible_segments (self, &_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp110__length1 = _tmp108_;
				_tmp111_ = _tmp110_[270 / segment_degrees];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp111_);
				_tmp110_ = (_vala_array_free (_tmp110_, _tmp110__length1, (GDestroyNotify) g_object_unref), NULL);
				GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp112_ = FALSE;
				if (((guint) focus_id) == (90 / segment_degrees)) {
					_tmp112_ = TRUE;
				} else {
					gboolean _tmp113_ = FALSE;
					if ((90 % segment_degrees) == ((guint) 0)) {
						_tmp113_ = ((guint) focus_id) == ((90 / segment_degrees) - 1);
					} else {
						_tmp113_ = FALSE;
					}
					_tmp112_ = _tmp113_;
				}
				if (_tmp112_) {
					gint _tmp114_ = 0;
					ColourWheelSegment** _tmp115_;
					ColourWheelSegment** _tmp116_;
					gint _tmp116__length1;
					ColourWheelSegment* _tmp117_;
					_tmp115_ = colour_wheel_get_visible_segments (self, &_tmp114_);
					_tmp116_ = _tmp115_;
					_tmp116__length1 = _tmp114_;
					_tmp117_ = _tmp116_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp117_);
					_tmp116_ = (_vala_array_free (_tmp116_, _tmp116__length1, (GDestroyNotify) g_object_unref), NULL);
					result = FALSE;
					return result;
				} else {
					gboolean _tmp118_ = FALSE;
					gint _tmp127_ = 0;
					ColourWheelSegment** _tmp128_;
					ColourWheelSegment** _tmp129_;
					gint _tmp129__length1;
					ColourWheelSegment* _tmp130_;
					if (((guint) focus_id) < (270 / segment_degrees)) {
						_tmp118_ = ((guint) focus_id) >= (90 / segment_degrees);
					} else {
						_tmp118_ = FALSE;
					}
					if (_tmp118_) {
						gint _tmp119_ = 0;
						ColourWheelSegment** _tmp120_;
						ColourWheelSegment** _tmp121_;
						gint _tmp121__length1;
						ColourWheelSegment* _tmp122_;
						_tmp120_ = colour_wheel_get_visible_segments (self, &_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp121__length1 = _tmp119_;
						_tmp122_ = _tmp121_[focus_id - 1];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp122_);
						_tmp121_ = (_vala_array_free (_tmp121_, _tmp121__length1, (GDestroyNotify) g_object_unref), NULL);
					} else {
						gint _tmp123_ = 0;
						ColourWheelSegment** _tmp124_;
						ColourWheelSegment** _tmp125_;
						gint _tmp125__length1;
						ColourWheelSegment* _tmp126_;
						_tmp124_ = colour_wheel_get_visible_segments (self, &_tmp123_);
						_tmp125_ = _tmp124_;
						_tmp125__length1 = _tmp123_;
						_tmp126_ = _tmp125_[(focus_id + 1) % segment_count];
						gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp126_);
						_tmp125_ = (_vala_array_free (_tmp125_, _tmp125__length1, (GDestroyNotify) g_object_unref), NULL);
					}
					GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
					_tmp128_ = colour_wheel_get_visible_segments (self, &_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp129__length1 = _tmp127_;
					_tmp130_ = _tmp129_[focus_id];
					gtk_widget_queue_draw ((GtkWidget*) _tmp130_);
					_tmp129_ = (_vala_array_free (_tmp129_, _tmp129__length1, (GDestroyNotify) g_object_unref), NULL);
					result = TRUE;
					return result;
				}
			}
		}
		default:
		{
			ColourWheelSegment* _tmp131_;
			ColourWheelSegment* _tmp132_;
			gboolean _tmp133_;
			_tmp131_ = colour_wheel_get_is_focus_child (self);
			_tmp132_ = _tmp131_;
			_tmp133_ = NULL == _tmp132_;
			_g_object_unref0 (_tmp132_);
			if (_tmp133_) {
				gint _tmp134_ = 0;
				ColourWheelSegment** _tmp135_;
				ColourWheelSegment** _tmp136_;
				gint _tmp136__length1;
				ColourWheelSegment* _tmp137_;
				_tmp135_ = colour_wheel_get_visible_segments (self, &_tmp134_);
				_tmp136_ = _tmp135_;
				_tmp136__length1 = _tmp134_;
				_tmp137_ = _tmp136_[0];
				gtk_widget_set_focus_child ((GtkWidget*) self, (GtkWidget*) _tmp137_);
				_tmp136_ = (_vala_array_free (_tmp136_, _tmp136__length1, (GDestroyNotify) g_object_unref), NULL);
			}
			GTK_WIDGET_CLASS (colour_wheel_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
			result = TRUE;
			return result;
		}
	}
}

ColourWheelSegment*
colour_wheel_get_is_focus_child (ColourWheel* self)
{
	gint _tmp0_ = 0;
	ColourWheelSegment** _tmp1_;
	ColourWheelSegment* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = colour_wheel_get_visible_segments (self, &_tmp0_);
	{
		ColourWheelSegment** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _tmp0_;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			ColourWheelSegment* _tmp2_;
			ColourWheelSegment* s = NULL;
			_tmp2_ = _g_object_ref0 (s_collection[s_it]);
			s = _tmp2_;
			{
				ColourWheelSegment* _tmp3_;
				_tmp3_ = s;
				if (gtk_widget_is_focus ((GtkWidget*) _tmp3_)) {
					result = s;
					s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_object_unref), NULL);
					return result;
				}
				_g_object_unref0 (s);
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	result = NULL;
	return result;
}

ColourWheelSegment*
colour_wheel_get_mouse_point_segment (ColourWheel* self)
{
	ColourWheelSegment* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->mouse_point_valid) {
		gint _tmp0_ = 0;
		ColourWheelSegment** _tmp1_;
		_tmp1_ = colour_wheel_get_visible_segments (self, &_tmp0_);
		{
			ColourWheelSegment** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp1_;
			s_collection_length1 = _tmp0_;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				ColourWheelSegment* _tmp2_;
				ColourWheelSegment* s = NULL;
				_tmp2_ = _g_object_ref0 (s_collection[s_it]);
				s = _tmp2_;
				{
					ColourWheelSegment* _tmp3_;
					GskPath* _tmp4_;
					GskPath* _tmp5_;
					graphene_point_t _tmp6_;
					gboolean _tmp7_;
					_tmp3_ = s;
					_tmp4_ = colour_wheel_segment_get_path (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp6_ = self->priv->mouse_point;
					_tmp7_ = gsk_path_in_fill (_tmp5_, &_tmp6_, GSK_FILL_RULE_EVEN_ODD);
					_gsk_path_unref0 (_tmp5_);
					if (_tmp7_) {
						result = s;
						s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_object_unref), NULL);
						return result;
					}
					_g_object_unref0 (s);
				}
			}
			s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_object_unref), NULL);
		}
	}
	result = NULL;
	return result;
}

static void
colour_wheel_move_mouse (ColourWheel* self)
{
	ColourWheelSegment* lose_focus = NULL;
	ColourWheelSegment* _tmp9_;
	ColourWheelSegment* _tmp10_;
	g_return_if_fail (self != NULL);
	if (self->priv->mouse_point_valid) {
		ColourWheelSegment* segment = NULL;
		ColourWheelSegment* _tmp0_;
		ColourWheelSegment* _tmp1_;
		_tmp0_ = colour_wheel_get_mouse_point_segment (self);
		segment = _tmp0_;
		_tmp1_ = segment;
		if (NULL != _tmp1_) {
			gboolean _tmp2_ = FALSE;
			if (self->priv->mouse_depressed) {
				ColourWheelSegment* _tmp3_;
				_tmp3_ = segment;
				_tmp2_ = !gtk_widget_is_focus ((GtkWidget*) _tmp3_);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				ColourWheelSegment* lose_focus = NULL;
				ColourWheelSegment* _tmp4_;
				ColourWheelSegment* _tmp5_;
				ColourWheelSegment* _tmp7_;
				ColourWheelSegment* _tmp8_;
				_tmp4_ = colour_wheel_get_is_focus_child (self);
				lose_focus = _tmp4_;
				_tmp5_ = lose_focus;
				if (NULL != _tmp5_) {
					ColourWheelSegment* _tmp6_;
					_tmp6_ = lose_focus;
					gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
				}
				_tmp7_ = segment;
				gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
				_tmp8_ = segment;
				gtk_widget_queue_draw ((GtkWidget*) _tmp8_);
				_g_object_unref0 (lose_focus);
			}
			_g_object_unref0 (segment);
			return;
		}
		_g_object_unref0 (segment);
	}
	_tmp9_ = colour_wheel_get_is_focus_child (self);
	lose_focus = _tmp9_;
	_tmp10_ = lose_focus;
	if (NULL != _tmp10_) {
		ColourWheelSegment* _tmp11_;
		_tmp11_ = lose_focus;
		gtk_widget_queue_draw ((GtkWidget*) _tmp11_);
	}
	_g_object_unref0 (lose_focus);
}

static void
colour_wheel_select (ColourWheel* self,
                     ColourWheelSegment* segment)
{
	ColourWheelResultFunction _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (segment != NULL);
	_tmp0_ = self->priv->result_function;
	_tmp0__target = self->priv->result_function_target;
	_tmp0_ (colour_wheel_GetVisibleID (self, segment), _tmp0__target);
}

void
colour_wheel_do_select_segment (ColourWheel* self,
                                gint current_selection,
                                ColourWheelResultFunction result_function,
                                gpointer result_function_target)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->result_function = result_function;
	self->priv->result_function_target = result_function_target;
	self->priv->mouse_point_valid = FALSE;
	self->priv->mouse_depressed = FALSE;
	if (colour_wheel_GetVisibleSegmentCount (self) > ((guint) 0)) {
		_tmp0_ = current_selection >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp1_ = 0;
		ColourWheelSegment** _tmp2_;
		ColourWheelSegment** _tmp3_;
		gint _tmp3__length1;
		ColourWheelSegment* _tmp4_;
		_tmp2_ = colour_wheel_get_visible_segments (self, &_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp1_;
		_tmp4_ = _tmp3_[current_selection];
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_object_unref), NULL);
	}
}

static void
colour_wheel_real_snapshot (GtkWidget* base,
                            GtkSnapshot* snapshot)
{
	ColourWheel * self;
	self = (ColourWheel*) base;
	g_return_if_fail (snapshot != NULL);
	GTK_WIDGET_CLASS (colour_wheel_parent_class)->snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), snapshot);
	colour_wheel_draw_label (self, snapshot, (gdouble) gtk_widget_get_width ((GtkWidget*) self), (gdouble) gtk_widget_get_height ((GtkWidget*) self), _ ("Select Your Color"));
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static gint
colour_wheel_calculate_font_size (ColourWheel* self,
                                  const gchar* text,
                                  gint target_width,
                                  gdouble* width,
                                  gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gboolean rush_size_steps = FALSE;
	gint fail_count = 0;
	gint last_font_size = 0;
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	rush_size_steps = TRUE;
	fail_count = 0;
	last_font_size = 1;
	target_font_size = 1;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	target_width_diff = G_MAXUINT;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp1_;
				PangoFontDescription* _tmp2_ = NULL;
				PangoLayout* _tmp3_;
				PangoFontDescription* _tmp4_;
				PangoFontDescription* font = NULL;
				PangoFontDescription* _tmp9_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoFontDescription* _tmp12_;
				PangoLayout* _tmp13_;
				PangoRectangle a = {0};
				PangoRectangle b = {0};
				PangoLayout* _tmp14_;
				PangoRectangle _tmp15_ = {0};
				PangoRectangle _tmp16_ = {0};
				guint width_diff = 0U;
				PangoRectangle _tmp17_;
				gboolean _tmp18_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(font_size < 128)) {
					break;
				}
				_tmp1_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
				layout = _tmp1_;
				_tmp3_ = layout;
				_tmp4_ = pango_layout_get_font_description (_tmp3_);
				if (NULL == _tmp4_) {
					PangoFontDescription* _tmp5_;
					_tmp5_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (_tmp2_);
					_tmp2_ = _tmp5_;
				} else {
					PangoLayout* _tmp6_;
					PangoFontDescription* _tmp7_;
					PangoFontDescription* _tmp8_;
					_tmp6_ = layout;
					_tmp7_ = pango_layout_get_font_description (_tmp6_);
					_tmp8_ = pango_font_description_copy (_tmp7_);
					__vala_PangoFontDescription_free0 (_tmp2_);
					_tmp2_ = _tmp8_;
				}
				_tmp9_ = __vala_PangoFontDescription_copy0 (_tmp2_);
				font = _tmp9_;
				_tmp10_ = font;
				pango_font_description_set_size (_tmp10_, PANGO_SCALE * font_size);
				_tmp11_ = layout;
				_tmp12_ = font;
				pango_layout_set_font_description (_tmp11_, _tmp12_);
				_tmp13_ = layout;
				pango_layout_set_text (_tmp13_, text, -1);
				_tmp14_ = layout;
				pango_layout_get_extents (_tmp14_, &_tmp15_, &_tmp16_);
				a = _tmp15_;
				b = _tmp16_;
				_tmp17_ = a;
				width_diff = (guint) (target_width - ((gint) (_tmp17_.width / PANGO_SCALE)));
				if (width_diff > ((guint) 0)) {
					_tmp18_ = width_diff < target_width_diff;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					PangoRectangle _tmp19_;
					PangoRectangle _tmp20_;
					target_width_diff = width_diff;
					target_font_size = font_size;
					_tmp19_ = a;
					_vala_width = (gdouble) (_tmp19_.width / PANGO_SCALE);
					_tmp20_ = a;
					_vala_height = (gdouble) (_tmp20_.height / PANGO_SCALE);
					if (!rush_size_steps) {
						fail_count = 0;
					}
				} else {
					if (rush_size_steps) {
						rush_size_steps = FALSE;
						font_size = last_font_size + 1;
						fail_count = 0;
					} else {
						if (fail_count > 2) {
							__vala_PangoFontDescription_free0 (font);
							__vala_PangoFontDescription_free0 (_tmp2_);
							_g_object_unref0 (layout);
							break;
						} else {
							gint _tmp21_;
							_tmp21_ = fail_count;
							fail_count = _tmp21_ + 1;
						}
					}
				}
				if (rush_size_steps) {
					last_font_size = font_size;
					font_size *= 2;
				} else {
					gint _tmp22_;
					_tmp22_ = font_size;
					font_size = _tmp22_ + 1;
				}
				__vala_PangoFontDescription_free0 (font);
				__vala_PangoFontDescription_free0 (_tmp2_);
				_g_object_unref0 (layout);
			}
		}
	}
	result = target_font_size;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

static void
colour_wheel_draw_text_font_size (ColourWheel* self,
                                  GtkSnapshot* snapshot,
                                  gint x,
                                  gint y,
                                  const gchar* text,
                                  gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	graphene_point_t _tmp2_ = {0};
	PangoLayout* layout = NULL;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	PangoFontDescription* _tmp5_ = NULL;
	PangoLayout* _tmp6_;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	PangoLayout* _tmp15_;
	GdkRGBA _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (text != NULL);
	colour_wheel_get_text_offsets (self, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	_tmp2_.x = (gfloat) (x - x_offset);
	_tmp2_.y = (gfloat) (y - y_offset);
	gtk_snapshot_translate (snapshot, &_tmp2_);
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp3_;
	_tmp4_ = layout;
	pango_layout_set_alignment (_tmp4_, 1);
	_tmp6_ = layout;
	_tmp7_ = pango_layout_get_font_description (_tmp6_);
	if (NULL == _tmp7_) {
		PangoFontDescription* _tmp8_;
		_tmp8_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		PangoLayout* _tmp9_;
		PangoFontDescription* _tmp10_;
		PangoFontDescription* _tmp11_;
		_tmp9_ = layout;
		_tmp10_ = pango_layout_get_font_description (_tmp9_);
		_tmp11_ = pango_font_description_copy (_tmp10_);
		__vala_PangoFontDescription_free0 (_tmp5_);
		_tmp5_ = _tmp11_;
	}
	_tmp12_ = __vala_PangoFontDescription_copy0 (_tmp5_);
	font = _tmp12_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp13_ = layout;
	pango_layout_set_font_description (_tmp13_, font);
	_tmp14_ = layout;
	pango_layout_set_text (_tmp14_, text, -1);
	_tmp15_ = layout;
	_tmp16_.red = (gfloat) 1;
	_tmp16_.green = (gfloat) 1;
	_tmp16_.blue = (gfloat) 1;
	_tmp16_.alpha = (gfloat) 1;
	gtk_snapshot_append_layout (snapshot, _tmp15_, &_tmp16_);
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp5_);
	_g_object_unref0 (layout);
}

static void
colour_wheel_get_text_offsets (ColourWheel* self,
                               const gchar* text,
                               gint font_size,
                               gint* x_offset,
                               gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_ = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp8_;
	PangoLayout* _tmp9_;
	PangoLayout* _tmp10_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp11_;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_;
	PangoRectangle _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp0_;
	_tmp2_ = layout;
	_tmp3_ = pango_layout_get_font_description (_tmp2_);
	if (NULL == _tmp3_) {
		PangoFontDescription* _tmp4_;
		_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		PangoLayout* _tmp5_;
		PangoFontDescription* _tmp6_;
		PangoFontDescription* _tmp7_;
		_tmp5_ = layout;
		_tmp6_ = pango_layout_get_font_description (_tmp5_);
		_tmp7_ = pango_font_description_copy (_tmp6_);
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	font = _tmp8_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp9_ = layout;
	pango_layout_set_font_description (_tmp9_, font);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_layout_get_extents (_tmp11_, &_tmp12_, &_tmp13_);
	a = _tmp12_;
	b = _tmp13_;
	_tmp14_ = a;
	_vala_x_offset = _tmp14_.x / PANGO_SCALE;
	_tmp15_ = a;
	_vala_y_offset = _tmp15_.y / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp1_);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static void
colour_wheel_draw_label (ColourWheel* self,
                         GtkSnapshot* snapshot,
                         gdouble width,
                         gdouble height,
                         const gchar* text)
{
	static const gfloat PIby2 = 1.570796326794896619231321691639751442f;
	static const gint border = 20;
	gdouble text_width = 0.0;
	gdouble text_height = 0.0;
	gint font_size = 0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gint _tmp2_;
	gfloat background_width = 0.0F;
	gfloat background_height = 0.0F;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat _tmp3_ = 0.0F;
	gfloat arc_radius = 0.0F;
	GskPathBuilder* background = NULL;
	GskPathBuilder* _tmp4_;
	GskPath* _tmp5_;
	GskPath* _tmp6_;
	GdkRGBA _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (text != NULL);
	_tmp2_ = colour_wheel_calculate_font_size (self, text, ((gint) width) - border, &_tmp0_, &_tmp1_);
	text_width = _tmp0_;
	text_height = _tmp1_;
	font_size = _tmp2_;
	background_width = ((gfloat) text_width) + border;
	background_height = ((gfloat) text_height) + border;
	x = (gtk_widget_get_width ((GtkWidget*) self) - background_width) / 2;
	y = (gfloat) 0;
	if (background_width < background_height) {
		_tmp3_ = background_width / 2;
	} else {
		_tmp3_ = background_height / 2;
	}
	arc_radius = _tmp3_;
	_tmp4_ = gsk_path_builder_new ();
	background = _tmp4_;
	gsk_path_builder_move_to (background, (x + background_width) - arc_radius, y + 0);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, x + background_width, y + arc_radius);
	gsk_path_builder_line_to (background, x + background_width, (y + background_height) - arc_radius);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, (x + background_width) - arc_radius, y + background_height);
	gsk_path_builder_line_to (background, x + arc_radius, y + background_height);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, x + 0, (y + background_height) - arc_radius);
	gsk_path_builder_line_to (background, x + 0, y + arc_radius);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, x + arc_radius, y + 0);
	_tmp5_ = gsk_path_builder_to_path (background);
	_tmp6_ = _tmp5_;
	_tmp7_.red = 0.0f;
	_tmp7_.green = 0.0f;
	_tmp7_.blue = 0.0f;
	_tmp7_.alpha = 0.9f;
	gtk_snapshot_append_fill (snapshot, _tmp6_, GSK_FILL_RULE_EVEN_ODD, &_tmp7_);
	_gsk_path_unref0 (_tmp6_);
	colour_wheel_draw_text_font_size (self, snapshot, (gint) (x + ((background_width - text_width) / 2)), (gint) (y + ((background_height - text_height) / 2)), text, font_size);
	_gsk_path_builder_unref0 (background);
}

ColourWheel*
colour_wheel_construct (GType object_type)
{
	ColourWheel * self = NULL;
	self = (ColourWheel*) g_object_new (object_type, NULL);
	return self;
}

ColourWheel*
colour_wheel_new (void)
{
	return colour_wheel_construct (TYPE_COLOUR_WHEEL);
}

static void
_colour_wheel___lambda10_ (ColourWheel* self,
                           gdouble x,
                           gdouble y)
{
	self->priv->mouse_point.x = (gfloat) x;
	self->priv->mouse_point.y = (gfloat) y;
	self->priv->mouse_point_valid = TRUE;
	colour_wheel_move_mouse (self);
}

static void
__colour_wheel___lambda10__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self)
{
	_colour_wheel___lambda10_ ((ColourWheel*) self, x, y);
}

static void
_colour_wheel___lambda11_ (ColourWheel* self,
                           gdouble x,
                           gdouble y)
{
	self->priv->mouse_point.x = (gfloat) x;
	self->priv->mouse_point.y = (gfloat) y;
	self->priv->mouse_point_valid = TRUE;
	colour_wheel_move_mouse (self);
}

static void
__colour_wheel___lambda11__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self)
{
	_colour_wheel___lambda11_ ((ColourWheel*) self, x, y);
}

static void
_colour_wheel___lambda12_ (ColourWheel* self)
{
	self->priv->mouse_point_valid = FALSE;
	colour_wheel_move_mouse (self);
}

static void
__colour_wheel___lambda12__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                              gpointer self)
{
	_colour_wheel___lambda12_ ((ColourWheel*) self);
}

static gboolean
_colour_wheel___lambda13_ (ColourWheel* self,
                           GdkEvent* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (gdk_event_get_event_type (event)) {
		case GDK_BUTTON_PRESS:
		{
			if (!self->priv->mouse_depressed) {
				self->priv->mouse_depressed = TRUE;
				colour_wheel_move_mouse (self);
			}
			result = TRUE;
			return result;
		}
		case GDK_BUTTON_RELEASE:
		{
			ColourWheelSegment* segment = NULL;
			ColourWheelSegment* _tmp0_;
			gboolean _tmp1_ = FALSE;
			_tmp0_ = colour_wheel_get_mouse_point_segment (self);
			segment = _tmp0_;
			if (self->priv->mouse_point_valid) {
				ColourWheelSegment* _tmp2_;
				_tmp2_ = segment;
				_tmp1_ = NULL != _tmp2_;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				ColourWheelSegment* _tmp3_;
				_tmp3_ = segment;
				colour_wheel_select (self, _tmp3_);
			} else {
				if (self->priv->mouse_depressed) {
					self->priv->mouse_depressed = FALSE;
					colour_wheel_move_mouse (self);
				}
			}
			result = TRUE;
			_g_object_unref0 (segment);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
__colour_wheel___lambda13__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                              GdkEvent* event,
                                                              gpointer self)
{
	gboolean result;
	result = _colour_wheel___lambda13_ ((ColourWheel*) self, event);
	return result;
}

static void
_colour_wheel___lambda14_ (ColourWheel* self,
                           guint keyval,
                           guint keycode,
                           GdkModifierType state)
{
	switch (keyval) {
		case 65293:
		case 65421:
		case 32:
		{
			ColourWheelSegment* segment = NULL;
			ColourWheelSegment* _tmp0_;
			ColourWheelSegment* _tmp1_;
			_tmp0_ = colour_wheel_get_is_focus_child (self);
			segment = _tmp0_;
			_tmp1_ = segment;
			if (NULL != _tmp1_) {
				ColourWheelSegment* _tmp2_;
				_tmp2_ = segment;
				colour_wheel_select (self, _tmp2_);
			}
			_g_object_unref0 (segment);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
__colour_wheel___lambda14__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	_colour_wheel___lambda14_ ((ColourWheel*) self, keyval, keycode, state);
}

static GObject *
colour_wheel_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ColourWheel * self;
	ColourWheelSegment* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkEventControllerMotion* mouse_position = NULL;
	GtkEventControllerMotion* _tmp3_;
	GtkEventControllerMotion* _tmp4_;
	GtkEventControllerMotion* _tmp5_;
	GtkEventControllerMotion* _tmp6_;
	GtkEventControllerMotion* _tmp7_;
	GtkEventController* _tmp8_;
	GtkEventControllerLegacy* mouse_click = NULL;
	GtkEventControllerLegacy* _tmp9_;
	GtkEventControllerLegacy* _tmp10_;
	GtkEventControllerLegacy* _tmp11_;
	GtkEventController* _tmp12_;
	GtkEventControllerKey* key = NULL;
	GtkEventControllerKey* _tmp13_;
	GtkEventControllerKey* _tmp14_;
	GtkEventControllerKey* _tmp15_;
	GtkEventController* _tmp16_;
	parent_class = G_OBJECT_CLASS (colour_wheel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOUR_WHEEL, ColourWheel);
	gtk_widget_set_focusable ((GtkWidget*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	gtk_widget_set_focus_on_click ((GtkWidget*) self, TRUE);
	gtk_widget_set_can_target ((GtkWidget*) self, TRUE);
	_tmp0_ = self->priv->__initilisation_segment;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_assert_false (_tmp2_);
	_tmp3_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	mouse_position = _tmp3_;
	_tmp4_ = mouse_position;
	g_signal_connect_object (_tmp4_, "motion", (GCallback) __colour_wheel___lambda10__gtk_event_controller_motion_motion, self, 0);
	_tmp5_ = mouse_position;
	g_signal_connect_object (_tmp5_, "enter", (GCallback) __colour_wheel___lambda11__gtk_event_controller_motion_enter, self, 0);
	_tmp6_ = mouse_position;
	g_signal_connect_object (_tmp6_, "leave", (GCallback) __colour_wheel___lambda12__gtk_event_controller_motion_leave, self, 0);
	_tmp7_ = mouse_position;
	_tmp8_ = _g_object_ref0 ((GtkEventController*) _tmp7_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp8_);
	_tmp9_ = (GtkEventControllerLegacy*) gtk_event_controller_legacy_new ();
	mouse_click = _tmp9_;
	_tmp10_ = mouse_click;
	g_signal_connect_object (_tmp10_, "event", (GCallback) __colour_wheel___lambda13__gtk_event_controller_legacy_event, self, 0);
	_tmp11_ = mouse_click;
	_tmp12_ = _g_object_ref0 ((GtkEventController*) _tmp11_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp12_);
	_tmp13_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key = _tmp13_;
	_tmp14_ = key;
	g_signal_connect_object (_tmp14_, "key-released", (GCallback) __colour_wheel___lambda14__gtk_event_controller_key_key_released, self, 0);
	_tmp15_ = key;
	_tmp16_ = _g_object_ref0 ((GtkEventController*) _tmp15_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp16_);
	_g_object_unref0 (key);
	_g_object_unref0 (mouse_click);
	_g_object_unref0 (mouse_position);
	return obj;
}

static void
colour_wheel_class_init (ColourWheelClass * klass,
                         gpointer klass_data)
{
	colour_wheel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ColourWheel_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) colour_wheel_real_size_allocate;
	((GtkWidgetClass *) klass)->focus = (gboolean (*) (GtkWidget*, GtkDirectionType)) colour_wheel_real_focus;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) colour_wheel_real_snapshot;
	G_OBJECT_CLASS (klass)->constructor = colour_wheel_constructor;
	G_OBJECT_CLASS (klass)->finalize = colour_wheel_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/colourwheel.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "__initilisation_segment", FALSE, ColourWheel_private_offset + G_STRUCT_OFFSET (ColourWheelPrivate, __initilisation_segment));
}

static void
colour_wheel_instance_init (ColourWheel * self,
                            gpointer klass)
{
	self->priv = colour_wheel_get_instance_private (self);
	self->priv->mouse_point_valid = FALSE;
	self->priv->mouse_depressed = FALSE;
	g_type_ensure (TYPE_COLOUR_WHEEL_SEGMENT);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
colour_wheel_finalize (GObject * obj)
{
	ColourWheel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOUR_WHEEL, ColourWheel);
	G_OBJECT_CLASS (colour_wheel_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
colour_wheel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ColourWheelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) colour_wheel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ColourWheel), 0, (GInstanceInitFunc) colour_wheel_instance_init, NULL };
	GType colour_wheel_type_id;
	colour_wheel_type_id = g_type_register_static (gtk_widget_get_type (), "ColourWheel", &g_define_type_info, 0);
	ColourWheel_private_offset = g_type_add_instance_private (colour_wheel_type_id, sizeof (ColourWheelPrivate));
	return colour_wheel_type_id;
}

GType
colour_wheel_get_type (void)
{
	static gsize colour_wheel_type_id__once = 0;
	if (g_once_init_enter (&colour_wheel_type_id__once)) {
		GType colour_wheel_type_id;
		colour_wheel_type_id = colour_wheel_get_type_once ();
		g_once_init_leave (&colour_wheel_type_id__once, colour_wheel_type_id);
	}
	return colour_wheel_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

