/* dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "libgnome-games-support.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesScoresDialog {
	AdwDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	AdwDialogClass parent_class;
};

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GListStore* score_model;
	AdwToolbarView* toolbar;
	GtkButton* done_button;
	GtkColumnView* score_view;
	GtkColumnViewColumn* rank_column;
	GtkColumnViewColumn* score_column;
	GtkColumnViewColumn* player_column;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	gchar* score_or_time;
};

struct _Block5Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GtkDropDown* drop_down;
};

struct _Block6Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresCategory* active_category;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GamesScoresScore* score;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	GtkEntry* entry;
};

struct _Block9Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresContextNewGameFunc new_game_func;
	gpointer new_game_func_target;
	GamesScoresContextQuitAppFunc quit_app_func;
	gpointer quit_app_func_target;
};

static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            const gchar* icon_name);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  const gchar* icon_name);
VALA_EXTERN GListStore* games_scores_context_get_categories (GamesScoresContext* self);
static void ___lambda13_ (GamesScoresDialog* self);
static void ____lambda13__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda14_ (Block5Data* _data5_);
static void games_scores_dialog_load_scores_for_category (GamesScoresDialog* self,
                                                   GamesScoresCategory* category);
static void _____lambda14__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
static void games_scores_dialog_setup_columns (GamesScoresDialog* self,
                                        GamesScoresCategory* category);
static void games_scores_dialog_set_up_rank_column (GamesScoresDialog* self);
static void games_scores_dialog_set_up_score_column (GamesScoresDialog* self);
static void games_scores_dialog_set_up_player_column (GamesScoresDialog* self,
                                               GamesScoresCategory* active_category);
static void __lambda23_ (GamesScoresDialog* self);
static void ___lambda23__gtk_sorter_changed (GtkSorter* _sender,
                                      GtkSorterChange change,
                                      gpointer self);
static gint games_scores_dialog_rank_sorter_cb (GamesScoresScore* entry1,
                                         GamesScoresScore* entry2);
static void __lambda15_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda15__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void __lambda16_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda16__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void __lambda17_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda17__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void ___lambda18_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda18__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void ___lambda19_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda19__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda20_ (Block6Data* _data6_,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda21_ (Block8Data* _data8_);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
static void ____lambda21__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda22_ (GamesScoresDialog* self);
static void ____lambda22__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static void ___lambda20__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
VALA_EXTERN void games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self,
                                             GamesScoresContextNewGameFunc new_game_func,
                                             gpointer new_game_func_target,
                                             GamesScoresContextQuitAppFunc quit_app_func,
                                             gpointer quit_app_func_target);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda24_ (Block9Data* _data9_);
static void ___lambda24__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda25_ (Block9Data* _data9_);
static void ___lambda25__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void games_scores_dialog_finalize (GObject * obj);
static GType games_scores_dialog_get_type_once (void);

static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda13_ (GamesScoresDialog* self)
{
	adw_dialog_close ((AdwDialog*) self);
}

static void
____lambda13__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda13_ ((GamesScoresDialog*) self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->drop_down);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
____lambda14_ (Block5Data* _data5_)
{
	GamesScoresDialog* self;
	GamesScoresCategory* selected = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	self = _data5_->self;
	_tmp0_ = _data5_->drop_down;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory));
	selected = _tmp2_;
	_tmp3_ = selected;
	if (NULL != _tmp3_) {
		GamesScoresCategory* _tmp4_;
		_tmp4_ = selected;
		games_scores_dialog_load_scores_for_category (self, _tmp4_);
	}
	_g_object_unref0 (selected);
}

static void
_____lambda14__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda14_ (self);
}

GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               const gchar* icon_name)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_;
	AdwToolbarView* _tmp3_;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp4_;
	AdwHeaderBar* _tmp5_;
	AdwToolbarView* _tmp6_;
	AdwToolbarView* _tmp7_;
	GtkBuilder* _tmp8_;
	AdwHeaderBar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	guint active_category_index = 0U;
	GListStore* categories = NULL;
	GListStore* _tmp20_;
	GamesScoresCategory* _tmp21_ = NULL;
	GListStore* _tmp22_;
	guint _tmp23_ = 0U;
	gboolean _tmp24_;
	GamesScoresCategory* active_category = NULL;
	gchar* _tmp28_;
	gchar* new_score_or_time = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp64_;
	GtkColumnView* _tmp65_;
	GtkColumnView* _tmp66_;
	GtkColumnView* _tmp67_;
	GamesScoresCategory* _tmp68_;
	GamesScoresCategory* _tmp69_;
	GtkScrolledWindow* _tmp70_;
	GtkColumnView* _tmp71_;
	AdwToolbarView* _tmp72_;
	GtkBuilder* _tmp73_;
	GtkScrolledWindow* _tmp74_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GamesScoresDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = _g_object_ref0 (new_high_score);
	_g_object_unref0 (self->priv->new_high_score);
	self->priv->new_high_score = _tmp1_;
	_tmp2_ = gtk_builder_new ();
	builder = _tmp2_;
	_tmp3_ = (AdwToolbarView*) adw_toolbar_view_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp3_;
	_tmp4_ = (AdwHeaderBar*) adw_header_bar_new ();
	g_object_ref_sink (_tmp4_);
	headerbar = _tmp4_;
	_tmp5_ = headerbar;
	adw_header_bar_set_show_end_title_buttons (_tmp5_, new_high_score == NULL);
	_tmp6_ = self->priv->toolbar;
	adw_dialog_set_child ((AdwDialog*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->toolbar;
	_tmp8_ = builder;
	_tmp9_ = headerbar;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp7_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp7_, _tmp8_, (GObject*) _tmp9_, "top");
	adw_dialog_set_content_width ((AdwDialog*) self, 400);
	adw_dialog_set_content_height ((AdwDialog*) self, 500);
	if (!games_scores_context_has_scores (context)) {
		_tmp10_ = new_high_score == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		AdwStatusPage* status_page = NULL;
		AdwStatusPage* _tmp11_;
		AdwToolbarView* _tmp12_;
		GtkBuilder* _tmp13_;
		AdwStatusPage* _tmp14_;
		AdwStatusPage* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		AdwStatusPage* _tmp18_;
		AdwStatusPage* _tmp19_;
		adw_dialog_set_title ((AdwDialog*) self, _ ("No scores yet"));
		_tmp11_ = (AdwStatusPage*) adw_status_page_new ();
		g_object_ref_sink (_tmp11_);
		status_page = _tmp11_;
		_tmp12_ = self->priv->toolbar;
		_tmp13_ = builder;
		_tmp14_ = status_page;
		G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp12_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp12_, _tmp13_, (GObject*) _tmp14_, NULL);
		_tmp15_ = status_page;
		_tmp16_ = g_strconcat (icon_name, "-symbolic", NULL);
		_tmp17_ = _tmp16_;
		adw_status_page_set_icon_name (_tmp15_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = status_page;
		adw_status_page_set_description (_tmp18_, _ ("Play some games and your scores will show up here."));
		_tmp19_ = status_page;
		gtk_widget_add_css_class ((GtkWidget*) _tmp19_, "dim-label");
		_g_object_unref0 (status_page);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (builder);
		return self;
	}
	self->priv->scores_style = style;
	active_category_index = (guint) 0;
	_tmp20_ = games_scores_context_get_categories (context);
	categories = _tmp20_;
	_tmp22_ = categories;
	_tmp24_ = g_list_store_find (_tmp22_, (GObject*) current_cat, &_tmp23_);
	active_category_index = _tmp23_;
	if (_tmp24_) {
		GamesScoresCategory* _tmp25_;
		_tmp25_ = _g_object_ref0 (current_cat);
		_g_object_unref0 (_tmp21_);
		_tmp21_ = _tmp25_;
	} else {
		GListStore* _tmp26_;
		GObject* _tmp27_;
		_tmp26_ = categories;
		_tmp27_ = g_list_model_get_item ((GListModel*) _tmp26_, active_category_index);
		_g_object_unref0 (_tmp21_);
		_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory);
	}
	active_category = _tmp21_;
	_tmp28_ = g_strdup ("");
	_g_free0 (self->priv->score_or_time);
	self->priv->score_or_time = _tmp28_;
	_tmp29_ = g_strdup ("");
	new_score_or_time = _tmp29_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp30_) {
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp31_ = g_strdup (_ ("Score"));
		_g_free0 (self->priv->score_or_time);
		self->priv->score_or_time = _tmp31_;
		_tmp32_ = g_strdup (_ ("New Score in"));
		_g_free0 (new_score_or_time);
		new_score_or_time = _tmp32_;
	} else {
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp33_ = g_strdup (_ ("Time"));
		_g_free0 (self->priv->score_or_time);
		self->priv->score_or_time = _tmp33_;
		_tmp34_ = g_strdup (_ ("New Time in"));
		_g_free0 (new_score_or_time);
		new_score_or_time = _tmp34_;
	}
	if (new_high_score != NULL) {
		AdwWindowTitle* title_widget = NULL;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		GamesScoresCategory* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		AdwWindowTitle* _tmp43_;
		AdwWindowTitle* _tmp44_;
		AdwHeaderBar* _tmp45_;
		AdwWindowTitle* _tmp46_;
		GtkButton* _tmp47_;
		GtkButton* _tmp48_;
		GtkButton* _tmp49_;
		AdwHeaderBar* _tmp50_;
		GtkButton* _tmp51_;
		_tmp35_ = new_score_or_time;
		_tmp36_ = string_to_string (_tmp35_);
		_tmp37_ = active_category;
		_tmp38_ = games_scores_category_get_name (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = string_to_string (_tmp39_);
		_tmp41_ = g_strconcat (_tmp36_, " ", _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = (AdwWindowTitle*) adw_window_title_new (_ ("Congratulations!"), _tmp42_);
		g_object_ref_sink (_tmp43_);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		title_widget = _tmp44_;
		_tmp45_ = headerbar;
		_tmp46_ = title_widget;
		adw_header_bar_set_title_widget (_tmp45_, (GtkWidget*) _tmp46_);
		_tmp47_ = (GtkButton*) gtk_button_new_with_label (_ ("Done"));
		g_object_ref_sink (_tmp47_);
		_g_object_unref0 (self->priv->done_button);
		self->priv->done_button = _tmp47_;
		_tmp48_ = self->priv->done_button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp48_, "suggested-action");
		_tmp49_ = self->priv->done_button;
		g_signal_connect_object (_tmp49_, "clicked", (GCallback) ____lambda13__gtk_button_clicked, self, 0);
		_tmp50_ = headerbar;
		_tmp51_ = self->priv->done_button;
		adw_header_bar_pack_end (_tmp50_, (GtkWidget*) _tmp51_);
		_g_object_unref0 (title_widget);
	} else {
		GListStore* _tmp52_;
		_tmp52_ = categories;
		if (g_list_model_get_n_items ((GListModel*) _tmp52_) == ((guint) 1)) {
			GamesScoresCategory* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			_tmp53_ = active_category;
			_tmp54_ = games_scores_category_get_name (_tmp53_);
			_tmp55_ = _tmp54_;
			adw_dialog_set_title ((AdwDialog*) self, _tmp55_);
		} else {
			Block5Data* _data5_;
			GListStore* _tmp56_;
			GListModel* _tmp57_;
			GtkPropertyExpression* _tmp58_;
			GtkDropDown* _tmp59_;
			GtkDropDown* _tmp60_;
			GtkDropDown* _tmp61_;
			AdwHeaderBar* _tmp62_;
			GtkDropDown* _tmp63_;
			_data5_ = g_slice_new0 (Block5Data);
			_data5_->_ref_count_ = 1;
			_data5_->self = g_object_ref (self);
			_tmp56_ = categories;
			_tmp57_ = _g_object_ref0 ((GListModel*) _tmp56_);
			_tmp58_ = (GtkPropertyExpression*) gtk_property_expression_new (GAMES_SCORES_TYPE_CATEGORY, NULL, "name");
			_tmp59_ = (GtkDropDown*) gtk_drop_down_new (_tmp57_, (GtkExpression*) _tmp58_);
			g_object_ref_sink (_tmp59_);
			_data5_->drop_down = _tmp59_;
			_tmp60_ = _data5_->drop_down;
			gtk_drop_down_set_selected (_tmp60_, active_category_index);
			_tmp61_ = _data5_->drop_down;
			g_signal_connect_data ((GObject*) _tmp61_, "notify::selected", (GCallback) _____lambda14__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
			_tmp62_ = headerbar;
			_tmp63_ = _data5_->drop_down;
			adw_header_bar_set_title_widget (_tmp62_, (GtkWidget*) _tmp63_);
			block5_data_unref (_data5_);
			_data5_ = NULL;
		}
	}
	_tmp64_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp64_);
	scroll = _tmp64_;
	_tmp65_ = (GtkColumnView*) gtk_column_view_new (NULL);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp65_;
	_tmp66_ = self->priv->score_view;
	gtk_column_view_set_reorderable (_tmp66_, FALSE);
	_tmp67_ = self->priv->score_view;
	gtk_column_view_set_tab_behavior (_tmp67_, GTK_LIST_TAB_ITEM);
	_tmp68_ = active_category;
	games_scores_dialog_setup_columns (self, _tmp68_);
	_tmp69_ = active_category;
	games_scores_dialog_load_scores_for_category (self, _tmp69_);
	_tmp70_ = scroll;
	_tmp71_ = self->priv->score_view;
	gtk_scrolled_window_set_child (_tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = self->priv->toolbar;
	_tmp73_ = builder;
	_tmp74_ = scroll;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp72_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp72_, _tmp73_, (GObject*) _tmp74_, NULL);
	_g_object_unref0 (scroll);
	_g_free0 (new_score_or_time);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (categories);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (builder);
	return self;
}

GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         const gchar* icon_name)
{
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, icon_name);
}

static void
games_scores_dialog_load_scores_for_category (GamesScoresDialog* self,
                                              GamesScoresCategory* category)
{
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GeeList* best_n_scores = NULL;
	GamesScoresContext* _tmp2_;
	GeeList* _tmp3_;
	GtkColumnView* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = self->priv->score_model;
	_vala_return_if_fail (NULL != _tmp0_, "null != score_model");
	_tmp1_ = self->priv->score_model;
	g_list_store_remove_all (_tmp1_);
	_tmp2_ = self->priv->context;
	_tmp3_ = games_scores_context_get_high_scores (_tmp2_, category, 10);
	best_n_scores = _tmp3_;
	{
		GeeList* _score_list = NULL;
		GeeList* _tmp4_;
		gint _score_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _score_index = 0;
		_tmp4_ = best_n_scores;
		_score_list = _tmp4_;
		_tmp5_ = _score_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_score_size = _tmp7_;
		_score_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			GListStore* _tmp12_;
			GamesScoresScore* _tmp13_;
			_score_index = _score_index + 1;
			_tmp8_ = _score_index;
			_tmp9_ = _score_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _score_list;
			_tmp11_ = gee_list_get (_tmp10_, _score_index);
			score = (GamesScoresScore*) _tmp11_;
			_tmp12_ = self->priv->score_model;
			_tmp13_ = score;
			g_list_store_append (_tmp12_, (GObject*) _tmp13_);
			_g_object_unref0 (score);
		}
	}
	_tmp14_ = self->priv->score_view;
	gtk_column_view_scroll_to (_tmp14_, (guint) 0, NULL, GTK_LIST_SCROLL_NONE, NULL);
	_g_object_unref0 (best_n_scores);
}

static void
__lambda23_ (GamesScoresDialog* self)
{
	GtkColumnView* _tmp0_;
	_tmp0_ = self->priv->score_view;
	gtk_column_view_scroll_to (_tmp0_, (guint) 0, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
}

static void
___lambda23__gtk_sorter_changed (GtkSorter* _sender,
                                 GtkSorterChange change,
                                 gpointer self)
{
	__lambda23_ ((GamesScoresDialog*) self);
}

static void
games_scores_dialog_setup_columns (GamesScoresDialog* self,
                                   GamesScoresCategory* category)
{
	GtkColumnView* _tmp0_;
	GtkColumnViewColumn* _tmp1_;
	GtkColumnView* _tmp2_;
	GtkColumnViewColumn* _tmp3_;
	GtkColumnView* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	GtkColumnViewColumn* _tmp6_;
	GtkColumnViewColumn* _tmp7_;
	GtkColumnViewColumn* _tmp8_;
	GtkColumnViewColumn* _tmp9_;
	GListStore* _tmp10_;
	GtkSortListModel* sort_model = NULL;
	GListStore* _tmp11_;
	GListModel* _tmp12_;
	GtkColumnView* _tmp13_;
	GtkSorter* _tmp14_;
	GtkSorter* _tmp15_;
	GtkSorter* _tmp16_;
	GtkSortListModel* _tmp17_;
	GtkColumnView* _tmp18_;
	GtkSortListModel* _tmp19_;
	GListModel* _tmp20_;
	GtkNoSelection* _tmp21_;
	GtkNoSelection* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GtkColumnView* _tmp28_;
	GtkSorter* _tmp29_;
	GtkSorter* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	games_scores_dialog_set_up_rank_column (self);
	games_scores_dialog_set_up_score_column (self);
	games_scores_dialog_set_up_player_column (self, category);
	_tmp0_ = self->priv->score_view;
	_tmp1_ = self->priv->rank_column;
	gtk_column_view_append_column (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->score_view;
	_tmp3_ = self->priv->score_column;
	gtk_column_view_append_column (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->score_view;
	_tmp5_ = self->priv->player_column;
	gtk_column_view_append_column (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->score_column;
	gtk_column_view_column_set_expand (_tmp6_, TRUE);
	_tmp7_ = self->priv->score_column;
	gtk_column_view_column_set_fixed_width (_tmp7_, 0);
	_tmp8_ = self->priv->player_column;
	gtk_column_view_column_set_expand (_tmp8_, TRUE);
	_tmp9_ = self->priv->player_column;
	gtk_column_view_column_set_fixed_width (_tmp9_, 0);
	_tmp10_ = g_list_store_new (GAMES_SCORES_TYPE_SCORE);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp10_;
	_tmp11_ = self->priv->score_model;
	_tmp12_ = _g_object_ref0 ((GListModel*) _tmp11_);
	_tmp13_ = self->priv->score_view;
	_tmp14_ = gtk_column_view_get_sorter (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = gtk_sort_list_model_new (_tmp12_, _tmp16_);
	sort_model = _tmp17_;
	_tmp18_ = self->priv->score_view;
	_tmp19_ = sort_model;
	_tmp20_ = _g_object_ref0 ((GListModel*) _tmp19_);
	_tmp21_ = gtk_no_selection_new (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_column_view_set_model (_tmp18_, (GtkSelectionModel*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = self->priv->scores_style == GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER;
	}
	if (_tmp23_) {
		GtkColumnView* _tmp24_;
		GtkColumnViewColumn* _tmp25_;
		_tmp24_ = self->priv->score_view;
		_tmp25_ = self->priv->rank_column;
		gtk_column_view_sort_by_column (_tmp24_, _tmp25_, GTK_SORT_ASCENDING);
	} else {
		GtkColumnView* _tmp26_;
		GtkColumnViewColumn* _tmp27_;
		_tmp26_ = self->priv->score_view;
		_tmp27_ = self->priv->rank_column;
		gtk_column_view_sort_by_column (_tmp26_, _tmp27_, GTK_SORT_DESCENDING);
	}
	_tmp28_ = self->priv->score_view;
	_tmp29_ = gtk_column_view_get_sorter (_tmp28_);
	_tmp30_ = _tmp29_;
	g_signal_connect_object (_tmp30_, "changed", (GCallback) ___lambda23__gtk_sorter_changed, self, 0);
	_g_object_unref0 (sort_model);
}

static gint
games_scores_dialog_rank_sorter_cb (GamesScoresScore* entry1,
                                    GamesScoresScore* entry2)
{
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
	gint result;
	g_return_val_if_fail (entry1 != NULL, 0);
	g_return_val_if_fail (entry2 != NULL, 0);
	_tmp0_ = games_scores_score_get_score (entry1);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_score_get_score (entry2);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_scores_score_get_score (entry1);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_scores_score_get_score (entry2);
	_tmp7_ = _tmp6_;
	result = ((gint) (_tmp1_ > _tmp3_)) - ((gint) (_tmp5_ < _tmp7_));
	return result;
}

static void
__lambda15_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_ = NULL;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_width_chars (_tmp0_, 3);
	gtk_label_set_xalign (_tmp0_, (gfloat) 0);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "caption");
	gtk_widget_add_css_class ((GtkWidget*) label, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda15__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda15_ ((GamesScoresDialog*) self, _sender, object);
}

static void
__lambda16_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkLabel* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	guint position = 0U;
	GListStore* _tmp6_;
	GamesScoresScore* _tmp7_;
	guint _tmp8_ = 0U;
	GamesScoresScore* _tmp9_;
	GamesScoresScore* _tmp10_;
	GtkLabel* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = self->priv->score_model;
	_tmp7_ = score;
	g_list_store_find (_tmp6_, (GObject*) _tmp7_, &_tmp8_);
	position = _tmp8_;
	_tmp9_ = score;
	_tmp10_ = self->priv->new_high_score;
	if (_tmp9_ == _tmp10_) {
		GtkLabel* _tmp11_;
		_tmp11_ = label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "heading");
	}
	_tmp12_ = label;
	_tmp13_ = g_strdup_printf ("%u", position + 1);
	_tmp14_ = _tmp13_;
	gtk_label_set_label (_tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
}

static void
___lambda16__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda16_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_rank_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkMultiSorter* sorter = NULL;
	GtkMultiSorter* _tmp1_;
	GtkCustomSorter* _tmp2_;
	GtkListItemFactory* _tmp3_;
	GtkColumnViewColumn* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = gtk_multi_sorter_new ();
	sorter = _tmp1_;
	g_signal_connect_object (factory, "setup", (GCallback) ___lambda15__gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) ___lambda16__gtk_signal_list_item_factory_bind, self, 0);
	_tmp2_ = gtk_custom_sorter_new ((GCompareDataFunc) games_scores_dialog_rank_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp2_);
	_tmp3_ = _g_object_ref0 ((GtkListItemFactory*) factory);
	_tmp4_ = gtk_column_view_column_new ("Rank", _tmp3_);
	_g_object_unref0 (self->priv->rank_column);
	self->priv->rank_column = _tmp4_;
	_tmp5_ = self->priv->rank_column;
	gtk_column_view_column_set_sorter (_tmp5_, (GtkSorter*) sorter);
	_g_object_unref0 (sorter);
	_g_object_unref0 (factory);
}

static void
__lambda17_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkInscription* _tmp0_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkInscription*) gtk_inscription_new (NULL);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda17__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda17_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda18_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GamesScoresScore* _tmp6_;
	GamesScoresScore* _tmp7_;
	GtkInscription* _tmp9_;
	GamesScoresScore* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = score;
	_tmp7_ = self->priv->new_high_score;
	if (_tmp6_ == _tmp7_) {
		GtkInscription* _tmp8_;
		_tmp8_ = label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "heading");
	}
	_tmp9_ = label;
	_tmp10_ = score;
	_tmp11_ = games_scores_score_get_score (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%li", _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_inscription_set_text (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
}

static void
____lambda18__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	___lambda18_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda19_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	gchar* time_label = NULL;
	GamesScoresScore* _tmp6_;
	glong _tmp7_;
	glong _tmp8_;
	gchar* _tmp9_;
	GamesScoresScore* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	GamesScoresScore* _tmp20_;
	GamesScoresScore* _tmp21_;
	GtkInscription* _tmp23_;
	const gchar* _tmp24_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = score;
	_tmp7_ = games_scores_score_get_score (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%lds", _tmp8_);
	time_label = _tmp9_;
	_tmp10_ = score;
	_tmp11_ = games_scores_score_get_score (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ >= ((glong) 60)) {
		GamesScoresScore* _tmp13_;
		glong _tmp14_;
		glong _tmp15_;
		GamesScoresScore* _tmp16_;
		glong _tmp17_;
		glong _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = score;
		_tmp14_ = games_scores_score_get_score (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = score;
		_tmp17_ = games_scores_score_get_score (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%ldm %lds", _tmp15_ / 60, _tmp18_ % 60);
		_g_free0 (time_label);
		time_label = _tmp19_;
	}
	_tmp20_ = score;
	_tmp21_ = self->priv->new_high_score;
	if (_tmp20_ == _tmp21_) {
		GtkInscription* _tmp22_;
		_tmp22_ = label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp22_, "heading");
	}
	_tmp23_ = label;
	_tmp24_ = time_label;
	gtk_inscription_set_text (_tmp23_, _tmp24_);
	_g_free0 (time_label);
}

static void
____lambda19__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	___lambda19_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_score_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_;
	GtkSignalListItemFactory* _tmp6_;
	GtkListItemFactory* _tmp7_;
	GtkColumnViewColumn* _tmp8_;
	GtkColumnViewColumn* _tmp9_;
	GtkColumnViewColumn* _tmp10_;
	GtkSorter* _tmp11_;
	GtkSorter* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = factory;
	g_signal_connect_object (_tmp1_, "setup", (GCallback) ___lambda17__gtk_signal_list_item_factory_setup, self, 0);
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp2_) {
		GtkSignalListItemFactory* _tmp3_;
		_tmp3_ = factory;
		g_signal_connect_object (_tmp3_, "bind", (GCallback) ____lambda18__gtk_signal_list_item_factory_bind, self, 0);
	} else {
		GtkSignalListItemFactory* _tmp4_;
		_tmp4_ = factory;
		g_signal_connect_object (_tmp4_, "bind", (GCallback) ____lambda19__gtk_signal_list_item_factory_bind, self, 0);
	}
	_tmp5_ = self->priv->score_or_time;
	_tmp6_ = factory;
	_tmp7_ = _g_object_ref0 ((GtkListItemFactory*) _tmp6_);
	_tmp8_ = gtk_column_view_column_new (_tmp5_, _tmp7_);
	_g_object_unref0 (self->priv->score_column);
	self->priv->score_column = _tmp8_;
	_tmp9_ = self->priv->score_column;
	_tmp10_ = self->priv->rank_column;
	_tmp11_ = gtk_column_view_column_get_sorter (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_column_view_column_set_sorter (_tmp9_, _tmp12_);
	_g_object_unref0 (factory);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->active_category);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data7_->_data6_->self;
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data8_->_data7_->_data6_->self;
		_g_object_unref0 (_data8_->entry);
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static void
___lambda21_ (Block8Data* _data8_)
{
	Block7Data* _data7_;
	Block6Data* _data6_;
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	GamesScoresScore* _tmp4_;
	GtkEntry* _tmp5_;
	const gchar* _tmp6_;
	_data7_ = _data8_->_data7_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = self->priv->context;
	_tmp1_ = _data7_->score;
	_tmp2_ = _data8_->entry;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	games_scores_context_update_score_name (_tmp0_, _tmp1_, _data6_->active_category, _tmp3_);
	_tmp4_ = _data7_->score;
	_tmp5_ = _data8_->entry;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	games_scores_score_set_user (_tmp4_, _tmp6_);
}

static void
____lambda21__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda21_ (self);
}

static void
___lambda22_ (GamesScoresDialog* self)
{
	adw_dialog_close ((AdwDialog*) self);
}

static void
____lambda22__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	___lambda22_ ((GamesScoresDialog*) self);
}

static void
__lambda20_ (Block6Data* _data6_,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GamesScoresDialog* self;
	Block7Data* _data7_;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GamesScoresScore* _tmp3_;
	GamesScoresScore* _tmp4_;
	self = _data6_->self;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->_data6_ = block6_data_ref (_data6_);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_data7_->score = GAMES_SCORES_IS_SCORE (_tmp2_) ? ((GamesScoresScore*) _tmp2_) : NULL;
	_tmp3_ = _data7_->score;
	_tmp4_ = self->priv->new_high_score;
	if (_tmp3_ == _tmp4_) {
		Block8Data* _data8_;
		GtkEntry* _tmp5_;
		GtkEntry* _tmp6_;
		GamesScoresScore* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkEntry* _tmp10_;
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		GtkEntry* _tmp13_;
		GtkListItem* _tmp14_;
		GtkEntry* _tmp15_;
		GtkColumnView* _tmp16_;
		GtkEntry* _tmp17_;
		GtkColumnView* _tmp18_;
		GtkListItem* _tmp19_;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->_data7_ = block7_data_ref (_data7_);
		_tmp5_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp5_);
		_data8_->entry = _tmp5_;
		_tmp6_ = _data8_->entry;
		_tmp7_ = _data7_->score;
		_tmp8_ = games_scores_score_get_user (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_editable_set_text ((GtkEditable*) _tmp6_, _tmp9_);
		_tmp10_ = _data8_->entry;
		gtk_entry_set_has_frame (_tmp10_, FALSE);
		_tmp11_ = _data8_->entry;
		gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "heading");
		_tmp12_ = _data8_->entry;
		g_signal_connect_data ((GObject*) _tmp12_, "notify::text", (GCallback) ____lambda21__g_object_notify, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
		_tmp13_ = _data8_->entry;
		g_signal_connect_object (_tmp13_, "activate", (GCallback) ____lambda22__gtk_entry_activate, self, 0);
		_tmp14_ = list_item;
		_tmp15_ = _data8_->entry;
		gtk_list_item_set_child (_tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = self->priv->score_view;
		adw_dialog_set_focus ((AdwDialog*) self, (GtkWidget*) _tmp16_);
		_tmp17_ = _data8_->entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->score_view;
		_tmp19_ = list_item;
		gtk_column_view_scroll_to (_tmp18_, gtk_list_item_get_position (_tmp19_), NULL, GTK_LIST_SCROLL_NONE, NULL);
		block8_data_unref (_data8_);
		_data8_ = NULL;
	} else {
		GtkListItem* _tmp20_;
		GamesScoresScore* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GtkInscription* _tmp24_;
		GtkInscription* _tmp25_;
		_tmp20_ = list_item;
		_tmp21_ = _data7_->score;
		_tmp22_ = games_scores_score_get_user (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = (GtkInscription*) gtk_inscription_new (_tmp23_);
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		gtk_list_item_set_child (_tmp20_, (GtkWidget*) _tmp25_);
		_g_object_unref0 (_tmp25_);
	}
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
___lambda20__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda20_ (self, _sender, object);
}

static void
games_scores_dialog_set_up_player_column (GamesScoresDialog* self,
                                          GamesScoresCategory* active_category)
{
	Block6Data* _data6_;
	GamesScoresCategory* _tmp0_;
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp1_;
	GtkListItemFactory* _tmp2_;
	GtkColumnViewColumn* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_category != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (active_category);
	_g_object_unref0 (_data6_->active_category);
	_data6_->active_category = _tmp0_;
	_tmp1_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp1_;
	g_signal_connect_data (factory, "bind", (GCallback) ___lambda20__gtk_signal_list_item_factory_bind, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp2_ = _g_object_ref0 ((GtkListItemFactory*) factory);
	_tmp3_ = gtk_column_view_column_new (_ ("Player"), _tmp2_);
	_g_object_unref0 (self->priv->player_column);
	self->priv->player_column = _tmp3_;
	_g_object_unref0 (factory);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data9_->self;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda24_ (Block9Data* _data9_)
{
	GamesScoresDialog* self;
	self = _data9_->self;
	adw_dialog_close ((AdwDialog*) self);
	_data9_->new_game_func (_data9_->new_game_func_target);
}

static void
___lambda24__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda24_ (self);
}

static void
__lambda25_ (Block9Data* _data9_)
{
	GamesScoresDialog* self;
	self = _data9_->self;
	adw_dialog_close ((AdwDialog*) self);
	_data9_->quit_app_func (_data9_->quit_app_func_target);
}

static void
___lambda25__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda25_ (self);
}

void
games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self,
                                        GamesScoresContextNewGameFunc new_game_func,
                                        gpointer new_game_func_target,
                                        GamesScoresContextQuitAppFunc quit_app_func,
                                        gpointer quit_app_func_target)
{
	Block9Data* _data9_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkCenterBox* bottom_bar = NULL;
	GtkCenterBox* _tmp1_;
	GtkButton* new_game_button = NULL;
	GtkButton* _tmp2_;
	GtkButton* quit_button = NULL;
	GtkButton* _tmp3_;
	AdwButtonContent* content = NULL;
	AdwButtonContent* _tmp4_;
	AdwToolbarView* _tmp5_;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->new_game_func = new_game_func;
	_data9_->new_game_func_target = new_game_func_target;
	_data9_->quit_app_func = quit_app_func;
	_data9_->quit_app_func_target = quit_app_func_target;
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = (GtkCenterBox*) gtk_center_box_new ();
	g_object_ref_sink (_tmp1_);
	bottom_bar = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_ ("_New Game"));
	g_object_ref_sink (_tmp2_);
	new_game_button = _tmp2_;
	gtk_button_set_use_underline (new_game_button, TRUE);
	gtk_button_set_can_shrink (new_game_button, TRUE);
	g_signal_connect_data (new_game_button, "clicked", (GCallback) ___lambda24__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	quit_button = _tmp3_;
	gtk_button_set_can_shrink (quit_button, TRUE);
	_tmp4_ = (AdwButtonContent*) adw_button_content_new ();
	g_object_ref_sink (_tmp4_);
	content = _tmp4_;
	adw_button_content_set_icon_name (content, "application-exit-symbolic");
	adw_button_content_set_label (content, _ ("_Quit"));
	adw_button_content_set_use_underline (content, TRUE);
	adw_button_content_set_can_shrink (content, TRUE);
	gtk_button_set_child (quit_button, (GtkWidget*) content);
	g_signal_connect_data (quit_button, "clicked", (GCallback) ___lambda25__gtk_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	gtk_widget_add_css_class ((GtkWidget*) new_game_button, "pill");
	gtk_widget_add_css_class ((GtkWidget*) quit_button, "toolbar");
	gtk_widget_add_css_class ((GtkWidget*) bottom_bar, "toolbar");
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) bottom_bar, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) bottom_bar, builder, (GObject*) new_game_button, "center");
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) bottom_bar, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) bottom_bar, builder, (GObject*) quit_button, "end");
	_tmp5_ = self->priv->toolbar;
	G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp5_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp5_, builder, (GObject*) bottom_bar, "bottom");
	_g_object_unref0 (content);
	_g_object_unref0 (quit_button);
	_g_object_unref0 (new_game_button);
	_g_object_unref0 (bottom_bar);
	_g_object_unref0 (builder);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass,
                                gpointer klass_data)
{
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
}

static void
games_scores_dialog_instance_init (GamesScoresDialog * self,
                                   gpointer klass)
{
	self->priv = games_scores_dialog_get_instance_private (self);
	self->priv->score_model = NULL;
	self->priv->done_button = NULL;
}

static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->score_model);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->done_button);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->rank_column);
	_g_object_unref0 (self->priv->score_column);
	_g_object_unref0 (self->priv->player_column);
	_g_object_unref0 (self->priv->new_high_score);
	_g_free0 (self->priv->score_or_time);
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
games_scores_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
	GType games_scores_dialog_type_id;
	games_scores_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
	GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
	return games_scores_dialog_type_id;
}

GType
games_scores_dialog_get_type (void)
{
	static gsize games_scores_dialog_type_id__once = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__once)) {
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = games_scores_dialog_get_type_once ();
		g_once_init_leave (&games_scores_dialog_type_id__once, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__once;
}

