/* sudoku-board.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libsudoku.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <qqwing-wrapper.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SUDOKU_BOARD_TYPE_CELL (sudoku_board_cell_get_type ())
typedef struct _SudokuBoardCell SudokuBoardCell;

#define SUDOKU_BOARD_TYPE_DIGIT_OCCURENCES (sudoku_board_digit_occurences_get_type ())
typedef struct _SudokuBoardDigitOccurences SudokuBoardDigitOccurences;
enum  {
	SUDOKU_BOARD_0_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY,
	SUDOKU_BOARD_BLOCK_ROWS_PROPERTY,
	SUDOKU_BOARD_BLOCK_COLS_PROPERTY,
	SUDOKU_BOARD_ROWS_PROPERTY,
	SUDOKU_BOARD_COLS_PROPERTY,
	SUDOKU_BOARD_MAX_VAL_PROPERTY,
	SUDOKU_BOARD_FILLED_PROPERTY,
	SUDOKU_BOARD_FIXED_PROPERTY,
	SUDOKU_BOARD_COMPLETE_PROPERTY,
	SUDOKU_BOARD_BROKEN_COORDS_PROPERTY,
	SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY,
	SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY,
	SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY,
	SUDOKU_BOARD_NUM_PROPERTIES
};
static GParamSpec* sudoku_board_properties[SUDOKU_BOARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SUDOKU_BOARD_COMPLETED_SIGNAL,
	SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL,
	SUDOKU_BOARD_VALUE_CHANGED_SIGNAL,
	SUDOKU_BOARD_NUM_SIGNALS
};
static guint sudoku_board_signals[SUDOKU_BOARD_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuBoardCell {
	gint value;
	gint solution;
	gboolean* earmarks;
	gint earmarks_length1;
	gint _earmarks_size_;
	gboolean fixed;
};

struct _SudokuBoardDigitOccurences {
	gint* occurrences_in_row;
	gint occurrences_in_row_length1;
	gint _occurrences_in_row_size_;
	gint* occurrences_in_col;
	gint occurrences_in_col_length1;
	gint _occurrences_in_col_size_;
	gint* occurrences_in_block;
	gint occurrences_in_block_length1;
	gint occurrences_in_block_length2;
};

struct _SudokuBoardPrivate {
	SudokuBoardCell* cells;
	gint cells_length1;
	gint cells_length2;
	SudokuBoardDigitOccurences* digits;
	gint digits_length1;
	gint _digits_size_;
	gboolean has_solution;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
	GeeSet* _broken_coords;
	GeeList* _coords_for_col;
	GeeList* _coords_for_row;
	GeeMap* _coords_for_block;
};

static gint SudokuBoard_private_offset;
static gpointer sudoku_board_parent_class = NULL;

static GType sudoku_board_cell_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SudokuBoardCell* sudoku_board_cell_dup (const SudokuBoardCell* self);
static void sudoku_board_cell_free (SudokuBoardCell* self);
static void sudoku_board_cell_copy (const SudokuBoardCell* self,
                             SudokuBoardCell* dest);
static void sudoku_board_cell_destroy (SudokuBoardCell* self);
static GType sudoku_board_digit_occurences_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SudokuBoardDigitOccurences* sudoku_board_digit_occurences_dup (const SudokuBoardDigitOccurences* self);
static void sudoku_board_digit_occurences_free (SudokuBoardDigitOccurences* self);
static void sudoku_board_digit_occurences_copy (const SudokuBoardDigitOccurences* self,
                                         SudokuBoardDigitOccurences* dest);
static void sudoku_board_digit_occurences_destroy (SudokuBoardDigitOccurences* self);
static void _vala_SudokuBoardCell_array_free (SudokuBoardCell * array,
                                       gssize array_length);
static void _vala_SudokuBoardDigitOccurences_array_free (SudokuBoardDigitOccurences * array,
                                                  gssize array_length);
static void sudoku_board_set_broken_coords (SudokuBoard* self,
                                     GeeSet* value);
static void sudoku_board_set_coords_for_col (SudokuBoard* self,
                                      GeeList* value);
static void sudoku_board_set_coords_for_row (SudokuBoard* self,
                                      GeeList* value);
static void sudoku_board_set_coords_for_block (SudokuBoard* self,
                                        GeeMap* value);
static SudokuBoardCell* _vala_array_dup1 (SudokuBoardCell* self,
                                   gssize length);
static SudokuBoardDigitOccurences* _vala_array_dup2 (SudokuBoardDigitOccurences* self,
                                              gssize length);
static void sudoku_board_set_filled (SudokuBoard* self,
                              gint value);
static void sudoku_board_set_fixed (SudokuBoard* self,
                             gint value);
static gboolean* _vala_array_dup3 (gboolean* self,
                            gssize length);
static gint* sudoku_board_get_fixed_cells (SudokuBoard* self,
                                    gint* result_length1,
                                    gint* result_length2);
static gint* _vala_array_dup4 (gint* self,
                        gssize length);
static void sudoku_board_update_old_breakages (SudokuBoard* self,
                                        gint row,
                                        gint col,
                                        gint val);
static void sudoku_board_add_to_occurrences (SudokuBoard* self,
                                      gint row,
                                      gint col,
                                      gint val,
                                      gint add);
static void sudoku_board_mark_breakages (SudokuBoard* self,
                                  gint row,
                                  gint col,
                                  gint val);
static void sudoku_board_remove_breakages_for (SudokuBoard* self,
                                        GeeList* coords,
                                        gint val);
static void sudoku_board_mark_breakages_for (SudokuBoard* self,
                                      GeeList* coords,
                                      gint val);
static gint* sudoku_board_convert_2d_to_1d (SudokuBoard* self,
                                     gint* ints_2d,
                                     gint ints_2d_length1,
                                     gint ints_2d_length2,
                                     gint* result_length1);
static void sudoku_board_set_block_rows (SudokuBoard* self,
                                  gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self,
                                  gint value);
static void sudoku_board_set_rows (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_cols (SudokuBoard* self,
                            gint value);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_BOOLEAN (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static gboolean* _vala_array_dup5 (gboolean* self,
                            gssize length);
static gint* _vala_array_dup6 (gint* self,
                        gssize length);
static gint* _vala_array_dup7 (gint* self,
                        gssize length);
static gint* _vala_array_dup8 (gint* self,
                        gssize length);
static void sudoku_board_finalize (GObject * obj);
static GType sudoku_board_get_type_once (void);
static void _vala_sudoku_board_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sudoku_board_get_instance_private (SudokuBoard* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuBoard_private_offset);
}

static void
_vala_SudokuBoardCell_array_free (SudokuBoardCell * array,
                                  gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			sudoku_board_cell_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_SudokuBoardDigitOccurences_array_free (SudokuBoardDigitOccurences * array,
                                             gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			sudoku_board_digit_occurences_destroy (&array[i]);
		}
	}
	g_free (array);
}

gboolean
sudoku_board_is_empty (SudokuBoard* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_fixed;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = self->priv->n_earmarks == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
sudoku_board_is_fully_filled (SudokuBoard* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filled;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = self->priv->_rows;
	result = _tmp0_ == (_tmp1_ * _tmp2_);
	return result;
}

SudokuBoard*
sudoku_board_construct (GType object_type)
{
	SudokuBoard * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	SudokuBoardCell* _tmp2_;
	gint _tmp13_;
	gint _tmp14_;
	SudokuBoardDigitOccurences* _tmp15_;
	GeeHashSet* _tmp30_;
	GeeHashSet* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeList* _tmp54_;
	GeeList* _tmp55_;
	GeeList* _tmp56_;
	GeeList* _tmp57_;
	GeeArrayList* _tmp58_;
	GeeArrayList* _tmp59_;
	GeeList* _tmp80_;
	GeeList* _tmp81_;
	GeeList* _tmp82_;
	GeeList* _tmp83_;
	GeeHashMap* _tmp84_;
	GeeHashMap* _tmp85_;
	GeeMap* _tmp124_;
	GeeMap* _tmp125_;
	GeeMap* _tmp126_;
	GeeMap* _tmp127_;
	self = (SudokuBoard*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (SudokuBoardCell, _tmp0_ * _tmp1_);
	self->priv->cells = (_vala_SudokuBoardCell_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2), NULL);
	self->priv->cells = _tmp2_;
	self->priv->cells_length1 = _tmp0_;
	self->priv->cells_length2 = _tmp1_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							SudokuBoardCell* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							gboolean* _tmp12_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = self->priv->cells;
							_tmp9__length1 = self->priv->cells_length1;
							_tmp9__length2 = self->priv->cells_length2;
							_tmp10_ = sudoku_board_get_max_val (self);
							_tmp11_ = _tmp10_;
							_tmp12_ = g_new0 (gboolean, _tmp11_);
							_tmp9_[(row * _tmp9__length2) + col].earmarks = (g_free (_tmp9_[(row * _tmp9__length2) + col].earmarks), NULL);
							_tmp9_[(row * _tmp9__length2) + col].earmarks = _tmp12_;
							_tmp9_[(row * _tmp9__length2) + col].earmarks_length1 = _tmp11_;
							_tmp9_[(row * _tmp9__length2) + col]._earmarks_size_ = _tmp9_[(row * _tmp9__length2) + col].earmarks_length1;
						}
					}
				}
			}
		}
	}
	_tmp13_ = sudoku_board_get_max_val (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (SudokuBoardDigitOccurences, _tmp14_);
	self->priv->digits = (_vala_SudokuBoardDigitOccurences_array_free (self->priv->digits, self->priv->digits_length1), NULL);
	self->priv->digits = _tmp15_;
	self->priv->digits_length1 = _tmp14_;
	self->priv->_digits_size_ = self->priv->digits_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				SudokuBoardDigitOccurences* _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				gint* _tmp22_;
				SudokuBoardDigitOccurences* _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				gint* _tmp25_;
				SudokuBoardDigitOccurences* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gint _tmp28_;
				gint* _tmp29_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = sudoku_board_get_max_val (self);
				_tmp19_ = _tmp18_;
				if (!(i < _tmp19_)) {
					break;
				}
				_tmp20_ = self->priv->digits;
				_tmp20__length1 = self->priv->digits_length1;
				_tmp21_ = self->priv->_rows;
				_tmp22_ = g_new0 (gint, _tmp21_);
				_tmp20_[i].occurrences_in_row = (g_free (_tmp20_[i].occurrences_in_row), NULL);
				_tmp20_[i].occurrences_in_row = _tmp22_;
				_tmp20_[i].occurrences_in_row_length1 = _tmp21_;
				_tmp20_[i]._occurrences_in_row_size_ = _tmp20_[i].occurrences_in_row_length1;
				_tmp23_ = self->priv->digits;
				_tmp23__length1 = self->priv->digits_length1;
				_tmp24_ = self->priv->_cols;
				_tmp25_ = g_new0 (gint, _tmp24_);
				_tmp23_[i].occurrences_in_col = (g_free (_tmp23_[i].occurrences_in_col), NULL);
				_tmp23_[i].occurrences_in_col = _tmp25_;
				_tmp23_[i].occurrences_in_col_length1 = _tmp24_;
				_tmp23_[i]._occurrences_in_col_size_ = _tmp23_[i].occurrences_in_col_length1;
				_tmp26_ = self->priv->digits;
				_tmp26__length1 = self->priv->digits_length1;
				_tmp27_ = self->priv->_block_rows;
				_tmp28_ = self->priv->_block_cols;
				_tmp29_ = g_new0 (gint, _tmp27_ * _tmp28_);
				_tmp26_[i].occurrences_in_block = (g_free (_tmp26_[i].occurrences_in_block), NULL);
				_tmp26_[i].occurrences_in_block = _tmp29_;
				_tmp26_[i].occurrences_in_block_length1 = _tmp27_;
				_tmp26_[i].occurrences_in_block_length2 = _tmp28_;
			}
		}
	}
	_tmp30_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	_tmp31_ = _tmp30_;
	sudoku_board_set_broken_coords (self, (GeeSet*) _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp33_ = _tmp32_;
	sudoku_board_set_coords_for_col (self, (GeeList*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_;
				GeeList* _tmp37_;
				GeeArrayList* _tmp38_;
				GeeArrayList* _tmp39_;
				GeeList* _tmp47_;
				GeeList* _tmp48_;
				gpointer _tmp49_;
				GeeList* _tmp50_;
				GeeList* _tmp51_;
				GeeList* _tmp52_;
				GeeList* _tmp53_;
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = col;
					col = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = self->priv->_cols;
				if (!(col < _tmp36_)) {
					break;
				}
				_tmp37_ = self->priv->_coords_for_col;
				_tmp38_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp39_ = _tmp38_;
				gee_collection_add ((GeeCollection*) _tmp37_, (GeeList*) _tmp39_);
				_g_object_unref0 (_tmp39_);
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp40_ = FALSE;
						_tmp40_ = TRUE;
						while (TRUE) {
							gint _tmp42_;
							GeeList* _tmp43_;
							gpointer _tmp44_;
							GeeList* _tmp45_;
							Coord _tmp46_ = {0};
							if (!_tmp40_) {
								gint _tmp41_;
								_tmp41_ = row;
								row = _tmp41_ + 1;
							}
							_tmp40_ = FALSE;
							_tmp42_ = self->priv->_rows;
							if (!(row < _tmp42_)) {
								break;
							}
							_tmp43_ = self->priv->_coords_for_col;
							_tmp44_ = gee_list_get (_tmp43_, col);
							_tmp45_ = (GeeList*) _tmp44_;
							coord_init (&_tmp46_, row, col);
							gee_collection_add ((GeeCollection*) _tmp45_, &_tmp46_);
							_g_object_unref0 (_tmp45_);
						}
					}
				}
				_tmp47_ = self->priv->_coords_for_col;
				_tmp48_ = self->priv->_coords_for_col;
				_tmp49_ = gee_list_get (_tmp48_, col);
				_tmp50_ = (GeeList*) _tmp49_;
				_tmp51_ = gee_list_get_read_only_view (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = _tmp52_;
				gee_list_set (_tmp47_, col, _tmp53_);
				_g_object_unref0 (_tmp53_);
				_g_object_unref0 (_tmp50_);
			}
		}
	}
	_tmp54_ = self->priv->_coords_for_col;
	_tmp55_ = gee_list_get_read_only_view (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = _tmp56_;
	sudoku_board_set_coords_for_col (self, _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp59_ = _tmp58_;
	sudoku_board_set_coords_for_row (self, (GeeList*) _tmp59_);
	_g_object_unref0 (_tmp59_);
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				gint _tmp62_;
				GeeList* _tmp63_;
				GeeArrayList* _tmp64_;
				GeeArrayList* _tmp65_;
				GeeList* _tmp73_;
				GeeList* _tmp74_;
				gpointer _tmp75_;
				GeeList* _tmp76_;
				GeeList* _tmp77_;
				GeeList* _tmp78_;
				GeeList* _tmp79_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = row;
					row = _tmp61_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp62_ = self->priv->_rows;
				if (!(row < _tmp62_)) {
					break;
				}
				_tmp63_ = self->priv->_coords_for_row;
				_tmp64_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp65_ = _tmp64_;
				gee_collection_add ((GeeCollection*) _tmp63_, (GeeList*) _tmp65_);
				_g_object_unref0 (_tmp65_);
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp66_ = FALSE;
						_tmp66_ = TRUE;
						while (TRUE) {
							gint _tmp68_;
							GeeList* _tmp69_;
							gpointer _tmp70_;
							GeeList* _tmp71_;
							Coord _tmp72_ = {0};
							if (!_tmp66_) {
								gint _tmp67_;
								_tmp67_ = col;
								col = _tmp67_ + 1;
							}
							_tmp66_ = FALSE;
							_tmp68_ = self->priv->_cols;
							if (!(col < _tmp68_)) {
								break;
							}
							_tmp69_ = self->priv->_coords_for_row;
							_tmp70_ = gee_list_get (_tmp69_, row);
							_tmp71_ = (GeeList*) _tmp70_;
							coord_init (&_tmp72_, row, col);
							gee_collection_add ((GeeCollection*) _tmp71_, &_tmp72_);
							_g_object_unref0 (_tmp71_);
						}
					}
				}
				_tmp73_ = self->priv->_coords_for_row;
				_tmp74_ = self->priv->_coords_for_row;
				_tmp75_ = gee_list_get (_tmp74_, row);
				_tmp76_ = (GeeList*) _tmp75_;
				_tmp77_ = gee_list_get_read_only_view (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = _tmp78_;
				gee_list_set (_tmp73_, row, _tmp79_);
				_g_object_unref0 (_tmp79_);
				_g_object_unref0 (_tmp76_);
			}
		}
	}
	_tmp80_ = self->priv->_coords_for_row;
	_tmp81_ = gee_list_get_read_only_view (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = _tmp82_;
	sudoku_board_set_coords_for_row (self, _tmp83_);
	_g_object_unref0 (_tmp83_);
	_tmp84_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_tmp85_ = _tmp84_;
	sudoku_board_set_coords_for_block (self, (GeeMap*) _tmp85_);
	_g_object_unref0 (_tmp85_);
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp86_ = FALSE;
			_tmp86_ = TRUE;
			while (TRUE) {
				gint _tmp88_;
				if (!_tmp86_) {
					gint _tmp87_;
					_tmp87_ = col;
					col = _tmp87_ + 1;
				}
				_tmp86_ = FALSE;
				_tmp88_ = self->priv->_block_cols;
				if (!(col < _tmp88_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp89_ = FALSE;
						_tmp89_ = TRUE;
						while (TRUE) {
							gint _tmp91_;
							GeeMap* _tmp92_;
							Coord _tmp93_ = {0};
							GeeArrayList* _tmp94_;
							GeeArrayList* _tmp95_;
							if (!_tmp89_) {
								gint _tmp90_;
								_tmp90_ = row;
								row = _tmp90_ + 1;
							}
							_tmp89_ = FALSE;
							_tmp91_ = self->priv->_block_rows;
							if (!(row < _tmp91_)) {
								break;
							}
							_tmp92_ = self->priv->_coords_for_block;
							coord_init (&_tmp93_, row, col);
							_tmp94_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
							_tmp95_ = _tmp94_;
							gee_map_set (_tmp92_, &_tmp93_, (GeeList*) _tmp95_);
							_g_object_unref0 (_tmp95_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp96_ = FALSE;
			_tmp96_ = TRUE;
			while (TRUE) {
				gint _tmp98_;
				if (!_tmp96_) {
					gint _tmp97_;
					_tmp97_ = col;
					col = _tmp97_ + 1;
				}
				_tmp96_ = FALSE;
				_tmp98_ = self->priv->_cols;
				if (!(col < _tmp98_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp99_ = FALSE;
						_tmp99_ = TRUE;
						while (TRUE) {
							gint _tmp101_;
							GeeMap* _tmp102_;
							gint _tmp103_;
							gint _tmp104_;
							Coord _tmp105_ = {0};
							gpointer _tmp106_;
							GeeList* _tmp107_;
							Coord _tmp108_ = {0};
							if (!_tmp99_) {
								gint _tmp100_;
								_tmp100_ = row;
								row = _tmp100_ + 1;
							}
							_tmp99_ = FALSE;
							_tmp101_ = self->priv->_rows;
							if (!(row < _tmp101_)) {
								break;
							}
							_tmp102_ = self->priv->_coords_for_block;
							_tmp103_ = self->priv->_block_rows;
							_tmp104_ = self->priv->_block_cols;
							coord_init (&_tmp105_, row / _tmp103_, col / _tmp104_);
							_tmp106_ = gee_map_get (_tmp102_, &_tmp105_);
							_tmp107_ = (GeeList*) _tmp106_;
							coord_init (&_tmp108_, row, col);
							gee_collection_add ((GeeCollection*) _tmp107_, &_tmp108_);
							_g_object_unref0 (_tmp107_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp109_ = FALSE;
			_tmp109_ = TRUE;
			while (TRUE) {
				gint _tmp111_;
				if (!_tmp109_) {
					gint _tmp110_;
					_tmp110_ = col;
					col = _tmp110_ + 1;
				}
				_tmp109_ = FALSE;
				_tmp111_ = self->priv->_block_cols;
				if (!(col < _tmp111_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp112_ = FALSE;
						_tmp112_ = TRUE;
						while (TRUE) {
							gint _tmp114_;
							GeeMap* _tmp115_;
							Coord _tmp116_ = {0};
							GeeMap* _tmp117_;
							Coord _tmp118_ = {0};
							gpointer _tmp119_;
							GeeList* _tmp120_;
							GeeList* _tmp121_;
							GeeList* _tmp122_;
							GeeList* _tmp123_;
							if (!_tmp112_) {
								gint _tmp113_;
								_tmp113_ = row;
								row = _tmp113_ + 1;
							}
							_tmp112_ = FALSE;
							_tmp114_ = self->priv->_block_rows;
							if (!(row < _tmp114_)) {
								break;
							}
							_tmp115_ = self->priv->_coords_for_block;
							coord_init (&_tmp116_, row, col);
							_tmp117_ = self->priv->_coords_for_block;
							coord_init (&_tmp118_, row, col);
							_tmp119_ = gee_map_get (_tmp117_, &_tmp118_);
							_tmp120_ = (GeeList*) _tmp119_;
							_tmp121_ = gee_list_get_read_only_view (_tmp120_);
							_tmp122_ = _tmp121_;
							_tmp123_ = _tmp122_;
							gee_map_set (_tmp115_, &_tmp116_, _tmp123_);
							_g_object_unref0 (_tmp123_);
							_g_object_unref0 (_tmp120_);
						}
					}
				}
			}
		}
	}
	_tmp124_ = self->priv->_coords_for_block;
	_tmp125_ = gee_map_get_read_only_view (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = _tmp126_;
	sudoku_board_set_coords_for_block (self, _tmp127_);
	_g_object_unref0 (_tmp127_);
	return self;
}

SudokuBoard*
sudoku_board_new (void)
{
	return sudoku_board_construct (TYPE_SUDOKU_BOARD);
}

static SudokuBoardCell*
_vala_array_dup1 (SudokuBoardCell* self,
                  gssize length)
{
	if (length > 0) {
		SudokuBoardCell* result;
		gssize i;
		result = g_new0 (SudokuBoardCell, length);
		for (i = 0; i < length; i++) {
			SudokuBoardCell _tmp0_;
			SudokuBoardCell _tmp1_ = {0};
			_tmp0_ = self[i];
			sudoku_board_cell_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static SudokuBoardDigitOccurences*
_vala_array_dup2 (SudokuBoardDigitOccurences* self,
                  gssize length)
{
	if (length > 0) {
		SudokuBoardDigitOccurences* result;
		gssize i;
		result = g_new0 (SudokuBoardDigitOccurences, length);
		for (i = 0; i < length; i++) {
			SudokuBoardDigitOccurences _tmp0_;
			SudokuBoardDigitOccurences _tmp1_ = {0};
			_tmp0_ = self[i];
			sudoku_board_digit_occurences_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

SudokuBoard*
sudoku_board_clone (SudokuBoard* self)
{
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_;
	SudokuBoardCell* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	SudokuBoardCell* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	SudokuBoardDigitOccurences* _tmp3_;
	gint _tmp3__length1;
	SudokuBoardDigitOccurences* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	DifficultyCategory _tmp9_;
	SudokuBoard* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_new ();
	board = _tmp0_;
	_tmp1_ = self->priv->cells;
	_tmp1__length1 = self->priv->cells_length1;
	_tmp1__length2 = self->priv->cells_length2;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1 * _tmp1__length2) : _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	board->priv->cells = (_vala_SudokuBoardCell_array_free (board->priv->cells, board->priv->cells_length1 * board->priv->cells_length2), NULL);
	board->priv->cells = _tmp2_;
	board->priv->cells_length1 = _tmp2__length1;
	board->priv->cells_length2 = _tmp2__length2;
	_tmp3_ = self->priv->digits;
	_tmp3__length1 = self->priv->digits_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	board->priv->digits = (_vala_SudokuBoardDigitOccurences_array_free (board->priv->digits, board->priv->digits_length1), NULL);
	board->priv->digits = _tmp4_;
	board->priv->digits_length1 = _tmp4__length1;
	board->priv->_digits_size_ = board->priv->digits_length1;
	_tmp5_ = self->priv->_filled;
	sudoku_board_set_filled (board, _tmp5_);
	_tmp6_ = self->priv->_fixed;
	sudoku_board_set_fixed (board, _tmp6_);
	board->priv->n_earmarks = self->priv->n_earmarks;
	_tmp7_ = board->priv->_broken_coords;
	_tmp8_ = self->priv->_broken_coords;
	gee_collection_add_all ((GeeCollection*) _tmp7_, (GeeCollection*) _tmp8_);
	_tmp9_ = self->priv->_difficulty_category;
	sudoku_board_set_difficulty_category (board, _tmp9_);
	result = board;
	return result;
}

gint
sudoku_board_get (SudokuBoard* self,
                  gint row,
                  gint col)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_.value;
	return result;
}

static gboolean*
_vala_array_dup3 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

gboolean*
sudoku_board_get_earmarks (SudokuBoard* self,
                           gint row,
                           gint col,
                           gint* result_length1)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gboolean* _tmp3_;
	gint _tmp3__length1;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	_tmp2_ = _tmp1_.earmarks;
	_tmp2__length1 = _tmp1_.earmarks_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup3 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

gboolean
sudoku_board_get_is_fixed (SudokuBoard* self,
                           gint row,
                           gint col)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_.fixed;
	return result;
}

gint
sudoku_board_get_solution (SudokuBoard* self,
                           gint row,
                           gint col)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_.solution;
	return result;
}

gint*
sudoku_board_get_cells (SudokuBoard* self,
                        gint* result_length1,
                        gint* result_length2)
{
	gint* ret = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ret_length1;
	gint ret_length2;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ret = _tmp2_;
	ret_length1 = _tmp0_;
	ret_length2 = _tmp1_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							SudokuBoardCell* _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							SudokuBoardCell _tmp11_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = ret;
							_tmp9__length1 = ret_length1;
							_tmp9__length2 = ret_length2;
							_tmp10_ = self->priv->cells;
							_tmp10__length1 = self->priv->cells_length1;
							_tmp10__length2 = self->priv->cells_length2;
							_tmp11_ = _tmp10_[(row * _tmp10__length2) + col];
							_tmp9_[(row * _tmp9__length2) + col] = _tmp11_.value;
						}
					}
				}
			}
		}
	}
	_tmp12_ = ret;
	_tmp12__length1 = ret_length1;
	_tmp12__length2 = ret_length2;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp12__length2;
	}
	result = _tmp12_;
	return result;
}

static gint*
sudoku_board_get_fixed_cells (SudokuBoard* self,
                              gint* result_length1,
                              gint* result_length2)
{
	gint* ret = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ret_length1;
	gint ret_length2;
	gint* _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ret = _tmp2_;
	ret_length1 = _tmp0_;
	ret_length2 = _tmp1_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							SudokuBoardCell* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							SudokuBoardCell _tmp10_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = self->priv->cells;
							_tmp9__length1 = self->priv->cells_length1;
							_tmp9__length2 = self->priv->cells_length2;
							_tmp10_ = _tmp9_[(row * _tmp9__length2) + col];
							if (_tmp10_.fixed) {
								gint* _tmp11_;
								gint _tmp11__length1;
								gint _tmp11__length2;
								SudokuBoardCell* _tmp12_;
								gint _tmp12__length1;
								gint _tmp12__length2;
								SudokuBoardCell _tmp13_;
								_tmp11_ = ret;
								_tmp11__length1 = ret_length1;
								_tmp11__length2 = ret_length2;
								_tmp12_ = self->priv->cells;
								_tmp12__length1 = self->priv->cells_length1;
								_tmp12__length2 = self->priv->cells_length2;
								_tmp13_ = _tmp12_[(row * _tmp12__length2) + col];
								_tmp11_[(row * _tmp11__length2) + col] = _tmp13_.value;
							} else {
								gint* _tmp14_;
								gint _tmp14__length1;
								gint _tmp14__length2;
								_tmp14_ = ret;
								_tmp14__length1 = ret_length1;
								_tmp14__length2 = ret_length2;
								_tmp14_[(row * _tmp14__length2) + col] = 0;
							}
						}
					}
				}
			}
		}
	}
	_tmp15_ = ret;
	_tmp15__length1 = ret_length1;
	_tmp15__length2 = ret_length2;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp15__length2;
	}
	result = _tmp15_;
	return result;
}

static gint*
_vala_array_dup4 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

gint*
sudoku_board_get_possibilities (SudokuBoard* self,
                                gint row,
                                gint col,
                                gint* result_length1)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	gint* possibilities = NULL;
	gint* _tmp4_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gint count = 0;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	if (_tmp1_.value != 0) {
		gint* _tmp2_;
		gint* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (gint, 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_new0 (gint, 9);
	possibilities = _tmp4_;
	possibilities_length1 = 9;
	_possibilities_size_ = possibilities_length1;
	count = 0;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = l;
					l = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = sudoku_board_get_max_val (self);
				_tmp8_ = _tmp7_;
				if (!(l <= _tmp8_)) {
					break;
				}
				if (sudoku_board_is_possible (self, row, col, l)) {
					gint* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					_tmp9_ = possibilities;
					_tmp9__length1 = possibilities_length1;
					_tmp9_[count] = l;
					_tmp10_ = count;
					count = _tmp10_ + 1;
				}
			}
		}
	}
	_tmp11_ = possibilities;
	_tmp11__length1 = possibilities_length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup4 (_tmp11_ + 0, count - 0) : _tmp11_;
	_tmp12__length1 = count - 0;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	possibilities = (g_free (possibilities), NULL);
	return result;
}

gboolean*
sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                              gint row,
                                              gint col,
                                              gint* result_length1)
{
	gboolean* possibilities = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	possibilities = _tmp2_;
	possibilities_length1 = _tmp1_;
	_possibilities_size_ = possibilities_length1;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gboolean* _tmp7_;
				gint _tmp7__length1;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = l;
					l = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = sudoku_board_get_max_val (self);
				_tmp6_ = _tmp5_;
				if (!(l <= _tmp6_)) {
					break;
				}
				_tmp7_ = possibilities;
				_tmp7__length1 = possibilities_length1;
				_tmp7_[l - 1] = sudoku_board_is_possible (self, row, col, l);
			}
		}
	}
	_tmp8_ = possibilities;
	_tmp8__length1 = possibilities_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

void
sudoku_board_set (SudokuBoard* self,
                  gint row,
                  gint col,
                  gint val)
{
	gint old_val = 0;
	g_return_if_fail (self != NULL);
	old_val = sudoku_board_get (self, row, col);
	if (old_val == 0) {
		sudoku_board_disable_all_earmarks (self, row, col);
	}
	if (old_val == val) {
		return;
	}
	if (val == 0) {
		sudoku_board_remove (self, row, col);
	} else {
		sudoku_board_insert (self, row, col, val, FALSE);
	}
}

void
sudoku_board_set_all_fixed (SudokuBoard* self)
{
	g_return_if_fail (self != NULL);
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_rows;
				if (!(row < _tmp2_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							SudokuBoardCell* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							SudokuBoardCell _tmp7_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = col;
								col = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_cols;
							if (!(col < _tmp5_)) {
								break;
							}
							_tmp6_ = self->priv->cells;
							_tmp6__length1 = self->priv->cells_length1;
							_tmp6__length2 = self->priv->cells_length2;
							_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
							if (_tmp7_.value > 0) {
								SudokuBoardCell* _tmp8_;
								gint _tmp8__length1;
								gint _tmp8__length2;
								gint _tmp9_;
								_tmp8_ = self->priv->cells;
								_tmp8__length1 = self->priv->cells_length1;
								_tmp8__length2 = self->priv->cells_length2;
								_tmp8_[(row * _tmp8__length2) + col].fixed = TRUE;
								_tmp9_ = self->priv->_fixed;
								sudoku_board_set_fixed (self, _tmp9_ + 1);
							}
						}
					}
				}
			}
		}
	}
}

void
sudoku_board_enable_earmark (SudokuBoard* self,
                             gint row,
                             gint col,
                             gint num)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	SudokuBoardCell* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	SudokuBoardCell _tmp3_;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	SudokuBoardCell* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	SudokuBoardCell _tmp7_;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	_vala_return_if_fail (_tmp1_.value == 0, "cells[row, col].value == 0");
	_tmp2_ = self->priv->cells;
	_tmp2__length1 = self->priv->cells_length1;
	_tmp2__length2 = self->priv->cells_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_tmp4_ = _tmp3_.earmarks;
	_tmp4__length1 = _tmp3_.earmarks_length1;
	_tmp5_ = _tmp4_[num - 1];
	_vala_return_if_fail (!_tmp5_, "!cells[row, col].earmarks[num - 1]");
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
	_tmp8_ = _tmp7_.earmarks;
	_tmp8__length1 = _tmp7_.earmarks_length1;
	_tmp8_[num - 1] = TRUE;
	_tmp9_ = self->priv->n_earmarks;
	self->priv->n_earmarks = _tmp9_ + 1;
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL], 0, row, col, num, TRUE);
}

void
sudoku_board_disable_earmark (SudokuBoard* self,
                              gint row,
                              gint col,
                              gint num)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	SudokuBoardCell* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	SudokuBoardCell _tmp3_;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	SudokuBoardCell* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	SudokuBoardCell _tmp7_;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	_vala_return_if_fail (_tmp1_.value == 0, "cells[row, col].value == 0");
	_tmp2_ = self->priv->cells;
	_tmp2__length1 = self->priv->cells_length1;
	_tmp2__length2 = self->priv->cells_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_tmp4_ = _tmp3_.earmarks;
	_tmp4__length1 = _tmp3_.earmarks_length1;
	_tmp5_ = _tmp4_[num - 1];
	_vala_return_if_fail (_tmp5_, "cells[row, col].earmarks[num - 1]");
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
	_tmp8_ = _tmp7_.earmarks;
	_tmp8__length1 = _tmp7_.earmarks_length1;
	_tmp8_[num - 1] = FALSE;
	_tmp9_ = self->priv->n_earmarks;
	self->priv->n_earmarks = _tmp9_ - 1;
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL], 0, row, col, num, FALSE);
}

void
sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                   gint row,
                                   gint col)
{
	g_return_if_fail (self != NULL);
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				SudokuBoardCell* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				SudokuBoardCell _tmp5_;
				gboolean* _tmp6_;
				gint _tmp6__length1;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = num;
					num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = sudoku_board_get_max_val (self);
				_tmp3_ = _tmp2_;
				if (!(num <= _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->cells;
				_tmp4__length1 = self->priv->cells_length1;
				_tmp4__length2 = self->priv->cells_length2;
				_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
				_tmp6_ = _tmp5_.earmarks;
				_tmp6__length1 = _tmp5_.earmarks_length1;
				_tmp7_ = _tmp6_[num - 1];
				if (_tmp7_) {
					sudoku_board_disable_earmark (self, row, col, num);
				}
			}
		}
	}
}

gboolean
sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                 gint row,
                                 gint col,
                                 gint num)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	_tmp2_ = _tmp1_.earmarks;
	_tmp2__length1 = _tmp1_.earmarks_length1;
	_tmp3_ = _tmp2_[num - 1];
	result = _tmp3_;
	return result;
}

gboolean
sudoku_board_is_possible (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val)
{
	SudokuBoardDigitOccurences digit = {0};
	SudokuBoardDigitOccurences* _tmp0_;
	gint _tmp0__length1;
	SudokuBoardDigitOccurences _tmp1_;
	SudokuBoardDigitOccurences _tmp2_;
	SudokuBoardDigitOccurences _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	SudokuBoardDigitOccurences _tmp6_;
	gint* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->digits;
	_tmp0__length1 = self->priv->digits_length1;
	_tmp1_ = _tmp0_[val - 1];
	_tmp2_ = _tmp1_;
	sudoku_board_digit_occurences_copy (&_tmp2_, &_tmp3_);
	digit = _tmp3_;
	_tmp6_ = digit;
	_tmp7_ = _tmp6_.occurrences_in_row;
	_tmp7__length1 = _tmp6_.occurrences_in_row_length1;
	_tmp8_ = _tmp7_[row];
	if (_tmp8_ == 0) {
		SudokuBoardDigitOccurences _tmp9_;
		gint* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		_tmp9_ = digit;
		_tmp10_ = _tmp9_.occurrences_in_col;
		_tmp10__length1 = _tmp9_.occurrences_in_col_length1;
		_tmp11_ = _tmp10_[col];
		_tmp5_ = _tmp11_ == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		SudokuBoardDigitOccurences _tmp12_;
		gint* _tmp13_;
		gint _tmp13__length1;
		gint _tmp13__length2;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp12_ = digit;
		_tmp13_ = _tmp12_.occurrences_in_block;
		_tmp13__length1 = _tmp12_.occurrences_in_block_length1;
		_tmp13__length2 = _tmp12_.occurrences_in_block_length2;
		_tmp14_ = self->priv->_block_rows;
		_tmp15_ = self->priv->_block_cols;
		_tmp16_ = _tmp13_[((row / _tmp14_) * _tmp13__length2) + (col / _tmp15_)];
		_tmp4_ = _tmp16_ == 0;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	sudoku_board_digit_occurences_destroy (&digit);
	return result;
}

void
sudoku_board_insert (SudokuBoard* self,
                     gint row,
                     gint col,
                     gint val,
                     gboolean is_fixed)
{
	gint _tmp0_;
	gint _tmp1_;
	SudokuBoardCell* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	SudokuBoardCell _tmp3_;
	gint old_val = 0;
	SudokuBoardCell* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	SudokuBoardCell _tmp5_;
	SudokuBoardCell* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	SudokuBoardCell* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail ((val > 0) && (val <= _tmp1_), "val > 0 && val <= max_val");
	_tmp2_ = self->priv->cells;
	_tmp2__length1 = self->priv->cells_length1;
	_tmp2__length2 = self->priv->cells_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_vala_return_if_fail (!_tmp3_.fixed, "!cells[row, col].fixed");
	_tmp4_ = self->priv->cells;
	_tmp4__length1 = self->priv->cells_length1;
	_tmp4__length2 = self->priv->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	old_val = _tmp5_.value;
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col].value = val;
	_tmp7_ = self->priv->cells;
	_tmp7__length1 = self->priv->cells_length1;
	_tmp7__length2 = self->priv->cells_length2;
	_tmp7_[(row * _tmp7__length2) + col].fixed = is_fixed;
	if (is_fixed) {
		gint _tmp8_;
		_tmp8_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp8_ + 1);
	}
	if (old_val != 0) {
		sudoku_board_update_old_breakages (self, row, col, old_val);
	} else {
		gint _tmp9_;
		_tmp9_ = self->priv->_filled;
		sudoku_board_set_filled (self, _tmp9_ + 1);
	}
	sudoku_board_add_to_occurrences (self, row, col, val, 1);
	sudoku_board_mark_breakages (self, row, col, val);
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_VALUE_CHANGED_SIGNAL], 0, row, col, old_val, val);
	_tmp10_ = sudoku_board_get_complete (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL], 0);
	}
}

void
sudoku_board_remove (SudokuBoard* self,
                     gint row,
                     gint col)
{
	SudokuBoardCell* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuBoardCell _tmp1_;
	SudokuBoardCell* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	SudokuBoardCell _tmp3_;
	gint old_val = 0;
	SudokuBoardCell* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	SudokuBoardCell _tmp5_;
	SudokuBoardCell* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	_vala_return_if_fail (_tmp1_.value > 0, "cells[row, col].value > 0");
	_tmp2_ = self->priv->cells;
	_tmp2__length1 = self->priv->cells_length1;
	_tmp2__length2 = self->priv->cells_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_vala_return_if_fail (!_tmp3_.fixed, "!cells[row, col].fixed");
	_tmp4_ = self->priv->cells;
	_tmp4__length1 = self->priv->cells_length1;
	_tmp4__length2 = self->priv->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	old_val = _tmp5_.value;
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col].value = 0;
	_tmp7_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp7_ - 1);
	sudoku_board_update_old_breakages (self, row, col, old_val);
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_VALUE_CHANGED_SIGNAL], 0, row, col, old_val, 0);
}

static void
sudoku_board_update_old_breakages (SudokuBoard* self,
                                   gint row,
                                   gint col,
                                   gint val)
{
	GeeSet* _tmp0_;
	Coord _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	sudoku_board_add_to_occurrences (self, row, col, val, -1);
	_tmp0_ = self->priv->_broken_coords;
	coord_init (&_tmp1_, row, col);
	if (gee_collection_contains ((GeeCollection*) _tmp0_, &_tmp1_)) {
		GeeSet* _tmp2_;
		Coord _tmp3_ = {0};
		GeeList* _tmp4_;
		gpointer _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gpointer _tmp8_;
		GeeList* _tmp9_;
		GeeMap* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		Coord _tmp13_ = {0};
		gpointer _tmp14_;
		GeeList* _tmp15_;
		_tmp2_ = self->priv->_broken_coords;
		coord_init (&_tmp3_, row, col);
		gee_collection_remove ((GeeCollection*) _tmp2_, &_tmp3_);
		_tmp4_ = self->priv->_coords_for_row;
		_tmp5_ = gee_list_get (_tmp4_, row);
		_tmp6_ = (GeeList*) _tmp5_;
		sudoku_board_remove_breakages_for (self, _tmp6_, val);
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->_coords_for_col;
		_tmp8_ = gee_list_get (_tmp7_, col);
		_tmp9_ = (GeeList*) _tmp8_;
		sudoku_board_remove_breakages_for (self, _tmp9_, val);
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->priv->_coords_for_block;
		_tmp11_ = self->priv->_block_rows;
		_tmp12_ = self->priv->_block_cols;
		coord_init (&_tmp13_, row / _tmp11_, col / _tmp12_);
		_tmp14_ = gee_map_get (_tmp10_, &_tmp13_);
		_tmp15_ = (GeeList*) _tmp14_;
		sudoku_board_remove_breakages_for (self, _tmp15_, val);
		_g_object_unref0 (_tmp15_);
	}
}

static void
sudoku_board_add_to_occurrences (SudokuBoard* self,
                                 gint row,
                                 gint col,
                                 gint val,
                                 gint add)
{
	SudokuBoardDigitOccurences* _tmp0_;
	gint _tmp0__length1;
	SudokuBoardDigitOccurences _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	SudokuBoardDigitOccurences* _tmp3_;
	gint _tmp3__length1;
	SudokuBoardDigitOccurences _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	SudokuBoardDigitOccurences* _tmp6_;
	gint _tmp6__length1;
	SudokuBoardDigitOccurences _tmp7_;
	gint* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->digits;
	_tmp0__length1 = self->priv->digits_length1;
	_tmp1_ = _tmp0_[val - 1];
	_tmp2_ = _tmp1_.occurrences_in_row;
	_tmp2__length1 = _tmp1_.occurrences_in_row_length1;
	_tmp2_[row] += add;
	_tmp3_ = self->priv->digits;
	_tmp3__length1 = self->priv->digits_length1;
	_tmp4_ = _tmp3_[val - 1];
	_tmp5_ = _tmp4_.occurrences_in_col;
	_tmp5__length1 = _tmp4_.occurrences_in_col_length1;
	_tmp5_[col] += add;
	_tmp6_ = self->priv->digits;
	_tmp6__length1 = self->priv->digits_length1;
	_tmp7_ = _tmp6_[val - 1];
	_tmp8_ = _tmp7_.occurrences_in_block;
	_tmp8__length1 = _tmp7_.occurrences_in_block_length1;
	_tmp8__length2 = _tmp7_.occurrences_in_block_length2;
	_tmp9_ = self->priv->_block_rows;
	_tmp10_ = self->priv->_block_cols;
	_tmp8_[((row / _tmp9_) * _tmp8__length2) + (col / _tmp10_)] += add;
}

static void
sudoku_board_mark_breakages (SudokuBoard* self,
                             gint row,
                             gint col,
                             gint val)
{
	SudokuBoardDigitOccurences digit = {0};
	SudokuBoardDigitOccurences* _tmp0_;
	gint _tmp0__length1;
	SudokuBoardDigitOccurences _tmp1_;
	SudokuBoardDigitOccurences _tmp2_;
	SudokuBoardDigitOccurences _tmp3_ = {0};
	SudokuBoardDigitOccurences _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	SudokuBoardDigitOccurences _tmp10_;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	SudokuBoardDigitOccurences _tmp16_;
	gint* _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->digits;
	_tmp0__length1 = self->priv->digits_length1;
	_tmp1_ = _tmp0_[val - 1];
	_tmp2_ = _tmp1_;
	sudoku_board_digit_occurences_copy (&_tmp2_, &_tmp3_);
	digit = _tmp3_;
	_tmp4_ = digit;
	_tmp5_ = _tmp4_.occurrences_in_row;
	_tmp5__length1 = _tmp4_.occurrences_in_row_length1;
	_tmp6_ = _tmp5_[row];
	if (_tmp6_ > 1) {
		GeeList* _tmp7_;
		gpointer _tmp8_;
		GeeList* _tmp9_;
		_tmp7_ = self->priv->_coords_for_row;
		_tmp8_ = gee_list_get (_tmp7_, row);
		_tmp9_ = (GeeList*) _tmp8_;
		sudoku_board_mark_breakages_for (self, _tmp9_, val);
		_g_object_unref0 (_tmp9_);
	}
	_tmp10_ = digit;
	_tmp11_ = _tmp10_.occurrences_in_col;
	_tmp11__length1 = _tmp10_.occurrences_in_col_length1;
	_tmp12_ = _tmp11_[col];
	if (_tmp12_ > 1) {
		GeeList* _tmp13_;
		gpointer _tmp14_;
		GeeList* _tmp15_;
		_tmp13_ = self->priv->_coords_for_col;
		_tmp14_ = gee_list_get (_tmp13_, col);
		_tmp15_ = (GeeList*) _tmp14_;
		sudoku_board_mark_breakages_for (self, _tmp15_, val);
		_g_object_unref0 (_tmp15_);
	}
	_tmp16_ = digit;
	_tmp17_ = _tmp16_.occurrences_in_block;
	_tmp17__length1 = _tmp16_.occurrences_in_block_length1;
	_tmp17__length2 = _tmp16_.occurrences_in_block_length2;
	_tmp18_ = self->priv->_block_rows;
	_tmp19_ = self->priv->_block_cols;
	_tmp20_ = _tmp17_[((row / _tmp18_) * _tmp17__length2) + (col / _tmp19_)];
	if (_tmp20_ > 1) {
		GeeMap* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		Coord _tmp24_ = {0};
		gpointer _tmp25_;
		GeeList* _tmp26_;
		_tmp21_ = self->priv->_coords_for_block;
		_tmp22_ = self->priv->_block_rows;
		_tmp23_ = self->priv->_block_cols;
		coord_init (&_tmp24_, row / _tmp22_, col / _tmp23_);
		_tmp25_ = gee_map_get (_tmp21_, &_tmp24_);
		_tmp26_ = (GeeList*) _tmp25_;
		sudoku_board_mark_breakages_for (self, _tmp26_, val);
		_g_object_unref0 (_tmp26_);
	}
	sudoku_board_digit_occurences_destroy (&digit);
}

void
sudoku_board_solve (SudokuBoard* self)
{
	gint* fixed_cells = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint fixed_cells_length1;
	gint fixed_cells_length2;
	gint* solution_1d = NULL;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint _tmp4_ = 0;
	gint* _tmp5_;
	gint solution_1d_length1;
	gint _solution_1d_size_;
	gint* _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	_tmp2_ = sudoku_board_get_fixed_cells (self, &_tmp0_, &_tmp1_);
	fixed_cells = _tmp2_;
	fixed_cells_length1 = _tmp0_;
	fixed_cells_length2 = _tmp1_;
	_tmp3_ = fixed_cells;
	_tmp3__length1 = fixed_cells_length1;
	_tmp3__length2 = fixed_cells_length2;
	_tmp5_ = sudoku_board_convert_2d_to_1d (self, _tmp3_, (gint) _tmp3__length1, (gint) _tmp3__length2, &_tmp4_);
	solution_1d = _tmp5_;
	solution_1d_length1 = _tmp4_;
	_solution_1d_size_ = solution_1d_length1;
	_tmp6_ = solution_1d;
	_tmp6__length1 = solution_1d_length1;
	if (qqwing_solve_puzzle (_tmp6_)) {
		gint i = 0;
		self->priv->has_solution = TRUE;
		i = 0;
		{
			gint row = 0;
			row = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					gint _tmp9_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = row;
						row = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = self->priv->_rows;
					if (!(row < _tmp9_)) {
						break;
					}
					{
						gint col = 0;
						col = 0;
						{
							gboolean _tmp10_ = FALSE;
							_tmp10_ = TRUE;
							while (TRUE) {
								gint _tmp12_;
								SudokuBoardCell* _tmp13_;
								gint _tmp13__length1;
								gint _tmp13__length2;
								gint* _tmp14_;
								gint _tmp14__length1;
								gint _tmp15_;
								gint _tmp16_;
								if (!_tmp10_) {
									gint _tmp11_;
									_tmp11_ = col;
									col = _tmp11_ + 1;
								}
								_tmp10_ = FALSE;
								_tmp12_ = self->priv->_cols;
								if (!(col < _tmp12_)) {
									break;
								}
								_tmp13_ = self->priv->cells;
								_tmp13__length1 = self->priv->cells_length1;
								_tmp13__length2 = self->priv->cells_length2;
								_tmp14_ = solution_1d;
								_tmp14__length1 = solution_1d_length1;
								_tmp15_ = _tmp14_[i];
								_tmp13_[(row * _tmp13__length2) + col].solution = _tmp15_;
								_tmp16_ = i;
								i = _tmp16_ + 1;
							}
						}
					}
				}
			}
		}
	} else {
		self->priv->has_solution = FALSE;
	}
	solution_1d = (g_free (solution_1d), NULL);
	fixed_cells = (g_free (fixed_cells), NULL);
}

gboolean
sudoku_board_solved (SudokuBoard* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->has_solution;
	return result;
}

gint
sudoku_board_count_solutions_limited (SudokuBoard* self)
{
	gint* cells_1d = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint _tmp4_ = 0;
	gint* _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint cells_1d_length1;
	gint _cells_1d_size_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp2_ = sudoku_board_get_cells (self, &_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp0_;
	_tmp3__length2 = _tmp1_;
	_tmp5_ = sudoku_board_convert_2d_to_1d (self, _tmp3_, (gint) _tmp0_, (gint) _tmp1_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	cells_1d = _tmp6_;
	cells_1d_length1 = _tmp6__length1;
	_cells_1d_size_ = cells_1d_length1;
	result = qqwing_count_solutions_limited (cells_1d);
	cells_1d = (g_free (cells_1d), NULL);
	return result;
}

static void
sudoku_board_remove_breakages_for (SudokuBoard* self,
                                   GeeList* coords,
                                   gint val)
{
	SudokuBoardDigitOccurences digit = {0};
	SudokuBoardDigitOccurences* _tmp0_;
	gint _tmp0__length1;
	SudokuBoardDigitOccurences _tmp1_;
	SudokuBoardDigitOccurences _tmp2_;
	SudokuBoardDigitOccurences _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	_tmp0_ = self->priv->digits;
	_tmp0__length1 = self->priv->digits_length1;
	_tmp1_ = _tmp0_[val - 1];
	_tmp2_ = _tmp1_;
	sudoku_board_digit_occurences_copy (&_tmp2_, &_tmp3_);
	digit = _tmp3_;
	{
		GeeList* _coord_list = NULL;
		gint _coord_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _coord_index = 0;
		_coord_list = coords;
		_tmp4_ = _coord_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_coord_size = _tmp6_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Coord coord = {0};
			GeeList* _tmp9_;
			gpointer _tmp10_;
			Coord* _tmp11_;
			Coord _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			SudokuBoardCell* _tmp17_;
			gint _tmp17__length1;
			gint _tmp17__length2;
			Coord _tmp18_;
			Coord _tmp19_;
			SudokuBoardCell _tmp20_;
			_coord_index = _coord_index + 1;
			_tmp7_ = _coord_index;
			_tmp8_ = _coord_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _coord_list;
			_tmp10_ = gee_list_get (_tmp9_, _coord_index);
			_tmp11_ = (Coord*) _tmp10_;
			_tmp12_ = *_tmp11_;
			_coord_free0 (_tmp11_);
			coord = _tmp12_;
			_tmp17_ = self->priv->cells;
			_tmp17__length1 = self->priv->cells_length1;
			_tmp17__length2 = self->priv->cells_length2;
			_tmp18_ = coord;
			_tmp19_ = coord;
			_tmp20_ = _tmp17_[(_tmp18_.row * _tmp17__length2) + _tmp19_.col];
			if (_tmp20_.value == val) {
				GeeSet* _tmp21_;
				Coord _tmp22_;
				_tmp21_ = self->priv->_broken_coords;
				_tmp22_ = coord;
				_tmp16_ = gee_collection_contains ((GeeCollection*) _tmp21_, &_tmp22_);
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				SudokuBoardDigitOccurences _tmp23_;
				gint* _tmp24_;
				gint _tmp24__length1;
				Coord _tmp25_;
				gint _tmp26_;
				_tmp23_ = digit;
				_tmp24_ = _tmp23_.occurrences_in_row;
				_tmp24__length1 = _tmp23_.occurrences_in_row_length1;
				_tmp25_ = coord;
				_tmp26_ = _tmp24_[_tmp25_.row];
				_tmp15_ = _tmp26_ <= 1;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				SudokuBoardDigitOccurences _tmp27_;
				gint* _tmp28_;
				gint _tmp28__length1;
				Coord _tmp29_;
				gint _tmp30_;
				_tmp27_ = digit;
				_tmp28_ = _tmp27_.occurrences_in_col;
				_tmp28__length1 = _tmp27_.occurrences_in_col_length1;
				_tmp29_ = coord;
				_tmp30_ = _tmp28_[_tmp29_.col];
				_tmp14_ = _tmp30_ <= 1;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				SudokuBoardDigitOccurences _tmp31_;
				gint* _tmp32_;
				gint _tmp32__length1;
				gint _tmp32__length2;
				Coord _tmp33_;
				gint _tmp34_;
				Coord _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp31_ = digit;
				_tmp32_ = _tmp31_.occurrences_in_block;
				_tmp32__length1 = _tmp31_.occurrences_in_block_length1;
				_tmp32__length2 = _tmp31_.occurrences_in_block_length2;
				_tmp33_ = coord;
				_tmp34_ = self->priv->_block_cols;
				_tmp35_ = coord;
				_tmp36_ = self->priv->_block_rows;
				_tmp37_ = _tmp32_[((_tmp33_.row / _tmp34_) * _tmp32__length2) + (_tmp35_.col / _tmp36_)];
				_tmp13_ = _tmp37_ <= 1;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeSet* _tmp38_;
				Coord _tmp39_;
				_tmp38_ = self->priv->_broken_coords;
				_tmp39_ = coord;
				gee_collection_remove ((GeeCollection*) _tmp38_, &_tmp39_);
			}
		}
	}
	sudoku_board_digit_occurences_destroy (&digit);
}

static void
sudoku_board_mark_breakages_for (SudokuBoard* self,
                                 GeeList* coords,
                                 gint val)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	{
		GeeList* _coord_list = NULL;
		gint _coord_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _coord_index = 0;
		_coord_list = coords;
		_tmp0_ = _coord_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_coord_size = _tmp2_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			Coord coord = {0};
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Coord* _tmp7_;
			Coord _tmp8_;
			SudokuBoardCell* _tmp9_;
			gint _tmp9__length1;
			gint _tmp9__length2;
			Coord _tmp10_;
			Coord _tmp11_;
			SudokuBoardCell _tmp12_;
			_coord_index = _coord_index + 1;
			_tmp3_ = _coord_index;
			_tmp4_ = _coord_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _coord_list;
			_tmp6_ = gee_list_get (_tmp5_, _coord_index);
			_tmp7_ = (Coord*) _tmp6_;
			_tmp8_ = *_tmp7_;
			_coord_free0 (_tmp7_);
			coord = _tmp8_;
			_tmp9_ = self->priv->cells;
			_tmp9__length1 = self->priv->cells_length1;
			_tmp9__length2 = self->priv->cells_length2;
			_tmp10_ = coord;
			_tmp11_ = coord;
			_tmp12_ = _tmp9_[(_tmp10_.row * _tmp9__length2) + _tmp11_.col];
			if (_tmp12_.value == val) {
				GeeSet* _tmp13_;
				Coord _tmp14_;
				_tmp13_ = self->priv->_broken_coords;
				_tmp14_ = coord;
				gee_collection_add ((GeeCollection*) _tmp13_, &_tmp14_);
			}
		}
	}
}

gchar*
sudoku_board_to_string (SudokuBoard* self)
{
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	board_string = _tmp0_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = row;
					row = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_rows;
				if (!(row < _tmp3_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							SudokuBoardCell* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							SudokuBoardCell _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = col;
								col = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_cols;
							if (!(col < _tmp6_)) {
								break;
							}
							_tmp7_ = self->priv->cells;
							_tmp7__length1 = self->priv->cells_length1;
							_tmp7__length2 = self->priv->cells_length2;
							_tmp8_ = _tmp7_[(row * _tmp7__length2) + col];
							if (_tmp8_.fixed) {
								const gchar* _tmp9_;
								SudokuBoardCell* _tmp10_;
								gint _tmp10__length1;
								gint _tmp10__length2;
								SudokuBoardCell _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								gchar* _tmp14_;
								_tmp9_ = board_string;
								_tmp10_ = self->priv->cells;
								_tmp10__length1 = self->priv->cells_length1;
								_tmp10__length2 = self->priv->cells_length2;
								_tmp11_ = _tmp10_[(row * _tmp10__length2) + col];
								_tmp12_ = g_strdup_printf ("%i", _tmp11_.value);
								_tmp13_ = _tmp12_;
								_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
								_g_free0 (board_string);
								board_string = _tmp14_;
								_g_free0 (_tmp13_);
							} else {
								const gchar* _tmp15_;
								gchar* _tmp16_;
								_tmp15_ = board_string;
								_tmp16_ = g_strconcat (_tmp15_, "0", NULL);
								_g_free0 (board_string);
								board_string = _tmp16_;
							}
						}
					}
				}
			}
		}
	}
	result = board_string;
	return result;
}

gboolean
sudoku_board_is_finished (SudokuBoard* self)
{
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_board_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	board_string = _tmp3_;
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
	finishgame_file = _tmp6_;
	_tmp7_ = g_file_new_for_path (finishgame_file);
	file = _tmp7_;
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	_g_free0 (finishgame_file);
	_g_free0 (board_string);
	return result;
}

gboolean
sudoku_board_has_earmarks (SudokuBoard* self,
                           gint row,
                           gint col)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuBoardCell* _tmp2_;
				gint _tmp2__length1;
				gint _tmp2__length2;
				SudokuBoardCell _tmp3_;
				gboolean* _tmp4_;
				gint _tmp4__length1;
				gboolean _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 9)) {
					break;
				}
				_tmp2_ = self->priv->cells;
				_tmp2__length1 = self->priv->cells_length1;
				_tmp2__length2 = self->priv->cells_length2;
				_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
				_tmp4_ = _tmp3_.earmarks;
				_tmp4__length1 = _tmp3_.earmarks_length1;
				_tmp5_ = _tmp4_[i];
				if (_tmp5_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static gint*
sudoku_board_convert_2d_to_1d (SudokuBoard* self,
                               gint* ints_2d,
                               gint ints_2d_length1,
                               gint ints_2d_length2,
                               gint* result_length1)
{
	gint* ints_1d = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ints_1d_length1;
	gint _ints_1d_size_;
	gint i = 0;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ints_1d = _tmp2_;
	ints_1d_length1 = _tmp0_ * _tmp1_;
	_ints_1d_size_ = ints_1d_length1;
	i = 0;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							gint _tmp11_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = ints_1d;
							_tmp9__length1 = ints_1d_length1;
							_tmp10_ = i;
							i = _tmp10_ + 1;
							_tmp11_ = ints_2d[(row * ints_2d_length2) + col];
							_tmp9_[_tmp10_] = _tmp11_;
						}
					}
				}
			}
		}
	}
	_tmp12_ = ints_1d;
	_tmp12__length1 = ints_1d_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}

gdouble
sudoku_board_get_previous_played_time (SudokuBoard* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_previous_played_time;
	return result;
}

void
sudoku_board_set_previous_played_time (SudokuBoard* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_previous_played_time (self);
	if (old_value != value) {
		self->priv->_previous_played_time = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY]);
	}
}

DifficultyCategory
sudoku_board_get_difficulty_category (SudokuBoard* self)
{
	DifficultyCategory result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_difficulty_category;
	return result;
}

void
sudoku_board_set_difficulty_category (SudokuBoard* self,
                                      DifficultyCategory value)
{
	DifficultyCategory old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_difficulty_category (self);
	if (old_value != value) {
		self->priv->_difficulty_category = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY]);
	}
}

gint
sudoku_board_get_block_rows (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_rows;
	return result;
}

static void
sudoku_board_set_block_rows (SudokuBoard* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_block_rows (self);
	if (old_value != value) {
		self->priv->_block_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY]);
	}
}

gint
sudoku_board_get_block_cols (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_cols;
	return result;
}

static void
sudoku_board_set_block_cols (SudokuBoard* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_block_cols (self);
	if (old_value != value) {
		self->priv->_block_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY]);
	}
}

gint
sudoku_board_get_rows (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rows;
	return result;
}

static void
sudoku_board_set_rows (SudokuBoard* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_rows (self);
	if (old_value != value) {
		self->priv->_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY]);
	}
}

gint
sudoku_board_get_cols (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cols;
	return result;
}

static void
sudoku_board_set_cols (SudokuBoard* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_cols (self);
	if (old_value != value) {
		self->priv->_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY]);
	}
}

gint
sudoku_board_get_max_val (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}

gint
sudoku_board_get_filled (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_filled;
	return result;
}

static void
sudoku_board_set_filled (SudokuBoard* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_filled (self);
	if (old_value != value) {
		self->priv->_filled = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY]);
	}
}

gint
sudoku_board_get_fixed (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_fixed;
	return result;
}

static void
sudoku_board_set_fixed (SudokuBoard* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_fixed (self);
	if (old_value != value) {
		self->priv->_fixed = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY]);
	}
}

gboolean
sudoku_board_get_complete (SudokuBoard* self)
{
	gboolean result;
	gboolean broken = FALSE;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_broken_coords;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	broken = _tmp2_ != 0;
	_tmp4_ = self->priv->_filled;
	_tmp5_ = self->priv->_cols;
	_tmp6_ = self->priv->_rows;
	if (_tmp4_ == (_tmp5_ * _tmp6_)) {
		_tmp3_ = !broken;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

GeeSet*
sudoku_board_get_broken_coords (SudokuBoard* self)
{
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_broken_coords;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sudoku_board_set_broken_coords (SudokuBoard* self,
                                GeeSet* value)
{
	GeeSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_broken_coords (self);
	if (old_value != value) {
		GeeSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_broken_coords);
		self->priv->_broken_coords = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BROKEN_COORDS_PROPERTY]);
	}
}

GeeList*
sudoku_board_get_coords_for_col (SudokuBoard* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coords_for_col;
	result = _tmp0_;
	return result;
}

static void
sudoku_board_set_coords_for_col (SudokuBoard* self,
                                 GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_coords_for_col (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_coords_for_col);
		self->priv->_coords_for_col = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY]);
	}
}

GeeList*
sudoku_board_get_coords_for_row (SudokuBoard* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coords_for_row;
	result = _tmp0_;
	return result;
}

static void
sudoku_board_set_coords_for_row (SudokuBoard* self,
                                 GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_coords_for_row (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_coords_for_row);
		self->priv->_coords_for_row = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY]);
	}
}

GeeMap*
sudoku_board_get_coords_for_block (SudokuBoard* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coords_for_block;
	result = _tmp0_;
	return result;
}

static void
sudoku_board_set_coords_for_block (SudokuBoard* self,
                                   GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_coords_for_block (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_coords_for_block);
		self->priv->_coords_for_block = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_BOOLEAN) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static gboolean*
_vala_array_dup5 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static void
sudoku_board_cell_copy (const SudokuBoardCell* self,
                        SudokuBoardCell* dest)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	(*dest).value = (*self).value;
	(*dest).solution = (*self).solution;
	_tmp0_ = (*self).earmarks;
	_tmp0__length1 = (*self).earmarks_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).earmarks = (g_free ((*dest).earmarks), NULL);
	(*dest).earmarks = _tmp1_;
	(*dest).earmarks_length1 = _tmp1__length1;
	(*dest)._earmarks_size_ = (*dest).earmarks_length1;
	(*dest).fixed = (*self).fixed;
}

static void
sudoku_board_cell_destroy (SudokuBoardCell* self)
{
	(*self).earmarks = (g_free ((*self).earmarks), NULL);
}

static SudokuBoardCell*
sudoku_board_cell_dup (const SudokuBoardCell* self)
{
	SudokuBoardCell* dup;
	dup = g_new0 (SudokuBoardCell, 1);
	sudoku_board_cell_copy (self, dup);
	return dup;
}

static void
sudoku_board_cell_free (SudokuBoardCell* self)
{
	sudoku_board_cell_destroy (self);
	g_free (self);
}

static GType
sudoku_board_cell_get_type_once (void)
{
	GType sudoku_board_cell_type_id;
	sudoku_board_cell_type_id = g_boxed_type_register_static ("SudokuBoardCell", (GBoxedCopyFunc) sudoku_board_cell_dup, (GBoxedFreeFunc) sudoku_board_cell_free);
	return sudoku_board_cell_type_id;
}

static GType
sudoku_board_cell_get_type (void)
{
	static volatile gsize sudoku_board_cell_type_id__once = 0;
	if (g_once_init_enter (&sudoku_board_cell_type_id__once)) {
		GType sudoku_board_cell_type_id;
		sudoku_board_cell_type_id = sudoku_board_cell_get_type_once ();
		g_once_init_leave (&sudoku_board_cell_type_id__once, sudoku_board_cell_type_id);
	}
	return sudoku_board_cell_type_id__once;
}

static gint*
_vala_array_dup6 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup7 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup8 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static void
sudoku_board_digit_occurences_copy (const SudokuBoardDigitOccurences* self,
                                    SudokuBoardDigitOccurences* dest)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	_tmp0_ = (*self).occurrences_in_row;
	_tmp0__length1 = (*self).occurrences_in_row_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).occurrences_in_row = (g_free ((*dest).occurrences_in_row), NULL);
	(*dest).occurrences_in_row = _tmp1_;
	(*dest).occurrences_in_row_length1 = _tmp1__length1;
	(*dest)._occurrences_in_row_size_ = (*dest).occurrences_in_row_length1;
	_tmp2_ = (*self).occurrences_in_col;
	_tmp2__length1 = (*self).occurrences_in_col_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup7 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).occurrences_in_col = (g_free ((*dest).occurrences_in_col), NULL);
	(*dest).occurrences_in_col = _tmp3_;
	(*dest).occurrences_in_col_length1 = _tmp3__length1;
	(*dest)._occurrences_in_col_size_ = (*dest).occurrences_in_col_length1;
	_tmp4_ = (*self).occurrences_in_block;
	_tmp4__length1 = (*self).occurrences_in_block_length1;
	_tmp4__length2 = (*self).occurrences_in_block_length2;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup8 (_tmp4_, _tmp4__length1 * _tmp4__length2) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp5__length2 = _tmp4__length2;
	(*dest).occurrences_in_block = (g_free ((*dest).occurrences_in_block), NULL);
	(*dest).occurrences_in_block = _tmp5_;
	(*dest).occurrences_in_block_length1 = _tmp5__length1;
	(*dest).occurrences_in_block_length2 = _tmp5__length2;
}

static void
sudoku_board_digit_occurences_destroy (SudokuBoardDigitOccurences* self)
{
	(*self).occurrences_in_row = (g_free ((*self).occurrences_in_row), NULL);
	(*self).occurrences_in_col = (g_free ((*self).occurrences_in_col), NULL);
	(*self).occurrences_in_block = (g_free ((*self).occurrences_in_block), NULL);
}

static SudokuBoardDigitOccurences*
sudoku_board_digit_occurences_dup (const SudokuBoardDigitOccurences* self)
{
	SudokuBoardDigitOccurences* dup;
	dup = g_new0 (SudokuBoardDigitOccurences, 1);
	sudoku_board_digit_occurences_copy (self, dup);
	return dup;
}

static void
sudoku_board_digit_occurences_free (SudokuBoardDigitOccurences* self)
{
	sudoku_board_digit_occurences_destroy (self);
	g_free (self);
}

static GType
sudoku_board_digit_occurences_get_type_once (void)
{
	GType sudoku_board_digit_occurences_type_id;
	sudoku_board_digit_occurences_type_id = g_boxed_type_register_static ("SudokuBoardDigitOccurences", (GBoxedCopyFunc) sudoku_board_digit_occurences_dup, (GBoxedFreeFunc) sudoku_board_digit_occurences_free);
	return sudoku_board_digit_occurences_type_id;
}

static GType
sudoku_board_digit_occurences_get_type (void)
{
	static volatile gsize sudoku_board_digit_occurences_type_id__once = 0;
	if (g_once_init_enter (&sudoku_board_digit_occurences_type_id__once)) {
		GType sudoku_board_digit_occurences_type_id;
		sudoku_board_digit_occurences_type_id = sudoku_board_digit_occurences_get_type_once ();
		g_once_init_leave (&sudoku_board_digit_occurences_type_id__once, sudoku_board_digit_occurences_type_id);
	}
	return sudoku_board_digit_occurences_type_id__once;
}

static void
sudoku_board_class_init (SudokuBoardClass * klass,
                         gpointer klass_data)
{
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuBoard_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY] = g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY] = g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY] = g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY] = g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 9, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY] = g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 9, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_MAX_VAL_PROPERTY] = g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY] = g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY] = g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COMPLETE_PROPERTY] = g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN_COORDS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BROKEN_COORDS_PROPERTY] = g_param_spec_object ("broken-coords", "broken-coords", "broken-coords", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY] = g_param_spec_object ("coords-for-col", "coords-for-col", "coords-for-col", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY] = g_param_spec_object ("coords-for-row", "coords-for-row", "coords-for-row", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY] = g_param_spec_object ("coords-for-block", "coords-for-block", "coords-for-block", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL] = g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sudoku_board_signals[SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL] = g_signal_new ("earmark-changed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_BOOLEAN, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_BOOLEAN);
	sudoku_board_signals[SUDOKU_BOARD_VALUE_CHANGED_SIGNAL] = g_signal_new ("value-changed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
}

static void
sudoku_board_instance_init (SudokuBoard * self,
                            gpointer klass)
{
	self->priv = sudoku_board_get_instance_private (self);
	self->priv->has_solution = FALSE;
	self->priv->_previous_played_time = (gdouble) 0;
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
	self->priv->_block_rows = 3;
	self->priv->_block_cols = 3;
	self->priv->_rows = 9;
	self->priv->_cols = 9;
}

static void
sudoku_board_finalize (GObject * obj)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
	self->priv->cells = (_vala_SudokuBoardCell_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2), NULL);
	self->priv->digits = (_vala_SudokuBoardDigitOccurences_array_free (self->priv->digits, self->priv->digits_length1), NULL);
	_g_object_unref0 (self->priv->_broken_coords);
	_g_object_unref0 (self->priv->_coords_for_col);
	_g_object_unref0 (self->priv->_coords_for_row);
	_g_object_unref0 (self->priv->_coords_for_block);
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
}

static GType
sudoku_board_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
	GType sudoku_board_type_id;
	sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
	SudokuBoard_private_offset = g_type_add_instance_private (sudoku_board_type_id, sizeof (SudokuBoardPrivate));
	return sudoku_board_type_id;
}

GType
sudoku_board_get_type (void)
{
	static volatile gsize sudoku_board_type_id__once = 0;
	if (g_once_init_enter (&sudoku_board_type_id__once)) {
		GType sudoku_board_type_id;
		sudoku_board_type_id = sudoku_board_get_type_once ();
		g_once_init_leave (&sudoku_board_type_id__once, sudoku_board_type_id);
	}
	return sudoku_board_type_id__once;
}

static void
_vala_sudoku_board_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_rows (self));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_cols (self));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_rows (self));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_cols (self));
		break;
		case SUDOKU_BOARD_MAX_VAL_PROPERTY:
		g_value_set_int (value, sudoku_board_get_max_val (self));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_filled (self));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_fixed (self));
		break;
		case SUDOKU_BOARD_COMPLETE_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_complete (self));
		break;
		case SUDOKU_BOARD_BROKEN_COORDS_PROPERTY:
		g_value_set_object (value, sudoku_board_get_broken_coords (self));
		break;
		case SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY:
		g_value_set_object (value, sudoku_board_get_coords_for_col (self));
		break;
		case SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY:
		g_value_set_object (value, sudoku_board_get_coords_for_row (self));
		break;
		case SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY:
		g_value_set_object (value, sudoku_board_get_coords_for_block (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_board_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		sudoku_board_set_block_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		sudoku_board_set_block_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		sudoku_board_set_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		sudoku_board_set_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		sudoku_board_set_filled (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		sudoku_board_set_fixed (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BROKEN_COORDS_PROPERTY:
		sudoku_board_set_broken_coords (self, g_value_get_object (value));
		break;
		case SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY:
		sudoku_board_set_coords_for_col (self, g_value_get_object (value));
		break;
		case SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY:
		sudoku_board_set_coords_for_row (self, g_value_get_object (value));
		break;
		case SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY:
		sudoku_board_set_coords_for_block (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
coord_init (Coord *self,
            gint row,
            gint col)
{
	memset (self, 0, sizeof (Coord));
	(*self).row = row;
	(*self).col = col;
}

gint
coord_hash (Coord* coord)
{
	Coord _tmp0_;
	Coord _tmp1_;
	gint result;
	g_return_val_if_fail (coord != NULL, 0);
	_tmp0_ = *coord;
	_tmp1_ = *coord;
	result = (_tmp0_.row * 33) ^ _tmp1_.col;
	return result;
}

gboolean
coord_equal (Coord* a,
             Coord* b)
{
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_;
	Coord _tmp2_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = *b;
	if (_tmp1_.row == _tmp2_.row) {
		Coord _tmp3_;
		Coord _tmp4_;
		_tmp3_ = *a;
		_tmp4_ = *b;
		_tmp0_ = _tmp3_.col == _tmp4_.col;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Coord*
coord_dup (const Coord* self)
{
	Coord* dup;
	dup = g_new0 (Coord, 1);
	memcpy (dup, self, sizeof (Coord));
	return dup;
}

void
coord_free (Coord* self)
{
	g_free (self);
}

static GType
coord_get_type_once (void)
{
	GType coord_type_id;
	coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
	return coord_type_id;
}

GType
coord_get_type (void)
{
	static volatile gsize coord_type_id__once = 0;
	if (g_once_init_enter (&coord_type_id__once)) {
		GType coord_type_id;
		coord_type_id = coord_get_type_once ();
		g_once_init_leave (&coord_type_id__once, coord_type_id);
	}
	return coord_type_id__once;
}

gchar*
difficulty_category_to_string (DifficultyCategory self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Unknown Difficulty"));
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Easy Difficulty"));
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Medium Difficulty"));
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Hard Difficulty"));
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Very Hard Difficulty"));
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Custom Puzzle"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
difficulty_category_to_untranslated_string (DifficultyCategory self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Unknown Difficulty");
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Easy Difficulty");
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Medium Difficulty");
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Hard Difficulty");
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Very Hard Difficulty");
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("Custom Puzzle");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

DifficultyCategory
difficulty_category_from_string (const gchar* input)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	DifficultyCategory result;
	g_return_val_if_fail (input != NULL, 0);
	_tmp0_ = input;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_UNKNOWN;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_MEDIUM;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_VERY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("Custom Puzzle")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_CUSTOM;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("sudoku-board.vala:585: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	}
}

static GType
difficulty_category_get_type_once (void)
{
	static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {DIFFICULTY_CATEGORY_CUSTOM, "DIFFICULTY_CATEGORY_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType difficulty_category_type_id;
	difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
	return difficulty_category_type_id;
}

GType
difficulty_category_get_type (void)
{
	static volatile gsize difficulty_category_type_id__once = 0;
	if (g_once_init_enter (&difficulty_category_type_id__once)) {
		GType difficulty_category_type_id;
		difficulty_category_type_id = difficulty_category_get_type_once ();
		g_once_init_leave (&difficulty_category_type_id__once, difficulty_category_type_id);
	}
	return difficulty_category_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

