/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_correlate_access_code_tag_bb = R"doc(Examine input for specified access code, one bit at a time.

input: stream of bits, 1 bit per input byte (data in LSB) output: unaltered stream of bits (plus tags)


This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc.

Constructor Specific Documentation:



Args:
    access_code : is represented with 1 byte per bit, e.g., \"010101010111000100\"
    threshold : maximum number of bits that may be wrong
    tag_name : key of the tag inserted into the tag stream)doc";


static const char*
    __doc_gr_digital_correlate_access_code_tag_bb_correlate_access_code_tag_bb_0 =
        R"doc()doc";


static const char*
    __doc_gr_digital_correlate_access_code_tag_bb_correlate_access_code_tag_bb_1 =
        R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_tag_bb_make = R"doc(Examine input for specified access code, one bit at a time.

input: stream of bits, 1 bit per input byte (data in LSB) output: unaltered stream of bits (plus tags)


This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc.

Constructor Specific Documentation:



Args:
    access_code : is represented with 1 byte per bit, e.g., \"010101010111000100\"
    threshold : maximum number of bits that may be wrong
    tag_name : key of the tag inserted into the tag stream)doc";


static const char* __doc_gr_digital_correlate_access_code_tag_bb_set_access_code =
    R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_tag_bb_set_threshold =
    R"doc()doc";


static const char* __doc_gr_digital_correlate_access_code_tag_bb_set_tagname =
    R"doc()doc";
