/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_pfb_arb_resampler_ccf = R"doc(Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and float taps.

This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccf to perform arbitrary resampling on the stream.


Output sampling rate is  * input rate.

Constructor Specific Documentation:

Build the polyphase filterbank arbitrary resampler.

Args:
    rate : (float) Specifies the resampling rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
    filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_pfb_arb_resampler_ccf_0 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_pfb_arb_resampler_ccf_1 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_make = R"doc(Polyphase filterbank arbitrary resampler with gr_complex input, gr_complex output and float taps.

This block takes in a signal stream and calls gr::filter::kernel::pfb_arb_resampler_ccf to perform arbitrary resampling on the stream.


Output sampling rate is  * input rate.

Constructor Specific Documentation:

Build the polyphase filterbank arbitrary resampler.

Args:
    rate : (float) Specifies the resampling rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
    filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_set_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_taps = R"doc(Return a vector<vector<>> of the filterbank taps)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_print_taps = R"doc(Print all of the filterbank taps to screen.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_set_rate = R"doc(Sets the resampling rate of the block.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_set_phase = R"doc(Sets the current phase offset in radians (0 to 2pi).)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_phase = R"doc(Gets the current phase of the resampler in radians (2 to 2pi).)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_taps_per_filter = R"doc(Gets the number of taps per filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_interpolation_rate = R"doc(Gets the interpolation rate of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_decimation_rate = R"doc(Gets the decimation rate of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_fractional_rate = R"doc(Gets the fractional rate of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_group_delay = R"doc(Get the group delay of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_ccf_phase_offset = R"doc(Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).)doc";
