/**************************************************************************/
/*  smaa_blending.glsl.gen.h                                              */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

/* THIS FILE IS GENERATED. EDITS WILL BE LOST. */

#pragma once

#include "servers/rendering/renderer_rd/shader_rd.h"

class SmaaBlendingShaderRD : public ShaderRD {
public:
	SmaaBlendingShaderRD() {
		static const char _vertex_code[] = {
R"<!>(#version 450

layout(location = 0) out vec2 tex_coord;
layout(location = 1) out vec4 offset;

layout(push_constant, std430) uniform Params {
	vec2 inv_size;
	vec2 pad;
}
params;

void main() {
	vec2 vertex_base;
	if (gl_VertexIndex == 0) {
		vertex_base = vec2(-1.0, -1.0);
	} else if (gl_VertexIndex == 1) {
		vertex_base = vec2(-1.0, 3.0);
	} else {
		vertex_base = vec2(3.0, -1.0);
	}
	gl_Position = vec4(vertex_base, 0.0, 1.0);
	tex_coord = clamp(vertex_base, vec2(0.0, 0.0), vec2(1.0, 1.0)) * 2.0; 
	offset = fma(params.inv_size.xyxy, vec4(1.0, 0.0, 0.0, 1.0), tex_coord.xyxy);
}

)<!>"
		};
		static const char _fragment_code[] = {
R"<!>(#version 450

layout(location = 0) in vec2 tex_coord;
layout(location = 1) in vec4 offset;
layout(set = 0, binding = 0) uniform sampler2D color_tex;
layout(set = 1, binding = 0) uniform sampler2D blend_tex;

layout(location = 0) out vec4 out_color;

#define FLAG_USE_8_BIT_DEBANDING (1 << 0)
#define FLAG_USE_10_BIT_DEBANDING (1 << 1)

layout(push_constant, std430) uniform Params {
	vec2 inv_size;
	uint flags;
	float pad;
}
params;

#define textureLinear(tex, uv) srgb_to_linear(textureLod(tex, uv, 0.0).rgb)

vec3 linear_to_srgb(vec3 color) {
	
	color = clamp(color, vec3(0.0), vec3(1.0));
	const vec3 a = vec3(0.055f);
	return mix((vec3(1.0f) + a) * pow(color.rgb, vec3(1.0f / 2.4f)) - a, 12.92f * color.rgb, lessThan(color.rgb, vec3(0.0031308f)));
}

vec3 srgb_to_linear(vec3 color) {
	return mix(pow((color.rgb + vec3(0.055)) * (1.0 / (1.0 + 0.055)), vec3(2.4)), color.rgb * (1.0 / 12.92), lessThan(color.rgb, vec3(0.04045)));
}

void SMAAMovc(bvec2 cond, inout vec2 variable, vec2 value) {
	if (cond.x) {
		variable.x = value.x;
	}
	if (cond.y) {
		variable.y = value.y;
	}
}

void SMAAMovc(bvec4 cond, inout vec4 variable, vec4 value) {
	SMAAMovc(cond.xy, variable.xy, value.xy);
	SMAAMovc(cond.zw, variable.zw, value.zw);
}






vec3 screen_space_dither(vec2 frag_coord, float bit_alignment_diviser) {
	
	
	vec3 dither = vec3(dot(vec2(171.0, 231.0), frag_coord));
	dither.rgb = fract(dither.rgb / vec3(103.0, 71.0, 97.0));

	
	
	return (dither.rgb - 0.5) / bit_alignment_diviser;
}

void main() {
	vec4 a;
	a.x = texture(blend_tex, offset.xy).a;
	a.y = texture(blend_tex, offset.zw).g;
	a.wz = texture(blend_tex, tex_coord).xz;

	if (dot(a, vec4(1.0, 1.0, 1.0, 1.0)) < 1e-5) {
		out_color = textureLod(color_tex, tex_coord, 0.0);
	} else {
		bool h = max(a.x, a.z) > max(a.y, a.w);

		vec4 blending_offset = vec4(0.0, a.y, 0.0, a.w);
		vec2 blending_weight = a.yw;

		SMAAMovc(bvec4(h, h, h, h), blending_offset, vec4(a.x, 0.0, a.z, 0.0));
		SMAAMovc(bvec2(h, h), blending_weight, a.xz);
		blending_weight /= dot(blending_weight, vec2(1.0, 1.0));

		vec4 blending_coord = fma(blending_offset, vec4(params.inv_size.xy, -params.inv_size.xy), tex_coord.xyxy);

		out_color.rgb = blending_weight.x * textureLinear(color_tex, blending_coord.xy);
		out_color.rgb += blending_weight.y * textureLinear(color_tex, blending_coord.zw);
		out_color.rgb = linear_to_srgb(out_color.rgb);
		out_color.a = texture(color_tex, tex_coord).a;
	}
	if (bool(params.flags & FLAG_USE_8_BIT_DEBANDING)) {
		
		out_color.rgb += screen_space_dither(gl_FragCoord.xy, 255.0);
	} else if (bool(params.flags & FLAG_USE_10_BIT_DEBANDING)) {
		
		out_color.rgb += screen_space_dither(gl_FragCoord.xy, 1023.0);
	}
}
)<!>"
		};
		static const char *_compute_code = nullptr;
		setup(_vertex_code, _fragment_code, _compute_code, "SmaaBlendingShaderRD");
	}
};
