{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describes a key press or key release event.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventKey
    ( 

-- * Exported types
    EventKey(..)                            ,
    newZeroEventKey                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventKeyMethod                   ,
#endif



 -- * Properties


-- ** group #attr:group#
-- | the keyboard group.

#if defined(ENABLE_OVERLOADING)
    eventKey_group                          ,
#endif
    getEventKeyGroup                        ,
    setEventKeyGroup                        ,


-- ** hardwareKeycode #attr:hardwareKeycode#
-- | the raw code of the key that was pressed or released.

#if defined(ENABLE_OVERLOADING)
    eventKey_hardwareKeycode                ,
#endif
    getEventKeyHardwareKeycode              ,
    setEventKeyHardwareKeycode              ,


-- ** isModifier #attr:isModifier#
-- | a flag that indicates if /@hardwareKeycode@/ is mapped to a
--   modifier. Since 2.10

#if defined(ENABLE_OVERLOADING)
    eventKey_isModifier                     ,
#endif
    getEventKeyIsModifier                   ,
    setEventKeyIsModifier                   ,


-- ** keyval #attr:keyval#
-- | the key that was pressed or released. See the
--   @gdk\/gdkkeysyms.h@ header file for a
--   complete list of GDK key codes.

#if defined(ENABLE_OVERLOADING)
    eventKey_keyval                         ,
#endif
    getEventKeyKeyval                       ,
    setEventKeyKeyval                       ,


-- ** length #attr:length#
-- | the length of /@string@/.

#if defined(ENABLE_OVERLOADING)
    eventKey_length                         ,
#endif
    getEventKeyLength                       ,
    setEventKeyLength                       ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventKey_sendEvent                      ,
#endif
    getEventKeySendEvent                    ,
    setEventKeySendEvent                    ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventKey_state                          ,
#endif
    getEventKeyState                        ,
    setEventKeyState                        ,


-- ** string #attr:string#
-- | a string containing an approximation of the text that
--   would result from this keypress. The only correct way to handle text
--   input of text is using input methods (see @/GtkIMContext/@), so this
--   field is deprecated and should never be used.
--   ('GI.Gdk.Functions.unicodeToKeyval' provides a non-deprecated way of getting
--   an approximate translation for a key.) The string is encoded in the
--   encoding of the current locale (Note: this for backwards compatibility:
--   strings in GTK+ and GDK are typically in UTF-8.) and NUL-terminated.
--   In some cases, the translation of the key code will be a single
--   NUL byte, in which case looking at /@length@/ is necessary to distinguish
--   it from the an empty translation.

    clearEventKeyString                     ,
#if defined(ENABLE_OVERLOADING)
    eventKey_string                         ,
#endif
    getEventKeyString                       ,
    setEventKeyString                       ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventKey_time                           ,
#endif
    getEventKeyTime                         ,
    setEventKeyTime                         ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeKeyPress' or 'GI.Gdk.Enums.EventTypeKeyRelease').

#if defined(ENABLE_OVERLOADING)
    eventKey_type                           ,
#endif
    getEventKeyType                         ,
    setEventKeyType                         ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventKeyWindow                     ,
#if defined(ENABLE_OVERLOADING)
    eventKey_window                         ,
#endif
    getEventKeyWindow                       ,
    setEventKeyWindow                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventKey = EventKey (SP.ManagedPtr EventKey)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventKey where
    toManagedPtr (EventKey p) = p

instance BoxedPtr EventKey where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr EventKey)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventKey where
    boxedPtrCalloc = callocBytes 56


-- | Construct a t'EventKey' struct initialized to zero.
newZeroEventKey :: MonadIO m => m EventKey
newZeroEventKey = liftIO $ boxedPtrCalloc >>= wrapPtr EventKey

instance tag ~ 'AttrSet => Constructible EventKey tag where
    new _ attrs = do
        o <- newZeroEventKey
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #type
-- @
getEventKeyType :: MonadIO m => EventKey -> m Gdk.Enums.EventType
getEventKeyType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyType :: MonadIO m => EventKey -> Gdk.Enums.EventType -> m ()
setEventKeyType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventKeyTypeFieldInfo
instance AttrInfo EventKeyTypeFieldInfo where
    type AttrBaseTypeConstraint EventKeyTypeFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventKeyTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventKeyTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventKeyTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventKeyTypeFieldInfo = "type"
    type AttrOrigin EventKeyTypeFieldInfo = EventKey
    attrGet = getEventKeyType
    attrSet = setEventKeyType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:type"
        })

eventKey_type :: AttrLabelProxy "type"
eventKey_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #window
-- @
getEventKeyWindow :: MonadIO m => EventKey -> m (Maybe Gdk.Window.Window)
getEventKeyWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyWindow :: MonadIO m => EventKey -> Ptr Gdk.Window.Window -> m ()
setEventKeyWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventKeyWindow :: MonadIO m => EventKey -> m ()
clearEventKeyWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventKeyWindowFieldInfo
instance AttrInfo EventKeyWindowFieldInfo where
    type AttrBaseTypeConstraint EventKeyWindowFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventKeyWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventKeyWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventKeyWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventKeyWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventKeyWindowFieldInfo = "window"
    type AttrOrigin EventKeyWindowFieldInfo = EventKey
    attrGet = getEventKeyWindow
    attrSet = setEventKeyWindow
    attrConstruct = undefined
    attrClear = clearEventKeyWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:window"
        })

eventKey_window :: AttrLabelProxy "window"
eventKey_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #sendEvent
-- @
getEventKeySendEvent :: MonadIO m => EventKey -> m Int8
getEventKeySendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeySendEvent :: MonadIO m => EventKey -> Int8 -> m ()
setEventKeySendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventKeySendEventFieldInfo
instance AttrInfo EventKeySendEventFieldInfo where
    type AttrBaseTypeConstraint EventKeySendEventFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeySendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeySendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventKeySendEventFieldInfo = (~)Int8
    type AttrTransferType EventKeySendEventFieldInfo = Int8
    type AttrGetType EventKeySendEventFieldInfo = Int8
    type AttrLabel EventKeySendEventFieldInfo = "send_event"
    type AttrOrigin EventKeySendEventFieldInfo = EventKey
    attrGet = getEventKeySendEvent
    attrSet = setEventKeySendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:sendEvent"
        })

eventKey_sendEvent :: AttrLabelProxy "sendEvent"
eventKey_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #time
-- @
getEventKeyTime :: MonadIO m => EventKey -> m Word32
getEventKeyTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyTime :: MonadIO m => EventKey -> Word32 -> m ()
setEventKeyTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventKeyTimeFieldInfo
instance AttrInfo EventKeyTimeFieldInfo where
    type AttrBaseTypeConstraint EventKeyTimeFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventKeyTimeFieldInfo = (~)Word32
    type AttrTransferType EventKeyTimeFieldInfo = Word32
    type AttrGetType EventKeyTimeFieldInfo = Word32
    type AttrLabel EventKeyTimeFieldInfo = "time"
    type AttrOrigin EventKeyTimeFieldInfo = EventKey
    attrGet = getEventKeyTime
    attrSet = setEventKeyTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:time"
        })

eventKey_time :: AttrLabelProxy "time"
eventKey_time = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #state
-- @
getEventKeyState :: MonadIO m => EventKey -> m [Gdk.Flags.ModifierType]
getEventKeyState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyState :: MonadIO m => EventKey -> [Gdk.Flags.ModifierType] -> m ()
setEventKeyState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 24) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventKeyStateFieldInfo
instance AttrInfo EventKeyStateFieldInfo where
    type AttrBaseTypeConstraint EventKeyStateFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventKeyStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventKeyStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventKeyStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventKeyStateFieldInfo = "state"
    type AttrOrigin EventKeyStateFieldInfo = EventKey
    attrGet = getEventKeyState
    attrSet = setEventKeyState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:state"
        })

eventKey_state :: AttrLabelProxy "state"
eventKey_state = AttrLabelProxy

#endif


-- | Get the value of the “@keyval@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #keyval
-- @
getEventKeyKeyval :: MonadIO m => EventKey -> m Word32
getEventKeyKeyval s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@keyval@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #keyval 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyKeyval :: MonadIO m => EventKey -> Word32 -> m ()
setEventKeyKeyval s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventKeyKeyvalFieldInfo
instance AttrInfo EventKeyKeyvalFieldInfo where
    type AttrBaseTypeConstraint EventKeyKeyvalFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyKeyvalFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyKeyvalFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventKeyKeyvalFieldInfo = (~)Word32
    type AttrTransferType EventKeyKeyvalFieldInfo = Word32
    type AttrGetType EventKeyKeyvalFieldInfo = Word32
    type AttrLabel EventKeyKeyvalFieldInfo = "keyval"
    type AttrOrigin EventKeyKeyvalFieldInfo = EventKey
    attrGet = getEventKeyKeyval
    attrSet = setEventKeyKeyval
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.keyval"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:keyval"
        })

eventKey_keyval :: AttrLabelProxy "keyval"
eventKey_keyval = AttrLabelProxy

#endif


-- | Get the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #length
-- @
getEventKeyLength :: MonadIO m => EventKey -> m Int32
getEventKeyLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Int32
    return val

-- | Set the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyLength :: MonadIO m => EventKey -> Int32 -> m ()
setEventKeyLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data EventKeyLengthFieldInfo
instance AttrInfo EventKeyLengthFieldInfo where
    type AttrBaseTypeConstraint EventKeyLengthFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyLengthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint EventKeyLengthFieldInfo = (~)Int32
    type AttrTransferType EventKeyLengthFieldInfo = Int32
    type AttrGetType EventKeyLengthFieldInfo = Int32
    type AttrLabel EventKeyLengthFieldInfo = "length"
    type AttrOrigin EventKeyLengthFieldInfo = EventKey
    attrGet = getEventKeyLength
    attrSet = setEventKeyLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:length"
        })

eventKey_length :: AttrLabelProxy "length"
eventKey_length = AttrLabelProxy

#endif


-- | Get the value of the “@string@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #string
-- @
getEventKeyString :: MonadIO m => EventKey -> m (Maybe T.Text)
getEventKeyString s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@string@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #string 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyString :: MonadIO m => EventKey -> CString -> m ()
setEventKeyString s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: CString)

-- | Set the value of the “@string@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #string
-- @
clearEventKeyString :: MonadIO m => EventKey -> m ()
clearEventKeyString s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data EventKeyStringFieldInfo
instance AttrInfo EventKeyStringFieldInfo where
    type AttrBaseTypeConstraint EventKeyStringFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyStringFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventKeyStringFieldInfo = (~) CString
    type AttrTransferTypeConstraint EventKeyStringFieldInfo = (~)CString
    type AttrTransferType EventKeyStringFieldInfo = CString
    type AttrGetType EventKeyStringFieldInfo = Maybe T.Text
    type AttrLabel EventKeyStringFieldInfo = "string"
    type AttrOrigin EventKeyStringFieldInfo = EventKey
    attrGet = getEventKeyString
    attrSet = setEventKeyString
    attrConstruct = undefined
    attrClear = clearEventKeyString
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.string"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:string"
        })

eventKey_string :: AttrLabelProxy "string"
eventKey_string = AttrLabelProxy

#endif


-- | Get the value of the “@hardware_keycode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #hardwareKeycode
-- @
getEventKeyHardwareKeycode :: MonadIO m => EventKey -> m Word16
getEventKeyHardwareKeycode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO Word16
    return val

-- | Set the value of the “@hardware_keycode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #hardwareKeycode 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyHardwareKeycode :: MonadIO m => EventKey -> Word16 -> m ()
setEventKeyHardwareKeycode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data EventKeyHardwareKeycodeFieldInfo
instance AttrInfo EventKeyHardwareKeycodeFieldInfo where
    type AttrBaseTypeConstraint EventKeyHardwareKeycodeFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyHardwareKeycodeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyHardwareKeycodeFieldInfo = (~) Word16
    type AttrTransferTypeConstraint EventKeyHardwareKeycodeFieldInfo = (~)Word16
    type AttrTransferType EventKeyHardwareKeycodeFieldInfo = Word16
    type AttrGetType EventKeyHardwareKeycodeFieldInfo = Word16
    type AttrLabel EventKeyHardwareKeycodeFieldInfo = "hardware_keycode"
    type AttrOrigin EventKeyHardwareKeycodeFieldInfo = EventKey
    attrGet = getEventKeyHardwareKeycode
    attrSet = setEventKeyHardwareKeycode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.hardwareKeycode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:hardwareKeycode"
        })

eventKey_hardwareKeycode :: AttrLabelProxy "hardwareKeycode"
eventKey_hardwareKeycode = AttrLabelProxy

#endif


-- | Get the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #group
-- @
getEventKeyGroup :: MonadIO m => EventKey -> m Word8
getEventKeyGroup s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 50) :: IO Word8
    return val

-- | Set the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #group 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyGroup :: MonadIO m => EventKey -> Word8 -> m ()
setEventKeyGroup s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 50) (val :: Word8)

#if defined(ENABLE_OVERLOADING)
data EventKeyGroupFieldInfo
instance AttrInfo EventKeyGroupFieldInfo where
    type AttrBaseTypeConstraint EventKeyGroupFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyGroupFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyGroupFieldInfo = (~) Word8
    type AttrTransferTypeConstraint EventKeyGroupFieldInfo = (~)Word8
    type AttrTransferType EventKeyGroupFieldInfo = Word8
    type AttrGetType EventKeyGroupFieldInfo = Word8
    type AttrLabel EventKeyGroupFieldInfo = "group"
    type AttrOrigin EventKeyGroupFieldInfo = EventKey
    attrGet = getEventKeyGroup
    attrSet = setEventKeyGroup
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.group"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:group"
        })

eventKey_group :: AttrLabelProxy "group"
eventKey_group = AttrLabelProxy

#endif


-- | Get the value of the “@is_modifier@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventKey #isModifier
-- @
getEventKeyIsModifier :: MonadIO m => EventKey -> m Word32
getEventKeyIsModifier s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 52) :: IO Word32
    return val

-- | Set the value of the “@is_modifier@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventKey [ #isModifier 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventKeyIsModifier :: MonadIO m => EventKey -> Word32 -> m ()
setEventKeyIsModifier s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 52) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventKeyIsModifierFieldInfo
instance AttrInfo EventKeyIsModifierFieldInfo where
    type AttrBaseTypeConstraint EventKeyIsModifierFieldInfo = (~) EventKey
    type AttrAllowedOps EventKeyIsModifierFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventKeyIsModifierFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventKeyIsModifierFieldInfo = (~)Word32
    type AttrTransferType EventKeyIsModifierFieldInfo = Word32
    type AttrGetType EventKeyIsModifierFieldInfo = Word32
    type AttrLabel EventKeyIsModifierFieldInfo = "is_modifier"
    type AttrOrigin EventKeyIsModifierFieldInfo = EventKey
    attrGet = getEventKeyIsModifier
    attrSet = setEventKeyIsModifier
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventKey.isModifier"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventKey.html#g:attr:isModifier"
        })

eventKey_isModifier :: AttrLabelProxy "isModifier"
eventKey_isModifier = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventKey
type instance O.AttributeList EventKey = EventKeyAttributeList
type EventKeyAttributeList = ('[ '("type", EventKeyTypeFieldInfo), '("window", EventKeyWindowFieldInfo), '("sendEvent", EventKeySendEventFieldInfo), '("time", EventKeyTimeFieldInfo), '("state", EventKeyStateFieldInfo), '("keyval", EventKeyKeyvalFieldInfo), '("length", EventKeyLengthFieldInfo), '("string", EventKeyStringFieldInfo), '("hardwareKeycode", EventKeyHardwareKeycodeFieldInfo), '("group", EventKeyGroupFieldInfo), '("isModifier", EventKeyIsModifierFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventKeyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventKeyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventKeyMethod t EventKey, O.OverloadedMethod info EventKey p) => OL.IsLabel t (EventKey -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventKeyMethod t EventKey, O.OverloadedMethod info EventKey p, R.HasField t EventKey p) => R.HasField t EventKey p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventKeyMethod t EventKey, O.OverloadedMethodInfo info EventKey) => OL.IsLabel t (O.MethodProxy info EventKey) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


