{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GProxyResolver@ provides synchronous and asynchronous network proxy
-- resolution. @GProxyResolver@ is used within t'GI.Gio.Objects.SocketClient.SocketClient' through
-- the method 'GI.Gio.Interfaces.SocketConnectable.socketConnectableProxyEnumerate'.
-- 
-- Implementations of @GProxyResolver@ based on
-- <https://github.com/libproxy/libproxy libproxy> and GNOME settings can be
-- found in <https://gitlab.gnome.org/GNOME/glib-networking glib-networking>.
-- GIO comes with an implementation for use inside Flatpak portals.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.ProxyResolver
    ( 

-- * Exported types
    ProxyResolver(..)                       ,
    IsProxyResolver                         ,
    toProxyResolver                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isSupported]("GI.Gio.Interfaces.ProxyResolver#g:method:isSupported"), [lookup]("GI.Gio.Interfaces.ProxyResolver#g:method:lookup"), [lookupAsync]("GI.Gio.Interfaces.ProxyResolver#g:method:lookupAsync"), [lookupFinish]("GI.Gio.Interfaces.ProxyResolver#g:method:lookupFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveProxyResolverMethod              ,
#endif

-- ** getDefault #method:getDefault#

    proxyResolverGetDefault                 ,


-- ** isSupported #method:isSupported#

#if defined(ENABLE_OVERLOADING)
    ProxyResolverIsSupportedMethodInfo      ,
#endif
    proxyResolverIsSupported                ,


-- ** lookup #method:lookup#

#if defined(ENABLE_OVERLOADING)
    ProxyResolverLookupMethodInfo           ,
#endif
    proxyResolverLookup                     ,


-- ** lookupAsync #method:lookupAsync#

#if defined(ENABLE_OVERLOADING)
    ProxyResolverLookupAsyncMethodInfo      ,
#endif
    proxyResolverLookupAsync                ,


-- ** lookupFinish #method:lookupFinish#

#if defined(ENABLE_OVERLOADING)
    ProxyResolverLookupFinishMethodInfo     ,
#endif
    proxyResolverLookupFinish               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#endif

-- interface ProxyResolver 
-- | Memory-managed wrapper type.
newtype ProxyResolver = ProxyResolver (SP.ManagedPtr ProxyResolver)
    deriving (Eq)

instance SP.ManagedPtrNewtype ProxyResolver where
    toManagedPtr (ProxyResolver p) = p

foreign import ccall "g_proxy_resolver_get_type"
    c_g_proxy_resolver_get_type :: IO B.Types.GType

instance B.Types.TypedObject ProxyResolver where
    glibType = c_g_proxy_resolver_get_type

instance B.Types.GObject ProxyResolver

-- | Type class for types which can be safely cast to t'ProxyResolver', for instance with `toProxyResolver`.
class (SP.GObject o, O.IsDescendantOf ProxyResolver o) => IsProxyResolver o
instance (SP.GObject o, O.IsDescendantOf ProxyResolver o) => IsProxyResolver o

instance O.HasParentTypes ProxyResolver
type instance O.ParentTypes ProxyResolver = '[GObject.Object.Object]

-- | Cast to t'ProxyResolver', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toProxyResolver :: (MIO.MonadIO m, IsProxyResolver o) => o -> m ProxyResolver
toProxyResolver = MIO.liftIO . B.ManagedPtr.unsafeCastTo ProxyResolver

-- | Convert t'ProxyResolver' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ProxyResolver) where
    gvalueGType_ = c_g_proxy_resolver_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ProxyResolver)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ProxyResolver)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ProxyResolver ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ProxyResolver
type instance O.AttributeList ProxyResolver = ProxyResolverAttributeList
type ProxyResolverAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveProxyResolverMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveProxyResolverMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveProxyResolverMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveProxyResolverMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveProxyResolverMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveProxyResolverMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveProxyResolverMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveProxyResolverMethod "isSupported" o = ProxyResolverIsSupportedMethodInfo
    ResolveProxyResolverMethod "lookup" o = ProxyResolverLookupMethodInfo
    ResolveProxyResolverMethod "lookupAsync" o = ProxyResolverLookupAsyncMethodInfo
    ResolveProxyResolverMethod "lookupFinish" o = ProxyResolverLookupFinishMethodInfo
    ResolveProxyResolverMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveProxyResolverMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveProxyResolverMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveProxyResolverMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveProxyResolverMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveProxyResolverMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveProxyResolverMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveProxyResolverMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveProxyResolverMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveProxyResolverMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveProxyResolverMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveProxyResolverMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveProxyResolverMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveProxyResolverMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveProxyResolverMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveProxyResolverMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveProxyResolverMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveProxyResolverMethod t ProxyResolver, O.OverloadedMethod info ProxyResolver p) => OL.IsLabel t (ProxyResolver -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveProxyResolverMethod t ProxyResolver, O.OverloadedMethod info ProxyResolver p, R.HasField t ProxyResolver p) => R.HasField t ProxyResolver p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveProxyResolverMethod t ProxyResolver, O.OverloadedMethodInfo info ProxyResolver) => OL.IsLabel t (O.MethodProxy info ProxyResolver) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method ProxyResolver::is_supported
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyResolver" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_resolver_is_supported" g_proxy_resolver_is_supported :: 
    Ptr ProxyResolver ->                    -- resolver : TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
    IO CInt

-- | Checks if /@resolver@/ can be used on this system. (This is used
-- internally; 'GI.Gio.Functions.proxyResolverGetDefault' will only return a proxy
-- resolver that returns 'P.True' for this method.)
-- 
-- /Since: 2.26/
proxyResolverIsSupported ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyResolver a) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@resolver@/ is supported.
proxyResolverIsSupported resolver = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    result <- g_proxy_resolver_is_supported resolver'
    let result' = (/= 0) result
    touchManagedPtr resolver
    return result'

#if defined(ENABLE_OVERLOADING)
data ProxyResolverIsSupportedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsProxyResolver a) => O.OverloadedMethod ProxyResolverIsSupportedMethodInfo a signature where
    overloadedMethod = proxyResolverIsSupported

instance O.OverloadedMethodInfo ProxyResolverIsSupportedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ProxyResolver.proxyResolverIsSupported",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ProxyResolver.html#v:proxyResolverIsSupported"
        })


#endif

-- method ProxyResolver::lookup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyResolver" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a URI representing the destination to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : True
-- Skip return : False

foreign import ccall "g_proxy_resolver_lookup" g_proxy_resolver_lookup :: 
    Ptr ProxyResolver ->                    -- resolver : TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
    CString ->                              -- uri : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CString)

-- | Looks into the system proxy configuration to determine what proxy,
-- if any, to use to connect to /@uri@/. The returned proxy URIs are of
-- the form @\<protocol>:\/\/[user[:password]\@]host[:port]@ or
-- @direct:\/\/@, where @\<protocol>@ could be http, rtsp, socks
-- or other proxying protocol.
-- 
-- If you don\'t know what network protocol is being used on the
-- socket, you should use @none@ as the URI protocol.
-- In this case, the resolver might still return a generic proxy type
-- (such as SOCKS), but would not return protocol-specific proxy types
-- (such as http).
-- 
-- @direct:\/\/@ is used when no proxy is needed.
-- Direct connection should not be attempted unless it is part of the
-- returned array of proxies.
-- 
-- /Since: 2.26/
proxyResolverLookup ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyResolver a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver'
    -> T.Text
    -- ^ /@uri@/: a URI representing the destination to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m [T.Text]
    -- ^ __Returns:__ A
    --               NULL-terminated array of proxy URIs. Must be freed
    --               with 'GI.GLib.Functions.strfreev'. /(Can throw 'Data.GI.Base.GError.GError')/
proxyResolverLookup resolver uri cancellable = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    uri' <- textToCString uri
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_proxy_resolver_lookup resolver' uri' maybeCancellable
        checkUnexpectedReturnNULL "proxyResolverLookup" result
        result' <- unpackZeroTerminatedUTF8CArray result
        mapZeroTerminatedCArray freeMem result
        freeMem result
        touchManagedPtr resolver
        whenJust cancellable touchManagedPtr
        freeMem uri'
        return result'
     ) (do
        freeMem uri'
     )

#if defined(ENABLE_OVERLOADING)
data ProxyResolverLookupMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> m [T.Text]), MonadIO m, IsProxyResolver a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod ProxyResolverLookupMethodInfo a signature where
    overloadedMethod = proxyResolverLookup

instance O.OverloadedMethodInfo ProxyResolverLookupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ProxyResolver.proxyResolverLookup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ProxyResolver.html#v:proxyResolverLookup"
        })


#endif

-- method ProxyResolver::lookup_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyResolver" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a URI representing the destination to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback to call after resolution completes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data for @callback" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_resolver_lookup_async" g_proxy_resolver_lookup_async :: 
    Ptr ProxyResolver ->                    -- resolver : TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
    CString ->                              -- uri : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronous lookup of proxy. See 'GI.Gio.Interfaces.ProxyResolver.proxyResolverLookup' for more
-- details.
-- 
-- /Since: 2.26/
proxyResolverLookupAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyResolver a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver'
    -> T.Text
    -- ^ /@uri@/: a URI representing the destination to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: callback to call after resolution completes
    -> m ()
proxyResolverLookupAsync resolver uri cancellable callback = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    uri' <- textToCString uri
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_proxy_resolver_lookup_async resolver' uri' maybeCancellable maybeCallback userData
    touchManagedPtr resolver
    whenJust cancellable touchManagedPtr
    freeMem uri'
    return ()

#if defined(ENABLE_OVERLOADING)
data ProxyResolverLookupAsyncMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsProxyResolver a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod ProxyResolverLookupAsyncMethodInfo a signature where
    overloadedMethod = proxyResolverLookupAsync

instance O.OverloadedMethodInfo ProxyResolverLookupAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ProxyResolver.proxyResolverLookupAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ProxyResolver.html#v:proxyResolverLookupAsync"
        })


#endif

-- method ProxyResolver::lookup_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyResolver" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the result passed to your #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : True
-- Skip return : False

foreign import ccall "g_proxy_resolver_lookup_finish" g_proxy_resolver_lookup_finish :: 
    Ptr ProxyResolver ->                    -- resolver : TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CString)

-- | Call this function to obtain the array of proxy URIs when
-- 'GI.Gio.Interfaces.ProxyResolver.proxyResolverLookupAsync' is complete. See
-- 'GI.Gio.Interfaces.ProxyResolver.proxyResolverLookup' for more details.
-- 
-- /Since: 2.26/
proxyResolverLookupFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyResolver a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver'
    -> b
    -- ^ /@result@/: the result passed to your t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m [T.Text]
    -- ^ __Returns:__ A
    --               NULL-terminated array of proxy URIs. Must be freed
    --               with 'GI.GLib.Functions.strfreev'. /(Can throw 'Data.GI.Base.GError.GError')/
proxyResolverLookupFinish resolver result_ = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_proxy_resolver_lookup_finish resolver' result_'
        checkUnexpectedReturnNULL "proxyResolverLookupFinish" result
        result' <- unpackZeroTerminatedUTF8CArray result
        mapZeroTerminatedCArray freeMem result
        freeMem result
        touchManagedPtr resolver
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data ProxyResolverLookupFinishMethodInfo
instance (signature ~ (b -> m [T.Text]), MonadIO m, IsProxyResolver a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod ProxyResolverLookupFinishMethodInfo a signature where
    overloadedMethod = proxyResolverLookupFinish

instance O.OverloadedMethodInfo ProxyResolverLookupFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.ProxyResolver.proxyResolverLookupFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-ProxyResolver.html#v:proxyResolverLookupFinish"
        })


#endif

-- method ProxyResolver::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "ProxyResolver" })
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_resolver_get_default" g_proxy_resolver_get_default :: 
    IO (Ptr ProxyResolver)

-- | Gets the default t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver' for the system.
-- 
-- /Since: 2.26/
proxyResolverGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ProxyResolver
    -- ^ __Returns:__ the default t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver', which
    --     will be a dummy object if no proxy resolver is available
proxyResolverGetDefault  = liftIO $ do
    result <- g_proxy_resolver_get_default
    checkUnexpectedReturnNULL "proxyResolverGetDefault" result
    result' <- (newObject ProxyResolver) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ProxyResolver = ProxyResolverSignalList
type ProxyResolverSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


