{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about an argument for a method or a signal.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusArgInfo
    ( 

-- * Exported types
    DBusArgInfo(..)                         ,
    newZeroDBusArgInfo                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gio.Structs.DBusArgInfo#g:method:ref"), [unref]("GI.Gio.Structs.DBusArgInfo#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveDBusArgInfoMethod                ,
#endif

-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    DBusArgInfoRefMethodInfo                ,
#endif
    dBusArgInfoRef                          ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    DBusArgInfoUnrefMethodInfo              ,
#endif
    dBusArgInfoUnref                        ,




 -- * Properties


-- ** annotations #attr:annotations#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo' structures or 'P.Nothing' if there are no annotations.

    clearDBusArgInfoAnnotations             ,
#if defined(ENABLE_OVERLOADING)
    dBusArgInfo_annotations                 ,
#endif
    getDBusArgInfoAnnotations               ,
    setDBusArgInfoAnnotations               ,


-- ** name #attr:name#
-- | Name of the argument, e.g. /@unixUserId@/.

    clearDBusArgInfoName                    ,
#if defined(ENABLE_OVERLOADING)
    dBusArgInfo_name                        ,
#endif
    getDBusArgInfoName                      ,
    setDBusArgInfoName                      ,


-- ** refCount #attr:refCount#
-- | The reference count or -1 if statically allocated.

#if defined(ENABLE_OVERLOADING)
    dBusArgInfo_refCount                    ,
#endif
    getDBusArgInfoRefCount                  ,
    setDBusArgInfoRefCount                  ,


-- ** signature #attr:signature#
-- | D-Bus signature of the argument (a single complete type).

    clearDBusArgInfoSignature               ,
#if defined(ENABLE_OVERLOADING)
    dBusArgInfo_signature                   ,
#endif
    getDBusArgInfoSignature                 ,
    setDBusArgInfoSignature                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo

#else
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo

#endif

-- | Memory-managed wrapper type.
newtype DBusArgInfo = DBusArgInfo (SP.ManagedPtr DBusArgInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusArgInfo where
    toManagedPtr (DBusArgInfo p) = p

foreign import ccall "g_dbus_arg_info_get_type" c_g_dbus_arg_info_get_type :: 
    IO GType

type instance O.ParentTypes DBusArgInfo = '[]
instance O.HasParentTypes DBusArgInfo

instance B.Types.TypedObject DBusArgInfo where
    glibType = c_g_dbus_arg_info_get_type

instance B.Types.GBoxed DBusArgInfo

-- | Convert t'DBusArgInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusArgInfo) where
    gvalueGType_ = c_g_dbus_arg_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr DBusArgInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr DBusArgInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed DBusArgInfo ptr
        else return P.Nothing
        
    

-- | Construct a t'DBusArgInfo' struct initialized to zero.
newZeroDBusArgInfo :: MonadIO m => m DBusArgInfo
newZeroDBusArgInfo = liftIO $ callocBoxedBytes 32 >>= wrapBoxed DBusArgInfo

instance tag ~ 'AttrSet => Constructible DBusArgInfo tag where
    new _ attrs = do
        o <- newZeroDBusArgInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusArgInfo #refCount
-- @
getDBusArgInfoRefCount :: MonadIO m => DBusArgInfo -> m Int32
getDBusArgInfoRefCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusArgInfo [ #refCount 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusArgInfoRefCount :: MonadIO m => DBusArgInfo -> Int32 -> m ()
setDBusArgInfoRefCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusArgInfoRefCountFieldInfo
instance AttrInfo DBusArgInfoRefCountFieldInfo where
    type AttrBaseTypeConstraint DBusArgInfoRefCountFieldInfo = (~) DBusArgInfo
    type AttrAllowedOps DBusArgInfoRefCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusArgInfoRefCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusArgInfoRefCountFieldInfo = (~)Int32
    type AttrTransferType DBusArgInfoRefCountFieldInfo = Int32
    type AttrGetType DBusArgInfoRefCountFieldInfo = Int32
    type AttrLabel DBusArgInfoRefCountFieldInfo = "ref_count"
    type AttrOrigin DBusArgInfoRefCountFieldInfo = DBusArgInfo
    attrGet = getDBusArgInfoRefCount
    attrSet = setDBusArgInfoRefCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusArgInfo.refCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusArgInfo.html#g:attr:refCount"
        })

dBusArgInfo_refCount :: AttrLabelProxy "refCount"
dBusArgInfo_refCount = AttrLabelProxy

#endif


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusArgInfo #name
-- @
getDBusArgInfoName :: MonadIO m => DBusArgInfo -> m (Maybe T.Text)
getDBusArgInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusArgInfo [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusArgInfoName :: MonadIO m => DBusArgInfo -> CString -> m ()
setDBusArgInfoName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearDBusArgInfoName :: MonadIO m => DBusArgInfo -> m ()
clearDBusArgInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusArgInfoNameFieldInfo
instance AttrInfo DBusArgInfoNameFieldInfo where
    type AttrBaseTypeConstraint DBusArgInfoNameFieldInfo = (~) DBusArgInfo
    type AttrAllowedOps DBusArgInfoNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusArgInfoNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusArgInfoNameFieldInfo = (~)CString
    type AttrTransferType DBusArgInfoNameFieldInfo = CString
    type AttrGetType DBusArgInfoNameFieldInfo = Maybe T.Text
    type AttrLabel DBusArgInfoNameFieldInfo = "name"
    type AttrOrigin DBusArgInfoNameFieldInfo = DBusArgInfo
    attrGet = getDBusArgInfoName
    attrSet = setDBusArgInfoName
    attrConstruct = undefined
    attrClear = clearDBusArgInfoName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusArgInfo.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusArgInfo.html#g:attr:name"
        })

dBusArgInfo_name :: AttrLabelProxy "name"
dBusArgInfo_name = AttrLabelProxy

#endif


-- | Get the value of the “@signature@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusArgInfo #signature
-- @
getDBusArgInfoSignature :: MonadIO m => DBusArgInfo -> m (Maybe T.Text)
getDBusArgInfoSignature s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@signature@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusArgInfo [ #signature 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusArgInfoSignature :: MonadIO m => DBusArgInfo -> CString -> m ()
setDBusArgInfoSignature s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@signature@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #signature
-- @
clearDBusArgInfoSignature :: MonadIO m => DBusArgInfo -> m ()
clearDBusArgInfoSignature s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusArgInfoSignatureFieldInfo
instance AttrInfo DBusArgInfoSignatureFieldInfo where
    type AttrBaseTypeConstraint DBusArgInfoSignatureFieldInfo = (~) DBusArgInfo
    type AttrAllowedOps DBusArgInfoSignatureFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusArgInfoSignatureFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusArgInfoSignatureFieldInfo = (~)CString
    type AttrTransferType DBusArgInfoSignatureFieldInfo = CString
    type AttrGetType DBusArgInfoSignatureFieldInfo = Maybe T.Text
    type AttrLabel DBusArgInfoSignatureFieldInfo = "signature"
    type AttrOrigin DBusArgInfoSignatureFieldInfo = DBusArgInfo
    attrGet = getDBusArgInfoSignature
    attrSet = setDBusArgInfoSignature
    attrConstruct = undefined
    attrClear = clearDBusArgInfoSignature
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusArgInfo.signature"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusArgInfo.html#g:attr:signature"
        })

dBusArgInfo_signature :: AttrLabelProxy "signature"
dBusArgInfo_signature = AttrLabelProxy

#endif


-- | Get the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusArgInfo #annotations
-- @
getDBusArgInfoAnnotations :: MonadIO m => DBusArgInfo -> m (Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo])
getDBusArgInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusAnnotationInfo.DBusAnnotationInfo) val''
        return val'''
    return result

-- | Set the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusArgInfo [ #annotations 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusArgInfoAnnotations :: MonadIO m => DBusArgInfo -> Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo) -> m ()
setDBusArgInfoAnnotations s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

-- | Set the value of the “@annotations@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #annotations
-- @
clearDBusArgInfoAnnotations :: MonadIO m => DBusArgInfo -> m ()
clearDBusArgInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

#if defined(ENABLE_OVERLOADING)
data DBusArgInfoAnnotationsFieldInfo
instance AttrInfo DBusArgInfoAnnotationsFieldInfo where
    type AttrBaseTypeConstraint DBusArgInfoAnnotationsFieldInfo = (~) DBusArgInfo
    type AttrAllowedOps DBusArgInfoAnnotationsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusArgInfoAnnotationsFieldInfo = (~) (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferTypeConstraint DBusArgInfoAnnotationsFieldInfo = (~)(Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferType DBusArgInfoAnnotationsFieldInfo = (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrGetType DBusArgInfoAnnotationsFieldInfo = Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo]
    type AttrLabel DBusArgInfoAnnotationsFieldInfo = "annotations"
    type AttrOrigin DBusArgInfoAnnotationsFieldInfo = DBusArgInfo
    attrGet = getDBusArgInfoAnnotations
    attrSet = setDBusArgInfoAnnotations
    attrConstruct = undefined
    attrClear = clearDBusArgInfoAnnotations
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusArgInfo.annotations"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusArgInfo.html#g:attr:annotations"
        })

dBusArgInfo_annotations :: AttrLabelProxy "annotations"
dBusArgInfo_annotations = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusArgInfo
type instance O.AttributeList DBusArgInfo = DBusArgInfoAttributeList
type DBusArgInfoAttributeList = ('[ '("refCount", DBusArgInfoRefCountFieldInfo), '("name", DBusArgInfoNameFieldInfo), '("signature", DBusArgInfoSignatureFieldInfo), '("annotations", DBusArgInfoAnnotationsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method DBusArgInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusArgInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusArgInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "DBusArgInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_arg_info_ref" g_dbus_arg_info_ref :: 
    Ptr DBusArgInfo ->                      -- info : TInterface (Name {namespace = "Gio", name = "DBusArgInfo"})
    IO (Ptr DBusArgInfo)

-- | If /@info@/ is statically allocated does nothing. Otherwise increases
-- the reference count.
-- 
-- /Since: 2.26/
dBusArgInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusArgInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusArgInfo.DBusArgInfo'
    -> m DBusArgInfo
    -- ^ __Returns:__ The same /@info@/.
dBusArgInfoRef info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    result <- g_dbus_arg_info_ref info'
    checkUnexpectedReturnNULL "dBusArgInfoRef" result
    result' <- (wrapBoxed DBusArgInfo) result
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusArgInfoRefMethodInfo
instance (signature ~ (m DBusArgInfo), MonadIO m) => O.OverloadedMethod DBusArgInfoRefMethodInfo DBusArgInfo signature where
    overloadedMethod = dBusArgInfoRef

instance O.OverloadedMethodInfo DBusArgInfoRefMethodInfo DBusArgInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusArgInfo.dBusArgInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusArgInfo.html#v:dBusArgInfoRef"
        })


#endif

-- method DBusArgInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusArgInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusArgInfo." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_arg_info_unref" g_dbus_arg_info_unref :: 
    Ptr DBusArgInfo ->                      -- info : TInterface (Name {namespace = "Gio", name = "DBusArgInfo"})
    IO ()

-- | If /@info@/ is statically allocated, does nothing. Otherwise decreases
-- the reference count of /@info@/. When its reference count drops to 0,
-- the memory used is freed.
-- 
-- /Since: 2.26/
dBusArgInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusArgInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusArgInfo.DBusArgInfo'.
    -> m ()
dBusArgInfoUnref info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    g_dbus_arg_info_unref info'
    touchManagedPtr info
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusArgInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod DBusArgInfoUnrefMethodInfo DBusArgInfo signature where
    overloadedMethod = dBusArgInfoUnref

instance O.OverloadedMethodInfo DBusArgInfoUnrefMethodInfo DBusArgInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusArgInfo.dBusArgInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusArgInfo.html#v:dBusArgInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusArgInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusArgInfoMethod "ref" o = DBusArgInfoRefMethodInfo
    ResolveDBusArgInfoMethod "unref" o = DBusArgInfoUnrefMethodInfo
    ResolveDBusArgInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusArgInfoMethod t DBusArgInfo, O.OverloadedMethod info DBusArgInfo p) => OL.IsLabel t (DBusArgInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusArgInfoMethod t DBusArgInfo, O.OverloadedMethod info DBusArgInfo p, R.HasField t DBusArgInfo p) => R.HasField t DBusArgInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusArgInfoMethod t DBusArgInfo, O.OverloadedMethodInfo info DBusArgInfo) => OL.IsLabel t (O.MethodProxy info DBusArgInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


