/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// CapacityRequirementsApplyConfiguration represents a declarative configuration of the CapacityRequirements type for use
// with apply.
type CapacityRequirementsApplyConfiguration struct {
	Requests map[resourcev1beta2.QualifiedName]resource.Quantity `json:"requests,omitempty"`
}

// CapacityRequirementsApplyConfiguration constructs a declarative configuration of the CapacityRequirements type for use with
// apply.
func CapacityRequirements() *CapacityRequirementsApplyConfiguration {
	return &CapacityRequirementsApplyConfiguration{}
}

// WithRequests puts the entries into the Requests field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Requests field,
// overwriting an existing map entries in Requests field with the same key.
func (b *CapacityRequirementsApplyConfiguration) WithRequests(entries map[resourcev1beta2.QualifiedName]resource.Quantity) *CapacityRequirementsApplyConfiguration {
	if b.Requests == nil && len(entries) > 0 {
		b.Requests = make(map[resourcev1beta2.QualifiedName]resource.Quantity, len(entries))
	}
	for k, v := range entries {
		b.Requests[k] = v
	}
	return b
}
