/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// PodCertificateProjectionApplyConfiguration represents a declarative configuration of the PodCertificateProjection type for use
// with apply.
type PodCertificateProjectionApplyConfiguration struct {
	SignerName           *string `json:"signerName,omitempty"`
	KeyType              *string `json:"keyType,omitempty"`
	MaxExpirationSeconds *int32  `json:"maxExpirationSeconds,omitempty"`
	CredentialBundlePath *string `json:"credentialBundlePath,omitempty"`
	KeyPath              *string `json:"keyPath,omitempty"`
	CertificateChainPath *string `json:"certificateChainPath,omitempty"`
}

// PodCertificateProjectionApplyConfiguration constructs a declarative configuration of the PodCertificateProjection type for use with
// apply.
func PodCertificateProjection() *PodCertificateProjectionApplyConfiguration {
	return &PodCertificateProjectionApplyConfiguration{}
}

// WithSignerName sets the SignerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignerName field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithSignerName(value string) *PodCertificateProjectionApplyConfiguration {
	b.SignerName = &value
	return b
}

// WithKeyType sets the KeyType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeyType field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithKeyType(value string) *PodCertificateProjectionApplyConfiguration {
	b.KeyType = &value
	return b
}

// WithMaxExpirationSeconds sets the MaxExpirationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxExpirationSeconds field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithMaxExpirationSeconds(value int32) *PodCertificateProjectionApplyConfiguration {
	b.MaxExpirationSeconds = &value
	return b
}

// WithCredentialBundlePath sets the CredentialBundlePath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CredentialBundlePath field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithCredentialBundlePath(value string) *PodCertificateProjectionApplyConfiguration {
	b.CredentialBundlePath = &value
	return b
}

// WithKeyPath sets the KeyPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeyPath field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithKeyPath(value string) *PodCertificateProjectionApplyConfiguration {
	b.KeyPath = &value
	return b
}

// WithCertificateChainPath sets the CertificateChainPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CertificateChainPath field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithCertificateChainPath(value string) *PodCertificateProjectionApplyConfiguration {
	b.CertificateChainPath = &value
	return b
}
