/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ModifyVolumeStatusApplyConfiguration represents a declarative configuration of the ModifyVolumeStatus type for use
// with apply.
//
// ModifyVolumeStatus represents the status object of ControllerModifyVolume operation
type ModifyVolumeStatusApplyConfiguration struct {
	// targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
	TargetVolumeAttributesClassName *string `json:"targetVolumeAttributesClassName,omitempty"`
	// status is the status of the ControllerModifyVolume operation. It can be in any of following states:
	// - Pending
	// Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
	// the specified VolumeAttributesClass not existing.
	// - InProgress
	// InProgress indicates that the volume is being modified.
	// - Infeasible
	// Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
	// resolve the error, a valid VolumeAttributesClass needs to be specified.
	// Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
	Status *corev1.PersistentVolumeClaimModifyVolumeStatus `json:"status,omitempty"`
}

// ModifyVolumeStatusApplyConfiguration constructs a declarative configuration of the ModifyVolumeStatus type for use with
// apply.
func ModifyVolumeStatus() *ModifyVolumeStatusApplyConfiguration {
	return &ModifyVolumeStatusApplyConfiguration{}
}

// WithTargetVolumeAttributesClassName sets the TargetVolumeAttributesClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetVolumeAttributesClassName field is set to the value of the last call.
func (b *ModifyVolumeStatusApplyConfiguration) WithTargetVolumeAttributesClassName(value string) *ModifyVolumeStatusApplyConfiguration {
	b.TargetVolumeAttributesClassName = &value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *ModifyVolumeStatusApplyConfiguration) WithStatus(value corev1.PersistentVolumeClaimModifyVolumeStatus) *ModifyVolumeStatusApplyConfiguration {
	b.Status = &value
	return b
}
