/* animate-timer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from animate-timer.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#define ANIMATE_TIMER_INSTANT 150
#define ANIMATE_TIMER_FAST 250
#define ANIMATE_TIMER_NORMAL 500
#define ANIMATE_TIMER_SLOW 1000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;
typedef struct _AnimateTimerPrivate AnimateTimerPrivate;
typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, gpointer user_data);
enum  {
	ANIMATE_TIMER_0_PROPERTY,
	ANIMATE_TIMER_SPEED_PROPERTY,
	ANIMATE_TIMER_IS_RUNNING_PROPERTY,
	ANIMATE_TIMER_PROGRESS_PROPERTY,
	ANIMATE_TIMER_NUM_PROPERTIES
};
static GParamSpec* animate_timer_properties[ANIMATE_TIMER_NUM_PROPERTIES];
enum  {
	ANIMATE_TIMER_ANIMATE_SIGNAL,
	ANIMATE_TIMER_NUM_SIGNALS
};
static guint animate_timer_signals[ANIMATE_TIMER_NUM_SIGNALS] = {0};

struct _AnimateTimer {
	GObject parent_instance;
	AnimateTimerPrivate * priv;
};

struct _AnimateTimerClass {
	GObjectClass parent_class;
};

struct _AnimateTimerPrivate {
	AnimateTimerEasingFunc _easing_func;
	gpointer _easing_func_target;
	gint _speed;
	gdouble _progress;
	guint timeout;
	GTimeSpan start_time;
	GTimeSpan length;
	GTimeSpan extra_time;
	gdouble extra_progress;
};

static gint AnimateTimer_private_offset;
static gpointer animate_timer_parent_class = NULL;

VALA_EXTERN GType animate_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimateTimer, g_object_unref)
VALA_EXTERN void animate_timer_stop (AnimateTimer* self);
VALA_EXTERN AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func,
                                 gpointer func_target,
                                 gint speed);
VALA_EXTERN AnimateTimer* animate_timer_construct (GType object_type,
                                       AnimateTimerEasingFunc func,
                                       gpointer func_target,
                                       gint speed);
static void animate_timer_set_easing_func (AnimateTimer* self,
                                    AnimateTimerEasingFunc value,
                                    gpointer value_target);
VALA_EXTERN void animate_timer_reset (AnimateTimer* self,
                          gint temp_speed);
static gboolean animate_timer_animate_cb (AnimateTimer* self);
static gboolean _animate_timer_animate_cb_gsource_func (gpointer self);
static void animate_timer_set_progress (AnimateTimer* self,
                                 gdouble value);
VALA_EXTERN gint animate_timer_get_speed (AnimateTimer* self);
static gdouble animate_timer_normalize_time (AnimateTimer* self,
                                      GTimeSpan now);
static gdouble animate_timer_calculate_progress (AnimateTimer* self,
                                          gdouble time_progress);
VALA_EXTERN gdouble animate_timer_get_progress (AnimateTimer* self);
VALA_EXTERN AnimateTimerEasingFunc animate_timer_get_easing_func (AnimateTimer* self,
                                                      gpointer* result_target);
VALA_EXTERN gdouble animate_timer_ease_in_out (gdouble x);
VALA_EXTERN gdouble animate_timer_ease_out_quint (gdouble x);
VALA_EXTERN void animate_timer_set_speed (AnimateTimer* self,
                              gint value);
VALA_EXTERN gboolean animate_timer_get_is_running (AnimateTimer* self);
static void animate_timer_finalize (GObject * obj);
static GType animate_timer_get_type_once (void);
static void _vala_animate_timer_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_animate_timer_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
animate_timer_get_instance_private (AnimateTimer* self)
{
	return G_STRUCT_MEMBER_P (self, AnimateTimer_private_offset);
}

AnimateTimer*
animate_timer_construct (GType object_type,
                         AnimateTimerEasingFunc func,
                         gpointer func_target,
                         gint speed)
{
	AnimateTimer * self = NULL;
#line 57 "../src/animate-timer.vala"
	self = (AnimateTimer*) g_object_new (object_type, "speed", speed, NULL);
#line 58 "../src/animate-timer.vala"
	animate_timer_set_easing_func (self, func, func_target);
#line 55 "../src/animate-timer.vala"
	return self;
#line 163 "animate-timer.c"
}

AnimateTimer*
animate_timer_new (AnimateTimerEasingFunc func,
                   gpointer func_target,
                   gint speed)
{
#line 55 "../src/animate-timer.vala"
	return animate_timer_construct (TYPE_ANIMATE_TIMER, func, func_target, speed);
#line 173 "animate-timer.c"
}

static gboolean
_animate_timer_animate_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = animate_timer_animate_cb ((AnimateTimer*) self);
#line 71 "../src/animate-timer.vala"
	return result;
#line 183 "animate-timer.c"
}

void
animate_timer_reset (AnimateTimer* self,
                     gint temp_speed)
{
#line 67 "../src/animate-timer.vala"
	g_return_if_fail (self != NULL);
#line 69 "../src/animate-timer.vala"
	animate_timer_stop (self);
#line 71 "../src/animate-timer.vala"
	self->priv->timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 16, _animate_timer_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 72 "../src/animate-timer.vala"
	animate_timer_set_progress (self, (gdouble) 0);
#line 73 "../src/animate-timer.vala"
	self->priv->start_time = (GTimeSpan) 0;
#line 74 "../src/animate-timer.vala"
	self->priv->extra_time = (GTimeSpan) 0;
#line 75 "../src/animate-timer.vala"
	self->priv->extra_progress = (gdouble) 0;
#line 77 "../src/animate-timer.vala"
	if (temp_speed == -1) {
#line 206 "animate-timer.c"
		gint _tmp0_;
#line 78 "../src/animate-timer.vala"
		_tmp0_ = self->priv->_speed;
#line 78 "../src/animate-timer.vala"
		temp_speed = _tmp0_;
#line 212 "animate-timer.c"
	}
#line 80 "../src/animate-timer.vala"
	self->priv->length = temp_speed * G_TIME_SPAN_MILLISECOND;
#line 216 "animate-timer.c"
}

void
animate_timer_stop (AnimateTimer* self)
{
#line 83 "../src/animate-timer.vala"
	g_return_if_fail (self != NULL);
#line 85 "../src/animate-timer.vala"
	if (self->priv->timeout != ((guint) 0)) {
#line 86 "../src/animate-timer.vala"
		g_source_remove (self->priv->timeout);
#line 228 "animate-timer.c"
	}
#line 87 "../src/animate-timer.vala"
	self->priv->timeout = (guint) 0;
#line 232 "animate-timer.c"
}

static gboolean
animate_timer_animate_cb (AnimateTimer* self)
{
	gdouble time_progress = 0.0;
	gdouble _tmp0_;
	gboolean result;
#line 96 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "../src/animate-timer.vala"
	if (self->priv->start_time == ((GTimeSpan) 0)) {
#line 99 "../src/animate-timer.vala"
		self->priv->start_time = (GTimeSpan) g_get_monotonic_time ();
#line 247 "animate-timer.c"
	}
#line 101 "../src/animate-timer.vala"
	time_progress = animate_timer_normalize_time (self, (GTimeSpan) g_get_monotonic_time ());
#line 102 "../src/animate-timer.vala"
	animate_timer_set_progress (self, animate_timer_calculate_progress (self, time_progress));
#line 103 "../src/animate-timer.vala"
	_tmp0_ = self->priv->_progress;
#line 103 "../src/animate-timer.vala"
	g_signal_emit (self, animate_timer_signals[ANIMATE_TIMER_ANIMATE_SIGNAL], 0, _tmp0_);
#line 105 "../src/animate-timer.vala"
	if (time_progress >= 1.0) {
#line 107 "../src/animate-timer.vala"
		self->priv->timeout = (guint) 0;
#line 108 "../src/animate-timer.vala"
		result = FALSE;
#line 108 "../src/animate-timer.vala"
		return result;
#line 265 "animate-timer.c"
	} else {
#line 111 "../src/animate-timer.vala"
		result = TRUE;
#line 111 "../src/animate-timer.vala"
		return result;
#line 271 "animate-timer.c"
	}
}

static gdouble
animate_timer_normalize_time (AnimateTimer* self,
                              GTimeSpan now)
{
	gdouble result;
#line 115 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 117 "../src/animate-timer.vala"
	if (self->priv->length == ((GTimeSpan) 0)) {
#line 118 "../src/animate-timer.vala"
		result = (gdouble) 1.0f;
#line 118 "../src/animate-timer.vala"
		return result;
#line 288 "animate-timer.c"
	}
#line 120 "../src/animate-timer.vala"
	result = CLAMP (((gdouble) (now - self->priv->start_time)) / self->priv->length, 0.0, 1.0);
#line 120 "../src/animate-timer.vala"
	return result;
#line 294 "animate-timer.c"
}

static gdouble
animate_timer_calculate_progress (AnimateTimer* self,
                                  gdouble time_progress)
{
	gdouble y = 0.0;
	AnimateTimerEasingFunc _tmp0_ = NULL;
	gpointer _tmp0__target = NULL;
	AnimateTimerEasingFunc _tmp1_;
	gpointer _tmp1__target;
	gdouble result;
#line 125 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 127 "../src/animate-timer.vala"
	_tmp0_ = animate_timer_get_easing_func (self, &_tmp0__target);
#line 127 "../src/animate-timer.vala"
	_tmp1_ = _tmp0_;
#line 127 "../src/animate-timer.vala"
	_tmp1__target = _tmp0__target;
#line 127 "../src/animate-timer.vala"
	y = _tmp1_ (time_progress, _tmp1__target);
#line 128 "../src/animate-timer.vala"
	result = CLAMP (y, 0.0, 1.0);
#line 128 "../src/animate-timer.vala"
	return result;
#line 321 "animate-timer.c"
}

gdouble
animate_timer_ease_in_out (gdouble x)
{
	gdouble result;
#line 133 "../src/animate-timer.vala"
	result = (1 - cos (G_PI * x)) / 2;
#line 133 "../src/animate-timer.vala"
	return result;
#line 332 "animate-timer.c"
}

gdouble
animate_timer_ease_out_quint (gdouble x)
{
	gdouble result;
#line 151 "../src/animate-timer.vala"
	result = pow (x - 1, (gdouble) 5) + 1;
#line 151 "../src/animate-timer.vala"
	return result;
#line 343 "animate-timer.c"
}

AnimateTimerEasingFunc
animate_timer_get_easing_func (AnimateTimer* self,
                               gpointer* result_target)
{
	AnimateTimerEasingFunc result;
	AnimateTimerEasingFunc _tmp0_;
	gpointer _tmp0__target;
	AnimateTimerEasingFunc _tmp1_;
	gpointer _tmp1__target;
#line 33 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "../src/animate-timer.vala"
	_tmp0_ = self->priv->_easing_func;
#line 33 "../src/animate-timer.vala"
	_tmp0__target = self->priv->_easing_func_target;
#line 33 "../src/animate-timer.vala"
	_tmp1_ = _tmp0_;
#line 33 "../src/animate-timer.vala"
	_tmp1__target = _tmp0__target;
#line 33 "../src/animate-timer.vala"
	*result_target = _tmp1__target;
#line 33 "../src/animate-timer.vala"
	result = _tmp1_;
#line 33 "../src/animate-timer.vala"
	return result;
#line 371 "animate-timer.c"
}

static void
animate_timer_set_easing_func (AnimateTimer* self,
                               AnimateTimerEasingFunc value,
                               gpointer value_target)
{
#line 33 "../src/animate-timer.vala"
	g_return_if_fail (self != NULL);
#line 33 "../src/animate-timer.vala"
	self->priv->_easing_func = value;
#line 33 "../src/animate-timer.vala"
	self->priv->_easing_func_target = value_target;
#line 385 "animate-timer.c"
}

gint
animate_timer_get_speed (AnimateTimer* self)
{
	gint result;
#line 34 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "../src/animate-timer.vala"
	result = self->priv->_speed;
#line 34 "../src/animate-timer.vala"
	return result;
#line 398 "animate-timer.c"
}

void
animate_timer_set_speed (AnimateTimer* self,
                         gint value)
{
	gint old_value;
#line 34 "../src/animate-timer.vala"
	g_return_if_fail (self != NULL);
#line 34 "../src/animate-timer.vala"
	old_value = animate_timer_get_speed (self);
#line 34 "../src/animate-timer.vala"
	if (old_value != value) {
#line 34 "../src/animate-timer.vala"
		self->priv->_speed = value;
#line 34 "../src/animate-timer.vala"
		g_object_notify_by_pspec ((GObject *) self, animate_timer_properties[ANIMATE_TIMER_SPEED_PROPERTY]);
#line 416 "animate-timer.c"
	}
}

gboolean
animate_timer_get_is_running (AnimateTimer* self)
{
	gboolean result;
#line 35 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 35 "../src/animate-timer.vala"
	result = self->priv->timeout != ((guint) 0);
#line 35 "../src/animate-timer.vala"
	return result;
#line 430 "animate-timer.c"
}

gdouble
animate_timer_get_progress (AnimateTimer* self)
{
	gdouble result;
#line 36 "../src/animate-timer.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 36 "../src/animate-timer.vala"
	result = self->priv->_progress;
#line 36 "../src/animate-timer.vala"
	return result;
#line 443 "animate-timer.c"
}

static void
animate_timer_set_progress (AnimateTimer* self,
                            gdouble value)
{
	gdouble old_value;
#line 36 "../src/animate-timer.vala"
	g_return_if_fail (self != NULL);
#line 36 "../src/animate-timer.vala"
	old_value = animate_timer_get_progress (self);
#line 36 "../src/animate-timer.vala"
	if (old_value != value) {
#line 36 "../src/animate-timer.vala"
		self->priv->_progress = value;
#line 36 "../src/animate-timer.vala"
		g_object_notify_by_pspec ((GObject *) self, animate_timer_properties[ANIMATE_TIMER_PROGRESS_PROPERTY]);
#line 461 "animate-timer.c"
	}
}

static void
animate_timer_class_init (AnimateTimerClass * klass,
                          gpointer klass_data)
{
#line 21 "../src/animate-timer.vala"
	animate_timer_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/animate-timer.vala"
	g_type_class_adjust_private_offset (klass, &AnimateTimer_private_offset);
#line 21 "../src/animate-timer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_animate_timer_get_property;
#line 21 "../src/animate-timer.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_animate_timer_set_property;
#line 21 "../src/animate-timer.vala"
	G_OBJECT_CLASS (klass)->finalize = animate_timer_finalize;
#line 21 "../src/animate-timer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATE_TIMER_SPEED_PROPERTY, animate_timer_properties[ANIMATE_TIMER_SPEED_PROPERTY] = g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "../src/animate-timer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATE_TIMER_IS_RUNNING_PROPERTY, animate_timer_properties[ANIMATE_TIMER_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 21 "../src/animate-timer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATE_TIMER_PROGRESS_PROPERTY, animate_timer_properties[ANIMATE_TIMER_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 21 "../src/animate-timer.vala"
	animate_timer_signals[ANIMATE_TIMER_ANIMATE_SIGNAL] = g_signal_new ("animate", TYPE_ANIMATE_TIMER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
#line 487 "animate-timer.c"
}

static void
animate_timer_instance_init (AnimateTimer * self,
                             gpointer klass)
{
#line 21 "../src/animate-timer.vala"
	self->priv = animate_timer_get_instance_private (self);
#line 90 "../src/animate-timer.vala"
	self->priv->timeout = (guint) 0;
#line 91 "../src/animate-timer.vala"
	self->priv->start_time = (GTimeSpan) 0;
#line 92 "../src/animate-timer.vala"
	self->priv->length = (GTimeSpan) 0;
#line 93 "../src/animate-timer.vala"
	self->priv->extra_time = (GTimeSpan) 0;
#line 94 "../src/animate-timer.vala"
	self->priv->extra_progress = 0.0;
#line 506 "animate-timer.c"
}

static void
animate_timer_finalize (GObject * obj)
{
	AnimateTimer * self;
#line 21 "../src/animate-timer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATE_TIMER, AnimateTimer);
#line 63 "../src/animate-timer.vala"
	animate_timer_stop (self);
#line 21 "../src/animate-timer.vala"
	G_OBJECT_CLASS (animate_timer_parent_class)->finalize (obj);
#line 519 "animate-timer.c"
}

static GType
animate_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimateTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animate_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimateTimer), 0, (GInstanceInitFunc) animate_timer_instance_init, NULL };
	GType animate_timer_type_id;
	animate_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "AnimateTimer", &g_define_type_info, 0);
	AnimateTimer_private_offset = g_type_add_instance_private (animate_timer_type_id, sizeof (AnimateTimerPrivate));
	return animate_timer_type_id;
}

GType
animate_timer_get_type (void)
{
	static volatile gsize animate_timer_type_id__once = 0;
	if (g_once_init_enter (&animate_timer_type_id__once)) {
		GType animate_timer_type_id;
		animate_timer_type_id = animate_timer_get_type_once ();
		g_once_init_leave (&animate_timer_type_id__once, animate_timer_type_id);
	}
	return animate_timer_type_id__once;
}

static void
_vala_animate_timer_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	AnimateTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATE_TIMER, AnimateTimer);
#line 21 "../src/animate-timer.vala"
	switch (property_id) {
#line 21 "../src/animate-timer.vala"
		case ANIMATE_TIMER_SPEED_PROPERTY:
#line 21 "../src/animate-timer.vala"
		g_value_set_int (value, animate_timer_get_speed (self));
#line 21 "../src/animate-timer.vala"
		break;
#line 21 "../src/animate-timer.vala"
		case ANIMATE_TIMER_IS_RUNNING_PROPERTY:
#line 21 "../src/animate-timer.vala"
		g_value_set_boolean (value, animate_timer_get_is_running (self));
#line 21 "../src/animate-timer.vala"
		break;
#line 21 "../src/animate-timer.vala"
		case ANIMATE_TIMER_PROGRESS_PROPERTY:
#line 21 "../src/animate-timer.vala"
		g_value_set_double (value, animate_timer_get_progress (self));
#line 21 "../src/animate-timer.vala"
		break;
#line 572 "animate-timer.c"
		default:
#line 21 "../src/animate-timer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "../src/animate-timer.vala"
		break;
#line 578 "animate-timer.c"
	}
}

static void
_vala_animate_timer_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	AnimateTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATE_TIMER, AnimateTimer);
#line 21 "../src/animate-timer.vala"
	switch (property_id) {
#line 21 "../src/animate-timer.vala"
		case ANIMATE_TIMER_SPEED_PROPERTY:
#line 21 "../src/animate-timer.vala"
		animate_timer_set_speed (self, g_value_get_int (value));
#line 21 "../src/animate-timer.vala"
		break;
#line 21 "../src/animate-timer.vala"
		case ANIMATE_TIMER_PROGRESS_PROPERTY:
#line 21 "../src/animate-timer.vala"
		animate_timer_set_progress (self, g_value_get_double (value));
#line 21 "../src/animate-timer.vala"
		break;
#line 604 "animate-timer.c"
		default:
#line 21 "../src/animate-timer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "../src/animate-timer.vala"
		break;
#line 610 "animate-timer.c"
	}
}

