/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/DataRefactoring/MultiDimension/DataRefactoring.hpp"
// clang-format off
namespace mgard_x {

namespace data_refactoring {

namespace multi_dimension {

template void recompose<4, float, OPENMP>(
    Hierarchy<4, float, OPENMP> &hierarchy,
    SubArray<4, float, OPENMP> &v,
    SubArray<4, float, OPENMP> w,
    SubArray<4, float, OPENMP> b, 
    int start_level, int stop_level, int queue_idx);

} // namespace multi_dimension

} // namespace data_refactoring

} // namespace mgard_x// clang-format on
