// IWYU pragma: private, include "nvim/option_defs.h"

typedef enum {
  kOptInvalid = -1,
  kOptAleph = 0,
  kOptAllowrevins = 1,
  kOptAmbiwidth = 2,
  kOptArabic = 3,
  kOptArabicshape = 4,
  kOptAutochdir = 5,
  kOptAutoindent = 6,
  kOptAutoread = 7,
  kOptAutowrite = 8,
  kOptAutowriteall = 9,
  kOptBackground = 10,
  kOptBackspace = 11,
  kOptBackup = 12,
  kOptBackupcopy = 13,
  kOptBackupdir = 14,
  kOptBackupext = 15,
  kOptBackupskip = 16,
  kOptBelloff = 17,
  kOptBinary = 18,
  kOptBomb = 19,
  kOptBreakat = 20,
  kOptBreakindent = 21,
  kOptBreakindentopt = 22,
  kOptBrowsedir = 23,
  kOptBufhidden = 24,
  kOptBuflisted = 25,
  kOptBuftype = 26,
  kOptCasemap = 27,
  kOptCdhome = 28,
  kOptCdpath = 29,
  kOptCedit = 30,
  kOptChannel = 31,
  kOptCharconvert = 32,
  kOptCindent = 33,
  kOptCinkeys = 34,
  kOptCinoptions = 35,
  kOptCinscopedecls = 36,
  kOptCinwords = 37,
  kOptClipboard = 38,
  kOptCmdheight = 39,
  kOptCmdwinheight = 40,
  kOptColorcolumn = 41,
  kOptColumns = 42,
  kOptComments = 43,
  kOptCommentstring = 44,
  kOptCompatible = 45,
  kOptComplete = 46,
  kOptCompletefunc = 47,
  kOptCompleteitemalign = 48,
  kOptCompleteopt = 49,
  kOptCompleteslash = 50,
  kOptConcealcursor = 51,
  kOptConceallevel = 52,
  kOptConfirm = 53,
  kOptCopyindent = 54,
  kOptCpoptions = 55,
  kOptCursorbind = 56,
  kOptCursorcolumn = 57,
  kOptCursorline = 58,
  kOptCursorlineopt = 59,
  kOptDebug = 60,
  kOptDefine = 61,
  kOptDelcombine = 62,
  kOptDictionary = 63,
  kOptDiff = 64,
  kOptDiffexpr = 65,
  kOptDiffopt = 66,
  kOptDigraph = 67,
  kOptDirectory = 68,
  kOptDisplay = 69,
  kOptEadirection = 70,
  kOptEdcompatible = 71,
  kOptEmoji = 72,
  kOptEncoding = 73,
  kOptEndoffile = 74,
  kOptEndofline = 75,
  kOptEqualalways = 76,
  kOptEqualprg = 77,
  kOptErrorbells = 78,
  kOptErrorfile = 79,
  kOptErrorformat = 80,
  kOptEventignore = 81,
  kOptEventignorewin = 82,
  kOptExpandtab = 83,
  kOptExrc = 84,
  kOptFileencoding = 85,
  kOptFileencodings = 86,
  kOptFileformat = 87,
  kOptFileformats = 88,
  kOptFileignorecase = 89,
  kOptFiletype = 90,
  kOptFillchars = 91,
  kOptFindfunc = 92,
  kOptFixendofline = 93,
  kOptFoldclose = 94,
  kOptFoldcolumn = 95,
  kOptFoldenable = 96,
  kOptFoldexpr = 97,
  kOptFoldignore = 98,
  kOptFoldlevel = 99,
  kOptFoldlevelstart = 100,
  kOptFoldmarker = 101,
  kOptFoldmethod = 102,
  kOptFoldminlines = 103,
  kOptFoldnestmax = 104,
  kOptFoldopen = 105,
  kOptFoldtext = 106,
  kOptFormatexpr = 107,
  kOptFormatlistpat = 108,
  kOptFormatoptions = 109,
  kOptFormatprg = 110,
  kOptFsync = 111,
  kOptGdefault = 112,
  kOptGrepformat = 113,
  kOptGrepprg = 114,
  kOptGuicursor = 115,
  kOptGuifont = 116,
  kOptGuifontwide = 117,
  kOptGuioptions = 118,
  kOptGuitablabel = 119,
  kOptGuitabtooltip = 120,
  kOptHelpfile = 121,
  kOptHelpheight = 122,
  kOptHelplang = 123,
  kOptHidden = 124,
  kOptHighlight = 125,
  kOptHistory = 126,
  kOptHkmap = 127,
  kOptHkmapp = 128,
  kOptHlsearch = 129,
  kOptIcon = 130,
  kOptIconstring = 131,
  kOptIgnorecase = 132,
  kOptImcmdline = 133,
  kOptImdisable = 134,
  kOptIminsert = 135,
  kOptImsearch = 136,
  kOptInccommand = 137,
  kOptInclude = 138,
  kOptIncludeexpr = 139,
  kOptIncsearch = 140,
  kOptIndentexpr = 141,
  kOptIndentkeys = 142,
  kOptInfercase = 143,
  kOptInsertmode = 144,
  kOptIsfname = 145,
  kOptIsident = 146,
  kOptIskeyword = 147,
  kOptIsprint = 148,
  kOptJoinspaces = 149,
  kOptJumpoptions = 150,
  kOptKeymap = 151,
  kOptKeymodel = 152,
  kOptKeywordprg = 153,
  kOptLangmap = 154,
  kOptLangmenu = 155,
  kOptLangnoremap = 156,
  kOptLangremap = 157,
  kOptLaststatus = 158,
  kOptLazyredraw = 159,
  kOptLinebreak = 160,
  kOptLines = 161,
  kOptLinespace = 162,
  kOptLisp = 163,
  kOptLispoptions = 164,
  kOptLispwords = 165,
  kOptList = 166,
  kOptListchars = 167,
  kOptLoadplugins = 168,
  kOptMagic = 169,
  kOptMakeef = 170,
  kOptMakeencoding = 171,
  kOptMakeprg = 172,
  kOptMatchpairs = 173,
  kOptMatchtime = 174,
  kOptMaxcombine = 175,
  kOptMaxfuncdepth = 176,
  kOptMaxmapdepth = 177,
  kOptMaxmempattern = 178,
  kOptMenuitems = 179,
  kOptMessagesopt = 180,
  kOptMkspellmem = 181,
  kOptModeline = 182,
  kOptModelineexpr = 183,
  kOptModelines = 184,
  kOptModifiable = 185,
  kOptModified = 186,
  kOptMore = 187,
  kOptMouse = 188,
  kOptMousefocus = 189,
  kOptMousehide = 190,
  kOptMousemodel = 191,
  kOptMousemoveevent = 192,
  kOptMousescroll = 193,
  kOptMouseshape = 194,
  kOptMousetime = 195,
  kOptNrformats = 196,
  kOptNumber = 197,
  kOptNumberwidth = 198,
  kOptOmnifunc = 199,
  kOptOpendevice = 200,
  kOptOperatorfunc = 201,
  kOptPackpath = 202,
  kOptParagraphs = 203,
  kOptPaste = 204,
  kOptPastetoggle = 205,
  kOptPatchexpr = 206,
  kOptPatchmode = 207,
  kOptPath = 208,
  kOptPreserveindent = 209,
  kOptPreviewheight = 210,
  kOptPreviewwindow = 211,
  kOptPrompt = 212,
  kOptPumblend = 213,
  kOptPumheight = 214,
  kOptPumwidth = 215,
  kOptPyxversion = 216,
  kOptQuickfixtextfunc = 217,
  kOptQuoteescape = 218,
  kOptReadonly = 219,
  kOptRedrawdebug = 220,
  kOptRedrawtime = 221,
  kOptRegexpengine = 222,
  kOptRelativenumber = 223,
  kOptRemap = 224,
  kOptReport = 225,
  kOptRevins = 226,
  kOptRightleft = 227,
  kOptRightleftcmd = 228,
  kOptRuler = 229,
  kOptRulerformat = 230,
  kOptRuntimepath = 231,
  kOptScroll = 232,
  kOptScrollback = 233,
  kOptScrollbind = 234,
  kOptScrolljump = 235,
  kOptScrolloff = 236,
  kOptScrollopt = 237,
  kOptSections = 238,
  kOptSecure = 239,
  kOptSelection = 240,
  kOptSelectmode = 241,
  kOptSessionoptions = 242,
  kOptShada = 243,
  kOptShadafile = 244,
  kOptShell = 245,
  kOptShellcmdflag = 246,
  kOptShellpipe = 247,
  kOptShellquote = 248,
  kOptShellredir = 249,
  kOptShellslash = 250,
  kOptShelltemp = 251,
  kOptShellxescape = 252,
  kOptShellxquote = 253,
  kOptShiftround = 254,
  kOptShiftwidth = 255,
  kOptShortmess = 256,
  kOptShowbreak = 257,
  kOptShowcmd = 258,
  kOptShowcmdloc = 259,
  kOptShowfulltag = 260,
  kOptShowmatch = 261,
  kOptShowmode = 262,
  kOptShowtabline = 263,
  kOptSidescroll = 264,
  kOptSidescrolloff = 265,
  kOptSigncolumn = 266,
  kOptSmartcase = 267,
  kOptSmartindent = 268,
  kOptSmarttab = 269,
  kOptSmoothscroll = 270,
  kOptSofttabstop = 271,
  kOptSpell = 272,
  kOptSpellcapcheck = 273,
  kOptSpellfile = 274,
  kOptSpelllang = 275,
  kOptSpelloptions = 276,
  kOptSpellsuggest = 277,
  kOptSplitbelow = 278,
  kOptSplitkeep = 279,
  kOptSplitright = 280,
  kOptStartofline = 281,
  kOptStatuscolumn = 282,
  kOptStatusline = 283,
  kOptSuffixes = 284,
  kOptSuffixesadd = 285,
  kOptSwapfile = 286,
  kOptSwitchbuf = 287,
  kOptSynmaxcol = 288,
  kOptSyntax = 289,
  kOptTabclose = 290,
  kOptTabline = 291,
  kOptTabpagemax = 292,
  kOptTabstop = 293,
  kOptTagbsearch = 294,
  kOptTagcase = 295,
  kOptTagfunc = 296,
  kOptTaglength = 297,
  kOptTagrelative = 298,
  kOptTags = 299,
  kOptTagstack = 300,
  kOptTermbidi = 301,
  kOptTermencoding = 302,
  kOptTermguicolors = 303,
  kOptTermpastefilter = 304,
  kOptTermsync = 305,
  kOptTerse = 306,
  kOptTextwidth = 307,
  kOptThesaurus = 308,
  kOptThesaurusfunc = 309,
  kOptTildeop = 310,
  kOptTimeout = 311,
  kOptTimeoutlen = 312,
  kOptTitle = 313,
  kOptTitlelen = 314,
  kOptTitleold = 315,
  kOptTitlestring = 316,
  kOptTtimeout = 317,
  kOptTtimeoutlen = 318,
  kOptTtyfast = 319,
  kOptUndodir = 320,
  kOptUndofile = 321,
  kOptUndolevels = 322,
  kOptUndoreload = 323,
  kOptUpdatecount = 324,
  kOptUpdatetime = 325,
  kOptVarsofttabstop = 326,
  kOptVartabstop = 327,
  kOptVerbose = 328,
  kOptVerbosefile = 329,
  kOptViewdir = 330,
  kOptViewoptions = 331,
  kOptVirtualedit = 332,
  kOptVisualbell = 333,
  kOptWarn = 334,
  kOptWhichwrap = 335,
  kOptWildchar = 336,
  kOptWildcharm = 337,
  kOptWildignore = 338,
  kOptWildignorecase = 339,
  kOptWildmenu = 340,
  kOptWildmode = 341,
  kOptWildoptions = 342,
  kOptWinaltkeys = 343,
  kOptWinbar = 344,
  kOptWinblend = 345,
  kOptWinborder = 346,
  kOptWindow = 347,
  kOptWinfixbuf = 348,
  kOptWinfixheight = 349,
  kOptWinfixwidth = 350,
  kOptWinheight = 351,
  kOptWinhighlight = 352,
  kOptWinminheight = 353,
  kOptWinminwidth = 354,
  kOptWinwidth = 355,
  kOptWrap = 356,
  kOptWrapmargin = 357,
  kOptWrapscan = 358,
  kOptWrite = 359,
  kOptWriteany = 360,
  kOptWritebackup = 361,
  kOptWritedelay = 362,
  // Option count
#define kOptCount 363
} OptIndex;

typedef enum {
  kGlobalOptInvalid = -1,
  kGlobalOptAleph = 0,
  kGlobalOptAllowrevins = 1,
  kGlobalOptAmbiwidth = 2,
  kGlobalOptArabicshape = 3,
  kGlobalOptAutochdir = 4,
  kGlobalOptAutoread = 5,
  kGlobalOptAutowrite = 6,
  kGlobalOptAutowriteall = 7,
  kGlobalOptBackground = 8,
  kGlobalOptBackspace = 9,
  kGlobalOptBackup = 10,
  kGlobalOptBackupcopy = 11,
  kGlobalOptBackupdir = 12,
  kGlobalOptBackupext = 13,
  kGlobalOptBackupskip = 14,
  kGlobalOptBelloff = 15,
  kGlobalOptBreakat = 16,
  kGlobalOptBrowsedir = 17,
  kGlobalOptCasemap = 18,
  kGlobalOptCdhome = 19,
  kGlobalOptCdpath = 20,
  kGlobalOptCedit = 21,
  kGlobalOptCharconvert = 22,
  kGlobalOptClipboard = 23,
  kGlobalOptCmdheight = 24,
  kGlobalOptCmdwinheight = 25,
  kGlobalOptColumns = 26,
  kGlobalOptCompatible = 27,
  kGlobalOptCompleteitemalign = 28,
  kGlobalOptCompleteopt = 29,
  kGlobalOptConfirm = 30,
  kGlobalOptCpoptions = 31,
  kGlobalOptDebug = 32,
  kGlobalOptDefine = 33,
  kGlobalOptDelcombine = 34,
  kGlobalOptDictionary = 35,
  kGlobalOptDiffexpr = 36,
  kGlobalOptDiffopt = 37,
  kGlobalOptDigraph = 38,
  kGlobalOptDirectory = 39,
  kGlobalOptDisplay = 40,
  kGlobalOptEadirection = 41,
  kGlobalOptEdcompatible = 42,
  kGlobalOptEmoji = 43,
  kGlobalOptEncoding = 44,
  kGlobalOptEqualalways = 45,
  kGlobalOptEqualprg = 46,
  kGlobalOptErrorbells = 47,
  kGlobalOptErrorfile = 48,
  kGlobalOptErrorformat = 49,
  kGlobalOptEventignore = 50,
  kGlobalOptExrc = 51,
  kGlobalOptFileencodings = 52,
  kGlobalOptFileformats = 53,
  kGlobalOptFileignorecase = 54,
  kGlobalOptFillchars = 55,
  kGlobalOptFindfunc = 56,
  kGlobalOptFoldclose = 57,
  kGlobalOptFoldlevelstart = 58,
  kGlobalOptFoldopen = 59,
  kGlobalOptFormatprg = 60,
  kGlobalOptFsync = 61,
  kGlobalOptGdefault = 62,
  kGlobalOptGrepformat = 63,
  kGlobalOptGrepprg = 64,
  kGlobalOptGuicursor = 65,
  kGlobalOptGuifont = 66,
  kGlobalOptGuifontwide = 67,
  kGlobalOptGuioptions = 68,
  kGlobalOptGuitablabel = 69,
  kGlobalOptGuitabtooltip = 70,
  kGlobalOptHelpfile = 71,
  kGlobalOptHelpheight = 72,
  kGlobalOptHelplang = 73,
  kGlobalOptHidden = 74,
  kGlobalOptHighlight = 75,
  kGlobalOptHistory = 76,
  kGlobalOptHkmap = 77,
  kGlobalOptHkmapp = 78,
  kGlobalOptHlsearch = 79,
  kGlobalOptIcon = 80,
  kGlobalOptIconstring = 81,
  kGlobalOptIgnorecase = 82,
  kGlobalOptImcmdline = 83,
  kGlobalOptImdisable = 84,
  kGlobalOptInccommand = 85,
  kGlobalOptInclude = 86,
  kGlobalOptIncsearch = 87,
  kGlobalOptInsertmode = 88,
  kGlobalOptIsfname = 89,
  kGlobalOptIsident = 90,
  kGlobalOptIsprint = 91,
  kGlobalOptJoinspaces = 92,
  kGlobalOptJumpoptions = 93,
  kGlobalOptKeymodel = 94,
  kGlobalOptKeywordprg = 95,
  kGlobalOptLangmap = 96,
  kGlobalOptLangmenu = 97,
  kGlobalOptLangnoremap = 98,
  kGlobalOptLangremap = 99,
  kGlobalOptLaststatus = 100,
  kGlobalOptLazyredraw = 101,
  kGlobalOptLines = 102,
  kGlobalOptLinespace = 103,
  kGlobalOptLispwords = 104,
  kGlobalOptListchars = 105,
  kGlobalOptLoadplugins = 106,
  kGlobalOptMagic = 107,
  kGlobalOptMakeef = 108,
  kGlobalOptMakeencoding = 109,
  kGlobalOptMakeprg = 110,
  kGlobalOptMatchtime = 111,
  kGlobalOptMaxcombine = 112,
  kGlobalOptMaxfuncdepth = 113,
  kGlobalOptMaxmapdepth = 114,
  kGlobalOptMaxmempattern = 115,
  kGlobalOptMenuitems = 116,
  kGlobalOptMessagesopt = 117,
  kGlobalOptMkspellmem = 118,
  kGlobalOptModelineexpr = 119,
  kGlobalOptModelines = 120,
  kGlobalOptMore = 121,
  kGlobalOptMouse = 122,
  kGlobalOptMousefocus = 123,
  kGlobalOptMousehide = 124,
  kGlobalOptMousemodel = 125,
  kGlobalOptMousemoveevent = 126,
  kGlobalOptMousescroll = 127,
  kGlobalOptMouseshape = 128,
  kGlobalOptMousetime = 129,
  kGlobalOptOpendevice = 130,
  kGlobalOptOperatorfunc = 131,
  kGlobalOptPackpath = 132,
  kGlobalOptParagraphs = 133,
  kGlobalOptPaste = 134,
  kGlobalOptPastetoggle = 135,
  kGlobalOptPatchexpr = 136,
  kGlobalOptPatchmode = 137,
  kGlobalOptPath = 138,
  kGlobalOptPreviewheight = 139,
  kGlobalOptPrompt = 140,
  kGlobalOptPumblend = 141,
  kGlobalOptPumheight = 142,
  kGlobalOptPumwidth = 143,
  kGlobalOptPyxversion = 144,
  kGlobalOptQuickfixtextfunc = 145,
  kGlobalOptRedrawdebug = 146,
  kGlobalOptRedrawtime = 147,
  kGlobalOptRegexpengine = 148,
  kGlobalOptRemap = 149,
  kGlobalOptReport = 150,
  kGlobalOptRevins = 151,
  kGlobalOptRuler = 152,
  kGlobalOptRulerformat = 153,
  kGlobalOptRuntimepath = 154,
  kGlobalOptScrolljump = 155,
  kGlobalOptScrolloff = 156,
  kGlobalOptScrollopt = 157,
  kGlobalOptSections = 158,
  kGlobalOptSecure = 159,
  kGlobalOptSelection = 160,
  kGlobalOptSelectmode = 161,
  kGlobalOptSessionoptions = 162,
  kGlobalOptShada = 163,
  kGlobalOptShadafile = 164,
  kGlobalOptShell = 165,
  kGlobalOptShellcmdflag = 166,
  kGlobalOptShellpipe = 167,
  kGlobalOptShellquote = 168,
  kGlobalOptShellredir = 169,
  kGlobalOptShellslash = 170,
  kGlobalOptShelltemp = 171,
  kGlobalOptShellxescape = 172,
  kGlobalOptShellxquote = 173,
  kGlobalOptShiftround = 174,
  kGlobalOptShortmess = 175,
  kGlobalOptShowbreak = 176,
  kGlobalOptShowcmd = 177,
  kGlobalOptShowcmdloc = 178,
  kGlobalOptShowfulltag = 179,
  kGlobalOptShowmatch = 180,
  kGlobalOptShowmode = 181,
  kGlobalOptShowtabline = 182,
  kGlobalOptSidescroll = 183,
  kGlobalOptSidescrolloff = 184,
  kGlobalOptSmartcase = 185,
  kGlobalOptSmarttab = 186,
  kGlobalOptSpellsuggest = 187,
  kGlobalOptSplitbelow = 188,
  kGlobalOptSplitkeep = 189,
  kGlobalOptSplitright = 190,
  kGlobalOptStartofline = 191,
  kGlobalOptStatusline = 192,
  kGlobalOptSuffixes = 193,
  kGlobalOptSwitchbuf = 194,
  kGlobalOptTabclose = 195,
  kGlobalOptTabline = 196,
  kGlobalOptTabpagemax = 197,
  kGlobalOptTagbsearch = 198,
  kGlobalOptTagcase = 199,
  kGlobalOptTaglength = 200,
  kGlobalOptTagrelative = 201,
  kGlobalOptTags = 202,
  kGlobalOptTagstack = 203,
  kGlobalOptTermbidi = 204,
  kGlobalOptTermencoding = 205,
  kGlobalOptTermguicolors = 206,
  kGlobalOptTermpastefilter = 207,
  kGlobalOptTermsync = 208,
  kGlobalOptTerse = 209,
  kGlobalOptThesaurus = 210,
  kGlobalOptThesaurusfunc = 211,
  kGlobalOptTildeop = 212,
  kGlobalOptTimeout = 213,
  kGlobalOptTimeoutlen = 214,
  kGlobalOptTitle = 215,
  kGlobalOptTitlelen = 216,
  kGlobalOptTitleold = 217,
  kGlobalOptTitlestring = 218,
  kGlobalOptTtimeout = 219,
  kGlobalOptTtimeoutlen = 220,
  kGlobalOptTtyfast = 221,
  kGlobalOptUndodir = 222,
  kGlobalOptUndolevels = 223,
  kGlobalOptUndoreload = 224,
  kGlobalOptUpdatecount = 225,
  kGlobalOptUpdatetime = 226,
  kGlobalOptVerbose = 227,
  kGlobalOptVerbosefile = 228,
  kGlobalOptViewdir = 229,
  kGlobalOptViewoptions = 230,
  kGlobalOptVirtualedit = 231,
  kGlobalOptVisualbell = 232,
  kGlobalOptWarn = 233,
  kGlobalOptWhichwrap = 234,
  kGlobalOptWildchar = 235,
  kGlobalOptWildcharm = 236,
  kGlobalOptWildignore = 237,
  kGlobalOptWildignorecase = 238,
  kGlobalOptWildmenu = 239,
  kGlobalOptWildmode = 240,
  kGlobalOptWildoptions = 241,
  kGlobalOptWinaltkeys = 242,
  kGlobalOptWinbar = 243,
  kGlobalOptWinborder = 244,
  kGlobalOptWindow = 245,
  kGlobalOptWinheight = 246,
  kGlobalOptWinminheight = 247,
  kGlobalOptWinminwidth = 248,
  kGlobalOptWinwidth = 249,
  kGlobalOptWrapscan = 250,
  kGlobalOptWrite = 251,
  kGlobalOptWriteany = 252,
  kGlobalOptWritebackup = 253,
  kGlobalOptWritedelay = 254,
  // Global option count
#define kGlobalOptCount 255
} GlobalOptIndex;

typedef enum {
  kBufOptInvalid = -1,
  kBufOptAutoindent = 0,
  kBufOptAutoread = 1,
  kBufOptBackupcopy = 2,
  kBufOptBinary = 3,
  kBufOptBomb = 4,
  kBufOptBufhidden = 5,
  kBufOptBuflisted = 6,
  kBufOptBuftype = 7,
  kBufOptChannel = 8,
  kBufOptCindent = 9,
  kBufOptCinkeys = 10,
  kBufOptCinoptions = 11,
  kBufOptCinscopedecls = 12,
  kBufOptCinwords = 13,
  kBufOptComments = 14,
  kBufOptCommentstring = 15,
  kBufOptComplete = 16,
  kBufOptCompletefunc = 17,
  kBufOptCompleteopt = 18,
  kBufOptCompleteslash = 19,
  kBufOptCopyindent = 20,
  kBufOptDefine = 21,
  kBufOptDictionary = 22,
  kBufOptEndoffile = 23,
  kBufOptEndofline = 24,
  kBufOptEqualprg = 25,
  kBufOptErrorformat = 26,
  kBufOptExpandtab = 27,
  kBufOptFileencoding = 28,
  kBufOptFileformat = 29,
  kBufOptFiletype = 30,
  kBufOptFindfunc = 31,
  kBufOptFixendofline = 32,
  kBufOptFormatexpr = 33,
  kBufOptFormatlistpat = 34,
  kBufOptFormatoptions = 35,
  kBufOptFormatprg = 36,
  kBufOptGrepprg = 37,
  kBufOptIminsert = 38,
  kBufOptImsearch = 39,
  kBufOptInclude = 40,
  kBufOptIncludeexpr = 41,
  kBufOptIndentexpr = 42,
  kBufOptIndentkeys = 43,
  kBufOptInfercase = 44,
  kBufOptIskeyword = 45,
  kBufOptKeymap = 46,
  kBufOptKeywordprg = 47,
  kBufOptLisp = 48,
  kBufOptLispoptions = 49,
  kBufOptLispwords = 50,
  kBufOptMakeencoding = 51,
  kBufOptMakeprg = 52,
  kBufOptMatchpairs = 53,
  kBufOptModeline = 54,
  kBufOptModifiable = 55,
  kBufOptModified = 56,
  kBufOptNrformats = 57,
  kBufOptOmnifunc = 58,
  kBufOptPath = 59,
  kBufOptPreserveindent = 60,
  kBufOptQuoteescape = 61,
  kBufOptReadonly = 62,
  kBufOptScrollback = 63,
  kBufOptShiftwidth = 64,
  kBufOptSmartindent = 65,
  kBufOptSofttabstop = 66,
  kBufOptSpellcapcheck = 67,
  kBufOptSpellfile = 68,
  kBufOptSpelllang = 69,
  kBufOptSpelloptions = 70,
  kBufOptSuffixesadd = 71,
  kBufOptSwapfile = 72,
  kBufOptSynmaxcol = 73,
  kBufOptSyntax = 74,
  kBufOptTabstop = 75,
  kBufOptTagcase = 76,
  kBufOptTagfunc = 77,
  kBufOptTags = 78,
  kBufOptTextwidth = 79,
  kBufOptThesaurus = 80,
  kBufOptThesaurusfunc = 81,
  kBufOptUndofile = 82,
  kBufOptUndolevels = 83,
  kBufOptVarsofttabstop = 84,
  kBufOptVartabstop = 85,
  kBufOptWrapmargin = 86,
  // Buf option count
#define kBufOptCount 87
} BufOptIndex;

typedef enum {
  kWinOptInvalid = -1,
  kWinOptArabic = 0,
  kWinOptBreakindent = 1,
  kWinOptBreakindentopt = 2,
  kWinOptColorcolumn = 3,
  kWinOptConcealcursor = 4,
  kWinOptConceallevel = 5,
  kWinOptCursorbind = 6,
  kWinOptCursorcolumn = 7,
  kWinOptCursorline = 8,
  kWinOptCursorlineopt = 9,
  kWinOptDiff = 10,
  kWinOptEventignorewin = 11,
  kWinOptFillchars = 12,
  kWinOptFoldcolumn = 13,
  kWinOptFoldenable = 14,
  kWinOptFoldexpr = 15,
  kWinOptFoldignore = 16,
  kWinOptFoldlevel = 17,
  kWinOptFoldmarker = 18,
  kWinOptFoldmethod = 19,
  kWinOptFoldminlines = 20,
  kWinOptFoldnestmax = 21,
  kWinOptFoldtext = 22,
  kWinOptLinebreak = 23,
  kWinOptList = 24,
  kWinOptListchars = 25,
  kWinOptNumber = 26,
  kWinOptNumberwidth = 27,
  kWinOptPreviewwindow = 28,
  kWinOptRelativenumber = 29,
  kWinOptRightleft = 30,
  kWinOptRightleftcmd = 31,
  kWinOptScroll = 32,
  kWinOptScrollbind = 33,
  kWinOptScrolloff = 34,
  kWinOptShowbreak = 35,
  kWinOptSidescrolloff = 36,
  kWinOptSigncolumn = 37,
  kWinOptSmoothscroll = 38,
  kWinOptSpell = 39,
  kWinOptStatuscolumn = 40,
  kWinOptStatusline = 41,
  kWinOptVirtualedit = 42,
  kWinOptWinbar = 43,
  kWinOptWinblend = 44,
  kWinOptWinfixbuf = 45,
  kWinOptWinfixheight = 46,
  kWinOptWinfixwidth = 47,
  kWinOptWinhighlight = 48,
  kWinOptWrap = 49,
  // Win option count
#define kWinOptCount 50
} WinOptIndex;

EXTERN const OptIndex global_opt_idx[] INIT( = {
  [kGlobalOptAleph] = kOptAleph,
  [kGlobalOptAllowrevins] = kOptAllowrevins,
  [kGlobalOptAmbiwidth] = kOptAmbiwidth,
  [kGlobalOptArabicshape] = kOptArabicshape,
  [kGlobalOptAutochdir] = kOptAutochdir,
  [kGlobalOptAutoread] = kOptAutoread,
  [kGlobalOptAutowrite] = kOptAutowrite,
  [kGlobalOptAutowriteall] = kOptAutowriteall,
  [kGlobalOptBackground] = kOptBackground,
  [kGlobalOptBackspace] = kOptBackspace,
  [kGlobalOptBackup] = kOptBackup,
  [kGlobalOptBackupcopy] = kOptBackupcopy,
  [kGlobalOptBackupdir] = kOptBackupdir,
  [kGlobalOptBackupext] = kOptBackupext,
  [kGlobalOptBackupskip] = kOptBackupskip,
  [kGlobalOptBelloff] = kOptBelloff,
  [kGlobalOptBreakat] = kOptBreakat,
  [kGlobalOptBrowsedir] = kOptBrowsedir,
  [kGlobalOptCasemap] = kOptCasemap,
  [kGlobalOptCdhome] = kOptCdhome,
  [kGlobalOptCdpath] = kOptCdpath,
  [kGlobalOptCedit] = kOptCedit,
  [kGlobalOptCharconvert] = kOptCharconvert,
  [kGlobalOptClipboard] = kOptClipboard,
  [kGlobalOptCmdheight] = kOptCmdheight,
  [kGlobalOptCmdwinheight] = kOptCmdwinheight,
  [kGlobalOptColumns] = kOptColumns,
  [kGlobalOptCompatible] = kOptCompatible,
  [kGlobalOptCompleteitemalign] = kOptCompleteitemalign,
  [kGlobalOptCompleteopt] = kOptCompleteopt,
  [kGlobalOptConfirm] = kOptConfirm,
  [kGlobalOptCpoptions] = kOptCpoptions,
  [kGlobalOptDebug] = kOptDebug,
  [kGlobalOptDefine] = kOptDefine,
  [kGlobalOptDelcombine] = kOptDelcombine,
  [kGlobalOptDictionary] = kOptDictionary,
  [kGlobalOptDiffexpr] = kOptDiffexpr,
  [kGlobalOptDiffopt] = kOptDiffopt,
  [kGlobalOptDigraph] = kOptDigraph,
  [kGlobalOptDirectory] = kOptDirectory,
  [kGlobalOptDisplay] = kOptDisplay,
  [kGlobalOptEadirection] = kOptEadirection,
  [kGlobalOptEdcompatible] = kOptEdcompatible,
  [kGlobalOptEmoji] = kOptEmoji,
  [kGlobalOptEncoding] = kOptEncoding,
  [kGlobalOptEqualalways] = kOptEqualalways,
  [kGlobalOptEqualprg] = kOptEqualprg,
  [kGlobalOptErrorbells] = kOptErrorbells,
  [kGlobalOptErrorfile] = kOptErrorfile,
  [kGlobalOptErrorformat] = kOptErrorformat,
  [kGlobalOptEventignore] = kOptEventignore,
  [kGlobalOptExrc] = kOptExrc,
  [kGlobalOptFileencodings] = kOptFileencodings,
  [kGlobalOptFileformats] = kOptFileformats,
  [kGlobalOptFileignorecase] = kOptFileignorecase,
  [kGlobalOptFillchars] = kOptFillchars,
  [kGlobalOptFindfunc] = kOptFindfunc,
  [kGlobalOptFoldclose] = kOptFoldclose,
  [kGlobalOptFoldlevelstart] = kOptFoldlevelstart,
  [kGlobalOptFoldopen] = kOptFoldopen,
  [kGlobalOptFormatprg] = kOptFormatprg,
  [kGlobalOptFsync] = kOptFsync,
  [kGlobalOptGdefault] = kOptGdefault,
  [kGlobalOptGrepformat] = kOptGrepformat,
  [kGlobalOptGrepprg] = kOptGrepprg,
  [kGlobalOptGuicursor] = kOptGuicursor,
  [kGlobalOptGuifont] = kOptGuifont,
  [kGlobalOptGuifontwide] = kOptGuifontwide,
  [kGlobalOptGuioptions] = kOptGuioptions,
  [kGlobalOptGuitablabel] = kOptGuitablabel,
  [kGlobalOptGuitabtooltip] = kOptGuitabtooltip,
  [kGlobalOptHelpfile] = kOptHelpfile,
  [kGlobalOptHelpheight] = kOptHelpheight,
  [kGlobalOptHelplang] = kOptHelplang,
  [kGlobalOptHidden] = kOptHidden,
  [kGlobalOptHighlight] = kOptHighlight,
  [kGlobalOptHistory] = kOptHistory,
  [kGlobalOptHkmap] = kOptHkmap,
  [kGlobalOptHkmapp] = kOptHkmapp,
  [kGlobalOptHlsearch] = kOptHlsearch,
  [kGlobalOptIcon] = kOptIcon,
  [kGlobalOptIconstring] = kOptIconstring,
  [kGlobalOptIgnorecase] = kOptIgnorecase,
  [kGlobalOptImcmdline] = kOptImcmdline,
  [kGlobalOptImdisable] = kOptImdisable,
  [kGlobalOptInccommand] = kOptInccommand,
  [kGlobalOptInclude] = kOptInclude,
  [kGlobalOptIncsearch] = kOptIncsearch,
  [kGlobalOptInsertmode] = kOptInsertmode,
  [kGlobalOptIsfname] = kOptIsfname,
  [kGlobalOptIsident] = kOptIsident,
  [kGlobalOptIsprint] = kOptIsprint,
  [kGlobalOptJoinspaces] = kOptJoinspaces,
  [kGlobalOptJumpoptions] = kOptJumpoptions,
  [kGlobalOptKeymodel] = kOptKeymodel,
  [kGlobalOptKeywordprg] = kOptKeywordprg,
  [kGlobalOptLangmap] = kOptLangmap,
  [kGlobalOptLangmenu] = kOptLangmenu,
  [kGlobalOptLangnoremap] = kOptLangnoremap,
  [kGlobalOptLangremap] = kOptLangremap,
  [kGlobalOptLaststatus] = kOptLaststatus,
  [kGlobalOptLazyredraw] = kOptLazyredraw,
  [kGlobalOptLines] = kOptLines,
  [kGlobalOptLinespace] = kOptLinespace,
  [kGlobalOptLispwords] = kOptLispwords,
  [kGlobalOptListchars] = kOptListchars,
  [kGlobalOptLoadplugins] = kOptLoadplugins,
  [kGlobalOptMagic] = kOptMagic,
  [kGlobalOptMakeef] = kOptMakeef,
  [kGlobalOptMakeencoding] = kOptMakeencoding,
  [kGlobalOptMakeprg] = kOptMakeprg,
  [kGlobalOptMatchtime] = kOptMatchtime,
  [kGlobalOptMaxcombine] = kOptMaxcombine,
  [kGlobalOptMaxfuncdepth] = kOptMaxfuncdepth,
  [kGlobalOptMaxmapdepth] = kOptMaxmapdepth,
  [kGlobalOptMaxmempattern] = kOptMaxmempattern,
  [kGlobalOptMenuitems] = kOptMenuitems,
  [kGlobalOptMessagesopt] = kOptMessagesopt,
  [kGlobalOptMkspellmem] = kOptMkspellmem,
  [kGlobalOptModelineexpr] = kOptModelineexpr,
  [kGlobalOptModelines] = kOptModelines,
  [kGlobalOptMore] = kOptMore,
  [kGlobalOptMouse] = kOptMouse,
  [kGlobalOptMousefocus] = kOptMousefocus,
  [kGlobalOptMousehide] = kOptMousehide,
  [kGlobalOptMousemodel] = kOptMousemodel,
  [kGlobalOptMousemoveevent] = kOptMousemoveevent,
  [kGlobalOptMousescroll] = kOptMousescroll,
  [kGlobalOptMouseshape] = kOptMouseshape,
  [kGlobalOptMousetime] = kOptMousetime,
  [kGlobalOptOpendevice] = kOptOpendevice,
  [kGlobalOptOperatorfunc] = kOptOperatorfunc,
  [kGlobalOptPackpath] = kOptPackpath,
  [kGlobalOptParagraphs] = kOptParagraphs,
  [kGlobalOptPaste] = kOptPaste,
  [kGlobalOptPastetoggle] = kOptPastetoggle,
  [kGlobalOptPatchexpr] = kOptPatchexpr,
  [kGlobalOptPatchmode] = kOptPatchmode,
  [kGlobalOptPath] = kOptPath,
  [kGlobalOptPreviewheight] = kOptPreviewheight,
  [kGlobalOptPrompt] = kOptPrompt,
  [kGlobalOptPumblend] = kOptPumblend,
  [kGlobalOptPumheight] = kOptPumheight,
  [kGlobalOptPumwidth] = kOptPumwidth,
  [kGlobalOptPyxversion] = kOptPyxversion,
  [kGlobalOptQuickfixtextfunc] = kOptQuickfixtextfunc,
  [kGlobalOptRedrawdebug] = kOptRedrawdebug,
  [kGlobalOptRedrawtime] = kOptRedrawtime,
  [kGlobalOptRegexpengine] = kOptRegexpengine,
  [kGlobalOptRemap] = kOptRemap,
  [kGlobalOptReport] = kOptReport,
  [kGlobalOptRevins] = kOptRevins,
  [kGlobalOptRuler] = kOptRuler,
  [kGlobalOptRulerformat] = kOptRulerformat,
  [kGlobalOptRuntimepath] = kOptRuntimepath,
  [kGlobalOptScrolljump] = kOptScrolljump,
  [kGlobalOptScrolloff] = kOptScrolloff,
  [kGlobalOptScrollopt] = kOptScrollopt,
  [kGlobalOptSections] = kOptSections,
  [kGlobalOptSecure] = kOptSecure,
  [kGlobalOptSelection] = kOptSelection,
  [kGlobalOptSelectmode] = kOptSelectmode,
  [kGlobalOptSessionoptions] = kOptSessionoptions,
  [kGlobalOptShada] = kOptShada,
  [kGlobalOptShadafile] = kOptShadafile,
  [kGlobalOptShell] = kOptShell,
  [kGlobalOptShellcmdflag] = kOptShellcmdflag,
  [kGlobalOptShellpipe] = kOptShellpipe,
  [kGlobalOptShellquote] = kOptShellquote,
  [kGlobalOptShellredir] = kOptShellredir,
  [kGlobalOptShellslash] = kOptShellslash,
  [kGlobalOptShelltemp] = kOptShelltemp,
  [kGlobalOptShellxescape] = kOptShellxescape,
  [kGlobalOptShellxquote] = kOptShellxquote,
  [kGlobalOptShiftround] = kOptShiftround,
  [kGlobalOptShortmess] = kOptShortmess,
  [kGlobalOptShowbreak] = kOptShowbreak,
  [kGlobalOptShowcmd] = kOptShowcmd,
  [kGlobalOptShowcmdloc] = kOptShowcmdloc,
  [kGlobalOptShowfulltag] = kOptShowfulltag,
  [kGlobalOptShowmatch] = kOptShowmatch,
  [kGlobalOptShowmode] = kOptShowmode,
  [kGlobalOptShowtabline] = kOptShowtabline,
  [kGlobalOptSidescroll] = kOptSidescroll,
  [kGlobalOptSidescrolloff] = kOptSidescrolloff,
  [kGlobalOptSmartcase] = kOptSmartcase,
  [kGlobalOptSmarttab] = kOptSmarttab,
  [kGlobalOptSpellsuggest] = kOptSpellsuggest,
  [kGlobalOptSplitbelow] = kOptSplitbelow,
  [kGlobalOptSplitkeep] = kOptSplitkeep,
  [kGlobalOptSplitright] = kOptSplitright,
  [kGlobalOptStartofline] = kOptStartofline,
  [kGlobalOptStatusline] = kOptStatusline,
  [kGlobalOptSuffixes] = kOptSuffixes,
  [kGlobalOptSwitchbuf] = kOptSwitchbuf,
  [kGlobalOptTabclose] = kOptTabclose,
  [kGlobalOptTabline] = kOptTabline,
  [kGlobalOptTabpagemax] = kOptTabpagemax,
  [kGlobalOptTagbsearch] = kOptTagbsearch,
  [kGlobalOptTagcase] = kOptTagcase,
  [kGlobalOptTaglength] = kOptTaglength,
  [kGlobalOptTagrelative] = kOptTagrelative,
  [kGlobalOptTags] = kOptTags,
  [kGlobalOptTagstack] = kOptTagstack,
  [kGlobalOptTermbidi] = kOptTermbidi,
  [kGlobalOptTermencoding] = kOptTermencoding,
  [kGlobalOptTermguicolors] = kOptTermguicolors,
  [kGlobalOptTermpastefilter] = kOptTermpastefilter,
  [kGlobalOptTermsync] = kOptTermsync,
  [kGlobalOptTerse] = kOptTerse,
  [kGlobalOptThesaurus] = kOptThesaurus,
  [kGlobalOptThesaurusfunc] = kOptThesaurusfunc,
  [kGlobalOptTildeop] = kOptTildeop,
  [kGlobalOptTimeout] = kOptTimeout,
  [kGlobalOptTimeoutlen] = kOptTimeoutlen,
  [kGlobalOptTitle] = kOptTitle,
  [kGlobalOptTitlelen] = kOptTitlelen,
  [kGlobalOptTitleold] = kOptTitleold,
  [kGlobalOptTitlestring] = kOptTitlestring,
  [kGlobalOptTtimeout] = kOptTtimeout,
  [kGlobalOptTtimeoutlen] = kOptTtimeoutlen,
  [kGlobalOptTtyfast] = kOptTtyfast,
  [kGlobalOptUndodir] = kOptUndodir,
  [kGlobalOptUndolevels] = kOptUndolevels,
  [kGlobalOptUndoreload] = kOptUndoreload,
  [kGlobalOptUpdatecount] = kOptUpdatecount,
  [kGlobalOptUpdatetime] = kOptUpdatetime,
  [kGlobalOptVerbose] = kOptVerbose,
  [kGlobalOptVerbosefile] = kOptVerbosefile,
  [kGlobalOptViewdir] = kOptViewdir,
  [kGlobalOptViewoptions] = kOptViewoptions,
  [kGlobalOptVirtualedit] = kOptVirtualedit,
  [kGlobalOptVisualbell] = kOptVisualbell,
  [kGlobalOptWarn] = kOptWarn,
  [kGlobalOptWhichwrap] = kOptWhichwrap,
  [kGlobalOptWildchar] = kOptWildchar,
  [kGlobalOptWildcharm] = kOptWildcharm,
  [kGlobalOptWildignore] = kOptWildignore,
  [kGlobalOptWildignorecase] = kOptWildignorecase,
  [kGlobalOptWildmenu] = kOptWildmenu,
  [kGlobalOptWildmode] = kOptWildmode,
  [kGlobalOptWildoptions] = kOptWildoptions,
  [kGlobalOptWinaltkeys] = kOptWinaltkeys,
  [kGlobalOptWinbar] = kOptWinbar,
  [kGlobalOptWinborder] = kOptWinborder,
  [kGlobalOptWindow] = kOptWindow,
  [kGlobalOptWinheight] = kOptWinheight,
  [kGlobalOptWinminheight] = kOptWinminheight,
  [kGlobalOptWinminwidth] = kOptWinminwidth,
  [kGlobalOptWinwidth] = kOptWinwidth,
  [kGlobalOptWrapscan] = kOptWrapscan,
  [kGlobalOptWrite] = kOptWrite,
  [kGlobalOptWriteany] = kOptWriteany,
  [kGlobalOptWritebackup] = kOptWritebackup,
  [kGlobalOptWritedelay] = kOptWritedelay,
});

EXTERN const OptIndex buf_opt_idx[] INIT( = {
  [kBufOptAutoindent] = kOptAutoindent,
  [kBufOptAutoread] = kOptAutoread,
  [kBufOptBackupcopy] = kOptBackupcopy,
  [kBufOptBinary] = kOptBinary,
  [kBufOptBomb] = kOptBomb,
  [kBufOptBufhidden] = kOptBufhidden,
  [kBufOptBuflisted] = kOptBuflisted,
  [kBufOptBuftype] = kOptBuftype,
  [kBufOptChannel] = kOptChannel,
  [kBufOptCindent] = kOptCindent,
  [kBufOptCinkeys] = kOptCinkeys,
  [kBufOptCinoptions] = kOptCinoptions,
  [kBufOptCinscopedecls] = kOptCinscopedecls,
  [kBufOptCinwords] = kOptCinwords,
  [kBufOptComments] = kOptComments,
  [kBufOptCommentstring] = kOptCommentstring,
  [kBufOptComplete] = kOptComplete,
  [kBufOptCompletefunc] = kOptCompletefunc,
  [kBufOptCompleteopt] = kOptCompleteopt,
  [kBufOptCompleteslash] = kOptCompleteslash,
  [kBufOptCopyindent] = kOptCopyindent,
  [kBufOptDefine] = kOptDefine,
  [kBufOptDictionary] = kOptDictionary,
  [kBufOptEndoffile] = kOptEndoffile,
  [kBufOptEndofline] = kOptEndofline,
  [kBufOptEqualprg] = kOptEqualprg,
  [kBufOptErrorformat] = kOptErrorformat,
  [kBufOptExpandtab] = kOptExpandtab,
  [kBufOptFileencoding] = kOptFileencoding,
  [kBufOptFileformat] = kOptFileformat,
  [kBufOptFiletype] = kOptFiletype,
  [kBufOptFindfunc] = kOptFindfunc,
  [kBufOptFixendofline] = kOptFixendofline,
  [kBufOptFormatexpr] = kOptFormatexpr,
  [kBufOptFormatlistpat] = kOptFormatlistpat,
  [kBufOptFormatoptions] = kOptFormatoptions,
  [kBufOptFormatprg] = kOptFormatprg,
  [kBufOptGrepprg] = kOptGrepprg,
  [kBufOptIminsert] = kOptIminsert,
  [kBufOptImsearch] = kOptImsearch,
  [kBufOptInclude] = kOptInclude,
  [kBufOptIncludeexpr] = kOptIncludeexpr,
  [kBufOptIndentexpr] = kOptIndentexpr,
  [kBufOptIndentkeys] = kOptIndentkeys,
  [kBufOptInfercase] = kOptInfercase,
  [kBufOptIskeyword] = kOptIskeyword,
  [kBufOptKeymap] = kOptKeymap,
  [kBufOptKeywordprg] = kOptKeywordprg,
  [kBufOptLisp] = kOptLisp,
  [kBufOptLispoptions] = kOptLispoptions,
  [kBufOptLispwords] = kOptLispwords,
  [kBufOptMakeencoding] = kOptMakeencoding,
  [kBufOptMakeprg] = kOptMakeprg,
  [kBufOptMatchpairs] = kOptMatchpairs,
  [kBufOptModeline] = kOptModeline,
  [kBufOptModifiable] = kOptModifiable,
  [kBufOptModified] = kOptModified,
  [kBufOptNrformats] = kOptNrformats,
  [kBufOptOmnifunc] = kOptOmnifunc,
  [kBufOptPath] = kOptPath,
  [kBufOptPreserveindent] = kOptPreserveindent,
  [kBufOptQuoteescape] = kOptQuoteescape,
  [kBufOptReadonly] = kOptReadonly,
  [kBufOptScrollback] = kOptScrollback,
  [kBufOptShiftwidth] = kOptShiftwidth,
  [kBufOptSmartindent] = kOptSmartindent,
  [kBufOptSofttabstop] = kOptSofttabstop,
  [kBufOptSpellcapcheck] = kOptSpellcapcheck,
  [kBufOptSpellfile] = kOptSpellfile,
  [kBufOptSpelllang] = kOptSpelllang,
  [kBufOptSpelloptions] = kOptSpelloptions,
  [kBufOptSuffixesadd] = kOptSuffixesadd,
  [kBufOptSwapfile] = kOptSwapfile,
  [kBufOptSynmaxcol] = kOptSynmaxcol,
  [kBufOptSyntax] = kOptSyntax,
  [kBufOptTabstop] = kOptTabstop,
  [kBufOptTagcase] = kOptTagcase,
  [kBufOptTagfunc] = kOptTagfunc,
  [kBufOptTags] = kOptTags,
  [kBufOptTextwidth] = kOptTextwidth,
  [kBufOptThesaurus] = kOptThesaurus,
  [kBufOptThesaurusfunc] = kOptThesaurusfunc,
  [kBufOptUndofile] = kOptUndofile,
  [kBufOptUndolevels] = kOptUndolevels,
  [kBufOptVarsofttabstop] = kOptVarsofttabstop,
  [kBufOptVartabstop] = kOptVartabstop,
  [kBufOptWrapmargin] = kOptWrapmargin,
});

EXTERN const OptIndex win_opt_idx[] INIT( = {
  [kWinOptArabic] = kOptArabic,
  [kWinOptBreakindent] = kOptBreakindent,
  [kWinOptBreakindentopt] = kOptBreakindentopt,
  [kWinOptColorcolumn] = kOptColorcolumn,
  [kWinOptConcealcursor] = kOptConcealcursor,
  [kWinOptConceallevel] = kOptConceallevel,
  [kWinOptCursorbind] = kOptCursorbind,
  [kWinOptCursorcolumn] = kOptCursorcolumn,
  [kWinOptCursorline] = kOptCursorline,
  [kWinOptCursorlineopt] = kOptCursorlineopt,
  [kWinOptDiff] = kOptDiff,
  [kWinOptEventignorewin] = kOptEventignorewin,
  [kWinOptFillchars] = kOptFillchars,
  [kWinOptFoldcolumn] = kOptFoldcolumn,
  [kWinOptFoldenable] = kOptFoldenable,
  [kWinOptFoldexpr] = kOptFoldexpr,
  [kWinOptFoldignore] = kOptFoldignore,
  [kWinOptFoldlevel] = kOptFoldlevel,
  [kWinOptFoldmarker] = kOptFoldmarker,
  [kWinOptFoldmethod] = kOptFoldmethod,
  [kWinOptFoldminlines] = kOptFoldminlines,
  [kWinOptFoldnestmax] = kOptFoldnestmax,
  [kWinOptFoldtext] = kOptFoldtext,
  [kWinOptLinebreak] = kOptLinebreak,
  [kWinOptList] = kOptList,
  [kWinOptListchars] = kOptListchars,
  [kWinOptNumber] = kOptNumber,
  [kWinOptNumberwidth] = kOptNumberwidth,
  [kWinOptPreviewwindow] = kOptPreviewwindow,
  [kWinOptRelativenumber] = kOptRelativenumber,
  [kWinOptRightleft] = kOptRightleft,
  [kWinOptRightleftcmd] = kOptRightleftcmd,
  [kWinOptScroll] = kOptScroll,
  [kWinOptScrollbind] = kOptScrollbind,
  [kWinOptScrolloff] = kOptScrolloff,
  [kWinOptShowbreak] = kOptShowbreak,
  [kWinOptSidescrolloff] = kOptSidescrolloff,
  [kWinOptSigncolumn] = kOptSigncolumn,
  [kWinOptSmoothscroll] = kOptSmoothscroll,
  [kWinOptSpell] = kOptSpell,
  [kWinOptStatuscolumn] = kOptStatuscolumn,
  [kWinOptStatusline] = kOptStatusline,
  [kWinOptVirtualedit] = kOptVirtualedit,
  [kWinOptWinbar] = kOptWinbar,
  [kWinOptWinblend] = kOptWinblend,
  [kWinOptWinfixbuf] = kOptWinfixbuf,
  [kWinOptWinfixheight] = kOptWinfixheight,
  [kWinOptWinfixwidth] = kOptWinfixwidth,
  [kWinOptWinhighlight] = kOptWinhighlight,
  [kWinOptWrap] = kOptWrap,
});
