// python wrapper for vtkPVPlaneCutter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPlaneCutter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPlaneCutter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPlaneCutter_ClassNew(); }


static PyObject *
PyvtkPVPlaneCutter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPlaneCutter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPlaneCutter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPlaneCutter *tempr = vtkPVPlaneCutter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPlaneCutter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPlaneCutter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPlaneCutter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPlaneCutter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_GetDual(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDual");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDual() :
      op->vtkPVPlaneCutter::GetDual());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_SetDual(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDual");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDual(temp0);
    }
    else
    {
      op->vtkPVPlaneCutter::SetDual(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_SetLevelOfResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLevelOfResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLevelOfResolution(temp0);
    }
    else
    {
      op->vtkPVPlaneCutter::SetLevelOfResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_GetLevelOfResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLevelOfResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLevelOfResolution() :
      op->vtkPVPlaneCutter::GetLevelOfResolution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_SetUseNativeCutter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseNativeCutter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseNativeCutter(temp0);
    }
    else
    {
      op->vtkPVPlaneCutter::SetUseNativeCutter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_GetUseNativeCutter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseNativeCutter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseNativeCutter() :
      op->vtkPVPlaneCutter::GetUseNativeCutter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_UseNativeCutterOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseNativeCutterOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseNativeCutterOn();
    }
    else
    {
      op->vtkPVPlaneCutter::UseNativeCutterOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlaneCutter_UseNativeCutterOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseNativeCutterOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlaneCutter *op = static_cast<vtkPVPlaneCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseNativeCutterOff();
    }
    else
    {
      op->vtkPVPlaneCutter::UseNativeCutterOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPlaneCutter_Methods[] = {
  {"IsTypeOf", PyvtkPVPlaneCutter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPlaneCutter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPlaneCutter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPlaneCutter\nC++: static vtkPVPlaneCutter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPlaneCutter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPlaneCutter\nC++: vtkPVPlaneCutter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPlaneCutter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPlaneCutter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetDual", PyvtkPVPlaneCutter_GetDual, METH_VARARGS,
   "GetDual(self) -> bool\nC++: virtual bool GetDual()\n\n@\n\nIf set to true, the dual grid is used for cutting.\n\nDefault is false.\n\nNote: Only used for cutting hyper tree grids.\n"},
  {"SetDual", PyvtkPVPlaneCutter_SetDual, METH_VARARGS,
   "SetDual(self, _arg:bool) -> None\nC++: virtual void SetDual(bool _arg)\n\n"},
  {"SetLevelOfResolution", PyvtkPVPlaneCutter_SetLevelOfResolution, METH_VARARGS,
   "SetLevelOfResolution(self, _arg:int) -> None\nC++: virtual void SetLevelOfResolution(int _arg)\n\nSets the level of resolution\n\nDefault is 0.\n\nNote: Only used for cutting overlapping AMR.\n"},
  {"GetLevelOfResolution", PyvtkPVPlaneCutter_GetLevelOfResolution, METH_VARARGS,
   "GetLevelOfResolution(self) -> int\nC++: virtual int GetLevelOfResolution()\n\n"},
  {"SetUseNativeCutter", PyvtkPVPlaneCutter_SetUseNativeCutter, METH_VARARGS,
   "SetUseNativeCutter(self, _arg:bool) -> None\nC++: virtual void SetUseNativeCutter(bool _arg)\n\nSets if plane cutter is used instead of the specialized AMR\ncutter.\n\nDefault is true.\n\nNote: Only used for cutting overlapping AMR.\n"},
  {"GetUseNativeCutter", PyvtkPVPlaneCutter_GetUseNativeCutter, METH_VARARGS,
   "GetUseNativeCutter(self) -> bool\nC++: virtual bool GetUseNativeCutter()\n\n"},
  {"UseNativeCutterOn", PyvtkPVPlaneCutter_UseNativeCutterOn, METH_VARARGS,
   "UseNativeCutterOn(self) -> None\nC++: virtual void UseNativeCutterOn()\n\n"},
  {"UseNativeCutterOff", PyvtkPVPlaneCutter_UseNativeCutterOff, METH_VARARGS,
   "UseNativeCutterOff(self) -> None\nC++: virtual void UseNativeCutterOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPlaneCutter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("dual"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlaneCutter_GetDual(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlaneCutter_SetDual(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlaneCutter_SetDual(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDual/SetDual\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("level_of_resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlaneCutter_GetLevelOfResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlaneCutter_SetLevelOfResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlaneCutter_SetLevelOfResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLevelOfResolution/SetLevelOfResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_native_cutter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlaneCutter_GetUseNativeCutter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlaneCutter_SetUseNativeCutter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlaneCutter_SetUseNativeCutter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseNativeCutter/SetUseNativeCutter\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPlaneCutter_Doc =
  "vtkPVPlaneCutter - Slice with plane filter\n\n"
  "Superclass: vtkPlaneCutter\n\n"
  "This is a subclass of vtkPlaneCutter that allows selection of input\n"
  "vtkHyperTreeGrid, vtkOverlappingAMR.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPlaneCutter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVPlaneCutter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPlaneCutter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPlaneCutter_StaticNew()
{
  return vtkPVPlaneCutter::New();
}

PyObject *PyvtkPVPlaneCutter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPlaneCutter_Type, PyvtkPVPlaneCutter_Methods,
    "vtkPVPlaneCutter",
 &PyvtkPVPlaneCutter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPlaneCutter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPlaneCutter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPlaneCutter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPlaneCutter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPlaneCutter", o) != 0)
  {
    Py_DECREF(o);
  }

}

