// python wrapper for vtkPVCatalystSessionCore
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVCatalystSessionCore.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVCatalystSessionCore(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVCatalystSessionCore_ClassNew(); }

#ifndef DECLARED_PyvtkPVSessionCore_ClassNew
extern "C" { PyObject *PyvtkPVSessionCore_ClassNew(); }
#define DECLARED_PyvtkPVSessionCore_ClassNew
#endif

static PyObject *
PyvtkPVCatalystSessionCore_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVCatalystSessionCore::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVCatalystSessionCore::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVCatalystSessionCore *tempr = vtkPVCatalystSessionCore::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVCatalystSessionCore *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVCatalystSessionCore::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVCatalystSessionCore::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVCatalystSessionCore::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_GatherInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GatherInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  unsigned int temp0;
  vtkPVInformation *temp1 = nullptr;
  unsigned int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkPVInformation") &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->GatherInformation(temp0, temp1, temp2) :
      op->vtkPVCatalystSessionCore::GatherInformation(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_RegisterDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  unsigned int temp0;
  unsigned int temp1;
  vtkPVInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkPVInformation"))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->RegisterDataInformation(temp0, temp1, temp2) :
      op->vtkPVCatalystSessionCore::RegisterDataInformation(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_UpdateIdMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateIdMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned int> store0(2*size0);
  unsigned int *temp0 = store0.Data();
  unsigned int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->UpdateIdMap(temp0, temp1);
    }
    else
    {
      op->vtkPVCatalystSessionCore::UpdateIdMap(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCatalystSessionCore_ResetIdMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetIdMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCatalystSessionCore *op = static_cast<vtkPVCatalystSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetIdMap();
    }
    else
    {
      op->vtkPVCatalystSessionCore::ResetIdMap();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVCatalystSessionCore_Methods[] = {
  {"IsTypeOf", PyvtkPVCatalystSessionCore_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVCatalystSessionCore_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVCatalystSessionCore_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVCatalystSessionCore\nC++: static vtkPVCatalystSessionCore *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVCatalystSessionCore_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVCatalystSessionCore\nC++: vtkPVCatalystSessionCore *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVCatalystSessionCore_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVCatalystSessionCore_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GatherInformation", PyvtkPVCatalystSessionCore_GatherInformation, METH_VARARGS,
   "GatherInformation(self, location:int,\n    information:vtkPVInformation, globalid:int) -> bool\nC++: bool GatherInformation(vtkTypeUInt32 location,\n    vtkPVInformation *information, vtkTypeUInt32 globalid)\n    override;\n\nGather information about an object referred by the\nglobalid.location identifies the processes to gather the\ninformation from.\n"},
  {"RegisterDataInformation", PyvtkPVCatalystSessionCore_RegisterDataInformation, METH_VARARGS,
   "RegisterDataInformation(self, globalid:int, port:int,\n    information:vtkPVInformation) -> int\nC++: vtkTypeUInt32 RegisterDataInformation(vtkTypeUInt32 globalid,\n     unsigned int port, vtkPVInformation *information)\n\nUpdate the data information for a given proxy with the given\nglobalid. This will allow the GatherInformation to work with\n\"fake\" VTK pipeline. Return the real corresponding proxy id\n"},
  {"UpdateIdMap", PyvtkPVCatalystSessionCore_UpdateIdMap, METH_VARARGS,
   "UpdateIdMap(self, idMapArray:[int, ...], size:int) -> None\nC++: void UpdateIdMap(vtkTypeUInt32 *idMapArray, int size)\n\n"},
  {"ResetIdMap", PyvtkPVCatalystSessionCore_ResetIdMap, METH_VARARGS,
   "ResetIdMap(self) -> None\nC++: void ResetIdMap()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVCatalystSessionCore_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVCatalystSessionCore_Doc =
  "vtkPVCatalystSessionCore - vtkPVCatalystSessionCore is used by\nvtkSMSession.\n\n"
  "Superclass: vtkPVSessionCore\n\n"
  "vtkPVCatalystSessionCore handle catalyst based proxy which don't\n"
  "contains any real data and therefore are not allowed to execute the\n"
  "VTK pipeline.@ingroup LiveInsitu\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVCatalystSessionCore_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVCatalystSessionCore", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVCatalystSessionCore_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVCatalystSessionCore_StaticNew()
{
  return vtkPVCatalystSessionCore::New();
}

PyObject *PyvtkPVCatalystSessionCore_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVCatalystSessionCore_Type, PyvtkPVCatalystSessionCore_Methods,
    "vtkPVCatalystSessionCore",
 &PyvtkPVCatalystSessionCore_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVSessionCore_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVCatalystSessionCore_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVCatalystSessionCore(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVCatalystSessionCore_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVCatalystSessionCore", o) != 0)
  {
    Py_DECREF(o);
  }

}

