/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_messaging.h"

#include "librpc/gen_ndr/ndr_server_id.h"
_PUBLIC_ enum ndr_err_code ndr_push_messaging_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum messaging_type r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_messaging_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum messaging_type *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_messaging_type(struct ndr_print *ndr, const char *name, enum messaging_type r)
{
	const char *val = NULL;

	switch (r) {
		case MSG_DEBUG: val = "MSG_DEBUG"; break;
		case MSG_PING: val = "MSG_PING"; break;
		case MSG_PONG: val = "MSG_PONG"; break;
		case MSG_PROFILE: val = "MSG_PROFILE"; break;
		case MSG_REQ_DEBUGLEVEL: val = "MSG_REQ_DEBUGLEVEL"; break;
		case MSG_DEBUGLEVEL: val = "MSG_DEBUGLEVEL"; break;
		case MSG_REQ_PROFILELEVEL: val = "MSG_REQ_PROFILELEVEL"; break;
		case MSG_PROFILELEVEL: val = "MSG_PROFILELEVEL"; break;
		case MSG_REQ_POOL_USAGE: val = "MSG_REQ_POOL_USAGE"; break;
		case MSG_POOL_USAGE: val = "MSG_POOL_USAGE"; break;
		case MSG_REQ_DMALLOC_MARK: val = "MSG_REQ_DMALLOC_MARK"; break;
		case MSG_REQ_DMALLOC_LOG_CHANGED: val = "MSG_REQ_DMALLOC_LOG_CHANGED"; break;
		case MSG_SHUTDOWN: val = "MSG_SHUTDOWN"; break;
		case ID_CACHE_DELETE: val = "ID_CACHE_DELETE"; break;
		case ID_CACHE_KILL: val = "ID_CACHE_KILL"; break;
		case MSG_SMB_CONF_UPDATED: val = "MSG_SMB_CONF_UPDATED"; break;
		case MSG_RELOAD_TLS_CERTIFICATES: val = "MSG_RELOAD_TLS_CERTIFICATES"; break;
		case MSG_PREFORK_CHILD_EVENT: val = "MSG_PREFORK_CHILD_EVENT"; break;
		case MSG_PREFORK_PARENT_EVENT: val = "MSG_PREFORK_PARENT_EVENT"; break;
		case MSG_REQ_RINGBUF_LOG: val = "MSG_REQ_RINGBUF_LOG"; break;
		case MSG_RINGBUF_LOG: val = "MSG_RINGBUF_LOG"; break;
		case MSG_DAEMON_READY_FD: val = "MSG_DAEMON_READY_FD"; break;
		case MSG_FORCE_ELECTION: val = "MSG_FORCE_ELECTION"; break;
		case MSG_WINS_NEW_ENTRY: val = "MSG_WINS_NEW_ENTRY"; break;
		case MSG_SEND_PACKET: val = "MSG_SEND_PACKET"; break;
		case MSG_PRINTER_NOTIFY2: val = "MSG_PRINTER_NOTIFY2"; break;
		case MSG_PRINTER_DRVUPGRADE: val = "MSG_PRINTER_DRVUPGRADE"; break;
		case MSG_PRINTERDATA_INIT_RESET: val = "MSG_PRINTERDATA_INIT_RESET"; break;
		case MSG_PRINTER_UPDATE: val = "MSG_PRINTER_UPDATE"; break;
		case MSG_PRINTER_MOD: val = "MSG_PRINTER_MOD"; break;
		case MSG_PRINTER_PCAP: val = "MSG_PRINTER_PCAP"; break;
		case MSG_SMB_FORCE_TDIS: val = "MSG_SMB_FORCE_TDIS"; break;
		case MSG_SMB_BREAK_REQUEST: val = "MSG_SMB_BREAK_REQUEST"; break;
		case MSG_SMB_KERNEL_BREAK: val = "MSG_SMB_KERNEL_BREAK"; break;
		case MSG_SMB_FILE_RENAME: val = "MSG_SMB_FILE_RENAME"; break;
		case MSG_SMB_INJECT_FAULT: val = "MSG_SMB_INJECT_FAULT"; break;
		case MSG_SMB_BLOCKING_LOCK_CANCEL: val = "MSG_SMB_BLOCKING_LOCK_CANCEL"; break;
		case MSG_SMB_NOTIFY: val = "MSG_SMB_NOTIFY"; break;
		case MSG_PVFS_NOTIFY: val = "MSG_PVFS_NOTIFY"; break;
		case MSG_SMB_CLOSE_FILE: val = "MSG_SMB_CLOSE_FILE"; break;
		case MSG_SMB_NOTIFY_CLEANUP: val = "MSG_SMB_NOTIFY_CLEANUP"; break;
		case MSG_SMB_SCAVENGER: val = "MSG_SMB_SCAVENGER"; break;
		case MSG_SMB_KILL_CLIENT_IP: val = "MSG_SMB_KILL_CLIENT_IP"; break;
		case MSG_SMB_TELL_NUM_CHILDREN: val = "MSG_SMB_TELL_NUM_CHILDREN"; break;
		case MSG_SMB_NUM_CHILDREN: val = "MSG_SMB_NUM_CHILDREN"; break;
		case MSG_SMB_NOTIFY_CANCEL_DELETED: val = "MSG_SMB_NOTIFY_CANCEL_DELETED"; break;
		case MSG_SMB_NOTIFY_REC_CHANGE: val = "MSG_SMB_NOTIFY_REC_CHANGE"; break;
		case MSG_SMB_NOTIFY_TRIGGER: val = "MSG_SMB_NOTIFY_TRIGGER"; break;
		case MSG_SMB_NOTIFY_GET_DB: val = "MSG_SMB_NOTIFY_GET_DB"; break;
		case MSG_SMB_NOTIFY_DB: val = "MSG_SMB_NOTIFY_DB"; break;
		case MSG_SMB_NOTIFY_REC_CHANGES: val = "MSG_SMB_NOTIFY_REC_CHANGES"; break;
		case MSG_SMB_NOTIFY_STARTED: val = "MSG_SMB_NOTIFY_STARTED"; break;
		case MSG_SMB_SLEEP: val = "MSG_SMB_SLEEP"; break;
		case MSG_SMB_FORCE_TDIS_DENIED: val = "MSG_SMB_FORCE_TDIS_DENIED"; break;
		case MSG_SMB_IP_DROPPED: val = "MSG_SMB_IP_DROPPED"; break;
		case MSG_WINBIND_FINISHED: val = "MSG_WINBIND_FINISHED"; break;
		case MSG_WINBIND_FORGET_STATE: val = "MSG_WINBIND_FORGET_STATE"; break;
		case MSG_WINBIND_ONLINE: val = "MSG_WINBIND_ONLINE"; break;
		case MSG_WINBIND_OFFLINE: val = "MSG_WINBIND_OFFLINE"; break;
		case MSG_WINBIND_ONLINESTATUS: val = "MSG_WINBIND_ONLINESTATUS"; break;
		case MSG_WINBIND_VALIDATE_CACHE: val = "MSG_WINBIND_VALIDATE_CACHE"; break;
		case MSG_WINBIND_DUMP_DOMAIN_LIST: val = "MSG_WINBIND_DUMP_DOMAIN_LIST"; break;
		case MSG_WINBIND_IP_DROPPED: val = "MSG_WINBIND_IP_DROPPED"; break;
		case MSG_WINBIND_DOMAIN_ONLINE: val = "MSG_WINBIND_DOMAIN_ONLINE"; break;
		case MSG_WINBIND_DOMAIN_OFFLINE: val = "MSG_WINBIND_DOMAIN_OFFLINE"; break;
		case MSG_WINBIND_RELOAD_TRUSTED_DOMAINS: val = "MSG_WINBIND_RELOAD_TRUSTED_DOMAINS"; break;
		case MSG_WINBIND_DISCONNECT_DC: val = "MSG_WINBIND_DISCONNECT_DC"; break;
		case MSG_SMBXSRV_SESSION_CLOSE: val = "MSG_SMBXSRV_SESSION_CLOSE"; break;
		case MSG_SMBXSRV_CONNECTION_PASS: val = "MSG_SMBXSRV_CONNECTION_PASS"; break;
		case MSG_SMBXSRV_CONNECTION_PASSED: val = "MSG_SMBXSRV_CONNECTION_PASSED"; break;
		case MSG_SMBXSRV_CONNECTION_DROP: val = "MSG_SMBXSRV_CONNECTION_DROP"; break;
		case MSG_RPCD_WITNESS_REGISTRATION_UPDATE: val = "MSG_RPCD_WITNESS_REGISTRATION_UPDATE"; break;
		case MSG_BRL_RETRY: val = "MSG_BRL_RETRY"; break;
		case MSG_PVFS_RETRY_OPEN: val = "MSG_PVFS_RETRY_OPEN"; break;
		case MSG_IRPC: val = "MSG_IRPC"; break;
		case MSG_NTVFS_OPLOCK_BREAK: val = "MSG_NTVFS_OPLOCK_BREAK"; break;
		case MSG_DREPL_ALLOCATE_RID: val = "MSG_DREPL_ALLOCATE_RID"; break;
		case MSG_AUTH_LOG: val = "MSG_AUTH_LOG"; break;
		case MSG_DSDB_LOG: val = "MSG_DSDB_LOG"; break;
		case MSG_DSDB_PWD_LOG: val = "MSG_DSDB_PWD_LOG"; break;
		case MSG_GROUP_LOG: val = "MSG_GROUP_LOG"; break;
		case MSG_DBWRAP_MODIFIED: val = "MSG_DBWRAP_MODIFIED"; break;
		case MSG_RPC_HOST_NEW_CLIENT: val = "MSG_RPC_HOST_NEW_CLIENT"; break;
		case MSG_RPC_WORKER_STATUS: val = "MSG_RPC_WORKER_STATUS"; break;
		case MSG_RPC_DUMP_STATUS: val = "MSG_RPC_DUMP_STATUS"; break;
		case MSG_TMP_BASE: val = "MSG_TMP_BASE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_messaging_rec(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct messaging_rec *r)
{
	uint32_t cntr_fds_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		/* [skip] 'r->prev' */
		/* [skip] 'r->next' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->msg_version));
		NDR_CHECK(ndr_push_messaging_type(ndr, NDR_SCALARS, r->msg_type));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->dest));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->src));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->buf));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_fds));
		for (cntr_fds_0 = 0; cntr_fds_0 < (r->num_fds); cntr_fds_0++) {
			NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->fds[cntr_fds_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [skip] 'r->prev' */
		/* [skip] 'r->next' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_messaging_rec(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct messaging_rec *r)
{
	uint32_t size_fds_0 = 0;
	uint32_t cntr_fds_0;
	TALLOC_CTX *_mem_save_fds_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		/* [skip] 'r->prev' */
		NDR_ZERO_STRUCT(r->prev);
		/* [skip] 'r->next' */
		NDR_ZERO_STRUCT(r->next);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->msg_version));
		NDR_CHECK(ndr_pull_messaging_type(ndr, NDR_SCALARS, &r->msg_type));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->dest));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->src));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->buf));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_fds));
		size_fds_0 = r->num_fds;
		NDR_PULL_ALLOC_N(ndr, r->fds, size_fds_0);
		_mem_save_fds_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->fds, 0);
		for (cntr_fds_0 = 0; cntr_fds_0 < (size_fds_0); cntr_fds_0++) {
			NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->fds[cntr_fds_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_fds_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [skip] 'r->prev' */
		NDR_ZERO_STRUCT(r->prev);
		/* [skip] 'r->next' */
		NDR_ZERO_STRUCT(r->next);
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_messaging_rec(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct messaging_rec *r)
{
	ndr_print_messaging_rec(ndr, name, r);
}

_PUBLIC_ void ndr_print_messaging_rec(struct ndr_print *ndr, const char *name, const struct messaging_rec *r)
{
	uint32_t cntr_fds_0;
	ndr_print_struct(ndr, name, "messaging_rec");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "prev", r->prev);
	ndr->depth++;
	if (r->prev) {
		ndr_print_messaging_rec(ndr, "prev", r->prev);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "next", r->next);
	ndr->depth++;
	if (r->next) {
		ndr_print_messaging_rec(ndr, "next", r->next);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "msg_version", r->msg_version);
	ndr_print_messaging_type(ndr, "msg_type", r->msg_type);
	ndr_print_server_id(ndr, "dest", &r->dest);
	ndr_print_server_id(ndr, "src", &r->src);
	ndr_print_DATA_BLOB(ndr, "buf", r->buf);
	ndr_print_uint8(ndr, "num_fds", r->num_fds);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "fds", (uint32_t)(r->num_fds));
	ndr->depth++;
	for (cntr_fds_0 = 0; cntr_fds_0 < (r->num_fds); cntr_fds_0++) {
		ndr_print_dlong(ndr, "fds", r->fds[cntr_fds_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_messaging_reclog(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct messaging_reclog *r)
{
	uint32_t cntr_recs_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->rec_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_recs));
		for (cntr_recs_0 = 0; cntr_recs_0 < (r->num_recs); cntr_recs_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->recs[cntr_recs_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_recs_0 = 0; cntr_recs_0 < (r->num_recs); cntr_recs_0++) {
			if (r->recs[cntr_recs_0]) {
				NDR_CHECK(ndr_push_messaging_rec(ndr, NDR_SCALARS|NDR_BUFFERS, r->recs[cntr_recs_0]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_messaging_reclog(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct messaging_reclog *r)
{
	uint32_t _ptr_recs;
	uint32_t size_recs_0 = 0;
	uint32_t cntr_recs_0;
	TALLOC_CTX *_mem_save_recs_0 = NULL;
	TALLOC_CTX *_mem_save_recs_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->rec_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_recs));
		size_recs_0 = r->num_recs;
		NDR_PULL_ALLOC_N(ndr, r->recs, size_recs_0);
		_mem_save_recs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->recs, 0);
		for (cntr_recs_0 = 0; cntr_recs_0 < (size_recs_0); cntr_recs_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_recs));
			if (_ptr_recs) {
				NDR_PULL_ALLOC(ndr, r->recs[cntr_recs_0]);
			} else {
				r->recs[cntr_recs_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_recs_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_recs_0 = r->num_recs;
		_mem_save_recs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->recs, 0);
		for (cntr_recs_0 = 0; cntr_recs_0 < (size_recs_0); cntr_recs_0++) {
			if (r->recs[cntr_recs_0]) {
				_mem_save_recs_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->recs[cntr_recs_0], 0);
				NDR_CHECK(ndr_pull_messaging_rec(ndr, NDR_SCALARS|NDR_BUFFERS, r->recs[cntr_recs_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_recs_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_recs_0, 0);
		for (cntr_recs_0 = 0; cntr_recs_0 < (size_recs_0); cntr_recs_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_messaging_reclog(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct messaging_reclog *r)
{
	ndr_print_messaging_reclog(ndr, name, r);
}

_PUBLIC_ void ndr_print_messaging_reclog(struct ndr_print *ndr, const char *name, const struct messaging_reclog *r)
{
	uint32_t cntr_recs_0;
	ndr_print_struct(ndr, name, "messaging_reclog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "rec_index", r->rec_index);
	ndr_print_uint32(ndr, "num_recs", r->num_recs);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "recs", (uint32_t)(r->num_recs));
	ndr->depth++;
	for (cntr_recs_0 = 0; cntr_recs_0 < (r->num_recs); cntr_recs_0++) {
		ndr_print_ptr(ndr, "recs", r->recs[cntr_recs_0]);
		ndr->depth++;
		if (r->recs[cntr_recs_0]) {
			ndr_print_messaging_rec(ndr, "recs", r->recs[cntr_recs_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_messaging
static const struct ndr_interface_public_struct messaging_public_structs[] = {
	{
		.name = "messaging_rec",
		.struct_size = sizeof(struct messaging_rec ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_messaging_rec,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_messaging_rec,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_messaging_rec,
	},
	{
		.name = "messaging_reclog",
		.struct_size = sizeof(struct messaging_reclog ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_messaging_reclog,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_messaging_reclog,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_messaging_reclog,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call messaging_calls[] = {
	{ .name = NULL }
};

static const char * const messaging_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\messaging]", 
};

static const struct ndr_interface_string_array messaging_endpoints = {
	.count	= 1,
	.names	= messaging_endpoint_strings
};

static const char * const messaging_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array messaging_authservices = {
	.count	= 1,
	.names	= messaging_authservice_strings
};


const struct ndr_interface_table ndr_table_messaging = {
	.name		= "messaging",
	.num_calls	= 0,
	.calls		= messaging_calls,
	.num_public_structs	= 2,
	.public_structs		= messaging_public_structs,
	.endpoints	= &messaging_endpoints,
	.authservices	= &messaging_authservices
};

#endif /* SKIP_NDR_TABLE_messaging */
