/* Db.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Db.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <config.h>

#define DB_IN_MEMORY_NAME ":memory:"
#define DATABASE_TABLE_SCHEMA_VERSION 24
#define RESOURCES_APP_VERSION _VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	DB_VERIFY_RESULT_OK,
	DB_VERIFY_RESULT_FUTURE_VERSION,
	DB_VERIFY_RESULT_UPGRADE_ERROR,
	DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE
} DbVerifyResult;

#define DB_TYPE_VERIFY_RESULT (db_verify_result_get_type ())

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VERSION_TABLE (version_table_get_type ())
#define VERSION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VERSION_TABLE, VersionTable))
#define VERSION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VERSION_TABLE, VersionTableClass))
#define IS_VERSION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VERSION_TABLE))
#define IS_VERSION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VERSION_TABLE))
#define VERSION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VERSION_TABLE, VersionTableClass))

typedef struct _VersionTable VersionTable;
typedef struct _VersionTableClass VersionTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_FACE_TABLE (face_table_get_type ())
#define FACE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_TABLE, FaceTable))
#define FACE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_TABLE, FaceTableClass))
#define IS_FACE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_TABLE))
#define IS_FACE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_TABLE))
#define FACE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_TABLE, FaceTableClass))

typedef struct _FaceTable FaceTable;
typedef struct _FaceTableClass FaceTableClass;

#define TYPE_FACE_LOCATION_TABLE (face_location_table_get_type ())
#define FACE_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION_TABLE, FaceLocationTable))
#define FACE_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION_TABLE, FaceLocationTableClass))
#define IS_FACE_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION_TABLE))
#define IS_FACE_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION_TABLE))
#define FACE_LOCATION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION_TABLE, FaceLocationTableClass))

typedef struct _FaceLocationTable FaceLocationTable;
typedef struct _FaceLocationTableClass FaceLocationTableClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

VALA_EXTERN gchar* db_filename;
gchar* db_filename = NULL;

VALA_EXTERN void db_preconfigure (GFile* db_file);
VALA_EXTERN void db_init (GError** error);
VALA_EXTERN void database_table_init (const gchar* filename);
VALA_EXTERN void db_terminate (void);
VALA_EXTERN void database_table_terminate (void);
VALA_EXTERN GType db_verify_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN DbVerifyResult db_verify_database (gchar** app_version,
                                   gint* schema_version);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType version_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VersionTable, database_table_unref)
VALA_EXTERN VersionTable* version_table_get_instance (void);
VALA_EXTERN gint version_table_get_version (VersionTable* self,
                                gchar** app_version);
VALA_EXTERN void version_table_set_version (VersionTable* self,
                                gint version,
                                const gchar* app_version,
                                const gchar* user_data);
VALA_EXTERN DbVerifyResult db_upgrade_database (gint input_version);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_table_clean_comments (GError** error);
VALA_EXTERN void video_table_clean_comments (GError** error);
VALA_EXTERN gboolean database_table_has_column (const gchar* table_name,
                                    const gchar* column_name);
VALA_EXTERN gboolean database_table_add_column (const gchar* table_name,
                                    const gchar* column_name,
                                    const gchar* column_constraints);
VALA_EXTERN gboolean database_table_has_table (const gchar* table_name);
VALA_EXTERN gboolean database_table_ensure_column (const gchar* table_name,
                                       const gchar* column_name,
                                       const gchar* column_constraints,
                                       const gchar* upgrade_msg);
VALA_EXTERN void tag_table_upgrade_for_htags (void);
VALA_EXTERN void gsettings_configuration_engine_run_gsettings_migrator (void);
VALA_EXTERN gpointer application_ref (gpointer instance);
VALA_EXTERN void application_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_application (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_application (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_application (const GValue* value);
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, application_unref)
VALA_EXTERN Application* application_get_instance (void);
VALA_EXTERN void application_set_raw_thumbs_fix_required (Application* self,
                                              gboolean should_fixup);
VALA_EXTERN GType face_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceTable, database_table_unref)
VALA_EXTERN FaceTable* face_table_get_instance (void);
VALA_EXTERN GType face_location_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocationTable, database_table_unref)
VALA_EXTERN FaceLocationTable* face_location_table_get_instance (void);
VALA_EXTERN void gsettings_configuration_engine_run_gsettings_migrator_v2 (void);
VALA_EXTERN void photo_table_upgrade_for_unset_timestamp (GError** error);
VALA_EXTERN void video_table_upgrade_for_unset_timestamp (GError** error);
VALA_EXTERN void version_table_update_version (VersionTable* self,
                                   gint version,
                                   const gchar* app_version);

void
db_preconfigure (GFile* db_file)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail ((db_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (db_file, g_file_get_type ()));
	if (db_file != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_file_get_path (db_file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (DB_IN_MEMORY_NAME);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (db_filename);
	db_filename = _tmp3_;
	_g_free0 (_tmp0_);
}

void
db_init (GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = db_filename;
	_vala_assert (_tmp0_ != NULL, "filename != null");
	_tmp1_ = db_filename;
	database_table_init (_tmp1_);
}

void
db_terminate (void)
{
	database_table_terminate ();
}

static GType
db_verify_result_get_type_once (void)
{
	static const GEnumValue values[] = {{DB_VERIFY_RESULT_OK, "DB_VERIFY_RESULT_OK", "ok"}, {DB_VERIFY_RESULT_FUTURE_VERSION, "DB_VERIFY_RESULT_FUTURE_VERSION", "future-version"}, {DB_VERIFY_RESULT_UPGRADE_ERROR, "DB_VERIFY_RESULT_UPGRADE_ERROR", "upgrade-error"}, {DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE, "DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE", "no-upgrade-available"}, {0, NULL, NULL}};
	GType db_verify_result_type_id;
	db_verify_result_type_id = g_enum_register_static ("DbVerifyResult", values);
	return db_verify_result_type_id;
}

GType
db_verify_result_get_type (void)
{
	static volatile gsize db_verify_result_type_id__once = 0;
	if (g_once_init_enter (&db_verify_result_type_id__once)) {
		GType db_verify_result_type_id;
		db_verify_result_type_id = db_verify_result_get_type_once ();
		g_once_init_leave (&db_verify_result_type_id__once, db_verify_result_type_id);
	}
	return db_verify_result_type_id__once;
}

DbVerifyResult
db_verify_database (gchar** app_version,
                    gint* schema_version)
{
	gchar* _vala_app_version = NULL;
	gint _vala_schema_version = 0;
	VersionTable* version_table = NULL;
	VersionTable* _tmp0_;
	VersionTable* _tmp1_;
	gchar* _tmp2_ = NULL;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	DbVerifyResult result;
	_tmp0_ = version_table_get_instance ();
	version_table = _tmp0_;
	_tmp1_ = version_table;
	_tmp3_ = version_table_get_version (_tmp1_, &_tmp2_);
	_g_free0 (_vala_app_version);
	_vala_app_version = _tmp2_;
	_vala_schema_version = _tmp3_;
	if (_vala_schema_version >= 0) {
		const gchar* _tmp4_;
		_tmp4_ = _vala_app_version;
		g_debug ("Db.vala:40: Database schema version %d created by app version %s", _vala_schema_version, _tmp4_);
	}
	if (_vala_schema_version == -1) {
		VersionTable* _tmp5_;
		gchar* _tmp6_;
		g_debug ("Db.vala:44: Creating database schema version %d for app version %s", DATABASE_TABLE_SCHEMA_VERSION, RESOURCES_APP_VERSION);
		_tmp5_ = version_table;
		version_table_set_version (_tmp5_, DATABASE_TABLE_SCHEMA_VERSION, RESOURCES_APP_VERSION, NULL);
		_tmp6_ = g_strdup (RESOURCES_APP_VERSION);
		_g_free0 (_vala_app_version);
		_vala_app_version = _tmp6_;
		_vala_schema_version = DATABASE_TABLE_SCHEMA_VERSION;
	} else {
		if (_vala_schema_version > DATABASE_TABLE_SCHEMA_VERSION) {
			result = DB_VERIFY_RESULT_FUTURE_VERSION;
			_database_table_unref0 (version_table);
			if (app_version) {
				*app_version = _vala_app_version;
			} else {
				_g_free0 (_vala_app_version);
			}
			if (schema_version) {
				*schema_version = _vala_schema_version;
			}
			return result;
		} else {
			if (_vala_schema_version < DATABASE_TABLE_SCHEMA_VERSION) {
				DbVerifyResult _result_ = 0;
				_result_ = db_upgrade_database (_vala_schema_version);
				if (_result_ != DB_VERIFY_RESULT_OK) {
					result = _result_;
					_database_table_unref0 (version_table);
					if (app_version) {
						*app_version = _vala_app_version;
					} else {
						_g_free0 (_vala_app_version);
					}
					if (schema_version) {
						*schema_version = _vala_schema_version;
					}
					return result;
				}
			}
		}
	}
	{
		photo_table_clean_comments (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_database_table_unref0 (version_table);
			_g_free0 (_vala_app_version);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		video_table_clean_comments (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_database_table_unref0 (version_table);
			_g_free0 (_vala_app_version);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_debug ("Db.vala:63: Ignoring database error while clean ing comments: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_database_table_unref0 (version_table);
		_g_free0 (_vala_app_version);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	result = DB_VERIFY_RESULT_OK;
	_database_table_unref0 (version_table);
	if (app_version) {
		*app_version = _vala_app_version;
	} else {
		_g_free0 (_vala_app_version);
	}
	if (schema_version) {
		*schema_version = _vala_schema_version;
	}
	return result;
}

DbVerifyResult
db_upgrade_database (gint input_version)
{
	gint version = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	FaceTable* _tmp5_;
	FaceTable* _tmp6_;
	FaceLocationTable* _tmp7_;
	FaceLocationTable* _tmp8_;
	VersionTable* _tmp11_;
	VersionTable* _tmp12_;
	GError* _inner_error0_ = NULL;
	DbVerifyResult result;
	_vala_assert (input_version < DATABASE_TABLE_SCHEMA_VERSION, "input_version < DatabaseTable.SCHEMA_VERSION");
	version = input_version;
	if (version == 1) {
		result = DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE;
		return result;
	}
	g_message ("Db.vala:79: Upgrading database from schema version %d to %d", version, DATABASE_TABLE_SCHEMA_VERSION);
	if (!database_table_has_column ("PhotoTable", "flags")) {
		g_message ("Db.vala:92: upgrade_database: adding flags column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "flags", "INTEGER DEFAULT 0")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 3;
	if (!database_table_has_column ("PhotoTable", "file_format")) {
		g_message ("Db.vala:109: upgrade_database: adding file_format column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "file_format", "INTEGER DEFAULT 0")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 4;
	if (!database_table_has_column ("PhotoTable", "title")) {
		g_message ("Db.vala:122: upgrade_database: adding title column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "title", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 5;
	if (!database_table_has_column ("PhotoTable", "backlinks")) {
		g_message ("Db.vala:135: upgrade_database: adding backlinks column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "backlinks", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 6;
	if (!database_table_has_column ("PhotoTable", "time_reimported")) {
		g_message ("Db.vala:155: upgrade_database: adding time_reimported column to PhotoT" \
"able");
		if (!database_table_add_column ("PhotoTable", "time_reimported", "INTEGER")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("PhotoTable", "editable_id")) {
		g_message ("Db.vala:161: upgrade_database: adding editable_id column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "editable_id", "INTEGER DEFAULT -1")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 7;
	if (!database_table_has_column ("PhotoTable", "rating")) {
		g_message ("Db.vala:179: upgrade_database: adding rating column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "rating", "INTEGER DEFAULT 0")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("PhotoTable", "metadata_dirty")) {
		g_message ("Db.vala:191: upgrade_database: adding metadata_dirty column to PhotoTa" \
"ble");
		if (!database_table_add_column ("PhotoTable", "metadata_dirty", "INTEGER DEFAULT 1")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 9;
	if (database_table_has_table ("VideoTable")) {
		_tmp0_ = !database_table_has_column ("VideoTable", "flags");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_message ("Db.vala:204: upgrade_database: adding flags column to VideoTable");
		if (!database_table_add_column ("VideoTable", "flags", "INTEGER DEFAULT 0")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 10;
	if (!database_table_has_column ("EventTable", "primary_source_id")) {
		g_message ("Db.vala:217: upgrade_database: adding primary_source_id column to Even" \
"tTable");
		if (!database_table_add_column ("EventTable", "primary_source_id", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 11;
	if (!database_table_ensure_column ("TombstoneTable", "reason", "INTEGER DEFAULT 0", "upgrade_database: adding reason column to TombstoneTable")) {
		result = DB_VERIFY_RESULT_UPGRADE_ERROR;
		return result;
	}
	version = 12;
	if (!database_table_has_column ("PhotoTable", "developer")) {
		g_message ("Db.vala:242: upgrade_database: adding developer column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "developer", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("PhotoTable", "develop_shotwell_id")) {
		g_message ("Db.vala:248: upgrade_database: adding develop_shotwell_id column to Ph" \
"otoTable");
		if (!database_table_add_column ("PhotoTable", "develop_shotwell_id", "INTEGER DEFAULT -1")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("PhotoTable", "develop_camera_id")) {
		g_message ("Db.vala:254: upgrade_database: adding develop_camera_id column to Phot" \
"oTable");
		if (!database_table_add_column ("PhotoTable", "develop_camera_id", "INTEGER DEFAULT -1")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("PhotoTable", "develop_embedded_id")) {
		g_message ("Db.vala:260: upgrade_database: adding develop_embedded_id column to Ph" \
"otoTable");
		if (!database_table_add_column ("PhotoTable", "develop_embedded_id", "INTEGER DEFAULT -1")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 13;
	if (input_version < 14) {
		tag_table_upgrade_for_htags ();
	}
	version = 14;
	version = 15;
	if (input_version < 16) {
		gsettings_configuration_engine_run_gsettings_migrator ();
	}
	version = 16;
	if (!database_table_has_column ("PhotoTable", "comment")) {
		g_message ("Db.vala:311: upgrade_database: adding comment column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "comment", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (database_table_has_table ("VideoTable") & (!database_table_has_column ("VideoTable", "comment"))) {
		g_message ("Db.vala:316: upgrade_database: adding comment column to VideoTable");
		if (!database_table_add_column ("VideoTable", "comment", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 17;
	if (!database_table_has_column ("EventTable", "comment")) {
		g_message ("Db.vala:329: upgrade_database: adding comment column to EventTable");
		if (!database_table_add_column ("EventTable", "comment", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 18;
	if (input_version < 19) {
		Application* _tmp1_;
		Application* _tmp2_;
		_tmp1_ = application_get_instance ();
		_tmp2_ = _tmp1_;
		application_set_raw_thumbs_fix_required (_tmp2_, TRUE);
		_application_unref0 (_tmp2_);
	}
	version = 19;
	version = 20;
	if (!database_table_ensure_column ("PhotoTable", "has_gps", "INTEGER DEFAULT -1", "upgrade_database: adding gps_lat column to PhotoTable")) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = !database_table_ensure_column ("PhotoTable", "gps_lat", "REAL", "upgrade_database: adding gps_lat column to PhotoTable");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = !database_table_ensure_column ("PhotoTable", "gps_lon", "REAL", "upgrade_database: adding gps_lon column to PhotoTable");
	}
	if (_tmp3_) {
		result = DB_VERIFY_RESULT_UPGRADE_ERROR;
		return result;
	}
	version = 21;
	_tmp5_ = face_table_get_instance ();
	_tmp6_ = _tmp5_;
	_database_table_unref0 (_tmp6_);
	_tmp7_ = face_location_table_get_instance ();
	_tmp8_ = _tmp7_;
	_database_table_unref0 (_tmp8_);
	if (!database_table_has_column ("FaceLocationTable", "vec")) {
		g_message ("Db.vala:386: upgrade_database: adding vec column to FaceLocationTable");
		if (!database_table_add_column ("FaceLocationTable", "vec", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("FaceLocationTable", "guess")) {
		g_message ("Db.vala:391: upgrade_database: adding guess column to FaceLocationTabl" \
"e");
		if (!database_table_add_column ("FaceLocationTable", "guess", "INTEGER DEFAULT 0")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("FaceTable", "ref")) {
		g_message ("Db.vala:396: upgrade_database: adding ref column to FaceTable");
		if (!database_table_add_column ("FaceTable", "ref", "INTEGER DEFAULT -1")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 22;
	if (input_version < 23) {
		gsettings_configuration_engine_run_gsettings_migrator_v2 ();
	}
	version = 23;
	if (input_version < 24) {
		g_message ("Db.vala:416: upgrade_database: Shifting times from 0 to null for unset" \
" times");
		{
			photo_table_upgrade_for_unset_timestamp (&_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return 0;
			}
			video_table_upgrade_for_unset_timestamp (&_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return 0;
			}
			version = 24;
		}
		goto __finally0;
		__catch0_database_error:
		{
			GError* err = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = err;
			_tmp10_ = _tmp9_->message;
			g_critical ("Db.vala:422: Failed to upgrade database to version 24: %s", _tmp10_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	_vala_assert (version == DATABASE_TABLE_SCHEMA_VERSION, "version == DatabaseTable.SCHEMA_VERSION");
	_tmp11_ = version_table_get_instance ();
	_tmp12_ = _tmp11_;
	version_table_update_version (_tmp12_, version, RESOURCES_APP_VERSION);
	_database_table_unref0 (_tmp12_);
	g_message ("Db.vala:429: Database upgrade to schema version %d successful", version);
	result = DB_VERIFY_RESULT_OK;
	return result;
}

