/* This is a generated file! */
/* Generated by `utils/build_lexers.py` via `utils/rustify.py` */
/* This process can be run via tox: `tox -e generate-rs` */
#![cfg_attr(rustfmt, rustfmt_skip)]
use once_cell::sync::Lazy;
use sqlfluffrs_types::LexMatcher;
use sqlfluffrs_types::{Token, RegexModeGroup};
use sqlfluffrs_types::token::CaseFold;

pub static TSQL_KEYWORDS: Lazy<Vec<String>> = Lazy::new(|| { vec![
    "ADD".to_string(),
    "ALL".to_string(),
    "ALTER".to_string(),
    "AND".to_string(),
    "ANY".to_string(),
    "AS".to_string(),
    "ASC".to_string(),
    "AUTHORIZATION".to_string(),
    "BACKUP".to_string(),
    "BEGIN".to_string(),
    "BETWEEN".to_string(),
    "BREAK".to_string(),
    "BROWSE".to_string(),
    "BULK".to_string(),
    "BY".to_string(),
    "CASCADE".to_string(),
    "CASE".to_string(),
    "CHECK".to_string(),
    "CHECKPOINT".to_string(),
    "CLOSE".to_string(),
    "CLUSTERED".to_string(),
    "COALESCE".to_string(),
    "COLLATE".to_string(),
    "COLUMN".to_string(),
    "COMMIT".to_string(),
    "COMPUTE".to_string(),
    "CONSTRAINT".to_string(),
    "CONTAINS".to_string(),
    "CONTAINSTABLE".to_string(),
    "CONTINUE".to_string(),
    "CONVERT".to_string(),
    "CREATE".to_string(),
    "CROSS".to_string(),
    "CURRENT".to_string(),
    "CURRENT_DATE".to_string(),
    "CURRENT_TIME".to_string(),
    "CURRENT_TIMESTAMP".to_string(),
    "CURRENT_USER".to_string(),
    "CURSOR".to_string(),
    "DATABASE".to_string(),
    "DBCC".to_string(),
    "DEALLOCATE".to_string(),
    "DECLARE".to_string(),
    "DEFAULT".to_string(),
    "DELETE".to_string(),
    "DENY".to_string(),
    "DESC".to_string(),
    "DISK".to_string(),
    "DISTINCT".to_string(),
    "DISTRIBUTED".to_string(),
    "DOUBLE".to_string(),
    "DROP".to_string(),
    "DUMP".to_string(),
    "ELSE".to_string(),
    "END".to_string(),
    "ERRLVL".to_string(),
    "ESCAPE".to_string(),
    "EXCEPT".to_string(),
    "EXEC".to_string(),
    "EXECUTE".to_string(),
    "EXISTS".to_string(),
    "EXIT".to_string(),
    "EXTERNAL".to_string(),
    "FETCH".to_string(),
    "FILE".to_string(),
    "FILLFACTOR".to_string(),
    "FOR".to_string(),
    "FOREIGN".to_string(),
    "FREETEXT".to_string(),
    "FREETEXTTABLE".to_string(),
    "FROM".to_string(),
    "FULL".to_string(),
    "FUNCTION".to_string(),
    "GO".to_string(),
    "GOTO".to_string(),
    "GRANT".to_string(),
    "GROUP".to_string(),
    "HAVING".to_string(),
    "HOLDLOCK".to_string(),
    "IDENTITY".to_string(),
    "IDENTITYCOL".to_string(),
    "IDENTITY_INSERT".to_string(),
    "IF".to_string(),
    "IN".to_string(),
    "INDEX".to_string(),
    "INNER".to_string(),
    "INSERT".to_string(),
    "INTERSECT".to_string(),
    "INTO".to_string(),
    "IS".to_string(),
    "JOIN".to_string(),
    "KEY".to_string(),
    "KILL".to_string(),
    "LEFT".to_string(),
    "LIKE".to_string(),
    "LINENO".to_string(),
    "LOAD".to_string(),
    "MERGE".to_string(),
    "NATIONAL".to_string(),
    "NOCHECK".to_string(),
    "NONCLUSTERED".to_string(),
    "NOT".to_string(),
    "NULL".to_string(),
    "NULLIF".to_string(),
    "OF".to_string(),
    "OFF".to_string(),
    "OFFSETS".to_string(),
    "ON".to_string(),
    "OPEN".to_string(),
    "OPENDATASOURCE".to_string(),
    "OPENQUERY".to_string(),
    "OPENROWSET".to_string(),
    "OPENXML".to_string(),
    "OPTION".to_string(),
    "OR".to_string(),
    "ORDER".to_string(),
    "OUTER".to_string(),
    "OVER".to_string(),
    "PERCENT".to_string(),
    "PIVOT".to_string(),
    "PLAN".to_string(),
    "PRECISION".to_string(),
    "PRIMARY".to_string(),
    "PRINT".to_string(),
    "PROC".to_string(),
    "PROCEDURE".to_string(),
    "PUBLIC".to_string(),
    "RAISERROR".to_string(),
    "READ".to_string(),
    "READTEXT".to_string(),
    "RECONFIGURE".to_string(),
    "REFERENCES".to_string(),
    "REPLICATION".to_string(),
    "RESTORE".to_string(),
    "RESTRICT".to_string(),
    "RETURN".to_string(),
    "REVERT".to_string(),
    "REVOKE".to_string(),
    "RIGHT".to_string(),
    "ROLLBACK".to_string(),
    "ROWCOUNT".to_string(),
    "ROWGUIDCOL".to_string(),
    "RULE".to_string(),
    "SAVE".to_string(),
    "SCHEMA".to_string(),
    "SECURITYAUDIT".to_string(),
    "SELECT".to_string(),
    "SEMANTICKEYPHRASETABLE".to_string(),
    "SEMANTICSIMILARITYDETAILSTABLE".to_string(),
    "SEMANTICSIMILARITYTABLE".to_string(),
    "SESSION_USER".to_string(),
    "SET".to_string(),
    "SETUSER".to_string(),
    "SHUTDOWN".to_string(),
    "SOME".to_string(),
    "STATISTICS".to_string(),
    "SYSTEM_USER".to_string(),
    "TABLE".to_string(),
    "TABLESAMPLE".to_string(),
    "TEXTSIZE".to_string(),
    "THEN".to_string(),
    "TO".to_string(),
    "TOP".to_string(),
    "TRAN".to_string(),
    "TRANSACTION".to_string(),
    "TRIGGER".to_string(),
    "TRUNCATE".to_string(),
    "TRY_CONVERT".to_string(),
    "TSEQUAL".to_string(),
    "UNION".to_string(),
    "UNIQUE".to_string(),
    "UNPIVOT".to_string(),
    "UPDATE".to_string(),
    "UPDATETEXT".to_string(),
    "USE".to_string(),
    "USER".to_string(),
    "VALUES".to_string(),
    "VARYING".to_string(),
    "VIEW".to_string(),
    "WAITFOR".to_string(),
    "WHEN".to_string(),
    "WHERE".to_string(),
    "WHILE".to_string(),
    "WITH".to_string(),
    "WITHIN GROUP".to_string(),
    "WRITETEXT".to_string(),
]});

pub static TSQL_LEXERS: Lazy<Vec<LexMatcher>> = Lazy::new(|| { vec![

    LexMatcher::regex_lexer(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "inline_comment",
        r#"(--)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        Some(vec![String::from("-"), String::from("-")]),
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['#','-','/']),
        None,
    ),

    LexMatcher::regex_lexer(
        "block_comment",
        r#"/\*(?>[^*/]+|\*(?!\/)|/[^*])*(?>(?R)(?>[^*/]+|\*(?!\/)|/[^*])*)*\*/"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        None,
        None,
        None,
        None,
        CaseFold::None,
        Some(extract_nested_block_comment),
        |input| input.starts_with("/"),
        None,
    ),

    LexMatcher::regex_lexer(
        "single_quote",
        r#"'([^']|'')*'"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'\'', ..] => true,                     // Single quote case
        [b'R' | b'r', b'\'', ..] => true,        // r' or R'
        [b'B' | b'b', b'\'', ..] => true,        // b' or B'
        [b'R' | b'r', b'B' | b'b', b'\'', ..] => true, // rb', RB', etc.
        [b'B' | b'b', b'R' | b'r', b'\'', ..] => true, // br', Br', etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "double_quote",
        r#""(""|[^"\\]|\\.)*""#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#""((?:[^"\\]|\\.)*)""#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\"|"""#.to_string(), r#"""#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'"', ..] => true,                     // Just a double quote
        [b'R' | b'r', b'"', ..] => true,        // r" or R"
        [b'B' | b'b', b'"', ..] => true,        // b" or B"
        [b'R' | b'r', b'B' | b'b', b'"', ..] => true, // rb", RB", etc.
        [b'B' | b'b', b'R' | b'r', b'"', ..] => true, // br", Br", etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "atsign",
        r#"[@][a-zA-Z0-9_@$#]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "square_quote",
        r#"\[([^\[\]]*)*\]"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"\[([^\[\]]*)\]"#.to_string(), RegexModeGroup::Index(1))),
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "single_quote_with_n",
        r#"N'([^']|'')*'"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"N'((?:[^']|'')*)'"#.to_string(), RegexModeGroup::Index(1))),
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "hash_prefix",
        r#"[#][#]?[a-zA-Z0-9_@$#]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "unquoted_relative_sql_file_path",
        r#"[.\w\\/#-]+\.[sS][qQ][lL]\b"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "back_quote",
        r#"`(?:[^`\\]|\\.)*`"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"`((?:[^`\\]|\\.)*)`"#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\`"#.to_string(), r#"`"#.to_string())),
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "dollar_quote",
        r#"\$(\w*)\$(.*?)\$\1\$"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"\$(\w*)\$(.*?)\$\1\$"#.to_string(), RegexModeGroup::Index(2))),
        None,
        CaseFold::None,
        None,
        |input| input.starts_with("$"),
        None,
    ),

    LexMatcher::regex_lexer(
        "numeric_literal",
        r#"(?>\d+\.\d+|\d+\.(?![\.\w])|\.\d+|\d+)(\.?[eE][+-]?\d+)?((?<=\.)|(?=\b))"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::literal_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['x','X','.','0','1','2','3','4','5','6','7','8','9']),
        None,
    ),

    LexMatcher::regex_lexer(
        "obevo_annotation",
        r#"////\s*(CHANGE|BODY|METADATA)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "glob_operator",
        "~~~",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "like_operator",
        r#"!?~~?\*?"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "casting_operator",
        "::",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "equals",
        "=",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "greater_than",
        ">",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "less_than",
        "<",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "not",
        "!",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "dot",
        ".",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "comma",
        ",",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "plus",
        "+",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "minus",
        "-",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "divide",
        "/",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "percent",
        "%",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "question",
        "?",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "ampersand",
        "&",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "vertical_bar",
        "|",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "caret",
        "^",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "star",
        "*",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_bracket",
        "(",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_bracket",
        ")",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_square_bracket",
        "[",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_square_bracket",
        "]",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_curly_bracket",
        "{",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_curly_bracket",
        "}",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "colon",
        ":",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "semicolon",
        ";",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "numeric_literal",
        r#"([xX]'([\da-fA-F][\da-fA-F])+'|0[xX][\da-fA-F]*)"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::literal_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['x','X','.','0','1','2','3','4','5','6','7','8','9']),
        None,
    ),

    LexMatcher::regex_lexer(
        "word",
        r#"[0-9a-zA-Z_#@$\p{L}]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::word_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),
]});


// Wrapper function that passes the dialect name to the shared implementation
fn extract_nested_block_comment(input: &str) -> Option<&str> {
    crate::extract_nested_block_comment(input, "tsql")
}
