//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#include "pxr/usd/usdPhysics/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

UsdPhysicsTokensType::UsdPhysicsTokensType() :
    acceleration("acceleration", TfToken::Immortal),
    angular("angular", TfToken::Immortal),
    boundingCube("boundingCube", TfToken::Immortal),
    boundingSphere("boundingSphere", TfToken::Immortal),
    colliders("colliders", TfToken::Immortal),
    convexDecomposition("convexDecomposition", TfToken::Immortal),
    convexHull("convexHull", TfToken::Immortal),
    distance("distance", TfToken::Immortal),
    drive("drive", TfToken::Immortal),
    drive_MultipleApplyTemplate_PhysicsDamping("drive:__INSTANCE_NAME__:physics:damping", TfToken::Immortal),
    drive_MultipleApplyTemplate_PhysicsMaxForce("drive:__INSTANCE_NAME__:physics:maxForce", TfToken::Immortal),
    drive_MultipleApplyTemplate_PhysicsStiffness("drive:__INSTANCE_NAME__:physics:stiffness", TfToken::Immortal),
    drive_MultipleApplyTemplate_PhysicsTargetPosition("drive:__INSTANCE_NAME__:physics:targetPosition", TfToken::Immortal),
    drive_MultipleApplyTemplate_PhysicsTargetVelocity("drive:__INSTANCE_NAME__:physics:targetVelocity", TfToken::Immortal),
    drive_MultipleApplyTemplate_PhysicsType("drive:__INSTANCE_NAME__:physics:type", TfToken::Immortal),
    force("force", TfToken::Immortal),
    kilogramsPerUnit("kilogramsPerUnit", TfToken::Immortal),
    limit("limit", TfToken::Immortal),
    limit_MultipleApplyTemplate_PhysicsHigh("limit:__INSTANCE_NAME__:physics:high", TfToken::Immortal),
    limit_MultipleApplyTemplate_PhysicsLow("limit:__INSTANCE_NAME__:physics:low", TfToken::Immortal),
    linear("linear", TfToken::Immortal),
    meshSimplification("meshSimplification", TfToken::Immortal),
    none("none", TfToken::Immortal),
    physicsAngularVelocity("physics:angularVelocity", TfToken::Immortal),
    physicsApproximation("physics:approximation", TfToken::Immortal),
    physicsAxis("physics:axis", TfToken::Immortal),
    physicsBody0("physics:body0", TfToken::Immortal),
    physicsBody1("physics:body1", TfToken::Immortal),
    physicsBreakForce("physics:breakForce", TfToken::Immortal),
    physicsBreakTorque("physics:breakTorque", TfToken::Immortal),
    physicsCenterOfMass("physics:centerOfMass", TfToken::Immortal),
    physicsCollisionEnabled("physics:collisionEnabled", TfToken::Immortal),
    physicsConeAngle0Limit("physics:coneAngle0Limit", TfToken::Immortal),
    physicsConeAngle1Limit("physics:coneAngle1Limit", TfToken::Immortal),
    physicsDensity("physics:density", TfToken::Immortal),
    physicsDiagonalInertia("physics:diagonalInertia", TfToken::Immortal),
    physicsDynamicFriction("physics:dynamicFriction", TfToken::Immortal),
    physicsExcludeFromArticulation("physics:excludeFromArticulation", TfToken::Immortal),
    physicsFilteredGroups("physics:filteredGroups", TfToken::Immortal),
    physicsFilteredPairs("physics:filteredPairs", TfToken::Immortal),
    physicsGravityDirection("physics:gravityDirection", TfToken::Immortal),
    physicsGravityMagnitude("physics:gravityMagnitude", TfToken::Immortal),
    physicsInvertFilteredGroups("physics:invertFilteredGroups", TfToken::Immortal),
    physicsJointEnabled("physics:jointEnabled", TfToken::Immortal),
    physicsKinematicEnabled("physics:kinematicEnabled", TfToken::Immortal),
    physicsLocalPos0("physics:localPos0", TfToken::Immortal),
    physicsLocalPos1("physics:localPos1", TfToken::Immortal),
    physicsLocalRot0("physics:localRot0", TfToken::Immortal),
    physicsLocalRot1("physics:localRot1", TfToken::Immortal),
    physicsLowerLimit("physics:lowerLimit", TfToken::Immortal),
    physicsMass("physics:mass", TfToken::Immortal),
    physicsMaxDistance("physics:maxDistance", TfToken::Immortal),
    physicsMergeGroup("physics:mergeGroup", TfToken::Immortal),
    physicsMinDistance("physics:minDistance", TfToken::Immortal),
    physicsPrincipalAxes("physics:principalAxes", TfToken::Immortal),
    physicsRestitution("physics:restitution", TfToken::Immortal),
    physicsRigidBodyEnabled("physics:rigidBodyEnabled", TfToken::Immortal),
    physicsSimulationOwner("physics:simulationOwner", TfToken::Immortal),
    physicsStartsAsleep("physics:startsAsleep", TfToken::Immortal),
    physicsStaticFriction("physics:staticFriction", TfToken::Immortal),
    physicsUpperLimit("physics:upperLimit", TfToken::Immortal),
    physicsVelocity("physics:velocity", TfToken::Immortal),
    rotX("rotX", TfToken::Immortal),
    rotY("rotY", TfToken::Immortal),
    rotZ("rotZ", TfToken::Immortal),
    transX("transX", TfToken::Immortal),
    transY("transY", TfToken::Immortal),
    transZ("transZ", TfToken::Immortal),
    x("X", TfToken::Immortal),
    y("Y", TfToken::Immortal),
    z("Z", TfToken::Immortal),
    PhysicsArticulationRootAPI("PhysicsArticulationRootAPI", TfToken::Immortal),
    PhysicsCollisionAPI("PhysicsCollisionAPI", TfToken::Immortal),
    PhysicsCollisionGroup("PhysicsCollisionGroup", TfToken::Immortal),
    PhysicsDistanceJoint("PhysicsDistanceJoint", TfToken::Immortal),
    PhysicsDriveAPI("PhysicsDriveAPI", TfToken::Immortal),
    PhysicsFilteredPairsAPI("PhysicsFilteredPairsAPI", TfToken::Immortal),
    PhysicsFixedJoint("PhysicsFixedJoint", TfToken::Immortal),
    PhysicsJoint("PhysicsJoint", TfToken::Immortal),
    PhysicsLimitAPI("PhysicsLimitAPI", TfToken::Immortal),
    PhysicsMassAPI("PhysicsMassAPI", TfToken::Immortal),
    PhysicsMaterialAPI("PhysicsMaterialAPI", TfToken::Immortal),
    PhysicsMeshCollisionAPI("PhysicsMeshCollisionAPI", TfToken::Immortal),
    PhysicsPrismaticJoint("PhysicsPrismaticJoint", TfToken::Immortal),
    PhysicsRevoluteJoint("PhysicsRevoluteJoint", TfToken::Immortal),
    PhysicsRigidBodyAPI("PhysicsRigidBodyAPI", TfToken::Immortal),
    PhysicsScene("PhysicsScene", TfToken::Immortal),
    PhysicsSphericalJoint("PhysicsSphericalJoint", TfToken::Immortal),
    allTokens({
        acceleration,
        angular,
        boundingCube,
        boundingSphere,
        colliders,
        convexDecomposition,
        convexHull,
        distance,
        drive,
        drive_MultipleApplyTemplate_PhysicsDamping,
        drive_MultipleApplyTemplate_PhysicsMaxForce,
        drive_MultipleApplyTemplate_PhysicsStiffness,
        drive_MultipleApplyTemplate_PhysicsTargetPosition,
        drive_MultipleApplyTemplate_PhysicsTargetVelocity,
        drive_MultipleApplyTemplate_PhysicsType,
        force,
        kilogramsPerUnit,
        limit,
        limit_MultipleApplyTemplate_PhysicsHigh,
        limit_MultipleApplyTemplate_PhysicsLow,
        linear,
        meshSimplification,
        none,
        physicsAngularVelocity,
        physicsApproximation,
        physicsAxis,
        physicsBody0,
        physicsBody1,
        physicsBreakForce,
        physicsBreakTorque,
        physicsCenterOfMass,
        physicsCollisionEnabled,
        physicsConeAngle0Limit,
        physicsConeAngle1Limit,
        physicsDensity,
        physicsDiagonalInertia,
        physicsDynamicFriction,
        physicsExcludeFromArticulation,
        physicsFilteredGroups,
        physicsFilteredPairs,
        physicsGravityDirection,
        physicsGravityMagnitude,
        physicsInvertFilteredGroups,
        physicsJointEnabled,
        physicsKinematicEnabled,
        physicsLocalPos0,
        physicsLocalPos1,
        physicsLocalRot0,
        physicsLocalRot1,
        physicsLowerLimit,
        physicsMass,
        physicsMaxDistance,
        physicsMergeGroup,
        physicsMinDistance,
        physicsPrincipalAxes,
        physicsRestitution,
        physicsRigidBodyEnabled,
        physicsSimulationOwner,
        physicsStartsAsleep,
        physicsStaticFriction,
        physicsUpperLimit,
        physicsVelocity,
        rotX,
        rotY,
        rotZ,
        transX,
        transY,
        transZ,
        x,
        y,
        z,
        PhysicsArticulationRootAPI,
        PhysicsCollisionAPI,
        PhysicsCollisionGroup,
        PhysicsDistanceJoint,
        PhysicsDriveAPI,
        PhysicsFilteredPairsAPI,
        PhysicsFixedJoint,
        PhysicsJoint,
        PhysicsLimitAPI,
        PhysicsMassAPI,
        PhysicsMaterialAPI,
        PhysicsMeshCollisionAPI,
        PhysicsPrismaticJoint,
        PhysicsRevoluteJoint,
        PhysicsRigidBodyAPI,
        PhysicsScene,
        PhysicsSphericalJoint
    })
{
}

TfStaticData<UsdPhysicsTokensType> UsdPhysicsTokens;

PXR_NAMESPACE_CLOSE_SCOPE
