/* PulseAudioManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PulseAudioManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2016-2018 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */
/*
 * Vocabulary of PulseAudio:
 *  - Source: Input (microphone)
 *  - Sink: Output (speaker)
 */

#include "sound.h"
#include <pulse/pulseaudio.h>
#include <pulse/glib-mainloop.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "pulse/ext-stream-restore.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_PULSE_AUDIO_MANAGER_0_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY,
	SOUND_PULSE_AUDIO_MANAGER_NUM_PROPERTIES
};
static GParamSpec* sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_NUM_PROPERTIES];
#define _pa_context_unref0(var) ((var == NULL) ? NULL : (var = (pa_context_unref (var), NULL)))
#define _pa_glib_mainloop_free0(var) ((var == NULL) ? NULL : (var = (pa_glib_mainloop_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SoundPulseAudioManagerSetDefaultDeviceData SoundPulseAudioManagerSetDefaultDeviceData;
typedef struct _Block5Data Block5Data;
#define _pa_operation_unref0(var) ((var == NULL) ? NULL : (var = (pa_operation_unref (var), NULL)))
typedef struct _SoundPulseAudioManagerSetCardProfileByIndexData SoundPulseAudioManagerSetCardProfileByIndexData;
typedef struct _Block6Data Block6Data;
typedef struct _SoundPulseAudioManagerWaitForUpdateData SoundPulseAudioManagerWaitForUpdateData;
typedef struct _Block7Data Block7Data;
typedef struct _SoundPulseAudioManagerSetSinkPortByNameData SoundPulseAudioManagerSetSinkPortByNameData;
typedef struct _Block8Data Block8Data;
typedef struct _SoundPulseAudioManagerSetSourcePortByNameData SoundPulseAudioManagerSetSourcePortByNameData;
typedef struct _Block9Data Block9Data;
typedef struct _SoundPulseAudioManagerSetDefaultSinkData SoundPulseAudioManagerSetDefaultSinkData;
typedef struct _Block10Data Block10Data;
typedef struct _SoundPulseAudioManagerSetDefaultSourceData SoundPulseAudioManagerSetDefaultSourceData;
#define _pa_proplist_free0(var) ((var == NULL) ? NULL : (var = (pa_proplist_free (var), NULL)))
typedef struct _SoundPulseAudioManagerReconnectToPulseData SoundPulseAudioManagerReconnectToPulseData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
enum  {
	SOUND_PULSE_AUDIO_MANAGER_NEW_DEVICE_SIGNAL,
	SOUND_PULSE_AUDIO_MANAGER_NUM_SIGNALS
};
static guint sound_pulse_audio_manager_signals[SOUND_PULSE_AUDIO_MANAGER_NUM_SIGNALS] = {0};

struct _SoundPulseAudioManagerPrivate {
	pa_context* context;
	pa_glib_mainloop* loop;
	gboolean is_ready;
	guint reconnect_timer_id;
	GeeHashMap* input_devices;
	GeeHashMap* output_devices;
	SoundDevice* _default_output;
	SoundDevice* _default_input;
	gchar* default_source_name;
	gchar* default_sink_name;
};

struct _SoundPulseAudioManagerSetDefaultDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	SoundDevice* device;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	pa_direction_t _tmp2_;
	pa_direction_t _tmp3_;
	const gchar* _tmp4_;
	SoundDevice* other_device;
	SoundDevice* _tmp5_;
	SoundDevice* _tmp6_;
	gchar* card_name;
	gchar* _tmp7_;
	pa_direction_t _tmp8_;
	pa_direction_t _tmp9_;
	SoundDevice* _tmp10_;
	SoundDevice* _tmp11_;
	gchar* _tmp12_;
	gchar* profile_name;
	SoundDevice* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	gpointer _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	guint32 _tmp25_;
	guint32 _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_;
	pa_direction_t _tmp30_;
	pa_direction_t _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gboolean _tmp44_;
	pa_direction_t _tmp45_;
	pa_direction_t _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	pa_direction_t _tmp61_;
	pa_direction_t _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gboolean _tmp65_;
	pa_direction_t _tmp66_;
	pa_direction_t _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gboolean _tmp71_;
	pa_direction_t _tmp72_;
	pa_direction_t _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	gboolean _tmp82_;
	pa_direction_t _tmp83_;
	pa_direction_t _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp92_;
};

struct _Block5Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	guint32 card_index;
	gchar* profile_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetCardProfileByIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	guint32 card_index;
	gchar* profile_name;
	Block5Data* _data5_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block6Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gulong handler_id;
	SoundDevice* device;
	gchar* prop_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerWaitForUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	SoundDevice* device;
	gchar* prop_name;
	Block6Data* _data6_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gulong _tmp3_;
};

struct _Block7Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	gchar* port_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetSinkPortByNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	gchar* port_name;
	Block7Data* _data7_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block8Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* source_name;
	gchar* port_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetSourcePortByNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* source_name;
	gchar* port_name;
	Block8Data* _data8_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block9Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetDefaultSinkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* sink_name;
	Block9Data* _data9_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _Block10Data {
	int _ref_count_;
	SoundPulseAudioManager* self;
	gchar* source_name;
	gpointer _async_data_;
};

struct _SoundPulseAudioManagerSetDefaultSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	gchar* source_name;
	Block10Data* _data10_;
	pa_context* _tmp0_;
	pa_operation* _tmp1_;
	pa_operation* _tmp2_;
};

struct _SoundPulseAudioManagerReconnectToPulseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPulseAudioManager* self;
	pa_context* _tmp0_;
	pa_proplist* props;
	pa_proplist* _tmp1_;
	pa_proplist* _tmp2_;
	pa_glib_mainloop* _tmp3_;
	pa_mainloop_api* _tmp4_;
	pa_proplist* _tmp5_;
	pa_context* _tmp6_;
	pa_context* _tmp7_;
	pa_context* _tmp8_;
	pa_context* _tmp9_;
	const gchar* _tmp10_;
};

static gint SoundPulseAudioManager_private_offset;
static gpointer sound_pulse_audio_manager_parent_class = NULL;
static SoundPulseAudioManager* sound_pulse_audio_manager_pam;
static SoundPulseAudioManager* sound_pulse_audio_manager_pam = NULL;
static gboolean sound_pulse_audio_manager_debug_enabled;
static gboolean sound_pulse_audio_manager_debug_enabled = FALSE;

static SoundPulseAudioManager* sound_pulse_audio_manager_new (void);
static SoundPulseAudioManager* sound_pulse_audio_manager_construct (GType object_type);
static void sound_pulse_audio_manager_reconnect_to_pulse (SoundPulseAudioManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void sound_pulse_audio_manager_reconnect_to_pulse_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_device_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_default_device_co (SoundPulseAudioManagerSetDefaultDeviceData* _data_);
static const char* _pulse_audio_direction_to_string (pa_direction_t value);
static void sound_pulse_audio_manager_set_card_profile_by_index (SoundPulseAudioManager* self,
                                                          guint32 card_index,
                                                          const gchar* profile_name,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void sound_pulse_audio_manager_set_card_profile_by_index_finish (SoundPulseAudioManager* self,
                                                                 GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_device_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void sound_pulse_audio_manager_wait_for_update (SoundPulseAudioManager* self,
                                                SoundDevice* device,
                                                const gchar* prop_name,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void sound_pulse_audio_manager_wait_for_update_finish (SoundPulseAudioManager* self,
                                                       GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_sink_port_by_name (SoundPulseAudioManager* self,
                                                      const gchar* sink_name,
                                                      const gchar* port_name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void sound_pulse_audio_manager_set_sink_port_by_name_finish (SoundPulseAudioManager* self,
                                                             GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_source_port_by_name (SoundPulseAudioManager* self,
                                                        const gchar* source_name,
                                                        const gchar* port_name,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void sound_pulse_audio_manager_set_source_port_by_name_finish (SoundPulseAudioManager* self,
                                                               GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_sink (SoundPulseAudioManager* self,
                                                 const gchar* sink_name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void sound_pulse_audio_manager_set_default_sink_finish (SoundPulseAudioManager* self,
                                                        GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_default_source (SoundPulseAudioManager* self,
                                                   const gchar* source_name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void sound_pulse_audio_manager_set_default_source_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_);
static void sound_pulse_audio_manager_set_card_profile_by_index_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_card_profile_by_index_co (SoundPulseAudioManagerSetCardProfileByIndexData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda48_ (Block5Data* _data5_,
                  pa_context* c,
                  gint success);
static void ___lambda48__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_wait_for_update_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_wait_for_update_co (SoundPulseAudioManagerWaitForUpdateData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda49_ (Block6Data* _data6_,
                  GObject* s,
                  GParamSpec* p);
static void ___lambda49__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void sound_pulse_audio_manager_set_sink_port_by_name_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_sink_port_by_name_co (SoundPulseAudioManagerSetSinkPortByNameData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda50_ (Block7Data* _data7_,
                  pa_context* c,
                  gint success);
static void ___lambda50__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_set_source_port_by_name_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_source_port_by_name_co (SoundPulseAudioManagerSetSourcePortByNameData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda51_ (Block8Data* _data8_,
                  pa_context* c,
                  gint success);
static void ___lambda51__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_set_default_sink_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_default_sink_co (SoundPulseAudioManagerSetDefaultSinkData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda52_ (Block9Data* _data9_,
                  pa_context* c,
                  gint success);
static void ___lambda52__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static void sound_pulse_audio_manager_set_default_source_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_set_default_source_co (SoundPulseAudioManagerSetDefaultSourceData* _data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda53_ (Block10Data* _data10_,
                  pa_context* c,
                  gint success);
static void ___lambda53__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static gboolean sound_pulse_audio_manager_reconnect_timeout (SoundPulseAudioManager* self);
static void sound_pulse_audio_manager_reconnect_to_pulse_data_free (gpointer _data);
static gboolean sound_pulse_audio_manager_reconnect_to_pulse_co (SoundPulseAudioManagerReconnectToPulseData* _data_);
static void sound_pulse_audio_manager_context_state_callback (SoundPulseAudioManager* self,
                                                       pa_context* c);
static void _sound_pulse_audio_manager_context_state_callback_pa_context_notify_cb_t (pa_context* c,
                                                                               gpointer self);
static void sound_pulse_audio_manager_subscribe_callback (SoundPulseAudioManager* self,
                                                   pa_context* c,
                                                   pa_subscription_event_type_t t,
                                                   guint32 index);
static void _sound_pulse_audio_manager_subscribe_callback_pa_context_subscribe_cb_t (pa_context* c,
                                                                              pa_subscription_event_type_t t,
                                                                              guint32 idx,
                                                                              gpointer self);
static void sound_pulse_audio_manager_server_info_callback (SoundPulseAudioManager* self,
                                                     pa_context* context,
                                                     pa_server_info* server);
static void _sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t (pa_context* c,
                                                                          pa_server_info* i,
                                                                          gpointer self);
static gboolean _sound_pulse_audio_manager_reconnect_timeout_gsource_func (gpointer self);
static void sound_pulse_audio_manager_sink_info_callback (SoundPulseAudioManager* self,
                                                   pa_context* c,
                                                   pa_sink_info* sink,
                                                   gint eol);
static void _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t (pa_context* c,
                                                                      pa_sink_info* i,
                                                                      gint eol,
                                                                      gpointer self);
static void sound_pulse_audio_manager_card_info_callback (SoundPulseAudioManager* self,
                                                   pa_context* c,
                                                   pa_card_info* card,
                                                   gint eol);
static void _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t (pa_context* c,
                                                                      pa_card_info* i,
                                                                      gint eol,
                                                                      gpointer self);
static void sound_pulse_audio_manager_remove_devices_by_card (SoundPulseAudioManager* self,
                                                       GeeHashMap* devices,
                                                       guint32 card_index);
static void sound_pulse_audio_manager_source_info_callback (SoundPulseAudioManager* self,
                                                     pa_context* c,
                                                     pa_source_info* source,
                                                     gint eol);
static void _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t (pa_context* c,
                                                                          pa_source_info* i,
                                                                          gint eol,
                                                                          gpointer self);
static void sound_pulse_audio_manager_set_default_input (SoundPulseAudioManager* self,
                                                  SoundDevice* value);
static void sound_pulse_audio_manager_set_default_output (SoundPulseAudioManager* self,
                                                   SoundDevice* value);
static void _vala_array_add4 (pa_card_port_info** * array,
                       gint* length,
                       gint* size,
                       pa_card_port_info* value);
static gchar* sound_pulse_audio_manager_get_device_id (pa_card_info* card,
                                                pa_card_port_info* port);
static GeeArrayList* sound_pulse_audio_manager_get_relevant_card_port_profiles (SoundPulseAudioManager* self,
                                                                         pa_card_port_info* port);
static void sound_pulse_audio_manager_cleanup_devices (SoundPulseAudioManager* self,
                                                GeeHashMap* devices,
                                                pa_card_info* card,
                                                pa_card_port_info** relevant_ports,
                                                gint relevant_ports_length1);
static pa_card_profile_info2** _vala_array_dup1 (pa_card_profile_info2** self,
                                          gssize length);
static gint __lambda47_ (SoundPulseAudioManager* self,
                  pa_card_profile_info2* a,
                  pa_card_profile_info2* b);
static gint ___lambda47__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void sound_pulse_audio_manager_ext_stream_restore_read_sink_callback (SoundPulseAudioManager* self,
                                                                      pa_context* c,
                                                                      pa_ext_stream_restore_info* info,
                                                                      gint eol);
static void _sound_pulse_audio_manager_ext_stream_restore_read_sink_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                              pa_ext_stream_restore_info* info,
                                                                                                              gint eol,
                                                                                                              gpointer self);
static void sound_pulse_audio_manager_ext_stream_restore_read_source_callback (SoundPulseAudioManager* self,
                                                                        pa_context* c,
                                                                        pa_ext_stream_restore_info* info,
                                                                        gint eol);
static void _sound_pulse_audio_manager_ext_stream_restore_read_source_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                                pa_ext_stream_restore_info* info,
                                                                                                                gint eol,
                                                                                                                gpointer self);
static void __lambda46_ (SoundPulseAudioManager* self,
                  pa_context* c,
                  gint success);
static void ___lambda46__pa_context_success_cb_t (pa_context* c,
                                           gint success,
                                           gpointer self);
static GObject * sound_pulse_audio_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void sound_pulse_audio_manager_finalize (GObject * obj);
static GType sound_pulse_audio_manager_get_type_once (void);
static void _vala_sound_pulse_audio_manager_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_sound_pulse_audio_manager_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_pulse_audio_manager_get_instance_private (SoundPulseAudioManager* self)
{
	return G_STRUCT_MEMBER_P (self, SoundPulseAudioManager_private_offset);
}

SoundPulseAudioManager*
sound_pulse_audio_manager_get_default (void)
{
	SoundPulseAudioManager* _tmp0_;
	SoundPulseAudioManager* _tmp2_;
	SoundPulseAudioManager* result;
	_tmp0_ = sound_pulse_audio_manager_pam;
	if (_tmp0_ == NULL) {
		SoundPulseAudioManager* _tmp1_;
		_tmp1_ = sound_pulse_audio_manager_new ();
		_g_object_unref0 (sound_pulse_audio_manager_pam);
		sound_pulse_audio_manager_pam = _tmp1_;
	}
	_tmp2_ = sound_pulse_audio_manager_pam;
	result = _tmp2_;
	return result;
}

static SoundPulseAudioManager*
sound_pulse_audio_manager_construct (GType object_type)
{
	SoundPulseAudioManager * self = NULL;
	self = (SoundPulseAudioManager*) g_object_new (object_type, NULL);
	return self;
}

static SoundPulseAudioManager*
sound_pulse_audio_manager_new (void)
{
	return sound_pulse_audio_manager_construct (SOUND_TYPE_PULSE_AUDIO_MANAGER);
}

void
sound_pulse_audio_manager_start (SoundPulseAudioManager* self)
{
	g_return_if_fail (self != NULL);
	sound_pulse_audio_manager_reconnect_to_pulse (self, NULL, NULL);
}

static void
sound_pulse_audio_manager_set_default_device_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetDefaultDeviceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sound_pulse_audio_manager_set_default_device (SoundPulseAudioManager* self,
                                              SoundDevice* device,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetDefaultDeviceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_default_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	sound_pulse_audio_manager_set_default_device_co (_data_);
}

void
sound_pulse_audio_manager_set_default_device_finish (SoundPulseAudioManager* self,
                                                     GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static const char*
_pulse_audio_direction_to_string (pa_direction_t value)
{
	switch (value) {
		case PA_DIRECTION_OUTPUT:
		return "PA_DIRECTION_OUTPUT";
		case PA_DIRECTION_INPUT:
		return "PA_DIRECTION_INPUT";
	}
	return NULL;
}

static void
sound_pulse_audio_manager_set_default_device_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultDeviceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sound_pulse_audio_manager_set_default_device_co (_data_);
}

static gboolean
sound_pulse_audio_manager_set_default_device_co (SoundPulseAudioManagerSetDefaultDeviceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("PulseAudioManager.vala:75: \n");
	_data_->_tmp0_ = sound_device_get_id (_data_->device);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("PulseAudioManager.vala:76: set_default_device: %s", _data_->_tmp1_);
	_data_->_tmp2_ = sound_device_get_direction (_data_->device);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _pulse_audio_direction_to_string (_data_->_tmp3_);
	g_debug ("PulseAudioManager.vala:77: \t%s", _data_->_tmp4_);
	_data_->_tmp5_ = _data_->self->priv->_default_input;
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
	_data_->other_device = _data_->_tmp6_;
	_data_->_tmp7_ = g_strdup ("card-sink-name");
	_data_->card_name = _data_->_tmp7_;
	_data_->_tmp8_ = sound_device_get_direction (_data_->device);
	_data_->_tmp9_ = _data_->_tmp8_;
	if (_data_->_tmp9_ == PA_DIRECTION_OUTPUT) {
		_data_->_tmp10_ = _data_->self->priv->_default_output;
		_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
		_g_object_unref0 (_data_->other_device);
		_data_->other_device = _data_->_tmp11_;
		_data_->_tmp12_ = g_strdup ("card-source-name");
		_g_free0 (_data_->card_name);
		_data_->card_name = _data_->_tmp12_;
	}
	_data_->_tmp13_ = _data_->other_device;
	_data_->_tmp14_ = sound_device_get_matching_profile (_data_->device, _data_->_tmp13_);
	_data_->profile_name = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->profile_name;
	if (_data_->_tmp15_ == NULL) {
		_data_->_tmp16_ = sound_device_get_profiles (_data_->device);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp17_, 0);
		_g_free0 (_data_->profile_name);
		_data_->profile_name = (gchar*) _data_->_tmp18_;
	}
	_data_->_tmp19_ = _data_->profile_name;
	_data_->_tmp20_ = sound_device_get_card_active_profile_name (_data_->device);
	_data_->_tmp21_ = _data_->_tmp20_;
	if (g_strcmp0 (_data_->_tmp19_, _data_->_tmp21_) != 0) {
		_data_->_tmp22_ = sound_device_get_card_active_profile_name (_data_->device);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = _data_->profile_name;
		g_debug ("PulseAudioManager.vala:97: set card profile: %s > %s", _data_->_tmp23_, _data_->_tmp24_);
		_data_->_tmp25_ = sound_device_get_card_index (_data_->device);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->profile_name;
		_data_->_state_ = 1;
		sound_pulse_audio_manager_set_card_profile_by_index (_data_->self, _data_->_tmp26_, _data_->_tmp27_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_1:
		sound_pulse_audio_manager_set_card_profile_by_index_finish (_data_->self, _data_->_res_);
		g_debug ("PulseAudioManager.vala:101: wait for card sink / source");
		_data_->_tmp28_ = _data_->card_name;
		_data_->_state_ = 2;
		sound_pulse_audio_manager_wait_for_update (_data_->self, _data_->device, _data_->_tmp28_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_2:
		sound_pulse_audio_manager_wait_for_update_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp30_ = sound_device_get_direction (_data_->device);
	_data_->_tmp31_ = _data_->_tmp30_;
	if (_data_->_tmp31_ == PA_DIRECTION_OUTPUT) {
		_data_->_tmp32_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = sound_device_get_card_sink_port_name (_data_->device);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp29_ = g_strcmp0 (_data_->_tmp33_, _data_->_tmp35_) != 0;
	} else {
		_data_->_tmp29_ = FALSE;
	}
	if (_data_->_tmp29_) {
		_data_->_tmp36_ = sound_device_get_card_sink_port_name (_data_->device);
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp38_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp39_ = _data_->_tmp38_;
		g_debug ("PulseAudioManager.vala:108: set sink port: %s > %s", _data_->_tmp37_, _data_->_tmp39_);
		_data_->_tmp40_ = sound_device_get_card_sink_name (_data_->device);
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp43_ = _data_->_tmp42_;
		_data_->_state_ = 3;
		sound_pulse_audio_manager_set_sink_port_by_name (_data_->self, _data_->_tmp41_, _data_->_tmp43_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_3:
		sound_pulse_audio_manager_set_sink_port_by_name_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp45_ = sound_device_get_direction (_data_->device);
	_data_->_tmp46_ = _data_->_tmp45_;
	if (_data_->_tmp46_ == PA_DIRECTION_INPUT) {
		_data_->_tmp47_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = sound_device_get_card_source_port_name (_data_->device);
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_tmp44_ = g_strcmp0 (_data_->_tmp48_, _data_->_tmp50_) != 0;
	} else {
		_data_->_tmp44_ = FALSE;
	}
	if (_data_->_tmp44_) {
		_data_->_tmp51_ = sound_device_get_card_source_port_name (_data_->device);
		_data_->_tmp52_ = _data_->_tmp51_;
		_data_->_tmp53_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp54_ = _data_->_tmp53_;
		g_debug ("PulseAudioManager.vala:114: set source port: %s > %s", _data_->_tmp52_, _data_->_tmp54_);
		_data_->_tmp55_ = sound_device_get_card_source_name (_data_->device);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = sound_device_get_port_name (_data_->device);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_state_ = 4;
		sound_pulse_audio_manager_set_source_port_by_name (_data_->self, _data_->_tmp56_, _data_->_tmp58_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_4:
		sound_pulse_audio_manager_set_source_port_by_name_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp61_ = sound_device_get_direction (_data_->device);
	_data_->_tmp62_ = _data_->_tmp61_;
	if (_data_->_tmp62_ == PA_DIRECTION_OUTPUT) {
		_data_->_tmp63_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp64_ = _data_->_tmp63_;
		_data_->_tmp60_ = _data_->_tmp64_ == NULL;
	} else {
		_data_->_tmp60_ = FALSE;
	}
	if (_data_->_tmp60_) {
		_data_->_tmp59_ = TRUE;
	} else {
		_data_->_tmp66_ = sound_device_get_direction (_data_->device);
		_data_->_tmp67_ = _data_->_tmp66_;
		if (_data_->_tmp67_ == PA_DIRECTION_INPUT) {
			_data_->_tmp68_ = sound_device_get_source_name (_data_->device);
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->_tmp65_ = _data_->_tmp69_ == NULL;
		} else {
			_data_->_tmp65_ = FALSE;
		}
		_data_->_tmp59_ = _data_->_tmp65_;
	}
	if (_data_->_tmp59_) {
		g_debug ("PulseAudioManager.vala:121: wait for sink / source");
		_data_->_tmp70_ = _data_->card_name;
		_data_->_state_ = 5;
		sound_pulse_audio_manager_wait_for_update (_data_->self, _data_->device, _data_->_tmp70_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_5:
		sound_pulse_audio_manager_wait_for_update_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp72_ = sound_device_get_direction (_data_->device);
	_data_->_tmp73_ = _data_->_tmp72_;
	if (_data_->_tmp73_ == PA_DIRECTION_OUTPUT) {
		_data_->_tmp74_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp75_ = _data_->_tmp74_;
		_data_->_tmp76_ = _data_->self->priv->default_sink_name;
		_data_->_tmp71_ = g_strcmp0 (_data_->_tmp75_, _data_->_tmp76_) != 0;
	} else {
		_data_->_tmp71_ = FALSE;
	}
	if (_data_->_tmp71_) {
		_data_->_tmp77_ = _data_->self->priv->default_sink_name;
		_data_->_tmp78_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp79_ = _data_->_tmp78_;
		g_debug ("PulseAudioManager.vala:128: set sink: %s > %s", _data_->_tmp77_, _data_->_tmp79_);
		_data_->_tmp80_ = sound_device_get_sink_name (_data_->device);
		_data_->_tmp81_ = _data_->_tmp80_;
		_data_->_state_ = 6;
		sound_pulse_audio_manager_set_default_sink (_data_->self, _data_->_tmp81_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_6:
		sound_pulse_audio_manager_set_default_sink_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp83_ = sound_device_get_direction (_data_->device);
	_data_->_tmp84_ = _data_->_tmp83_;
	if (_data_->_tmp84_ == PA_DIRECTION_INPUT) {
		_data_->_tmp85_ = sound_device_get_source_name (_data_->device);
		_data_->_tmp86_ = _data_->_tmp85_;
		_data_->_tmp87_ = _data_->self->priv->default_source_name;
		_data_->_tmp82_ = g_strcmp0 (_data_->_tmp86_, _data_->_tmp87_) != 0;
	} else {
		_data_->_tmp82_ = FALSE;
	}
	if (_data_->_tmp82_) {
		_data_->_tmp88_ = _data_->self->priv->default_source_name;
		_data_->_tmp89_ = sound_device_get_source_name (_data_->device);
		_data_->_tmp90_ = _data_->_tmp89_;
		g_debug ("PulseAudioManager.vala:133: set source: %s > %s", _data_->_tmp88_, _data_->_tmp90_);
		_data_->_tmp91_ = sound_device_get_source_name (_data_->device);
		_data_->_tmp92_ = _data_->_tmp91_;
		_data_->_state_ = 7;
		sound_pulse_audio_manager_set_default_source (_data_->self, _data_->_tmp92_, sound_pulse_audio_manager_set_default_device_ready, _data_);
		return FALSE;
		_state_7:
		sound_pulse_audio_manager_set_default_source_finish (_data_->self, _data_->_res_);
	}
	_g_free0 (_data_->profile_name);
	_g_free0 (_data_->card_name);
	_g_object_unref0 (_data_->other_device);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_card_profile_by_index_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetCardProfileByIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetCardProfileByIndexData, _data_);
}

static void
sound_pulse_audio_manager_set_card_profile_by_index (SoundPulseAudioManager* self,
                                                     guint32 card_index,
                                                     const gchar* profile_name,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SoundPulseAudioManagerSetCardProfileByIndexData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetCardProfileByIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_card_profile_by_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->card_index = card_index;
	_tmp1_ = g_strdup (profile_name);
	_g_free0 (_data_->profile_name);
	_data_->profile_name = _tmp1_;
	sound_pulse_audio_manager_set_card_profile_by_index_co (_data_);
}

static void
sound_pulse_audio_manager_set_card_profile_by_index_finish (SoundPulseAudioManager* self,
                                                            GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetCardProfileByIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data5_->self;
		_g_free0 (_data5_->profile_name);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda48_ (Block5Data* _data5_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data5_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_card_profile_by_index_co (_data5_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:143: setting card %u profile to %s failed", (guint) _data5_->card_index, _data5_->profile_name);
	}
}

static void
___lambda48__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda48_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_card_profile_by_index_co (SoundPulseAudioManagerSetCardProfileByIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->card_index = _data_->card_index;
	_g_free0 (_data_->_data5_->profile_name);
	_data_->_data5_->profile_name = _data_->profile_name;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->context;
	_data_->_tmp1_ = pa_context_set_card_profile_by_index (_data_->_tmp0_, _data_->_data5_->card_index, _data_->_data5_->profile_name, ___lambda48__pa_context_success_cb_t, _data_->_data5_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_wait_for_update_data_free (gpointer _data)
{
	SoundPulseAudioManagerWaitForUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerWaitForUpdateData, _data_);
}

static void
sound_pulse_audio_manager_wait_for_update (SoundPulseAudioManager* self,
                                           SoundDevice* device,
                                           const gchar* prop_name,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	SoundPulseAudioManagerWaitForUpdateData* _data_;
	SoundPulseAudioManager* _tmp0_;
	SoundDevice* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (prop_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerWaitForUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_wait_for_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = g_strdup (prop_name);
	_g_free0 (_data_->prop_name);
	_data_->prop_name = _tmp2_;
	sound_pulse_audio_manager_wait_for_update_co (_data_);
}

static void
sound_pulse_audio_manager_wait_for_update_finish (SoundPulseAudioManager* self,
                                                  GAsyncResult* _res_)
{
	SoundPulseAudioManagerWaitForUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->device);
		_g_free0 (_data6_->prop_name);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda49_ (Block6Data* _data6_,
             GObject* s,
             GParamSpec* p)
{
	SoundPulseAudioManager* self;
	gchar* prop_value = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	self = _data6_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	g_object_get ((GObject*) _data6_->device, _data6_->prop_name, &_tmp0_, NULL);
	_g_free0 (prop_value);
	prop_value = _tmp0_;
	_tmp1_ = prop_value;
	if (_tmp1_ != NULL) {
		g_signal_handler_disconnect ((GObject*) _data6_->device, _data6_->handler_id);
		sound_pulse_audio_manager_wait_for_update_co (_data6_->_async_data_);
	}
	_g_free0 (prop_value);
}

static void
___lambda49__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda49_ (self, _sender, pspec);
}

static gboolean
sound_pulse_audio_manager_wait_for_update_co (SoundPulseAudioManagerWaitForUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data6_->device);
	_data_->_data6_->device = _data_->device;
	_g_free0 (_data_->_data6_->prop_name);
	_data_->_data6_->prop_name = _data_->prop_name;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = sound_device_get_id (_data_->_data6_->device);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("PulseAudioManager.vala:152: wait_for_update: %s:%s", _data_->_tmp1_, _data_->_data6_->prop_name);
	_data_->_data6_->handler_id = (gulong) 0;
	_data_->_tmp2_ = g_strconcat ("notify::", _data_->_data6_->prop_name, NULL);
	_data_->_tmp3_ = g_signal_connect_data ((GObject*) _data_->_data6_->device, _data_->_tmp2_, (GCallback) ___lambda49__g_object_notify, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
	_data_->_data6_->handler_id = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_sink_port_by_name_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetSinkPortByNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetSinkPortByNameData, _data_);
}

static void
sound_pulse_audio_manager_set_sink_port_by_name (SoundPulseAudioManager* self,
                                                 const gchar* sink_name,
                                                 const gchar* port_name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SoundPulseAudioManagerSetSinkPortByNameData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink_name != NULL);
	g_return_if_fail (port_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetSinkPortByNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_sink_port_by_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sink_name);
	_g_free0 (_data_->sink_name);
	_data_->sink_name = _tmp1_;
	_tmp2_ = g_strdup (port_name);
	_g_free0 (_data_->port_name);
	_data_->port_name = _tmp2_;
	sound_pulse_audio_manager_set_sink_port_by_name_co (_data_);
}

static void
sound_pulse_audio_manager_set_sink_port_by_name_finish (SoundPulseAudioManager* self,
                                                        GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetSinkPortByNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data7_->self;
		_g_free0 (_data7_->sink_name);
		_g_free0 (_data7_->port_name);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda50_ (Block7Data* _data7_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data7_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_sink_port_by_name_co (_data7_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:171: setting sink %s port to %s failed", _data7_->sink_name, _data7_->port_name);
	}
}

static void
___lambda50__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda50_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_sink_port_by_name_co (SoundPulseAudioManagerSetSinkPortByNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data7_ = g_slice_new0 (Block7Data);
	_data_->_data7_->_ref_count_ = 1;
	_data_->_data7_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data7_->sink_name);
	_data_->_data7_->sink_name = _data_->sink_name;
	_g_free0 (_data_->_data7_->port_name);
	_data_->_data7_->port_name = _data_->port_name;
	_data_->_data7_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->context;
	_data_->_tmp1_ = pa_context_set_sink_port_by_name (_data_->_tmp0_, _data_->_data7_->sink_name, _data_->_data7_->port_name, ___lambda50__pa_context_success_cb_t, _data_->_data7_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block7_data_unref (_data_->_data7_);
	_data_->_data7_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_source_port_by_name_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetSourcePortByNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetSourcePortByNameData, _data_);
}

static void
sound_pulse_audio_manager_set_source_port_by_name (SoundPulseAudioManager* self,
                                                   const gchar* source_name,
                                                   const gchar* port_name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SoundPulseAudioManagerSetSourcePortByNameData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_name != NULL);
	g_return_if_fail (port_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetSourcePortByNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_source_port_by_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (source_name);
	_g_free0 (_data_->source_name);
	_data_->source_name = _tmp1_;
	_tmp2_ = g_strdup (port_name);
	_g_free0 (_data_->port_name);
	_data_->port_name = _tmp2_;
	sound_pulse_audio_manager_set_source_port_by_name_co (_data_);
}

static void
sound_pulse_audio_manager_set_source_port_by_name_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetSourcePortByNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data8_->self;
		_g_free0 (_data8_->source_name);
		_g_free0 (_data8_->port_name);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda51_ (Block8Data* _data8_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data8_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_source_port_by_name_co (_data8_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:183: setting source %s port to %s failed", _data8_->source_name, _data8_->port_name);
	}
}

static void
___lambda51__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda51_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_source_port_by_name_co (SoundPulseAudioManagerSetSourcePortByNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data8_->source_name);
	_data_->_data8_->source_name = _data_->source_name;
	_g_free0 (_data_->_data8_->port_name);
	_data_->_data8_->port_name = _data_->port_name;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->context;
	_data_->_tmp1_ = pa_context_set_source_port_by_name (_data_->_tmp0_, _data_->_data8_->source_name, _data_->_data8_->port_name, ___lambda51__pa_context_success_cb_t, _data_->_data8_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_default_sink_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetDefaultSinkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetDefaultSinkData, _data_);
}

static void
sound_pulse_audio_manager_set_default_sink (SoundPulseAudioManager* self,
                                            const gchar* sink_name,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultSinkData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetDefaultSinkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_default_sink_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sink_name);
	_g_free0 (_data_->sink_name);
	_data_->sink_name = _tmp1_;
	sound_pulse_audio_manager_set_default_sink_co (_data_);
}

static void
sound_pulse_audio_manager_set_default_sink_finish (SoundPulseAudioManager* self,
                                                   GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetDefaultSinkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data9_->self;
		_g_free0 (_data9_->sink_name);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda52_ (Block9Data* _data9_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data9_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_default_sink_co (_data9_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:195: setting default sink to %s failed", _data9_->sink_name);
	}
}

static void
___lambda52__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda52_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_default_sink_co (SoundPulseAudioManagerSetDefaultSinkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data9_->sink_name);
	_data_->_data9_->sink_name = _data_->sink_name;
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->context;
	_data_->_tmp1_ = pa_context_set_default_sink (_data_->_tmp0_, _data_->_data9_->sink_name, ___lambda52__pa_context_success_cb_t, _data_->_data9_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_pulse_audio_manager_set_default_source_data_free (gpointer _data)
{
	SoundPulseAudioManagerSetDefaultSourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerSetDefaultSourceData, _data_);
}

static void
sound_pulse_audio_manager_set_default_source (SoundPulseAudioManager* self,
                                              const gchar* source_name,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SoundPulseAudioManagerSetDefaultSourceData* _data_;
	SoundPulseAudioManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_name != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerSetDefaultSourceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_set_default_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (source_name);
	_g_free0 (_data_->source_name);
	_data_->source_name = _tmp1_;
	sound_pulse_audio_manager_set_default_source_co (_data_);
}

static void
sound_pulse_audio_manager_set_default_source_finish (SoundPulseAudioManager* self,
                                                     GAsyncResult* _res_)
{
	SoundPulseAudioManagerSetDefaultSourceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SoundPulseAudioManager* self;
		self = _data10_->self;
		_g_free0 (_data10_->source_name);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda53_ (Block10Data* _data10_,
             pa_context* c,
             gint success)
{
	SoundPulseAudioManager* self;
	self = _data10_->self;
	g_return_if_fail (c != NULL);
	if (success == 1) {
		sound_pulse_audio_manager_set_default_source_co (_data10_->_async_data_);
	} else {
		g_warning ("PulseAudioManager.vala:207: setting default source to %s failed", _data10_->source_name);
	}
}

static void
___lambda53__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda53_ (self, c, success);
}

static gboolean
sound_pulse_audio_manager_set_default_source_co (SoundPulseAudioManagerSetDefaultSourceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data10_ = g_slice_new0 (Block10Data);
	_data_->_data10_->_ref_count_ = 1;
	_data_->_data10_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data10_->source_name);
	_data_->_data10_->source_name = _data_->source_name;
	_data_->_data10_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->context;
	_data_->_tmp1_ = pa_context_set_default_source (_data_->_tmp0_, _data_->_data10_->source_name, ___lambda53__pa_context_success_cb_t, _data_->_data10_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_pa_operation_unref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block10_data_unref (_data_->_data10_);
	_data_->_data10_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
sound_pulse_audio_manager_reconnect_timeout (SoundPulseAudioManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->reconnect_timer_id = 0U;
	sound_pulse_audio_manager_reconnect_to_pulse (self, NULL, NULL);
	result = FALSE;
	return result;
}

static void
sound_pulse_audio_manager_reconnect_to_pulse_data_free (gpointer _data)
{
	SoundPulseAudioManagerReconnectToPulseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPulseAudioManagerReconnectToPulseData, _data_);
}

static void
sound_pulse_audio_manager_reconnect_to_pulse (SoundPulseAudioManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SoundPulseAudioManagerReconnectToPulseData* _data_;
	SoundPulseAudioManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SoundPulseAudioManagerReconnectToPulseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_pulse_audio_manager_reconnect_to_pulse_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sound_pulse_audio_manager_reconnect_to_pulse_co (_data_);
}

static void
sound_pulse_audio_manager_reconnect_to_pulse_finish (SoundPulseAudioManager* self,
                                                     GAsyncResult* _res_)
{
	SoundPulseAudioManagerReconnectToPulseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_sound_pulse_audio_manager_context_state_callback_pa_context_notify_cb_t (pa_context* c,
                                                                          gpointer self)
{
	sound_pulse_audio_manager_context_state_callback ((SoundPulseAudioManager*) self, c);
}

static gboolean
sound_pulse_audio_manager_reconnect_to_pulse_co (SoundPulseAudioManagerReconnectToPulseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->is_ready) {
		_data_->_tmp0_ = _data_->self->priv->context;
		pa_context_disconnect (_data_->_tmp0_);
		_pa_context_unref0 (_data_->self->priv->context);
		_data_->self->priv->context = NULL;
		_data_->self->priv->is_ready = FALSE;
	}
	_data_->_tmp1_ = pa_proplist_new ();
	_data_->props = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->props;
	pa_proplist_sets (_data_->_tmp2_, PA_PROP_APPLICATION_ID, "org.wingpanel.indicator.sound");
	_data_->_tmp3_ = _data_->self->priv->loop;
	_data_->_tmp4_ = pa_glib_mainloop_get_api (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->props;
	_data_->_tmp6_ = pa_context_new_with_proplist (_data_->_tmp4_, NULL, _data_->_tmp5_);
	_pa_context_unref0 (_data_->self->priv->context);
	_data_->self->priv->context = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->self->priv->context;
	pa_context_set_state_callback (_data_->_tmp7_, _sound_pulse_audio_manager_context_state_callback_pa_context_notify_cb_t, _data_->self);
	_data_->_tmp8_ = _data_->self->priv->context;
	if (pa_context_connect (_data_->_tmp8_, NULL, PA_CONTEXT_NOFAIL, NULL) < 0) {
		_data_->_tmp9_ = _data_->self->priv->context;
		_data_->_tmp10_ = pa_strerror (pa_context_errno (_data_->_tmp9_));
		g_warning ("PulseAudioManager.vala:237: pa_context_connect () failed: %s\n", _data_->_tmp10_);
	}
	_pa_proplist_free0 (_data_->props);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_sound_pulse_audio_manager_subscribe_callback_pa_context_subscribe_cb_t (pa_context* c,
                                                                         pa_subscription_event_type_t t,
                                                                         guint32 idx,
                                                                         gpointer self)
{
	sound_pulse_audio_manager_subscribe_callback ((SoundPulseAudioManager*) self, c, t, idx);
}

static void
_sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t (pa_context* c,
                                                                     pa_server_info* i,
                                                                     gpointer self)
{
	sound_pulse_audio_manager_server_info_callback ((SoundPulseAudioManager*) self, c, i);
}

static gboolean
_sound_pulse_audio_manager_reconnect_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = sound_pulse_audio_manager_reconnect_timeout ((SoundPulseAudioManager*) self);
	return result;
}

static void
sound_pulse_audio_manager_context_state_callback (SoundPulseAudioManager* self,
                                                  pa_context* c)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	switch (pa_context_get_state (c)) {
		case PA_CONTEXT_READY:
		{
			pa_operation* _tmp0_;
			pa_operation* _tmp1_;
			pa_context* _tmp2_;
			pa_operation* _tmp3_;
			pa_operation* _tmp4_;
			pa_context_set_subscribe_callback (c, _sound_pulse_audio_manager_subscribe_callback_pa_context_subscribe_cb_t, self);
			_tmp0_ = pa_context_subscribe (c, ((((PA_SUBSCRIPTION_MASK_SERVER | PA_SUBSCRIPTION_MASK_SINK) | PA_SUBSCRIPTION_MASK_SOURCE) | PA_SUBSCRIPTION_MASK_SINK_INPUT) | PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT) | PA_SUBSCRIPTION_MASK_CARD, NULL, NULL);
			_tmp1_ = _tmp0_;
			_pa_operation_unref0 (_tmp1_);
			_tmp2_ = self->priv->context;
			_tmp3_ = pa_context_get_server_info (_tmp2_, _sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t, self);
			_tmp4_ = _tmp3_;
			_pa_operation_unref0 (_tmp4_);
			self->priv->is_ready = TRUE;
			break;
		}
		case PA_CONTEXT_FAILED:
		case PA_CONTEXT_TERMINATED:
		{
			if (self->priv->reconnect_timer_id == 0U) {
				self->priv->reconnect_timer_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _sound_pulse_audio_manager_reconnect_timeout_gsource_func, g_object_ref (self), g_object_unref);
			}
			break;
		}
		default:
		{
			self->priv->is_ready = FALSE;
			break;
		}
	}
}

static void
_sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t (pa_context* c,
                                                                 pa_sink_info* i,
                                                                 gint eol,
                                                                 gpointer self)
{
	sound_pulse_audio_manager_sink_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static void
_sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t (pa_context* c,
                                                                 pa_card_info* i,
                                                                 gint eol,
                                                                 gpointer self)
{
	sound_pulse_audio_manager_card_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static void
_sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t (pa_context* c,
                                                                     pa_source_info* i,
                                                                     gint eol,
                                                                     gpointer self)
{
	sound_pulse_audio_manager_source_info_callback ((SoundPulseAudioManager*) self, c, i, eol);
}

static void
sound_pulse_audio_manager_subscribe_callback (SoundPulseAudioManager* self,
                                              pa_context* c,
                                              pa_subscription_event_type_t t,
                                              guint32 index)
{
	pa_subscription_event_type_t source_type = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	source_type = t & PA_SUBSCRIPTION_EVENT_FACILITY_MASK;
	switch (source_type) {
		case PA_SUBSCRIPTION_EVENT_SINK:
		case PA_SUBSCRIPTION_EVENT_SINK_INPUT:
		{
			pa_subscription_event_type_t event_type = 0;
			event_type = t & PA_SUBSCRIPTION_EVENT_TYPE_MASK;
			switch (event_type) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				{
					pa_operation* _tmp0_;
					pa_operation* _tmp1_;
					_tmp0_ = pa_context_get_sink_info_by_index (c, index, _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t, self);
					_tmp1_ = _tmp0_;
					_pa_operation_unref0 (_tmp1_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp2_;
					pa_operation* _tmp3_;
					_tmp2_ = pa_context_get_sink_info_by_index (c, index, _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t, self);
					_tmp3_ = _tmp2_;
					_pa_operation_unref0 (_tmp3_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					g_debug ("PulseAudioManager.vala:289: subscribe_callback:SINK:REMOVE");
					{
						GeeIterator* _device_it = NULL;
						GeeHashMap* _tmp4_;
						GeeCollection* _tmp5_;
						GeeCollection* _tmp6_;
						GeeCollection* _tmp7_;
						GeeIterator* _tmp8_;
						GeeIterator* _tmp9_;
						_tmp4_ = self->priv->output_devices;
						_tmp5_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp4_);
						_tmp6_ = _tmp5_;
						_tmp7_ = _tmp6_;
						_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
						_tmp9_ = _tmp8_;
						_g_object_unref0 (_tmp7_);
						_device_it = _tmp9_;
						while (TRUE) {
							GeeIterator* _tmp10_;
							SoundDevice* device = NULL;
							GeeIterator* _tmp11_;
							gpointer _tmp12_;
							SoundDevice* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							SoundDevice* _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							_tmp10_ = _device_it;
							if (!gee_iterator_next (_tmp10_)) {
								break;
							}
							_tmp11_ = _device_it;
							_tmp12_ = gee_iterator_get (_tmp11_);
							device = (SoundDevice*) _tmp12_;
							_tmp13_ = device;
							_tmp14_ = sound_device_get_sink_index (_tmp13_);
							_tmp15_ = _tmp14_;
							if (((guint32) _tmp15_) == index) {
								SoundDevice* _tmp16_;
								const gchar* _tmp17_;
								const gchar* _tmp18_;
								SoundDevice* _tmp19_;
								SoundDevice* _tmp20_;
								SoundDevice* _tmp21_;
								SoundDevice* _tmp22_;
								const gchar* _tmp23_;
								const gchar* _tmp24_;
								_tmp16_ = device;
								_tmp17_ = sound_device_get_id (_tmp16_);
								_tmp18_ = _tmp17_;
								g_debug ("PulseAudioManager.vala:292: \tupdating device: %s", _tmp18_);
								_tmp19_ = device;
								sound_device_set_sink_name (_tmp19_, NULL);
								_tmp20_ = device;
								sound_device_set_sink_index (_tmp20_, -1);
								_tmp21_ = device;
								sound_device_set_is_default (_tmp21_, FALSE);
								_tmp22_ = device;
								_tmp23_ = sound_device_get_sink_name (_tmp22_);
								_tmp24_ = _tmp23_;
								g_debug ("PulseAudioManager.vala:296: \t\tdevice.sink_name: %s", _tmp24_);
							}
							_tmp25_ = device;
							_tmp26_ = sound_device_get_card_sink_index (_tmp25_);
							_tmp27_ = _tmp26_;
							if (((guint32) _tmp27_) == index) {
								SoundDevice* _tmp28_;
								const gchar* _tmp29_;
								const gchar* _tmp30_;
								SoundDevice* _tmp31_;
								SoundDevice* _tmp32_;
								SoundDevice* _tmp33_;
								SoundDevice* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								_tmp28_ = device;
								_tmp29_ = sound_device_get_id (_tmp28_);
								_tmp30_ = _tmp29_;
								g_debug ("PulseAudioManager.vala:300: \tupdating device: %s", _tmp30_);
								_tmp31_ = device;
								sound_device_set_card_sink_name (_tmp31_, NULL);
								_tmp32_ = device;
								sound_device_set_card_sink_index (_tmp32_, -1);
								_tmp33_ = device;
								sound_device_set_card_sink_port_name (_tmp33_, NULL);
								_tmp34_ = device;
								_tmp35_ = sound_device_get_card_sink_name (_tmp34_);
								_tmp36_ = _tmp35_;
								g_debug ("PulseAudioManager.vala:304: \t\tdevice.card_sink_name: %s", _tmp36_);
							}
							_g_object_unref0 (device);
						}
						_g_object_unref0 (_device_it);
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case PA_SUBSCRIPTION_EVENT_SERVER:
		{
			pa_context* _tmp37_;
			pa_operation* _tmp38_;
			pa_operation* _tmp39_;
			_tmp37_ = self->priv->context;
			_tmp38_ = pa_context_get_server_info (_tmp37_, _sound_pulse_audio_manager_server_info_callback_pa_server_info_cb_t, self);
			_tmp39_ = _tmp38_;
			_pa_operation_unref0 (_tmp39_);
			break;
		}
		case PA_SUBSCRIPTION_EVENT_CARD:
		{
			pa_subscription_event_type_t event_type = 0;
			event_type = t & PA_SUBSCRIPTION_EVENT_TYPE_MASK;
			switch (event_type) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				{
					pa_operation* _tmp40_;
					pa_operation* _tmp41_;
					_tmp40_ = pa_context_get_card_info_by_index (c, index, _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t, self);
					_tmp41_ = _tmp40_;
					_pa_operation_unref0 (_tmp41_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp42_;
					pa_operation* _tmp43_;
					_tmp42_ = pa_context_get_card_info_by_index (c, index, _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t, self);
					_tmp43_ = _tmp42_;
					_pa_operation_unref0 (_tmp43_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					GeeHashMap* _tmp44_;
					GeeHashMap* _tmp45_;
					_tmp44_ = self->priv->output_devices;
					sound_pulse_audio_manager_remove_devices_by_card (self, _tmp44_, index);
					_tmp45_ = self->priv->input_devices;
					sound_pulse_audio_manager_remove_devices_by_card (self, _tmp45_, index);
					break;
				}
				default:
				break;
			}
			break;
		}
		case PA_SUBSCRIPTION_EVENT_SOURCE:
		case PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT:
		{
			pa_subscription_event_type_t event_type = 0;
			event_type = t & PA_SUBSCRIPTION_EVENT_TYPE_MASK;
			switch (event_type) {
				case PA_SUBSCRIPTION_EVENT_NEW:
				{
					pa_operation* _tmp46_;
					pa_operation* _tmp47_;
					_tmp46_ = pa_context_get_source_info_by_index (c, index, _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t, self);
					_tmp47_ = _tmp46_;
					_pa_operation_unref0 (_tmp47_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_CHANGE:
				{
					pa_operation* _tmp48_;
					pa_operation* _tmp49_;
					_tmp48_ = pa_context_get_source_info_by_index (c, index, _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t, self);
					_tmp49_ = _tmp48_;
					_pa_operation_unref0 (_tmp49_);
					break;
				}
				case PA_SUBSCRIPTION_EVENT_REMOVE:
				{
					g_debug ("PulseAudioManager.vala:349: subscribe_callback:SOURCE:REMOVE");
					{
						GeeIterator* _device_it = NULL;
						GeeHashMap* _tmp50_;
						GeeCollection* _tmp51_;
						GeeCollection* _tmp52_;
						GeeCollection* _tmp53_;
						GeeIterator* _tmp54_;
						GeeIterator* _tmp55_;
						_tmp50_ = self->priv->input_devices;
						_tmp51_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _tmp52_;
						_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
						_tmp55_ = _tmp54_;
						_g_object_unref0 (_tmp53_);
						_device_it = _tmp55_;
						while (TRUE) {
							GeeIterator* _tmp56_;
							SoundDevice* device = NULL;
							GeeIterator* _tmp57_;
							gpointer _tmp58_;
							SoundDevice* _tmp59_;
							gint _tmp60_;
							gint _tmp61_;
							SoundDevice* _tmp71_;
							gint _tmp72_;
							gint _tmp73_;
							_tmp56_ = _device_it;
							if (!gee_iterator_next (_tmp56_)) {
								break;
							}
							_tmp57_ = _device_it;
							_tmp58_ = gee_iterator_get (_tmp57_);
							device = (SoundDevice*) _tmp58_;
							_tmp59_ = device;
							_tmp60_ = sound_device_get_source_index (_tmp59_);
							_tmp61_ = _tmp60_;
							if (((guint32) _tmp61_) == index) {
								SoundDevice* _tmp62_;
								const gchar* _tmp63_;
								const gchar* _tmp64_;
								SoundDevice* _tmp65_;
								SoundDevice* _tmp66_;
								SoundDevice* _tmp67_;
								SoundDevice* _tmp68_;
								const gchar* _tmp69_;
								const gchar* _tmp70_;
								_tmp62_ = device;
								_tmp63_ = sound_device_get_id (_tmp62_);
								_tmp64_ = _tmp63_;
								g_debug ("PulseAudioManager.vala:352: \tupdating device: %s", _tmp64_);
								_tmp65_ = device;
								sound_device_set_source_name (_tmp65_, NULL);
								_tmp66_ = device;
								sound_device_set_source_index (_tmp66_, -1);
								_tmp67_ = device;
								sound_device_set_is_default (_tmp67_, FALSE);
								_tmp68_ = device;
								_tmp69_ = sound_device_get_source_name (_tmp68_);
								_tmp70_ = _tmp69_;
								g_debug ("PulseAudioManager.vala:356: \t\tdevice.source_name: %s", _tmp70_);
							}
							_tmp71_ = device;
							_tmp72_ = sound_device_get_card_source_index (_tmp71_);
							_tmp73_ = _tmp72_;
							if (((guint32) _tmp73_) == index) {
								SoundDevice* _tmp74_;
								const gchar* _tmp75_;
								const gchar* _tmp76_;
								SoundDevice* _tmp77_;
								SoundDevice* _tmp78_;
								SoundDevice* _tmp79_;
								SoundDevice* _tmp80_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								_tmp74_ = device;
								_tmp75_ = sound_device_get_id (_tmp74_);
								_tmp76_ = _tmp75_;
								g_debug ("PulseAudioManager.vala:360: \tupdating device: %s", _tmp76_);
								_tmp77_ = device;
								sound_device_set_card_source_name (_tmp77_, NULL);
								_tmp78_ = device;
								sound_device_set_card_source_index (_tmp78_, -1);
								_tmp79_ = device;
								sound_device_set_card_source_port_name (_tmp79_, NULL);
								_tmp80_ = device;
								_tmp81_ = sound_device_get_card_source_name (_tmp80_);
								_tmp82_ = _tmp81_;
								g_debug ("PulseAudioManager.vala:364: \t\tdevice.card_source_name: %s", _tmp82_);
							}
							_g_object_unref0 (device);
						}
						_g_object_unref0 (_device_it);
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
}

static void
sound_pulse_audio_manager_source_info_callback (SoundPulseAudioManager* self,
                                                pa_context* c,
                                                pa_source_info* source,
                                                gint eol)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	pa_source_port_info* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (source == NULL) {
		return;
	}
	if ((*source).monitor_of_sink != PA_INVALID_INDEX) {
		return;
	}
	g_debug ("PulseAudioManager.vala:389: source info update");
	_tmp0_ = (*source).description;
	_tmp1_ = (*source).name;
	g_debug ("PulseAudioManager.vala:390: \tsource: %s (%s)", _tmp0_, _tmp1_);
	g_debug ("PulseAudioManager.vala:391: \t\tcard: %u", (guint) (*source).card);
	_tmp2_ = (*source).name;
	if (g_strcmp0 (_tmp2_, "auto_null") == 0) {
		return;
	}
	if (sound_pulse_audio_manager_debug_enabled) {
		pa_source_port_info** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = (*source).ports;
		_tmp3__length1 = (*source).n_ports;
		{
			pa_source_port_info** port_collection = NULL;
			gint port_collection_length1 = 0;
			gint _port_collection_size_ = 0;
			gint port_it = 0;
			port_collection = _tmp3_;
			port_collection_length1 = _tmp3__length1;
			for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
				pa_source_port_info* port = NULL;
				port = port_collection[port_it];
				{
					pa_source_port_info* _tmp4_;
					const gchar* _tmp5_;
					pa_source_port_info* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = port;
					_tmp5_ = (*_tmp4_).description;
					_tmp6_ = port;
					_tmp7_ = (*_tmp6_).name;
					g_debug ("PulseAudioManager.vala:399: \t\tport: %s (%s)", _tmp5_, _tmp7_);
				}
			}
		}
	}
	_tmp8_ = (*source).active_port;
	if (_tmp8_ != NULL) {
		pa_source_port_info* _tmp9_;
		const gchar* _tmp10_;
		pa_source_port_info* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = (*source).active_port;
		_tmp10_ = (*_tmp9_).description;
		_tmp11_ = (*source).active_port;
		_tmp12_ = (*_tmp11_).name;
		g_debug ("PulseAudioManager.vala:404: \t\tactive port: %s (%s)", _tmp10_, _tmp12_);
	}
	{
		GeeIterator* _device_it = NULL;
		GeeHashMap* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp13_ = self->priv->input_devices;
		_tmp14_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_device_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			SoundDevice* device = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			SoundDevice* _tmp22_;
			guint32 _tmp23_;
			guint32 _tmp24_;
			_tmp19_ = _device_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _device_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			device = (SoundDevice*) _tmp21_;
			_tmp22_ = device;
			_tmp23_ = sound_device_get_card_index (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == (*source).card) {
				SoundDevice* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				SoundDevice* _tmp28_;
				SoundDevice* _tmp29_;
				const gchar* _tmp30_;
				SoundDevice* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gboolean _tmp34_ = FALSE;
				pa_source_port_info* _tmp35_;
				_tmp25_ = device;
				_tmp26_ = sound_device_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				g_debug ("PulseAudioManager.vala:409: \t\tupdating device: %s", _tmp27_);
				_tmp28_ = device;
				sound_device_set_card_source_index (_tmp28_, (gint) (*source).index);
				_tmp29_ = device;
				_tmp30_ = (*source).name;
				sound_device_set_card_source_name (_tmp29_, _tmp30_);
				_tmp31_ = device;
				_tmp32_ = sound_device_get_card_source_name (_tmp31_);
				_tmp33_ = _tmp32_;
				g_debug ("PulseAudioManager.vala:412: \t\t\tdevice.card_source_name: %s", _tmp33_);
				_tmp35_ = (*source).active_port;
				if (_tmp35_ != NULL) {
					SoundDevice* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					pa_source_port_info* _tmp39_;
					const gchar* _tmp40_;
					_tmp36_ = device;
					_tmp37_ = sound_device_get_port_name (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = (*source).active_port;
					_tmp40_ = (*_tmp39_).name;
					_tmp34_ = g_strcmp0 (_tmp38_, _tmp40_) == 0;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					SoundDevice* _tmp41_;
					pa_source_port_info* _tmp42_;
					const gchar* _tmp43_;
					SoundDevice* _tmp44_;
					const gchar* _tmp45_;
					SoundDevice* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					SoundDevice* _tmp49_;
					SoundDevice* _tmp50_;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_ = NULL;
					SoundDevice* _tmp54_;
					gboolean _tmp55_;
					gboolean _tmp56_;
					SoundDevice* _tmp57_;
					gboolean _tmp58_;
					gboolean _tmp59_;
					_tmp41_ = device;
					_tmp42_ = (*source).active_port;
					_tmp43_ = (*_tmp42_).name;
					sound_device_set_card_source_port_name (_tmp41_, _tmp43_);
					_tmp44_ = device;
					_tmp45_ = (*source).name;
					sound_device_set_source_name (_tmp44_, _tmp45_);
					_tmp46_ = device;
					_tmp47_ = sound_device_get_card_source_name (_tmp46_);
					_tmp48_ = _tmp47_;
					g_debug ("PulseAudioManager.vala:416: \t\t\tdevice.source_name: %s", _tmp48_);
					_tmp49_ = device;
					sound_device_set_source_index (_tmp49_, (gint) (*source).index);
					_tmp50_ = device;
					_tmp51_ = (*source).name;
					_tmp52_ = self->priv->default_source_name;
					sound_device_set_is_default (_tmp50_, g_strcmp0 (_tmp51_, _tmp52_) == 0);
					_tmp54_ = device;
					_tmp55_ = sound_device_get_is_default (_tmp54_);
					_tmp56_ = _tmp55_;
					if (_tmp56_) {
						_tmp53_ = "true";
					} else {
						_tmp53_ = "false";
					}
					g_debug ("PulseAudioManager.vala:419: \t\t\tis_default: %s", _tmp53_);
					_tmp57_ = device;
					_tmp58_ = sound_device_get_is_default (_tmp57_);
					_tmp59_ = _tmp58_;
					if (_tmp59_) {
						SoundDevice* _tmp60_;
						_tmp60_ = device;
						sound_pulse_audio_manager_set_default_input (self, _tmp60_);
					}
				} else {
					SoundDevice* _tmp61_;
					SoundDevice* _tmp62_;
					SoundDevice* _tmp63_;
					_tmp61_ = device;
					sound_device_set_source_name (_tmp61_, NULL);
					_tmp62_ = device;
					sound_device_set_source_index (_tmp62_, -1);
					_tmp63_ = device;
					sound_device_set_is_default (_tmp63_, FALSE);
				}
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
}

static void
sound_pulse_audio_manager_sink_info_callback (SoundPulseAudioManager* self,
                                              pa_context* c,
                                              pa_sink_info* sink,
                                              gint eol)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	pa_sink_port_info* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (sink == NULL) {
		return;
	}
	g_debug ("PulseAudioManager.vala:439: sink info update");
	_tmp0_ = (*sink).description;
	_tmp1_ = (*sink).name;
	g_debug ("PulseAudioManager.vala:440: \tsink: %s (%s)", _tmp0_, _tmp1_);
	_tmp2_ = (*sink).name;
	if (g_strcmp0 (_tmp2_, "auto_null") == 0) {
		return;
	}
	g_debug ("PulseAudioManager.vala:446: \t\tcard: %u", (guint) (*sink).card);
	if (sound_pulse_audio_manager_debug_enabled) {
		pa_sink_port_info** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = (*sink).ports;
		_tmp3__length1 = (*sink).n_ports;
		{
			pa_sink_port_info** port_collection = NULL;
			gint port_collection_length1 = 0;
			gint _port_collection_size_ = 0;
			gint port_it = 0;
			port_collection = _tmp3_;
			port_collection_length1 = _tmp3__length1;
			for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
				pa_sink_port_info* port = NULL;
				port = port_collection[port_it];
				{
					pa_sink_port_info* _tmp4_;
					const gchar* _tmp5_;
					pa_sink_port_info* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = port;
					_tmp5_ = (*_tmp4_).description;
					_tmp6_ = port;
					_tmp7_ = (*_tmp6_).name;
					g_debug ("PulseAudioManager.vala:450: \t\tport: %s (%s)", _tmp5_, _tmp7_);
				}
			}
		}
	}
	_tmp8_ = (*sink).active_port;
	if (_tmp8_ != NULL) {
		pa_sink_port_info* _tmp9_;
		const gchar* _tmp10_;
		pa_sink_port_info* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = (*sink).active_port;
		_tmp10_ = (*_tmp9_).description;
		_tmp11_ = (*sink).active_port;
		_tmp12_ = (*_tmp11_).name;
		g_debug ("PulseAudioManager.vala:456: \t\tactive port: %s (%s)", _tmp10_, _tmp12_);
	}
	{
		GeeIterator* _device_it = NULL;
		GeeHashMap* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp13_ = self->priv->output_devices;
		_tmp14_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_device_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			SoundDevice* device = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			SoundDevice* _tmp22_;
			guint32 _tmp23_;
			guint32 _tmp24_;
			_tmp19_ = _device_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _device_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			device = (SoundDevice*) _tmp21_;
			_tmp22_ = device;
			_tmp23_ = sound_device_get_card_index (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == (*sink).card) {
				SoundDevice* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				SoundDevice* _tmp28_;
				SoundDevice* _tmp29_;
				const gchar* _tmp30_;
				SoundDevice* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gboolean _tmp34_ = FALSE;
				pa_sink_port_info* _tmp35_;
				_tmp25_ = device;
				_tmp26_ = sound_device_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				g_debug ("PulseAudioManager.vala:461: \t\tupdating device: %s", _tmp27_);
				_tmp28_ = device;
				sound_device_set_card_sink_index (_tmp28_, (gint) (*sink).index);
				_tmp29_ = device;
				_tmp30_ = (*sink).name;
				sound_device_set_card_sink_name (_tmp29_, _tmp30_);
				_tmp31_ = device;
				_tmp32_ = sound_device_get_card_sink_name (_tmp31_);
				_tmp33_ = _tmp32_;
				g_debug ("PulseAudioManager.vala:464: \t\t\tdevice.card_sink_name: %s", _tmp33_);
				_tmp35_ = (*sink).active_port;
				if (_tmp35_ != NULL) {
					SoundDevice* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					pa_sink_port_info* _tmp39_;
					const gchar* _tmp40_;
					_tmp36_ = device;
					_tmp37_ = sound_device_get_port_name (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = (*sink).active_port;
					_tmp40_ = (*_tmp39_).name;
					_tmp34_ = g_strcmp0 (_tmp38_, _tmp40_) == 0;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					SoundDevice* _tmp41_;
					pa_sink_port_info* _tmp42_;
					const gchar* _tmp43_;
					SoundDevice* _tmp44_;
					const gchar* _tmp45_;
					SoundDevice* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					SoundDevice* _tmp49_;
					SoundDevice* _tmp50_;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_ = NULL;
					SoundDevice* _tmp54_;
					gboolean _tmp55_;
					gboolean _tmp56_;
					SoundDevice* _tmp57_;
					gboolean _tmp58_;
					gboolean _tmp59_;
					_tmp41_ = device;
					_tmp42_ = (*sink).active_port;
					_tmp43_ = (*_tmp42_).name;
					sound_device_set_card_sink_port_name (_tmp41_, _tmp43_);
					_tmp44_ = device;
					_tmp45_ = (*sink).name;
					sound_device_set_sink_name (_tmp44_, _tmp45_);
					_tmp46_ = device;
					_tmp47_ = sound_device_get_card_sink_name (_tmp46_);
					_tmp48_ = _tmp47_;
					g_debug ("PulseAudioManager.vala:469: \t\t\tdevice.sink_name: %s", _tmp48_);
					_tmp49_ = device;
					sound_device_set_sink_index (_tmp49_, (gint) (*sink).index);
					_tmp50_ = device;
					_tmp51_ = (*sink).name;
					_tmp52_ = self->priv->default_sink_name;
					sound_device_set_is_default (_tmp50_, g_strcmp0 (_tmp51_, _tmp52_) == 0);
					_tmp54_ = device;
					_tmp55_ = sound_device_get_is_default (_tmp54_);
					_tmp56_ = _tmp55_;
					if (_tmp56_) {
						_tmp53_ = "true";
					} else {
						_tmp53_ = "false";
					}
					g_debug ("PulseAudioManager.vala:472: \t\t\tis_default: %s", _tmp53_);
					_tmp57_ = device;
					_tmp58_ = sound_device_get_is_default (_tmp57_);
					_tmp59_ = _tmp58_;
					if (_tmp59_) {
						SoundDevice* _tmp60_;
						_tmp60_ = device;
						sound_pulse_audio_manager_set_default_output (self, _tmp60_);
					}
				} else {
					SoundDevice* _tmp61_;
					SoundDevice* _tmp62_;
					SoundDevice* _tmp63_;
					_tmp61_ = device;
					sound_device_set_sink_name (_tmp61_, NULL);
					_tmp62_ = device;
					sound_device_set_sink_index (_tmp62_, -1);
					_tmp63_ = device;
					sound_device_set_is_default (_tmp63_, FALSE);
				}
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
}

static void
_vala_array_add4 (pa_card_port_info** * array,
                  gint* length,
                  gint* size,
                  pa_card_port_info* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (pa_card_port_info*, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
sound_pulse_audio_manager_card_info_callback (SoundPulseAudioManager* self,
                                              pa_context* c,
                                              pa_card_info* card,
                                              gint eol)
{
	pa_proplist* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	pa_card_profile_info2* _tmp3_;
	const gchar* _tmp4_;
	pa_proplist* _tmp5_;
	const gchar* _tmp6_;
	pa_proplist* _tmp7_;
	const gchar* _tmp8_;
	gchar* card_active_profile_name = NULL;
	pa_card_profile_info2* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	pa_card_port_info** relevant_ports = NULL;
	pa_card_port_info** _tmp12_;
	gint relevant_ports_length1;
	gint _relevant_ports_size_;
	guint32 highest_output_priority = 0U;
	guint32 highest_input_priority = 0U;
	pa_card_port_info** _tmp13_;
	gint _tmp13__length1;
	GVariant* preferred_devices = NULL;
	GSettings* _tmp23_;
	GVariant* _tmp24_;
	GeeHashMap* preferred_device_map = NULL;
	GeeHashMap* _tmp25_;
	gint32 preferred_expiry = 0;
	pa_card_port_info** _tmp43_;
	gint _tmp43__length1;
	GeeHashMap* _tmp172_;
	pa_card_port_info** _tmp173_;
	gint _tmp173__length1;
	pa_card_info _tmp174_;
	GeeHashMap* _tmp175_;
	pa_card_port_info** _tmp176_;
	gint _tmp176__length1;
	pa_card_info _tmp177_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (card == NULL) {
		return;
	}
	g_debug ("PulseAudioManager.vala:492: card info update");
	_tmp0_ = (*card).proplist;
	_tmp1_ = pa_proplist_gets (_tmp0_, PA_PROP_DEVICE_DESCRIPTION);
	_tmp2_ = (*card).name;
	g_debug ("PulseAudioManager.vala:493: \tcard: %u %s (%s)", (guint) (*card).index, _tmp1_, _tmp2_);
	_tmp3_ = (*card).active_profile2;
	_tmp4_ = (*_tmp3_).name;
	g_debug ("PulseAudioManager.vala:495: \t\tactive profile: %s", _tmp4_);
	_tmp5_ = (*card).proplist;
	_tmp6_ = pa_proplist_gets (_tmp5_, PA_PROP_DEVICE_FORM_FACTOR);
	g_debug ("PulseAudioManager.vala:497: \t\tcard form factor: %s", _tmp6_);
	_tmp7_ = (*card).proplist;
	_tmp8_ = pa_proplist_gets (_tmp7_, PA_PROP_MEDIA_ICON_NAME);
	g_debug ("PulseAudioManager.vala:498: \t\tcard icon name: %s", _tmp8_);
	_tmp9_ = (*card).active_profile2;
	_tmp10_ = (*_tmp9_).name;
	_tmp11_ = g_strdup (_tmp10_);
	card_active_profile_name = _tmp11_;
	_tmp12_ = g_new0 (pa_card_port_info*, 0);
	relevant_ports = _tmp12_;
	relevant_ports_length1 = 0;
	_relevant_ports_size_ = relevant_ports_length1;
	highest_output_priority = (guint32) 0;
	highest_input_priority = (guint32) 0;
	_tmp13_ = (*card).ports;
	_tmp13__length1 = (*card).n_ports;
	{
		pa_card_port_info** port_collection = NULL;
		gint port_collection_length1 = 0;
		gint _port_collection_size_ = 0;
		gint port_it = 0;
		port_collection = _tmp13_;
		port_collection_length1 = _tmp13__length1;
		for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
			pa_card_port_info* port = NULL;
			port = port_collection[port_it];
			{
				pa_card_port_info* _tmp14_;
				gboolean is_input = FALSE;
				pa_card_port_info* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp19_ = FALSE;
				pa_card_port_info* _tmp22_;
				_tmp14_ = port;
				if ((*_tmp14_).available == PA_PORT_AVAILABLE_NO) {
					continue;
				}
				_tmp15_ = port;
				is_input = ((*_tmp15_).direction & PA_DIRECTION_INPUT) == PA_DIRECTION_INPUT;
				if (is_input) {
					pa_card_port_info* _tmp17_;
					_tmp17_ = port;
					_tmp16_ = (*_tmp17_).priority > highest_input_priority;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					pa_card_port_info* _tmp18_;
					_tmp18_ = port;
					highest_input_priority = (*_tmp18_).priority;
				}
				if (!is_input) {
					pa_card_port_info* _tmp20_;
					_tmp20_ = port;
					_tmp19_ = (*_tmp20_).priority > highest_output_priority;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					pa_card_port_info* _tmp21_;
					_tmp21_ = port;
					highest_output_priority = (*_tmp21_).priority;
				}
				_tmp22_ = port;
				_vala_array_add4 (&relevant_ports, &relevant_ports_length1, &_relevant_ports_size_, _tmp22_);
			}
		}
	}
	_tmp23_ = sound_indicator_settings;
	_tmp24_ = g_settings_get_value (_tmp23_, "preferred-devices");
	preferred_devices = _tmp24_;
	_tmp25_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	preferred_device_map = _tmp25_;
	preferred_expiry = ((gint32) (g_get_real_time () / 1000000)) - (86400 * 7);
	{
		GVariantIter* _dev_it = NULL;
		GVariant* _tmp26_;
		GVariantIter* _tmp27_;
		GVariant* dev = NULL;
		_tmp26_ = preferred_devices;
		_tmp27_ = g_variant_iter_new (_tmp26_);
		_dev_it = _tmp27_;
		while (TRUE) {
			GVariantIter* _tmp28_;
			GVariant* _tmp29_;
			GVariant* _tmp30_;
			gchar* name = NULL;
			GVariant* _tmp31_;
			GVariant* _tmp32_;
			GVariant* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gint32 last_used = 0;
			GVariant* _tmp37_;
			GVariant* _tmp38_;
			GVariant* _tmp39_;
			gint32 _tmp40_;
			GeeHashMap* _tmp41_;
			const gchar* _tmp42_;
			_tmp28_ = _dev_it;
			_tmp29_ = g_variant_iter_next_value (_tmp28_);
			_g_variant_unref0 (dev);
			dev = _tmp29_;
			_tmp30_ = dev;
			if (!(_tmp30_ != NULL)) {
				break;
			}
			_tmp31_ = dev;
			_tmp32_ = g_variant_get_child_value (_tmp31_, (gsize) 0);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_variant_get_string (_tmp33_, NULL);
			_tmp35_ = g_strdup (_tmp34_);
			_tmp36_ = _tmp35_;
			_g_variant_unref0 (_tmp33_);
			name = _tmp36_;
			_tmp37_ = dev;
			_tmp38_ = g_variant_get_child_value (_tmp37_, (gsize) 1);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_variant_get_int32 (_tmp39_);
			_g_variant_unref0 (_tmp39_);
			last_used = _tmp40_;
			_tmp41_ = preferred_device_map;
			_tmp42_ = name;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, _tmp42_, (gpointer) ((gintptr) last_used));
			_g_free0 (name);
		}
		_g_variant_unref0 (dev);
		_g_variant_iter_free0 (_dev_it);
	}
	_tmp43_ = relevant_ports;
	_tmp43__length1 = relevant_ports_length1;
	{
		pa_card_port_info** port_collection = NULL;
		gint port_collection_length1 = 0;
		gint _port_collection_size_ = 0;
		gint port_it = 0;
		port_collection = _tmp43_;
		port_collection_length1 = _tmp43__length1;
		for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
			pa_card_port_info* port = NULL;
			port = port_collection[port_it];
			{
				gboolean is_input = FALSE;
				pa_card_port_info* _tmp44_;
				const gchar* _tmp45_ = NULL;
				pa_card_port_info* _tmp46_;
				const gchar* _tmp47_;
				pa_card_port_info* _tmp48_;
				const gchar* _tmp49_;
				GeeHashMap* _tmp50_ = NULL;
				GeeHashMap* devices = NULL;
				GeeHashMap* _tmp53_;
				SoundDevice* device = NULL;
				gchar* id = NULL;
				pa_card_port_info* _tmp54_;
				pa_card_info _tmp55_;
				gchar* _tmp56_;
				gboolean is_new = FALSE;
				GeeHashMap* _tmp57_;
				const gchar* _tmp58_;
				SoundDevice* _tmp68_;
				const gchar* _tmp69_;
				SoundDevice* _tmp70_;
				pa_card_port_info* _tmp71_;
				guint32 _tmp72_ = 0U;
				SoundDevice* _tmp73_;
				pa_card_port_info* _tmp74_;
				gboolean _tmp75_ = FALSE;
				GeeHashMap* _tmp76_;
				GeeSet* _tmp77_;
				GeeSet* _tmp78_;
				GeeSet* _tmp79_;
				const gchar* _tmp80_;
				gboolean _tmp81_;
				gchar* card_description = NULL;
				pa_proplist* _tmp86_;
				const gchar* _tmp87_;
				gchar* _tmp88_;
				SoundDevice* _tmp89_;
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				pa_card_port_info* _tmp92_;
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				SoundDevice* _tmp97_;
				pa_card_port_info* _tmp98_;
				pa_proplist* _tmp99_;
				const gchar* _tmp100_;
				SoundDevice* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				SoundDevice* _tmp107_;
				const gchar* _tmp108_;
				const gchar* _tmp109_;
				SoundDevice* _tmp110_;
				pa_card_port_info* _tmp111_;
				pa_proplist* _tmp112_;
				const gchar* _tmp113_;
				SoundDevice* _tmp114_;
				const gchar* _tmp115_;
				const gchar* _tmp116_;
				gboolean _tmp120_ = FALSE;
				SoundDevice* _tmp121_;
				const gchar* _tmp122_;
				const gchar* _tmp123_;
				SoundDevice* _tmp143_;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				gboolean _tmp148_ = FALSE;
				SoundDevice* _tmp153_;
				pa_card_port_info* _tmp154_;
				GeeArrayList* _tmp155_;
				GeeArrayList* _tmp156_;
				_tmp44_ = port;
				is_input = ((*_tmp44_).direction & PA_DIRECTION_INPUT) == PA_DIRECTION_INPUT;
				if (is_input) {
					_tmp45_ = "input";
				} else {
					_tmp45_ = "output";
				}
				_tmp46_ = port;
				_tmp47_ = (*_tmp46_).description;
				_tmp48_ = port;
				_tmp49_ = (*_tmp48_).name;
				g_debug ("PulseAudioManager.vala:533: \t\t%s port: %s (%s)", _tmp45_, _tmp47_, _tmp49_);
				if (is_input) {
					GeeHashMap* _tmp51_;
					_tmp51_ = self->priv->input_devices;
					_tmp50_ = _tmp51_;
				} else {
					GeeHashMap* _tmp52_;
					_tmp52_ = self->priv->output_devices;
					_tmp50_ = _tmp52_;
				}
				_tmp53_ = _g_object_ref0 (_tmp50_);
				devices = _tmp53_;
				device = NULL;
				_tmp54_ = port;
				_tmp55_ = *card;
				_tmp56_ = sound_pulse_audio_manager_get_device_id (&_tmp55_, _tmp54_);
				id = _tmp56_;
				_tmp57_ = devices;
				_tmp58_ = id;
				is_new = !gee_abstract_map_has_key ((GeeAbstractMap*) _tmp57_, _tmp58_);
				if (is_new) {
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					pa_card_port_info* _tmp61_;
					const gchar* _tmp62_;
					SoundDevice* _tmp63_;
					_tmp59_ = id;
					g_debug ("PulseAudioManager.vala:539: \t\t\tnew device: %s", _tmp59_);
					_tmp60_ = id;
					_tmp61_ = port;
					_tmp62_ = (*_tmp61_).name;
					_tmp63_ = sound_device_new (_tmp60_, (*card).index, _tmp62_);
					_g_object_unref0 (device);
					device = _tmp63_;
				} else {
					const gchar* _tmp64_;
					GeeHashMap* _tmp65_;
					const gchar* _tmp66_;
					gpointer _tmp67_;
					_tmp64_ = id;
					g_debug ("PulseAudioManager.vala:542: \t\t\tupdating device: %s", _tmp64_);
					_tmp65_ = devices;
					_tmp66_ = id;
					_tmp67_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp65_, _tmp66_);
					_g_object_unref0 (device);
					device = (SoundDevice*) _tmp67_;
				}
				_tmp68_ = device;
				_tmp69_ = card_active_profile_name;
				sound_device_set_card_active_profile_name (_tmp68_, _tmp69_);
				_tmp70_ = device;
				_tmp71_ = port;
				sound_device_set_direction (_tmp70_, (*_tmp71_).direction);
				if (is_input) {
					_tmp72_ = highest_input_priority;
				} else {
					_tmp72_ = highest_output_priority;
				}
				_tmp73_ = device;
				_tmp74_ = port;
				sound_device_set_is_priority (_tmp73_, (*_tmp74_).priority == _tmp72_);
				_tmp76_ = preferred_device_map;
				_tmp77_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = _tmp78_;
				_tmp80_ = id;
				_tmp81_ = gee_collection_contains ((GeeCollection*) _tmp79_, _tmp80_);
				_g_object_unref0 (_tmp79_);
				if (_tmp81_) {
					GeeHashMap* _tmp82_;
					const gchar* _tmp83_;
					gpointer _tmp84_;
					_tmp82_ = preferred_device_map;
					_tmp83_ = id;
					_tmp84_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp82_, _tmp83_);
					_tmp75_ = ((gint32) ((gintptr) _tmp84_)) > preferred_expiry;
				} else {
					_tmp75_ = FALSE;
				}
				if (_tmp75_) {
					SoundDevice* _tmp85_;
					_tmp85_ = device;
					sound_device_set_is_priority (_tmp85_, TRUE);
				}
				_tmp86_ = (*card).proplist;
				_tmp87_ = pa_proplist_gets (_tmp86_, PA_PROP_DEVICE_DESCRIPTION);
				_tmp88_ = g_strdup (_tmp87_);
				card_description = _tmp88_;
				_tmp89_ = device;
				_tmp90_ = card_description;
				_tmp91_ = string_to_string (_tmp90_);
				_tmp92_ = port;
				_tmp93_ = (*_tmp92_).description;
				_tmp94_ = string_to_string (_tmp93_);
				_tmp95_ = g_strconcat (_tmp91_, ": ", _tmp94_, NULL);
				_tmp96_ = _tmp95_;
				sound_device_set_display_name (_tmp89_, _tmp96_);
				_g_free0 (_tmp96_);
				_tmp97_ = device;
				_tmp98_ = port;
				_tmp99_ = (*_tmp98_).proplist;
				_tmp100_ = pa_proplist_gets (_tmp99_, PA_PROP_DEVICE_FORM_FACTOR);
				sound_device_set_form_factor (_tmp97_, _tmp100_);
				_tmp101_ = device;
				_tmp102_ = sound_device_get_form_factor (_tmp101_);
				_tmp103_ = _tmp102_;
				if (_tmp103_ == NULL) {
					SoundDevice* _tmp104_;
					pa_proplist* _tmp105_;
					const gchar* _tmp106_;
					_tmp104_ = device;
					_tmp105_ = (*card).proplist;
					_tmp106_ = pa_proplist_gets (_tmp105_, PA_PROP_DEVICE_FORM_FACTOR);
					sound_device_set_form_factor (_tmp104_, _tmp106_);
				}
				_tmp107_ = device;
				_tmp108_ = sound_device_get_form_factor (_tmp107_);
				_tmp109_ = _tmp108_;
				g_debug ("PulseAudioManager.vala:559: \t\t\tform factor: %s", _tmp109_);
				_tmp110_ = device;
				_tmp111_ = port;
				_tmp112_ = (*_tmp111_).proplist;
				_tmp113_ = pa_proplist_gets (_tmp112_, PA_PROP_DEVICE_ICON_NAME);
				sound_device_set_icon_name (_tmp110_, _tmp113_);
				_tmp114_ = device;
				_tmp115_ = sound_device_get_icon_name (_tmp114_);
				_tmp116_ = _tmp115_;
				if (_tmp116_ == NULL) {
					SoundDevice* _tmp117_;
					pa_proplist* _tmp118_;
					const gchar* _tmp119_;
					_tmp117_ = device;
					_tmp118_ = (*card).proplist;
					_tmp119_ = pa_proplist_gets (_tmp118_, PA_PROP_DEVICE_ICON_NAME);
					sound_device_set_icon_name (_tmp117_, _tmp119_);
				}
				_tmp121_ = device;
				_tmp122_ = sound_device_get_icon_name (_tmp121_);
				_tmp123_ = _tmp122_;
				if (_tmp123_ == NULL) {
					SoundDevice* _tmp124_;
					const gchar* _tmp125_;
					const gchar* _tmp126_;
					_tmp124_ = device;
					_tmp125_ = sound_device_get_form_factor (_tmp124_);
					_tmp126_ = _tmp125_;
					_tmp120_ = _tmp126_ != NULL;
				} else {
					_tmp120_ = FALSE;
				}
				if (_tmp120_) {
					SoundDevice* _tmp127_;
					const gchar* _tmp128_;
					const gchar* _tmp129_;
					const gchar* _tmp130_;
					GQuark _tmp132_ = 0U;
					static GQuark _tmp131_label0 = 0;
					static GQuark _tmp131_label1 = 0;
					static GQuark _tmp131_label2 = 0;
					static GQuark _tmp131_label3 = 0;
					static GQuark _tmp131_label4 = 0;
					static GQuark _tmp131_label5 = 0;
					static GQuark _tmp131_label6 = 0;
					static GQuark _tmp131_label7 = 0;
					static GQuark _tmp131_label8 = 0;
					static GQuark _tmp131_label9 = 0;
					static GQuark _tmp131_label10 = 0;
					static GQuark _tmp131_label11 = 0;
					static GQuark _tmp131_label12 = 0;
					_tmp127_ = device;
					_tmp128_ = sound_device_get_form_factor (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = _tmp129_;
					_tmp132_ = (NULL == _tmp130_) ? 0 : g_quark_from_string (_tmp130_);
					if (_tmp132_ == ((0 != _tmp131_label0) ? _tmp131_label0 : (_tmp131_label0 = g_quark_from_static_string ("car")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp133_;
								_tmp133_ = device;
								sound_device_set_icon_name (_tmp133_, "audio-car");
								break;
							}
						}
					} else if ((_tmp132_ == ((0 != _tmp131_label1) ? _tmp131_label1 : (_tmp131_label1 = g_quark_from_static_string ("computer")))) || (_tmp132_ == ((0 != _tmp131_label2) ? _tmp131_label2 : (_tmp131_label2 = g_quark_from_static_string ("internal"))))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp134_;
								_tmp134_ = device;
								sound_device_set_icon_name (_tmp134_, "computer");
								break;
							}
						}
					} else if (_tmp132_ == ((0 != _tmp131_label3) ? _tmp131_label3 : (_tmp131_label3 = g_quark_from_static_string ("handset")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp135_;
								_tmp135_ = device;
								sound_device_set_icon_name (_tmp135_, "phone");
								break;
							}
						}
					} else if (_tmp132_ == ((0 != _tmp131_label4) ? _tmp131_label4 : (_tmp131_label4 = g_quark_from_static_string ("headphone")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp136_;
								_tmp136_ = device;
								sound_device_set_icon_name (_tmp136_, "audio-headphones");
								break;
							}
						}
					} else if ((_tmp132_ == ((0 != _tmp131_label5) ? _tmp131_label5 : (_tmp131_label5 = g_quark_from_static_string ("hands-free")))) || (_tmp132_ == ((0 != _tmp131_label6) ? _tmp131_label6 : (_tmp131_label6 = g_quark_from_static_string ("headset"))))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp137_;
								_tmp137_ = device;
								sound_device_set_icon_name (_tmp137_, "audio-headset");
								break;
							}
						}
					} else if (_tmp132_ == ((0 != _tmp131_label7) ? _tmp131_label7 : (_tmp131_label7 = g_quark_from_static_string ("hifi")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp138_;
								_tmp138_ = device;
								sound_device_set_icon_name (_tmp138_, "audio-subwoofer");
								break;
							}
						}
					} else if (_tmp132_ == ((0 != _tmp131_label8) ? _tmp131_label8 : (_tmp131_label8 = g_quark_from_static_string ("microphone")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp139_;
								_tmp139_ = device;
								sound_device_set_icon_name (_tmp139_, "audio-input-microphone");
								break;
							}
						}
					} else if ((_tmp132_ == ((0 != _tmp131_label9) ? _tmp131_label9 : (_tmp131_label9 = g_quark_from_static_string ("portable")))) || (_tmp132_ == ((0 != _tmp131_label10) ? _tmp131_label10 : (_tmp131_label10 = g_quark_from_static_string ("speaker"))))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp140_;
								_tmp140_ = device;
								sound_device_set_icon_name (_tmp140_, "bluetooth");
								break;
							}
						}
					} else if (_tmp132_ == ((0 != _tmp131_label11) ? _tmp131_label11 : (_tmp131_label11 = g_quark_from_static_string ("tv")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp141_;
								_tmp141_ = device;
								sound_device_set_icon_name (_tmp141_, "video-display-tv");
								break;
							}
						}
					} else if (_tmp132_ == ((0 != _tmp131_label12) ? _tmp131_label12 : (_tmp131_label12 = g_quark_from_static_string ("webcam")))) {
						switch (0) {
							default:
							{
								SoundDevice* _tmp142_;
								_tmp142_ = device;
								sound_device_set_icon_name (_tmp142_, "camera-web");
								break;
							}
						}
					}
				}
				_tmp143_ = device;
				_tmp144_ = sound_device_get_icon_name (_tmp143_);
				_tmp145_ = _tmp144_;
				if (_tmp145_ == NULL) {
					const gchar* _tmp146_ = NULL;
					SoundDevice* _tmp147_;
					if (is_input) {
						_tmp146_ = "audio-input-microphone";
					} else {
						_tmp146_ = "audio-card";
					}
					_tmp147_ = device;
					sound_device_set_icon_name (_tmp147_, _tmp146_);
				}
				if (is_input) {
					SoundDevice* _tmp149_;
					const gchar* _tmp150_;
					const gchar* _tmp151_;
					_tmp149_ = device;
					_tmp150_ = sound_device_get_icon_name (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp148_ = g_str_has_prefix (_tmp151_, "audio-card");
				} else {
					_tmp148_ = FALSE;
				}
				if (_tmp148_) {
					SoundDevice* _tmp152_;
					_tmp152_ = device;
					sound_device_set_icon_name (_tmp152_, "audio-input-microphone");
				}
				_tmp153_ = device;
				_tmp154_ = port;
				_tmp155_ = sound_pulse_audio_manager_get_relevant_card_port_profiles (self, _tmp154_);
				_tmp156_ = _tmp155_;
				sound_device_set_profiles (_tmp153_, _tmp156_);
				_g_object_unref0 (_tmp156_);
				if (sound_pulse_audio_manager_debug_enabled) {
					{
						GeeArrayList* _profile_list = NULL;
						SoundDevice* _tmp157_;
						GeeArrayList* _tmp158_;
						GeeArrayList* _tmp159_;
						gint _profile_size = 0;
						GeeArrayList* _tmp160_;
						gint _tmp161_;
						gint _tmp162_;
						gint _profile_index = 0;
						_tmp157_ = device;
						_tmp158_ = sound_device_get_profiles (_tmp157_);
						_tmp159_ = _tmp158_;
						_profile_list = _tmp159_;
						_tmp160_ = _profile_list;
						_tmp161_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp160_);
						_tmp162_ = _tmp161_;
						_profile_size = _tmp162_;
						_profile_index = -1;
						while (TRUE) {
							gint _tmp163_;
							gint _tmp164_;
							gchar* profile = NULL;
							GeeArrayList* _tmp165_;
							gpointer _tmp166_;
							const gchar* _tmp167_;
							_profile_index = _profile_index + 1;
							_tmp163_ = _profile_index;
							_tmp164_ = _profile_size;
							if (!(_tmp163_ < _tmp164_)) {
								break;
							}
							_tmp165_ = _profile_list;
							_tmp166_ = gee_abstract_list_get ((GeeAbstractList*) _tmp165_, _profile_index);
							profile = (gchar*) _tmp166_;
							_tmp167_ = profile;
							g_debug ("PulseAudioManager.vala:618: \t\t\tprofile: %s", _tmp167_);
							_g_free0 (profile);
						}
					}
				}
				if (is_new) {
					GeeHashMap* _tmp168_;
					const gchar* _tmp169_;
					SoundDevice* _tmp170_;
					SoundDevice* _tmp171_;
					_tmp168_ = devices;
					_tmp169_ = id;
					_tmp170_ = device;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp168_, _tmp169_, _tmp170_);
					_tmp171_ = device;
					g_signal_emit (self, sound_pulse_audio_manager_signals[SOUND_PULSE_AUDIO_MANAGER_NEW_DEVICE_SIGNAL], 0, _tmp171_);
				}
				_g_free0 (card_description);
				_g_free0 (id);
				_g_object_unref0 (device);
				_g_object_unref0 (devices);
			}
		}
	}
	_tmp172_ = self->priv->output_devices;
	_tmp173_ = relevant_ports;
	_tmp173__length1 = relevant_ports_length1;
	_tmp174_ = *card;
	sound_pulse_audio_manager_cleanup_devices (self, _tmp172_, &_tmp174_, _tmp173_, (gint) _tmp173__length1);
	_tmp175_ = self->priv->input_devices;
	_tmp176_ = relevant_ports;
	_tmp176__length1 = relevant_ports_length1;
	_tmp177_ = *card;
	sound_pulse_audio_manager_cleanup_devices (self, _tmp175_, &_tmp177_, _tmp176_, (gint) _tmp176__length1);
	_g_object_unref0 (preferred_device_map);
	_g_variant_unref0 (preferred_devices);
	relevant_ports = (g_free (relevant_ports), NULL);
	_g_free0 (card_active_profile_name);
}

static void
sound_pulse_audio_manager_cleanup_devices (SoundPulseAudioManager* self,
                                           GeeHashMap* devices,
                                           pa_card_info* card,
                                           pa_card_port_info** relevant_ports,
                                           gint relevant_ports_length1)
{
	GeeMapIterator* iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devices != NULL);
	g_return_if_fail (card != NULL);
	_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) devices);
	iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		SoundDevice* device = NULL;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		SoundDevice* _tmp4_;
		guint32 _tmp5_;
		guint32 _tmp6_;
		pa_card_info _tmp7_;
		gboolean found = FALSE;
		_tmp1_ = iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_get_value (_tmp2_);
		device = (SoundDevice*) _tmp3_;
		_tmp4_ = device;
		_tmp5_ = sound_device_get_card_index (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = *card;
		if (_tmp6_ != _tmp7_.index) {
			_g_object_unref0 (device);
			continue;
		}
		found = FALSE;
		{
			pa_card_port_info** port_collection = NULL;
			gint port_collection_length1 = 0;
			gint _port_collection_size_ = 0;
			gint port_it = 0;
			port_collection = relevant_ports;
			port_collection_length1 = relevant_ports_length1;
			for (port_it = 0; port_it < port_collection_length1; port_it = port_it + 1) {
				pa_card_port_info* port = NULL;
				port = port_collection[port_it];
				{
					SoundDevice* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					pa_card_info _tmp11_;
					pa_card_port_info* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gboolean _tmp15_;
					_tmp8_ = device;
					_tmp9_ = sound_device_get_id (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = *card;
					_tmp12_ = port;
					_tmp13_ = sound_pulse_audio_manager_get_device_id (&_tmp11_, _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strcmp0 (_tmp10_, _tmp14_) == 0;
					_g_free0 (_tmp14_);
					if (_tmp15_) {
						found = TRUE;
						break;
					}
				}
			}
		}
		if (!found) {
			SoundDevice* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			SoundDevice* _tmp19_;
			GeeMapIterator* _tmp20_;
			_tmp16_ = device;
			_tmp17_ = sound_device_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			g_debug ("PulseAudioManager.vala:653: \t\tremoving device: %s", _tmp18_);
			_tmp19_ = device;
			g_signal_emit_by_name (_tmp19_, "removed");
			_tmp20_ = iter;
			gee_map_iterator_unset (_tmp20_);
		}
		_g_object_unref0 (device);
	}
	_g_object_unref0 (iter);
}

static gchar*
sound_pulse_audio_manager_get_device_id (pa_card_info* card,
                                         pa_card_port_info* port)
{
	pa_card_info _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (card != NULL, NULL);
	_tmp0_ = *card;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = (*port).name;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat (_tmp2_, ":", _tmp4_, NULL);
	result = _tmp5_;
	return result;
}

static pa_card_profile_info2**
_vala_array_dup1 (pa_card_profile_info2** self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (pa_card_profile_info2*));
	}
	return NULL;
}

static gint
__lambda47_ (SoundPulseAudioManager* self,
             pa_card_profile_info2* a,
             pa_card_profile_info2* b)
{
	gint result;
	if ((*a).priority > (*b).priority) {
		result = -1;
		return result;
	}
	if ((*a).priority < (*b).priority) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gint
___lambda47__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda47_ ((SoundPulseAudioManager*) self, a, b);
	return result;
}

static GeeArrayList*
sound_pulse_audio_manager_get_relevant_card_port_profiles (SoundPulseAudioManager* self,
                                                           pa_card_port_info* port)
{
	GeeArrayList* profiles_list = NULL;
	pa_card_profile_info2** _tmp0_;
	gint _tmp0__length1;
	pa_card_profile_info2** _tmp1_;
	gint _tmp1__length1;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* profiles = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (*port).profiles2;
	_tmp0__length1 = (*port).n_profiles;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = gee_array_list_new_wrap (G_TYPE_POINTER, NULL, NULL, _tmp1_, _tmp1__length1, NULL, NULL, NULL);
	profiles_list = _tmp2_;
	_tmp3_ = profiles_list;
	gee_list_sort ((GeeList*) _tmp3_, ___lambda47__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	profiles = _tmp4_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp5_;
		gint _item_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = profiles_list;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			pa_card_profile_info2* item = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			GeeArrayList* _tmp13_;
			pa_card_profile_info2* _tmp14_;
			const gchar* _tmp15_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
			item = _tmp12_;
			_tmp13_ = profiles;
			_tmp14_ = item;
			_tmp15_ = (*_tmp14_).name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
		}
	}
	result = profiles;
	_g_object_unref0 (profiles_list);
	return result;
}

static void
sound_pulse_audio_manager_remove_devices_by_card (SoundPulseAudioManager* self,
                                                  GeeHashMap* devices,
                                                  guint32 card_index)
{
	GeeMapIterator* iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devices != NULL);
	_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) devices);
	iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		SoundDevice* device = NULL;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		SoundDevice* _tmp4_;
		guint32 _tmp5_;
		guint32 _tmp6_;
		_tmp1_ = iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_get_value (_tmp2_);
		device = (SoundDevice*) _tmp3_;
		_tmp4_ = device;
		_tmp5_ = sound_device_get_card_index (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == card_index) {
			SoundDevice* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			SoundDevice* _tmp10_;
			GeeMapIterator* _tmp11_;
			_tmp7_ = device;
			_tmp8_ = sound_device_get_id (_tmp7_);
			_tmp9_ = _tmp8_;
			g_debug ("PulseAudioManager.vala:694: removing device: %s", _tmp9_);
			_tmp10_ = device;
			g_signal_emit_by_name (_tmp10_, "removed");
			_tmp11_ = iter;
			gee_map_iterator_unset (_tmp11_);
		}
		_g_object_unref0 (device);
	}
	_g_object_unref0 (iter);
}

static void
_sound_pulse_audio_manager_ext_stream_restore_read_sink_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                         pa_ext_stream_restore_info* info,
                                                                                                         gint eol,
                                                                                                         gpointer self)
{
	sound_pulse_audio_manager_ext_stream_restore_read_sink_callback ((SoundPulseAudioManager*) self, c, info, eol);
}

static void
_sound_pulse_audio_manager_ext_stream_restore_read_source_callback_pulse_audio_ext_stream_restore_read_cb (pa_context* c,
                                                                                                           pa_ext_stream_restore_info* info,
                                                                                                           gint eol,
                                                                                                           gpointer self)
{
	sound_pulse_audio_manager_ext_stream_restore_read_source_callback ((SoundPulseAudioManager*) self, c, info, eol);
}

static void
sound_pulse_audio_manager_server_info_callback (SoundPulseAudioManager* self,
                                                pa_context* context,
                                                pa_server_info* server)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp12_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	pa_operation* _tmp24_;
	pa_operation* _tmp25_;
	pa_operation* _tmp26_;
	pa_operation* _tmp27_;
	pa_operation* _tmp28_;
	pa_operation* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_debug ("PulseAudioManager.vala:702: server info update");
	if (server == NULL) {
		return;
	}
	_tmp0_ = self->priv->default_sink_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = (*server).default_sink_name;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->default_sink_name);
		self->priv->default_sink_name = _tmp2_;
		_tmp3_ = self->priv->default_sink_name;
		g_debug ("PulseAudioManager.vala:709: \tdefault_sink_name: %s", _tmp3_);
	}
	_tmp4_ = self->priv->default_sink_name;
	_tmp5_ = (*server).default_sink_name;
	if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		pa_operation* _tmp10_;
		pa_operation* _tmp11_;
		_tmp6_ = self->priv->default_sink_name;
		_tmp7_ = (*server).default_sink_name;
		g_debug ("PulseAudioManager.vala:713: \tdefault_sink_name: %s > %s", _tmp6_, _tmp7_);
		_tmp8_ = (*server).default_sink_name;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->default_sink_name);
		self->priv->default_sink_name = _tmp9_;
		_tmp10_ = pa_ext_stream_restore_read (context, _sound_pulse_audio_manager_ext_stream_restore_read_sink_callback_pulse_audio_ext_stream_restore_read_cb, self);
		_tmp11_ = _tmp10_;
		_pa_operation_unref0 (_tmp11_);
	}
	_tmp12_ = self->priv->default_source_name;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = (*server).default_source_name;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (self->priv->default_source_name);
		self->priv->default_source_name = _tmp14_;
		_tmp15_ = self->priv->default_source_name;
		g_debug ("PulseAudioManager.vala:720: \tdefault_source_name: %s", _tmp15_);
	}
	_tmp16_ = self->priv->default_source_name;
	_tmp17_ = (*server).default_source_name;
	if (g_strcmp0 (_tmp16_, _tmp17_) != 0) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		pa_operation* _tmp22_;
		pa_operation* _tmp23_;
		_tmp18_ = self->priv->default_source_name;
		_tmp19_ = (*server).default_source_name;
		g_debug ("PulseAudioManager.vala:724: \tdefault_source_name: %s > %s", _tmp18_, _tmp19_);
		_tmp20_ = (*server).default_source_name;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (self->priv->default_source_name);
		self->priv->default_source_name = _tmp21_;
		_tmp22_ = pa_ext_stream_restore_read (context, _sound_pulse_audio_manager_ext_stream_restore_read_source_callback_pulse_audio_ext_stream_restore_read_cb, self);
		_tmp23_ = _tmp22_;
		_pa_operation_unref0 (_tmp23_);
	}
	_tmp24_ = pa_context_get_card_info_list (context, _sound_pulse_audio_manager_card_info_callback_pa_card_info_cb_t, self);
	_tmp25_ = _tmp24_;
	_pa_operation_unref0 (_tmp25_);
	_tmp26_ = pa_context_get_source_info_list (context, _sound_pulse_audio_manager_source_info_callback_pa_source_info_cb_t, self);
	_tmp27_ = _tmp26_;
	_pa_operation_unref0 (_tmp27_);
	_tmp28_ = pa_context_get_sink_info_list (context, _sound_pulse_audio_manager_sink_info_callback_pa_sink_info_cb_t, self);
	_tmp29_ = _tmp28_;
	_pa_operation_unref0 (_tmp29_);
}

static void
__lambda46_ (SoundPulseAudioManager* self,
             pa_context* c,
             gint success)
{
	g_return_if_fail (c != NULL);
	if (success != 1) {
		g_warning ("PulseAudioManager.vala:756: Updating source failed");
	}
}

static void
___lambda46__pa_context_success_cb_t (pa_context* c,
                                      gint success,
                                      gpointer self)
{
	__lambda46_ ((SoundPulseAudioManager*) self, c, success);
}

static void
sound_pulse_audio_manager_ext_stream_restore_read_sink_callback (SoundPulseAudioManager* self,
                                                                 pa_context* c,
                                                                 pa_ext_stream_restore_info* info,
                                                                 gint eol)
{
	gboolean _tmp0_ = FALSE;
	pa_ext_stream_restore_info new_info = {0};
	const gchar* _tmp2_;
	pa_channel_map _tmp3_;
	pa_cvolume _tmp4_;
	const gchar* _tmp5_;
	pa_ext_stream_restore_info _tmp6_;
	pa_ext_stream_restore_info* _tmp7_;
	pa_ext_stream_restore_info* _tmp8_;
	gint _tmp8__length1;
	pa_operation* _tmp9_;
	pa_operation* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (eol != 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = (*info).name;
		_tmp0_ = !g_str_has_prefix (_tmp1_, "sink-input-by");
	}
	if (_tmp0_) {
		return;
	}
	memset (&new_info, 0, sizeof (pa_ext_stream_restore_info));
	_tmp2_ = (*info).name;
	new_info.name = _tmp2_;
	_tmp3_ = (*info).channel_map;
	new_info.channel_map = _tmp3_;
	_tmp4_ = (*info).volume;
	new_info.volume = _tmp4_;
	new_info.mute = (*info).mute;
	_tmp5_ = self->priv->default_sink_name;
	new_info.device = _tmp5_;
	_tmp6_ = new_info;
	_tmp7_ = g_new0 (pa_ext_stream_restore_info, 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = pa_ext_stream_restore_write (c, PA_UPDATE_REPLACE, _tmp8_, (gint) 1, 1, ___lambda46__pa_context_success_cb_t, self);
	_tmp10_ = _tmp9_;
	_pa_operation_unref0 (_tmp10_);
	_tmp8_ = (g_free (_tmp8_), NULL);
}

static void
sound_pulse_audio_manager_ext_stream_restore_read_source_callback (SoundPulseAudioManager* self,
                                                                   pa_context* c,
                                                                   pa_ext_stream_restore_info* info,
                                                                   gint eol)
{
	gboolean _tmp0_ = FALSE;
	pa_ext_stream_restore_info new_info = {0};
	const gchar* _tmp2_;
	pa_channel_map _tmp3_;
	pa_cvolume _tmp4_;
	const gchar* _tmp5_;
	pa_ext_stream_restore_info _tmp6_;
	pa_ext_stream_restore_info* _tmp7_;
	pa_ext_stream_restore_info* _tmp8_;
	gint _tmp8__length1;
	pa_operation* _tmp9_;
	pa_operation* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	if (eol != 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = (*info).name;
		_tmp0_ = !g_str_has_prefix (_tmp1_, "source-output-by");
	}
	if (_tmp0_) {
		return;
	}
	memset (&new_info, 0, sizeof (pa_ext_stream_restore_info));
	_tmp2_ = (*info).name;
	new_info.name = _tmp2_;
	_tmp3_ = (*info).channel_map;
	new_info.channel_map = _tmp3_;
	_tmp4_ = (*info).volume;
	new_info.volume = _tmp4_;
	new_info.mute = (*info).mute;
	_tmp5_ = self->priv->default_source_name;
	new_info.device = _tmp5_;
	_tmp6_ = new_info;
	_tmp7_ = g_new0 (pa_ext_stream_restore_info, 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = pa_ext_stream_restore_write (c, PA_UPDATE_REPLACE, _tmp8_, (gint) 1, 1, NULL, NULL);
	_tmp10_ = _tmp9_;
	_pa_operation_unref0 (_tmp10_);
	_tmp8_ = (g_free (_tmp8_), NULL);
}

SoundDevice*
sound_pulse_audio_manager_get_default_output (SoundPulseAudioManager* self)
{
	SoundDevice* result;
	SoundDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_output;
	result = _tmp0_;
	return result;
}

static void
sound_pulse_audio_manager_set_default_output (SoundPulseAudioManager* self,
                                              SoundDevice* value)
{
	SoundDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_pulse_audio_manager_get_default_output (self);
	if (old_value != value) {
		SoundDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_output);
		self->priv->_default_output = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY]);
	}
}

SoundDevice*
sound_pulse_audio_manager_get_default_input (SoundPulseAudioManager* self)
{
	SoundDevice* result;
	SoundDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_input;
	result = _tmp0_;
	return result;
}

static void
sound_pulse_audio_manager_set_default_input (SoundPulseAudioManager* self,
                                             SoundDevice* value)
{
	SoundDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_pulse_audio_manager_get_default_input (self);
	if (old_value != value) {
		SoundDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_input);
		self->priv->_default_input = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY]);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static GObject *
sound_pulse_audio_manager_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundPulseAudioManager * self;
	pa_glib_mainloop* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gchar* messages_debug_raw = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	parent_class = G_OBJECT_CLASS (sound_pulse_audio_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	_tmp0_ = pa_glib_mainloop_new (NULL);
	_pa_glib_mainloop_free0 (self->priv->loop);
	self->priv->loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SOUND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->input_devices);
	self->priv->input_devices = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SOUND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->output_devices);
	self->priv->output_devices = _tmp2_;
	_tmp3_ = g_getenv ("G_MESSAGES_DEBUG");
	_tmp4_ = g_strdup (_tmp3_);
	messages_debug_raw = _tmp4_;
	_tmp5_ = messages_debug_raw;
	if (_tmp5_ != NULL) {
		gchar** messages_debug = NULL;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint messages_debug_length1;
		gint _messages_debug_size_;
		gboolean _tmp9_ = FALSE;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp6_ = messages_debug_raw;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
		messages_debug = _tmp8_;
		messages_debug_length1 = _vala_array_length (_tmp7_);
		_messages_debug_size_ = messages_debug_length1;
		_tmp10_ = messages_debug;
		_tmp10__length1 = messages_debug_length1;
		if (_vala_string_array_contains (_tmp10_, _tmp10__length1, "all")) {
			_tmp9_ = TRUE;
		} else {
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = messages_debug;
			_tmp11__length1 = messages_debug_length1;
			_tmp9_ = _vala_string_array_contains (_tmp11_, _tmp11__length1, "debug");
		}
		sound_pulse_audio_manager_debug_enabled = _tmp9_;
		messages_debug = (_vala_array_free (messages_debug, messages_debug_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (messages_debug_raw);
	return obj;
}

static void
sound_pulse_audio_manager_class_init (SoundPulseAudioManagerClass * klass,
                                      gpointer klass_data)
{
	sound_pulse_audio_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundPulseAudioManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_pulse_audio_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_pulse_audio_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_pulse_audio_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_pulse_audio_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY] = g_param_spec_object ("default-output", "default-output", "default-output", SOUND_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY, sound_pulse_audio_manager_properties[SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY] = g_param_spec_object ("default-input", "default-input", "default-input", SOUND_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	sound_pulse_audio_manager_signals[SOUND_PULSE_AUDIO_MANAGER_NEW_DEVICE_SIGNAL] = g_signal_new ("new-device", SOUND_TYPE_PULSE_AUDIO_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUND_TYPE_DEVICE);
}

static void
sound_pulse_audio_manager_instance_init (SoundPulseAudioManager * self,
                                         gpointer klass)
{
	self->priv = sound_pulse_audio_manager_get_instance_private (self);
	self->priv->is_ready = FALSE;
	self->priv->reconnect_timer_id = 0U;
}

static void
sound_pulse_audio_manager_finalize (GObject * obj)
{
	SoundPulseAudioManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	_pa_context_unref0 (self->priv->context);
	_pa_glib_mainloop_free0 (self->priv->loop);
	_g_object_unref0 (self->priv->input_devices);
	_g_object_unref0 (self->priv->output_devices);
	_g_object_unref0 (self->priv->_default_output);
	_g_object_unref0 (self->priv->_default_input);
	_g_free0 (self->priv->default_source_name);
	_g_free0 (self->priv->default_sink_name);
	G_OBJECT_CLASS (sound_pulse_audio_manager_parent_class)->finalize (obj);
}

static GType
sound_pulse_audio_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundPulseAudioManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_pulse_audio_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundPulseAudioManager), 0, (GInstanceInitFunc) sound_pulse_audio_manager_instance_init, NULL };
	GType sound_pulse_audio_manager_type_id;
	sound_pulse_audio_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SoundPulseAudioManager", &g_define_type_info, 0);
	SoundPulseAudioManager_private_offset = g_type_add_instance_private (sound_pulse_audio_manager_type_id, sizeof (SoundPulseAudioManagerPrivate));
	return sound_pulse_audio_manager_type_id;
}

GType
sound_pulse_audio_manager_get_type (void)
{
	static volatile gsize sound_pulse_audio_manager_type_id__once = 0;
	if (g_once_init_enter (&sound_pulse_audio_manager_type_id__once)) {
		GType sound_pulse_audio_manager_type_id;
		sound_pulse_audio_manager_type_id = sound_pulse_audio_manager_get_type_once ();
		g_once_init_leave (&sound_pulse_audio_manager_type_id__once, sound_pulse_audio_manager_type_id);
	}
	return sound_pulse_audio_manager_type_id__once;
}

static void
_vala_sound_pulse_audio_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SoundPulseAudioManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	switch (property_id) {
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY:
		g_value_set_object (value, sound_pulse_audio_manager_get_default_output (self));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY:
		g_value_set_object (value, sound_pulse_audio_manager_get_default_input (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_pulse_audio_manager_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SoundPulseAudioManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager);
	switch (property_id) {
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_OUTPUT_PROPERTY:
		sound_pulse_audio_manager_set_default_output (self, g_value_get_object (value));
		break;
		case SOUND_PULSE_AUDIO_MANAGER_DEFAULT_INPUT_PROPERTY:
		sound_pulse_audio_manager_set_default_input (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

