/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// PhotonPersistentDiskVolumeSourceApplyConfiguration represents a declarative configuration of the PhotonPersistentDiskVolumeSource type for use
// with apply.
//
// Represents a Photon Controller persistent disk resource.
type PhotonPersistentDiskVolumeSourceApplyConfiguration struct {
	// pdID is the ID that identifies Photon Controller persistent disk
	PdID *string `json:"pdID,omitempty"`
	// fsType is the filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	FSType *string `json:"fsType,omitempty"`
}

// PhotonPersistentDiskVolumeSourceApplyConfiguration constructs a declarative configuration of the PhotonPersistentDiskVolumeSource type for use with
// apply.
func PhotonPersistentDiskVolumeSource() *PhotonPersistentDiskVolumeSourceApplyConfiguration {
	return &PhotonPersistentDiskVolumeSourceApplyConfiguration{}
}

// WithPdID sets the PdID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PdID field is set to the value of the last call.
func (b *PhotonPersistentDiskVolumeSourceApplyConfiguration) WithPdID(value string) *PhotonPersistentDiskVolumeSourceApplyConfiguration {
	b.PdID = &value
	return b
}

// WithFSType sets the FSType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FSType field is set to the value of the last call.
func (b *PhotonPersistentDiskVolumeSourceApplyConfiguration) WithFSType(value string) *PhotonPersistentDiskVolumeSourceApplyConfiguration {
	b.FSType = &value
	return b
}
