// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	applyconfigurationmonitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1"
	v1 "k8s.io/api/core/v1"
)

// OpenStackSDConfigApplyConfiguration represents a declarative configuration of the OpenStackSDConfig type for use
// with apply.
type OpenStackSDConfigApplyConfiguration struct {
	Role                        *monitoringv1alpha1.OpenStackRole                               `json:"role,omitempty"`
	Region                      *string                                                         `json:"region,omitempty"`
	IdentityEndpoint            *string                                                         `json:"identityEndpoint,omitempty"`
	Username                    *string                                                         `json:"username,omitempty"`
	UserID                      *string                                                         `json:"userid,omitempty"`
	Password                    *v1.SecretKeySelector                                           `json:"password,omitempty"`
	DomainName                  *string                                                         `json:"domainName,omitempty"`
	DomainID                    *string                                                         `json:"domainID,omitempty"`
	ProjectName                 *string                                                         `json:"projectName,omitempty"`
	ProjectID                   *string                                                         `json:"projectID,omitempty"`
	ApplicationCredentialName   *string                                                         `json:"applicationCredentialName,omitempty"`
	ApplicationCredentialID     *string                                                         `json:"applicationCredentialId,omitempty"`
	ApplicationCredentialSecret *v1.SecretKeySelector                                           `json:"applicationCredentialSecret,omitempty"`
	AllTenants                  *bool                                                           `json:"allTenants,omitempty"`
	RefreshInterval             *monitoringv1.Duration                                          `json:"refreshInterval,omitempty"`
	Port                        *int32                                                          `json:"port,omitempty"`
	Availability                *string                                                         `json:"availability,omitempty"`
	TLSConfig                   *applyconfigurationmonitoringv1.SafeTLSConfigApplyConfiguration `json:"tlsConfig,omitempty"`
}

// OpenStackSDConfigApplyConfiguration constructs a declarative configuration of the OpenStackSDConfig type for use with
// apply.
func OpenStackSDConfig() *OpenStackSDConfigApplyConfiguration {
	return &OpenStackSDConfigApplyConfiguration{}
}

// WithRole sets the Role field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Role field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithRole(value monitoringv1alpha1.OpenStackRole) *OpenStackSDConfigApplyConfiguration {
	b.Role = &value
	return b
}

// WithRegion sets the Region field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Region field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithRegion(value string) *OpenStackSDConfigApplyConfiguration {
	b.Region = &value
	return b
}

// WithIdentityEndpoint sets the IdentityEndpoint field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IdentityEndpoint field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithIdentityEndpoint(value string) *OpenStackSDConfigApplyConfiguration {
	b.IdentityEndpoint = &value
	return b
}

// WithUsername sets the Username field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Username field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithUsername(value string) *OpenStackSDConfigApplyConfiguration {
	b.Username = &value
	return b
}

// WithUserID sets the UserID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UserID field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithUserID(value string) *OpenStackSDConfigApplyConfiguration {
	b.UserID = &value
	return b
}

// WithPassword sets the Password field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Password field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithPassword(value v1.SecretKeySelector) *OpenStackSDConfigApplyConfiguration {
	b.Password = &value
	return b
}

// WithDomainName sets the DomainName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DomainName field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithDomainName(value string) *OpenStackSDConfigApplyConfiguration {
	b.DomainName = &value
	return b
}

// WithDomainID sets the DomainID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DomainID field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithDomainID(value string) *OpenStackSDConfigApplyConfiguration {
	b.DomainID = &value
	return b
}

// WithProjectName sets the ProjectName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProjectName field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithProjectName(value string) *OpenStackSDConfigApplyConfiguration {
	b.ProjectName = &value
	return b
}

// WithProjectID sets the ProjectID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProjectID field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithProjectID(value string) *OpenStackSDConfigApplyConfiguration {
	b.ProjectID = &value
	return b
}

// WithApplicationCredentialName sets the ApplicationCredentialName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplicationCredentialName field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithApplicationCredentialName(value string) *OpenStackSDConfigApplyConfiguration {
	b.ApplicationCredentialName = &value
	return b
}

// WithApplicationCredentialID sets the ApplicationCredentialID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplicationCredentialID field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithApplicationCredentialID(value string) *OpenStackSDConfigApplyConfiguration {
	b.ApplicationCredentialID = &value
	return b
}

// WithApplicationCredentialSecret sets the ApplicationCredentialSecret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplicationCredentialSecret field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithApplicationCredentialSecret(value v1.SecretKeySelector) *OpenStackSDConfigApplyConfiguration {
	b.ApplicationCredentialSecret = &value
	return b
}

// WithAllTenants sets the AllTenants field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllTenants field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithAllTenants(value bool) *OpenStackSDConfigApplyConfiguration {
	b.AllTenants = &value
	return b
}

// WithRefreshInterval sets the RefreshInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RefreshInterval field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithRefreshInterval(value monitoringv1.Duration) *OpenStackSDConfigApplyConfiguration {
	b.RefreshInterval = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithPort(value int32) *OpenStackSDConfigApplyConfiguration {
	b.Port = &value
	return b
}

// WithAvailability sets the Availability field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Availability field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithAvailability(value string) *OpenStackSDConfigApplyConfiguration {
	b.Availability = &value
	return b
}

// WithTLSConfig sets the TLSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLSConfig field is set to the value of the last call.
func (b *OpenStackSDConfigApplyConfiguration) WithTLSConfig(value *applyconfigurationmonitoringv1.SafeTLSConfigApplyConfiguration) *OpenStackSDConfigApplyConfiguration {
	b.TLSConfig = value
	return b
}
