// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportResponse represents the response for gRPC/HTTP client/server.
type ExportLogsServiceResponse struct {
	PartialSuccess ExportLogsPartialSuccess
}

var (
	protoPoolExportLogsServiceResponse = sync.Pool{
		New: func() any {
			return &ExportLogsServiceResponse{}
		},
	}
)

func NewExportLogsServiceResponse() *ExportLogsServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &ExportLogsServiceResponse{}
	}
	return protoPoolExportLogsServiceResponse.Get().(*ExportLogsServiceResponse)
}

func DeleteExportLogsServiceResponse(orig *ExportLogsServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteExportLogsPartialSuccess(&orig.PartialSuccess, false)
	orig.Reset()
	if nullable {
		protoPoolExportLogsServiceResponse.Put(orig)
	}
}

func CopyExportLogsServiceResponse(dest, src *ExportLogsServiceResponse) *ExportLogsServiceResponse {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportLogsServiceResponse()
	}
	CopyExportLogsPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)

	return dest
}

func CopyExportLogsServiceResponseSlice(dest, src []ExportLogsServiceResponse) []ExportLogsServiceResponse {
	var newDest []ExportLogsServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]ExportLogsServiceResponse, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportLogsServiceResponse(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportLogsServiceResponse(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportLogsServiceResponsePtrSlice(dest, src []*ExportLogsServiceResponse) []*ExportLogsServiceResponse {
	var newDest []*ExportLogsServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]*ExportLogsServiceResponse, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportLogsServiceResponse()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportLogsServiceResponse(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportLogsServiceResponse()
		}
	}
	for i := range src {
		CopyExportLogsServiceResponse(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportLogsServiceResponse) Reset() {
	*orig = ExportLogsServiceResponse{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportLogsServiceResponse) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	orig.PartialSuccess.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportLogsServiceResponse) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":

			orig.PartialSuccess.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportLogsServiceResponse) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.PartialSuccess.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *ExportLogsServiceResponse) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.PartialSuccess.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func (orig *ExportLogsServiceResponse) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.PartialSuccess.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportLogsServiceResponse() *ExportLogsServiceResponse {
	orig := NewExportLogsServiceResponse()
	orig.PartialSuccess = *GenTestExportLogsPartialSuccess()
	return orig
}

func GenTestExportLogsServiceResponsePtrSlice() []*ExportLogsServiceResponse {
	orig := make([]*ExportLogsServiceResponse, 5)
	orig[0] = NewExportLogsServiceResponse()
	orig[1] = GenTestExportLogsServiceResponse()
	orig[2] = NewExportLogsServiceResponse()
	orig[3] = GenTestExportLogsServiceResponse()
	orig[4] = NewExportLogsServiceResponse()
	return orig
}

func GenTestExportLogsServiceResponseSlice() []ExportLogsServiceResponse {
	orig := make([]ExportLogsServiceResponse, 5)
	orig[1] = *GenTestExportLogsServiceResponse()
	orig[3] = *GenTestExportLogsServiceResponse()
	return orig
}
