// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportPartialSuccess represents the details of a partially successful export request.
type ExportMetricsPartialSuccess struct {
	ErrorMessage       string
	RejectedDataPoints int64
}

var (
	protoPoolExportMetricsPartialSuccess = sync.Pool{
		New: func() any {
			return &ExportMetricsPartialSuccess{}
		},
	}
)

func NewExportMetricsPartialSuccess() *ExportMetricsPartialSuccess {
	if !UseProtoPooling.IsEnabled() {
		return &ExportMetricsPartialSuccess{}
	}
	return protoPoolExportMetricsPartialSuccess.Get().(*ExportMetricsPartialSuccess)
}

func DeleteExportMetricsPartialSuccess(orig *ExportMetricsPartialSuccess, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExportMetricsPartialSuccess.Put(orig)
	}
}

func CopyExportMetricsPartialSuccess(dest, src *ExportMetricsPartialSuccess) *ExportMetricsPartialSuccess {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportMetricsPartialSuccess()
	}
	dest.RejectedDataPoints = src.RejectedDataPoints
	dest.ErrorMessage = src.ErrorMessage

	return dest
}

func CopyExportMetricsPartialSuccessSlice(dest, src []ExportMetricsPartialSuccess) []ExportMetricsPartialSuccess {
	var newDest []ExportMetricsPartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]ExportMetricsPartialSuccess, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportMetricsPartialSuccess(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportMetricsPartialSuccess(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportMetricsPartialSuccessPtrSlice(dest, src []*ExportMetricsPartialSuccess) []*ExportMetricsPartialSuccess {
	var newDest []*ExportMetricsPartialSuccess
	if cap(dest) < len(src) {
		newDest = make([]*ExportMetricsPartialSuccess, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportMetricsPartialSuccess()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportMetricsPartialSuccess(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportMetricsPartialSuccess()
		}
	}
	for i := range src {
		CopyExportMetricsPartialSuccess(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportMetricsPartialSuccess) Reset() {
	*orig = ExportMetricsPartialSuccess{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportMetricsPartialSuccess) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedDataPoints != int64(0) {
		dest.WriteObjectField("rejectedDataPoints")
		dest.WriteInt64(orig.RejectedDataPoints)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportMetricsPartialSuccess) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "rejectedDataPoints", "rejected_data_points":
			orig.RejectedDataPoints = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportMetricsPartialSuccess) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RejectedDataPoints != int64(0) {
		n += 1 + proto.Sov(uint64(orig.RejectedDataPoints))
	}

	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ExportMetricsPartialSuccess) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedDataPoints != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedDataPoints))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *ExportMetricsPartialSuccess) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedDataPoints", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.RejectedDataPoints = int64(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ErrorMessage = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportMetricsPartialSuccess() *ExportMetricsPartialSuccess {
	orig := NewExportMetricsPartialSuccess()
	orig.RejectedDataPoints = int64(13)
	orig.ErrorMessage = "test_errormessage"
	return orig
}

func GenTestExportMetricsPartialSuccessPtrSlice() []*ExportMetricsPartialSuccess {
	orig := make([]*ExportMetricsPartialSuccess, 5)
	orig[0] = NewExportMetricsPartialSuccess()
	orig[1] = GenTestExportMetricsPartialSuccess()
	orig[2] = NewExportMetricsPartialSuccess()
	orig[3] = GenTestExportMetricsPartialSuccess()
	orig[4] = NewExportMetricsPartialSuccess()
	return orig
}

func GenTestExportMetricsPartialSuccessSlice() []ExportMetricsPartialSuccess {
	orig := make([]ExportMetricsPartialSuccess, 5)
	orig[1] = *GenTestExportMetricsPartialSuccess()
	orig[3] = *GenTestExportMetricsPartialSuccess()
	return orig
}
